﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class PrivacyController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        public PrivacyController(IRequestRepository requestRepository, ILicensing licensing,IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
        }

        [HttpPost]
        [ActionName("SetPrivacyAsRead")]
        public JsonResult SetPrivacyAsRead()
        {
            try
            {
                GlobalErrors result = PrivacyService.SetPrivacyReadDate(_requestRepository.CurrentOperator.EmployeeId);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon();
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("CheckPrivacyPolicy")]
        public JsonResult CheckPrivacyPolicy([FromBody] int empId)
        {
            try
            {
                GlobalErrors result = GlobalErrors.Success;
                bool showPrivacy = false;
                string privacyText = string.Empty;
                if (_requestRepository.Configurations.ShowPrivacyPolicy)
                {
                    //check the Privacy policy
                    result = PrivacyService.CheckPrivacyPolicy(empId, ref showPrivacy);
                    if (result == GlobalErrors.Success && showPrivacy)
                    {
                        if (showPrivacy)
                        {
                            if (_requestRepository.LanguageId == 2)
                            {
                                privacyText = PrivacyModel.PrivacyAr;
                            }
                            else
                            {
                                privacyText = PrivacyModel.PrivacyEn;
                            }
                        }
                    }
                }
                var data = new
                {
                    showPrivacy = showPrivacy,
                    privacyText = privacyText
                };
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
    }
}
