﻿using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using System.Linq;
using System.Reflection;
using Microsoft.AspNetCore.Authorization;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Licensing.Licensing;
using System.IO;
using System.Collections.ObjectModel;
using Microsoft.AspNetCore.Http;
using Sonic.Web.Service;
using Microsoft.AspNetCore.Hosting;
using Sonic.Web.Model;
using Microsoft.AspNetCore.SignalR;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class PromotionController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly PricesAndOffersService _pricesAndOffersService;
        private readonly CustomerService _customerService;
        private IHostingEnvironment _hostingEnvironment;
        public PromotionController(IHubContext<NotifyHub, ITypedHubClient> hubContext, IHostingEnvironment hostingEnvironment, IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _hostingEnvironment = hostingEnvironment;
            _pricesAndOffersService = new PricesAndOffersService(hubContext,requestRepository, hostingEnvironment);
            _customerService = new CustomerService(requestRepository);
        }

        #region GET
        [HttpPost]
        [ActionName("GetPromotionsListSharedTable")]
        public JsonResult GetPromotionsListSharedTable([FromBody] PromotionFilterModel promotionFilter)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                //PromotionFilterModel promotionFilter = JsonConvert.DeserializeObject<PromotionFilterModel>(filter);
                SharedTableResult<Promotion> promotionsSahredList = null;
                if (promotionFilter != null)
                {
                    promotionsSahredList = new SharedTableResult<Promotion>();
                    result = _pricesAndOffersService.GetPromotionsListSharedTable(promotionFilter, ref promotionsSahredList);
                }

                if (result == GlobalErrors.Success)
                {
                    if (promotionsSahredList != null && promotionsSahredList.Data != null && promotionsSahredList.Data.ToList().Count > 0)
                    {
                        return JSonResultResponse.GetSuccessrJSon(promotionsSahredList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(promotionsSahredList, ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetPromotionData")]
        public JsonResult GetPromotionData([FromBody] Promotion promotion)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                if (promotion.PromotionId != -1)
                {
                    Promotion selectedPromotion = new Promotion();
                    selectedPromotion.PromotionId = promotion.PromotionId;
                    GlobalErrors result = _pricesAndOffersService.GetPromotionData(promotion.PromotionId, promotion.IsClone, ref selectedPromotion);
                    if (result == GlobalErrors.Success)
                    {
                        List<string> imagesNames = new List<string>();
                        List<string> attachementNames = new List<string>();
                        FileManagerModel model = new FileManagerModel();
                        string folderName = Path.Combine("Resources\\promotions-img\\", selectedPromotion.PromotionId.ToString());
                        string rootPath = _hostingEnvironment.ContentRootPath;
                        var userImagesPath = Path.Combine(rootPath, folderName);
                        DirectoryInfo dir = new DirectoryInfo(userImagesPath);
                        if (dir.Exists)
                        {
                            FileInfo[] files = dir.GetFiles();
                            model.Files = files;
                            if (files != null && files.Length > 0)
                            {
                                foreach (FileInfo file in files)
                                {
                                    imagesNames.Add(file.Name);
                                }
                            }
                        }
                        if (imagesNames != null && imagesNames.Count > 0)
                        {
                            selectedPromotion.ImageList = imagesNames;
                        }
                        // For Attachements :
                        folderName = Path.Combine("Resources\\attachements\\promotions", selectedPromotion.PromotionId.ToString());
                        var userAttachementPath = Path.Combine(rootPath, folderName);
                        DirectoryInfo Attachementdir = new DirectoryInfo(userAttachementPath);
                        if (Attachementdir.Exists)
                        {
                            FileInfo[] files = Attachementdir.GetFiles();
                            model.Files = files;
                            if (files != null && files.Length > 0)
                            {
                                foreach (FileInfo file in files)
                                {
                                    attachementNames.Add(file.Name);
                                }
                            }
                        }
                        if (attachementNames != null && attachementNames.Count > 0)
                        {
                            selectedPromotion.AttachedFiles = attachementNames;
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        return JSonResultResponse.GetSuccessrJSon(selectedPromotion, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("IsValidToEditTargetPromotion")]
        public JsonResult IsValidToEditTargetPromotion([FromBody] Promotion promotion)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                bool isValidToEditOrDelete = true;
                List<CustomerOutletModel> customerList = new List<CustomerOutletModel>();
                result = _pricesAndOffersService.IsValidToEditTargetPromotion(promotion.PromotionId, promotion.RelatedToTarget, ref isValidToEditOrDelete, ref customerList);
                var data = new
                {
                    isValidToEditOrDelete = isValidToEditOrDelete,
                    achievementCustomerList = customerList,
                };
                if (result == GlobalErrors.Success)
                {
                    if (isValidToEditOrDelete)
                    {
                        return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Cannot_Edit_Or_Delete_Promoted_Target_Promotion, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetPromotionReasonList")]
        public JsonResult GetPromotionReasonList()
        {
            try
            {
                List<PromotionReasonModel> promotionReasonList = new List<PromotionReasonModel>();

                GlobalErrors result = _pricesAndOffersService.GetPromotionReasonList(ref promotionReasonList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(promotionReasonList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetAchievementTypesForTargetPromotions")]
        public JsonResult GetAchievementTypesForTargetPromotions()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<AchievementTypeModel> achievementList = new List<AchievementTypeModel>();
                result = _pricesAndOffersService.GetAchievementTypesForTargetPromotions(ref achievementList);

                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(achievementList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("CheckAllowEditPromotionByOrgAccess")]
        public JsonResult CheckAllowEditPromotionByOrgAccess([FromBody]int createdBy)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                bool isValid = false;
                result = _pricesAndOffersService.CheckAllowEditPromotionByOrgAccess(createdBy, ref isValid);

                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(isValid, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region INSERT
        [HttpPost]
        [ActionName("InsertPromotion")]
        public JsonResult InsertPromotion([FromForm] Collection<IFormFile> imagesList, Collection<IFormFile> attachedFiles, [FromForm] string promotionString)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                Promotion promotion = JsonConvert.DeserializeObject<Promotion>(promotionString);
                if (promotion != null)
                {
                    promotion.StartDate = new DateTime(promotion.StartDateModel.Year, promotion.StartDateModel.Month, promotion.StartDateModel.Day);
                    promotion.EndDate = new DateTime(promotion.EndDateModel.Year, promotion.EndDateModel.Month, promotion.EndDateModel.Day);

                    GlobalErrors result = _pricesAndOffersService.SavePromotion(promotion, Request.Form.Files);
                    if (result == GlobalErrors.Success)
                    {
                        #region[save Photos]
                        bool createNewDirectory = imagesList != null && imagesList.Count > 0;
                        // Create Directory in Sonic 
                        string rootPath = _hostingEnvironment.ContentRootPath;
                        string folderName = "Resources\\promotions-img\\";
                        string thisPromotionName = Path.Combine(folderName, promotion.PromotionId.ToString());
                        string oldPromotionName = Path.Combine(folderName, promotion.OldPromotionId.ToString());
                        string fullPathSonic = Path.Combine(rootPath, thisPromotionName);
                        string oldFullPathSonic = Path.Combine(rootPath, oldPromotionName);
                        // Delete old promotionId from sonic
                        if (Directory.Exists(oldFullPathSonic))
                        {
                            Directory.Delete(oldFullPathSonic, true);
                        }
                        // Delete old save from sonic
                        if (Directory.Exists(fullPathSonic))
                        {
                            Directory.Delete(fullPathSonic, true);
                        }
                        if (createNewDirectory && !Directory.Exists(fullPathSonic))
                        {
                            Directory.CreateDirectory(fullPathSonic);
                        }

                        // Create Directory in ECHO
                        rootPath = string.Format(@"{0}", LocalUtilities.CustomerAppServicePath);
                        folderName = "wwwroot\\img\\Echo\\promotions";
                        thisPromotionName = Path.Combine(folderName, promotion.PromotionId.ToString());
                        oldPromotionName = Path.Combine(folderName, promotion.OldPromotionId.ToString());
                        string fullPathEcho = Path.Combine(rootPath, thisPromotionName);
                        string oldFullPathEcho = Path.Combine(rootPath, oldPromotionName);
                        // Delete old promotion id from echo
                        if (Directory.Exists(oldFullPathEcho))
                        {
                            Directory.Delete(oldFullPathEcho, true);
                        }
                        // Delete old saved from echo
                        if (Directory.Exists(fullPathEcho))
                        {
                            Directory.Delete(fullPathEcho, true);
                        }
                        if (createNewDirectory && !Directory.Exists(fullPathEcho))
                        {
                            Directory.CreateDirectory(fullPathEcho);
                        }
                        for (int i = 0; i < imagesList.Count; i++)
                        {
                            var file = imagesList[i];
                            if (file.Length > 0)
                            {
                                string imageFileName = (i + 1).ToString() + ".png";

                                // Save Sonic Image
                                string imageFilePath = Path.Combine(fullPathSonic, imageFileName);
                                using (var stream = new FileStream(imageFilePath, FileMode.Create))
                                {
                                    file.CopyTo(stream);
                                }

                                // Save Echo image
                                imageFilePath = Path.Combine(fullPathEcho, imageFileName);
                                using (var stream = new FileStream(imageFilePath, FileMode.Create))
                                {
                                    file.CopyTo(stream);
                                }
                            }
                        }
                        #endregion
                        #region[save Attachements]
                        bool createNewAttachementDirectory = attachedFiles != null && attachedFiles.Count > 0;
                        // Create Directory in Sonic 
                        rootPath = _hostingEnvironment.ContentRootPath;
                        folderName = "Resources\\attachements\\promotions\\";
                        thisPromotionName = Path.Combine(folderName, promotion.PromotionId.ToString());
                        oldPromotionName = Path.Combine(folderName, promotion.OldPromotionId.ToString());
                        string attachfullPathSonic = Path.Combine(rootPath, thisPromotionName);
                        string attacholdFullPathSonic = Path.Combine(rootPath, oldPromotionName);

                        // Delete old promotionId from sonic
                        if (Directory.Exists(attacholdFullPathSonic))
                        {
                            Directory.Delete(attacholdFullPathSonic, true);
                        }
                        //// Delete old save from sonic
                        //if (Directory.Exists(attachfullPathSonic))
                        //{
                        //    Directory.Delete(attachfullPathSonic, true);
                        //}
                        if (createNewAttachementDirectory && !Directory.Exists(attachfullPathSonic))
                        {
                            Directory.CreateDirectory(attachfullPathSonic);
                        }
                        for (int i = 0; i < promotion.DeletedFiles.Count; i++)
                        { // delete only deleted files , and another file existed .
                            string fileName = promotion.DeletedFiles[i];
                            string deletepath = Path.Combine(attachfullPathSonic, fileName);
                            string[] fileList = System.IO.Directory.GetFiles(attachfullPathSonic, fileName);
                            foreach (string file in fileList)
                            {
                                //System.Diagnostics.Debug.WriteLine(file + "will be deleted");
                                System.IO.File.Delete(file);
                            }
                        }
                        for (int i = 0; i < attachedFiles.Count; i++)
                        {
                            var file = attachedFiles[i];
                            if (file.Length > 0)
                            {
                                //if (file.Name.ToString().ToLower() == "attachedfiles")
                                {
                                    string fileName = file.FileName;
                                    string filePath = Path.Combine(attachfullPathSonic, fileName);
                                    using (var stream = new FileStream(filePath, FileMode.Create))
                                    {
                                        file.CopyTo(stream);
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                    if (result == GlobalErrors.Success && promotion.SendNotification)
                    {
                        NotificaitonsModel CustomerNotificaitons = new NotificaitonsModel();
                        int maxId = -1;
                        result = _customerService.GetMaxNotificationId(ref maxId);
                        if (result == GlobalErrors.Success)
                        {
                            CustomerNotificaitons.NotificationId = maxId;
                        }
                        if (imagesList != null && imagesList.Count > 0 && result == GlobalErrors.Success)
                        {
                            foreach (IFormFile file in imagesList)
                            {
                                result = UploadNotificationImage(file, ref CustomerNotificaitons);
                                if (result != GlobalErrors.Success)
                                {
                                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                                }
                            }
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        var data = new
                        {
                            PromotionId = promotion.PromotionId,
                            Status = promotion.Status,
                            OfferAppliedOptions = promotion.OfferAppliedOptions
                        };
                        return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region UPDATE
        [HttpPost]
        [ActionName("UpdatePromotion")]
        public JsonResult UpdatePromotion([FromForm] Collection<IFormFile> imagesList, Collection<IFormFile> attachedFiles, [FromForm] string promotionString)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                Promotion promotion = JsonConvert.DeserializeObject<Promotion>(promotionString);
                if (promotion != null)
                {
                    promotion.StartDate = new DateTime(promotion.StartDateModel.Year, promotion.StartDateModel.Month, promotion.StartDateModel.Day);
                    promotion.EndDate = new DateTime(promotion.EndDateModel.Year, promotion.EndDateModel.Month, promotion.EndDateModel.Day);

                    GlobalErrors result = _pricesAndOffersService.SavePromotion(promotion, Request.Form.Files);
                    if (result == GlobalErrors.Success)
                    {
                        #region[save Photos]
                        bool createNewDirectory = imagesList != null && imagesList.Count > 0;
                        // Create Directory in Sonic 
                        string rootPath = _hostingEnvironment.ContentRootPath;
                        string folderName = "Resources\\promotions-img\\";
                        string thisPromotionName = Path.Combine(folderName, promotion.PromotionId.ToString());
                        string oldPromotionName = Path.Combine(folderName, promotion.OldPromotionId.ToString());
                        string fullPathSonic = Path.Combine(rootPath, thisPromotionName);
                        string oldFullPathSonic = Path.Combine(rootPath, oldPromotionName);
                        // Delete old promotionId from sonic
                        if (Directory.Exists(oldFullPathSonic))
                        {
                            Directory.Delete(oldFullPathSonic, true);
                        }
                        // Delete old save from sonic
                        if (Directory.Exists(fullPathSonic))
                        {
                            Directory.Delete(fullPathSonic, true);
                        }
                        if (createNewDirectory && !Directory.Exists(fullPathSonic))
                        {
                            Directory.CreateDirectory(fullPathSonic);
                        }

                        // Create Directory in ECHO
                        rootPath = string.Format(@"{0}", LocalUtilities.CustomerAppServicePath);
                        folderName = "wwwroot\\img\\Echo\\promotions";
                        thisPromotionName = Path.Combine(folderName, promotion.PromotionId.ToString());
                        oldPromotionName = Path.Combine(folderName, promotion.OldPromotionId.ToString());
                        string fullPathEcho = Path.Combine(rootPath, thisPromotionName);
                        string oldFullPathEcho = Path.Combine(rootPath, oldPromotionName);
                        // Delete old promotion id from echo
                        if (Directory.Exists(oldFullPathEcho))
                        {
                            Directory.Delete(oldFullPathEcho, true);
                        }
                        // Delete old saved from echo
                        if (Directory.Exists(fullPathEcho))
                        {
                            Directory.Delete(fullPathEcho, true);
                        }
                        if (createNewDirectory && !Directory.Exists(fullPathEcho))
                        {
                            Directory.CreateDirectory(fullPathEcho);
                        }
                        for (int i = 0; i < imagesList.Count; i++)
                        {
                            var file = imagesList[i];
                            if (file.Length > 0)
                            {
                                string imageFileName = (i + 1).ToString() + ".png";

                                // Save Sonic Image
                                string imageFilePath = Path.Combine(fullPathSonic, imageFileName);
                                using (var stream = new FileStream(imageFilePath, FileMode.Create))
                                {
                                    file.CopyTo(stream);
                                }

                                // Save Echo image
                                imageFilePath = Path.Combine(fullPathEcho, imageFileName);
                                using (var stream = new FileStream(imageFilePath, FileMode.Create))
                                {
                                    file.CopyTo(stream);
                                }
                            }
                        }
                        #endregion
                        #region[save Attachements]
                        bool createNewAttachementDirectory = attachedFiles != null && attachedFiles.Count > 0;
                        // Create Directory in Sonic 
                        rootPath = _hostingEnvironment.ContentRootPath;
                        folderName = "Resources\\attachements\\promotions\\";
                        thisPromotionName = Path.Combine(folderName, promotion.PromotionId.ToString());
                        oldPromotionName = Path.Combine(folderName, promotion.OldPromotionId.ToString());
                        string attachfullPathSonic = Path.Combine(rootPath, thisPromotionName);
                        string attacholdFullPathSonic = Path.Combine(rootPath, oldPromotionName);

                        // Delete old promotionId from sonic
                        if (Directory.Exists(attacholdFullPathSonic))
                        {
                            Directory.Delete(attacholdFullPathSonic, true);
                        }
                        //// Delete old save from sonic
                        //if (Directory.Exists(attachfullPathSonic))
                        //{
                        //    Directory.Delete(attachfullPathSonic, true);
                        //}
                        if (createNewAttachementDirectory && !Directory.Exists(attachfullPathSonic))
                        {
                            Directory.CreateDirectory(attachfullPathSonic);
                        }
                        for (int i = 0; i < promotion.DeletedFiles.Count; i++)
                        { // delete only deleted files , and another file existed .
                            string fileName = promotion.DeletedFiles[i];
                            string deletepath = Path.Combine(attachfullPathSonic, fileName);
                            string[] fileList = System.IO.Directory.GetFiles(attachfullPathSonic, fileName);
                            foreach (string file in fileList)
                            {
                                //System.Diagnostics.Debug.WriteLine(file + "will be deleted");
                                System.IO.File.Delete(file);
                            }
                        }
                        for (int i = 0; i < attachedFiles.Count; i++)
                        {
                            var file = attachedFiles[i];
                            if (file.Length > 0)
                            {
                                //if (file.Name.ToString().ToLower() == "attachedfiles")
                                {
                                    string fileName = file.FileName;
                                    string filePath = Path.Combine(attachfullPathSonic, fileName);
                                    using (var stream = new FileStream(filePath, FileMode.Create))
                                    {
                                        file.CopyTo(stream);
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                    if (result == GlobalErrors.Success && promotion.SendNotification)
                    {
                        NotificaitonsModel CustomerNotificaitons = new NotificaitonsModel();
                        int maxId = -1;
                        result = _customerService.GetMaxNotificationId(ref maxId);
                        if (result == GlobalErrors.Success)
                        {
                            CustomerNotificaitons.NotificationId = maxId;
                        }
                        if (imagesList != null && imagesList.Count > 0 && result == GlobalErrors.Success)
                        {
                            foreach (IFormFile file in imagesList)
                            {
                                result = UploadNotificationImage(file, ref CustomerNotificaitons);
                                if (result != GlobalErrors.Success)
                                {
                                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                                }
                            }
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        var data = new
                        {
                            PromotionId = promotion.PromotionId,
                            Status = promotion.Status,
                            OfferAppliedOptions = promotion.OfferAppliedOptions
                        };
                        return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("UpdateFromActivateToDeactivatePromotion")]
        public JsonResult UpdateFromActivateToDeactivatePromotion([FromBody] Promotion promotion)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                GlobalErrors result = _pricesAndOffersService.UpdatePromotionActiveStatus(promotion, true);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("UpdateFromDeactiveToActivatePromotion")]
        public JsonResult UpdateFromDeactiveToActivatePromotion([FromBody] Promotion promotion)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                GlobalErrors result = _pricesAndOffersService.UpdatePromotionActiveStatus(promotion, false);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region DELETE
        [HttpPost]
        [ActionName("DeletePromotion")]
        public JsonResult DeletePromotion([FromBody] Promotion promotion)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                bool isValidToDelete = true;
                string validationMessage = string.Empty;
                GlobalErrors result = _pricesAndOffersService.DeletePromotion(promotion, ref isValidToDelete, ref validationMessage);
                if (result == GlobalErrors.Success)
                {
                    if (isValidToDelete)
                    {
                        return JSonResultResponse.GetSuccessrJSon(isValidToDelete, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(validationMessage, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region METHODS
        public GlobalErrors UploadNotificationImage(IFormFile image, ref NotificaitonsModel CustomerNotificaitons)
        {
            try
            {
                if (image == null)
                {
                    return GlobalErrors.Error;
                }

                string path = string.Format(@"{0}", LocalUtilities.CustomerAppServicePath);
                string folderName = "wwwroot\\notifications\\images";
                string newPath = Path.Combine(path, folderName);
                var file = image;

                if (!Directory.Exists(newPath))
                {
                    Directory.CreateDirectory(newPath);
                }

                if (file.Length > 0)
                {
                    string extension = Path.GetExtension(file.FileName).ToLowerInvariant();
                    if (!string.IsNullOrEmpty(extension))
                    {
                        string fileName = CustomerNotificaitons.NotificationId + extension;
                        string fullPath = Path.Combine(newPath, fileName);
                        using (var stream = new FileStream(fullPath, FileMode.Create))
                        {
                            file.CopyTo(stream);
                        }
                        CustomerNotificaitons.ImageName = fileName;
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }

                }
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        #endregion
    }
}
