﻿using DinkToPdf;
using DinkToPdf.Contracts;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.SignalR;
using Newtonsoft.Json;
using Razor.Templating.Core;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.Customer;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using Sonic.Web.Service.SendEmail;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class PromotionGroupsController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly IHostingEnvironment _hostingEnvironment;
        private readonly IWebHostEnvironment _webHostEnvironment;
        private readonly PricesAndOffersService _pricesAndOffersService;
        private readonly MasterDataService _masterDataService;


        public PromotionGroupsController(IHubContext<NotifyHub, ITypedHubClient> hubContext, IRequestRepository requestRepository, IWebHostEnvironment webHostEnvironment, ILicensing licensing, IHostingEnvironment hostingEnvironment, IActiveTokens activeToken, IConverter _convertor, IConverter converter) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _hostingEnvironment = hostingEnvironment;
            _webHostEnvironment = webHostEnvironment;
            _pricesAndOffersService = new PricesAndOffersService(hubContext,requestRepository, _hostingEnvironment);
            _masterDataService = new MasterDataService(requestRepository);


        }

        #region GET
        [HttpPost]
        [ActionName("GetPromotionGroupsList")]
        public JsonResult GetPromotionGroupsList([FromBody] GeneralFilter filter)
        {
            try
            {
                SharedTableResult<PromotionGroupModel> promotionGroupListTable = new SharedTableResult<PromotionGroupModel>();
                //GeneralFilter generalFilter = JsonConvert.DeserializeObject<GeneralFilter>(filter);
                GlobalErrors result = _pricesAndOffersService.GetPromotionGroupsList(filter, ref promotionGroupListTable);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(promotionGroupListTable, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.NoMoreRows)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetPromotionGroupData")]
        public JsonResult GetPromotionGroupData([FromBody] int PromotionGroupId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                var promotionGroup = new PromotionGroupModel();
                result = _pricesAndOffersService.GetPromotionGroupData(PromotionGroupId, ref promotionGroup);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(promotionGroup, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetUnAssigmentPromotions")]
        public JsonResult GetUnAssigmentPromotions([FromBody] PromotionFilterModel promotionFilter)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                //PromotionFilterModel promotionFilter = JsonConvert.DeserializeObject<PromotionFilterModel>(filter);
                SharedTableResult<PromotionGroupModel> promotionsSahredList = null;
                if (promotionFilter != null)
                {
                    promotionsSahredList = new SharedTableResult<PromotionGroupModel>();
                    result = _pricesAndOffersService.GetUnAssignedPromotions(promotionFilter, ref promotionsSahredList);
                }

                if (result == GlobalErrors.Success)
                {
                    if (promotionsSahredList != null && promotionsSahredList.Data != null && promotionsSahredList.Data.ToList().Count > 0)
                    {
                        return JSonResultResponse.GetSuccessrJSon(promotionsSahredList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(promotionsSahredList, ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region UPDATE
        [HttpPost]
        [ActionName("UpdatePromotionGroup")]
        public JsonResult UpdatePromotionGroup([FromBody] PromotionGroupModel PromotionGroupObject)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
                try
                {
                    bool uniqueCode = true;
                    var insertedValue = PromotionGroupObject.languageDescriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).Select(x => x.Description)?.FirstOrDefault();
                    result = _masterDataService.CheckIfUniqueValue("PromotionGroupLanguage", "Description", insertedValue, PromotionGroupObject.PromotionGroupId > 0 ? "and PromotionGroupID != " + PromotionGroupObject.PromotionGroupId : "", ref uniqueCode);

                    if (uniqueCode)
                    {
                        result = _pricesAndOffersService.UpdatePromotionGroup(PromotionGroupObject);
                        if (result == GlobalErrors.Success)
                        {
                            return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                        }
                        else
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                        }
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Desc_Unique_PromotionGroup", _requestRepository.LanguageId));
                    }
                }
                catch (Exception ex)
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                    return JSonResultResponse.GetErrorJSon();
                }
            }
        #endregion

            #region INSERT
            [HttpPost]
        [ActionName("InsertPromotionGroup")]
        public JsonResult InsertPromotionGroup([FromBody] PromotionGroupModel PromotionGroupObject)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                    bool uniqueCode = true;
                    var insertedValue = PromotionGroupObject.languageDescriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).Select(x => x.Description)?.FirstOrDefault();
                    result = _masterDataService.CheckIfUniqueValue("PromotionGroupLanguage", "Description", insertedValue, PromotionGroupObject.PromotionGroupId > 0 ? "and PromotionGroupID != " + PromotionGroupObject.PromotionGroupId : "", ref uniqueCode);

                    if (uniqueCode)
                    {
                        result = _pricesAndOffersService.InsertPromotionGroup(PromotionGroupObject);
                        if (result == GlobalErrors.Success)
                        {
                            return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                        }
                        else
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                        }
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Desc_Unique_PromotionGroup", _requestRepository.LanguageId));
                    }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region DELETE
        [HttpPost]
        [ActionName("DeletePromotionGroupData")]
        public JsonResult DeletePromotionGroupData([FromBody] int promotionGroupId)
        {
            try
            {
                string errorMessage = string.Empty;
                var result = _pricesAndOffersService.DeletePromotionGroupData(promotionGroupId, ref errorMessage);
                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Delete_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    if (string.IsNullOrEmpty(errorMessage))
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(errorMessage);
                    }
                }
                //else
                //{
                //    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(string.IsNullOrEmpty(errorMessage) ? MessagesConstants.Desc_Delete_Faild : errorMessage, _requestRepository.LanguageId));

                //}
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("DeletePromotionAssignment")]
        public JsonResult DeletePromotionAssignment([FromBody] int promotionId)
        {
            try
            {
                string errorMessage = string.Empty;
                var result = _pricesAndOffersService.DeletePromotionAssignment(promotionId, ref errorMessage);
                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Delete_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(string.IsNullOrEmpty(errorMessage) ? MessagesConstants.Desc_Delete_Faild : errorMessage, _requestRepository.LanguageId));

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
    }
}






