﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.MasterData;
using Sonic.Web.Models;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Reflection;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class SecurityGroupManagementController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ConfigurationService _configurationService;
        private readonly SettingService _settingService;
        public SecurityGroupManagementController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _configurationService = new ConfigurationService(requestRepository);
            _settingService = new SettingService(requestRepository);
        }

        #region GET
        [HttpPost]
        [ActionName("GetAvailableSecurityGroupsList")]
        public JsonResult GetAvailableSecurityGroupsList()
        {
            try
            {
                List<SecurityGroupsListModel> securityGroupsList = new List<SecurityGroupsListModel>();

                GlobalErrors result = _settingService.GetAvailableSecurityGroupsList(ref securityGroupsList);

                if (result == GlobalErrors.Success)
                {
                    var serializerSettings = new JsonSerializerSettings();
                    serializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
                    var json = JsonConvert.SerializeObject(securityGroupsList, serializerSettings);
                    string encryptString = AESEncryption.EncryptDataAESE(json, _requestRepository.CurrentOperator.EmployeeId);
                    if (encryptString != null && !string.IsNullOrEmpty(encryptString))
                    {
                        return JSonResultResponse.GetSuccessrJSon(encryptString, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region INSERT
        [HttpPost]
        [ActionName("InsertSecurityGroup")]
        public JsonResult InsertSecurityGroup([FromBody] SecurityGroupData Data)
        {
            try
            {
                var result = _settingService.UpdateSecurityGroups(Data);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(Data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region UPDATE

        #endregion

        #region DELETE

        [HttpPost]
        [ActionName("DeleteSecurityGroup")]
        public JsonResult DeleteSecurityGroup([FromBody] int securityGroupId)
        {
            try
            {
                GlobalErrors result = _settingService.DeleteSecurityGroup(securityGroupId);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
    }
}
