﻿using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authorization;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Service.SendEmail;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using System.Reflection;
using DinkToPdf.Contracts;
using System.Dynamic;
using Newtonsoft.Json;
using DinkToPdf;
using Razor.Templating.Core;
using System.IO;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [AllowAnonymous]
    public class SendEmailController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly SendEmailService _sendEmailService;
        private IConverter _converter;
        public SendEmailController(IRequestRepository requestRepository, IConverter converter, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _converter = converter;
            _requestRepository = requestRepository;
            _sendEmailService = new SendEmailService(requestRepository, _converter);
        }

        [HttpPost]
        [ActionName("ResendTransactionsEmail")]
        public JsonResult ResendTransactionsEmail([FromBody] List<TransactionEmailHistory> transactionEmails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            String failedTransactions = string.Empty;
            try
            {
                foreach (TransactionEmailHistory email in transactionEmails)
                {
                    EmailFilter filter = new EmailFilter();
                    filter.CustomerId = email.CustomerId;
                    filter.OutletId = email.OutletId;
                    filter.TransactionId = email.TransactionId;
                    filter.TransactionTypeId = email.TransactionTypeId;
                    filter.DivisionId = email.DivisionId;
                    filter.ReportTypeID = email.ReportTypeID;
                    result = _sendEmailService.PrepareTransactionAndSendEmail(filter, email);
                    if (result != GlobalErrors.Success)
                    {
                        failedTransactions = failedTransactions + filter.TransactionId + ", ";
                    }
                }
                if (String.IsNullOrEmpty(failedTransactions))
                    return JSonResultResponse.GetSuccessrJSon(transactionEmails, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                else //add failedTransactions with result $$$
                {
                    failedTransactions = failedTransactions.Remove(failedTransactions.Length - 1);
                    return JSonResultResponse.GetErrorJSon(failedTransactions);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("ShowReport")]
        public IActionResult ShowReport([FromBody] TransactionEmailHistory email)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                EmailFilter filter = new EmailFilter();
                string path = string.Empty, htmlContent = string.Empty;
                filter.CustomerId = email.CustomerId;
                filter.OutletId = email.OutletId;
                filter.TransactionId = email.TransactionId;
                filter.TransactionTypeId = email.TransactionTypeId;
                filter.DivisionId = email.DivisionId;
                filter.ReportTypeID = email.ReportTypeID;
                var reportModel = new ReportModel();
                result = _sendEmailService.ShowReport(filter, email, ref path, ref reportModel);
                if (result == GlobalErrors.Success)
                {
                    string pageFooter = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Report_Page_Footer, _requestRepository.LanguageId);
                    string ofString = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Of_String, _requestRepository.LanguageId);
                    string footer = string.Format("{0} [page] {1} [toPage]", pageFooter, ofString);
                    RazorTemplateEngine.Initialize();
                    htmlContent = RazorTemplateEngine.RenderAsync(path, reportModel).Result;
                    var globalSettings = new GlobalSettings
                    {
                        ColorMode = ColorMode.Color,
                        Orientation = Orientation.Portrait,
                        PaperSize = PaperKind.A4,
                        Margins = new MarginSettings { Top = 10, Left = 3, Right = 3 },
                        DocumentTitle = reportModel.ReportTitle,
                        DPI = 500
                        //Out = @"D:\PDFCreator\Employee_Report.pdf"  USE THIS PROPERTY TO SAVE PDF TO A PROVIDED LOCATION
                    };

                    var objectSettings = new ObjectSettings
                    {
                        PagesCount = true,
                        HtmlContent = htmlContent,
                        //Page = "https://code-maze.com/", USE THIS PROPERTY TO GENERATE PDF CONTENT FROM AN HTML PAGE
                        WebSettings = { DefaultEncoding = "utf-8", UserStyleSheet = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "ReportsStyle.css") },
                        HeaderSettings = { FontName = "Arial", FontSize = 9 },
                        FooterSettings = { FontName = "Arial", FontSize = 9, Left = DateTime.Now.ToString(), Right = footer, Spacing = 1.8 }
                    };
                    var pdf = new HtmlToPdfDocument()
                    {
                        GlobalSettings = globalSettings,
                        Objects = { objectSettings }
                    };
                    //_converter.Convert(pdf); IF WE USE Out PROPERTY IN THE GlobalSettings CLASS, THIS IS ENOUGH FOR CONVERSION
                    //return File(file, "application/pdf", "EmployeeReport.pdf"); //USE THIS RETURN STATEMENT TO DOWNLOAD GENERATED PDF DOCUMENT
                    return File(_converter.Convert(pdf), "application/pdf");
                }
                else
                {
                    return View();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return View();
            }
        }
        [HttpPost]
        [ActionName("GetTransactionsEmails")]
        public JsonResult GetTransactionsEmails([FromBody] TransactionEmailHistory filterModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<TransactionEmailHistory> transactionEmails = new List<TransactionEmailHistory>();
                result = _sendEmailService.GetTransactionsEmails(ref transactionEmails, filterModel);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(transactionEmails, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Desc_Faild_To_Retrive_TransactionsEmails");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetTransactionsEmailsForSharedTable")]
        public JsonResult GetTransactionsEmailsForSharedTable([FromBody] GeneralFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                //GeneralFilter generalFilter = JsonConvert.DeserializeObject<GeneralFilter>(filter);
                SharedTableResult<TransactionEmailHistory> transactionEmails = new SharedTableResult<TransactionEmailHistory>();
                result = _sendEmailService.GetTransactionsEmailsForSharedTable(ref transactionEmails, filter);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(transactionEmails, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Desc_Faild_To_Retrive_TransactionsEmails");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("SendTransactionByEmail")]
        public JsonResult SendTransactionByEmail([FromBody] EmailFilter filter)
        {
            try
            {
                if (!ModelState.IsValid)
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));

                var result = GlobalErrors.Error;

                if (filter.RouteHistoryID > 0)
                {
                    result = _sendEmailService.PrepareInvoicesOnDownload(filter.RouteHistoryID);
                }
                else
                    result = _sendEmailService.PrepareTransactionAndSendEmail(filter);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(null, ResourcesManager.TranslateKey(MessagesConstants.Desc_Email_Sent_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Email_Sent_Failed, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageSavingFailed);
            }
        }
        [HttpPost]
        [ActionName("SendSummaryReportsEmail")]
        public JsonResult SendSummaryReportsEmail([FromBody] EmailFilter filter)
        {
            try
            {
                if (!ModelState.IsValid)
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));

                var result = GlobalErrors.Error;

                if (filter.RouteHistoryID > 0 && filter.EmployeeID > 0)
                    result = _sendEmailService.PrepareEmployeeTemplateAndSendSummaryEmail(filter);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(null, ResourcesManager.TranslateKey(MessagesConstants.Desc_Email_Sent_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Email_Sent_Failed, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageSavingFailed);
            }
        }

    }
}
