﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.MasterData;
using Sonic.Web.Models;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Reflection;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class SettingsController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly EmployeeService _employeeService;
        private readonly ConfigurationService _configurationService;
        private readonly SettingService _settingService;
        private readonly SupportNoteService _supportNoteService;

        public SettingsController(IRequestRepository requestRepository,ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _employeeService = new EmployeeService(requestRepository);
            _configurationService = new ConfigurationService(requestRepository);
            _settingService = new SettingService(requestRepository);
            _supportNoteService = new SupportNoteService(requestRepository);
        }

        [HttpPost]
        [ActionName("FillMenuData")]
        public JsonResult FillMenuData([FromBody] MenuModel menuList)
        {
            List<MenuModel> allAvailableMenus = new List<MenuModel>();
            List<MenuModel> addedMenus = new List<MenuModel>();
            try
            {
                GlobalErrors result = _employeeService.FillMenuData(ref allAvailableMenus, ref addedMenus, menuList.securityGroupId, menuList.mode);
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        menusList = allAvailableMenus,
                        addedList = addedMenus,
                        encryptedEmployeeId = _requestRepository.CurrentOperator.EncryptedEmployeeId,

                    };
                    var serializerSettings = new JsonSerializerSettings();
                    serializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
                    var json = JsonConvert.SerializeObject(data, serializerSettings);
                    string encryptString = AESEncryption.EncryptDataAESE(json, _requestRepository.CurrentOperator.EmployeeId);
                    if (encryptString != null && !string.IsNullOrEmpty(encryptString))
                    {
                        return JSonResultResponse.GetSuccessrJSon(encryptString, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetAllConfigurations")]
        public JsonResult GetAllConfigurations([FromBody] ConfigurationModel configuration)
        {
            List<ConfigurationModel> allConfigurations = new List<ConfigurationModel>();
                    try
            {
                GlobalErrors result = GlobalErrors.Success;
                if (configuration.LevelId == (int)ConfigurationLevels.SystemLevel)
                    result = _configurationService.GetAllConfigurations(ref allConfigurations);
                else
                    result = _configurationService.GetLevelConfigurations(configuration.LevelId,configuration.Filter, ref allConfigurations);
                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(allConfigurations, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("UpdateSystemConfigurations")]
        public JsonResult UpdateSystemConfigurations([FromBody] List<ConfigurationModel> changedConfigurationsList)
        {
            try
            {
                GlobalErrors result = _configurationService.UpdateSystemConfigurations(changedConfigurationsList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertLevelConfigurations")]
        public JsonResult InsertLevelConfigurations([FromBody] ConfigurationLevelData configLevelData)
        {
            try
            {
                if(configLevelData==null) return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
            
                GlobalErrors result = _configurationService.SaveLevelConfigurations(configLevelData.changedConfigurations,configLevelData.ConfigLevel);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetModuleEditableDescriptions")]
        public JsonResult GetModuleEditableDescriptions([FromBody] int moduleId)
        {
            try
            {
                var descriptionsTable = new ChangeDescriptionsTable();

                var result = _settingService.GetModuleEditableDescriptions(moduleId, ref descriptionsTable);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(descriptionsTable, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("UpdateDescriptions")]
        public JsonResult UpdateDescriptions([FromBody] DescriptionsData descriptions)
        {
            try
            {
                var result = _settingService.UpdateDescriptions(descriptions.captions, descriptions.moduleId);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Update_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertSecurityGroup")]
        public JsonResult InsertSecurityGroup([FromBody] SecurityGroupData Data)
        {
            try
            {
                var result = _settingService.UpdateSecurityGroups(Data);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(Data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("InsertOperationLevels")]
        public JsonResult InsertOperationLevels([FromBody] List<ApprovalCycleOperationsModel> operationDataList)
        {
            try
            {
                var result = _settingService.SaveOperationLevels(operationDataList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(operationDataList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        //[HttpPost]
        //[ActionName("GetAvailableSecurityGroupsList")]
        //public JsonResult GetAvailableSecurityGroupsList()
        //{
        //    try
        //    {
        //        List<SecurityGroupsListModel> securityGroupsList = new List<SecurityGroupsListModel>();

        //        GlobalErrors result = _settingService.GetAvailableSecurityGroupsList(ref securityGroupsList);

        //        if (result == GlobalErrors.Success)
        //        {
        //            var serializerSettings = new JsonSerializerSettings();
        //            serializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
        //            var json = JsonConvert.SerializeObject(securityGroupsList, serializerSettings);
        //            string encryptString = AESEncryption.EncryptDataAESE(json, _requestRepository.CurrentOperator.EmployeeId);
        //            if (encryptString != null && !string.IsNullOrEmpty(encryptString))
        //            {
        //                return JSonResultResponse.GetSuccessrJSon(encryptString, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //            }
        //            else
        //            {
        //                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //            }
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        [HttpPost]
        [ActionName("getOperationLevelsData")]
        public JsonResult getOperationLevelsData()
        {
            try
            {
                List<ApprovalCycleOperationsModel> approvalCycleOperations = new List<ApprovalCycleOperationsModel>();

                GlobalErrors result = _settingService.GetApprovalCycleOperations(ref approvalCycleOperations);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(approvalCycleOperations, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetDescriptionsList")]
        public JsonResult GetDescriptionsList([FromBody] int securityGroupId)
        {
            try
            {
                List<TextLanguage> descriptionsList = new List<TextLanguage>();
                GlobalErrors result = _settingService.GetDescriptionsList(securityGroupId, ref descriptionsList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(descriptionsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        //[HttpPost]
        //[ActionName("DeleteSecurityGroup")]
        //public JsonResult DeleteSecurityGroup([FromBody] int securityGroupId)
        //{
        //    try
        //    {
        //        GlobalErrors result = _settingService.DeleteSecurityGroup(securityGroupId);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
        [HttpPost]
        [ActionName("GetAvailableModules")]
        public JsonResult GetAvailableModules()
        {
            try
            {
                List<SonicModulesModel> sonicModules = new List<SonicModulesModel>();
                GlobalErrors result = _settingService.GetSonicModulesList(ref sonicModules);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(sonicModules, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("RestoreDefaultDescriptions")]
        public JsonResult RestoreDefaultDescriptions([FromBody] List<SonicModulesModel> sonicModules)
        {
            try
            {
                GlobalErrors result = _settingService.RestoreDefaultCaptions(ref sonicModules);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("ManageLanguages")]
        public JsonResult ManageLanguages([FromBody] List<LanguageModel> languages)
        {
            try
            {
                var result = _settingService.ManageLanguages(languages);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(languages, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("InsertSupportNote")]
        public JsonResult InsertSupportNote([FromBody] SupportNote supportNote)
        {
            try
            {
                GlobalErrors result = _supportNoteService.InsertSupportNote(supportNote);
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        supportNoteId = supportNote.NoteID,
                        message = string.Empty
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, string.Format(ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId)));
                }
                else
                {

                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }




        }

        //[HttpPost]
        //[ActionName("GetCustomerVisitPatternsSharedTable")]
        //public JsonResult GetCustomerVisitPatternsSharedTable()
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        List<CustomerVisitPattern> customerVisitPatterns = new List<CustomerVisitPattern>();
        //        result = _settingService.GetCustomerVisitPatternsSharedTable(ref customerVisitPatterns);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(customerVisitPatterns, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("GetAllMenus")]
        //public JsonResult GetAllMenus()
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;

        //    try
        //    {
        //        List<CustomerVisitStepMenuModel> allMenus = new List<CustomerVisitStepMenuModel>();
        //        result = _settingService.GetAllMenus(ref allMenus);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(allMenus, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("CheckIfVisitPatternExists")]
        //public JsonResult CheckIfVisitPatternExists([FromBody] CustomerVisitsFilter filter)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        if (!ModelState.IsValid)
        //        {
        //            return JSonResultResponse.GetErrorJSon(MessagesConstants.Desc_Error_Happend);
        //        }
        //        CustomerVisitPattern patternObject = new CustomerVisitPattern();
        //        result = _settingService.CheckIfVisitPatternExists(filter, ref patternObject);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(patternObject, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
        //[HttpPost]
        //[ActionName("GetVisitPatternData")]
        //public JsonResult GetVisitPatternData([FromBody] CustomerVisitsFilter filter)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        if (!ModelState.IsValid)
        //        {
        //            return JSonResultResponse.GetErrorJSon(MessagesConstants.Desc_Error_Happend);
        //        }
        //        CustomerVisitPattern patternObject = new CustomerVisitPattern();
        //        result = _settingService.GetPatternObject(filter, ref patternObject);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(patternObject, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("InsertVisitPattern")]
        //public JsonResult InsertVisitPattern([FromBody] CustomerVisitPattern visitPattern)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        if (!ModelState.IsValid)
        //        {
        //            return JSonResultResponse.GetErrorJSon(MessagesConstants.Desc_Error_Happend);
        //        }
        //        CustomerVisitPattern patternObject = new CustomerVisitPattern();
        //        result = _settingService.InsertVisitPattern(visitPattern);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("UpdateVisitPattern")]
        //public JsonResult UpdateVisitPattern([FromBody] CustomerVisitPattern visitPattern)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        if (!ModelState.IsValid)
        //        {
        //            return JSonResultResponse.GetErrorJSon(MessagesConstants.Desc_Error_Happend);
        //        }
        //        CustomerVisitPattern patternObject = new CustomerVisitPattern();
        //        result = _settingService.UpdateVisitPattern(visitPattern);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("GetCustomerVisitStepDetails")]
        //public JsonResult GetCustomerVisitStepDetails([FromBody] CustomerVisitsFilter filter)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        CustomerVisitStepModel visitStepObj = new CustomerVisitStepModel();
        //        result = _settingService.GetCustomerVisitStepDetails(filter.PatternId,filter.StepId, ref visitStepObj);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(visitStepObj, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("DeleteVisitPattern")]
        //public JsonResult DeleteVisitPattern([FromBody] CustomerVisitsFilter filter)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        if (!ModelState.IsValid)
        //        {
        //            return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageSavingFailed);
        //        }
        //        result = _settingService.DeleteVisitPattern(filter);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

    }
}