﻿using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Enums;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Licensing.Models;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.NetworkInformation;
using System.Reflection;
using System.Threading.Tasks;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    public class SetupController : ControllerBase
    {
        private readonly ILicensing _licensing;

        public SetupController(ILicensing licensing)
        {
            _licensing = licensing;
        }

        [HttpPost]
        [ActionName("SetupEnviroment")]
        public JsonResult SetupEnviroment([FromBody] SetupFilter filter)
        {
            var licenseResult = LicenseResult.Licensed;
            var info = new SiteInfoModel();
            string userName = string.Empty;
            string password = string.Empty;
            try
            {
                if(filter != null)
                {
                    userName = filter.Username;
                    password = filter.Password;
                }
                if (IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() != LocalUtilities.DomainName)
                {
                    licenseResult = _licensing.IsLicensedByLogin(userName, password);
                    info = _licensing.GetSiteInfo();
                }
                if (licenseResult == LicenseResult.Licensed)
                {
                    return JSonResultResponse.GetSuccessrJSon(info, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, 1));
                }
                else
                {
                    string msg = ResourcesManager.TranslateKey(_licensing.GetErrorMessage(), 1);
                    return JSonResultResponse.GetErrorJSon(msg);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("UpdateLicense")]
        public JsonResult UpdateLicense([FromBody] int languageId)
        {
            var licenseResult = LicenseResult.Licensed;
            var info = new SiteInfoModel();
            try
            {
                if (languageId <= 0)
                {
                    languageId = 1;
                }
                if (IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() != LocalUtilities.DomainName)
                {
                    licenseResult = _licensing.IsLicensedByKey();
                    info = _licensing.GetSiteInfo();
                    //if (licenseResult == LicenseResult.Licensed)
                    //{
                    //    licenseResult = _licensing.UpdateMenus(info);
                    //}
                }
                if (licenseResult == LicenseResult.Licensed)
                {
                    return JSonResultResponse.GetSuccessrJSon(LicenseResult.Licensed.GetHashCode(), ResourcesManager.TranslateKey(MessagesConstants.Desc_Update_License, languageId));
                }
                else if (licenseResult == LicenseResult.Unauthorized)
                {
                    string msg = ResourcesManager.TranslateKey(_licensing.GetErrorMessage(), languageId);
                    return JSonResultResponse.GetSuccessrJSon(LicenseResult.Unauthorized.GetHashCode(), msg);
                }
                else if (licenseResult == LicenseResult.NearToExpired)
                {
                    string msg = string.Empty;
                    if (_licensing.NumberOfDaysToExpired() == 0)
                    {
                        msg = ResourcesManager.TranslateKey(MessagesConstants.Desc_Expired_Today, languageId);
                    }
                    else
                    {
                        msg = string.Format(ResourcesManager.TranslateKey(MessagesConstants.Desc_Near_To_Expired, languageId), _licensing.NumberOfDaysToExpired());
                    }
                    return JSonResultResponse.GetSuccessrJSon(LicenseResult.NearToExpired.GetHashCode(), msg);
                }
                else
                {
                    string msg = ResourcesManager.TranslateKey(_licensing.GetErrorMessage(), languageId);
                    return JSonResultResponse.GetErrorJSon(msg);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("IsSettedIp")]
        public JsonResult IsSettedIp()
        {
            try
            {
                if (IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() == LocalUtilities.DomainName)
                    return JSonResultResponse.GetSuccessrJSon(true, "Success Getting Data");
                if (_licensing.IsSettedUp())
                {
                    return JSonResultResponse.GetSuccessrJSon(true, "Success Getting Data");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error in Getting data");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

    }
}
