﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using DinkToPdf;
using DinkToPdf.Contracts;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service.Survey;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class SurveyController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly SurveyService _surveyService;
        private IHostingEnvironment _hostingEnvironment;
        private readonly IConverter _converter;
        public SurveyController(IHostingEnvironment hostingEnvironment, IRequestRepository requestRepository, ILicensing licensing, IConverter converter, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _surveyService = new SurveyService(requestRepository, hostingEnvironment, converter);
            _hostingEnvironment = hostingEnvironment;
            _converter = converter;
        }

        [HttpPost]
        [ActionName("getAllCustomerSurveys")]
        public JsonResult getAllCustomerSurveys([FromBody] FilterModel filterModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SurveyModel> surveys = new List<SurveyModel>();
                result = _surveyService.getAllCustomerSurveys(filterModel,ref surveys);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(surveys, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Desc_Faild_To_Retrive_Survey");
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        //#region[LOV]
        //[HttpPost]
        //[ActionName("GetLOVByID")]
        //public JsonResult GetLOVByID([FromBody]int LOVID)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    LOVDynamicModel LOVModel = new LOVDynamicModel();
        //    try
        //    {
        //        result = _surveyService.GetLOVByID(LOVID, ref LOVModel);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(LOVModel, ResourcesManager.TranslateKey("Desc_Deleted_Successfully", _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon("Desc_Faild_To_Retrive_Survey");
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
        
        //[HttpPost]
        //[ActionName("GetLOVs")]
        //public JsonResult GetLOVs()
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        List<SurveyTemplateModel> LOVs = new List<SurveyTemplateModel>();
        //        result = _surveyService.GetLOVs(ref LOVs);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(LOVs, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon("Desc_Faild_To_Retrive_Survey");
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
        //#endregion
        #region [SurveyPeriod]
        [HttpPost]
        [ActionName("GetSurveyPeriods")]
        public JsonResult GetSurveyPeriods([FromBody]int surveyId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SurveyPeriod> surveyPeriods = new List<SurveyPeriod>();
                result = _surveyService.GetSurveyPeriods(ref surveyPeriods, surveyId);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(surveyPeriods, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Desc_Faild_To_Retrive_Survey");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        #endregion
        [HttpPost]
        [ActionName("DeleteSurvey")]
        public JsonResult DeleteSurvey([FromBody] SurveyModel filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _surveyService.DeleteSurvey(filter.SurveyId, filter.DCFID, filter.SurveyTypeId, filter.LinkedToPromotion);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey("Desc_Deleted_Successfully", _requestRepository.LanguageId));
                }
                else if(result == GlobalErrors.NotInitialized)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Desc_Cannot_Delete_Used_Survey", _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Desc_Faild_To_Retrive_Survey");
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("FillUI")]
        public JsonResult FillUI([FromBody]int surveyTypeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var data = new Object();
                result = _surveyService.FillUI(surveyTypeId, ref data);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Desc_Faild_To_Retrive_Survey");
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("getFieldGroups")]
        public JsonResult getFieldGroups()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SurveyTemplateModel> fieldGroups = new List<SurveyTemplateModel>();
                result = _surveyService.getFieldGroups(ref fieldGroups);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(fieldGroups, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Desc_Faild_To_Retrive_Survey");
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        [HttpPost]
        [ActionName("InsertCustomerSurvey")]
        public JsonResult InsertCustomerSurvey([FromBody] SurveyModel survey)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _surveyService.SaveCustomerSurvey(survey);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(survey.SurveyId, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("UpdateCustomerSurvey")]
        public JsonResult UpdateCustomerSurvey([FromBody] SurveyModel survey)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _surveyService.UpdateCustomerSurvey(survey);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon("", ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertGroup")]
        public JsonResult InsertGroup([FromBody] FieldGroupModel group)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _surveyService.saveGroup(group.GroupName);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon("", ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("AllowRemoveQuestion")]
        public JsonResult AllowRemoveQuestion([FromBody] GeneralFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                bool isFieldHasAnswers = false;
                result = _surveyService.AllowDeleteQuestion(filter.FieldId, filter.SurveyTypeId, ref isFieldHasAnswers);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(isFieldHasAnswers, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Desc_Question_Has_Answers", _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("getSurveyQuestions")]
        public JsonResult getSurveyQuestions([FromBody]int dCFID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<QuestionModel> questions = new List<QuestionModel>();
                result = _surveyService.getSurveyQuestions(dCFID, ref questions);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(questions, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("getAppliedList")]
        public JsonResult getAppliedList([FromBody] int surveyId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            CreditReleaseDataModel dataModel = new CreditReleaseDataModel();
            try
            {
                List<CreditReleaseAssignmentModel> applyTo = new List<CreditReleaseAssignmentModel>();
                List<SecurityGroupModel> securityGroups = new List<SecurityGroupModel>();
                result = _surveyService.getAppliedList(surveyId, ref applyTo, ref securityGroups);
                if(result == GlobalErrors.Success)
                {
                    dataModel.Groups = applyTo.Where(x=>x.GroupId != -1).ToList();
                    dataModel.Channels = applyTo.Where(x=>x.ChannelId != -1).ToList();
                    dataModel.Customers = applyTo.Where(x=>x.CustomerId != -1).ToList();
                    dataModel.securityGroupsList = securityGroups;
                }
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(dataModel, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("getEmployeesAppliedList")]
        public JsonResult getEmployeesAppliedList([FromBody] int surveyId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<EmployeeModel> appliedEmployee = new List<EmployeeModel>();
                List<SecurityGroupModel> securityGroups = new List<SecurityGroupModel>();
                result = _surveyService.getEmployeesAppliedList(surveyId, ref appliedEmployee,ref securityGroups);
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        appliedEmployee = appliedEmployee,
                        securityGroups = securityGroups,
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }



        [HttpPost]
        [ActionName("GetQuestionsDepend")]
        public JsonResult GetQuestionsDepend([FromBody] QuestionModel questionModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SurveyTemplateModel> questionDependList = new List<SurveyTemplateModel>();
                result = _surveyService.GetQuestionsDepend(questionModel.DCFID, questionModel.FieldId, ref questionDependList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(questionDependList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetLOVOptions")]
        public JsonResult GetLOVOptions([FromBody]int lOVId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<LOVModel> LOVOptionsList = new List<LOVModel>();
                result = _surveyService.GetLOVOptions(lOVId,ref LOVOptionsList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(LOVOptionsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetSurveyPeriodTypes")]
        public JsonResult GetSurveyPeriodTypes([FromBody]int surveyTypeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SurveyPeriodTypeModel> SurveyPeriodTypeList = new List<SurveyPeriodTypeModel>();
                result = _surveyService.GetSurveyPeriodTypes(surveyTypeId, ref SurveyPeriodTypeList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(SurveyPeriodTypeList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        //[HttpPost]
        //[ActionName("GetInspectorSurveys")]
        //public JsonResult GetInspectorSurveys([FromBody] FilterModel filterModel)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        List<SurveyModel> surveys = new List<SurveyModel>();
        //        result = _surveyService.GetInspectorSurveys(filterModel, ref surveys);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(surveys, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("GetSurveyData")]
        //public JsonResult GetSurveyData([FromBody]SurveyModel filter)
        //{
        //    try
        //    {
        //        if (!ModelState.IsValid)
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
        //        }
        //        if (filter.SurveyId != -1)
        //        {
        //            SurveyModel selectedSurvey = new SurveyModel();
        //            selectedSurvey.SurveyId = filter.SurveyId;
        //            selectedSurvey.DCFID = filter.DCFID;
        //            selectedSurvey.WarehouseId = filter.WarehouseId;
        //            GlobalErrors result = _surveyService.GetSurveyData(filter.SurveyId, filter.DCFID, filter.WarehouseId, filter.ReadingId, filter.OrganizationID, filter.IsClone, ref selectedSurvey);
        //            if (result == GlobalErrors.Success)
        //            {
        //                return JSonResultResponse.GetSuccessrJSon(selectedSurvey, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //            }
        //            else
        //            {
        //                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //            }
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
        //[HttpPost]
        //[ActionName("InsertQualityControlReading")]
        //public JsonResult InsertQualityControlReading([FromBody] SurveyReadingModel surveyReadingModel)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        result = _surveyService.SaveQualityControlReading(surveyReadingModel, _hostingEnvironment);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon("", ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        [HttpPost]
        [ActionName("GetSurveyMenusImages")]
        public JsonResult GetSurveyMenusImages()
        {
            try
            {
                List<SurveyMenu> imagesNames = new List<SurveyMenu>();
                FileManagerModel model = new FileManagerModel();
                string folderName = "Resources\\survey-menus-img";
                string rootPath = _hostingEnvironment.ContentRootPath;
                var userImagesPath = Path.Combine(rootPath, folderName);
                DirectoryInfo dir = new DirectoryInfo(userImagesPath);
                SurveyMenu menu = new SurveyMenu();
                int imageID = 0;
                if (dir.Exists)
                {
                    FileInfo[] files = dir.GetFiles();
                    model.Files = files;
                    if (files != null && files.Length > 0)
                    {
                        imageID = 0;
                        foreach (FileInfo file in files)
                        {
                            imageID += 1;
                            menu = new SurveyMenu();
                            menu.Path = file.Name;
                            menu.ImageName =  "survey" + imageID;
                            imagesNames.Add(menu);
                        }
                    }
                }
                GlobalErrors result = GlobalErrors.Success;
                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(imagesNames, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("CloneSurveyProcedure")]
        public JsonResult CloneSurveyProcedure([FromBody] int surveyId)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                result = _surveyService.ExecuteCloneSurveyProcedure(surveyId);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon("", ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetLinkedToPromotionSurveys")]
        public JsonResult GetLinkedToPromotionSurveys([FromBody]int promotionId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SurveyModel> surveys = new List<SurveyModel>();
                result = _surveyService.GetLinkedToPromotionSurveys(promotionId, ref surveys);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(surveys, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetSurveys")]
        public JsonResult GetSurveys([FromBody] int surveyTypeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SurveyModel> surveys = new List<SurveyModel>();
                result = _surveyService.GetSurveys(surveyTypeId, ref surveys);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(surveys, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

    }
}