﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using Sonic.Web.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class ValidationController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ValidationService _validationService;
        private readonly PromotionService _promotionService;
        private readonly DocumentSequenceService _documentSequenceService;
        
        public ValidationController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _validationService = new ValidationService(requestRepository);
            _promotionService = new PromotionService(requestRepository);
            _documentSequenceService = new DocumentSequenceService(_requestRepository);
        }

        [HttpPost]
        [ActionName("CheckHeaderData")]
        public JsonResult CheckHeaderData([FromBody] TransactionCommonData transationCommonData)
        {
            string msgError = string.Empty;
            try
            {
                GlobalErrors result = _validationService.CheckHeaderData(ref transationCommonData, ref msgError);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(transationCommonData, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                if (msgError != string.Empty)
                {
                    return JSonResultResponse.GetErrorJSon(false,ResourcesManager.TranslateKey(msgError, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        } 
        [HttpPost]
        [ActionName("CheckCostPrice")]
        public JsonResult CheckCostPrice([FromBody] TransactionCommonData transationCommonData)
        {
            string msgError = string.Empty;
            try
            {
                GlobalErrors result = _validationService.CheckCostPrice(transationCommonData, ref msgError);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                if (msgError != string.Empty)
                {
                    return JSonResultResponse.GetErrorJSon(msgError);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("CheckOutPromotions")]
        public JsonResult CheckOutPromotions([FromBody] TransactionCommonData transationCommonData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var allItems = transationCommonData.SoldItems.Where(x => x.SalesTransactionTypeId == SalesTransactionTypes.Promotion || x.SalesTransactionTypeId == SalesTransactionTypes.FOC).ToList(); ;
                transationCommonData.SoldItems = transationCommonData.SoldItems.Where(x => x.SalesTransactionTypeId != SalesTransactionTypes.Promotion && x.SalesTransactionTypeId != SalesTransactionTypes.FOC).ToList();

                var customerPromotions = new List<Promotion>();
                var promotionGroupLevels = new List<PromotionGroupLevelsModel>();
                bool hasWholeSalesTargetPromo = false;
                bool hasDynamicTargetSalesAmountPromo = false;
                bool isPromotionSelectionForEcho = false;
                bool hasLoyalityPromotion = false;
                bool hasNoSalesCertainPeriod = false;
                //var transCommonData = new TransactionCommonData();
               result = _validationService.CheckPromotions(transationCommonData, ref customerPromotions, false, ref hasWholeSalesTargetPromo, ref hasDynamicTargetSalesAmountPromo, false, false, false, ref isPromotionSelectionForEcho, ref hasLoyalityPromotion, false,ref hasNoSalesCertainPeriod);
                if(result == GlobalErrors.Success)
                {
                    transationCommonData.SoldItems.AddRange(allItems);
                }
                var data = new
                {
                    customerPromotions = customerPromotions,
                    promotionGroupLevels = transationCommonData.PromotionGroupLevels,
                    hasWholeSalesTargetPromo = hasWholeSalesTargetPromo,
                    hasDynamicTargetSalesAmountPromo = hasDynamicTargetSalesAmountPromo,
                    isPromotionSelectionForEcho = isPromotionSelectionForEcho,
                    hasLoyalityPromotion = hasLoyalityPromotion,
                    unSatisfiedTargetPromotions = transationCommonData.UnSatisfiedTargetPromotions,
                    unSatisfiedDynamicAmountPromotions = transationCommonData.UnSatisfiedDynamicAmountPromotions,
                    transCommonData = transationCommonData,
                    hasNoSalesCertainPeriod = hasNoSalesCertainPeriod
                };

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.UploadedRoute)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Cant_delivery_for_Uploaded_Customer, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("CheckOutBundles")]
        public JsonResult CheckOutBundles([FromBody] TransactionCommonData transationCommonData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var orderBundles = new List<Promotion>();
                var transCommonData = new TransactionCommonData();
                result = _validationService.CheckOrderBundles(transationCommonData, ref orderBundles);
                var data = new
                {
                    orderBundles = orderBundles,
                    transCommonData = transationCommonData,
                };

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("TakePromotions")]
        public JsonResult TakePromotions([FromBody] TransactionCommonData transationCommonData)
        {
            try
            {
                var allItems = transationCommonData.SoldItems.Where(x => x.SalesTransactionTypeId == SalesTransactionTypes.Promotion || x.SalesTransactionTypeId == SalesTransactionTypes.FOC).ToList();
                transationCommonData.SoldItems = transationCommonData.SoldItems.Where(x => x.SalesTransactionTypeId != SalesTransactionTypes.Promotion && x.SalesTransactionTypeId != SalesTransactionTypes.FOC).ToList();
                if (transationCommonData.ProductPromotionLevelId == 2)
                    transationCommonData.OnlyProductDiscount = false;
                GlobalErrors result = _promotionService.TakePromotions(ref transationCommonData,false);
                if (transationCommonData.IsThereAnyProductDiscountDefined)
                {
                    if (transationCommonData.CustomerProductPromotions == null || (transationCommonData.CustomerProductPromotions != null && transationCommonData.CustomerProductPromotions.Count == 0))
                        transationCommonData.CustomerProductPromotions = transationCommonData.CustomerPromotions;
                    else
                        transationCommonData.CustomerProductPromotions.AddRange(transationCommonData.CustomerPromotions);
                    transationCommonData.LastInvoicePromotionsList = new List<int>();
                    transationCommonData.DontCheckLastInvoice = true;
                    transationCommonData.ProductPromotionLevelId = 2;
                    if (transationCommonData.CustomerProductPromotions != null && transationCommonData.CustomerProductPromotions.Count > 0)
                    {
                        foreach (Promotion prodProm in transationCommonData.CustomerProductPromotions)
                        {
                            if (!transationCommonData.CustomerPromotions.Contains(prodProm))
                                transationCommonData.CustomerPromotions.Add(prodProm);
                        }
                    }
                }
                else
                {
                    if (transationCommonData.CustomerProductPromotions != null && transationCommonData.CustomerProductPromotions.Count > 0)
                    {
                        foreach (Promotion prodProm in transationCommonData.CustomerProductPromotions)
                        {
                            if (!transationCommonData.CustomerPromotions.Contains(prodProm))
                                transationCommonData.CustomerPromotions.Add(prodProm);
                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    transationCommonData.SoldItems.AddRange(allItems);
                }
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(transationCommonData, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetMaxDocumentSequence")]
        public JsonResult GetMaxDocumentSequence([FromBody] DocumentSequenceFilter documentSequenceFilter)
        {
            try
            {
                string documentId = string.Empty;
                string responseMessage = MessagesConstants.Desc_No_Document_Sequence;
                documentId = _documentSequenceService.GetMaxDocumentSequence(documentSequenceFilter.EmployeeId, documentSequenceFilter.DocumentType, documentSequenceFilter.DivisionId);

                if (!string.IsNullOrEmpty(documentId))
                {
                    if (documentSequenceFilter.DocumentType == DocumentTypes.Collection) // also check for applied payment id
                    {
                        string appliedPaymentId = _documentSequenceService.GetMaxDocumentSequence(documentSequenceFilter.EmployeeId, DocumentTypes.AppliedPayment, documentSequenceFilter.DivisionId);
                        if (string.IsNullOrEmpty(appliedPaymentId))
                        {
                            if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && _requestRepository.Configurations.ApplyDivisionsOnDocumentSequence)
                            {
                                responseMessage = MessagesConstants.Desc_No_Document_Sequence_To_Selected_Division;
                            }
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(responseMessage, _requestRepository.LanguageId));
                        }
                    }
                    return JSonResultResponse.GetSuccessrJSon(documentId, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && _requestRepository.Configurations.ApplyDivisionsOnDocumentSequence)
                    {
                        responseMessage = MessagesConstants.Desc_No_Document_Sequence_To_Selected_Division;
                    }
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(responseMessage, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("CheckAccountAndDocumentSequence")]
        public JsonResult CheckAccountAndDocumentSequence([FromBody] DocumentSequenceFilter documentSequenceFilter)
        {
            try
            {
                string maxDocumentId = string.Empty;
                int accountId = -1;

                bool isValid = _validationService.IsValidAccountAndDocumentSequence(documentSequenceFilter, ref maxDocumentId, ref accountId);
                if (isValid)
                {
                    return JSonResultResponse.GetSuccessrJSon(maxDocumentId, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    if (string.IsNullOrEmpty(maxDocumentId))
                    {
                        string responseMessage = MessagesConstants.Desc_No_Document_Sequence;
                        if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && _requestRepository.Configurations.ApplyDivisionsOnDocumentSequence)
                        {
                            responseMessage = MessagesConstants.Desc_No_Document_Sequence_To_Selected_Division;
                        }
                        if (_requestRepository.Configurations.EnableSalesDistributionChannel && _requestRepository.Configurations.ApplyDocumentSequencePerSalesChannel)
                        {
                            responseMessage = MessagesConstants.Desc_No_Document_Sequence_To_Selected_Sales_Distribution_Channel;
                        }
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(responseMessage, _requestRepository.LanguageId));
                    }
                    else if (accountId == -1)
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Employee_Account, _requestRepository.LanguageId));
                    }
                }
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        
        [HttpPost]
        [ActionName("RecalculateAfterProductDiscountPromotions")]
        public JsonResult RecalculateAfterProductDiscountPromotions([FromBody] TransactionCommonData transationCommonData)
        {
            try
            {
                _validationService.RecalculateItemsWithProductDiscount(transationCommonData);
                return JSonResultResponse.GetSuccessrJSon(transationCommonData, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        #region[Contracted FOC]
        [HttpPost]
        [ActionName("CheckForContractedFOC")]
        public JsonResult CheckForContractedFOC([FromBody] TransactionCommonData transationCommonData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<AppliedContractedFOCModel> contractedFOCs = new List<AppliedContractedFOCModel>();
                result = _validationService.CheckForContractedFOC(transationCommonData, ref contractedFOCs);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(contractedFOCs, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("ApplyContractedFOCs")]
        public JsonResult ApplyContractedFOCs([FromBody] TransactionCommonData transationCommonData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _validationService.ApplyContractedFOCs(ref transationCommonData);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(transationCommonData, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region[Header Discount]
        [HttpPost]
        [ActionName("CheckForHeaderDiscount")]
        public JsonResult CheckForHeaderDiscount([FromBody] TransactionCommonData transationCommonData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<HeaderDiscountModel> headerDiscountList = new List<HeaderDiscountModel>();
                result = _validationService.CheckForHeaderDiscount(ref transationCommonData, ref headerDiscountList);
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        transactionCommonData = transationCommonData,
                        headerDiscountList = headerDiscountList
                    };
                    return JSonResultResponse.GetSuccessrJSon(data,  ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
    }
}