﻿using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using System.Linq;
using System.Reflection;
using Microsoft.AspNetCore.Authorization;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using Sonic.Web.Licensing.Licensing;
using System.IO;
using System.Collections.ObjectModel;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Hosting;
using System.Threading.Tasks;
using Sonic.Web.PL.Helper;
using DinkToPdf.Contracts;
using DinkToPdf;
using Razor.Templating.Core;

namespace Sonic.Web.PL.Controllers
{

    [Route("api/[controller]/[action]")]
    [Authorize]
    public class WebFormController : BaseController
    {
        private readonly WebFormService _webFormService;
        private readonly IConverter _converter;
        private SharedMethod _sharedMethod;
        private readonly IRequestRepository _requestRepository;
        private IHostingEnvironment _hostingEnvironment;
        private readonly EmployeeService _employeeService;
        private readonly IActiveTokens _activeTokens;
        public WebFormController(IHostingEnvironment hostingEnvironment, IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken , IConverter converter) : base(requestRepository, licensing, activeToken)
        {
            _activeTokens = activeToken;
            _requestRepository = requestRepository;
            _converter = converter;
            _sharedMethod = new SharedMethod(_requestRepository);
            _webFormService = new WebFormService(requestRepository);
            _hostingEnvironment = hostingEnvironment;
            _employeeService = new EmployeeService(_requestRepository);
        }

        [HttpPost]
        [ActionName("InitializeWebFormList")]
        public JsonResult InitializeWebFormList([FromBody] InitializeWebFormList retrivingModel)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                WebFormModel form = new WebFormModel();
                result = _webFormService.InitializeWebFormList(retrivingModel, ref form);

                if (result == GlobalErrors.Success && form != null)
                {
                    return JSonResultResponse.GetSuccessrJSon(form, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetWebFormListData")]
        public JsonResult GetWebFormListData([FromBody] InitializeWebFormList retrivingModel)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                WebFormModel form = new WebFormModel();
                result = _webFormService.GetWebFormListData(retrivingModel, ref form);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(form.SharedTableDataSource, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("InitializeWebFormEntry")]
        public JsonResult InitializeWebFormEntry([FromBody] InitializeWebFormEntry retrivingModel)
        {
            try
            {
                List<string> attachementNames = new List<string>();
                GlobalErrors result = GlobalErrors.NotInitialized;
                WebFormModel form = new WebFormModel();
                result = _webFormService.InitializeWebFormEntry(retrivingModel, ref form, _hostingEnvironment);     
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(form, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("FillControlsDataSourceBasedOnParentControlValue")]
        public JsonResult FillControlsDataSourceBasedOnParentControlValue([FromBody] List<WebFormControlModel> controls)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                if (controls != null)
                {
                    result = _webFormService.FillControlsDataSourceBasedOnParentControlValue(ref controls);
                }
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(controls, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("InsertEntryForm")]
        public JsonResult InsertEntryForm([FromForm] Collection<IFormFile> attachedFiles, [FromForm] string entryFormString)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                WebFormModel entryForm = JsonConvert.DeserializeObject<WebFormModel>(entryFormString);
                string erroMessage = string.Empty;
                GlobalErrors result = _webFormService.SaveEntryForm(entryForm, ref erroMessage, _hostingEnvironment, attachedFiles);


                if (result == GlobalErrors.Success)
                {
                    //if (entryForm.WebFormName == "OrganizationsEntry" && !_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                    //{
                    //    result = _employeeService.FillOperatorRelatedData(false, false, true);
                    //    if (result != GlobalErrors.Success) return JSonResultResponse.GetErrorJSon("Desc_Saving_Faild");
                    //    string tokenString = WorkExtension.GenerateToken(_requestRepository.CurrentOperator, HttpContext.Session.Id, entryForm.ExpirationDate);
                    //    string httpToken = this.Request.Headers["Authorization"].ToString();
                    //    if (!string.IsNullOrEmpty(httpToken) && !string.IsNullOrEmpty(tokenString))
                    //    {
                    //        _activeTokens.DeleteActiveTokens(httpToken);
                    //        _activeTokens.AddActiveTokens(tokenString);
                    //    }
                    //    if (!string.IsNullOrEmpty(tokenString))
                    //    {
                    //        var data = new
                    //        {
                    //            result = result,
                    //            tokenString = tokenString,
                    //            currentOperator = _requestRepository.CurrentOperator
                    //        };
                    //        return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                    //    }
                    //    else
                    //    {
                    //        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Token Error", _requestRepository.LanguageId));
                    //    }
                    //}
                    //else
                    //{
                    //    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));

                    //}
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    if (result == GlobalErrors.DataAlreadyExists)
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Inserted_Data_Already_Exist, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(erroMessage, _requestRepository.LanguageId));
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("UpdateEntryForm")]
        public JsonResult UpdateEntryForm([FromForm] Collection<IFormFile> attachedFiles, [FromForm] string entryFormString)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                WebFormModel entryForm = JsonConvert.DeserializeObject<WebFormModel>(entryFormString);

                string erroMessage = string.Empty;
                GlobalErrors result = _webFormService.SaveEntryForm(entryForm, ref erroMessage, _hostingEnvironment, attachedFiles);
               
                if (result == GlobalErrors.Success)
                {
                    if (entryForm.WebFormName == "OrganizationsEntry" && !_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                    {
                        result = _employeeService.FillOperatorRelatedData(false, false, true);
                        if (result != GlobalErrors.Success) return JSonResultResponse.GetErrorJSon("Desc_Saving_Faild");
                        string tokenString = WorkExtension.GenerateToken(_requestRepository.CurrentOperator, HttpContext.Session.Id, entryForm.ExpirationDate);
                        string httpToken = this.Request.Headers["Authorization"].ToString();
                        if (!string.IsNullOrEmpty(httpToken) && !string.IsNullOrEmpty(tokenString))
                        {
                            _activeTokens.DeleteActiveTokens(httpToken);
                            _activeTokens.AddActiveTokens(tokenString);
                        }
                        if (!string.IsNullOrEmpty(tokenString))
                        {
                            var data = new
                            {
                                result = result,
                                tokenString = tokenString,
                                currentOperator = _requestRepository.CurrentOperator
                            };
                            return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                        }
                        else
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Token Error", _requestRepository.LanguageId));
                        }
                    }
                    else
                    {
                        if (string.IsNullOrEmpty(erroMessage))
                        {
                            erroMessage = MessagesConstants.MessageErrorHappened;
                        }
                        return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));

                    }
                }
                else
                {
                    if (result == GlobalErrors.DataAlreadyExists)
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Inserted_Data_Already_Exist, _requestRepository.LanguageId));
                    }
                    else
                    {
                        if (string.IsNullOrEmpty(erroMessage))
                        {
                            erroMessage = MessagesConstants.MessageErrorHappened;
                        }
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(erroMessage, _requestRepository.LanguageId));
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("CheckForUniqueValidation")]
        public JsonResult CheckForUniqueValidation([FromBody] WebFormModel entryForm)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                string validationMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId);
                bool isValid = true;
                GlobalErrors result = _webFormService.CheckForUniqueValidation(entryForm, ref isValid, ref validationMessage);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(isValid, validationMessage);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("PerformActionProcedure")]
        public JsonResult PerformActionProcedure([FromBody] PerformActionProcedureModel filter)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                bool isValid = false;
                string validationMessage = string.Empty;
                GlobalErrors result = _webFormService.PerformActionProcedure(filter, ref isValid, ref validationMessage);
                if (result == GlobalErrors.Success)
                {
                    //if (filter.ProcedureName == CoreDataBaseConstants.ProceduresConstants.DeleteOrganizationProcedure)
                    //{
                    //    result = _employeeService.FillOperatorRelatedData(false, false, true);
                    //    if (result != GlobalErrors.Success) return JSonResultResponse.GetErrorJSon(MessagesConstants.Desc_Saving_Faild);
                    //    string tokenString = WorkExtension.GenerateToken(_requestRepository.CurrentOperator, HttpContext.Session.Id, filter.ExpirationDate);
                    //    string httpToken = this.Request.Headers["Authorization"].ToString();
                    //    if (!string.IsNullOrEmpty(httpToken) && !string.IsNullOrEmpty(tokenString))
                    //    {
                    //        _activeTokens.DeleteActiveTokens(httpToken);
                    //        _activeTokens.AddActiveTokens(tokenString);
                    //    }
                    //    if (!string.IsNullOrEmpty(tokenString))
                    //    {
                    //        var data = new
                    //        {
                    //            isValid = isValid,
                    //            tokenString = tokenString,
                    //            currentOperator = _requestRepository.CurrentOperator
                    //        };
                    //        return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(validationMessage, _requestRepository.LanguageId));
                    //    }
                    //    else
                    //    {
                    //        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Token Error", _requestRepository.LanguageId));
                    //    }
                    //}
                    //else
                    //{
                    //    var data = new
                    //    {
                    //        isValid = isValid
                    //    };
                    //    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(validationMessage, _requestRepository.LanguageId));
                    //}

                    var data = new
                    {
                        isValid = isValid
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(validationMessage, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("DownloadFile")]
        public async Task<FileStream> DownloadFile(string primaryKey, string webMenuURL, string fileName)
        {
            try
            {
                if (string.IsNullOrEmpty(fileName))
                {
                    return null;
                }

                string folderName = Path.Combine("Resources\\attachements\\", webMenuURL, primaryKey);
                string rootPath = _hostingEnvironment.ContentRootPath;
                var path = Path.Combine(rootPath, folderName, fileName);


                return new FileStream(path, FileMode.Open, FileAccess.Read);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        [HttpPost]
        [ActionName("getOrganizationDetailsForParent")]
        public JsonResult getOrganizationDetailsForParent([FromBody] int OrganizationId)
        {
            try
            {
                OrganizationModel organizationModel = new OrganizationModel();

                GlobalErrors result = _webFormService.getOrganizationDetailsForParent(OrganizationId , ref organizationModel);

                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                      organizationModel
                    };

                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("PrintWebForm")]
        public IActionResult printWebForm([FromBody] InitializeWebFormList form)
        {
            var result = GlobalErrors.NotInitialized;
            double topMargin = 10;
            string path = string.Empty;
            string htmlContent = string.Empty;
            string headerPath = string.Empty;
            try
            {
                WebFormModel webForm = new WebFormModel();
                if (form != null)
                {
                    webForm = form.Form;
                }
                result = _webFormService.PreparePrintingQuery(ref webForm, form.SharedTableFilter, ref path);

                if (result == GlobalErrors.Success && webForm != null && webForm.ReportData != null && webForm.ReportData.Count > 0)
                {
                    string pageFooter = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Report_Page_Footer, _requestRepository.LanguageId);
                    string ofString = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Of_String, _requestRepository.LanguageId);
                    string footer = string.Format("{0} [page] {1} [toPage]", pageFooter, ofString);
                    RazorTemplateEngine.Initialize();
                    htmlContent = RazorTemplateEngine.RenderAsync(path, webForm).Result;

                    if (_requestRepository.Configurations.PrintHeaderPerPage)
                    {
                        double totalLines = 0;
                        result = _sharedMethod.PrepareCustomHeader(ref htmlContent, ref headerPath);

                        if (webForm != null)
                        {
                            var detail = webForm;
                            object value = null;
                            if (((IDictionary<string, object>)detail).ContainsKey("HeaderLines"))
                            {
                                ((IDictionary<string, object>)detail).TryGetValue("HeaderLines", out value);
                            }
                            if (value != null && !string.IsNullOrEmpty(value.ToString()))
                            {
                                totalLines = double.Parse(value.ToString());
                            }
                        }
                        double singleLineMargin = 7;

                        topMargin = (singleLineMargin * (totalLines));
                    }

                    if (result != GlobalErrors.Success) return View();

                    var globalSettings = new GlobalSettings
                    {
                        ColorMode = ColorMode.Color,
                        Orientation = Orientation.Portrait,
                        PaperSize = PaperKind.A4,
                        DocumentTitle = webForm.MenuName,
                        Margins = new MarginSettings { Top = topMargin, Left = 3, Right = 3 },
                        DPI = 500
                    };

                    var objectSettings = new ObjectSettings
                    {
                        PagesCount = true,
                        HtmlContent = htmlContent,
                        WebSettings = { DefaultEncoding = "utf-8", UserStyleSheet = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "ReportsStyle.css") },
                        HeaderSettings = { FontName = "Arial", FontSize = 9, HtmUrl = headerPath },
                        FooterSettings = { FontName = "Arial", FontSize = 9, Left = DateTime.Now.ToString(), Right = footer, Spacing = 1.8 }
                    };
                    var pdf = new HtmlToPdfDocument()
                    {
                        GlobalSettings = globalSettings,
                        Objects = { objectSettings }
                    };
                    return File(_converter.Convert(pdf), "application/pdf");
                }
                else
                {
                    return View();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return View();
            }
        }
    }
}
