﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.IdentityModel.Tokens;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.IdentityModel.Tokens.Jwt;
using System.Reflection;
using System.Security.Claims;
using System.Text;
using InCube.Security;

namespace Sonic.Web.PL.Helper
{
    public static class WorkExtension
    {
        private static object _object = new object();

        public static bool IsAuthenticated(this Controller controller)
        {
            return controller.User != null && controller.User.Identity.IsAuthenticated;
        }

        public static WorkContext WorkContext(this Controller controller)
        {
            try
            {
                lock (_object)
                {
                    WorkContext _workContext = null;
                    OperatorModel currentUser = null;
                    if (controller.IsAuthenticated())
                    {
                        var userSerialized = controller.User.FindFirstValue(ClaimTypes.Name);
                        currentUser = JsonConvert.DeserializeObject<OperatorModel>(userSerialized);
                        currentUser.EmployeeId = Int32.Parse(EncryptionManager.Instance.DecryptData(currentUser.EncryptedEmployeeId));
                        currentUser.OperatorId = Int32.Parse(EncryptionManager.Instance.DecryptData(currentUser.EncryptedOperatorId));
                    }
                    _workContext = new WorkContext(currentUser);
                    return _workContext;
                }
            }
            catch (Exception ex)
            {
                return null;
            }
        }
        public static WorkContext AndroidWorkContext(this Controller controller)
        {
            try
            {
                lock (_object)
                {
                    WorkContext _workContext = null;
                    AndroidOperatorModel currentUser = null;
                    if (controller.IsAuthenticated())
                    {
                        var userSerialized = controller.User.FindFirstValue(ClaimTypes.Name);
                        currentUser = JsonConvert.DeserializeObject<AndroidOperatorModel>(userSerialized);
                        currentUser.EmployeeId = Int32.Parse(EncryptionManager.Instance.DecryptData(currentUser.EncryptedEmployeeId));
                        currentUser.OperatorId = Int32.Parse(EncryptionManager.Instance.DecryptData(currentUser.EncryptedOperatorId));
                    }
                    _workContext = new WorkContext(currentUser);
                    return _workContext;
                }
            }
            catch (Exception ex)
            {
                return null;
            }
        }

        public static string GenerateToken(OperatorModel operatorModel, string HttpContextSessionId)
        {
            return GenerateToken(operatorModel, HttpContextSessionId, DateTime.Now.AddHours(SessionsConstants.TokenExpiredAfterHoursWeb));
        }
        public static string GenerateToken(OperatorModel operatorModel, string HttpContextSessionId, DateTime dateTime)
        {
            try
            {
                string securityKey = SessionsConstants.SecurityKeyWeb;
                //symmetric security key
                var symmetricSecurityKey = new SymmetricSecurityKey(Encoding.UTF8.GetBytes(securityKey));

                //signing credentials
                var signingCredentials = new SigningCredentials(symmetricSecurityKey, SecurityAlgorithms.HmacSha256Signature);

                //add claims
                var claims = new List<Claim>();
                claims.Add(new Claim(ClaimTypes.NameIdentifier, operatorModel.EncryptedEmployeeId));
                claims.Add(new Claim(ClaimTypes.Name, JsonConvert.SerializeObject(operatorModel)));
                claims.Add(new Claim(ClaimTypes.Sid, operatorModel.OperatorId + "-" + HttpContextSessionId));
                //create token
                var token = new JwtSecurityToken(
                        issuer: SessionsConstants.ValidIssuerWeb,
                        audience: SessionsConstants.ValidAudienceWeb,
                        expires: dateTime,
                        signingCredentials: signingCredentials
                        , claims: claims
                    );
                return new JwtSecurityTokenHandler().WriteToken(token);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }
        // For android login
        public static string GenerateFOToken(AndroidOperatorModel androidOperatorModel, string HttpContextSessionId, DateTime dateTime)
        {
            try
            {
                string securityKey = SessionsConstants.SecurityKeyWeb; // must change to android security key later
                //symmetric security key
                var symmetricSecurityKey = new SymmetricSecurityKey(Encoding.UTF8.GetBytes(securityKey));

                //signing credentials
                var signingCredentials = new SigningCredentials(symmetricSecurityKey, SecurityAlgorithms.HmacSha256Signature);
                // here androidOperatorModel.OperatorId + "-" + HttpContextSessionId
                //add claims
                var claims = new List<Claim>();
                claims.Add(new Claim(ClaimTypes.NameIdentifier, androidOperatorModel.EncryptedEmployeeId));
                claims.Add(new Claim(ClaimTypes.Name, JsonConvert.SerializeObject(androidOperatorModel)));
                claims.Add(new Claim(ClaimTypes.Sid, androidOperatorModel.OperatorId + "-" + HttpContextSessionId));
                //create token
                var token = new JwtSecurityToken(
                        issuer: SessionsConstants.ValidIssuerWeb,
                        audience: SessionsConstants.ValidAudienceWeb,
                        expires: dateTime,
                        signingCredentials: signingCredentials
                        , claims: claims
                    );
                return new JwtSecurityTokenHandler().WriteToken(token);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }

    }
}