﻿using Microsoft.AspNetCore.Mvc;

namespace Sonic.Web.PL.SystemModels
{
    public class JSonResponse
    {
        public JSonResponse(dynamic data, int status, string message)
        {
            this.data = data;
            this.status = status;
            this.message = message;
        }

        public dynamic data { get; set; }
        public string message { get; set; }

        /// <summary>
        /// Status is Zero --> Success, otherwise it's Error.
        /// </summary>
        public int status { get; set; }
    }

    public class JSonResultResponse
    {
        private static JSonResponse _JSonResponse;
        private static JsonResult _JsonResult;

        public static JsonResult GetErrorJSon()
        {
            return GetErrorJSon("Error happened, Please Try again later.");
        }

        public static JsonResult GetUnauthorized(string message)
        {
            _JSonResponse = new JSonResponse(null, -1, message);
            _JsonResult = new JsonResult(_JSonResponse);
            _JsonResult.ContentType = "application/json";
            _JsonResult.StatusCode = 401;
            //_JsonResult.SerializerSettings = JsonRequestBehavior.AllowGet;
            return _JsonResult;
        }

        public static JsonResult GetErrorJSon(string message)
        {
            _JSonResponse = new JSonResponse(null, -1, message);
            _JsonResult = new JsonResult(_JSonResponse);
            _JsonResult.ContentType = "application/json";
            //_JsonResult.SerializerSettings = JsonRequestBehavior.AllowGet;
            return _JsonResult;
        }
        public static JsonResult GetErrorJSon(dynamic data, string message)
        {
            _JSonResponse = new JSonResponse(data, -1, message);
            _JsonResult = new JsonResult(_JSonResponse);
            _JsonResult.ContentType = "application/json";
            //_JsonResult.SerializerSettings = JsonRequestBehavior.AllowGet;
            return _JsonResult;
        }
        public static JsonResult GetSuccessrJSon()
        {
            return GetSuccessrJSon("Success");
        }
        public static JsonResult GetSuccessrJSon(string message)
        {
            _JSonResponse = new JSonResponse(null, 0, message);
            _JsonResult = new JsonResult(_JSonResponse);
            //_JsonResult.MaxJsonLength = Int32.MaxValue;
            _JsonResult.ContentType = "application/json";
            //_JsonResult.JsonRequestBehavior = JsonRequestBehavior.AllowGet;
            return _JsonResult;
        }
        public static JsonResult GetSuccessrJSon(dynamic data, string message)
        {
            _JSonResponse = new JSonResponse(data, 0, message);
            _JsonResult = new JsonResult(_JSonResponse);
            //_JsonResult.MaxJsonLength = Int32.MaxValue;
            _JsonResult.ContentType = "application/json";
            //_JsonResult.JsonRequestBehavior = JsonRequestBehavior.AllowGet;
            return _JsonResult;
        }
    }

    public class JSonSuccessResponse
    {
        public static JSonResponse GetJSon(string message)
        {
            return new JSonResponse(null, -1, message);
        }
    }
}