﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;
using System.Linq;

namespace Sonic.Web.Resources
{
   public class ResourcesManager
   {

        public static List<LanguageCaption> Descriptions = null;
        public static string TranslateKey(string key, int languageID)
        {
            try
            {
                if (Descriptions == null)
                {
                    FillDescription();
                }

                var translatedString = Descriptions.Where(a => a.DescriptionKey == key && a.LanguageId == languageID).FirstOrDefault();

                if (translatedString != null && !string.IsNullOrEmpty(translatedString.DescriptionValue))
                {
                    return translatedString.DescriptionValue;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return key;
        }

        public static void FillDescription()
        {
            try
            {
                Descriptions = GetAllDescriptions();

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public static List<LanguageCaption> GetAllDescriptions()
        {
            List<LanguageCaption> DescriptionList = new List<LanguageCaption>();
            try
            {
                
                string query = string.Format(@" select DescriptionKey, DescriptionValue, LanguageId from SonicDescription");
                DBHelper<LanguageCaption> dBHelper = new DBHelper<LanguageCaption>();
                dBHelper.GetQueryList(query, ref DescriptionList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return DescriptionList;
        }
    }
}
