﻿using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Security.Cryptography;
using System.Text;

namespace Sonic.Web.SecureLibrary
{
    public class AESEncryption
    {
        private static AesManaged CreateAes(int employeeId)
        {
            try
            {
                string key = AESEncryptionConstants.AESEncryptionKey +  employeeId.ToString().PadLeft(10,'S'); // 16 char -> 10 for employee id and 6 for secret value
                string initVector = key;

                var aes = new AesManaged();
                aes.Key = System.Text.Encoding.UTF8.GetBytes(key);
                aes.IV = System.Text.Encoding.UTF8.GetBytes(initVector);
                return aes;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return null;
        }
        public static string EncryptDataAESE(string text, int employeeId)
        {
            try
            {
                using (AesManaged aes = CreateAes(employeeId))
                {
                    if (aes != null)
                    {
                        ICryptoTransform encryptor = aes.CreateEncryptor();
                        using (MemoryStream ms = new MemoryStream())
                        {
                            using (CryptoStream cs = new CryptoStream(ms, encryptor, CryptoStreamMode.Write))
                            {
                                using (StreamWriter sw = new StreamWriter(cs))
                                    sw.Write(text);
                                return Convert.ToBase64String(ms.ToArray());
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
            return null;
        }
    }
}