﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Data;
using System.Reflection;
using System.Text;

namespace Sonic.Web.SecureLibrary
{
    public class AccountManager
    {
        private readonly IRequestRepository _requestRepository;
        public AccountManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public GlobalErrors GetEmployeeAccountID(long employeeID, ref int accountID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                string query = "SELECT AccountID FROM AccountEmp WHERE EmployeeID = " + employeeID;

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && !field.ToString().Equals(string.Empty))
                {
                    accountID = Convert.ToInt32(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public AccountModel GetAccountInfoInformation(int accountID, DBHelper<int> dBHelper)
        {
            AccountModel account = null;
            try
            {
                string filter = string.Format(" and {0}.{1} = {2}", CoreDataBaseConstants.TableNames.Account, CoreDataBaseConstants.QueryColumnsNames.AccountID, accountID);
                Dictionary<int, AccountModel> accounts = GetAllAccounts(string.Empty, filter, dBHelper);
                if (accounts != null && accounts.ContainsKey(accountID))
                {
                    return accounts[accountID];
                }
            }
            catch (Exception ex)
            {
                account = null;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return account;
        }

        public Dictionary<int, AccountModel> GetAllAccounts(String JoinTableString, String WhereString, DBHelper<int> dBHelper)
        {
            Dictionary<int, AccountModel> accounts = null;
            DataTable dt = null;
            StringBuilder sqlQuery;
            GlobalErrors result;
            try
            {
                sqlQuery = new StringBuilder();
                sqlQuery.AppendFormat("Select " + " {0}.* , {1}.{2} {3}", CoreDataBaseConstants.TableNames.Account, CoreDataBaseConstants.TableNames.AccountLanguage, CoreDataBaseConstants.QueryColumnsNames.Description, "AccountName");
                sqlQuery.AppendFormat(" ,{0}.{1} {2} ", CoreDataBaseConstants.TableNames.AccountTypeLanguage, CoreDataBaseConstants.QueryColumnsNames.Description, CoreDataBaseConstants.QueryColumnsNames.AccountTypeDescription);
                sqlQuery.AppendFormat(" ,{0}.{1} {2} ", CoreDataBaseConstants.TableNames.CurrencyLanguage, CoreDataBaseConstants.QueryColumnsNames.Description, CoreDataBaseConstants.QueryColumnsNames.CurrencyDescription);
                sqlQuery.AppendFormat(" ,{0}.{1} {2} ", CoreDataBaseConstants.TableNames.OrganizationLanguage, CoreDataBaseConstants.QueryColumnsNames.Description, CoreDataBaseConstants.QueryColumnsNames.OrganizationDescription);
                sqlQuery.AppendFormat(" From " + " {0} left outer join {1} ", CoreDataBaseConstants.TableNames.Account, CoreDataBaseConstants.TableNames.AccountLanguage);
                sqlQuery.AppendFormat(" On " + "{0}.{2} =  {1}.{2} ", CoreDataBaseConstants.TableNames.Account, CoreDataBaseConstants.TableNames.AccountLanguage, CoreDataBaseConstants.QueryColumnsNames.AccountID);
                sqlQuery.AppendFormat(" And " + "{0}.{1} = {2} ", CoreDataBaseConstants.TableNames.AccountLanguage, CoreDataBaseConstants.QueryColumnsNames.LanguageID, 1);//CoreGeneral.Common.Language.GetCurrentLanguage().GetHashCode().ToString());
                sqlQuery.AppendFormat(" left outer join {1} on {0}.{2} =  {1}.{2} ", CoreDataBaseConstants.TableNames.Account, CoreDataBaseConstants.TableNames.CurrencyLanguage, CoreDataBaseConstants.QueryColumnsNames.CurrencyID);
                sqlQuery.AppendFormat(" And " + "{0}.{1} = {2} ", CoreDataBaseConstants.TableNames.CurrencyLanguage, CoreDataBaseConstants.QueryColumnsNames.LanguageID, 1);//CoreGeneral.Common.Language.GetCurrentLanguage().GetHashCode().ToString());
                sqlQuery.AppendFormat(" left outer join {1} on {0}.{2} =  {1}.{2} ", CoreDataBaseConstants.TableNames.Account, CoreDataBaseConstants.TableNames.AccountTypeLanguage, CoreDataBaseConstants.QueryColumnsNames.AccountTypeID);
                sqlQuery.AppendFormat(" And " + "{0}.{1} = {2} ", CoreDataBaseConstants.TableNames.AccountTypeLanguage, CoreDataBaseConstants.QueryColumnsNames.LanguageID, 1); //CoreGeneral.Common.Language.GetCurrentLanguage().GetHashCode().ToString());
                sqlQuery.AppendFormat(" left outer join {1} on {0}.{2} =  {1}.{2} ", CoreDataBaseConstants.TableNames.Account, CoreDataBaseConstants.TableNames.OrganizationLanguage, CoreDataBaseConstants.QueryColumnsNames.OrganizationID);
                sqlQuery.AppendFormat(" And " + "{0}.{1} = {2} ", CoreDataBaseConstants.TableNames.OrganizationLanguage, CoreDataBaseConstants.QueryColumnsNames.LanguageID, 1); //CoreGeneral.Common.Language.GetCurrentLanguage().GetHashCode().ToString());
                if (!JoinTableString.Equals(string.Empty) && JoinTableString != CoreDataBaseConstants.TableNames.Account)
                {
                    sqlQuery.AppendFormat(" inner join {1} on {0}.{2} =  {1}.{2} ", CoreDataBaseConstants.TableNames.Account, JoinTableString, CoreDataBaseConstants.QueryColumnsNames.AccountID);
                }
                sqlQuery.AppendFormat(" Where 1 = 1 ");
                sqlQuery.AppendFormat(" And {0}.{1} in ({2}) ", CoreDataBaseConstants.TableNames.Account, CoreDataBaseConstants.QueryColumnsNames.OrganizationID, _requestRepository.CurrentOperator.OrganizationAccess);
                sqlQuery.AppendFormat(WhereString);

                result = dBHelper.GetQueryDataTable(sqlQuery.ToString(), ref dt);
                if (result == GlobalErrors.Success && dt != null)
                {
                    accounts = GetAccountsFromDataTable(dt);
                }
            }
            catch (Exception ex)
            {
                accounts = null;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return accounts;
        }

        private Dictionary<int, AccountModel> GetAccountsFromDataTable(DataTable dt)
        {
            Dictionary<int, AccountModel> accounts = new Dictionary<int, AccountModel>();
            AccountModel Account;
            try
            {
                if (dt != null)
                {
                    foreach (DataRow row in dt.Rows)
                    {
                        Account = new AccountModel();
                        if (row[CoreDataBaseConstants.QueryColumnsNames.AccountID] != DBNull.Value)
                        {
                            Account.AccountId = Convert.ToInt32(row[CoreDataBaseConstants.QueryColumnsNames.AccountID]);
                        }
                        if (row["AccountName"] != DBNull.Value)
                        {
                            Account.AccountName = Convert.ToString(row[CoreDataBaseConstants.QueryColumnsNames.AccountName]);
                        }
                        if (row[CoreDataBaseConstants.QueryColumnsNames.OrganizationID] != DBNull.Value)
                        {
                            Account.OrganizationId = Convert.ToInt32(row[CoreDataBaseConstants.QueryColumnsNames.OrganizationID]);
                        }
                        if (row[CoreDataBaseConstants.QueryColumnsNames.AccountTypeID] != DBNull.Value)
                        {
                            Account.AccountTypeId = Convert.ToInt32(row[CoreDataBaseConstants.QueryColumnsNames.AccountTypeID]);
                        }
                        if (row[CoreDataBaseConstants.QueryColumnsNames.AccountTypeDescription] != DBNull.Value)
                        {
                            Account.TypeName = Convert.ToString(row[CoreDataBaseConstants.QueryColumnsNames.AccountTypeDescription]);
                        }
                        if (row[CoreDataBaseConstants.QueryColumnsNames.CreditLimit] != DBNull.Value)
                        {
                            Account.CreditLimit = Convert.ToDecimal(row[CoreDataBaseConstants.QueryColumnsNames.CreditLimit]);
                        }
                        if (row[CoreDataBaseConstants.QueryColumnsNames.Balance] != DBNull.Value)
                        {
                            Account.Balance = Convert.ToDecimal(row[CoreDataBaseConstants.QueryColumnsNames.Balance]);
                        }
                        if (row[CoreDataBaseConstants.QueryColumnsNames.GL] != DBNull.Value)
                        {
                            Account.GL = Convert.ToBoolean(row[CoreDataBaseConstants.QueryColumnsNames.GL]);
                        }
                        if (row[CoreDataBaseConstants.QueryColumnsNames.CurrencyID] != DBNull.Value)
                        {
                            Account.CurrencyId = Convert.ToInt32(row[CoreDataBaseConstants.QueryColumnsNames.CurrencyID]);
                        }
                        if (row[CoreDataBaseConstants.QueryColumnsNames.CurrencyDescription] != DBNull.Value)
                        {
                            Account.CurrencyName = Convert.ToString(row[CoreDataBaseConstants.QueryColumnsNames.CurrencyDescription]);
                        }
                        if (row[CoreDataBaseConstants.QueryColumnsNames.OrganizationDescription] != DBNull.Value)
                        {
                            Account.OrganizationName = Convert.ToString(row[CoreDataBaseConstants.QueryColumnsNames.OrganizationDescription]);
                        }
                        if (row[CoreDataBaseConstants.QueryColumnsNames.ParentAccountID] != DBNull.Value)
                        {
                            Account.ParentAccountId = Convert.ToInt32(row[CoreDataBaseConstants.QueryColumnsNames.ParentAccountID]);
                        }
                        accounts.Add(Account.AccountId, Account);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return accounts;
        }

        public GlobalErrors UpdateAccountBalance(int accountID, decimal amount, DateTime date, int createdBy, int postedBy, DateTime postedDate, string transactionID, DBHelper<int> dBHelper, int numberOfParents)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                if (numberOfParents <= 0)
                {
                    result = GlobalErrors.Error;
                }
                else
                {
                    numberOfParents--;
                    string query = string.Format(@"Update Account Set Balance = {2}(Balance,0) + {0} Where AccountID = {1} ", amount.ToString(), accountID.ToString(), CoreDataBaseConstants.CharactersAndDataTypes.ISNULLCheck);
                   
                    result = dBHelper.ExecuteNonQuery(query);
                    //
                    if (result == GlobalErrors.Success)
                    {
                        // Record this in the posting area for employee account
                    

                        //Update parent account if exist 
                        query = string.Format(@"Select ParentAccountID from Account Where AccountID = {0} ", accountID.ToString());
                        object value = null;
                        GlobalErrors findParentResult = dBHelper.ExecuteScalar(query, ref value);
                        if (findParentResult == GlobalErrors.Success && value != null && !value.ToString().Equals(string.Empty))
                        {
                            if (numberOfParents <= 0)
                            {
                                result = GlobalErrors.Error;
                            }
                            else
                            {
                                int parentAcountID = 0;
                                Int32.TryParse(value.ToString(), out parentAcountID);
                                if (parentAcountID != 0)
                                    result = UpdateAccountBalance(parentAcountID, amount, date, createdBy, postedBy, postedDate, transactionID, dBHelper, numberOfParents);
                            }

                        }


                    }
                }

            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
         
            return result;
        }
        public GlobalErrors UpdateAccountBalance(int accountID, decimal amount, DBHelper<int> dBHelper, int numberOfParents)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                if (numberOfParents <= 0)
                {
                    result = GlobalErrors.Error;
                }
                else
                {
                    numberOfParents--;
                    string query = string.Format(@"Update Account Set Balance = {2}(Balance,0) + {0} Where AccountID = {1} ", amount.ToString(), accountID.ToString(), CoreDataBaseConstants.CharactersAndDataTypes.ISNULLCheck);

                    result = dBHelper.ExecuteNonQuery(query);
                    //
                    if (result == GlobalErrors.Success)
                    {

                        //Update parent account if exist 
                        query = string.Format(@"Select ParentAccountID from Account Where AccountID = {0} ", accountID.ToString());
                        object value = null;
                        GlobalErrors findParentResult = dBHelper.ExecuteScalar(query, ref value);
                        if (findParentResult == GlobalErrors.Success && value != null && !value.ToString().Equals(string.Empty))
                        {
                            if (numberOfParents <= 0)
                            {
                                result = GlobalErrors.Error;
                            }
                            else
                            {
                                int parentAcountID = 0;
                                Int32.TryParse(value.ToString(), out parentAcountID);
                                if (parentAcountID != 0)
                                    result = UpdateAccountBalance(parentAcountID, amount, dBHelper, numberOfParents);
                            }

                        }
                    }
                }

            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }

            return result;
        }

        public GlobalErrors UpdateEmployeeDivisionAccountBalance(int accountID, decimal amount, DateTime date, int createdBy, int postedBy, DateTime postedDate, string transactionID, DBHelper<int> dBHelper, int numberOfParents, int divisionID,ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.Error;
            // InCubeQuery parentquery = null;
            string query;
            try
            {
                query = string.Format(@"Select AccountEmpDiv.AccountID from Account 
                inner join AccountEmpDiv on Account.AccountID = AccountEmpDiv.AccountID and  AccountEmpDiv.DivisionID = {1} Where AccountEmpDiv.ParentAccountID = {0} ", accountID.ToString(), divisionID);

                object value = null;
                result = dBHelper.ExecuteScalar(query, ref value);
                if (result == GlobalErrors.Success)
                {
                    if (value != null && !string.IsNullOrEmpty(value.ToString()))
                    {
                        int accountChildID = int.Parse(value.ToString());
                        query = string.Format(@"Update Account Set Balance = Balance + {0} Where AccountID = {1} ", amount.ToString(), accountChildID.ToString());
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                           
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_No_account_defined_for_employee_on_division;
                        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No account defined for employee on division" + divisionID,null,"",0);
                    }
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }

            return result;
        }

        public AccountModel GetEmployeeAccount(int employeeID, DBHelper<int> dbHelper)
        {
            AccountModel empAccount = null;
            Dictionary<int, AccountModel> accounts = new Dictionary<int, AccountModel>();
            try
            {
                string filter = string.Format(" And {0}.{1} = {2}", CoreDataBaseConstants.TableNames.AccountEmp, CoreDataBaseConstants.QueryColumnsNames.EmployeeID, employeeID);
                accounts = GetAllAccounts(CoreDataBaseConstants.TableNames.AccountEmp, filter, dbHelper);
                if (accounts != null && accounts.Count > 0)
                {
                    int[] keys = new int[accounts.Count];
                    accounts.Keys.CopyTo(keys, 0);
                    empAccount = accounts[keys[0]];
                }
            }
            catch (Exception ex)
            {
                empAccount = null;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return empAccount;
        }

        public GlobalErrors CreateNewAccount(AccountModel account  , DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO Account (AccountID , AccountTypeID , CreditLimit , Balance , GL , OrganizationID , CurrencyID , ParentAccountID , CommitmentLimit, CreatedBy, CreatedDate ) Values ");
                sqlStatment.Append("(");
                sqlStatment.Append(account.AccountId);
                sqlStatment.Append(",");
                sqlStatment.Append(account.AccountTypeId);
                sqlStatment.Append(",");
                sqlStatment.Append(account.CreditLimit);
                sqlStatment.Append(",");
                sqlStatment.Append(account.Balance);
                sqlStatment.Append(",");
                sqlStatment.Append(account.GL ? "1" : "0");
                sqlStatment.Append(",");
                sqlStatment.Append(account.OrganizationId);
                sqlStatment.Append(",");
                sqlStatment.Append(account.CurrencyId);
                sqlStatment.Append(",");
                sqlStatment.Append(account.ParentAccountId == -1 ?  "NULL" : account.ParentAccountId.ToString());
                sqlStatment.Append(",");
                sqlStatment.Append(account.CommitmentLimit);
                sqlStatment.Append(",");
                sqlStatment.Append(_requestRepository.CurrentOperator.EmployeeId);
                sqlStatment.Append(",");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                sqlStatment.Append(")");

                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CreateCustomerAccount(int accountId, int customerId , DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO AccountCust (CustomerID,AccountID) Values ");
                sqlStatment.Append("(");
                sqlStatment.Append(customerId);
                sqlStatment.Append(",");
                sqlStatment.Append(accountId);
                sqlStatment.Append(")");

                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CreateCustomerOutletAccount(int accountId, int customerId, int outletId ,DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO AccountCustOut (CustomerID, OutletID ,AccountID) Values ");
                sqlStatment.Append("(");
                sqlStatment.Append(customerId);
                sqlStatment.Append(",");
                sqlStatment.Append(outletId);
                sqlStatment.Append(",");
                sqlStatment.Append(accountId);
                sqlStatment.Append(")");

                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CreateCustomerOutletDivisionAccount(int accountId, int customerId, int outletId, int divisionId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO AccountCustOutDiv (CustomerID, OutletID, DivisionID, AccountID) Values ");
                sqlStatment.Append("(");
                sqlStatment.Append(customerId);
                sqlStatment.Append(",");
                sqlStatment.Append(outletId);
                sqlStatment.Append(",");
                sqlStatment.Append(divisionId);
                sqlStatment.Append(",");
                sqlStatment.Append(accountId);
                sqlStatment.Append(")");

                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors SaveAccountLanguage(int accountId, string defaultName, List<TextLanguage> descriptionLanguages, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;

                query = string.Format(@"Delete From AccountLanguage Where AccountID = {0}", accountId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                if(result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage descriptionObject in descriptionLanguages)
                    {
                        query = string.Format(@"Insert Into AccountLanguage (AccountID,LanguageID,Description) Values ({0},{1},'{2}')",
                        accountId,
                        descriptionObject.LanguageId,
                        descriptionObject.Description != null && !string.IsNullOrEmpty(descriptionObject.Description.Trim()) ? descriptionObject.Description.Trim().Replace("'", "''") : defaultName.Trim().Replace("'", "''")
                        );
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateAccountWithoutUpdateBalance(AccountModel account, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update Account Set CreditLimit = {1}, OrganizationID = {2}, CurrencyID = {3}, ParentAccountId = {4}, UpdatedBy = {5}, UpdatedDate = {6} 
                Where AccountID = {0}", 
                account.AccountId, //0
                account.CreditLimit, //1
                account.OrganizationId, //2
                account.CurrencyId, //3
                account.ParentAccountId == -1 ? "NULL" : account.ParentAccountId.ToString(), //4
                _requestRepository.CurrentOperator.EmployeeId, //5
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //6
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public int GetMaxAccountID(DBHelper<int> dBHelper)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = "Select IsNull(max(AccountID),0) + 1 maxAccountID from Account";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    return Int32.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return -1;
        }
       
        public GlobalErrors CreateEmployeeAccount(int accountId, int employeeID, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO AccountEmp (EmployeeID,AccountID) Values ");
                sqlStatment.Append("(");
                sqlStatment.Append(employeeID);
                sqlStatment.Append(",");
                sqlStatment.Append(accountId);
                sqlStatment.Append(")");

                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateTransactionRemainingAmount(DBHelper<int> dbHelper, string transactionID, long customerID, int outletID, int divisionID, TransactionType transactionTypeID, decimal paidAmount, long updatedBy, DateTime updatedDate)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                string query = string.Format(@" UPDATE {0} SET RemainingAmount = RemainingAmount - {1}, UpdatedBy = {2},UpdatedDate = {3} WHERE TransactionID= '{4}' AND  CustomerID = {5}  AND TransactionTypeID = {6} AND DivisionID = {7}",
                CoreDataBaseConstants.TableNames.Transaction, paidAmount, updatedBy, LocalUtilities.ParseDateAndTimeToSQL(updatedDate), transactionID, customerID, (int)transactionTypeID, divisionID);                
                result = dbHelper.ExecuteNonQuery(query);

                if(result == GlobalErrors.Success && transactionTypeID == TransactionType.CreditNote)
                {
                    // query to get RemainingAmount
                    object valid = null;
                    query = string.Format(@"SELECT COUNT(*) FROM {0} WHERE RemainingAmount < 0 AND TransactionID= '{1}' AND  CustomerID = {2}  AND TransactionTypeID = {3} AND DivisionID = {4}", CoreDataBaseConstants.TableNames.Transaction , transactionID, customerID, (int)transactionTypeID, divisionID);
                    result = dbHelper.ExecuteScalar(query , ref valid);
                    if(valid != null && !string.IsNullOrEmpty(valid.ToString()))
                    {
                        if(Convert.ToBoolean(valid))
                        {
                            return result = GlobalErrors.Error;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateTransactionRemainingAmountIncrease(DBHelper<int> dbHelper, string transactionId, long customerId, int outletId, int divisionId, decimal paidAmount, long updatedBy, DateTime updatedDate)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                string query = string.Format(@"Update {0} Set RemainingAmount = RemainingAmount + {1},UpdatedBy = {5},UpdatedDate = {6} Where
                TransactionID = '{2}' And CustomerID = {3} And OutletID = {4} And DivisionId = {7}",
                CoreDataBaseConstants.TableNames.Transaction,//0
                paidAmount,//1
                transactionId,//2
                customerId,//3
                outletId,//4
                _requestRepository.CurrentOperator.EmployeeId,//5
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//6
                divisionId //7
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeeDivisionAccount(int DivisionId, int EmployeeId, ref int accountId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"SELECT		Account.AccountID 
                                                FROM		AccountEmpDiv
                                                INNER JOIN  Account ON Account.AccountID = AccountEmpDiv.AccountID
                                                WHERE		 EmployeeID = {0} AND DivisionID= {1}",
                  EmployeeId,//0
                  DivisionId//1
                  );

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && !field.ToString().Equals(string.Empty))
                {
                    accountId = Convert.ToInt32(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerDivisionAccount(int DivisionId, int CustomerId, int OutletId, ref int accountId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"SELECT		Account.AccountID 
                                                FROM		AccountCustOutDiv
                                                INNER JOIN  Account ON Account.AccountID = AccountCustOutDiv.AccountID
                                                WHERE		 CustomerID = {0} AND DivisionID= {1} AND OutletID = {2} ",
                  CustomerId,   //0
                  DivisionId,   //1
                  OutletId      //2
                  );

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && !field.ToString().Equals(string.Empty))
                {
                    accountId = Convert.ToInt32(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateAccountsAfterNewTransaction(DBHelper<int> dbHelper, TransactionModel transaction,ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                // update transction account balances
                if (transaction.Outlet.Account != null)
                {
                    result = UpdateAccountBalance(transaction.Outlet.Account.AccountId, transaction.NetTotal, transaction.TransactionDate, transaction.EmployeeId, _requestRepository.CurrentOperator.EmployeeId
                        , DateTime.Now, transaction.TransactionId, dbHelper, 5);
                    if (result == GlobalErrors.Success)
                    {
                        int employeeAccountID = -1;
                        result = GetEmployeeAccountID(transaction.EmployeeId, ref employeeAccountID, dbHelper);
                        if (result == GlobalErrors.Success && employeeAccountID != -1)
                        {
                            if (
                                (!transaction.Outlet.IsCredit && transaction.SalesMode != SalesModes.CreditSales) ||
                                (transaction.Outlet.IsCredit && _requestRepository.Configurations.UpdateEmployeeBalanceOnCreditSale) ||
                                (transaction.SalesMode == SalesModes.CreditSales && !transaction.Outlet.IsCredit && _requestRepository.Configurations.UpdateEmployeeBalanceOnCreditSaleForCashCustomerOnly)
                             )
                            {
                                result = UpdateAccountBalance(employeeAccountID, transaction.NetTotal, transaction.TransactionDate, transaction.EmployeeId, _requestRepository.CurrentOperator.EmployeeId,
                                DateTime.Now, transaction.TransactionId, dbHelper, 5);
                                if (result == GlobalErrors.Success)
                                {
                                    if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && _requestRepository.Configurations.CheckCreditLimitOnEmployeeDivisionAccount)
                                    {
                                        result = UpdateEmployeeDivisionAccountBalance(employeeAccountID, transaction.NetTotal, transaction.TransactionDate, transaction.EmployeeId, _requestRepository.CurrentOperator.EmployeeId,
                                        DateTime.Now, transaction.TransactionId, dbHelper, 5, transaction.DivisionId, ref errorMessage);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetVehicleAccount(int vehicleId, ref AccountModel accountModel, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object objField = 0;
                int accountId = -1;
                string query = string.Format(@"SELECT AccountID FROM AccountVehicle WHERE VehicleID = {0}", vehicleId);
                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                {
                    accountId = int.Parse(objField.ToString());
                    accountModel = GetAccountInfoInformation(accountId, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeeDivisionAccount(int employeeId, int divisionId, ref AccountModel accountModel, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int accountId = -1;
                result = GetEmployeeDivisionAccount(divisionId, employeeId, ref accountId, dbHelper);
                if (accountId > 0)
                {
                    accountModel = GetAccountInfoInformation(accountId, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckVehicleAccount(int vehicleId, ref bool isAccountExist)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            isAccountExist = false;
            try
            {
                dbHelper = new DBHelper<int>();
                object objField = 0;

                string query = string.Format(@"SELECT AccountID FROM AccountVehicle WHERE VehicleID = {0}", vehicleId);
                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                {
                    isAccountExist = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckEmployeeAccount(int employeeID, int divisionId, ref bool isAccountExist)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            isAccountExist = false;
            try
            {
                dbHelper = new DBHelper<int>();
                object objField = 0;

                string query = string.Format(@"SELECT AccountID FROM AccountEmpDiv WHERE EmployeeID = {0} AND DivisionID = {1}", employeeID, divisionId);
                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                {
                    isAccountExist = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateRemainingAmountAndIsTransactionAffected(DBHelper<int> dbHelper, string paymentId, string transactionID, long customerID, int outletID, int divisionID, decimal paidAmount, long updatedBy, DateTime updatedDate)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@" UPDATE {0} SET RemainingAmount = RemainingAmount - {1}, UpdatedBy = {2},UpdatedDate = {3} WHERE TransactionID= '{4}' AND  CustomerID = {5} And OutletID = {6} AND DivisionID = {7}",
                CoreDataBaseConstants.TableNames.Transaction, paidAmount, updatedBy, LocalUtilities.ParseDateAndTimeToSQL(updatedDate), transactionID, customerID, outletID, divisionID);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@" UPDATE CustomerPayment SET IsTransRemainingAffected = 1 WHERE TransactionID= '{0}' AND  CustomerID = {1} And OutletId = {2} And CustomerPaymentId = '{3}' And DivisionId = {4}",
                    transactionID, customerID, outletID, paymentId, divisionID);
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
    }
}