﻿using Microsoft.AspNetCore.Mvc.ViewFeatures.Internal;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Sonic.Web.SecureLibrary
{
    public class PromotionManager
    {
        private readonly IRequestRepository _requestRepository;
        public PromotionManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }

        public List<Promotion> FillCustomerPromotions(int customerId, int outletId, bool exculdeBenifitSelectionPromotion , bool excludeTargetPromotions, bool showAchievements, int sequence, int sdcId,bool onlyProductDiscount, ItemFormProcessMode itemFormProcess, int divisionId = -1, bool includeInactive = false, int customerOrganizationId = -1)
        {
            return FillCustomerPromotions(customerId, outletId, exculdeBenifitSelectionPromotion, false, excludeTargetPromotions, showAchievements, sequence, sdcId, onlyProductDiscount,itemFormProcess, divisionId, includeInactive, customerOrganizationId);
        }
        public List<Promotion> FillCustomerPromotions(int customerId, int outletId, bool exculdeBenifitSelectionPromotion, bool isCustomerapp , bool excludeTargetPromotions, bool showEchoAchievements, int sequence, int sdcId,bool onlyProductDiscount, ItemFormProcessMode itemFormProcess, int divisionId = -1,bool includeInactive = false, int customerOrganizationId = -1)
        {
            List<Promotion> promoList = new List<Promotion>();

            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<Promotion> dbHelper = null;
            string targetPromotionsFilter = "";
            string afterPeriodJoin = "";
            string sequenceFilter = string.Empty;
            string productDiscountOnly = string.Empty;
            string echoForceOrgSelectionFilter = string.Empty;
            string customerPromotionSDCJoin = string.Empty;
            string excludeNoSalesCertainPeriod = string.Empty;
            string promotionStatusFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<Promotion>();
                string organizationFilter = string.Empty;
                string loyalityFilter = string.Empty;
                string divisionFilter = string.Empty;
                string conditionDivisionFilter = string.Empty;
                string restrictDataToCustomerOrganization = LocalUtilities.IsCRM && _requestRepository.Configurations.RestrictDataToCustomerOrganization ? $" Inner Join Division On Division.DivisionID = ItemCategory.DivisionID And Division.OrganizationId in ({customerOrganizationId})" : "";

                divisionFilter = string.Format(@" Left Join(
                                    select PromotionID from PromotionOptionDetail
                                    Inner Join Pack On Pack.PackID = PromotionOptionDetail.PackID
                                    Inner Join Item On Item.ItemID = Pack.ItemID
                                    Inner Join ItemCategory On ItemCategory.ItemCategoryID = Item.ItemCategoryID
                                    {1}
                                    Where ItemCategory.DivisionID in ({0}) And PromotionOptionDetail.PromotionOptionTypeID = 2
                                    Union
                                    select PromotionID from PromotionOptionDetail
                                    Inner Join PackGroupDetail On PackGroupDetail.PackGroupID = PromotionOptionDetail.PackGroupID
                                    Inner Join Pack On Pack.PackID = PackGroupDetail.PackID
                                    Inner Join Item On Item.ItemID = Pack.ItemID
                                    Inner Join ItemCategory On ItemCategory.ItemCategoryID = Item.ItemCategoryID
                                    {1}
                                    Where ItemCategory.DivisionID in ({0}) And PromotionOptionDetail.PromotionOptionTypeID = 2
                                    Union
                                    select PromotionID from PromotionOptionDetail
                                    where  PromotionOptionDetail.PromotionOptionTypeID = 2 and ISNULL(PackID, -1) = -1 and 
								    ISNULL(PackGroupID, -1) = -1
                                    )SelectedDivisions On SelectedDivisions.PromotionID = Promotion.PromotionID
                                    ", divisionId != -1 ? divisionId.ToString() : isCustomerapp ? _requestRepository.CurrentEchoOperator.DivisionIds :  _requestRepository.CurrentOperator.DivisionAccess, restrictDataToCustomerOrganization);
                conditionDivisionFilter = $"SelectedDivisions.PromotionID is not null and";

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    //organizationFilter = string.Format(@"  
                    //   INNER JOIN AccountCust on  AccountCust.CustomerID = {0}
                    //   INNER JOIN Account on   AccountCust.AccountID = Account.AccountID  AND (Account.OrganizationID = Promotion.OrganizationID OR Account.OrganizationID = cpo.OrganizationID)
                    //    ", customerId);
                }
                if (excludeTargetPromotions)
                {
                    targetPromotionsFilter = " AND  Promotion.PromotionType <> 4  AND  Promotion.PromotionType <> 6 AND (Promotion.RelatedToTarget is null or RelatedToTarget = 0) ";
                }
                //else {
                //    afterPeriodJoin = string.Format(@"LEFT JOIN AccumulativePromotionsHistory ACH ON ACH.PromotionID = ACH.PromotionID AND Promotion.AppliedAfterPeriod =1 AND ACH.CustomerID = {0} AND ACH.OutletID ={1} ", customerId,outletId);
                //    targetPromotionsFilter = " AND ACH.PromotionID IS NULL "; // to get after period promotions only if it is not taken (didn't exist in AccumulativePromotionsHistory table)
                //}
                string orgIds = _requestRepository.CurrentOperator.OrganizationAccess;
                if (string.IsNullOrEmpty(orgIds))
                {
                    orgIds = "SELECT OrganizationID FROM EmployeeOrganization WHERE EmployeeID = " + _requestRepository.CurrentOperator.EmployeeId;
                }
                string customerAppPromotions = string.Empty;
                string customerAppPromotionsDivFilter = string.Empty;
                if (!includeInactive)
                {
                    promotionStatusFilter = " AND (Promotion.Status = -1 )";
                }
                if (isCustomerapp)
                {
                    customerAppPromotions = " And PromotionCustomerApp.PromotionId Is Not Null ";
                    //if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    //{
                    //    echoForceOrgSelectionFilter = string.Format(@" And EmployeeOrganization.OrganizationID =  {0}", _requestRepository.CurrentOperator.OrganizationId);
                    //}
                    customerAppPromotionsDivFilter = string.Format(@" LEFT OUTER JOIN (select PromotionID from PromotionOptionDetail
                                        Inner Join Pack On Pack.PackID = PromotionOptionDetail.PackID
                                        Inner Join Item On Item.ItemID = Pack.ItemID and (Item.Inactive = 0 OR Item.Inactive IS NULL)
                                        Inner Join ItemCategory On ItemCategory.ItemCategoryID = Item.ItemCategoryID
                                        INNER JOIN ItemCategoryCustomerApp ON ItemCategoryCustomerApp.ItemCategoryId = ItemCategory.ItemCategoryId
                                        Where ItemCategory.DivisionID IN ({0}) And PromotionOptionDetail.PromotionOptionTypeID = 2) PromoDiv ON Promotion.PromotionID = PromoDiv.PromotionID ", _requestRepository.CurrentEchoOperator.DivisionIds);
                }
                //if (!showEchoAchievements && isCustomerapp)
                //{
                //    loyalityFilter = "AND  (promotion.IsLoyaltyPromotion = 0)";
                //}
                if (sequence > 1)
                    sequenceFilter = string.Format(@" and Promotion.sequence = {0}", sequence);
                else 
                {
                    if (!onlyProductDiscount)
                        productDiscountOnly = string.Format(@" and Promotion.IsProductDiscount <> 1");
                }
                if (_requestRepository.Configurations.EnableSalesDistributionChannel && sdcId > -1)
                {
                    customerPromotionSDCJoin = $@" OR ( ISNULL(CustomerPromotion.SDCID,-1) = {sdcId})";
                }
                string promotionGroupAssignmentJoin = string.Empty;
                string promotionGroupSelection = string.Empty;
                string orderByPromotionGroup = string.Empty;
                if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups) 
                {
                    promotionGroupAssignmentJoin = " LEFT JOIN PromotionGroupAssignment PGA on PGA.PromotionID = Promotion.PromotionID ";
                    promotionGroupSelection = " ,ISNULL(PGA.Priority,-1) Priority , ISNULL(PGA.PromotionGroupId,-1) PromotionGroupId ";
                    orderByPromotionGroup = " , PromotionGroupID, Priority ASC ";
                }
                // EXCLUDE THIS TYPE ON ORDERS
                if(itemFormProcess == ItemFormProcessMode.Orders || itemFormProcess == ItemFormProcessMode.Sales)
                {
                   excludeNoSalesCertainPeriod = string.Format(@" And IsNull(Promotion.NoOfInvoices,0)= 0");
                }
                string promtionQuery = string.Format(@"
                    SELECT DISTINCT Promotion.PromotionID,Promotion.IsRepeated ,Promotion.RepeatCount OriginalRepeatCount ,
                    Promotion.PromotionType,Description PromotionName, Promotion.StartDate, Promotion.EndDate, PromotionLanguage.Description PromotionName,
                    Promotion.MinValue,Promotion.RelatedToTarget,Promotion.TargetMode,Promotion.AppliedAfterPeriod,Promotion.AllowOring,
                   case when POD.PromotionID is not null  then 1 else 0 end hasFixedPrice,
                    IsNull(Promotion.Sequence,1) Sequence, Promotion.IsLoyaltyPromotion,
                    PromotionLoyaltyStatus.IsSatisfied, PromotionLoyaltyStatus.IsTaken,
                    (CASE WHEN  PromotionLoyaltyStatus.IsSatisfied = 1  AND Promotion.IsLoyaltyPromotion = 1 THEN 0 ELSE  1  END )  IsNeedToCalculateLoyalty, IsProductDiscount
                    {22}             
                    ,Promotion.SalesMode,IsNull(Promotion.NoOfInvoices,0)  NoOfInvoices 
                    FROM Promotion
                    left join PromotionLoyaltyStatus on Promotion.PromotionID = PromotionLoyaltyStatus.PromotionID and PromotionLoyaltyStatus.CustomerID = {2} and OutletID = {3}
                    INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {0} AND IsBundle = 0
                    LEFT JOIN PromotionCustomerApp on PromotionCustomerApp.PromotionId = Promotion.PromotionId
                    LEFT JOIN (SELECT DISTINCT PromotionOptionDetailTypeID,PromotionID 
                    FROM PromotionOptionDetail WHERE PromotionOptionDetailTypeID IN (28,29,30, 27, 34)) 
                    POD ON POD.PromotionID = Promotion.PromotionID
                    {13}
                
                    INNER JOIN CustomerPromotion ON
                    CustomerPromotion.PromotionID = Promotion.PromotionID
                    AND ((AllCustomers = 1)
                    OR (CustomerPromotion.CustomerID = {2} AND CustomerPromotion.OutletID = {3})
                    OR (CustomerPromotion.CustomerID = {2} AND CustomerPromotion.OutletID = -1)
                    OR (CustomerGroupID in (select GroupID from CustomerOutletGroup where CustomerID = {2} AND OutletId = {3}))
                    OR (SubChannelID in (Select SubChannelID From CustomerGroup Where CustomerGroup.GroupID  IN (select GroupID from CustomerOutletGroup where CustomerID = {2} AND OutletId = {3})))
                    {19}
                    )
                    INNER JOIN CustomerPromotionOrganization cpo ON cpo.PromotionID = Promotion.PromotionID AND cpo.OrganizationID IN ({4} {18})
                    LEFT OUTER JOIN CustomerPromotionExclusion ON Promotion.PromotionID = CustomerPromotionExclusion.PromotionID AND CustomerPromotionExclusion.CustomerID = {2} AND CustomerPromotionExclusion.OutletID = {3}              
                    {5}
                    {11}

                    {21}

                    {20}

                    WHERE
                    {12}
                    (Promotion.Inactive IS NULL OR  Promotion.Inactive = 0)
                    AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                    AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                    {7}
                    AND  (promotion.IsDeleted=0)
                    AND  (Promotion.PromotionID not in (select PromotionID from CustomerPromotionExclusion where CustomerID = {2} and OutletID = {3}))
                    {9}
                    AND  (CustomerPromotionExclusion.CustomerID is NULL AND CustomerPromotionExclusion.OutletID is NULL)
                    {25} {10} {17}  And Promotion.OfferAppliedOptions like '%{8}%' 
                    {6}

                    AND (PromotionLoyaltyStatus.IsTaken is null or PromotionLoyaltyStatus.IsTaken = 0)
                    AND(
					  (
						Promotion.IsLoyaltyPromotion = 1 AND 
						PromotionType in ({14}) AND 
						IsNull(Promotion.IsRepeated,0) = 0 AND
						 LoyaltyModeID != {15} AND 
						 (
						   (
		                        IsNull(PromotionLoyaltyStatus.IsSatisfied,0) = 0  AND  
		                        Promotion.StartDate <=   {1}   AND 
		                        Promotion.EndDate >=   {1}  
	                        ) OR
	                        (
		                        PromotionLoyaltyStatus.IsSatisfied = 1  AND 
		                        Promotion.StartDate <=   {1}  AND 
		                        DATEADD(day, Promotion.LoyalityWidth, Promotion.EndDate) >=   {1}  
	                        )
						 )
					  ) OR 
					  (
						Promotion.IsLoyaltyPromotion = 1 AND 
						PromotionType in ({16}) AND 
						PromotionLoyaltyStatus.IsSatisfied = 1 AND 
						LoyaltyModeID != {15} AND 
						(
		                    Promotion.EndDate <  {1}  OR
		                    DATEADD(day, Promotion.LoyalityWidth, Promotion.EndDate) >=  {1}  
	                    )
					  ) OR 
					  
					  ( IsNull(Promotion.IsLoyaltyPromotion,0) = 0 
					  
					      AND  (Promotion.StartDate <=   {1} )
                         AND  ((Promotion.EndDate   >=   {1}  AND Promotion.AppliedAfterPeriod = 0 {24}) OR ( {1}  > Promotion.EndDate AND Promotion.AppliedAfterPeriod = 1) )
					 
					 ) 

					)
                    order by hasFixedPrice desc {23}",
                    _requestRepository.LanguageId, //0
                    LocalUtilities.ParseDateToSQLString(DateTime.Now),//1
                    customerId,//2
                    outletId,//3
                    orgIds,//4
                    organizationFilter,//5
                    customerAppPromotions,//6
                    targetPromotionsFilter,//7
                    isCustomerapp || showEchoAchievements ? OfferAppliedOptions.CustomerApp.GetHashCode() : OfferAppliedOptions.Sonic.GetHashCode(),//8
                    loyalityFilter, //9
                    sequenceFilter, //10
                    divisionFilter, //11
                    conditionDivisionFilter, //12
                    afterPeriodJoin, //13
                    PromotionTypes.FixedValues.GetHashCode(), //14
                    LoyaltyModes.PointsLoyaltyPromotion.GetHashCode(), //15
                    PromotionTypes.RangeValues.GetHashCode(), //16
                    productDiscountOnly, //17
                    echoForceOrgSelectionFilter, //18
                    customerPromotionSDCJoin, //19
                    customerAppPromotionsDivFilter, //20
                    promotionGroupAssignmentJoin, //21
                    promotionGroupSelection, //22
                    orderByPromotionGroup, //23
                    excludeNoSalesCertainPeriod, // 24
                    promotionStatusFilter //25
                );
                result = dbHelper.GetQueryList(promtionQuery, ref promoList);
                if (result == GlobalErrors.Success && promoList.Count > 0)
                {
                    foreach (Promotion promotion in promoList)
                    {
                        GetPromotionInputsAndOutputs(promotion, customerId, outletId, exculdeBenifitSelectionPromotion,divisionId);
                        if (isCustomerapp)
                        {
                            //Offer List screen --> Take offer btn appears only when promotion define as a single input (item quantity)  or range from one item.
                            int inputItemId = -1;
                            promotion.AllowAddPromotionToBasket = false;

                            if (!(promotion.PromotionInputs.FindAll(option => option.PromotionOptionDetails.Count > 1).Count > 0))
                            {

                                if (promotion.PromotionInputs.FindAll(d => d.PromotionOptionDetails.Any(m => m.InputOptionDetailTypeId == PromotionInputDetailTypes.ItemQuantity)).ToList().Count == promotion.PromotionInputs.Count)
                                {
                                    if (promotion.PromotionInputs.Count > 0)
                                    {
                                        if (promotion.PromotionInputs[0].PromotionOptionDetails[0].ItemId != -1)
                                        {
                                            inputItemId = promotion.PromotionInputs[0].PromotionOptionDetails[0].ItemId;
                                            if (promotion.PromotionInputs.FindAll(m => m.PromotionOptionDetails.Any(option => option.ItemId == inputItemId)).ToList().Count == promotion.PromotionInputs.Count)
                                                //this to show take promotion in customer app 3.0.1
                                                //this get if promotion get one input and one option and option InputOptionDetailTypeId = ItemQuantity
                                                promotion.AllowAddPromotionToBasket = true;
                                        }

                                    }
                                }
                            }

                            if (promotion.PromotionType == PromotionTypes.FixedValues)
                            {
                                foreach (var input in promotion.PromotionInputs)
                                {
                                    if ((input.PromotionOptionDetails.Where(x => x.InputOptionDetailTypeId == PromotionInputDetailTypes.ItemQuantity).ToList().Count() == input.PromotionOptionDetails.Count()))
                                    {
                                        //this to show take promotion in customer app 4.0.1
                                        input.ShowTakePromotionOption = true;
                                    }
                                }
                            }
                            if(promotion.PromotionInputs.Count == 1 && promotion.PromotionInputs[0].ShowTakePromotionOption)
                            {
                                promotion.ShowTakePromotionOption = true;
                            }

                            if (!(promotion.PromotionInputs.Count == 1 && promotion.PromotionOutputs.Count == 1 ))
                            {
                                promotion.ShowReadMoreOption = true;
                            }

                            if (promotion.PromotionType == PromotionTypes.TargetPromotion ||
                               promotion.PromotionType == PromotionTypes.SimpleTargetPromotion ||
                               promotion.PromotionType == PromotionTypes.DynamicTargetPromotion)
                            {
                                decimal Percantage = 0;
                                decimal Reminder = 0;
                                result = GetTargetPromotion(promotion, ref Percantage, ref Reminder);
                                if (result == GlobalErrors.Success)
                                {
                                    promotion.AchievementPercantage = Percantage;
                                    promotion.AchievementReminder = Reminder;
                                }
                            }
                           
                               

                            string path = Path.Combine(Directory.GetCurrentDirectory(), string.Format("wwwroot\\img\\Echo\\promotions\\{0}", promotion.PromotionId));
                            if (Directory.Exists(path))
                            {
                                var list = Directory.GetFiles(path);
                                if (list != null && list.Length > 0)
                                {
                                    list.ToList().ForEach(i =>
                                    {
                                        promotion.ImageList.Add(Path.GetFileName(i));
                                    });
                                }
                            }
                        }
                    }
                    promoList.RemoveAll(a => a.PromotionInputs.Count == 0);
                    //if (exculdeBenifitSelectionPromotion)
                    promoList.RemoveAll(a => a.PromotionOutputs.Count == 0);

                    
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                promoList = null;
            }
            return promoList;
        }

        public List<RelatedToTargetPromotion> CheckAfterPeriodPromotion(int customerId , int outletId ,string transactionID ,bool isPartialDelivery ,string promotionIDs)
        {
            DBHelper<RelatedToTargetPromotion> dbHelper;
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<RelatedToTargetPromotion> promotions=  new List<RelatedToTargetPromotion>();
            string partialDelFilter = "";
            try
            {
                if (isPartialDelivery && transactionID != "")
                {
                    partialDelFilter = string.Format(" AND APH.TransactionID <> '{0}'", transactionID);
                }
                dbHelper = new DBHelper<RelatedToTargetPromotion>();
                string query = string.Format(@"Select CPA.CustomerID , CPA.OutletID , CPA.PromotionID , OptionDetailID PromotionOptionDetailId, OptionDetailTypeID PromotionOptionDetailTypeId, ReferenceOptionDetailID ReferenceOptionId, PackID , PackGroupID , OptionTargetValue, AchievedValue ,TotalAchievedValue ,CPA.LastInvoiceDate ,IsSatisfied, Benefit ,BenefitDetailTypeID BenefitOptionDetailTypeID ,AchievedValueAmount , AchievedValueVolume ,BenefitAchievedValue FROM CustomerPromotionsAccumulation CPA 
                        LEFT JOIN AccumulativePromotionsHistory APH 
                        ON CPA.CustomerID = APH.CustomerID AND (CPA.OutletID = APH.OutletID OR CPA.OutletID = -1) AND CPA.PromotionID = APH.PromotionID {3}
                        WHERE APH.PromotionID IS NULL AND  CPA.CustomerID = {0} AND (CPA.OutletID = {1} OR CPA.OutletID = -1) AND CPA.PromotionID in ({2}) 
                                        ", customerId, outletId, promotionIDs, partialDelFilter);

                result = dbHelper.GetQueryList(query, ref promotions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return promotions; 
        }

        public GlobalErrors GetTargetPromotion(Promotion promotion, ref decimal Percantage, ref decimal Reminder)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            DBHelper<object> dbHelper2 = null;
            string query = string.Empty;
            decimal AchievementValue = 0;
            decimal AchievementTarget = 0;

            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper2 = new DBHelper<object>();
                int achievementID = 0;
                query = string.Format(@"SELECT top 1 AchievementID FROM PromotionCustomerAchievement 
                    where CustomerID = {0} and OutletID = {1} and PromotionID = {2}", _requestRepository
                    .CurrentEchoOperator.CustomerId, _requestRepository.CurrentEchoOperator.OutletId, promotion.PromotionId);
                result = dbHelper.GetQuerySingle(query, ref achievementID);
                
                if(result == GlobalErrors.Success)
                {
                    if(achievementID == AchievementValues.DynamicSalesPerPackGroupPerCustomer.GetHashCode() ||
                        achievementID == AchievementValues.Monthlysoldquantityfrompackgroup.GetHashCode())
                    {
                        promotion.IsQuantity = true;
                    }
                    else if(achievementID == AchievementValues.MonthlySalesAmount.GetHashCode() ||
                        achievementID == AchievementValues.DynamicSalesAmountPerCustomer.GetHashCode())
                    {
                        promotion.IsAmount = true;
                    }
                    object achievementValueObj = null;
                    query = string.Format(@"SELECT ISNULL(AC.Value, 0) AS AchievementValue
                        FROM AchievementTargetCustomer AS ATC LEFT OUTER JOIN
	                            AchievementCustomer AS AC ON AC.AchievementID = ATC.AchievementID 
		                        AND AC.CustomerID = ATC.CustomerID 
		                        AND AC.OutletID = ATC.OutletID 
		                        AND AC.TargetID = ATC.TargetID INNER JOIN
                                PromotionCustomerAchievement AS PCA ON ATC.TargetID = PCA.TargetID
		                        AND ATC.CustomerID = PCA.CustomerID AND ATC.OutletID = PCA.OutletID 
		                        AND ATC.AchievementID = PCA.AchievementID
                        WHERE  (ATC.CustomerID = {0}) AND (ATC.OutletID = {1}) And (ATC.AchievementID = {2}) AND (PCA.PromotionID = {3}) AND (GETDATE() >= CONVERT(datetime, ATC.FromDate, 102)) AND (GETDATE() <= CONVERT(datetime, ATC.ToDate, 102))", 
                        _requestRepository .CurrentEchoOperator.CustomerId, //0
                        _requestRepository.CurrentEchoOperator.OutletId, //1
                        achievementID, //2
                        promotion.PromotionId//3
                        );
                    result = dbHelper2.ExecuteScalar(query, ref achievementValueObj);
               
                    if(result == GlobalErrors.Success && promotion != null)
                    {

                        AchievementValue = achievementValueObj != null ? (decimal)achievementValueObj : 0;
                        if (promotion.PromotionInputs.Count > 0)
                        {
                            for (int i = promotion.PromotionInputs.Count -1 ; i >= 0; i--)
                            {
                                if(AchievementValue < promotion.PromotionInputs[i].PromotionOptionDetails[0].Value)
                                {
                                    AchievementTarget = promotion.PromotionInputs[i].PromotionOptionDetails[0].Value;
                                    Percantage = (AchievementValue / AchievementTarget) * 100;
                                    Reminder = AchievementTarget - AchievementValue;

                                }
                               
                                else
                                {
                                    Percantage = 100;
                                    Reminder = 0;
                                }
                            }
                         
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
              
            }
            return result;
        }
        public List<RelatedToTargetPromotion> checkIfIsLastInvoiceAccumuoativePromoted(List<Promotion> lastinvoiceAccumulative , bool isPartialDelivery , string OrderId)
        {
            DBHelper<AccumulativePromotionsHistoryModel> dbHelber = new DBHelper<AccumulativePromotionsHistoryModel>();
            RelatedToTargetPromotion relatedToTargetPromotionAccLastInv = new RelatedToTargetPromotion();
            List<RelatedToTargetPromotion> relatedToTargetAccLastInvList = new List<RelatedToTargetPromotion>();
            string query = "";
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object field = null;
            string PartialDeliveryFilter ="";
            try
            {
                List<AccumulativePromotionsHistoryModel> historyList;
                historyList = new List<AccumulativePromotionsHistoryModel>();
                if (isPartialDelivery)
                {
                    query = string.Format("Select TransactionID FROM [Transaction] Where SourceTransactionID = '{0}' and voided <> 1 ", OrderId);
                    result = dbHelber.ExecuteScalar(query , ref field);
                    if (result == GlobalErrors.Success && field != null && field.ToString() != "")
                    {
                        PartialDeliveryFilter = string.Format(" AND T.TransactionID <> '{0}'", field.ToString());
                    }
                }
                lastinvoiceAccumulative.ForEach(x =>
                {
                    query = string.Format(@"Select PH.CustomerId,PH.OutletId,PH.PromotionId,PH.TransactionId,INPUT.PromotionOptionDetailID InputDetailId,PH.PromotionOptionDetailID OutputDetailId,LastInvoiceDate,BenefitValue ,
Output.Value BenefitPercentage ,
INPUT.PromotionOptionDetailTypeID InputTypeID ,
Output.PromotionOptionDetailTypeID OutputTypeID  from AccumulativePromotionsHistory PH INNER JOIN [Transaction] T ON PH.TransactionID = T.TransactionID
INNER JOIN PromotionOptionDetail INPUT ON PH.PromotionID = INPUT.PromotionID AND PH.PromotionOptionID = INPUT.ReferenceOptionID 
INNER JOIN PromotionOptionDetail Output ON PH.PromotionID = Output.PromotionID AND PH.PromotionOptionID = Output.PromotionOptionID " +
" WHERE PH.PromotionID = {0} AND TransactionDate >= {1} AND TransactionDate <= {2} {3}", x.PromotionId, LocalUtilities.ParseDateToSQLString(x.StartDate), LocalUtilities.ParseDateToSQLString(x.EndDate) , PartialDeliveryFilter);
                    result = dbHelber.GetQueryList(query, ref historyList);
                    if (result == GlobalErrors.Success && historyList != null && historyList.Count() > 0)
                    {
                        relatedToTargetPromotionAccLastInv = new RelatedToTargetPromotion();
                        x.IsPromoted = true;
                        x.IsSatisfied = true;
                        relatedToTargetPromotionAccLastInv.IsSatisfied = true;
                        relatedToTargetPromotionAccLastInv.ReferenceOptionId = historyList[0].OutputDetailId;
                        relatedToTargetPromotionAccLastInv.PromotionOptionDetailId = historyList[0].InputDetailId;
                        relatedToTargetPromotionAccLastInv.PromotionOptionDetailTypeId = historyList[0].InputTypeID;
                        relatedToTargetPromotionAccLastInv.BenefitOptionDetailTypeID = historyList[0].OutputTypeID;
                        relatedToTargetPromotionAccLastInv.PromotionId = historyList[0].PromotionID;
                        relatedToTargetPromotionAccLastInv.Benefit = historyList[0].BenefitPercentage;
                        relatedToTargetAccLastInvList.Add(relatedToTargetPromotionAccLastInv);
                    }
                });
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return relatedToTargetAccLastInvList;
        }

        public void FillDescriptions(List<RelatedToTargetPromotion> promotionSatisfiedOptions, Promotion promotion , TransactionCommonData transactionCommonData)
        {
            string outputDtlDesc = "", firstPart = "", secondPart = "", newDescription = "", oldDescription = "";
            int noOfDigits = 0;bool isPG = false;
            decimal groupAmount = 0;
            decimal amount = 0;
            decimal newBenefit = 0;
            string afterPeriod = "";
            decimal invoiceValue = 0;
            decimal itemAmount = 0;
            try {
                // suppose that the outputs of the promotion are similar .
                foreach (RelatedToTargetPromotion t in promotionSatisfiedOptions) {
                    switch ((PromotionOutputDetailTypes) t.BenefitOptionDetailTypeID)
                    {
                        case PromotionOutputDetailTypes.AllItemDiscountPercentage:
                        case PromotionOutputDetailTypes.DiscountPercentageForItem:
                        case PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount:
                        case PromotionOutputDetailTypes.DiscountPercentageForGroupItems:
                        case PromotionOutputDetailTypes.DiscountAmountOverGroup:
                        case PromotionOutputDetailTypes.DiscountAmountOverTransaction:
                            noOfDigits = _requestRepository.Configurations.NumberOfDigits;
                            break;
                        case PromotionOutputDetailTypes.SummationOverGroup:
                            noOfDigits = _requestRepository.Configurations.NumberOfStockDigits;
                            break;
                    }
                    PromotionOutputDetailTypes promotionOutputType = (PromotionOutputDetailTypes) promotion.PromotionOutputs.Find(x => x.PromotionOptionId == t.ReferenceOptionId).PromotionOptionDetails[0].PromotionOptionDetailTypeId;
                    if (promotion.AppliedAfterPeriod)
                    {
                        // we should change the benefit value according to the current total : 
                        groupAmount = 0;
                        amount = t.AchievedValueAmount * t.Benefit / 100;
                        switch (promotionOutputType)
                        {
                            case PromotionOutputDetailTypes.AllItemDiscountPercentage:
                                invoiceValue = transactionCommonData.SoldItems.Sum(pack => pack.GrossTotal - (pack.GrossTotal * pack.Discount / 100));
                                newBenefit = (t.AchievedValueAmount * t.Benefit / 100) / invoiceValue * 100;
                                afterPeriod = "\n" + ResourcesManager.TranslateKey(MessagesConstants.Desc_Total_Achieved_Value_Of, _requestRepository.LanguageId) + string.Format("({0})", decimal.Round(t.AchievedValueAmount, noOfDigits));
                                break;
                            case PromotionOutputDetailTypes.DiscountPercentageForGroupItems:
                            case PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount:
                                groupAmount = CalculateAmountOverPackGroup(transactionCommonData, promotion.PromotionOutputs.Find(x => x.PromotionOptionId == t.ReferenceOptionId).PromotionOptionDetails[0],true, transactionCommonData.SoldItems);
                                if (groupAmount > 0)
                                    newBenefit = (t.BenefitAchievedValue * t.Benefit / 100) / groupAmount * 100;
                                afterPeriod = "\n" + ResourcesManager.TranslateKey(MessagesConstants.Desc_Total_Achieved_Value_Of, _requestRepository.LanguageId) + string.Format("({0})", decimal.Round(t.BenefitAchievedValue, noOfDigits));
                                break;
                            case PromotionOutputDetailTypes.DiscountPercentageForItem:
                                if (_requestRepository.Configurations.AllowConversionInPromotion)
                                {
                                    //var soldPacksFromItem = transactionCommonData.SoldItems.Where(a => a.ItemId == promotion.PromotionOutputs.Find(x => x.PromotionOptionId == t.ReferenceOptionId).PromotionOptionDetails[0].ItemId).ToList();
                                    itemAmount = transactionCommonData.SoldItems.Where(a => a.ItemId == promotion.PromotionOutputs.Find(x => x.PromotionOptionId == t.ReferenceOptionId).PromotionOptionDetails[0].ItemId).ToList().Sum(p => p.GrossTotal);
                                    //foreach (var pack in soldPacksFromItem)
                                    //{
                                    //    itemAmount = itemAmount + pack.GrossTotal;
                                    //}
                                    afterPeriod = "\n" + ResourcesManager.TranslateKey(MessagesConstants.Desc_Total_Achieved_Value_Of, _requestRepository.LanguageId) + string.Format("({0})", decimal.Round(t.BenefitAchievedValue, noOfDigits));
                                }
                                else
                                {
                                    itemAmount = transactionCommonData.SoldItems.Where(a => a.ItemId == promotion.PromotionOutputs.Find(x => x.PromotionOptionId == t.ReferenceOptionId).PromotionOptionDetails[0].ItemId && a.PackId == promotion.PromotionOutputs.Find(x => x.PromotionOptionId == t.ReferenceOptionId).PromotionOptionDetails[0].PackId).ToList().Sum(p => p.GrossTotal);
                                }
                                if (itemAmount > 0)
                                    newBenefit = (t.BenefitAchievedValue * t.Benefit / 100) / itemAmount * 100;
                                break;
                        }
                        if (t.Benefit > 100)
                            t.Benefit = 0;//when the promotion is after period ,and this invoice can't carry out the benefit , don't get the promotion at this invoice , when it is not after period , then the procedure will set the benefit as 100 if it is > 100
                    }
                    else
                    {
                        newBenefit = t.Benefit;
                    }
                    oldDescription = promotion.PromotionOutputs.Find(x => x.PromotionOptionId == t.ReferenceOptionId).PromotionOptionDetails[0].Description;
                    outputDtlDesc = oldDescription;
                    isPG = outputDtlDesc.Count(f => f == ')') > 1;
                    firstPart = outputDtlDesc.Split(")")[0];
                    secondPart = outputDtlDesc.Split(')')[1];
                    newDescription = "(" + decimal.Round(t.Benefit, noOfDigits) + ")" + secondPart;
                    if (isPG)
                     newDescription +=")";
                    if (promotion.AppliedAfterPeriod)
                    {
                        newDescription = newDescription + afterPeriod;
                    }
                    t.Benefit = newBenefit; 
                    if (promotion.AllowOring)
                        t.NewBenefitDescription = oldDescription;
                    else
                        t.NewBenefitDescription = newDescription;
                }
                promotionSatisfiedOptions.RemoveAll(x => x.Benefit <= 0);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public GlobalErrors GetSatisfiedPromotionsData(ref List<RelatedToTargetPromotion> RelatedToTargetPromotions , int customerId , int outletId, List<Promotion> PromotedLastinvoiceAccumulative)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<RelatedToTargetPromotion> dBHelper;
            string PromotedLastinvoiceAccumulativeString = "";
            string lastInvAccFilter = "";
            string query;
            try {
                dBHelper = new DBHelper<RelatedToTargetPromotion>();
                RelatedToTargetPromotions = new List<RelatedToTargetPromotion>();
                if (PromotedLastinvoiceAccumulative != null && PromotedLastinvoiceAccumulative.Count() > 0)
                {
                    PromotedLastinvoiceAccumulative.ForEach(x =>
                    {
                        PromotedLastinvoiceAccumulativeString = x.PromotionId + ",";
                    });
                    PromotedLastinvoiceAccumulativeString = PromotedLastinvoiceAccumulativeString.Substring(0, PromotedLastinvoiceAccumulativeString.Length - 1);
                }
                if (!PromotedLastinvoiceAccumulativeString.Equals(""))
                {
                    lastInvAccFilter = " AND PromotionID Not IN ({0}) ";
                }
                query = string.Format("Select * From CustomerPromotionsAccumulation Where isSatisfied =1 And CustomerID = {0} AND OutletID = {1} {2} Order By OptionTargetValue DESC ",customerId , outletId, lastInvAccFilter);
                result = dBHelper.GetQueryList(query, ref RelatedToTargetPromotions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public List<Promotion> orderSatisfiedPromotions(List<Promotion> customerPromotions)
        {
            List<Promotion> orderedSatisfiedPromotions = new List<Promotion>();
            List<Promotion> targetsSatisfiedPromotions = new List<Promotion>();
            List<Promotion> otherSatisfiedPromotions = new List<Promotion>();
            List<Promotion> relatedToTargetPromotions = new List<Promotion>();
            try
            {
                if (customerPromotions != null && customerPromotions.Count > 0)
                {
                    foreach (Promotion currentPromotion in customerPromotions)
                    {
                        switch (currentPromotion.PromotionType)
                        {
                            case PromotionTypes.TargetPromotion:
                            case PromotionTypes.DynamicTargetPromotion:
                                targetsSatisfiedPromotions.Add(currentPromotion);
                                break;
                            default:
                                if (currentPromotion.RelatedToTarget)
                                    relatedToTargetPromotions.Add(currentPromotion);
                                else
                                    otherSatisfiedPromotions.Add(currentPromotion);
                                break;
                        }
                    }
                    orderedSatisfiedPromotions.AddRange(relatedToTargetPromotions);
                    orderedSatisfiedPromotions.AddRange(otherSatisfiedPromotions);
                    orderedSatisfiedPromotions.AddRange(targetsSatisfiedPromotions);
                }
                return orderedSatisfiedPromotions;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
            finally
            {
                if (orderedSatisfiedPromotions != null)
                {
                    orderedSatisfiedPromotions = null;
                }
                if (targetsSatisfiedPromotions != null)
                {
                    targetsSatisfiedPromotions = null;
                }
                if (otherSatisfiedPromotions != null)
                {
                    otherSatisfiedPromotions = null;
                }
            }
        }

        public List<Promotion> FillOrderPromotions(TransactionCommonData transationCommonData, bool fromCustomerApp,bool justAchievement, int sdcId )
        {
            List<Promotion> promoList = new List<Promotion>();

            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<Promotion> dbHelper = null;
            string organizationFilter = string.Empty;
            string sequence = string.Empty;
            string productDiscountOnly = string.Empty;
            string customerPromotionSDCJoin = string.Empty;
            string promotionStatusFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<Promotion>();
                StringBuilder queryString = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    organizationFilter = string.Format(@"  
                       INNER JOIN AccountCust on  AccountCust.CustomerID = {0}
                       INNER JOIN Account on   AccountCust.AccountID = Account.AccountID  AND (Account.OrganizationID = Promotion.OrganizationID OR Account.OrganizationID = cpo.OrganizationID)
                        ", transationCommonData.CustomerId);
                }
                if(!transationCommonData.IncludeInActive)
                {
                    promotionStatusFilter = " AND (Promotion.Status = -1 )";
                }
                //if (transationCommonData.Outlet.CustomerGroupsIDs != null && outlet.CustomerGroupsIDs.Count > 0)
                //{
                //    groupQuery = string.Format(" OR (CustomerGroupID IN ({0})) ", outlet.GetOutletGroupsString());
                //    groupQuery += string.Format(" OR (CustomerPromotion.SubChannelID in (Select SubChannelID from CustomerGroup where CustomerGroup.GroupID IN ({0}))) ", outlet.GetOutletGroupsString());
                //}
                if(transationCommonData.PromotionLevelId > 1)
                {
                    sequence = string.Format(@" and Promotion.Sequence = {0}", transationCommonData.PromotionLevelId);
                }
                else 
                {
                    if (!transationCommonData.OnlyProductDiscount)
                        productDiscountOnly = string.Format(@" and Promotion.IsProductDiscount <> 1");
                }
                if (_requestRepository.Configurations.EnableSalesDistributionChannel && sdcId > -1) 
                {
                    customerPromotionSDCJoin = $@" OR ( ISNULL(CustomerPromotion.SDCID,-1) = {sdcId})";
                }
                string AchievementPromotionsAndLoyaltyQuery = string.Format(@"SELECT DISTINCT Promotion.PromotionID,Promotion.IsRepeated ,Promotion.RepeatCount OriginalRepeatCount ,Promotion.PromotionType,Description PromotionName, Promotion.StartDate, Promotion.EndDate, Promotion.MinValue, Promotion.PromotionLevel,Promotion.RelatedToTarget,Promotion.TargetMode,Promotion.AppliedAfterPeriod,Promotion.AllowOring,Promotion.MaxLimit,Promotion.ResetLastInvRem,
                    Promotion.IsLoyaltyPromotion, PromotionLoyaltyStatus.IsSatisfied, PromotionLoyaltyStatus.IsTaken, 
                    (CASE WHEN  PromotionLoyaltyStatus.IsSatisfied = 1 and Promotion.IsLoyaltyPromotion = 1 THEN 0 ELSE  1  END ) IsNeedToCalculateLoyalty, IsProductDiscount  ,Promotion.SalesMode,IsNull(Promotion.NoOfInvoices,0)  NoOfInvoices 
                    ,Sequence FROM Promotion
                    INNER JOIN CustomerPromotion ON
                    CustomerPromotion.PromotionID = Promotion.PromotionID
                    AND ((AllCustomers = 1)
                    OR (CustomerPromotion.CustomerID = {2} AND (CustomerPromotion.OutletID = {3}  OR (CustomerPromotion.OutletID = -1 AND Promotion.PromotionLevel = {9})))
                    OR (CustomerGroupID in (select GroupID from CustomerOutletGroup where CustomerID = {2} AND OutletId = {3}))
                    OR (SubChannelID in (Select SubChannelID From CustomerGroup Where CustomerGroup.GroupID  IN (select GroupID from CustomerOutletGroup where CustomerID = {2} AND OutletId = {3})))
                    {16}
                    )
                    INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {0}
                    INNER JOIN CustomerPromotionOrganization cpo ON cpo.PromotionID = Promotion.PromotionID AND cpo.OrganizationID IN ({4})
                    LEFT OUTER JOIN CustomerPromotionExclusion ON Promotion.PromotionID = CustomerPromotionExclusion.PromotionID AND CustomerPromotionExclusion.CustomerID = {2} AND CustomerPromotionExclusion.OutletID = {3}
                    --LEFT JOIN AccumulativePromotionsHistory ACH ON ACH.PromotionID = ACH.PromotionID AND Promotion.AppliedAfterPeriod =1 AND ACH.CustomerID = {2} AND ACH.OutletID ={3}                 
                    {8}
                    left join PromotionLoyaltyStatus on Promotion.PromotionID = PromotionLoyaltyStatus.PromotionID and PromotionLoyaltyStatus.CustomerID = {2} and PromotionLoyaltyStatus.OutletID = {3} 
                    WHERE (Promotion.Inactive IS NULL OR  Promotion.Inactive = 0)
                    AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                    AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                    AND  (Promotion.IsBundle = 0 ) 
                    AND  (promotion.IsDeleted=0)
                    AND  (Promotion.PromotionID not in (select PromotionID from CustomerPromotionExclusion where CustomerID = {2} 
                          and  ((OutletID = {3} and promotion.PromotionLevel = {15}) OR (OutletID = -1 and promotion.PromotionLevel = {9}))   )
                         )
                    AND  (CustomerPromotionExclusion.CustomerID is NULL AND CustomerPromotionExclusion.OutletID is NULL)
                    
                   {17}
                    AND (PromotionLoyaltyStatus.IsTaken is null or PromotionLoyaltyStatus.IsTaken = 0)
                    
                    AND(
					(
						Promotion.IsLoyaltyPromotion = 1 AND 
						PromotionType in ({11}) AND 
						IsNull(Promotion.IsRepeated,0) = 0 AND
							LoyaltyModeID != {12} AND 
							(
							(
								IsNull(PromotionLoyaltyStatus.IsSatisfied,0) = 0  AND  
								Promotion.StartDate <= {1} AND 
								Promotion.EndDate >= {1} 
							) OR
							(
								PromotionLoyaltyStatus.IsSatisfied = 1  AND 
								Promotion.StartDate <= {1} AND 
								DATEADD(day, Promotion.LoyalityWidth, Promotion.EndDate) >=  {1}
							)
							)
						) OR 
						(
							Promotion.IsLoyaltyPromotion = 1 AND 
							PromotionType in ({13}) AND 
							PromotionLoyaltyStatus.IsSatisfied = 1 AND 
							LoyaltyModeID != {12} AND 
							(
								Promotion.EndDate < {1}   OR
								DATEADD(day, Promotion.LoyalityWidth, Promotion.EndDate) >= {1}  
							)
					) OR 
					  
						( 
							IsNull(Promotion.IsLoyaltyPromotion,0) = 0 
					  
							AND (Promotion.StartDate <= {1} )
							AND ((Promotion.EndDate >= {1} AND Promotion.AppliedAfterPeriod = 0) OR ( {1}  > Promotion.EndDate AND Promotion.AppliedAfterPeriod = 1) )
							AND  (Promotion.PromotionType in ({5}, {6}, {7}) OR Promotion.RelatedToTarget =1 or IsNull(Promotion.NoOfInvoices,0) > 0)
						
						) 
					)
                   {10} {14}
                    ",
                _requestRepository.LanguageId, //0
                LocalUtilities.ParseDateToSQLString(DateTime.Now), //1
                transationCommonData.CustomerId, //2
                transationCommonData.OutletId, //3
                fromCustomerApp ? _requestRepository.CurrentEchoOperator.RouteOrganizationIds : _requestRepository.CurrentOperator.OrganizationAccess, //4
                PromotionTypes.SimpleTargetPromotion.GetHashCode(), //5
                PromotionTypes.TargetPromotion.GetHashCode() + "", //6
                PromotionTypes.DynamicTargetPromotion.GetHashCode() + "", //7
                organizationFilter, //8
                PromotionLevel.CustomerLevel.GetHashCode(), //9
                sequence, //10
                PromotionTypes.FixedValues.GetHashCode(), //11
                LoyaltyModes.PointsLoyaltyPromotion.GetHashCode(), //12
                PromotionTypes.RangeValues.GetHashCode(), //13
                productDiscountOnly, //14
                PromotionLevel.OutletLevel.GetHashCode(), //15
                customerPromotionSDCJoin, //16 
                promotionStatusFilter
                );
                queryString.Append(AchievementPromotionsAndLoyaltyQuery);

                if (!justAchievement)
                {
                    string promtionQuery = string.Format(@"SELECT DISTINCT Promotion.PromotionID,Promotion.IsRepeated ,Promotion.RepeatCount OriginalRepeatCount ,Promotion.PromotionType,Description PromotionName, Promotion.StartDate, Promotion.EndDate, Promotion.MinValue, Promotion.PromotionLevel,Promotion.RelatedToTarget,Promotion.TargetMode,Promotion.AppliedAfterPeriod,Promotion.AllowOring,Promotion.MaxLimit,Promotion.ResetLastInvRem,
                        Promotion.IsLoyaltyPromotion, 0 IsSatisfied, 0 IsTaken, 1  IsNeedToCalculateLoyalty,IsProductDiscount  , Promotion.SalesMode  ,IsNull(Promotion.NoOfInvoices,0)  NoOfInvoices 
                        ,Sequence FROM Promotion
                        INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {0} AND IsBundle = 0
			            INNER JOIN PromotionBenefitHistory on Promotion.PromotionID=PromotionBenefitHistory.PromotionID  And PromotionBenefitHistory.TransactionTypeID=2 AND PromotionBenefitHistory.TransactionID='{1}' AND PromotionBenefitHistory.DivisionID={2} where Promotion.IsLoyaltyPromotion != 1",
                       _requestRepository.LanguageId, transationCommonData.OrderId, transationCommonData.DivisionId);
                    queryString.Append(string.Format(" Union " + promtionQuery));
                }
                

                //queryString.Append(" ORDER BY Promotion.IsGiftVoucher, PromotionGroupAssignment.PromotionGroupID, PromotionGroupAssignment.Priority, PromotionID,PromotionOptionTypeID,PromotionOptionID,PromotionOptionDetailID");

                result = dbHelper.GetQueryList(queryString.ToString(), ref promoList);

                if (result == GlobalErrors.Success && promoList.Count > 0)
                {
                    foreach (Promotion promotion in promoList)
                    {
                        GetPromotionInputsAndOutputs(promotion, transationCommonData.CustomerId, transationCommonData.OutletId, false, transationCommonData.DivisionId);
                    }
                    promoList.RemoveAll(a => a.PromotionInputs.Count == 0);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                promoList = null;
            }
            return promoList;
        }

        public bool IsPromotionInputsSatisfied(Promotion promotion, TransactionCommonData transationCommonData , ref int _numberOfWholeSaleContract)
        {
            bool isPromotionSatisfied = false;
            int promRepeatCount = 0;
            bool isInputDetailSatisfied = false;
            decimal maxSatisfiedAmount = 0; int maxValueOptionDetail =-1;
            try
            {
                promotion.SatisfiedInput = -1;
                promotion.SatesfiedDetail = -1;
                promotion.AmountOfPromotionSteps = 0;
                foreach (PromotionOption inputDetails in promotion.PromotionInputs)
                {
                    isInputDetailSatisfied = false;
                    int optionRepeatCount = -1;
                    foreach (PromotionOptionDetail detail in inputDetails.PromotionOptionDetails)
                    {
                        if (promotion.PromotionType == PromotionTypes.StepsValues)
                            promotion.IsRepeated = true;
                    
                        isInputDetailSatisfied = CheckPromotionInputDetail(promotion, detail, transationCommonData,ref maxSatisfiedAmount ,ref maxValueOptionDetail ,ref _numberOfWholeSaleContract);
                        if (isInputDetailSatisfied)
                        {
                            if (promotion.PromotionType == PromotionTypes.StepsValues)
                            {
                                promotion.PromotionOutputs
                                    .Where(opt => opt.PromotionOptionId == detail.ReferenceOptionId)
                                    .FirstOrDefault()
                                    .PromotionOptionDetails
                                    .ForEach(det => det.RepeatCount = detail.RepeatCount);
                            }
                            else
                            {
                                if (optionRepeatCount == -1)
                                {
                                    optionRepeatCount = detail.RepeatCount;
                                }

                                optionRepeatCount = Math.Min(optionRepeatCount, detail.RepeatCount);

                                if (promotion.SatisfiedInput == -1)
                                {
                                    promotion.SatisfiedInput = detail.PromotionOptionId;
                                    promotion.SatesfiedDetail = detail.PromotionOptionDetailId;
                                }
                            }
                        }
                        else
                        {
                            if (promotion.IsWholeSaleContract || (promotion.PromotionType == PromotionTypes.DynamicTargetPromotion))
                            {
                                if (!promotion.UnsatisfiedOutputs.Contains(detail.ReferenceOptionId))
                                {
                                    promotion.UnsatisfiedOutputs.Add(detail.ReferenceOptionId);
                                }
                                promotion.PromotionOutputs.RemoveAll(opt => opt.PromotionOptionId == detail.ReferenceOptionId);
                            }
                            if (promotion.PromotionType == PromotionTypes.StepsValues)
                            {
                                // Delete unSatisfied outputs 
                                promotion.PromotionOutputs.RemoveAll(opt => opt.PromotionOptionId == detail.ReferenceOptionId);
                            }
                            if (promotion.SatisfiedInput == -1)
                            {
                                promotion.SatisfiedInput = -1;
                                promotion.SatesfiedDetail = -1;
                            }

                            break;
                        }
                    }

                    if (isInputDetailSatisfied)
                    {
                        promRepeatCount += optionRepeatCount;
                    }

                    if ((promotion.PromotionType != PromotionTypes.StepsValues && !promotion.IsWholeSaleContract && promotion.PromotionType != PromotionTypes.DynamicTargetPromotion)  && isInputDetailSatisfied) // here case for wholeSales ///
                    {
                        break;
                    }
                }

                if ((promotion.PromotionType == PromotionTypes.StepsValues || promotion.IsWholeSaleContract || promotion.PromotionType == PromotionTypes.DynamicTargetPromotion) && promotion.PromotionOutputs.Count > 0)
                {
                    isInputDetailSatisfied = true;
                }
                if (isInputDetailSatisfied && promotion.PromotionType == PromotionTypes.RangeValues)
                {
                    var satisfiedOutputId = promotion.PromotionInputs.Where(a => a.PromotionOptionId == promotion.SatisfiedInput).First().PromotionOptionDetails.First().ReferenceOptionId;
                    promotion.PromotionOutputs.RemoveAll(a => a.PromotionOptionId != satisfiedOutputId);
                }

                if (isInputDetailSatisfied)
                {
                    isPromotionSatisfied = CheckPromoOutputs(promotion, transationCommonData.SoldItems);
                }
                if (isPromotionSatisfied && (promotion.IsWholeSaleContract || promotion.PromotionType == PromotionTypes.DynamicTargetPromotion) && promotion.UnsatisfiedOutputs != null && promotion.UnsatisfiedOutputs.Count>0 && promotion.UnsatisfiedOutputs.Count > 0)
                {
                    promotion.PromotionOutputs.RemoveAll(x => promotion.UnsatisfiedOutputs.Contains(x.PromotionOptionId));
                }
                else if (isPromotionSatisfied)
                {
                    if (promRepeatCount > promotion.OriginalRepeatCount) promRepeatCount = promotion.OriginalRepeatCount;
                    promotion.NewRepeatCount = promRepeatCount;
                }

                return isPromotionSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }  
        public GlobalErrors GetSatisfiedPromotionBenefitSelectionFromEcho(Promotion promotion, TransactionCommonData transationCommonData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<PromotionBenefitHistoryModel> dBHelper = new DBHelper<PromotionBenefitHistoryModel>();
            List<PromotionBenefitHistoryModel> echoSelectionDetails = new List<PromotionBenefitHistoryModel>();
            string query = string.Empty;

            try
            {
                // query select bh where order = {0} and type n (3 types) 
                string selectionPromoOutputDetailTypes = string.Format("{0}, {1}, {2}",
                    PromotionOutputDetailTypes.SummationOverGroup.GetHashCode(),
                    PromotionOutputDetailTypes.FreeItemsWithCertainValue.GetHashCode(),
                    PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage.GetHashCode());
                query = string.Format(@"
                        SELECT distinct PBH.*
                        FROM Promotion AS P INNER JOIN PromotionBenefitHistory AS PBH ON P.PromotionID = PBH.PromotionID INNER JOIN PromotionOptionDetail AS POD ON POD.PromotionID = P.PromotionID
                        WHERE (P.PromotionID = {0}) AND (PBH.TransactionID = '{1}') AND (PBH.DivisionID = {4}) AND (PBH.PromotionOptionDetailTypeID IN ({2})) ",
                promotion.PromotionId,//0
                transationCommonData.OrderId, //1
                selectionPromoOutputDetailTypes, //2
                PromotionOptionTypes.Output.GetHashCode(), //3
                transationCommonData.DivisionId);
                result = dBHelper.GetQueryList(query, ref echoSelectionDetails);
                if (result == GlobalErrors.Success && echoSelectionDetails != null)
                {

                  
                    if (echoSelectionDetails.Count() > 0)
                    {
                        foreach (var option in promotion.PromotionOutputs)
                        {
                            var all = from a in option.PromotionOptionDetails
                                      join b in echoSelectionDetails on 
                                      a.PromotionId equals b.PromotionID
                                      where 
                                        a.PromotionId == b.PromotionID &&
                                         a.PromotionOptionId == b.PromotionOptionID && 
                                        a.PromotionOptionDetailId == b.PromotionOptionDetailID &&
                                        a.PromotionOptionDetailTypeId == b.PromotionOptionDetailTypeID 
   

                                      select  a ;
                            option.PromotionOptionDetails = all.ToList();
                            //option.PromotionOptionDetails.RemoveAll(x =>
                            //x.PromotionOptionDetailTypeId.GetHashCode() != PromotionOutputDetailTypes.SummationOverGroup.GetHashCode() &&
                            //x.PromotionOptionDetailTypeId.GetHashCode() != PromotionOutputDetailTypes.FreeItemsWithCertainValue.GetHashCode() &&
                            //x.PromotionOptionDetailTypeId.GetHashCode() != PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage.GetHashCode());
                            
                        }
                        promotion.PromotionOutputs.RemoveAll(x => x.PromotionOptionDetails.Count == 0);
                        if (promotion.PromotionOutputs.Count > 0)
                            promotion.IsPromotionSelectionForEcho = true;
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public List <Promotion> CheckifThereMoreThanOneTargetPromotion(List <Promotion> promotions)
        {
            // user should not define one or more retail promotion with one or more wholeSales promotion in the same period for the same customer .
            // user should not define more than one retail promotions in the same period for the same customer .
            // user should not define more than one wholeSales promotions in the same period for the same customer .
            // if user define one of the above cases -> then system will show only one promotion with the less ID ..
            List<Promotion> targetPromotions = new List<Promotion>();
            try
            {
                foreach (Promotion promotion in promotions)
                {
                    if (promotion.PromotionType == PromotionTypes.TargetPromotion)
                    {
                        foreach (PromotionOption inputDetails in promotion.PromotionInputs)
                        {
                            foreach (PromotionOptionDetail promotionInputDetail in inputDetails.PromotionOptionDetails)
                            {
                                if (promotionInputDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.CustomerMonthlyWholesalesContracts
                                    || promotionInputDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.CustomerMonthlyAchievement)
                                    if (promotionInputDetail.AchievementTypeId == AchievementTypeValues.SalesAmount.GetHashCode())
                                    {
                                        targetPromotions.Add(promotion);

                                    }
                                break;
                            }
                            break;
                        }
                    }
                }
                targetPromotions.Sort();
                if (targetPromotions.Count > 1)
                { // get only one retail or whole sales -> if there is more than applied retail or more than applied whole sale only get one of them .
                    for (int i = 0; i < targetPromotions.Count; i++)
                    {
                        if (i == 0)
                            continue;
                        else
                        {
                            promotions.Remove(targetPromotions[i]);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return promotions;
        }
        public void RecalculatePromotedDiscountFactor(TransactionCommonData transactionCommonData)
        {
            decimal totalPromotedDiscount = 0, totalDiscount = 0, packNetTotal = 0, seqFactor = 1;
            try
            {
                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                soldItems = transactionCommonData.SoldItems;
                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                {
                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                }
                foreach (ItemPackModel pack in soldItems)
                {
                    seqFactor = 1;
                    totalDiscount = (pack.Discount + pack.AdditionalDiscount) / 100;
                    packNetTotal = pack.Price * (1 - totalDiscount) * pack.RequiredQty;
                    totalPromotedDiscount = Math.Min(pack.ItemPromotedDiscount + pack.AllItemDiscount, 100) * packNetTotal / 100;
                    if (packNetTotal > 0)
                        seqFactor = (packNetTotal - totalPromotedDiscount) / packNetTotal;
                    pack.SeqFactor = seqFactor;
                    pack.PromotedDiscount = Math.Min(pack.ItemPromotedDiscount + pack.AllItemDiscount, 100);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public decimal CalculateCurrentPromotedDiscount(TransactionCommonData transactionCommonData)
        {
            decimal disc = 0;
            try
            {
                return CalculateCurrentPromotedDiscount(transactionCommonData, ref disc);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return disc;
        }

        public decimal CalculateCurrentPromotedDiscount(TransactionCommonData transactionCommonData, ref decimal totalAchievementDiscount)
        {
            decimal totalItemPromotedDiscount = 0;
            try
            {
                AccumlateAllItemsDiscounts(transactionCommonData);

                foreach (ItemPackModel item in transactionCommonData.SoldItems)
                {
                    if (item.RequiredQty > 0)
                    {
                        totalItemPromotedDiscount += (item.ItemPromotedDiscount + item.AllItemDiscount + item.ExciseContractPromotedDiscount + item.WholeSalesPromotedDiscount)
                      * item.Price * (1 - (item.Discount + item.AdditionalDiscount) / 100) * item.RequiredQty / 100;
                        totalAchievementDiscount = totalAchievementDiscount + (item.ExciseContractPromotedDiscount + item.WholeSalesPromotedDiscount)//11.546947328676
                      * item.Price * (1 - (item.Discount + item.AdditionalDiscount) / 100) * item.RequiredQty / 100;
                    }
                }
                AccumlateAllPromotedDiscounts(transactionCommonData);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return totalItemPromotedDiscount;
        }

        public void AccumlateAllItemsDiscounts(TransactionCommonData transactionCommonData)
        {
            decimal totalItemPromotedDiscount = 0, promotedDiscount = 0, totalDiscount = 0, packNetTotal = 0, discountAmount = 0, tempRepeatCount = 1, seqFactor = 1;
            try
            {
                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                soldItems = transactionCommonData.SoldItems;
                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                {
                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                }
                if (transactionCommonData.IsDeliveryHasRelatedToTarget && !transactionCommonData.AreAllItemDiscountsAdded) // in case of full delivery & having all item discount => then AreAllItemDiscountsAdded will be false and transactionCommonData.PromotionBenefitDetails. count will be zero ,
                                                                                                                           // but there is already all item discount included in order 
                {
                    foreach (ItemPackModel pack in soldItems)
                    {
                        seqFactor = 1;
                        if (_requestRepository.Configurations.PromotionCalculationSequence == (int)PromotionCalculationSequence.SequentialFlow)
                        {
                            totalDiscount = (pack.Discount + pack.AdditionalDiscount) / 100;
                            packNetTotal = pack.Price * (1 - totalDiscount) * pack.RequiredQty;
                            totalItemPromotedDiscount = pack.ItemPromotedDiscount * packNetTotal / 100;

                            if (packNetTotal > 0)
                                seqFactor = (packNetTotal - totalItemPromotedDiscount) / packNetTotal;
                        }

                        //foreach (KeyValuePair<PromotionOutputDetailTypes, List<PromotionBenefitDetails>> currentBenefit in transactionCommonData.PromotionBenefitDetails)
                        //{
                            //foreach (PromotionBenefitDetails currentDetail in currentBenefit.Value)
                            //{
                                promotedDiscount = 0;
                                tempRepeatCount = 1;

                        //if (currentBenefit.Key == PromotionOutputDetailTypes.AllItemDiscountAmount)//?
                        //{
                        //promotedDiscount = CalculatePromotedDiscount(pack, false, 0, pack.AllItemDiscount, ref discountAmount, PromotionOutputDetailTypes.AllItemDiscountAmount);
                        //discountAmount = pack.AllItemDiscount;
                        //}
                        //else
                        //{
                        //if (currentDetail.IsRepeated)
                        //    tempRepeatCount = currentDetail.RepeatCount;
                        //promotedDiscount = pack.AllItemDiscount * seqFactor * 1;//?
                        //                                                                                //promotedDiscount = decimal.Parse(5.94.ToString());
                        //discountAmount = (pack.NetTotal + pack.CalculatedPromotedDiscount - pack.CalculatedTax) * promotedDiscount / 100;// pack net total should be 

                        ////}

                        //pack.AllItemDiscount = promotedDiscount;
                        //promotedDiscount = pack.OriginalAllItemDiscount * seqFactor * 1;//?
                        promotedDiscount = pack.AllItemDiscount * seqFactor * 1;//?
                        discountAmount = (pack.NetTotal + pack.CalculatedPromotedDiscount - pack.CalculatedTax) * promotedDiscount / 100;// pack net total should be 
                        pack.AllItemDiscount = promotedDiscount;
                        //transactionCommonData.CustomerPromotions.Find(a => a.PromotionId == currentDetail.PromotionId)
                        //    .PromotionOutputs.Find(a => a.PromotionOptionId == currentDetail.OptionId)
                        //    .PromotionOptionDetails.Find(a => a.PromotionOptionDetailId == currentDetail.OptionDetailId).BenefitPromotedAmount += discountAmount;
                        // }
                        //}

                        pack.PromotedDiscount = Math.Min(pack.ItemPromotedDiscount + pack.AllItemDiscount, 100);
                    }
                    transactionCommonData.AreAllItemDiscountsAdded = true;
                }
                if (!transactionCommonData.AreAllItemDiscountsAdded && transactionCommonData.PromotionBenefitDetails != null && transactionCommonData.PromotionBenefitDetails.Count > 0)
                {
                    foreach (ItemPackModel pack in soldItems)
                    {
                        seqFactor = 1;
                        if (_requestRepository.Configurations.PromotionCalculationSequence == (int)PromotionCalculationSequence.SequentialFlow)
                        {
                            totalDiscount = (pack.Discount + pack.AdditionalDiscount) / 100;
                            packNetTotal = pack.Price * (1 - totalDiscount) * pack.RequiredQty;
                            totalItemPromotedDiscount = pack.ItemPromotedDiscount * packNetTotal / 100;

                            if (packNetTotal > 0)
                                seqFactor = (packNetTotal - totalItemPromotedDiscount) / packNetTotal;
                        }
 
                        foreach (KeyValuePair<PromotionOutputDetailTypes, List<PromotionBenefitDetails>> currentBenefit in transactionCommonData.PromotionBenefitDetails)
                        {
                            foreach (PromotionBenefitDetails currentDetail in currentBenefit.Value)
                            {
                                promotedDiscount = 0;
                                tempRepeatCount = 1;

                                if (currentBenefit.Key == PromotionOutputDetailTypes.AllItemDiscountAmount)
                                {
                                    promotedDiscount = CalculatePromotedDiscount(pack, currentDetail.IsRepeated, currentDetail.RepeatCount, currentDetail.PromotedDiscount, ref discountAmount, PromotionOutputDetailTypes.AllItemDiscountAmount,false);
                                    discountAmount = currentDetail.PromotedDiscount;
                                }
                                else
                                {
                                    if (currentDetail.IsRepeated)
                                        tempRepeatCount = currentDetail.RepeatCount;
                                    promotedDiscount = currentDetail.PromotedDiscount * seqFactor * tempRepeatCount;//?
                                    //promotedDiscount = decimal.Parse(5.94.ToString());
                                    discountAmount = (pack.NetTotal - pack.CalculatedTax) * promotedDiscount / 100;// pack net total should be 

                                }
                                pack.AllItemDiscount += promotedDiscount;

                                transactionCommonData.CustomerPromotions.Find(a => a.PromotionId == currentDetail.PromotionId)
                                    .PromotionOutputs.Find(a => a.PromotionOptionId == currentDetail.OptionId)
                                    .PromotionOptionDetails.Find(a => a.PromotionOptionDetailId == currentDetail.OptionDetailId).BenefitPromotedAmount += discountAmount;
                            }
                        }

                        pack.PromotedDiscount = Math.Min(pack.ItemPromotedDiscount + pack.AllItemDiscount, 100);
                    }
                    transactionCommonData.AreAllItemDiscountsAdded = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public void AccumlateAllPromotedDiscounts(TransactionCommonData transactionCommonData)
        {
            try
            {
                 decimal totalPromotedDiscount = 0, itemPromotedDiscount = 0, allItemPromotedDiscount = 0,
                    achievementPromotedDiscount = 0, dynamicPromotedDiscount = 0, productDiscount;
                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                soldItems = transactionCommonData.SoldItems;
                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                {
                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                }
                if (!transactionCommonData.AreAllItemDiscountsAdded )//&& transactionCommonData.ItemFormProcessMode != ItemFormProcessMode.Delivery)// && !_fullDelivery)
                    AccumlateAllItemsDiscounts(transactionCommonData);
                
                foreach (ItemPackModel pack in soldItems)
                {
                    itemPromotedDiscount = pack.ItemPromotedDiscount;
                    allItemPromotedDiscount = pack.AllItemDiscount;
                    achievementPromotedDiscount = pack.ExciseContractPromotedDiscount + pack.WholeSalesPromotedDiscount;
                    dynamicPromotedDiscount = pack.DynamicPromotedDiscount;
                    productDiscount = pack.ProductDiscount;
                    totalPromotedDiscount = itemPromotedDiscount + allItemPromotedDiscount + achievementPromotedDiscount + dynamicPromotedDiscount + productDiscount;
                    pack.PromotedDiscount = totalPromotedDiscount;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public GlobalErrors SavePromotionsAgainstAchievementsData(TransactionModel transaction, OrderModel order,List <PromotionsHistoryModel> oldPromotionsHistoryData,string voidedTransactionID ,decimal oldNetTotal, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            Dictionary<int, AchievementTargetCustomer> lookup = new Dictionary<int, AchievementTargetCustomer>();
            try
            {
                if (transaction.CustomerPromotions != null)
                {
                    foreach ( Promotion item in transaction.CustomerPromotions)
                    {
                        if (item.CustomerTargets != null && item.CustomerTargets.Count > 0)
                        {
                            foreach (AchievementTargetCustomer obj in item.CustomerTargets)
                            {
                                if (obj.PromotedOnPromotionID == item.PromotionId
                                      || ((item.IsWholeSaleContract || item.IsDynamicSalesAmount) && obj.IsLastInvoice && obj.PromotedOnPromotionID == -1))
                                {
                                    if (obj.IsPromoted && obj.IsLastInvoice && !lookup.ContainsKey(obj.PromotedOnPromotionID))
                                    {
                                        obj.PromotedOnPromotionID = item.PromotionId;
                                        result = InsertPromotionHistoryData(transaction.OutletId, obj.PromotedOnPromotionID, transaction.TransactionId, obj, true, transaction.TransactionDate, item.PromotionLevel,order.OrderOperation == OrderOperation.PartialDelivery , oldPromotionsHistoryData,voidedTransactionID,oldNetTotal ,dbHelper);
                                        if (result == GlobalErrors.Success)
                                        {
                                            result = UpdateTargetAgainstPromotion(obj, true, transaction.TransactionDate, true, transaction.TransactionId, dbHelper);
                                            lookup.Add(item.PromotionId, obj);
                                        }
                                        if (result != GlobalErrors.Success)
                                        {
                                            return GlobalErrors.Error;
                                        }
                                        break;
                                    }
                                    else if (obj.IsPromoted && !obj.IsLastInvoice && !lookup.ContainsKey(obj.PromotedOnPromotionID))
                                    {
                                        result = InsertPromotionHistoryData(transaction.OutletId, obj.PromotedOnPromotionID, transaction.TransactionId, obj, false, transaction.TransactionDate, item.PromotionLevel, order.OrderOperation == OrderOperation.PartialDelivery, oldPromotionsHistoryData, voidedTransactionID, oldNetTotal, dbHelper);
                                        result = UpdateTargetAgainstPromotion(obj, true, transaction.TransactionDate, false, transaction.TransactionId, dbHelper);
                                        lookup.Add(item.PromotionId, obj);
                                        if (result != GlobalErrors.Success)
                                        {
                                            return GlobalErrors.Error;
                                        }
                                        break;
                                    }
                                    else if (!obj.IsPromoted && obj.IsLastInvoice)
                                    {/* in case of setting an invoice as last one and it was not reaching the target 
                                            we count it as first promoted to handle the voiding of last invoices after it .*/
                                        obj.PromotedOnPromotionID = item.PromotionId;
                                        obj.IsFirstTimePromoted = true;
                                        result = InsertPromotionHistoryData(transaction.OutletId, obj.PromotedOnPromotionID, transaction.TransactionId, obj, true, transaction.TransactionDate, item.PromotionLevel, order.OrderOperation == OrderOperation.PartialDelivery, oldPromotionsHistoryData, voidedTransactionID, oldNetTotal, dbHelper);
                                        if (result == GlobalErrors.Success)
                                        {
                                            result = UpdateTargetAgainstPromotion(obj, true, transaction.TransactionDate, true, transaction.TransactionId, dbHelper);
                                            if (!lookup.ContainsKey(obj.PromotedOnPromotionID)) lookup.Add(item.PromotionId, obj);
                                        }
                                        if (result != GlobalErrors.Success)
                                        {
                                            return GlobalErrors.Error;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public static GlobalErrors UpdateTargetAgainstPromotion(AchievementTargetCustomer obj, bool isPromoted, DateTime lastInvoiceDate, bool updateLastInvoiceDate, string transactionID,  DBHelper<int> dBHelper)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                string queryColumns = string.Empty;
                if (isPromoted && updateLastInvoiceDate)
                {
                    queryColumns = string.Format(" LastInvoiceDate = {0} , IsPromoted = 1 ", LocalUtilities.ParseDateAndTimeToSQL(lastInvoiceDate));
                }
                else if (!isPromoted && updateLastInvoiceDate)
                {
                    queryColumns = string.Format(" LastInvoiceDate = {0}", LocalUtilities.ParseDateAndTimeToSQL(lastInvoiceDate));
                }
                else if (isPromoted && !updateLastInvoiceDate)
                {
                    queryColumns = string.Format(" IsPromoted = 1 ");
                }
                
                string query =string.Format("UPDATE AchievementTargetCustomer Set {0}",
                     obj.IsFirstTimePromoted && transactionID != string.Empty ? string.Format(" PromotedOnTransactionID = '{0}', ", transactionID) : string.Empty) +
                    "IsUpdatedInFO = 0," + queryColumns +
                    " WHERE CustomerID = " + obj.CustomerID.ToString()
                    + " AND OutletID = " + obj.OutletID.ToString()
                    + " AND TargetID = " + obj.TargetID.ToString()
                    + " AND AchievementID = " + obj.AchievementID.ToString()
                    + " AND FromDate = " + LocalUtilities.ParseDateAndTimeToSQL(obj.FromDate)
                    + " AND ToDate = " + LocalUtilities.ParseDateAndTimeToSQL(obj.ToDate) ;
                err = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                err = GlobalErrors.Error;
            }
            return err;
        }
        public GlobalErrors InsertPromotionHistoryData(int outletID, int promotionID, string transactionID, AchievementTargetCustomer obj, bool updateDate, DateTime transactionDate, PromotionLevel promotionLevel, bool isPartialDelivery,List<PromotionsHistoryModel> oldPromotionsHistoryData, string voidedTransactionID, decimal oldInvoiceAmount, DBHelper <int> dBHelper)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            decimal oldAvhievement = 0;
            bool isCustomerLevel = false;
            decimal oldQuantity = 0;
            try
            {
                if (promotionLevel == PromotionLevel.CustomerLevel)
                    isCustomerLevel = true;
                oldAvhievement = GetAchievementValue(int.Parse(obj.CustomerID.ToString()), outletID, obj.AchievementID, obj.TargetID, isCustomerLevel, dBHelper);
                if (isPartialDelivery)
                {
                    List<PromotionsHistoryModel> oldData = new List<PromotionsHistoryModel>();
                    if (oldPromotionsHistoryData != null && oldPromotionsHistoryData.Count > 0)
                        oldData = oldPromotionsHistoryData.Where(x => x.PromotionID == promotionID && x.AchievementId == obj.AchievementID && x.TargetId == obj.TargetID && x.CustomerID == int.Parse(obj.CustomerID.ToString()) && x.OutletID == outletID).ToList();
                    if (oldData == null || (oldData != null && oldData.Count == 0))
                    {
                        if ((obj.AchievementID == AchievementValues.MonthlySalesAmount.GetHashCode()
                            || obj.AchievementID == AchievementValues.DynamicSalesAmountPerCustomer.GetHashCode()))
                        {
                                oldAvhievement = oldAvhievement - oldInvoiceAmount;
                        }
                        else if ((obj.AchievementID == AchievementValues.Monthlysoldquantityfrompackgroup.GetHashCode()
                            || obj.AchievementID == AchievementValues.DynamicSalesPerPackGroupPerCustomer.GetHashCode()))
                        {
                            oldQuantity = GetCalculatedTotalQuantityForOldTransaction(voidedTransactionID, obj.CustomerID, obj.OutletID, obj.AchievementID, obj.TargetID, dBHelper);
                            oldAvhievement = oldAvhievement - oldQuantity;
                        }
                    }
                    else if (oldData != null && oldData.Count > 0)
                    {
                        oldAvhievement = oldData.First().OldValue;
                    }
                }
                string sqlStatement = "INSERT INTO "
                    + " PromotionsHistory(TransactionID, PromotionID, AchievementID, TargetID, LastInvoiceDate, CustomerID, OutletID, BenefitValue, OldValue) "
                    + " VALUES ('" + transactionID + "', "
                    + promotionID.ToString() + ", "
                    + obj.AchievementID.ToString() + ", "
                    + obj.TargetID.ToString() + ", "
                    + (updateDate ? LocalUtilities.ParseDateAndTimeToSQL(transactionDate) : "NULL") + ", "
                    + obj.CustomerID.ToString() + ", "
                    + outletID.ToString() + ", "
                    + obj.BenefitValue + ", "
                    + oldAvhievement + ")";
                err = dBHelper.ExecuteSQLCommand(sqlStatement);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }

            return err;
        }
        public decimal CalculatePromotedDiscount(ItemPackModel selectedPack, bool isRepeated, int repeatCount, decimal promotionValue, ref decimal dicountAmount, PromotionOutputDetailTypes type, bool isProductDiscount)
        {
            try
            {
                decimal totalDiscount = 0, totalAmount = 0, dicountPercent = 0, promotedDiscount = 0, typeDepDiscount = 0, totalTax = 0, addedExsiceTax = 0;
                bool applyRoundingPerLine = _requestRepository.Configurations.ApplyRoundingOnCalculations;
                if (_requestRepository.Configurations.IncludeExciseTaxInDiscount)
                {
                    addedExsiceTax = selectedPack.RetailValue * selectedPack.RequiredQty;
                    if (applyRoundingPerLine)
                    {
                        addedExsiceTax = LocalUtilities.GetRoundedDecimal(addedExsiceTax, _requestRepository.Configurations.NumberOfDigits);
                    }
                }
                totalAmount = (selectedPack.RequiredQty * selectedPack.Price) + addedExsiceTax;
                if (selectedPack.DiscountTypeId == DiscountValueTypes.Amount.GetHashCode())
                {
                    if (_requestRepository.Configurations.ApplyAmountDiscountPerQuantity)
                    {
                        totalDiscount = selectedPack.Discount * selectedPack.RequiredQty;
                    }
                    else
                    {
                        totalDiscount = selectedPack.Discount;
                    }
                }
                else
                {
                    totalDiscount = totalAmount * selectedPack.Discount / 100;
                }
                totalDiscount += (totalAmount - totalDiscount) * selectedPack.AdditionalDiscountPercentage / 100;
                totalAmount = totalAmount - totalDiscount;
                if (isProductDiscount)
                {
                    totalTax = totalAmount * selectedPack.Tax / 100;
                    totalAmount = totalAmount + totalTax;
                    promotionValue = promotionValue + totalTax;
                }
                dicountAmount = promotionValue;
                if (totalAmount <= 0)
                {
                    totalAmount = 0;
                    dicountPercent = 0;
                    dicountAmount = 0;
                    return promotedDiscount = 0;
                }
                else
                {
                    if (!isProductDiscount)
                    {
                        if (_requestRepository.Configurations.ApplyAmountDiscountPerQuantity)
                        {
                            dicountPercent = (selectedPack.RequiredQty * dicountAmount * 100) / totalAmount;
                            dicountAmount = dicountPercent * totalAmount / 100;
                        }
                        else
                            dicountPercent = (promotionValue * 100) / totalAmount;
                    }
                    else
                    {
                        dicountAmount = promotionValue;
                        dicountPercent = dicountAmount / totalAmount * 100;
                    }
                }
                int newCount = 1;
                if (isRepeated)
                    newCount = repeatCount;
                switch (type)
                {
                    case PromotionOutputDetailTypes.AllItemDiscountAmount:
                        {
                            typeDepDiscount = selectedPack.AllItemDiscount;
                            break;
                        }
                    case PromotionOutputDetailTypes.DiscountAmountForGroupItems:
                    case PromotionOutputDetailTypes.DiscountAmountForItem:
                        {
                            typeDepDiscount = selectedPack.ItemPromotedDiscount;
                            break;
                        }
                    //case PromotionOutputDetailTypes.RetailContractDiscount:
                    //    {
                    //        typeDepDiscount = selectedPack.ExciseContractPromotedDiscount;
                    //        break;
                    //    }
                    //case PromotionOutputDetailTypes.WholesalesContractsDiscount:
                    //    {
                    //        typeDepDiscount = selectedPack.WholeSalesPromotedDiscount;
                    //        break;
                    //    }
                    //case PromotionOutputDetailTypes.DynamicTargetDiscount:
                    //    {
                    //        typeDepDiscount = selectedPack.DynamicPromotedDiscount;
                    //        break;
                    //    }
                }
                if (!isProductDiscount)
                    promotedDiscount = Math.Min(dicountPercent * newCount, 100 - typeDepDiscount);
                else
                    promotedDiscount = dicountPercent * newCount;

                return promotedDiscount;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return 0;
            }
        }

        //private decimal CalculatePromotedDiscount(ItemPackModel selectedPack, bool isRepeated, int repeatCount, decimal promotionValue, ref decimal dicountAmount, PromotionOutputDetailTypes type)
        //{
        //    try
        //    {
        //        decimal totalDiscount = 0, totalAmount = 0, dicountPercent = 0, promotedDiscount = 0, typeDepDiscount = 0;
        //        totalAmount = selectedPack.RequiredQty * selectedPack.Price;
        //        totalDiscount = totalAmount * selectedPack.Discount / 100;
        //        totalDiscount += (totalAmount - totalDiscount) * selectedPack.AdditionalDiscountPercentage / 100;
        //        totalAmount = totalAmount - totalDiscount;
        //        dicountAmount = promotionValue;
        //        if (totalAmount <= 0)
        //        {
        //            totalAmount = 0;
        //            dicountPercent = 0;
        //            dicountAmount = 0;
        //            return promotedDiscount = 0;
        //        }
        //        else
        //        {
        //            if (_requestRepository.Configurations.ApplyAmountDiscountPerQuantity)
        //            {
        //                dicountPercent = (selectedPack.RequiredQty * promotionValue * 100) / totalAmount;
        //                dicountAmount = dicountPercent * totalAmount / 100;
        //            }
        //            else
        //                dicountPercent = (promotionValue * 100) / totalAmount;
        //        }
        //        int newCount = 1;
        //        if (isRepeated)
        //            newCount = repeatCount;
        //        switch (type)
        //        {
        //            case PromotionOutputDetailTypes.AllItemDiscountAmount:
        //                {
        //                    typeDepDiscount = selectedPack.AllItemDiscount;
        //                    break;
        //                }
        //            case PromotionOutputDetailTypes.DiscountAmountForGroupItems:
        //            case PromotionOutputDetailTypes.DiscountAmountForItem:
        //            case PromotionOutputDetailTypes.DiscountAmountForItemBatch:
        //                {
        //                    typeDepDiscount = selectedPack.ItemPromotedDiscount;
        //                    break;
        //                }
        //            case PromotionOutputDetailTypes.RetailContractDiscount:
        //                {
        //                    typeDepDiscount = selectedPack.ExciseContractPromotedDiscount;
        //                    break;
        //                }
        //            case PromotionOutputDetailTypes.WholesalesContractsDiscount:
        //                {
        //                    typeDepDiscount = selectedPack.WholeSalesPromotedDiscount;
        //                    break;
        //                }
        //            case PromotionOutputDetailTypes.DynamicTargetDiscount:
        //                {
        //                    typeDepDiscount = selectedPack.DynamicPromotedDiscount;
        //                    break;
        //                }
        //        }
        //        promotedDiscount = Math.Min(dicountPercent * newCount, 100 - typeDepDiscount);
        //        return promotedDiscount;
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return 0;
        //    }
        //}
        public bool IsPromotionTaken(string transactionID, int customerID, int outletID, int divisionID)
        {
            DBHelper<int> dBHelper = null;
            bool isPromotionTaken = false;
            try
            {
                dBHelper = new DBHelper<int>();

                string query = string.Format(@"select COUNT(*) from PromotionBenefitHistory
                WHERE  TransactionID = '{0}' and CustomerID = {1} and OutletID = {2} and DivisionID = {3}"
                , transactionID, customerID, outletID, divisionID);

                object objField = 0;

                var result = dBHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success && objField != null && (int)objField > 0)
                {
                    isPromotionTaken = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isPromotionTaken;
        }

        public GlobalErrors SavePromotionBenefitHistoryData(TransactionModel _salesTransaction, OrderModel _Order, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string selectionPromoOutputDetailTypes = string.Format("{0}, {1}, {2}",
                  PromotionOutputDetailTypes.SummationOverGroup.GetHashCode(),
                  PromotionOutputDetailTypes.FreeItemsWithCertainValue.GetHashCode(),
                  PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage.GetHashCode());

                string query = string.Format(@"INSERT INTO PromotionBenefitHistory 
                    select  '{0}' TransactionID, PBH.PromotionID, PBH.PromotionOptionID, PBH.PromotionOptionDetailID,
                    PBH.PromotionOptionDetailTypeID, PBH.PackID, PBH.CustomerID, PBH.OutletID, PBH.EmployeeID,
                    PBH.RouteID, PBH.RouteHistoryID, PBH.PackGroupID, {1} CreatedDate,
                    PBH.InvoiceDiscountValue, PBH.PackDiscountValue, PBH.PackQuantity , 1 TransactionTypeID,PBH.DivisionID,PBH.ExpiryDate,PBH.BatchNo,PBH.RepeatCount ,0 ,0, -1
                    from PromotionBenefitHistory PBH
                    left join (
                    select PromotionBenefitHistory.* from PromotionBenefitHistory
                    inner join SalesOrder SO on SO.OrderID = PromotionBenefitHistory.TransactionID and SO.DivisionID = PromotionBenefitHistory.DivisionID
                    and SO.CreationSource = {5} and PromotionBenefitHistory.PromotionOptionDetailTypeID in ({4}) and IsNull(PromotionBenefitHistory.PackID, -1) = -1
                    ) tt on tt.TransactionID  = PBH.TransactionID and tt.DivisionID  = PBH.DivisionID and tt.PromotionID  = PBH.PromotionID and tt.PromotionOptionID  = PBH.PromotionOptionID and tt.PromotionOptionDetailID  = PBH.PromotionOptionDetailID
                    where PBH.TransactionID = '{2}' and PBH.DivisionID = {6} and tt.PromotionOptionDetailID is null;
                    INSERT INTO PromPrerequisitesHistory select CustomerID, OutletID, '{0}' TransactionID, PromotionID, ItemID, PackID, PackGroupID, QuantityInPcs, -1 from PromPrerequisitesHistory where TransactionID = '{2}'",
                                    _salesTransaction.TransactionId, //0
                                    //LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //1
                                    LocalUtilities.ParseDateAndTimeToSQL(_salesTransaction.TransactionDate), //1
                                    _Order.OrderId, //2
                                    _Order.DivisionId,//3
                                    selectionPromoOutputDetailTypes, //4
                                    CreationSource.Echo.GetHashCode(), //5
                                    _Order.DivisionId //6
                                    );
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public bool CheckIfPromotionBenefitHistoryIsSelection(string TransctionnId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper;
            try
            {
                dBHelper = new DBHelper<int>();
                string selectionPromoOutputDetailTypes = string.Format("{0}, {1}, {2}",
                   PromotionOutputDetailTypes.SummationOverGroup.GetHashCode(),
                   PromotionOutputDetailTypes.FreeItemsWithCertainValue.GetHashCode(),
                   PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage.GetHashCode());

                string query = string.Format(@"SELECT Count(*)
                        FROM Promotion AS P INNER JOIN PromotionBenefitHistory AS PBH ON P.PromotionID = PBH.PromotionID INNER JOIN PromotionOptionDetail AS POD ON POD.PromotionID = P.PromotionID
                        WHERE  (PBH.TransactionID = '{0}') AND (PBH.PromotionOptionDetailTypeID IN ({1})) AND (POD.PromotionOptionID = 2) AND (PBH.PackID = - 1) ",
                    TransctionnId, selectionPromoOutputDetailTypes, PromotionOptionTypes.Output.GetHashCode());
                object refObj = null;
                result = dBHelper.ExecuteScalar(query, ref refObj);
                if (result == GlobalErrors.Success && refObj != null)
                {
                    if ((int)refObj > 0)
                        return true;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return false;
        }
        public GlobalErrors SavePromotionBenefitHistoryData(string tableName,string transactionId, int customerId, int outletId, int divisionId, int employeeId, List<Promotion> customerPromotions, PromotionBenefitTransactionTypes type,DBHelper<int> dbHelper, bool isCustomerApp = false)
        {
            return SavePromotionBenefitHistoryData(tableName,transactionId, customerId, outletId, divisionId, employeeId, customerPromotions, type, DateTime.Now, dbHelper, isCustomerApp);
        }
        public GlobalErrors SavePromotionBenefitHistoryData(string tableName,string transactionId, int customerId, int outletId, int divisionId, int employeeId, List<Promotion> customerPromotions, PromotionBenefitTransactionTypes type, DateTime currentDate,DBHelper<int> dbHelper, bool isCustomerApp = false)
        {
            var result = GlobalErrors.Success;
            int packID = -1, promotionID = -1, promotionOptionID = -1
            , promotionOptionDetailID = -1, promotionOptionDetailTypeID = -1;
            int packGroupID = -1;
            decimal invoiceDiscount = -1, packDiscount = -1, packQuantity = -1, invoiceQty = -1;
            bool QueryBuilt = false;
            bool IsQyuOutput = false;
            Object field = null;
            decimal priceValue = 0;
            try
            {
                foreach (Promotion promotion in customerPromotions)
                {
                    if (!promotion.IsTaken && !isCustomerApp)
                        continue;
                    else
                    {
                        if (!isCustomerApp)
                        {
                            if(tableName == CoreDataBaseConstants.TableNames.PromotionBenefitHistory)
                                result = SaveSatisfiedPrerequisitesHistory(CoreDataBaseConstants.TableNames.PromPrerequisitesHistory, transactionId, customerId, outletId, promotion.SatisfiedPrerequisitesDetails, dbHelper);
                            else
                                result = SaveSatisfiedPrerequisitesHistory(CoreDataBaseConstants.TableNames.TestPromPrerequisitesHistory, transactionId, customerId, outletId, promotion.SatisfiedPrerequisitesDetails, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                            if (result == GlobalErrors.Success && promotion.ProductDiscountBenefitList != null && promotion.ProductDiscountBenefitList.Count > 0)
                            {
                                if (tableName == CoreDataBaseConstants.TableNames.PromotionBenefitHistory)
                                    result = SaveProductDiscountBenefitValues(CoreDataBaseConstants.TableNames.ProductDiscountBenefits, transactionId, customerId, outletId, promotion.ProductDiscountBenefitList, dbHelper);
                                else
                                    result = SaveProductDiscountBenefitValues(CoreDataBaseConstants.TableNames.TestProductDiscountBenefits, transactionId, customerId, outletId, promotion.ProductDiscountBenefitList, dbHelper);
                            }
                            if (result != GlobalErrors.Success) return result;
                            if (tableName == CoreDataBaseConstants.TableNames.PromotionBenefitHistory)
                                result = SavePromBenefitSequenceDetail(CoreDataBaseConstants.TableNames.PromBenefitSequenceDetail, transactionId, customerId, outletId, promotion.BenefitSequenceDtls, dbHelper);
                            else
                                result = SavePromBenefitSequenceDetail(CoreDataBaseConstants.TableNames.TestPromBenefitSequenceDetail, transactionId, customerId, outletId, promotion.BenefitSequenceDtls, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }    
                    foreach (PromotionOption promotionOption in promotion.PromotionOutputs)
                    {
                        foreach (PromotionOptionDetail promotionOptionDetail in promotionOption.PromotionOptionDetails)
                        {
                            if (isCustomerApp)
                            {
                                BuildPromotionBenefitQuery(tableName,promotionOptionDetail.PackId, promotionOptionDetail.PackGroupId, -1,
                                  -1, 0, promotionOptionDetail, type.GetHashCode(), promotion.NewRepeatCount, transactionId, customerId, outletId, divisionId, employeeId, currentDate, dbHelper);
                            }
                            else {
                                IsQyuOutput = false;
                                if (promotionOptionDetail.IsBenefitTaken)
                                {
                                    promotionID = promotionOptionDetail.PromotionId;
                                    promotionOptionID = promotionOptionDetail.PromotionOptionId;
                                    promotionOptionDetailID = promotionOptionDetail.PromotionOptionDetailId;
                                    promotionOptionDetailTypeID = (int)promotionOptionDetail.OutputOptionDetailTypeId;

                                    QueryBuilt = false;

                                    switch (promotionOptionDetail.OutputOptionDetailTypeId)
                                    {
                                        case PromotionOutputDetailTypes.AllItemDiscountAmount:
                                        case PromotionOutputDetailTypes.AllItemDiscountPercentage:
                                        case PromotionOutputDetailTypes.DiscountAmount:
                                        case PromotionOutputDetailTypes.DiscountPercentage:
                                        case PromotionOutputDetailTypes.DynamicTargetDiscount:
                                        case PromotionOutputDetailTypes.RetailContractDiscount:
                                        case PromotionOutputDetailTypes.WholesalesContractsDiscount:
                                        case PromotionOutputDetailTypes.DiscountAmountOverTransaction:
                                            {
                                                invoiceDiscount = promotionOptionDetail.BenefitPromotedAmount;
                                            }
                                            break;
                                        case PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount:
                                            packGroupID = promotionOptionDetail.PackGroupId;
                                            if (promotionOption.TakeMode == 0)
                                            {
                                                invoiceDiscount = promotionOptionDetail.BenefitPromotedAmount;
                                            }
                                            else
                                            {
                                                invoiceDiscount = promotionOptionDetail.BenefitPromotedAmount;
                                                if (promotionOptionDetail.PromotionWrapper != null && promotionOptionDetail.PromotionWrapper.Count > 0)
                                                {
                                                    QueryBuilt = true;
                                                    foreach (PromotionBenefitWrapper wrapper in promotionOptionDetail.PromotionWrapper)
                                                    {
                                                        BuildPromotionBenefitQuery(tableName,wrapper.PackId, promotionOptionDetail.PackGroupId, -1,
                                                        -1, wrapper.TotalQuantity, promotionOptionDetail, type.GetHashCode(), promotion.NewRepeatCount, transactionId, customerId, outletId, divisionId, employeeId, currentDate, dbHelper);
                                                    }
                                                }
                                            }
                                            break;

                                        case PromotionOutputDetailTypes.ItemQuantity:
                                        case PromotionOutputDetailTypes.ItemBatchQuantity:
                                        case PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems:
                                            {
                                                IsQyuOutput = true;
                                                packID = promotionOptionDetail.PackId;
                                                //packQuantity = promotionOptionDetail.BenefitPromotedAmount;
                                                if (promotionOptionDetail.PromotionWrapper != null && promotionOptionDetail.PromotionWrapper.Count > 0)
                                                {
                                                    // invoiceQty = 0;
                                                    QueryBuilt = true;
                                                    foreach (PromotionBenefitWrapper wrapper in promotionOptionDetail.PromotionWrapper)
                                                    {
                                                        BuildPromotionBenefitQuery(tableName,wrapper.PackId, promotionOptionDetail.PackGroupId, -1,
                                                        -1, wrapper.TotalQuantity, promotionOptionDetail, type.GetHashCode(), promotion.NewRepeatCount, transactionId, customerId, outletId, divisionId, employeeId, currentDate, dbHelper);
                                                        //   invoiceQty += wrapper.TotalQuantity;
                                                    }
                                                }
                                            }
                                            break;
                                        case PromotionOutputDetailTypes.DiscountAmountForItemBatch:
                                            packID = promotionOptionDetail.PackId;
                                            packDiscount = promotionOptionDetail.BenefitPromotedAmount;
                                            break;

                                        case PromotionOutputDetailTypes.DiscountPercentageForItem:
                                        case PromotionOutputDetailTypes.DiscountAmountForItem:

                                            {
                                                // invoiceQty = 0;
                                                QueryBuilt = true;
                                                invoiceDiscount = 0;
                                                foreach (PromotionBenefitWrapper wrapper in promotionOptionDetail.PromotionWrapper)
                                                {
                                                    invoiceDiscount += wrapper.TotalDiscount;
                                                    BuildPromotionBenefitQuery(tableName,wrapper.PackId, promotionOptionDetail.PackGroupId, wrapper.TotalDiscount,
                                                    -1, -1, promotionOptionDetail, type.GetHashCode(), promotion.NewRepeatCount, transactionId, customerId, outletId, divisionId, employeeId, currentDate, dbHelper);
                                                    ///   invoiceQty += wrapper.TotalQuantity;
                                                }
                                            }
                                            break;

                                        case PromotionOutputDetailTypes.FixedPriceOverItem:
                                            {
                                                packID = promotionOptionDetail.PackId;
                                                priceValue = promotionOptionDetail.Value;
                                            }
                                            break;
                                        case PromotionOutputDetailTypes.SummationOverGroup:
                                        case PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage:
                                        case PromotionOutputDetailTypes.FreeItemsWithCertainValue:
                                        case PromotionOutputDetailTypes.GroupEqualQuantity:
                                        case PromotionOutputDetailTypes.OpenSteps:
                                        case PromotionOutputDetailTypes.DynamicTargetSummationOverGroup:
                                        case PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems:
                                        case PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel:
                                            {
                                                IsQyuOutput = true;
                                                if (promotionOptionDetail.PromotionWrapper != null && promotionOptionDetail.PromotionWrapper.Count > 0)
                                                {
                                                    // invoiceQty = 0;
                                                    QueryBuilt = true;
                                                    foreach (PromotionBenefitWrapper wrapper in promotionOptionDetail.PromotionWrapper)
                                                    {
                                                        BuildPromotionBenefitQuery(tableName,wrapper.PackId, promotionOptionDetail.PackGroupId, -1,
                                                        -1, wrapper.TotalQuantity, promotionOptionDetail, type.GetHashCode(), promotion.NewRepeatCount, transactionId, customerId, outletId, divisionId, employeeId, currentDate, dbHelper, wrapper.SalesOrderTypeId);
                                                        //   invoiceQty += wrapper.TotalQuantity;
                                                    }
                                                }
                                                else if (promotion.AllowOring && (promotionOptionDetail.PromotionWrapper == null || promotionOptionDetail.PromotionWrapper.Count() == 0)) {
                                                    QueryBuilt = true;
                                                    // we don't need to save outputs that user didnt fill it .
                                                }
                                            }
                                            break;

                                        case PromotionOutputDetailTypes.FixedPriceOverGroup:
                                        case PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel:
                                            {
                                                packGroupID = promotionOptionDetail.PackGroupId;
                                                priceValue = promotionOptionDetail.Value;
                                                if (promotionOptionDetail.PromotionWrapper != null && promotionOptionDetail.PromotionWrapper.Count > 0)
                                                {
                                                    QueryBuilt = true;
                                                    foreach (PromotionBenefitWrapper wrapper in promotionOptionDetail.PromotionWrapper)
                                                    {
                                                        BuildPromotionBenefitQuery(tableName,wrapper.PackId, promotionOptionDetail.PackGroupId, -1,
                                                        -1, -1, promotionOptionDetail, type.GetHashCode(), promotion.NewRepeatCount, transactionId, customerId, outletId, divisionId, employeeId, currentDate, dbHelper, wrapper.SalesOrderTypeId, priceValue);
                                                    }
                                                }
                                            }
                                            break;

                                        case PromotionOutputDetailTypes.DiscountAmountForGroupItems:
                                        case PromotionOutputDetailTypes.DiscountPercentageForGroupItems:
                                        case PromotionOutputDetailTypes.DiscountAmountOverGroup:
                                        case PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel:
                                            {
                                                invoiceDiscount = 0;
                                                if (promotionOptionDetail.PromotionWrapper != null && promotionOptionDetail.PromotionWrapper.Count > 0)
                                                {
                                                    QueryBuilt = true;
                                                    foreach (PromotionBenefitWrapper wrapper in promotionOptionDetail.PromotionWrapper)
                                                    {
                                                        invoiceDiscount += wrapper.TotalDiscount;
                                                        BuildPromotionBenefitQuery(tableName,wrapper.PackId, promotionOptionDetail.PackGroupId, wrapper.TotalDiscount,
                                                        -1, -1, promotionOptionDetail, type.GetHashCode(), promotion.NewRepeatCount, transactionId, customerId, outletId, divisionId, employeeId, currentDate,dbHelper, wrapper.SalesOrderTypeId);
                                                    }
                                                }
                                            }
                                            break;
                                    }

                                    if (!QueryBuilt) // Indicating that the query reached other code calling below method.
                                        BuildPromotionBenefitQuery(tableName,packID, packGroupID, packDiscount, invoiceDiscount,
                                            packQuantity, promotionOptionDetail, type.GetHashCode(), promotion.NewRepeatCount, transactionId, customerId, outletId, divisionId, employeeId, currentDate, dbHelper);
                                    if (promotion.RelatedToTarget)
                                    {
                                        decimal valueToBeSaved = 0;
                                        if (IsQyuOutput)
                                        {
                                            string query = string.Format(@"select IsNull(SUM(CONVERT(numeric(19,9),(CONVERT(numeric(19,9),(PH.PackQuantity * Pack.Quantity)) / tt.dtlPcsInPack))),0) FROM {5} PH
                                                INNER JOIN Pack ON Pack.PackID = PH.PackID
                                                INNER JOIN (select Pack.PackID,Pack.ItemID,PGD.PackGroupID,Pack.Quantity dtlPcsInPack From Pack INNER JOIN PackGroupDetail PGD ON Pack.PackID = PGD.PackID) as tt ON Pack.ItemID = tt.ItemID And PH.PackGroupID = tt.PackGroupID
                                                Where Customerid ={0} and OutletID ={1} and PromotionID = {2} and Transactionid = '{3}' And PromotionOptionID ={4}
                                                GROUP BY PH.CustomerID,PH.OutletID,PH.PromotionID", customerId, outletId, promotionOptionDetail.PromotionId, transactionId, promotionOption.PromotionOptionId,tableName );
                                            result = dbHelper.ExecuteScalar(query , ref field );
                                            if (field != null && field.ToString() != "")
                                            {
                                                valueToBeSaved = decimal.Parse(field.ToString());
                                                if (promotionOptionDetail.PackGroupQuantity >0)
                                                    valueToBeSaved = valueToBeSaved / promotionOptionDetail.PackGroupQuantity;
                                                else if ( promotionOptionDetail.PiecesInPack > 0)
                                                    valueToBeSaved = valueToBeSaved / promotionOptionDetail.PiecesInPack;
                                            }
                                        }
                                        else
                                            valueToBeSaved = invoiceDiscount;
                                        if(tableName == CoreDataBaseConstants.TableNames.PromotionBenefitHistory)
                                            result = SaveInAccumulativePromotionsHistory(CoreDataBaseConstants.TableNames.AccumulativePromotionsHistory, customerId, outletId, promotionID, transactionId, promotionOptionDetail, valueToBeSaved, promotionOption.RelatedToTargetOption.RepeatCount, promotion.TargetMode, currentDate,dbHelper);
                                        else
                                            result = SaveInAccumulativePromotionsHistory(CoreDataBaseConstants.TableNames.TestAccumulativePromotionsHistory, customerId, outletId, promotionID, transactionId, promotionOptionDetail, valueToBeSaved, promotionOption.RelatedToTargetOption.RepeatCount, promotion.TargetMode, currentDate, dbHelper);
                                        if (result != GlobalErrors.Success)
                                            break;
                                    }
                                }
                                packID = -1;
                                packGroupID = -1;
                                invoiceDiscount = -1;
                                packDiscount = -1;
                                packQuantity = -1;
                            }
                        }
                        if (result != GlobalErrors.Success)
                            break;
                    }
                    if (result != GlobalErrors.Success)
                        break;
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        private GlobalErrors SaveInAccumulativePromotionsHistory(string tableName, int customerId, int outletId, int promotionID, string transactionId, PromotionOptionDetail promotionOptionDetail, decimal value,decimal repeatCount, int targetMode,DateTime currentDate, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            Object field = null;
            string promotedOnTransactionId = "";
            try {
                query = string.Format(@" insert into {10} (CustomerID,OutletId,PromotionID,TransactionID,PromotionOptionID,PromotionOptionDetailID,LastInvoiceDate,BenefitValue,RemainingValue,RepeatCount) values
                ({0},{1},{2},'{3}',{4},{5},{6},{7},{8},{9})", customerId, outletId, promotionID,transactionId, promotionOptionDetail.PromotionOptionId, promotionOptionDetail.PromotionOptionDetailId,
                (targetMode == TargetModes.LastInvoice.GetHashCode() || targetMode == TargetModes.LastInvoiceAccumulative.GetHashCode()) ? LocalUtilities.ParseDateAndTimeToSQL(currentDate) : "NULL", value, promotionOptionDetail.RemainingValue,repeatCount, tableName);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors SaveSatisfiedPrerequisitesHistory(string tableName, string transactionId, int customerId, int outletId, List<SatisfiedPrerequisitesDetails> satisfiedPrerequisites, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (satisfiedPrerequisites != null && satisfiedPrerequisites.Count > 0)
                {
                    foreach (SatisfiedPrerequisitesDetails satisfied in satisfiedPrerequisites)
                    {
                        query = string.Format(@" insert into {9} (CustomerID,OutletId,TransactionID,PromotionID,ItemId,PackId,PackGroupId,QuantityInPcs,SalesOrderTypeID) values
                ({0},{1},'{2}',{3},{4},{5},{6},{7},{8})", customerId, outletId, transactionId, satisfied.PromotionId, satisfied.ItemId, satisfied.PackId, satisfied.PackGroupId, satisfied.QuantityInPcs, satisfied.SalesOrderTypeId,tableName);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveProductDiscountBenefitValues(string tableName,string transactionId, int customerId, int outletId, List<ProductDiscountBenefitModel> productDiscountList, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (productDiscountList != null && productDiscountList.Count > 0)
                {
                    foreach (ProductDiscountBenefitModel prodDisc in productDiscountList)
                    {
                        query = string.Format(@" insert into {7} (CustomerID,OutletId,TransactionID,PromotionID,ItemId,PackId,ProductDiscountValue) values
                ({0},{1},'{2}',{3},{4},{5},{6})", customerId, outletId, transactionId, prodDisc.PromotionId, prodDisc.ItemId, prodDisc.PackId, prodDisc.ProductDiscountValue, tableName);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SavePromBenefitSequenceDetail(string tableName, string transactionId, int customerId, int outletId, List<BenefitSequenceDetails> benSeqDtls, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (benSeqDtls != null && benSeqDtls.Count > 0)
                {
                    foreach (BenefitSequenceDetails dtl in benSeqDtls)
                    {
                        query = string.Format(@" insert into {9} (CustomerID,OutletId,TransactionID,PromotionID,ItemId,PackId,Sequence,BenefitPGID,Value) values
                ({0},{1},'{2}',{3},{4},{5},{6},{7},{8})", customerId, outletId, transactionId, dtl.PromotionId, dtl.ItemId, dtl.PackId,dtl.Sequence,dtl.BenefitPGID, dtl.Value, tableName);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveTempBenefitSequenceDetails( int customerId, int outletId, List<BenefitSequenceDetails> benSeqDtls)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = new DBHelper<int>();
            try
            {
                string query = string.Empty;
                if (benSeqDtls != null && benSeqDtls.Count > 0)
                {
                    foreach (BenefitSequenceDetails dtl in benSeqDtls)
                    {
                        // Delete existing sequence data .
                        query = string.Format(@" DELETE FROM TempBenefitSequenceDetails Where Sequence ={0} AND SessionID = '{1}'",  dtl.Sequence, _requestRepository.SessionId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;
                        if (result != GlobalErrors.Success) return result;
                        // Insert new taken data .
                        query = string.Format(@" insert into TempBenefitSequenceDetails (SessionID,CustomerID,OutletId,PromotionID,ItemId,PackId,Sequence,BenefitPGID,Value) values
                            ('{0}',{1},{2},{3},{4},{5},{6},{7},{8})", _requestRepository.SessionId, customerId, outletId, dtl.PromotionId, dtl.ItemId, dtl.PackId, dtl.Sequence,dtl.BenefitPGID, dtl.Value);
                            result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteTempBenefitSequenceDetails()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                string query = string.Format(@"Delete From TempBenefitSequenceDetails Where SessionID = '{0}'", _requestRepository.SessionId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdatePromotionBenefitHistoryData(OrderModel order, List<Promotion> customerPromotions, PromotionBenefitTransactionTypes type, bool allowPromotion, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE FROM PromotionBenefitHistory WHERE TransactionID = '{0}'
                                               and CustomerID = {1} and OutletID = {2} and divisionId = {3}"
                                               , order.OrderId
                                               , order.Outlet.CustomerId
                                               , order.Outlet.OutletId
                                               , order.DivisionId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"DELETE FROM PromPrerequisitesHistory WHERE TransactionID = '{0}'
                                               and CustomerID = {1} and OutletID = {2} "
                                               , order.OrderId
                                               , order.Outlet.CustomerId
                                               , order.Outlet.OutletId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                }
                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode() && order.PromotionsForAllLevels != null && order.PromotionsForAllLevels.Count > 0)
                {
                    customerPromotions = order.PromotionsForAllLevels;
                }
                if (result == GlobalErrors.Success && allowPromotion && order.CustomerPromotions != null && order.CustomerPromotions.Count > 0)
                {

                    result = SavePromotionBenefitHistoryData(CoreDataBaseConstants.TableNames.PromotionBenefitHistory, order.OrderId, order.Outlet.CustomerId, order.Outlet.OutletId, order.DivisionId, order.EmployeeId, customerPromotions, type, dbHelper);
                }
                return result;
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors BuildPromotionBenefitQuery(string tableName,int packID, int packGroupID, decimal packDiscount, decimal invoiceDiscount
            , decimal packQuantity, PromotionOptionDetail option, int transactionTypeID, int repeatCount, string transactionId, int customerId, int outletId, int divisionId, int employeeId, DateTime currentDate, DBHelper<int> dbHelper, int salesOrderTypeId = -1, decimal priceValue = 0)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO {0}(" +
                                " TransactionID, PromotionID, PromotionOptionID, PromotionOptionDetailID, " +
                                " PromotionOptionDetailTypeID, PackID, CustomerID, OutletID, EmployeeID, " +
                                " RouteID, RouteHistoryID, PackGroupID, CreatedDate, " +
                                " InvoiceDiscountValue, PackDiscountValue, PackQuantity , TransactionTypeID,DivisionID,ExpiryDate, BatchNo , RepeatCount,SalesOrderTypeID,PriceValue)" +
                                " VALUES ('" + transactionId + "'" +
                                " ," + option.PromotionId.ToString() +
                                " ," + option.PromotionOptionId.ToString() +
                                " ," + option.PromotionOptionDetailId.ToString() +
                                " ," + ((int)option.OutputOptionDetailTypeId).ToString() +
                                " ," + packID.ToString() +
                                " ," + customerId.ToString() +
                                " ," + outletId.ToString() +
                                " ," + employeeId.ToString() +
                                " ," + -1 +
                                " ," + -1 +
                                " ," + (packGroupID == -1 ? "NULL" : packGroupID.ToString()) +
                                " ," + LocalUtilities.ParseDateAndTimeToSQL(currentDate) + // created Date
                                " ," + (invoiceDiscount == -1 ? "NULL" : invoiceDiscount.ToString()) +
                                " ," + (packDiscount == -1 ? "NULL" : packDiscount.ToString()) +
                                " ," + (packQuantity == -1 ? "NULL" : packQuantity.ToString()) +
                                " ," + transactionTypeID +
                                " ," + divisionId.ToString() +
                                " ," + LocalUtilities.ParseDateToSQLString(LocalUtilities.DefaultExpiryDate) +
                                " ,'" + "" + "'" +
                                " ," + (repeatCount > 0 ? repeatCount : 1) +
                                " ," + salesOrderTypeId +
                                " ," + (priceValue == 0 ? "NULL" : priceValue.ToString()) +
                                ")",tableName);

                result = dbHelper.ExecuteNonQuery(query.ToString());
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        private decimal CalculateAmountOverPackGroup(TransactionCommonData transactionCommonData, PromotionOptionDetail detail, bool isRelatedToTarget, List<ItemPackModel> soldItems, int promotionGroupId = -1, int priority = -1, bool byStockStatus = false)
        {
            decimal invoiceAmountOverPackGroup = 0;
            decimal discountValue = 0;
            decimal taxValue = 0;
            try
            {
                //List<SimpleItemPackModel> usedItemPacks = new List<SimpleItemPackModel>();
                List<int> listOfItemIds = new List<int>();
                List<int> listOfPackIds = new List<int>();
                List<ItemPackModel> commonItems = new List<ItemPackModel>();
                foreach (ItemPackModel soldItem in soldItems)
                {
                    discountValue += soldItem.CalculatedDiscountTotal;
                    taxValue += soldItem.CalculatedTax;
                }
                if (byStockStatus)
                {
                    commonItems = soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString()))).ToList();
                }
                else
                {
                    commonItems = soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId)).ToList();
                }

                if (commonItems != null && commonItems.Count > 0)
                {
                    if (isRelatedToTarget)
                    {
                        invoiceAmountOverPackGroup= commonItems.Sum(pack => pack.GrossTotal - (pack.GrossTotal * pack.Discount /100));
                    }
                    else if (_requestRepository.Configurations.AllowConversionInPromotion)
                    {
                        //if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotionGroupId > -1)
                        //{
                        //    usedItemPacks = ExcludeItemsIncludedInHigherPriorityPromotions(transactionCommonData, promotionGroupId,priority, ref listOfItemIds, ref commonItems);
                        //}
                        if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 0)
                        {
                             invoiceAmountOverPackGroup = commonItems.Sum(pack => pack.GrossTotal) - discountValue;
                        }
                        else if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 1)
                        {
                            invoiceAmountOverPackGroup = commonItems.Sum(pack => pack.GrossTotal);
                        }
                        else if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 2)
                        {
                            invoiceAmountOverPackGroup = commonItems.Sum(pack => pack.GrossTotal) - discountValue + taxValue;
                        }
                    }
                    else
                    {
                        var commonPacks = commonItems.Where(n => detail.PackGroupDetails.Any(o => o.PackId == n.PackId)).ToList();
                        //if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotionGroupId > -1)
                        //{
                        //    usedItemPacks = ExcludePacksIncludedInHigherPriorityPromotions(transactionCommonData, promotionGroupId, priority, ref listOfPackIds, ref commonPacks);
                        //}
                        if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 0)
                        {
                            invoiceAmountOverPackGroup = commonPacks.Sum(pack => pack.GrossTotal) - discountValue;
                        }
                        else if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 1)
                        {
                            invoiceAmountOverPackGroup = commonPacks.Sum(pack => pack.GrossTotal);
                        }
                        else if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 2)
                        {
                            invoiceAmountOverPackGroup = commonPacks.Sum(pack => pack.GrossTotal) - discountValue + taxValue;
                        }
                    }
                    //if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotionGroupId > -1 && priority >-1)
                    //{
                    //    CachePromotionGroupPriorities(ref transactionCommonData, promotionGroupId, priority, usedItemPacks);
                    //}
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return invoiceAmountOverPackGroup;
        }

        private bool CheckInputForSpecificPacksQuantity(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData)
        {
            bool isSatisfied = false;
            List<ItemPackModel> soldItems = new List<ItemPackModel>();
            decimal soldFromPackType = 0;
            try
            {
                if (!transationCommonData.IsExchangeInvoice)
                {
                    soldItems = transationCommonData.SoldItems;
                }
                else
                {
                    soldItems = transationCommonData.SoldItems.Where(a => a.IsReturnItem == false).ToList();
                }

                var commonPacks = soldItems.Where(a => a.PackTypeId == detail.PackTypeId).ToList();

                if (commonPacks != null && commonPacks.Count > 0)
                {
                    soldFromPackType = commonPacks.Sum(pack => pack.RequiredQty);

                    if (promotion.PromotionType == PromotionTypes.StepsValues)
                        soldFromPackType -= promotion.AmountOfPromotionSteps;
                    if (detail.Range == 0)
                    {
                        if (soldFromPackType >= detail.Value && soldFromPackType >= promotion.MinValue)
                        {
                            FillPromotionPreRequiesiteDetails(promotion, commonPacks, -1);
                            isSatisfied = true;
                            if (promotion.IsRepeated)
                            {
                                detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(soldFromPackType / detail.Value)));
                            }
                        }
                    }
                    else
                    {
                        if (soldFromPackType >= detail.Value && soldFromPackType <= (detail.Value + detail.Range))
                        {
                            FillPromotionPreRequiesiteDetails(promotion, commonPacks, -1);
                            isSatisfied = true;
                        }
                    }

                    if (isSatisfied && promotion.PromotionType == PromotionTypes.StepsValues)
                        promotion.AmountOfPromotionSteps += detail.RepeatCount * detail.Value;
                }

                return isSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public GlobalErrors FillPromotionPreRequiesiteDetails(Promotion promotion, List<ItemPackModel> appliedReq, int packGroupId)
        {
            return FillPromotionPreRequiesiteDetails(promotion, appliedReq, packGroupId,null);
        }
        public GlobalErrors FillPromotionPreRequiesiteDetails(Promotion promotion, List<ItemPackModel> appliedReq, int packGroupId, PromotionOptionDetail inputOptionDetail)
        {
            try
            {
                SatisfiedPrerequisitesDetails satisfiedPrerequisites = null;
                foreach (ItemPackModel itemPackModel in appliedReq)
                {
                    satisfiedPrerequisites = new SatisfiedPrerequisitesDetails();
                    satisfiedPrerequisites.PromotionId = promotion.PromotionId;
                    satisfiedPrerequisites.ItemId = itemPackModel.ItemId;
                    satisfiedPrerequisites.PackId = itemPackModel.PackId;
                    satisfiedPrerequisites.PackGroupId = packGroupId;
                    satisfiedPrerequisites.SalesOrderTypeId = itemPackModel.SalesOrderTypeId;
                    satisfiedPrerequisites.QuantityInPcs = itemPackModel.RequiredQty * itemPackModel.PiecesInPack;
                    if(inputOptionDetail != null && inputOptionDetail.PackGroupDetails != null && inputOptionDetail.PackGroupDetails.Count > 0)
                    {
                        if(inputOptionDetail.PackGroupDetails.Where(d => d.ItemId == itemPackModel.ItemId).FirstOrDefault() != null )
                        { 
                            satisfiedPrerequisites.QuantityInPrereqUOM = (itemPackModel.RequiredQty * itemPackModel.PiecesInPack) /
                                                        (inputOptionDetail.PackGroupDetails.Where(d => d.ItemId == itemPackModel.ItemId).FirstOrDefault().PackQuantity);
                        }
                        
                    }
                    if (promotion.SatisfiedPrerequisitesDetails == null) promotion.SatisfiedPrerequisitesDetails = new List<SatisfiedPrerequisitesDetails>();
                    if(itemPackModel.SalesOrderTypeId != -1)
                    {
                        if (promotion.SatisfiedPrerequisitesDetails.FindIndex(a => a.ItemId == satisfiedPrerequisites.ItemId && a.PackId == satisfiedPrerequisites.PackId && a.PackGroupId == packGroupId && a.PromotionId == promotion.PromotionId && a.SalesOrderTypeId == satisfiedPrerequisites.SalesOrderTypeId) < 0)
                        {
                            promotion.SatisfiedPrerequisitesDetails.Add(satisfiedPrerequisites);
                        }
                    }
                    else
                    {
                        if (promotion.SatisfiedPrerequisitesDetails.FindIndex(a => a.ItemId == satisfiedPrerequisites.ItemId && a.PackId == satisfiedPrerequisites.PackId && a.PackGroupId == packGroupId && a.PromotionId == promotion.PromotionId) < 0)
                        {
                            promotion.SatisfiedPrerequisitesDetails.Add(satisfiedPrerequisites);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        private bool CheckInputGroupPacksQuantity(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData, bool byStockStatus)
        {
            bool isSatisfied = false;
            var soldItems = new List<ItemPackModel>();
            var commonItems = new List<ItemPackModel>();
            List<PromotionLoyaltyHistory> promotionLoyaltyHistorieslist = new List<PromotionLoyaltyHistory>();
            try
            {
                // Range = Zero in this type
                if (!transationCommonData.IsExchangeInvoice)
                {
                    soldItems = transationCommonData.SoldItems;
                }
                else
                {
                    soldItems = transationCommonData.SoldItems.Where(a => a.IsReturnItem == false).ToList();
                }
                if(_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x=> x.ApprovalPrice > x.Price))
                {
                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                }
                if (_requestRepository.Configurations.AllowConversionInPromotion)
                {
                    // Get Item level data
                    if (byStockStatus)
                    {
                        commonItems = soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString()))).ToList();
                    }
                    else
                    {
                        commonItems = soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId)).ToList();
                    }
                    if (promotion.IsLoyaltyPromotion)
                    {
                        promotionLoyaltyHistorieslist = new List<PromotionLoyaltyHistory>();
                        var result = GetLoyalityQtyOrAmount(promotion, transationCommonData, ref promotionLoyaltyHistorieslist, -1);
                        if (result != GlobalErrors.Success) return false;
                    }
                }
                else
                {
                    // Get Pack level data
                    if (byStockStatus)
                    {
                        commonItems = soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString()))).ToList();
                    }
                    else
                    {
                        commonItems = soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId)).ToList();
                    }
                }

                if (detail.PackGroupDetails.FindAll(d => d.PromotionValue > 0).Count > commonItems.Count && !promotion.IsLoyaltyPromotion)
                    return false;

                foreach (var packInGroup in detail.PackGroupDetails)
                {
                    decimal neededQuantity = 0;
                    decimal soldQuantity = 0;
                    int itemRepeatCount = 0;
                    decimal loyalityQuantity = 0;

                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                    {
                        loyalityQuantity = promotionLoyaltyHistorieslist.Where(p => p.ItemId == packInGroup.ItemId).Sum(s => s.Quantity);
                        neededQuantity = detail.PackGroupDetails.Where(p => p.ItemId == packInGroup.ItemId).Sum(s => s.PackQuantity * s.PromotionValue);
                    }
                    else
                    {
                        neededQuantity = packInGroup.PromotionValue;
                    }

                    if (neededQuantity > 0)
                    {
                        if (soldItems.Any(a => a.ItemId == packInGroup.ItemId))
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {
                                if (byStockStatus)
                                {
                                    soldQuantity = GetItemSoldQuantityInPeices(soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.RequiredQty > 0 && packInGroup.SalesOrderTypeIDs.Contains(a.SalesOrderTypeId.ToString())).ToList());
                                }
                                else
                                {
                                    soldQuantity = GetItemSoldQuantityInPeices(soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.RequiredQty > 0).ToList());
                                }
                                soldQuantity += loyalityQuantity;
                            }
                            else
                            {
                                if (byStockStatus)
                                {
                                    soldQuantity = soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.PackId == packInGroup.PackId && packInGroup.SalesOrderTypeIDs.Contains(a.SalesOrderTypeId.ToString())).First().RequiredQty;
                                }
                                else
                                {
                                    soldQuantity = soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.PackId == packInGroup.PackId).First().RequiredQty;
                                }
                            }
                            
                            if (promotion.PromotionType == PromotionTypes.StepsValues)
                                soldQuantity -= promotion.AmountOfPromotionSteps;

                            if (soldQuantity >= neededQuantity && soldQuantity >= promotion.MinValue)
                            {
                                if (byStockStatus)
                                {
                                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.RequiredQty > 0 && packInGroup.SalesOrderTypeIDs.Contains(a.SalesOrderTypeId.ToString())).ToList(), detail.PackGroupId);
                                    }
                                    else
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.PackId == packInGroup.PackId && packInGroup.SalesOrderTypeIDs.Contains(a.SalesOrderTypeId.ToString())).ToList(), detail.PackGroupId);
                                    }
                                }
                                else
                                {
                                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.RequiredQty > 0).ToList(), detail.PackGroupId);
                                    }
                                    else
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.PackId == packInGroup.PackId).ToList(), detail.PackGroupId);
                                    }
                                }
                                

                                isSatisfied = true;

                                if (promotion.IsRepeated)
                                {
                                    itemRepeatCount = Convert.ToInt32(Math.Floor((double)(soldQuantity / neededQuantity)));
                                }

                                if (promotion.PromotionType == PromotionTypes.StepsValues)
                                {
                                    promotion.AmountOfPromotionSteps += itemRepeatCount * neededQuantity;
                                }
                            }
                            else
                            {
                                isSatisfied = false;
                            }
                        }
                        else
                        {
                            isSatisfied = false;
                        }

                        if (detail.RepeatCount == 0 || itemRepeatCount < detail.RepeatCount)
                        {
                            detail.RepeatCount = itemRepeatCount;
                        }

                        if (!isSatisfied) break;
                    }
                    else
                    {
                        if (byStockStatus)
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {

                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.RequiredQty > 0 && packInGroup.SalesOrderTypeIDs.Contains(a.SalesOrderTypeId.ToString())).ToList(), detail.PackGroupId);
                            }
                            else
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.PackId == packInGroup.PackId && packInGroup.SalesOrderTypeIDs.Contains(a.SalesOrderTypeId.ToString())).ToList(), detail.PackGroupId);
                            }
                        }
                        else
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {

                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.RequiredQty > 0).ToList(), detail.PackGroupId);
                            }
                            else
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == packInGroup.ItemId && a.PackId == packInGroup.PackId).ToList(), detail.PackGroupId);
                            }
                        }
                        isSatisfied = true;
                        continue;
                    }

                    
                }

                return isSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        private bool CheckInputInvoiceAmountOnPackGroup(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData,bool byStockStatus)
        {
            bool isSatisfied = false;
            decimal invoiceAmountOverPackGroup = 0;
            List<ItemPackModel> soldItems = new List<ItemPackModel>();
            List<int> listOfItemIds = new List<int>();
            List<int> listOfPackIds = new List<int>();
            List<SimpleItemPackModel> usedItemPacks = new List<SimpleItemPackModel>();
            List<ItemPackModel> commonItems = new List<ItemPackModel>();

            try
            {
                if (!transationCommonData.IsExchangeInvoice)
                {
                    soldItems = transationCommonData.SoldItems;
                }
                else
                {
                    soldItems = transationCommonData.SoldItems.Where(a => a.IsReturnItem == false).ToList();
                }
                if(_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x=> x.ApprovalPrice > x.Price))
                {
                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                }
                if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1)
                {
                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                    {
                        commonItems = soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId)).ToList();
                    }
                    else
                    {
                        commonItems = soldItems.Where(n => detail.PackGroupDetails.Any(o => o.PackId == n.PackId)).ToList();
                    }
                    usedItemPacks = ExcludeItemsIncludedInHigherPriorityPromotions(transationCommonData, promotion.PromotionGroupId, promotion.Priority, ref listOfItemIds, ref commonItems);
                }
                invoiceAmountOverPackGroup = CalculateAmountOverPackGroup(transationCommonData, detail,false, soldItems, promotion.PromotionGroupId, promotion.Priority, byStockStatus);
                if(_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority > -1)
                {
                    var promotionGroupObjs = transationCommonData.PromotionsGroupPriorities.Where(x => x.PromotionGroupId == promotion.PromotionGroupId && x.Priority < promotion.Priority).ToList();
                    if (promotionGroupObjs != null && promotionGroupObjs.Count > 0)
                    {
                        promotionGroupObjs.ForEach(obj =>
                        {
                            listOfItemIds.AddRange(obj.UsedItemPacks.Select(usedItem => usedItem.ItemId).ToList());
                            listOfPackIds.AddRange(obj.UsedItemPacks.Select(usedItem => usedItem.PackId).ToList());
                        });
                    }
                }
                if (promotion.PromotionType == PromotionTypes.StepsValues)
                    invoiceAmountOverPackGroup -= promotion.AmountOfPromotionSteps;

                if (detail.Range == 0)
                {
                    if (invoiceAmountOverPackGroup >= detail.Value && invoiceAmountOverPackGroup >= promotion.MinValue)
                    {
                        if (byStockStatus)
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString())) && !listOfItemIds.Contains(n.ItemId)).ToList(), detail.PackGroupId);
                            }
                            else
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString())) && !listOfPackIds.Contains(n.PackId)).ToList(), detail.PackGroupId);

                            }
                        }
                        else
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId) && !listOfItemIds.Contains(n.ItemId)).ToList(), detail.PackGroupId);
                            }
                            else
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId) && !listOfPackIds.Contains(n.PackId)).ToList(), detail.PackGroupId);

                            }
                        }


                        isSatisfied = true;
                        detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(invoiceAmountOverPackGroup / detail.Value)));
                    }
                }
                else
                {
                    if (invoiceAmountOverPackGroup >= detail.Value && invoiceAmountOverPackGroup <= (detail.Value + detail.Range))
                    {
                        if (byStockStatus)
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString())) && !listOfItemIds.Contains(n.ItemId)).ToList(), detail.PackGroupId);
                            }
                            else
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString())) && !listOfPackIds.Contains(n.PackId)).ToList(), detail.PackGroupId);
                            }
                        }
                        else
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId) && !listOfItemIds.Contains(n.ItemId)).ToList(), detail.PackGroupId);
                            }
                            else
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId) && !listOfPackIds.Contains(n.PackId)).ToList(), detail.PackGroupId);
                            }
                        }
                        isSatisfied = true;
                        detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(invoiceAmountOverPackGroup / detail.Value)));
                    }
                }
                if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority > -1 && isSatisfied)
                {
                    CachePromotionGroupPriorities(ref transationCommonData, promotion.PromotionGroupId, promotion.Priority, usedItemPacks);
                }
                if (isSatisfied && promotion.PromotionType == PromotionTypes.StepsValues)
                    promotion.AmountOfPromotionSteps += detail.RepeatCount * detail.Value;

                return isSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        private bool CheckInputInvoiceValue(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData)
        {
            bool isSatisfied = false;
            decimal invoiceValue = 0;
            decimal discountValue = 0;
            decimal taxValue = 0;
            decimal lotalityNetTotal = 0;
            decimal grossTotal = 0;
            List<ItemPackModel> soldEditPriceItems = new List<ItemPackModel>();
            try
            {
                soldEditPriceItems = transationCommonData.SoldItems;
                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && transationCommonData.SoldItems.Any(x=> x.ApprovalPrice > x.Price))
                {
                    soldEditPriceItems = soldEditPriceItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                }
                foreach (ItemPackModel soldItems in soldEditPriceItems)
                {
                    discountValue += soldItems.CalculatedDiscountTotal;
                    taxValue += soldItems.CalculatedTax;
                    grossTotal += soldItems.Price * soldItems.RequiredQty;
                }
                if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 0)
                {
                    invoiceValue = grossTotal - discountValue;
                }
                else if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 1)
                {
                    invoiceValue = grossTotal;
                }
                else if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 2)
                {
                    invoiceValue = grossTotal - discountValue + taxValue;
                }
                if (promotion.PromotionType == PromotionTypes.StepsValues)
                    invoiceValue -= promotion.AmountOfPromotionSteps;
                if (promotion.IsLoyaltyPromotion)
                {
                    List<PromotionLoyaltyHistory> promotionLoyaltyHistoryList = new List<PromotionLoyaltyHistory>();
                    var result = GetLoyalityQtyOrAmount(promotion, transationCommonData, ref promotionLoyaltyHistoryList, -1);
                    if (result == GlobalErrors.Success)
                    {
                        if (promotionLoyaltyHistoryList != null && promotionLoyaltyHistoryList.Count > 0)
                        {
                            foreach (var history in promotionLoyaltyHistoryList)
                            {
                                lotalityNetTotal += history.NetTotal;
                            }
                        }
                    }
                    else return false;
                }
                //Add totals from PromotionLoyaltyHistory to check satisfication          
                invoiceValue = invoiceValue + lotalityNetTotal;
                if (detail.Range == 0)
                {
                    if (invoiceValue >= detail.Value && invoiceValue >= promotion.MinValue)
                    {
                        isSatisfied = true;
                        detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(invoiceValue / detail.Value)));
                    }
                }
                else
                {
                    if (invoiceValue >= detail.Value && invoiceValue <= (detail.Value + detail.Range))
                    {
                        isSatisfied = true;
                        detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(invoiceValue / detail.Value)));
                    }
                }

                if (isSatisfied)
                {
                     FillPromotionPreRequiesiteDetails(promotion, soldEditPriceItems, -1);
                }
                if (isSatisfied && promotion.PromotionType == PromotionTypes.StepsValues)
                {
                    promotion.AmountOfPromotionSteps += detail.RepeatCount * detail.Value;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return isSatisfied;
        }

        private bool CheckInputItemAmount(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData)
        {
            bool isSatisfied = false;
            List<ItemPackModel> soldItems = new List<ItemPackModel>();
            decimal discountValue = 0;
            decimal taxValue = 0;
            List<SimpleItemPackModel> usedItemPacks = new List<SimpleItemPackModel>();
            List<int> listOfItemIds = new List<int>();
            List<int> listOfPackIds = new List<int>();
            try
            {
                if (!transationCommonData.IsExchangeInvoice)
                {
                    soldItems = transationCommonData.SoldItems;
                }
                else
                {
                    soldItems = transationCommonData.SoldItems.Where(a => a.IsReturnItem == false).ToList();
                }

                foreach (ItemPackModel soldItem in transationCommonData.SoldItems)
                {
                    discountValue += soldItem.CalculatedDiscountTotal;
                    taxValue += soldItem.CalculatedTax;
                }

                if (soldItems.Any(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId))
                {
                    if (!_requestRepository.Configurations.AllowConversionInPromotion)
                    {
                        if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority > -1)
                        {
                            soldItems = soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId).ToList();
                            usedItemPacks = ExcludePacksIncludedInHigherPriorityPromotions(transationCommonData, promotion.PromotionGroupId, promotion.Priority, ref listOfPackIds, ref soldItems);
                        }
                    }
                    decimal itemAmount = 0;
                    if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 0)
                    {
                        itemAmount = soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId).First().GrossTotal - discountValue;
                    }
                    else if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 1)
                    {
                        itemAmount = soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId).First().GrossTotal;
                    }
                    else if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 2)
                    {
                        itemAmount = soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId).First().GrossTotal - discountValue + taxValue;
                    }

                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                    {
                        if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority > -1)
                        {
                            soldItems = soldItems.Where(a => a.ItemId == detail.ItemId).ToList();
                            usedItemPacks = ExcludeItemsIncludedInHigherPriorityPromotions(transationCommonData, promotion.PromotionGroupId, promotion.Priority, ref listOfItemIds, ref soldItems);
                        }
                        itemAmount = GetItemSoldAmount(soldItems.Where(a => a.ItemId == detail.ItemId && a.RequiredQty > 0).ToList());
                    }

                    if (promotion.PromotionType == PromotionTypes.StepsValues)
                        itemAmount -= promotion.AmountOfPromotionSteps;

                    if (detail.Range == 0)
                    {
                        if (itemAmount >= detail.Value && itemAmount >= promotion.MinValue)
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == detail.ItemId && a.NetTotal > 0).ToList(), -1);
                            }
                            else
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId && a.NetTotal > 0).ToList(), -1);
                            }

                            isSatisfied = true;

                            if (promotion.IsRepeated)
                                detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(itemAmount / detail.Value)));
                        }
                    }
                    else
                    {
                        if (itemAmount >= detail.Value && itemAmount <= detail.Value + detail.Range)
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == detail.ItemId && a.NetTotal > 0).ToList(), -1);
                            }
                            else
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId && a.NetTotal > 0).ToList(), -1);
                            }
                            isSatisfied = true;
                            if (promotion.IsRepeated)
                                detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(itemAmount / detail.Value)));
                        }
                    }

                    if (isSatisfied && promotion.PromotionType == PromotionTypes.StepsValues)
                    {
                        promotion.AmountOfPromotionSteps += detail.RepeatCount * detail.Value;
                    }
                    if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority > -1 && isSatisfied)
                    {
                        CachePromotionGroupPriorities(ref transationCommonData, promotion.PromotionGroupId, promotion.Priority, usedItemPacks);
                    }
                }
                return isSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public void ExcludeBenefitItemsIncludedInHigherPriorityPromotions(TransactionCommonData transactionCommonData, int promotionGroupId, int priority, ref List<ItemPackModel> benefitItems)
        {
            try
            {
                List<int> excludedItemIds = new List<int>();
                List<int> excludedPackIds = new List<int>();
                if (_requestRepository.Configurations.ExcludeItemFromNextPromotion && _requestRepository.Configurations.ApplyPriorityOnPromotionGroups && priority > -1 && promotionGroupId > -1)
                {
                    var promotionGroupPriorities = transactionCommonData.PromotionsGroupPriorities.Where(priorityObj => priorityObj.PromotionGroupId == promotionGroupId && priorityObj.Priority < priority).ToList();
                    if (promotionGroupPriorities != null && promotionGroupPriorities.Count > 0)
                    {
                        promotionGroupPriorities.ForEach(obj =>
                        {
                            excludedItemIds.AddRange(obj.UsedItemPacks.Select(x => x.ItemId).ToList());
                            excludedPackIds.AddRange(obj.UsedItemPacks.Select(x => x.PackId).ToList());
                        });
                    }
                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                    {
                        benefitItems = benefitItems.Where(item => !excludedItemIds.Contains(item.ItemId)).ToList();
                    }
                    else
                    {
                        benefitItems = benefitItems.Where(item => !excludedPackIds.Contains(item.PackId)).ToList();
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public List<SimpleItemPackModel> ExcludeItemsIncludedInHigherPriorityPromotions(TransactionCommonData transactionCommonData, int promotionGroupId, int priority,ref List<int> excludedItemIds, ref List<ItemPackModel> soldItems)
        {
            List<SimpleItemPackModel> usedItemPacks = new List<SimpleItemPackModel>();
            List<int> listOfItemIds = new List<int>();
            try
            {
                var promotionGroupObjs = transactionCommonData.PromotionsGroupPriorities.Where(x => x.PromotionGroupId == promotionGroupId && x.Priority < priority).ToList();
                if (promotionGroupObjs != null && promotionGroupObjs.Count > 0)
                {
                    promotionGroupObjs.ForEach(obj =>
                    {
                        listOfItemIds.AddRange(obj.UsedItemPacks.Select(usedItem => usedItem.ItemId).ToList());
                    });
                    soldItems = soldItems.Where(item => !listOfItemIds.Contains(item.ItemId)).ToList();
                }
                usedItemPacks = soldItems.Select(item => new SimpleItemPackModel { ItemId = item.ItemId, PackId = item.PackId }).ToList();
                excludedItemIds = listOfItemIds;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
            return usedItemPacks;
        }
        public List<SimpleItemPackModel> ExcludePacksIncludedInHigherPriorityPromotions(TransactionCommonData transactionCommonData, int promotionGroupId, int priority,ref List<int> excludedPackIds, ref List<ItemPackModel> soldItems)
        {
            List<SimpleItemPackModel> usedItemPacks = new List<SimpleItemPackModel>();
            List<int> listOfPackIds = new List<int>();
            try
            {
                var promotionGroupObjs = transactionCommonData.PromotionsGroupPriorities.Where(x => x.PromotionGroupId == promotionGroupId && x.Priority < priority).ToList();
                if (promotionGroupObjs != null && promotionGroupObjs.Count > 0)
                {
                    promotionGroupObjs.ForEach(obj =>
                    {
                        listOfPackIds.AddRange(obj.UsedItemPacks.Select(usedItem => usedItem.PackId).ToList());
                    });
                    soldItems = soldItems.Where(item => !listOfPackIds.Contains(item.PackId)).ToList();
                }
                usedItemPacks = soldItems.Select(item => new SimpleItemPackModel { ItemId = item.ItemId, PackId = item.PackId }).ToList();
                excludedPackIds = listOfPackIds;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
            return usedItemPacks;
        }
        public void CachePromotionGroupPriorities(ref TransactionCommonData transactionCommonData, int promotionGroupId, int priority, List<SimpleItemPackModel> usedItemPacks)
        {
            try
            {
                int index = transactionCommonData.PromotionsGroupPriorities.FindIndex(g => g.PromotionGroupId == promotionGroupId && g.Priority == priority);
                if (index == -1)
                {
                    PromotionGroupPriorityModel obj = new PromotionGroupPriorityModel();
                    obj.PromotionGroupId = promotionGroupId;
                    obj.UsedItemPacks.AddRange(usedItemPacks);
                    obj.Priority = priority;
                    transactionCommonData.PromotionsGroupPriorities.Add(obj);
                }
                else
                {
                    var existingPackIds = transactionCommonData.PromotionsGroupPriorities[index].UsedItemPacks.Select(p => p.PackId).ToList();
                    transactionCommonData.PromotionsGroupPriorities[index].UsedItemPacks.AddRange(usedItemPacks.Where(i => !existingPackIds.Contains(i.PackId)).ToList());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        private bool CheckInputSummationOverGroup(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData,bool byStockStatus)
        {
            decimal totalOfGroup = 0;
            return CheckInputSummationOverGroup(promotion, detail, transationCommonData, byStockStatus, ref totalOfGroup);
        }
        private bool CheckInputSummationOverGroup(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData,bool byStockStatus, ref decimal totalOfGroup)
        {
            bool isSatisfied = false;
            List<ItemPackModel> soldItems = new List<ItemPackModel>();
            decimal packPcs = 0;
            totalOfGroup = 0;
            decimal totalOfGroupLoylty = 0;
            List<int> listOfItemIds = new List<int>(); // list of item ids to exclude based on promotion priority
            List<int> listOfPackIds = new List<int>(); // list of pack ids to exclude based on promotion priority
            List<SimpleItemPackModel> usedItemPacks = new List<SimpleItemPackModel>();
            List<ItemPackModel> commonItems = new List<ItemPackModel>();
            try
            {
                {

                    if (!transationCommonData.IsExchangeInvoice)
                    {
                        soldItems = transationCommonData.SoldItems;
                    }
                    else
                    {
                        soldItems = transationCommonData.SoldItems.Where(a => a.IsReturnItem == false).ToList();
                    }
                    if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x=> x.ApprovalPrice > x.Price))
                    {
                        soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                    }
                    if (byStockStatus)
                    {
                        commonItems = soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString()))).ToList();
                    }
                    else
                    {
                        commonItems = soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId)).ToList();
                    }
                    if (commonItems != null && commonItems.Count > 0)
                    {
                        if (_requestRepository.Configurations.AllowConversionInPromotion)
                        {
                            if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority > -1)
                            {
                                usedItemPacks = ExcludeItemsIncludedInHigherPriorityPromotions(transationCommonData,promotion.PromotionGroupId,promotion.Priority,ref  listOfItemIds, ref commonItems);
                            }
                            commonItems.ForEach(pack =>
                            {
                                if (detail.DefindPackGroupQuantities.Find(y => y.ItemId == pack.ItemId) != null && detail.DefindPackGroupQuantities.Find(y => y.ItemId == pack.ItemId).QtyInPcs > 0)
                                    packPcs += (pack.RequiredQty * pack.PiecesInPack) / detail.DefindPackGroupQuantities.Find(y => y.ItemId == pack.ItemId).QtyInPcs;                             
                            });
                            totalOfGroup = packPcs;
                            if (promotion.IsLoyaltyPromotion)
                            {
                                List<PromotionLoyaltyHistory> promotionLoyaltyHistoryList = new List<PromotionLoyaltyHistory>();
                                var result = GetLoyalityQtyOrAmount(promotion, transationCommonData, ref promotionLoyaltyHistoryList, -1);
                                if (result == GlobalErrors.Success)
                                {
                                    foreach (var history in promotionLoyaltyHistoryList)
                                    {
                                        if (detail.DefindPackGroupQuantities.Find(y => y.ItemId == history.ItemId) != null && detail.DefindPackGroupQuantities.Find(y => y.ItemId == history.ItemId).QtyInPcs > 0)
                                        {
                                            totalOfGroupLoylty += history.Quantity / detail.DefindPackGroupQuantities.Find(y => y.ItemId == history.ItemId).QtyInPcs;

                                        }
                                    }
                                }

                            }
                        }
                        else
                        {

                            var commonPacks = commonItems.Where(n => detail.PackGroupDetails.Any(o => o.PackId == n.PackId)).ToList();
                            if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1)
                            {
                                usedItemPacks = ExcludePacksIncludedInHigherPriorityPromotions(transationCommonData, promotion.PromotionGroupId, promotion.Priority, ref listOfPackIds,ref commonPacks);
                            }
                            if (commonPacks != null && commonPacks.Count > 0)
                                totalOfGroup = commonPacks.Sum(pack => pack.RequiredQty);
                        }

                        if (promotion.PromotionType == PromotionTypes.StepsValues)
                            totalOfGroup -= promotion.AmountOfPromotionSteps;
                        totalOfGroup = totalOfGroup + totalOfGroupLoylty;
                        if (detail.Range == 0)
                        {
                            if (totalOfGroup >= detail.Value && totalOfGroup >= promotion.MinValue)
                            {
                                if (byStockStatus)
                                {
                                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString())) && !listOfItemIds.Contains(n.ItemId)).ToList(), detail.PackGroupId);
                                    }
                                    else
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString())) && !listOfPackIds.Contains(n.PackId)).ToList(), detail.PackGroupId);
                                    }
                                }
                                else
                                {
                                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId) && !listOfItemIds.Contains(n.ItemId)).ToList(), detail.PackGroupId);
                                    }
                                    else
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId) && !listOfPackIds.Contains(n.PackId)).ToList(), detail.PackGroupId);
                                    }
                                }
                                isSatisfied = true;
                                if (promotion.IsRepeated) detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(totalOfGroup / detail.Value)));
                            }
                        }
                        else if (totalOfGroup > 0)
                        {

                            if (totalOfGroup >= detail.Value && totalOfGroup <= detail.Value + detail.Range)
                            {
                                if (byStockStatus)
                                {
                                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString())) && !listOfItemIds.Contains(n.ItemId)).ToList(), detail.PackGroupId);
                                    }
                                    else
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId && o.SalesOrderTypeIDs.Contains(n.SalesOrderTypeId.ToString())) && !listOfPackIds.Contains(n.PackId)).ToList(), detail.PackGroupId);
                                    }
                                }
                                else
                                {
                                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId) && !listOfItemIds.Contains(n.ItemId)).ToList(), detail.PackGroupId);
                                    }
                                    else
                                    {
                                        FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(n => detail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId) && !listOfPackIds.Contains(n.PackId)).ToList(), detail.PackGroupId);
                                    }
                                }
                                isSatisfied = true;
                            }
                        }
                        if (promotion.IsLoyaltyPromotion && promotion.EchoShowAchinment)
                        {
                            if (promotion.IsTaken)
                            {
                                promotion.IsSatisfied = false;
                                promotion.IsSatisfied = isSatisfied;
                                return isSatisfied;
                            }
                            if (promotion.IsSatisfied && !promotion.IsTaken)
                            {
                                promotion.IsSatisfied = true;
                                promotion.IsSatisfied = isSatisfied;
                                return isSatisfied;
                            }
                            if (!promotion.IsTaken && !promotion.IsTaken)
                            {
                                List<PromotionLoyaltyHistory> promotionLoyaltyHistorieslist = new List<PromotionLoyaltyHistory>();
                                foreach (PromotionOption inputDetails in promotion.PromotionInputs)
                                {
                                    foreach (PromotionOptionDetail detls in inputDetails.PromotionOptionDetails)
                                    {
                                        var result = GetPromotionLoyaltyHistory(promotion.PromotionId, ref promotionLoyaltyHistorieslist);

                                        if (result == GlobalErrors.Success)
                                        {
                                            decimal sum = 0;
                                            if (promotionLoyaltyHistorieslist.Count > 0)
                                            {
                                                foreach (ItemPackModel item in soldItems)
                                                {
                                                    if (promotionLoyaltyHistorieslist.Where(x => x.ItemId == item.ItemId).ToList().Count > 0 && 
                                                        commonItems.Where(x => x.ItemId == item.ItemId).ToList().Count > 0)
                                                    {
                                                        var total = (item.RequiredQty * item.PiecesInPack) + promotionLoyaltyHistorieslist.Find(x => x.ItemId == item.ItemId).Quantity;
                                                        sum += total;
                                                    }
                                                }
                                                if (sum >= detls.Value)
                                                {
                                                    isSatisfied = true;
                                                    promotion.IsSatisfied = isSatisfied;
                                                    return isSatisfied;
                                                }
                                                else
                                                {
                                                    isSatisfied = false;
                                                    promotion.IsSatisfied = isSatisfied;
                                                    return isSatisfied;
                                                }
                                            }
                                            else
                                            {
                                                foreach (ItemPackModel item in soldItems)
                                                {
                                                    sum += item.RequiredQty;
                                                }
                                                if (sum >= detls.Value)
                                                {
                                                    isSatisfied = true;
                                                }
                                            }
                                        }
                                    }
                                }
                                ///////
                            }
                        }
                        if (isSatisfied && promotion.PromotionType == PromotionTypes.StepsValues)
                            promotion.AmountOfPromotionSteps += detail.Value * detail.RepeatCount;
                        if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority > -1 && isSatisfied)
                        {
                            CachePromotionGroupPriorities(ref transationCommonData, promotion.PromotionGroupId, promotion.Priority, usedItemPacks);
                        }

                    }
                }
                return isSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }  
        private GlobalErrors GetPromotionLoyaltyHistory(int PromotionId, ref List<PromotionLoyaltyHistory> list)
        {
            var result = GlobalErrors.Success;
            DBHelper<PromotionLoyaltyHistory> dBHelper;
            try
            {
                dBHelper = new DBHelper<PromotionLoyaltyHistory>();
                list = new List<PromotionLoyaltyHistory>();
                string query = String.Format(@"SELECT  PromotionLoyaltyHistory.PromotionID, PromotionLoyaltyHistory.CustomerID, PromotionLoyaltyHistory.OutletID, PromotionLoyaltyHistory.PackID, PromotionLoyaltyHistory.Quantity, PromotionLoyaltyHistory.NetTotal, 
                        Pack.ItemID FROM PromotionLoyaltyHistory inner join Pack on PromotionLoyaltyHistory.PackId = Pack.packId WHERE (PromotionID = {0}) AND (CustomerID = {1}) AND (OutletID = {2})",
                    PromotionId, _requestRepository.CurrentEchoOperator.CustomerId, _requestRepository.CurrentEchoOperator.OutletId);
                result = dBHelper.GetQueryList(query, ref list);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors GetPromotionLoyaltyHistory(int PromotionId, int CustomerId, int OutletId, int ItemId, ref List<PromotionLoyaltyHistory> promotionLoyaltyHistoryList)
        {
            var result = GlobalErrors.Success;
            DBHelper<PromotionLoyaltyHistory> dBHelper;
            try
            {
                dBHelper = new DBHelper<PromotionLoyaltyHistory>();
                promotionLoyaltyHistoryList = new List<PromotionLoyaltyHistory>();
                string itemFilter = string.Empty;
                if (ItemId != -1)
                    itemFilter = string.Format(@" and Item.ItemID = {0}", ItemId);

                string query = string.Format(@"SELECT PLH.PromotionID, PLH.CustomerID, PLH.OutletID, PLH.PackID, PLH.Quantity, PLH.NetTotal, Item.ItemId
                        FROM PromotionLoyaltyHistory PLH inner join 
                             Pack on Pack.PackID = PLH.PackID inner join 
	                         Item on Pack.ItemID = Item.ItemID {3}
                        WHERE (PLH.PromotionID = {0}) AND (PLH.CustomerID = {1}) AND (PLH.OutletID = {2})",
                    PromotionId, CustomerId, OutletId, itemFilter);
                result = dBHelper.GetQueryList(query, ref promotionLoyaltyHistoryList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

       
        public bool isPromotionIDExistsInLoyaltyStatus(int promotionID, int customerID, int outletID)
        {

            GlobalErrors result = GlobalErrors.NotInitialized;
            PromotionLoyaltyStatus field = new PromotionLoyaltyStatus();
            DBHelper<PromotionLoyaltyStatus> dBHelper = new DBHelper<PromotionLoyaltyStatus>();
            try
            {
                string query = string.Format(@"select * from PromotionLoyaltyStatus where PromotionID={0} and CustomerID={1} and OutletID={2} "
                        , promotionID + "", customerID + "", outletID + "");
                result = dBHelper.GetQuerySingle(query, ref field);
                if (field != null)
                {
                    return true;
                }
                return false;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        public GlobalErrors SaveLoyality(List<Promotion> customerPromotions, int CustomerId, int OutletId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (var promortion in customerPromotions)
                {
                    if (isPromotionIDExistsInLoyaltyStatus(promortion.PromotionId, CustomerId, OutletId))
                    {
                        result = UpdatePromotionLoyaltyStatus(promortion, CustomerId, OutletId, dBHelper);
                    }
                    else
                    {
                        result = SavePromotionLoyaltyStatus(promortion, CustomerId, OutletId, dBHelper);
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetLoyalityQtyOrAmount(Promotion promotion, TransactionCommonData transactionCommonData, ref List<PromotionLoyaltyHistory> promotionLoyaltyHistoryList, int ItemId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!transactionCommonData.DontCheckLoyalty && transactionCommonData.LoyaltyPromotionsList.Count() > 0)
                {
                    if (!transactionCommonData.LoyaltyPromotionsList.Contains(promotion.PromotionId))
                    {
                        promotion.IsSatisfied = false;
                        return GlobalErrors.Success;
                    }
                    else
                    {
                        result = GetPromotionLoyaltyHistory(promotion.PromotionId, transactionCommonData.CustomerId, transactionCommonData.OutletId, ItemId, ref promotionLoyaltyHistoryList);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                else
                {
                    result = GetPromotionLoyaltyHistory(promotion.PromotionId, transactionCommonData.CustomerId, transactionCommonData.OutletId, ItemId, ref promotionLoyaltyHistoryList);
                    if (result != GlobalErrors.Success) return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SavePromotionLoyaltyStatus(Promotion Promotion, int CustomerId, int OutletId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.Success;
            try
            {
                string query = string.Format(@"INSERT INTO PromotionLoyaltyStatus VALUES ({0}, {1}, {2}, 0, 1, 1, - 1)", Promotion.PromotionId, CustomerId, OutletId, Promotion.IsSatisfied, Promotion.IsTaken);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdatePromotionLoyaltyStatus(Promotion Promotion, int CustomerId, int OutletId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.Success;
            try
            {
                string query = string.Format(@"UPDATE PromotionLoyaltyStatus SET IsSatisfied = 1, IsTaken = 1
                    WHERE (PromotionID = {0}) AND (CustomerID = {1}) AND (OutletID = {2})", Promotion.PromotionId, CustomerId, OutletId, Promotion.IsSatisfied, Promotion.IsTaken);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
       
        private bool CheckInputPackQuantity(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData)
        {
            bool isSatisfied = false;
            decimal soldQuantity = 0;
            decimal lotalitySoldQuantity = 0;
            List<ItemPackModel> soldItems = new List<ItemPackModel>();
            List<int> listOfItemIds = new List<int>();
            List<int> listOfPackIds = new List<int>();
            List<SimpleItemPackModel> usedItemPacks = new List<SimpleItemPackModel>();
            try
            {
                if (!transationCommonData.IsExchangeInvoice)
                {
                    soldItems = transationCommonData.SoldItems;
                }
                else
                {
                    soldItems = transationCommonData.SoldItems.Where(a => a.IsReturnItem == false).ToList();
                }
                if(_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x=> x.ApprovalPrice > x.Price))
                {
                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                }
                if (soldItems.Any(a => a.ItemId == detail.ItemId))
                {
                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                    {
                        if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority > -1)
                        {
                            soldItems = soldItems.Where(a => a.ItemId == detail.ItemId).ToList();
                            usedItemPacks = ExcludeItemsIncludedInHigherPriorityPromotions(transationCommonData, promotion.PromotionGroupId, promotion.Priority, ref listOfItemIds,ref soldItems);
                        }
                        soldQuantity = GetItemSoldQuantityInPeices(soldItems.Where(a => a.ItemId == detail.ItemId && a.RequiredQty > 0).ToList());
                        if (promotion.IsLoyaltyPromotion)
                        {
                            List<PromotionLoyaltyHistory> promotionLoyaltyHistoryList = new List<PromotionLoyaltyHistory>();
                            var result = GetLoyalityQtyOrAmount(promotion, transationCommonData, ref promotionLoyaltyHistoryList, detail.ItemId);
                            if (result == GlobalErrors.Success)
                            {
                                if (promotionLoyaltyHistoryList != null && promotionLoyaltyHistoryList.Count > 0)
                                {
                                    foreach (var history in promotionLoyaltyHistoryList)
                                    {
                                        lotalitySoldQuantity += history.Quantity;
                                    }
                                }
                            }
                            else return false;
                        }
                    }
                    else
                    {
                        if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority > -1)
                        {
                            soldItems = soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId).ToList();
                            usedItemPacks = ExcludePacksIncludedInHigherPriorityPromotions(transationCommonData, promotion.PromotionGroupId, promotion.Priority,ref listOfPackIds, ref soldItems);
                        }
                        soldQuantity = soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId).First().RequiredQty * soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId).First().PiecesInPack;
                    }

                    soldQuantity = soldQuantity + lotalitySoldQuantity;
                    detail.Value = detail.Value * detail.PiecesInPack;
                    detail.Range = detail.Range * detail.PiecesInPack;

                    if (promotion.PromotionType == PromotionTypes.StepsValues)
                        soldQuantity -= promotion.AmountOfPromotionSteps;

                    if (detail.Range == 0)
                    {
                        if (soldQuantity >= detail.Value && soldQuantity >= promotion.MinValue)
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == detail.ItemId && a.RequiredQty > 0).ToList(), -1);
                            }
                            else
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId && a.RequiredQty > 0).ToList(), -1);
                            }

                            isSatisfied = true;

                            if (promotion.IsRepeated)
                            {
                                detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(soldQuantity / detail.Value)));
                            }

                            if (promotion.PromotionType == PromotionTypes.StepsValues)
                            {
                                promotion.AmountOfPromotionSteps += detail.RepeatCount * detail.Value;
                            }
                        }
                    }
                    else
                    {
                        if (soldQuantity >= detail.Value && soldQuantity <= detail.Value + detail.Range)
                        {
                            if (_requestRepository.Configurations.AllowConversionInPromotion)
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == detail.ItemId && a.RequiredQty > 0).ToList(), -1);
                            }
                            else
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId && a.RequiredQty > 0).ToList(), -1);
                            }
                            isSatisfied = true;
                        }
                    }
                    if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority > -1 && isSatisfied)
                    {
                        CachePromotionGroupPriorities(ref transationCommonData, promotion.PromotionGroupId, promotion.Priority, usedItemPacks);
                    }
                }
                return isSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        private bool CheckInputItemQuantityFromDivision(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData)
        {
            bool isSatisfied = false;
            List<ItemPackModel> soldItems = new List<ItemPackModel>();
            decimal soldQuantity = 0;
            try
            {
                if (!transationCommonData.IsExchangeInvoice)
                {
                    soldItems = transationCommonData.SoldItems;
                }
                else
                {
                    soldItems = transationCommonData.SoldItems.Where(a => a.IsReturnItem == false).ToList();
                }
                if (soldItems.Any(a => a.DivisionId == detail.DivisionId))
                {
                    soldQuantity = GetItemsQuantityInDivision(soldItems.Where(a => a.DivisionId == detail.DivisionId && a.RequiredQty > 0).ToList());
                   
                    if (promotion.PromotionType == PromotionTypes.StepsValues)
                        soldQuantity -= promotion.AmountOfPromotionSteps;

                    if (detail.Range == 0)
                    {
                        if (soldQuantity >= detail.Value && soldQuantity >= promotion.MinValue)
                        {
                            FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.DivisionId == detail.DivisionId && a.RequiredQty > 0).ToList(), -1);
                            isSatisfied = true;
                            if (promotion.IsRepeated)
                            {
                                detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(soldQuantity / detail.Value)));
                            }

                            if (promotion.PromotionType == PromotionTypes.StepsValues)
                            {
                                promotion.AmountOfPromotionSteps += detail.RepeatCount * detail.Value;
                            }
                        }
                    }
                    else
                    {
                        if (soldQuantity >= detail.Value && soldQuantity <= detail.Value + detail.Range)
                        {
                            FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.DivisionId == detail.DivisionId && a.RequiredQty > 0).ToList(), -1);
                            isSatisfied = true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return isSatisfied;
        }

        private bool CheckInputGroupItemsQuantity(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData)
        {
            bool isSatisfied = false;
            List<ItemPackModel> soldItems = new List<ItemPackModel>();
            decimal numberOfPackGroupSoldItems = 0;
            List<SimpleItemPackModel> usedItemPacks = new List<SimpleItemPackModel>();
            List<int> listOfItemIds = new List<int>();
            try
            {
                if (!transationCommonData.IsExchangeInvoice)
                {
                    soldItems = transationCommonData.SoldItems;
                }
                else
                {
                    soldItems = transationCommonData.SoldItems.Where(a => a.IsReturnItem == false).ToList();
                }

                var commonItem = soldItems.Where(pack => detail.PromotionGroupItems.Any(o => o == pack.ItemId)).ToList();
                commonItem = commonItem.GroupBy(item => item.ItemId)
                   .Select(grp => grp.First())
                   .ToList();

                if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && promotion.Priority >-1)
                {
                    usedItemPacks = ExcludeItemsIncludedInHigherPriorityPromotions(transationCommonData, promotion.PromotionGroupId, promotion.Priority,ref listOfItemIds, ref commonItem);
                }
                if (commonItem != null && commonItem.Count > 0)
                {
                    numberOfPackGroupSoldItems = commonItem.Count;

                    if (promotion.PromotionType == PromotionTypes.StepsValues)
                        numberOfPackGroupSoldItems -= promotion.AmountOfPromotionSteps;

                    if (detail.Range == 0)
                    {
                        if (numberOfPackGroupSoldItems >= detail.Value && numberOfPackGroupSoldItems >= promotion.MinValue)
                        {
                            FillPromotionPreRequiesiteDetails(promotion, commonItem, detail.PackGroupId);
                            isSatisfied = true;
                            if (promotion.IsRepeated) detail.RepeatCount = Convert.ToInt32(Math.Floor((double)(numberOfPackGroupSoldItems / detail.Value)));
                        }
                    }
                    else
                    {
                        if (numberOfPackGroupSoldItems >= detail.Value && numberOfPackGroupSoldItems <= detail.Value + detail.Range)
                        {
                            FillPromotionPreRequiesiteDetails(promotion, commonItem, detail.PackGroupId);
                            isSatisfied = true;
                        }
                    }

                    if (isSatisfied && promotion.PromotionType == PromotionTypes.StepsValues)
                    {
                        promotion.AmountOfPromotionSteps += detail.RepeatCount * detail.Value;
                    }
                    if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups && _requestRepository.Configurations.ExcludeItemFromNextPromotion && promotion.PromotionGroupId > -1 && isSatisfied)
                    {
                        CachePromotionGroupPriorities(ref transationCommonData, promotion.PromotionGroupId, promotion.Priority, usedItemPacks);
                    }
                }
                return isSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        private bool CheckPromoOutputs(Promotion promotion, List<ItemPackModel> soldItems)
        {
            bool isSatesfied = true;
            try
            {
                List<PromotionOption> removedOptions = new List<PromotionOption>();
                foreach (PromotionOption outputDetails in promotion.PromotionOutputs)
                {
                    isSatesfied = true;

                    foreach (PromotionOptionDetail detail in outputDetails.PromotionOptionDetails)
                    {
                        if (_requestRepository.Configurations.AllowConversionInPromotion)
                        {
                            if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountAmountForItem)
                            {
                                if (soldItems.Any(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId))
                                {
                                    isSatesfied = true;
                                }
                                else
                                {
                                    isSatesfied = false;
                                    break;
                                }
                            }
                            else if(detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForItem)
                            {
                                if (soldItems.Any(a => a.ItemId == detail.ItemId))
                                {
                                    isSatesfied = true;
                                }
                                else
                                {
                                    isSatesfied = false;
                                    break;
                                }
                            }
                            else if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountAmountForGroupItems)
                            {
                                // check if at least one pack exist 
                                if (soldItems.Any(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && (o.PackId == pack.PackId || _requestRepository.Configurations.AllowConversionInPromotion))))
                                {
                                    isSatesfied = true;
                                }
                                else
                                {
                                    isSatesfied = false;
                                    break;
                                }

                            }
                            else if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems)
                            {
                                // check if at least one item exist 
                                if (soldItems.Any(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId)))
                                {
                                    isSatesfied = true;
                                }
                                else
                                {
                                    isSatesfied = false;
                                    break;
                                }
                            }
                            else if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountAmountOverGroup)
                            {
                                // check if at least one item exist 
                                if (soldItems.Any(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId)))
                                {
                                    isSatesfied = true;
                                }
                                else
                                {
                                    isSatesfied = false;
                                    break;
                                }
                            }
                            else if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems)
                            {
                                decimal soldItemsTotalQuantityInPcs = 0, value = 0;
                                if (soldItems.Any(a => a.ItemId == detail.ItemId))
                                {
                                    var items = soldItems.Where(a => a.ItemId == detail.ItemId).ToList();
                                    soldItemsTotalQuantityInPcs = items.Sum(item => item.RequiredQty * item.PiecesInPack);
                                    soldItemsTotalQuantityInPcs = soldItemsTotalQuantityInPcs / detail.PiecesInPack;
                                    value = decimal.Round(soldItemsTotalQuantityInPcs * detail.Value / 100, MidpointRounding.ToZero);
                                    if (value > 0)
                                    {
                                        isSatesfied = true;
                                    }
                                    else
                                    {
                                        isSatesfied = false;
                                        break;
                                    }
                                }
                            }
                            else if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems)
                            {
                                decimal soldItemsTotalQuantityInPcs = 0, value = 0;
                                foreach(PromotionGroupPackDetail item in detail.PackGroupDetails)
                                {
                                    if(soldItems.Any(x=> x.ItemId == item.ItemId))
                                    {
                                        soldItemsTotalQuantityInPcs = soldItems.Sum(item => item.RequiredQty * item.PiecesInPack);
                                        soldItemsTotalQuantityInPcs = soldItemsTotalQuantityInPcs / item.PackQuantity;
                                        value = decimal.Round(soldItemsTotalQuantityInPcs * detail.Value / 100, MidpointRounding.ToZero);
                                        if (value > 0)
                                        {
                                            isSatesfied = true;
                                        }
                                        else
                                        {
                                            isSatesfied = false;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        else
                        {
                            if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountAmountForItem
                           || detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForItem)
                            {
                                if (soldItems.Any(a => a.ItemId == detail.ItemId && a.PackId == detail.PackId))
                                {
                                    isSatesfied = true;
                                }
                                else
                                {
                                    isSatesfied = false;
                                    break;
                                }
                            }
                            else if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountAmountForGroupItems)
                            {
                                // check if at least one pack exist 
                                if (soldItems.Any(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && o.PackId == pack.PackId)))
                                {
                                    isSatesfied = true;
                                }
                                else
                                {
                                    isSatesfied = false;
                                    break;
                                }

                            }
                            else if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems)
                            {
                                // check if at least one item exist 
                                if (soldItems.Any(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId)))
                                {
                                    isSatesfied = true;
                                }
                                else
                                {
                                    isSatesfied = false;
                                    break;
                                }
                            }
                            else if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountAmountOverGroup)
                            {
                                // check if at least one item exist 
                                if (soldItems.Any(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId)))
                                {
                                    isSatesfied = true;
                                }
                                else
                                {
                                    isSatesfied = false;
                                    break;
                                }
                            }
                            else if(detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems)
                            {
                                decimal soldItemsTotalQuantityInPcs = 0, value = 0;
                                if (soldItems.Any(a => a.ItemId == detail.ItemId))
                                {
                                    var items = soldItems.Where(a => a.ItemId == detail.ItemId).ToList();
                                    soldItemsTotalQuantityInPcs = items.Sum(item => item.RequiredQty * item.PiecesInPack);
                                    soldItemsTotalQuantityInPcs = soldItemsTotalQuantityInPcs / detail.PiecesInPack;
                                    value = decimal.Round(soldItemsTotalQuantityInPcs * detail.Value / 100, MidpointRounding.AwayFromZero);
                                    if (value > 0)
                                    {
                                        isSatesfied = true;
                                    }
                                    else
                                    {
                                        isSatesfied = false;
                                        break;
                                    }
                                }
                            }
                            else if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems)
                            {
                                decimal soldItemsTotalQuantityInPcs = 0, value = 0;
                                foreach (PromotionGroupPackDetail item in detail.PackGroupDetails)
                                {
                                    if (soldItems.Any(x => x.ItemId == item.ItemId))
                                    {
                                        soldItemsTotalQuantityInPcs = soldItems.Sum(item => item.RequiredQty * item.PiecesInPack);
                                        soldItemsTotalQuantityInPcs = soldItemsTotalQuantityInPcs / item.PackQuantity;
                                        value = decimal.Round(soldItemsTotalQuantityInPcs * detail.Value / 100, MidpointRounding.AwayFromZero);
                                        if (value > 0)
                                        {
                                            isSatesfied = true;
                                        }
                                        else
                                        {
                                            isSatesfied = false;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                       
                    }

                    if (!isSatesfied)
                    {
                        removedOptions.AddRange(promotion.PromotionOutputs.FindAll(a => a.PromotionOptionId == outputDetails.PromotionOptionId).ToList());
                        //cause exception Collection was modified:
                        // promotion.PromotionOutputs.RemoveAll(a => a.PromotionOptionId == outputDetails.PromotionOptionId);
                    }
                }
                if (removedOptions != null && removedOptions.Count > 0)
                {
                    promotion.PromotionOutputs.RemoveAll(x => removedOptions.Any(y => y.PromotionOptionId == x.PromotionOptionId));
                }
                if (promotion.PromotionOutputs.Count > 0)
                {
                    isSatesfied = true;
                }

                return isSatesfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        private bool CheckPromotionInputDetail(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData , ref decimal maxSatisfiedAmount, ref int maxValueOptionDetail, ref int numberOfWholeSaleDetails)
        {
            bool isSatisfied = false;
            bool byStockStatus = false;
            try
            {
                switch (detail.InputOptionDetailTypeId)
                {
                    case PromotionInputDetailTypes.ItemQuantityFromDivision:
                        isSatisfied = CheckInputItemQuantityFromDivision(promotion, detail, transationCommonData);//must OK
                        break;
                    case PromotionInputDetailTypes.ItemQuantity:
                        isSatisfied = CheckInputPackQuantity(promotion, detail, transationCommonData);//must OK
                        break;
                    case PromotionInputDetailTypes.ItemAmount:
                        isSatisfied = CheckInputItemAmount(promotion, detail, transationCommonData);//must OK
                        break;
                    case PromotionInputDetailTypes.InvoiceValue:
                        isSatisfied = CheckInputInvoiceValue(promotion, detail, transationCommonData);
                        break;
                    case PromotionInputDetailTypes.InvoiceAmountOnPackGroup:
                        isSatisfied = CheckInputInvoiceAmountOnPackGroup(promotion, detail, transationCommonData,false);//must OK
                        break;
                    case PromotionInputDetailTypes.InvoiceAmountOnPackGroupOnTypeLevel:
                        byStockStatus = true;
                        isSatisfied = CheckInputInvoiceAmountOnPackGroup(promotion, detail, transationCommonData, byStockStatus);//must OK
                        break;
                    case PromotionInputDetailTypes.UOMOverAllItems:
                        isSatisfied = CheckInputForSpecificPacksQuantity(promotion, detail, transationCommonData);//must ok
                        break;
                    case PromotionInputDetailTypes.SummationOverGroupOnTypeLevel:
                        byStockStatus = true;
                        isSatisfied = CheckInputSummationOverGroup(promotion, detail, transationCommonData, byStockStatus);//must ok
                        break;
                    case PromotionInputDetailTypes.SummationOverGroup:
                        isSatisfied = CheckInputSummationOverGroup(promotion, detail, transationCommonData, false);//must ok
                        break;
                    case PromotionInputDetailTypes.GroupEqualQuantity:
                    case PromotionInputDetailTypes.GroupDifferntQuantity:
                        isSatisfied = CheckInputGroupPacksQuantity(promotion, detail, transationCommonData,false);//must ok
                        break;
                    case PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel:
                        byStockStatus = true;
                        isSatisfied = CheckInputGroupPacksQuantity(promotion, detail, transationCommonData, byStockStatus);
                        break;
                    case PromotionInputDetailTypes.CertainNumberOfItemsOverGroup:
                        isSatisfied = CheckInputGroupItemsQuantity(promotion, detail, transationCommonData);//must ok
                        break;
                    case PromotionInputDetailTypes.CustomerMonthlyAchievement:
                        isSatisfied = CheckCustomerMonthlyAchievements(promotion, detail, transationCommonData);
                        break;
                    case PromotionInputDetailTypes.CustomerMonthlyWholesalesContracts:
                        isSatisfied = CheckCustomerMonthlyWholesalesContracts(promotion, detail, transationCommonData , ref maxSatisfiedAmount, ref maxValueOptionDetail, ref numberOfWholeSaleDetails);
                        break;
                    case PromotionInputDetailTypes.DynamicTargetSalesAmount:
                        isSatisfied = CheckCustomerDynamicTargetSalesAmount(promotion, detail, transationCommonData , ref maxSatisfiedAmount, ref maxValueOptionDetail);
                        break;
                    case PromotionInputDetailTypes.DynamicTargetSummationOverGroup:
                        isSatisfied = CheckCustomerDynamicTargetSummationOverGroup(promotion, detail, transationCommonData, ref maxSatisfiedAmount, ref maxValueOptionDetail);
                        break;
                    case PromotionInputDetailTypes.ItemWithNoSalesInCertainPeriodRestrictedToInvoicesCount:
                        isSatisfied = CheckInputNumberOfInvoicesOverItemInCertainPeriod(promotion, detail, transationCommonData);
                        break;
                    case PromotionInputDetailTypes.GroupWithNoSalesInCertainPeriodRestrictedToInvoicesCount:
                        isSatisfied = CheckInputNumberOfInvoicesOverGroupInCertainPeriod(promotion, detail, transationCommonData);
                        break;
                    //case PromotionInputDetailTypes.SummationOverGroupOnTypeLevel:
                    //    isSatisfied = CheckInputSummationOverGroupOnTypeLevel(promotion, detail, transationCommonData);//must ok
                    //    break;
                }
                
                return isSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        private bool CheckCustomerMonthlyWholesalesContracts(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData , ref decimal maxSatisfiedAmount ,ref int maxValueOptionDetail, ref int numberOfWholeSaleDetails)
        {
            bool isSatisfied = false;
            try {
                bool isLastInvoice = false;
                promotion.IsWholeSaleContract = true;
                string invoiceID = string.Empty;
                decimal alreadySavedInvoiceValue = 0;
                decimal targetValue = 0;
                numberOfWholeSaleDetails++;
                if (transationCommonData.DontCheckLastInvoice || (transationCommonData.LastInvoicePromotionsList != null && transationCommonData.LastInvoicePromotionsList.Count > 0 &&transationCommonData.LastInvoicePromotionsList.Contains(promotion.PromotionId)))
                {
                    if (promotion.CustomerTargets != null)
                    {
                        string TransID = string.Empty;
                        foreach (AchievementTargetCustomer item in promotion.CustomerTargets)
                        {
                            if (item.TargetID == detail.TargetId && item.CustomerID == detail.CustomerId && item.OutletID == detail.OutletId)
                            {
                                item.IsLastInvoice = true;
                                targetValue = GetAchievementValue(item, promotion.PromotionType, promotion.StartDate, promotion.EndDate);
                                if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery )
                                {
                                    invoiceID = GetInvoiceID(transationCommonData.OrderId, int.Parse(item.CustomerID.ToString()), item.OutletID, -1);
                                    isLastInvoice = CheckIfTransactionIsLastInvoice(int.Parse(item.CustomerID.ToString()), item.OutletID, item.AchievementID, promotion.PromotionId, invoiceID, promotion.PromotionLevel);
                                    if (isLastInvoice)
                                    {
                                        targetValue = GetOldAchievementValue(int.Parse(item.CustomerID.ToString()), item.OutletID, item.AchievementID, item.TargetID, promotion.PromotionLevel, invoiceID);
                                    }
                                    else
                                    {
                                        alreadySavedInvoiceValue = 0;
                                        if (CheckIfAchievementDetailsAlreadySaved(int.Parse(detail.CustomerId.ToString()), detail.OutletId, detail.AchievementId, detail.TargetId, invoiceID, -1, -1, -1, ref alreadySavedInvoiceValue))
                                        {
                                            targetValue -= alreadySavedInvoiceValue;
                                        }
                                    }
                                }
                                if ((targetValue + transationCommonData.NetTotal) >= detail.Value && detail.Value >= maxSatisfiedAmount)
                                {
                                    if (promotion.EndDate != DateTime.MinValue && promotion.StartDate != DateTime.MinValue)
                                    {
                                        if (promotion.StartDate <= item.FromDate &&
                                            promotion.EndDate >= item.FromDate ||
                                            promotion.StartDate <= item.FromDate &&
                                            promotion.EndDate >= item.ToDate ||
                                            promotion.StartDate >= item.FromDate &&
                                            promotion.EndDate <= item.ToDate ||
                                            promotion.StartDate <= item.ToDate &&
                                            promotion.EndDate >= item.ToDate)
                                        {
                                            if (item.AchievementPeriod == AchievementPeriodValues.Month.GetHashCode())
                                            {
                                                // Promoted.
                                                if (!item.IsFirstTimePromoted)
                                                    // this change to insure that the system is taking the value of ispromoted in the first time only if there more than one promotion option [prerequesite].
                                                    item.IsFirstTimePromoted = !item.IsPromoted;
                                                item.IsPromoted = true;
                                                if (maxSatisfiedAmount != 0 && maxValueOptionDetail != -1)
                                                {
                                                    if (!promotion.UnsatisfiedOutputs.Contains(maxValueOptionDetail))//
                                                    {
                                                        promotion.UnsatisfiedOutputs.Add(maxValueOptionDetail);
                                                    }
                                                }
                                                maxValueOptionDetail = detail.ReferenceOptionId;
                                                maxSatisfiedAmount = detail.Value;
                                                isSatisfied = true;
                                                item.PromotedOnPromotionID = promotion.PromotionId;
                                                 FillPromotionPreRequiesiteDetails(promotion , transationCommonData.SoldItems , -1);
                                                // Break: Assign current promotion for current achievement only.
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return isSatisfied;
        }

        public decimal GetOldAchievementValue(int customerID, int outletID, int achievementID, int targetID, PromotionLevel promotionLevel, string invoiceID)
        {
            decimal value = 0;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                string outletLevelFilter = string.Empty;
                object field = null;
                if (promotionLevel == PromotionLevel.OutletLevel)
                    outletLevelFilter = string.Format(" and OutletID = {0}", outletID);
                string query = string.Format(@"Select OldValue from PromotionsHistory where CustomerID = {0} {1} and AchievementID = {2} and TargetID = {3} and TransactionID = '{4}'",
                    customerID, outletLevelFilter, achievementID, targetID, invoiceID);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    value = decimal.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return value;
        }

        public bool CheckIfTransactionIsLastInvoice(int customerID, int outletID, int achievementID, int promotionId, string invoiceID, PromotionLevel promotionLevel)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string outletFilter = string.Empty;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try {
                if (promotionLevel == PromotionLevel.OutletLevel)
                {
                    outletFilter = string.Format(@" and OutletID = {0}", outletID);
                }
                string query = string.Format(@"Select LastInvoiceDate From PromotionsHistory where CustomerID={0} {1} And achievementID={2} AND  TransactionID='{3}' and PromotionID = {4}"
                    , customerID, outletFilter, achievementID, invoiceID, promotionId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        private bool CheckCustomerMonthlyAchievements(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData)
        {
            bool isSatisfied = false;
            decimal invoiceValue = 0;
            decimal targetValue = 0;
            decimal currentTargetValue = 0;
            decimal alreadySavedInvoiceValue = 0;
            string invoiceID = string.Empty;
            try
            {
                if (promotion.CustomerTargets != null)
                {
                    if (detail.AchievementTypeId == (int)AchievementTypeValues.SalesAmount)
                        promotion.IsRetail = true;
                    foreach (AchievementTargetCustomer item in promotion.CustomerTargets)
                    {
                        AchievementTypeValues achievementType = (AchievementTypeValues)item.AchievementTypeID;
                        if (item.TargetID == detail.TargetId && item.CustomerID == detail.CustomerId && item.OutletID == detail.OutletId)
                        {
                            if ((achievementType == AchievementTypeValues.SalesAmount ||
                                        achievementType == AchievementTypeValues.SoldItemQuantities ||
                                        achievementType == AchievementTypeValues.CollectionAmount ||
                                        achievementType == AchievementTypeValues.SoldQuantityForPackGroup))
                            {
                                decimal itemQty = 0, itemPackGroupQty = 0, totalCollections = 0;
                                invoiceValue = 0;
                                if (detail.AchievementTypeId == (int)AchievementTypeValues.SoldQuantityForPackGroup)
                                {
                                   CheckInputSummationOverGroup(promotion, detail, transationCommonData ,false, ref itemPackGroupQty);
                                }
                                if (detail.AchievementTypeId == (int)AchievementTypeValues.SalesAmount)
                                {
                                    invoiceValue = transationCommonData.NetTotal;
                                }
                                targetValue = GetAchievementValue(item, promotion.PromotionType, promotion.StartDate, promotion.EndDate);
                                currentTargetValue = 0;
                                if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && targetValue > 0)
                                {/* in partial delievery case to check the input promotion if satisfying we must minse the orginal invoice achiv value
                                           because this value will be voided later on */
                                    invoiceID = string.Empty;
                                    if (achievementType == AchievementTypeValues.SoldQuantityForPackGroup)
                                    {
                                            alreadySavedInvoiceValue = 0;
                                            invoiceID = GetInvoiceID(transationCommonData.OrderId, int.Parse(item.CustomerID.ToString()), item.OutletID, -1);
                                            if (!CheckIfAchievementDetailsAlreadySaved(int.Parse(detail.CustomerId.ToString()), detail.OutletId, detail.AchievementId, detail.TargetId, invoiceID, -1, -1, detail.PackGroupId, ref alreadySavedInvoiceValue))
                                            {
                                                if (CheckIfTransactionPromoted(int.Parse(detail.CustomerId.ToString()), detail.OutletId, detail.AchievementId, invoiceID, detail.TargetId) && targetValue < item.Value)
                                                {
                                                    item.IsPromoted = false;
                                                }
                                            }
                                            else
                                            {
                                                targetValue -= alreadySavedInvoiceValue;
                                                if (targetValue < item.Value)
                                                {
                                                    item.IsPromoted = false;
                                                }
                                            }
                                    }
                                    else
                                    {
                                        alreadySavedInvoiceValue = 0;
                                        invoiceID = GetInvoiceID(transationCommonData.OrderId,int.Parse(item.CustomerID.ToString()), item.OutletID, -1);

                                        if (!CheckIfAchievementDetailsAlreadySaved(int.Parse(detail.CustomerId.ToString()), detail.OutletId, detail.AchievementId, detail.TargetId, invoiceID, -1, -1, -1, ref alreadySavedInvoiceValue))
                                        {
                                            if (CheckIfTransactionPromoted(int.Parse(detail.CustomerId.ToString()), detail.OutletId, detail.AchievementId, invoiceID, detail.TargetId) && targetValue < item.Value)
                                            {
                                                item.IsPromoted = false;
                                            }
                                        }
                                        else
                                        {
                                            targetValue -= alreadySavedInvoiceValue;
                                        }
                                    }
                                }
                                switch (detail.AchievementTypeId)
                                {
                                    case ((int)AchievementTypeValues.SoldItemQuantities):
                                        {
                                            currentTargetValue = itemQty;
                                            break;
                                        }
                                    case ((int)AchievementTypeValues.SalesAmount):
                                        {
                                            currentTargetValue = invoiceValue;
                                            break;
                                        }
                                    case ((int)AchievementTypeValues.CollectionAmount):
                                        {
                                            currentTargetValue = totalCollections;
                                            break;
                                        }
                                    case ((int)AchievementTypeValues.SoldQuantityForPackGroup):
                                        {
                                            currentTargetValue = itemPackGroupQty;
                                            break;
                                        }
                                }
                                if (currentTargetValue > 0  && (decimal.Round((targetValue + currentTargetValue), 3) >= item.Value || item.IsPromoted))
                                {
                                    if (promotion.EndDate != DateTime.MinValue && promotion.StartDate != DateTime.MinValue)
                                    {
                                        if (promotion.StartDate <= item.FromDate &&
                                            promotion.EndDate >= item.FromDate ||
                                            promotion.StartDate <= item.FromDate &&
                                            promotion.EndDate >= item.ToDate ||
                                            promotion.StartDate >= item.FromDate &&
                                            promotion.EndDate <= item.ToDate ||
                                            promotion.StartDate <= item.ToDate &&
                                            promotion.EndDate >= item.ToDate)
                                        {
                                            if (item.AchievementPeriod == AchievementPeriodValues.Month.GetHashCode() || item.AchievementPeriod == AchievementPeriodValues.Dynamic.GetHashCode())
                                            {
                                                if (achievementType == AchievementTypeValues.SoldQuantityForPackGroup)
                                                {
                                                    if (!item.IsPromoted)
                                                    {
                                                        promotion.TotalQuantityfromPackGroup = targetValue + currentTargetValue;
                                                    }
                                                    else
                                                    {
                                                        promotion.TotalQuantityfromPackGroup = currentTargetValue;
                                                    }
                                                    promotion.TargetBenefitQuantity = item.Value;
                                                }

                                                // Promoted.
                                                item.IsFirstTimePromoted = !item.IsPromoted;
                                                item.IsPromoted = true;
                                                item.PromotedOnPromotionID = promotion.PromotionId;
                                                isSatisfied = true;
                                                if (detail.AchievementTypeId == (int)AchievementTypeValues.SalesAmount)
                                                {
                                                    FillPromotionPreRequiesiteDetails(promotion, transationCommonData.SoldItems , -1);
                                                }
                                                    // Break: Assign current promotion for current achievement only.
                                                    break;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return isSatisfied;
        }

        public bool CheckIfTransactionPromoted(int customerID, int outletID, int achievementID, string documentID, int TargetID)
        {
            object field = null;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                GlobalErrors err = GlobalErrors.NotInitialized;
                string query = string.Format(@"Select COUNT(*) From AchievementTargetCustomer where CustomerID={0} And OutletID={1} And achievementID={2}  And TargetID={3} AND  PromotedOnTransactionID='{4}' and IsPromoted=1"
                    , customerID, outletID, achievementID, TargetID, documentID);
                err = dBHelper.ExecuteScalar(query, ref field);
                if (err == GlobalErrors.Success && field != null && field != DBNull.Value && field.ToString() != "0")
                {
                    return true;
                }
                else
                {
                    return false;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        private bool CheckCustomerDynamicTargetSalesAmount(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData , ref decimal maxSatisfiedAmount ,ref int maxValueOptionDetail)
        {
            bool isSatisfied = false;
            promotion.IsDynamicSalesAmount = true;
            string invoiceID = string.Empty;
            bool isPromoted = false;
            decimal invoiceValue = 0;
            decimal targetValue = 0;
            decimal currentTargetValue = 0;
            bool isLastInvoice = false;
            decimal alreadySavedInvoiceValue = 0;
            //numberOfDynamicSalesAmountc++;
            try
            {
                if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                {
                    invoiceID = GetInvoiceID(transationCommonData.OrderId, int.Parse(detail.CustomerId.ToString()), detail.OutletId, -1);
                }
                isPromoted = CheckTargetIsPromoted(detail, promotion.PromotionLevel, transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery, invoiceID);
                invoiceValue = 0;
                targetValue = 0;
                currentTargetValue = 0;
                if (transationCommonData.DontCheckLastInvoice || (transationCommonData.LastInvoicePromotionsList != null && transationCommonData.LastInvoicePromotionsList.Count > 0 && transationCommonData.LastInvoicePromotionsList.Contains(promotion.PromotionId)) || isPromoted)
                {
                    if (promotion.CustomerTargets != null)
                    {

                        foreach (AchievementTargetCustomer item in promotion.CustomerTargets)
                        {
                            if (item.TargetID == detail.TargetId && item.CustomerID == detail.CustomerId && item.OutletID == detail.OutletId)
                            {
                                if (isPromoted || (transationCommonData.LastInvoicePromotionsList != null && transationCommonData.LastInvoicePromotionsList.Count > 0 && transationCommonData.LastInvoicePromotionsList.Contains(promotion.PromotionId)))
                                    item.IsLastInvoice = true;
                                invoiceValue = transationCommonData.NetTotal;
                                targetValue = GetAchievementValue(item, promotion.PromotionType, promotion.StartDate, promotion.EndDate);
                                if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                                {
                                    isLastInvoice = CheckIfTransactionIsLastInvoice(int.Parse(item.CustomerID.ToString()), item.OutletID, item.AchievementID, promotion.PromotionId, invoiceID, promotion.PromotionLevel);
                                    if (isLastInvoice)
                                    {
                                        targetValue = GetOldAchievementValue(int.Parse(item.CustomerID.ToString()), item.OutletID, item.AchievementID, item.TargetID, promotion.PromotionLevel, invoiceID);
                                    }
                                    else
                                    {
                                        alreadySavedInvoiceValue = 0;
                                        if (CheckIfAchievementDetailsAlreadySaved(int.Parse(detail.CustomerId.ToString()), detail.OutletId, detail.AchievementId, detail.TargetId, invoiceID, -1, -1, -1, ref alreadySavedInvoiceValue))
                                        {
                                            targetValue -= alreadySavedInvoiceValue;
                                        }
                                    }
                                }
                                currentTargetValue = invoiceValue;
                                if (!isPromoted)
                                {
                                    if ((targetValue + currentTargetValue - transationCommonData.CalculatedAchievemnetDiscount) >= detail.Value && detail.Value >= maxSatisfiedAmount)
                                    {
                                        if (promotion.EndDate != DateTime.MinValue && promotion.StartDate != DateTime.MinValue)
                                        {
                                            if (promotion.StartDate <= item.FromDate &&
                                                promotion.EndDate >= item.FromDate ||
                                                promotion.StartDate <= item.FromDate &&
                                                promotion.EndDate >= item.ToDate ||
                                                promotion.StartDate >= item.FromDate &&
                                                promotion.EndDate <= item.ToDate ||
                                                promotion.StartDate <= item.ToDate &&
                                                promotion.EndDate >= item.ToDate)
                                            {
                                                item.BenefitValue = GetCustomerOldBenefitValue(item, promotion.PromotionId, invoiceID, transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery, promotion.PromotionLevel);
                                                promotion.BenefitValue = item.BenefitValue;
                                                // Promoted.
                                                if (!item.IsFirstTimePromoted)
                                                {
                                                    // this change to insure that the system is taking the value of ispromoted in the first time only if there more than one promotion option [prerequesite].
                                                    item.IsFirstTimePromoted = !item.IsPromoted;
                                                }
                                                item.PromotedOnPromotionID = promotion.PromotionId;
                                                if (maxSatisfiedAmount != 0 && maxValueOptionDetail != -1)
                                                {
                                                    if (!promotion.UnsatisfiedOutputs.Contains(maxValueOptionDetail))
                                                    {
                                                        promotion.UnsatisfiedOutputs.Add(maxValueOptionDetail);
                                                    }
                                                }
                                                maxValueOptionDetail = detail.ReferenceOptionId;
                                                maxSatisfiedAmount = detail.Value;
                                                isSatisfied = true;
                                                item.IsPromoted = isPromoted;
                                                if (item.IsFirstTimePromoted)
                                                    item.IsPromoted = true;
                                                FillPromotionPreRequiesiteDetails(promotion, transationCommonData.SoldItems, -1);
                                                // Break: Assign current promotion for current achievement only.
                                                break;
                                            }
                                        }
                                    }
                                }
                                else {
                                    item.BenefitValue = GetCustomerOldBenefitValue(item, promotion.PromotionId, invoiceID, transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery, promotion.PromotionLevel);
                                    promotion.BenefitValue = item.BenefitValue;
                                    int refereceOptionID = -1;
                                    refereceOptionID = GetPromotionOptionID(promotion.PromotionId, item.BenefitValue);
                                    if (refereceOptionID != detail.ReferenceOptionId)
                                    {
                                        if (!promotion.UnsatisfiedOutputs.Contains(detail.ReferenceOptionId))
                                        {
                                            promotion.UnsatisfiedOutputs.Add(detail.ReferenceOptionId);
                                        }
                                    }
                                    detail.ReferenceOptionId = refereceOptionID;
                                    isSatisfied = true;
                                    item.IsPromoted = isPromoted;
                                    if (item.IsFirstTimePromoted)
                                        item.IsPromoted = true;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return isSatisfied;
        }

        private bool CheckCustomerDynamicTargetSummationOverGroup(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData, ref decimal maxSatisfiedAmount, ref int maxValueOptionDetail)
        {
            bool isSatisfied = false;
            string invoiceID = string.Empty;
            bool isPromoted = false;
            decimal targetValue = 0;
            decimal currentTargetValue = 0;
            bool isLastInvoice = false;
            decimal alreadySavedInvoiceValue = 0;

            try
            {
                if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                {
                    invoiceID = GetInvoiceID(transationCommonData.OrderId, int.Parse(detail.CustomerId.ToString()), detail.OutletId, -1);
                }
                isPromoted = CheckTargetIsPromoted(detail, promotion.PromotionLevel, transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery, invoiceID);
                if (promotion.CustomerTargets != null)
                {

                    foreach (AchievementTargetCustomer item in promotion.CustomerTargets)
                    {
                        if (item.TargetID == detail.TargetId && item.CustomerID == detail.CustomerId && item.OutletID == detail.OutletId)
                        {
                            decimal itemPackGroupQty = 0;
                            CheckInputSummationOverGroup(promotion, detail, transationCommonData,false, ref itemPackGroupQty);
                            targetValue = GetAchievementValue(item, promotion.PromotionType, promotion.StartDate, promotion.EndDate);
                            currentTargetValue = 0;
                            if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                            {
                                isLastInvoice = CheckIfTransactionIsLastInvoice(int.Parse(item.CustomerID.ToString()), item.OutletID, item.AchievementID, promotion.PromotionId, invoiceID, promotion.PromotionLevel);
                                if (isLastInvoice)
                                {
                                    targetValue = GetOldAchievementValue(int.Parse(item.CustomerID.ToString()), item.OutletID, item.AchievementID, item.TargetID, promotion.PromotionLevel, invoiceID);
                                }
                                else
                                {
                                    alreadySavedInvoiceValue = 0;
                                    if (CheckIfAchievementDetailsAlreadySaved(int.Parse(detail.CustomerId.ToString()), detail.OutletId, detail.AchievementId, detail.TargetId, invoiceID, -1, -1, detail.PackGroupId, ref alreadySavedInvoiceValue))
                                    {
                                        targetValue -= alreadySavedInvoiceValue;
                                    }
                                }
                            }
                            currentTargetValue = itemPackGroupQty;
                            if (currentTargetValue > 0 && ((targetValue + currentTargetValue) >= detail.Value && detail.Value >= maxSatisfiedAmount))
                            {
                                if (promotion.EndDate != DateTime.MinValue && promotion.StartDate != DateTime.MinValue)
                                {
                                    if (promotion.StartDate <= item.FromDate &&
                                        promotion.EndDate >= item.FromDate ||
                                        promotion.StartDate <= item.FromDate &&
                                        promotion.EndDate >= item.ToDate ||
                                        promotion.StartDate >= item.FromDate &&
                                        promotion.EndDate <= item.ToDate ||
                                        promotion.StartDate <= item.ToDate &&
                                        promotion.EndDate >= item.ToDate)
                                    {
                                        if (isPromoted)
                                        {
                                            item.BenefitValue = GetCustomerOldBenefitValue(item, promotion.PromotionId, invoiceID, transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery, promotion.PromotionLevel);
                                            promotion.BenefitValue = item.BenefitValue;
                                        }
                                        promotion.TotalQuantityfromPackGroup = targetValue + currentTargetValue;
                                        promotion.TargetBenefitQuantity = detail.Value;
                                        // Promoted.
                                        if (!item.IsFirstTimePromoted)
                                            // this change to insure that the system is taking the value of ispromoted in the first time only if there more than one promotion option [prerequesite].
                                            item.IsFirstTimePromoted = !item.IsPromoted;
                                        item.PromotedOnPromotionID = promotion.PromotionId;
                                        if (maxSatisfiedAmount != 0 && maxValueOptionDetail != -1)
                                        {
                                            if (!promotion.UnsatisfiedOutputs.Contains(maxValueOptionDetail))//
                                            {
                                                promotion.UnsatisfiedOutputs.Add(maxValueOptionDetail);
                                            }
                                        }
                                        maxValueOptionDetail = detail.ReferenceOptionId;
                                        maxSatisfiedAmount = detail.Value;
                                        isSatisfied = true;
                                        item.IsPromoted = isPromoted;
                                        if (item.IsFirstTimePromoted)
                                            item.IsPromoted = true;
                                        // Break: Assign current promotion for current achievement only.
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return isSatisfied;
        }
        private bool CheckInputNumberOfInvoicesOverItemInCertainPeriod(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData)
        {
            bool isSatisfied = false;
            int NoOfInvoices = 0;
            int countOfInvoices = 0;
            List<ItemPackModel> soldItems = new List<ItemPackModel>();
            try
            {
                if (!transationCommonData.IsExchangeInvoice)
                {
                    soldItems = transationCommonData.SoldItems;
                }
                else
                {
                    soldItems = transationCommonData.SoldItems.Where(a => a.IsReturnItem == false).ToList();
                }
                if (soldItems.Any(a => a.ItemId == detail.ItemId))
                {
                    countOfInvoices = GetNoOfInvoicesOverItemInCertainPeriod(promotion, transationCommonData);
                    if (countOfInvoices == 0)
                    {
                        NoOfInvoices = GetNoOfInvoicesForBenefitPromotion(promotion, transationCommonData);
                        if(NoOfInvoices < promotion.NoOfInvoices)
                        {
                            FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == detail.ItemId && a.RequiredQty > 0).ToList(), -1);
                            isSatisfied = true;
                        }
                    }
                }
                return isSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        private bool CheckInputNumberOfInvoicesOverGroupInCertainPeriod(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transationCommonData)
        {
            bool isSatisfied = false;
            int NoOfInvoices = 0;
            int countOfInvoices = 0;
            List<ItemPackModel> soldItems = new List<ItemPackModel>();
            try
            {
                if (!transationCommonData.IsExchangeInvoice)
                {
                    soldItems = transationCommonData.SoldItems;
                }
                else
                {
                    soldItems = transationCommonData.SoldItems.Where(a => a.IsReturnItem == false).ToList();
                }
                foreach(PromotionGroupPackDetail item in detail.PackGroupDetails)
                {
                    if (soldItems.Any(a => a.ItemId == item.ItemId)){
                        countOfInvoices = GetNoOfInvoicesOverGroupInCertainPeriod(promotion, transationCommonData);
                        if (countOfInvoices == 0)
                        {
                            NoOfInvoices = GetNoOfInvoicesForBenefitPromotion(promotion, transationCommonData);
                            if (NoOfInvoices < promotion.NoOfInvoices)
                            {
                                FillPromotionPreRequiesiteDetails(promotion, soldItems.Where(a => a.ItemId == item.ItemId && a.PackId == item.PackId && a.RequiredQty > 0).ToList(), -1);
                                isSatisfied = true;
                            }
                        }
                    }
                }
                return isSatisfied;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public bool CheckTargetIsPromoted(PromotionOptionDetail detail, PromotionLevel promotionLevel, bool isPartialDelivery, string transactionID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool isPromoted = false;
            object field = null;
            string outletFilter = string.Empty;
            string transactionIDFilter = string.Empty;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                if (promotionLevel == PromotionLevel.OutletLevel)
                    outletFilter = string.Format(@" and OutletID = {0} ", detail.OutletId);
                if (isPartialDelivery && !string.IsNullOrEmpty(transactionID))
                    transactionIDFilter = string.Format(@" and PromotedOnTransactionID <> '{0}'", transactionID);
                string query = string.Format(@"Select IsPromoted from AchievementTargetCustomer where 
                AchievementID = {0} And TargetID = {1} And CustomerID = {2} {3} {4} ",
                detail.AchievementId, detail.TargetId, detail.CustomerId, outletFilter, transactionIDFilter);
                result = dBHelper.ExecuteScalar(query , ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    isPromoted = Convert.ToBoolean(field);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);            }
            return isPromoted;
        }
        #region AchievementCustomer
        public decimal GetAchievementValue(AchievementTargetCustomer item, PromotionTypes promType, DateTime dynamicStartDate, DateTime dynamicEndDate)
        {
            GlobalErrors result;
            string itemFilter = string.Empty;
            string outletLevelFilter = string.Empty;
            DateTime fromDate = DateTime.Now;
            DateTime toDate = DateTime.Now;
            DBHelper <decimal>  dBHelper = null;
            Object field = null;
            decimal value = 0;
            try
            {
                dBHelper = new DBHelper<decimal>();
                if (item.ItemID != -1)
                    itemFilter = " AND ItemID = " + item.ItemID.ToString();
                if (item.PackGroupID != -1)
                {
                    itemFilter = " AND PackGroupID = " + item.PackGroupID.ToString();
                }
                if (promType == PromotionTypes.TargetPromotion)
                {
                    fromDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, 1);
                    toDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.Month)).AddDays(1);
                }
                else
                {
                    fromDate = dynamicStartDate;
                    toDate = dynamicEndDate.AddDays(1);
                }
                string query = string.Format(@"SELECT Value FROM AchievementCustomer WHERE CustomerID = {0}  AND OutletID =  {1}  AND AchievementID ={2}  AND TargetID = {3}  AND FromDate >= {4}  AND ToDate < {5} {6}",
                    item.CustomerID.ToString() , item.OutletID.ToString() , item.AchievementID.ToString() , item.TargetID.ToString() , LocalUtilities.ParseDateToSQLString(fromDate) ,
                     LocalUtilities.ParseDateToSQLString(toDate) , itemFilter );

                result = dBHelper.ExecuteScalar(query , ref field);
                if (result == GlobalErrors.Success)
                {
                    if (field != null && field != DBNull.Value)
                        value = Convert.ToDecimal(field);

                }
                return value;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return 0;
            }
        }
        public static decimal GetAchievementValue(int customerID, int outletID, int achievementID, int targetID, bool isCustomerLevel, DBHelper<int> dbHelper)
        {
            decimal value = 0;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string outletLevelFilter = string.Empty;
                object field = null;
                if (!isCustomerLevel)
                    outletLevelFilter = string.Format(" and OutletID = {0}", outletID);
                else
                    outletLevelFilter = " and OutletID = -1";
                string query = string.Format(@"Select value from AchievementCustomer where CustomerID = {0} {1} and AchievementID = {2} and TargetID = {3}",
                    customerID, outletLevelFilter, achievementID, targetID);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    value = decimal.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return 0;
            }
            return value;
        }
        #endregion
        public List<PromotionGroupPackDetail> FillGroupPacksQuantity(PromotionOptionDetail detail,int divisionId)
        {
            var groupDetails = new List<PromotionGroupPackDetail>();
            var query = string.Empty;
            List<PackGroupQuantityModel> pgQuantities = new List<PackGroupQuantityModel>();
            PackGroupQuantityModel pgQty = new PackGroupQuantityModel();
            DBHelper<PromotionGroupPackDetail> dbHelper = null;
            string salesOrderCRMSelection = string.Empty;
            string groupDifferentQuantitySalesOrderSelection = string.Empty;
            try
            {
                dbHelper = new DBHelper<PromotionGroupPackDetail>();
                if(detail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel)
                {
                    groupDifferentQuantitySalesOrderSelection = string.Format(@" , ISNULL(PromotionOptionDetailGroup.SalesOrderTypeIDs,'') SalesOrderTypeIDs ");
                }
                if (!string.IsNullOrEmpty(detail.SalesOrderTypeId) && detail.SalesOrderTypeId != "NULL")
                {
                    salesOrderCRMSelection = string.Format(@" ,'{0}' SalesOrderTypeIDs", detail.SalesOrderTypeId);
                }
                if (detail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantity || detail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel)
                {
                    query = string.Format(@"SELECT Pack.ItemID,Pack.Quantity PackQuantity, PromotionOptionDetailGroup.PackID, PromotionOptionDetailGroup.Quantity PromotionValue {4}
                    FROM PromotionOptionDetailGroup
                    INNER JOIN Pack ON  PromotionOptionDetailGroup.PackID = Pack.PackID
                    INNER JOIN Item on Item.ItemID = Pack.ItemID AND Item.Inactive = 0
                    INNER Join ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID and ItemCategory.DivisionID in ({5})
                    WHERE PromotionID = {0} AND PromotionOptionID = {1} AND PromotionOptionDetailID = {2} AND  PackgroupID = {3} "
                    , detail.PromotionId
                    , detail.PromotionOptionId
                    , detail.PromotionOptionDetailId
                    , detail.PackGroupId
                    , groupDifferentQuantitySalesOrderSelection
                    , divisionId != -1 ? divisionId.ToString() :  _requestRepository.CurrentOperator.DivisionAccess);
                }
                else
                {
                    query = string.Format(@"SELECT Pack.ItemID , Pack.Quantity PackQuantity,PackGroupDetail.PackID, {0} PromotionValue {2}
                    FROM PackGroupDetail
                    INNER JOIN Pack ON  PackGroupDetail.PackID = Pack.PackID
					INNER JOIN Item on Item.ItemID = Pack.ItemID AND Item.Inactive = 0
                    INNER Join ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID and ItemCategory.DivisionID in ({3})
                    WHERE PackGroupDetail.PackgroupID = {1} ", detail.Value, detail.PackGroupId, salesOrderCRMSelection, divisionId != -1 ? divisionId.ToString() : _requestRepository.CurrentOperator.DivisionAccess);
                }

                var result = dbHelper.GetQueryList(query, ref groupDetails);

                groupDetails.ForEach(x => {
                    pgQty = new PackGroupQuantityModel();
                    pgQty.ItemId = x.ItemId;
                    pgQty.QtyInPcs = x.PackQuantity;
                    pgQuantities.Add(pgQty);
                });
                detail.DefindPackGroupQuantities = pgQuantities;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return groupDetails;
        }

        public List<int> GetAllItemsInPackGroup(int packGroup)
        {
            List<int> items = new List<int>();
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"SELECT DISTINCT Pack.ItemID 
                                                FROM PackGroupDetail 
                                                INNER JOIN Pack ON PackGroupDetail.PackID = Pack.PackID
                                                WHERE PackGroupID = {0}", packGroup);

                var result = dbHelper.GetQueryList(query, ref items);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return items;
        }

        private List<PromotionOption> FillInputsAndOutputs(List<PromotionOptionDetail> promoOptionsList, bool exculdeBenifitSelectionPromotion,int divisionId)
        {
            List<PromotionOption> options = null;
            try
            {
                options = new List<PromotionOption>();
                foreach (PromotionOptionDetail promotionOptionDetail in promoOptionsList)
                {
                    if (promotionOptionDetail.PromotionOptionDetailTypeId != -1)
                    {
                        switch (promotionOptionDetail.PromotionOptionTypeId)
                        {
                            case PromotionOptionTypes.Input:
                                {
                                    promotionOptionDetail.InputOptionDetailTypeId = (PromotionInputDetailTypes)promotionOptionDetail.PromotionOptionDetailTypeId;

                                    if (promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupEqualQuantity
                                        || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantity
                                        || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.SummationOverGroup
                                        || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.InvoiceAmountOnPackGroup
                                        || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.CustomerMonthlyAchievement && promotionOptionDetail.AchievementTypeId == AchievementTypeValues.SoldQuantityForPackGroup.GetHashCode()
                                        || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.DynamicTargetSummationOverGroup
                                        || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel
                                        || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupWithNoSalesInCertainPeriodRestrictedToInvoicesCount
                                        || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.SummationOverGroupOnTypeLevel
                                        || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.InvoiceAmountOnPackGroupOnTypeLevel)
                                    {
                                        promotionOptionDetail.PackGroupDetails = FillGroupPacksQuantity(promotionOptionDetail, divisionId);
                                    }
                                    else if (promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.CertainNumberOfItemsOverGroup)
                                    {
                                        promotionOptionDetail.PromotionGroupItems = GetAllItemsInPackGroup(promotionOptionDetail.PackGroupId);
                                    }
                                    break;
                                }

                            case PromotionOptionTypes.Output:
                                {

                                    promotionOptionDetail.OutputOptionDetailTypeId = (PromotionOutputDetailTypes)promotionOptionDetail.PromotionOptionDetailTypeId;

                                    if (promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.GroupEqualQuantity
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.SummationOverGroup
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountAmountForGroupItems
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FixedPriceOverGroup
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.OpenSteps
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DynamicTargetSummationOverGroup
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountAmountOverGroup
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel
                                        || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel)
                                    {
                                        promotionOptionDetail.PackGroupDetails = FillGroupPacksQuantity(promotionOptionDetail, divisionId);
                                    }
                                    break;
                                }
                        }
                    }

                    if (!options.Any(a => a.PromotionOptionId == promotionOptionDetail.PromotionOptionId))
                    {
                        PromotionOption promotionOption = new PromotionOption();
                        promotionOption.PromotionOptionId = promotionOptionDetail.PromotionOptionId;
                        promotionOption.PromotionOptionTypeId = promotionOptionDetail.PromotionOptionTypeId;
                        if (promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount)
                            promotionOption.IsPercentageOrAmountType = true;
                        options.Add(promotionOption);
                    }

                    options.Find(a => a.PromotionOptionId == promotionOptionDetail.PromotionOptionId).PromotionOptionDetails.Add(promotionOptionDetail);
                }
            }
            catch (Exception ex)
            {
                options = null;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return options;
        }

        private decimal GetItemSoldAmount(List<ItemPackModel> item)
        {
            decimal soldAmount = 0;
            try
            {
                foreach (ItemPackModel pack in item)
                {
                    if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 0)
                        soldAmount += (pack.NetTotal - pack.CalculatedTax);
                    else if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 1)
                        soldAmount += pack.GrossTotal;
                    else if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionPrerequisites == 2)
                        soldAmount += pack.NetTotal;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return soldAmount;
        }

        private decimal GetItemSoldQuantityInPeices(List<ItemPackModel> item)
        {
            decimal soldQuantity = 0;
            try
            {
                foreach (ItemPackModel pack in item)
                {
                    soldQuantity += pack.RequiredQty * pack.PiecesInPack;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return soldQuantity;
        }

        private decimal GetItemsQuantityInDivision(List<ItemPackModel> item)
        {
            decimal soldQuantity = 0;
            try
            {
                foreach (ItemPackModel pack in item)
                {
                    soldQuantity += pack.RequiredQty;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return soldQuantity;
        }
        private int GetNoOfInvoicesOverItemInCertainPeriod(Promotion promotion, TransactionCommonData transationCommonData)
        {
            int NoOfInvoices = 0;
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"select count( distinct T.TransactionID) NoOfInvoices
                from [Transaction] T
                inner join TransactionDetail TD on T.TransactionID = TD.TransactionID and T.CustomerID = TD.CustomerID and T.OutletID = TD.OutletID
                and T.DivisionID = TD.DivisionID
                inner join Pack on Pack.PackID = TD.PackID
                inner join Item on Item.ItemID = Pack.ItemID
                inner join PromotionOptionDetail POD on POD.ItemID = Item.ItemID and T.TransactionDate >= POD.fromDate and T.TransactionDate <= POD.ToDate
                and POD.PromotionID = {0}
                where T.Voided <> 1 and T.TransactionTypeID IN (1,3) and TD.SalesTransactionTypeID = 1 and TD.CustomerID = {1} and TD.OutletID = {2}", promotion.PromotionId, transationCommonData.CustomerId, transationCommonData.OutletId);

                 result = dbHelper.GetQuerySingle(query, ref NoOfInvoices);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return NoOfInvoices;
        }
        private int GetNoOfInvoicesOverGroupInCertainPeriod(Promotion promotion, TransactionCommonData transationCommonData)
        {
            int NoOfInvoices = 0;
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"select count( distinct T.TransactionID) NoOfInvoices
                from [Transaction] T
                inner join TransactionDetail TD on T.TransactionID = TD.TransactionID and T.CustomerID = TD.CustomerID and T.OutletID = TD.OutletID
                and T.DivisionID = TD.DivisionID
                inner join PackGroupDetail PGD on PGD.PackID = TD.PackID
                inner join PromotionOptionDetail POD on POD.PackGroupID = PGD.PackGroupID and T.TransactionDate >= POD.fromDate and T.TransactionDate <= POD.ToDate
                and POD.PromotionID = {0}
                where T.Voided <> 1 and T.TransactionTypeID IN (1,3) and TD.SalesTransactionTypeID = 1 and TD.CustomerID = {1} and TD.OutletID = {2}", promotion.PromotionId, transationCommonData.CustomerId, transationCommonData.OutletId);

                result = dbHelper.GetQuerySingle(query, ref NoOfInvoices);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return NoOfInvoices;
        }
        private int GetNoOfInvoicesForBenefitPromotion(Promotion promotion, TransactionCommonData transationCommonData)
        {
            int NoOfInvoices = 0;
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"select distinct count(*) NoOfInvoices 
                from PromotionBenefitHistory where PromotionID = {0} and CustomerID = {1} and OutletID = {2}", promotion.PromotionId, transationCommonData.CustomerId, transationCommonData.OutletId);

                result = dbHelper.GetQuerySingle(query, ref NoOfInvoices);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return NoOfInvoices;
        }
        private void GetPromotionInputsAndOutputs(Promotion promotion, int customerId, int outletId, bool exculdeBenifitSelectionPromotion,int divisionId)
        {
            string customerOutletFilter = string.Empty;
            string likelySatisfiedFilter = string.Empty;
            string achievementTargetFilter = string.Empty;
            string promotionTypes = string.Empty;
            DBHelper<PromotionOptionDetail> dbHelper = null;
            List<PromotionOptionDetail> promoOptionsList = new List<PromotionOptionDetail>();
            List<PromotionOptionDetail> inputPromoOptionsList = new List<PromotionOptionDetail>();
            List<PromotionOptionDetail> outputPromoOptionsList = new List<PromotionOptionDetail>();
            try
            {
                dbHelper = new DBHelper<PromotionOptionDetail>();
                if (customerId != -1 && outletId != -1)
                {
                    customerOutletFilter = string.Format(" And PromotionCustomerAchievement.CustomerID = {0} And  (PromotionCustomerAchievement.OutletID = {1} OR (PromotionCustomerAchievement.OutletID =-1 AND Promotion.PromotionLevel = {2}))"
                        , customerId, outletId, PromotionLevel.CustomerLevel.GetHashCode());
                }
                promotionTypes = string.Format("{0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},{14},{15},{16},{17},{18},{19},{20},{21},{22},{23},{24},{25},{26},{27}",
                                (int)PromotionOutputDetailTypes.DiscountAmount,
                                (int)PromotionOutputDetailTypes.DiscountPercentage,
                                (int)PromotionOutputDetailTypes.ItemQuantity,
                                (int)PromotionOutputDetailTypes.DiscountAmountForItem,
                                (int)PromotionOutputDetailTypes.DiscountPercentageForItem,
                                (int)PromotionOutputDetailTypes.DiscountAmountForGroupItems,
                                (int)PromotionOutputDetailTypes.DiscountPercentageForGroupItems,
                                (int)PromotionOutputDetailTypes.AllItemDiscountAmount,
                                (int)PromotionOutputDetailTypes.AllItemDiscountPercentage,
                                (int)PromotionOutputDetailTypes.FixedPriceOverItem,
                                (int)PromotionOutputDetailTypes.FixedPriceOverAllItem,
                                (int)PromotionOutputDetailTypes.FixedPriceOverGroup,
                                (int)PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage,
                                (int)PromotionOutputDetailTypes.FreeItemsWithCertainValue,
                                (int)PromotionOutputDetailTypes.RetailContractDiscount,
                                (int)PromotionOutputDetailTypes.OpenSteps,
                                (int)PromotionOutputDetailTypes.WholesalesContractsDiscount,
                                (int)PromotionOutputDetailTypes.DynamicTargetDiscount,
                                (int)PromotionOutputDetailTypes.DynamicTargetSummationOverGroup,
                                (int)PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount,
                                (int)PromotionOutputDetailTypes.SummationOverGroup,
                                (int)PromotionOutputDetailTypes.DiscountAmountOverGroup,
                                (int)PromotionOutputDetailTypes.DiscountAmountOverTransaction,
                                (int)PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems,
                                (int)PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems,
                                (int)PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel,
                                (int)PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel,
                                (int)PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel
                                );
                if (!exculdeBenifitSelectionPromotion)
                {
                    promotionTypes = string.Format("{0},{1}, {2} ", promotionTypes,
                                (int)PromotionOutputDetailTypes.SummationOverGroup,
                                (int)PromotionOutputDetailTypes.GroupEqualQuantity);
                }
                likelySatisfiedFilter = string.Format(@" AND (PromotionOptionTypeID = {0} OR (PromotionOptionTypeID = {1} AND PromotionOptionDetail.PromotionOptionDetailTypeID IN ({2})))",
                        PromotionOptionTypes.Input.GetHashCode(), PromotionOptionTypes.Output.GetHashCode(), promotionTypes);

                achievementTargetFilter = string.Format(@" DECLARE @AchTable as Table (TargetID INT, CustomerID INT, OutletID INT, AchievementID INT, Value numeric(19,9), AchievementTypeID INT);
                         INSERT INTO @AchTable 
                         SELECT TargetID, CustomerID, OutletID, AchievementTargetCustomer.AchievementID, Value, Achievement.AchievementTypeID  FROM AchievementTargetCustomer 
                         INNER JOIN Achievement on AchievementTargetCustomer.AchievementID = Achievement.AchievementID 
                         WHERE FromDate <=   {0}  AND AchievementTargetCustomer.ToDate > {0};", LocalUtilities.ParseDateToSQLString(DateTime.Now));

                string query = string.Format(@"{5} SELECT Pack.ItemID ,PromotionOptionDetail.*,PromOptionDetailLanguage.Description,PackTypeLanguage.Description as PackTypeDescription ,
                Pack.Quantity PiecesInPack,PromotionCustomerAchievement.CustomerID , PromotionCustomerAchievement.OutletID,
                AchievementTargetCustomer.Value As TargetValue , PromotionCustomerAchievement.TargetID as TargetID  , AchievementTargetCustomer.AchievementID as AchievementID, AchievementTargetCustomer.AchievementTypeID as AchievementTypeID                 
                FROM PromotionOptionDetail
                Inner Join Promotion on Promotion.PromotionID = PromotionOptionDetail.PromotionID
                LEFT OUTER JOIN Pack ON PromotionOptionDetail.PackID = Pack.PackID
                INNER JOIN PromOptionDetailLanguage ON PromotionOptionDetail.PromotionID = PromOptionDetailLanguage.PromotionID
                AND PromotionOptionDetail.PromotionOptionID = PromOptionDetailLanguage.PromotionOptionID
                AND PromotionOptionDetail.PromotionOptionDetailID = PromOptionDetailLanguage.PromotionOptionDetailID
                AND PromOptionDetailLanguage.LanguageID = {0}
                left join PackTypeLanguage on PromotionOptionDetail.PackTypeID=PackTypeLanguage.PackTypeID and packTypeLanguage.LanguageID={0}
                Left join PromotionCustomerAchievement on PromotionCustomerAchievement.PromotionID = PromotionOptionDetail.PromotionID {2}
                LEFT JOIN @AchTable AchievementTargetCustomer on PromotionCustomerAchievement.TargetID = AchievementTargetCustomer.TargetID and  PromotionCustomerAchievement.CustomerID = AchievementTargetCustomer.CustomerID 
                AND PromotionCustomerAchievement.OutletID = AchievementTargetCustomer.OutletID
                AND PromotionCustomerAchievement.AchievementID = AchievementTargetCustomer.AchievementID
                WHERE PromotionOptionDetail.PromotionID = {1}
                {3}
                ORDER BY PromotionOptionDetail.PromotionOptionID ,PromotionOptionDetail.PromotionOptionDetailID ",
                _requestRepository.LanguageId, promotion.PromotionId, customerOutletFilter, likelySatisfiedFilter, LocalUtilities.ParseDateToSQLString(DateTime.Now), achievementTargetFilter);
                var result = dbHelper.GetQueryList(query, ref promoOptionsList);
                if (promotion.PromotionType == PromotionTypes.TargetPromotion || promotion.PromotionType == PromotionTypes.DynamicTargetPromotion)
                {
                    promoOptionsList.RemoveAll(x => x.AchievementId == -1);
                }
                if (result == GlobalErrors.Success && promoOptionsList.Count > 0)
                {
                    inputPromoOptionsList = promoOptionsList.Where(p => p.PromotionOptionTypeId == PromotionOptionTypes.Input).ToList();
                    outputPromoOptionsList = promoOptionsList.Where(p => p.PromotionOptionTypeId == PromotionOptionTypes.Output).ToList();

                    promotion.IsWholeSaleContract = promoOptionsList.Where(p => p.PromotionOptionTypeId == PromotionOptionTypes.Input && p.PromotionOptionDetailTypeId == PromotionInputDetailTypes.CustomerMonthlyWholesalesContracts.GetHashCode()).ToList().Count > 0;
                    promotion.IsDynamicSalesAmount = promoOptionsList.Where(p => p.PromotionOptionTypeId == PromotionOptionTypes.Input && p.PromotionOptionDetailTypeId == PromotionInputDetailTypes.DynamicTargetSalesAmount.GetHashCode()).ToList().Count > 0;


                    if (inputPromoOptionsList.Count > 0)
                    {
                        promotion.PromotionInputs = FillInputsAndOutputs(inputPromoOptionsList, false, divisionId);
                        promotion.PromotionOutputs = FillInputsAndOutputs(outputPromoOptionsList, exculdeBenifitSelectionPromotion, divisionId);
                    }

                   
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public List<AchievementTargetCustomer> GetCustomerTargetData(int customerID, int outletID, int PromID, string oldInvoice, PromotionTypes promType, DateTime dynamicStartDate, DateTime dynamicEndDate, PromotionLevel promotionLevel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper <AchievementTargetCustomer> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<AchievementTargetCustomer>();
                List<AchievementTargetCustomer> lstCustomerTargets = new List<AchievementTargetCustomer>();
                DateTime fromDate = DateTime.Now;
                DateTime toDate = DateTime.Now;
                string promotionLevelFilter = string.Empty;
                string query = string.Empty;
                if (promotionLevel == PromotionLevel.OutletLevel)
                    promotionLevelFilter = " AND AchievementTargetCustomer.OutletID = " + outletID.ToString();

                if (promType == PromotionTypes.TargetPromotion)
                {
                    fromDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, 1);
                    toDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.Month)).AddDays(1);
                }
                else
                {
                    fromDate = dynamicStartDate;
                    toDate = dynamicEndDate.AddDays(1);
                }
                query = string.Format(@"SELECT Distinct AchievementTargetCustomer.TargetID, AchievementTargetCustomer.AchievementID, AchievementTargetCustomer.CustomerID, AchievementTargetCustomer.OutletID, AchievementTargetCustomer.FromDate,
                    AchievementTargetCustomer.ToDate, AchievementTargetCustomer.Value, AchievementTargetCustomer.ItemID, AchievementTargetCustomer.IsPromoted, Achievement.AchievementPeriodID AS AchievementPeriod , AchievementTargetCustomer.PackGroupID , AchievementTargetCustomer.PromotedOnTransactionID, Achievement.AchievementTypeID
                    FROM AchievementTargetCustomer INNER JOIN Achievement ON Achievement.AchievementID = AchievementTargetCustomer.AchievementID 
                    INNER JOIN PromotionCustomerAchievement ON PromotionCustomerAchievement.AchievementID = AchievementTargetCustomer.AchievementID AND
                    PromotionCustomerAchievement.CustomerID = AchievementTargetCustomer.CustomerID AND PromotionCustomerAchievement.TargetID = AchievementTargetCustomer.TargetID
                    WHERE AchievementTargetCustomer.CustomerID = {0} {1} AND PromotionCustomerAchievement.PromotionID = {2} AND AchievementTargetCustomer.FromDate >= {3}  AND AchievementTargetCustomer.ToDate < {4}",
                    customerID.ToString(), promotionLevelFilter, PromID, LocalUtilities.ParseDateToSQLString(fromDate), LocalUtilities.ParseDateToSQLString(toDate));

                result = dbHelper.GetQueryList(query, ref lstCustomerTargets);
                //since it is the same invoice in case of partial delivery :
                foreach (AchievementTargetCustomer target in lstCustomerTargets)
                {
                    if (target.PromotedOnTransactionID !=null && !target.PromotedOnTransactionID.Equals("") && oldInvoice != null && !oldInvoice.Equals("") 
                        && target.PromotedOnTransactionID.Trim().Equals(oldInvoice.Trim()))
                    {
                        target.IsPromoted = false;
                    }
                }

                if (result == GlobalErrors.Success && lstCustomerTargets != null && lstCustomerTargets.Count > 0) {
                    return lstCustomerTargets;
                }
                else
                return new List<AchievementTargetCustomer>();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }
        private static decimal GetCalculatedTotalQuantityForOldTransaction(string transactionID, long customerID, int outletID, int AchievementID, int targetID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            decimal quantity = 0;
            object field = null;
            try
            {
                string transactionItemsQuery = string.Format(@"SELECT Value from 
				AchievementCustomerDetail WHERE CustomerID = {0} AND OutletID = {1} and AchievementiD = {2} and TargetID = {3}  and DocumentID ='{4}'",
                customerID, outletID, AchievementID, targetID, transactionID);
                result = dBHelper.ExecuteScalar(transactionItemsQuery, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    quantity = decimal.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return quantity;
        }

        public  void RecalculateItemsWithProductDiscount(TransactionCommonData transationCommonData)
        {
            decimal productDiscTotal = 0;
            decimal calTax, calDisc, gross = 0;
            List<int> productDiscountPromotionIds = new List<int>();
            List<int> prePackIds = new List<int>();
            ProductDiscountModel prodDisModel = new ProductDiscountModel();
            ProductDiscountBenefitModel prodDisBenefitModel = new ProductDiscountBenefitModel();
            ItemPackModel prePack = new ItemPackModel();
            decimal preGrossTotal = 0;
            decimal preTotalQuantityInTargetUOM = 0;
            decimal productDiscountRatioPercentage = 0;
            decimal productDiscountRatio = 0;
            decimal prePackProductDiscountAmount = 0;
            int productDiscountCalculationMode = _requestRepository.Configurations.ProductDiscountCalculationMode;

            List<ProductDiscountModel> ProductDiscountList = new List<ProductDiscountModel>();
            try
            {
                if (transationCommonData.ProductPromotionLevelId == 1)
                    ProductDiscountList = transationCommonData.ProductDiscountFirstLevelList;
                else
                {
                    if (transationCommonData.ProductDiscountSecondLevelList != null && transationCommonData.ProductDiscountSecondLevelList.Count > 0)
                    {
                        ProductDiscountList.AddRange(transationCommonData.ProductDiscountSecondLevelList);
                        if(transationCommonData.ProductDiscountFirstLevelList != null && transationCommonData.ProductDiscountFirstLevelList.Count > 0)
                        ProductDiscountList.AddRange(transationCommonData.ProductDiscountFirstLevelList);
                    }
                    else
                    {
                        ProductDiscountList = transationCommonData.ProductDiscountFirstLevelList;
                    }
                }
                productDiscountPromotionIds = ProductDiscountList.Select(x => x.PromotionId).Distinct().ToList();
                foreach (int promotionID in productDiscountPromotionIds)
                {
                    foreach (ItemPackModel pack in transationCommonData.SoldItems)
                    {
                        if (pack.TotalProductDiscountQuantity > 0 )
                        {
                            prodDisModel = new ProductDiscountModel();
                            prodDisBenefitModel = new ProductDiscountBenefitModel();
                            prodDisModel = ProductDiscountList.Where(available => available.PromotionId == promotionID && available.BenefitPackId == pack.PackId).FirstOrDefault();
                            if (prodDisModel != null) prodDisModel.ProductDiscountQty = ProductDiscountList.Where(available => available.PromotionId == promotionID && available.BenefitPackId == pack.PackId).Sum(a => a.ProductDiscountQty);
                            if (prodDisModel != null && prodDisModel.ProductDiscountQty > 0)
                            {
                                gross = (prodDisModel.ProductDiscountQty * pack.Price) - pack.CalculatedDiscount;
                                if(_requestRepository.Configurations.ApplyRoundingOnCalculations)
                                    gross = LocalUtilities.GetRoundedDecimal(gross, _requestRepository.Configurations.NumberOfDigits);
                                calDisc = (gross * pack.PromotedDiscount) / 100;
                                if (_requestRepository.Configurations.ApplyRoundingOnCalculations)
                                    calDisc = LocalUtilities.GetRoundedDecimal(calDisc, _requestRepository.Configurations.NumberOfDigits);
                                calTax = ((gross - calDisc)) * pack.Tax / 100;
                                if (_requestRepository.Configurations.ApplyRoundingOnCalculations && !_requestRepository.Configurations.ApplyZATCARoundingRules)
                                    calTax = LocalUtilities.GetRoundedDecimal(calTax, _requestRepository.Configurations.NumberOfDigits);
                                if (_requestRepository.Configurations.IncludeTaxInProductDiscount)
                                {
                                    productDiscTotal = gross - calDisc + calTax;
                                }
                                else
                                {
                                    productDiscTotal = gross - calDisc;
                                }
                                prePackIds = prodDisModel.SatisfiedPrerequisitesDetails.Select(x => x.PackId).ToList();
                                preGrossTotal = 0;
                                preTotalQuantityInTargetUOM = 0;
                                foreach (int prePackId in prePackIds)
                                {
                                    prePack = transationCommonData.SoldItems.Where(x => x.PackId == prePackId).FirstOrDefault();
                                    preGrossTotal += prePack.GrossTotal - prePack.CalculatedDiscount;
                                    if (productDiscountCalculationMode == 1)
                                    {
                                        preTotalQuantityInTargetUOM += prodDisModel.SatisfiedPrerequisitesDetails.Where(x => x.PackId == prePackId).FirstOrDefault().QuantityInPrereqUOM;
                                    }
                                }
                                productDiscountRatioPercentage = (productDiscTotal / preGrossTotal) * 100;
                                foreach (int prePackId in prePackIds)
                                {
                                    prodDisBenefitModel = new ProductDiscountBenefitModel();
                                    prePack = transationCommonData.SoldItems.Where(x => x.PackId == prePackId).FirstOrDefault();
                                    if(productDiscountCalculationMode == 1)
                                    {
                                        productDiscountRatio = prodDisModel.SatisfiedPrerequisitesDetails.Where(x => x.PackId == prePackId).FirstOrDefault().QuantityInPrereqUOM / preTotalQuantityInTargetUOM;
                                        prePackProductDiscountAmount = productDiscountRatio * productDiscTotal;
                                        productDiscountRatioPercentage = (prePackProductDiscountAmount / (prePack.GrossTotal - prePack.CalculatedDiscount))*100;
                                    }

                                    prePack.ProductDiscountPercentage += productDiscountRatioPercentage;
                                    if (prePack.ProductDiscountPercentage > 100)
                                        prePack.ProductDiscountPercentage = 100;
                                    //prePack.ItemPromotedDiscount += productDiscountRatioPercentage;
                                    //if (prePack.ItemPromotedDiscount > 100)
                                    //    prePack.ItemPromotedDiscount = 100;
                                    //prePack.PromotedDiscount += productDiscountRatioPercentage;
                                    //if (prePack.PromotedDiscount > 100)
                                    //    prePack.PromotedDiscount = 100;

                                    // Caching product discount benefit amount for each prerequisite item .
                                    prodDisBenefitModel.PromotionId = promotionID;
                                    prodDisBenefitModel.PackId = prePackId;
                                    prodDisBenefitModel.ItemId = transationCommonData.SoldItems.Find(pack => pack.PackId == prePackId).ItemId;
                                    prodDisBenefitModel.ProductDiscountValue = prePackProductDiscountAmount;
                                    if (transationCommonData.CustomerPromotions.Find(promo => promo.PromotionId == promotionID).ProductDiscountBenefitList.FindIndex(a => a.ItemId == prodDisBenefitModel.ItemId && a.PackId == prodDisBenefitModel.PackId) < 0)
                                        transationCommonData.CustomerPromotions.Find(promo => promo.PromotionId == promotionID).ProductDiscountBenefitList.Add(prodDisBenefitModel);
                                    else
                                        transationCommonData.CustomerPromotions.Find(promo => promo.PromotionId == promotionID).ProductDiscountBenefitList.Find(a => a.ItemId == prodDisBenefitModel.ItemId && a.PackId == prodDisBenefitModel.PackId).ProductDiscountValue += prodDisBenefitModel.ProductDiscountValue;


                                }
                            }
                        }
                    }
                    if ((transationCommonData.ProductPromotionLevelId != 1 && IsLastPromotionInLevel(promotionID, transationCommonData.ProductDiscountSecondLevelList)) ||
                   IsLastPromotionInLevel(promotionID, transationCommonData.ProductDiscountFirstLevelList))
                    {
                        AccumulateDiscount(transationCommonData);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        private void AccumulateDiscount(TransactionCommonData transactionCommonData)
        {
            try
            {
                foreach (ItemPackModel pack in transactionCommonData.SoldItems)
                {
                    pack.ItemPromotedDiscount += pack.ProductDiscountPercentage;
                    if (pack.ItemPromotedDiscount > 100)
                        pack.ItemPromotedDiscount = 100;
                    pack.PromotedDiscount += pack.ProductDiscountPercentage;
                    if (pack.PromotedDiscount > 100)
                        pack.PromotedDiscount = 100;
                    pack.ProductDiscountPercentage = 0;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        private bool IsLastPromotionInLevel(int promotionId, List<ProductDiscountModel> productDiscountLevelList)
        {
            bool isLastPromotion = false;
            try
            {
                if (productDiscountLevelList != null && productDiscountLevelList.Count > 0)
                {
                    int index = productDiscountLevelList.FindLastIndex(promotion => promotion.PromotionId == promotionId);
                    if (index == productDiscountLevelList.Count - 1) // is last promotion of current level.
                    {
                        return true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return isLastPromotion;
        }

        #region[Apply Group Achievements to Customers]
        public GlobalErrors SaveTargetToCustomer(int achievementId, int customerId, int outletId, decimal targetValue, decimal target2Value, int itemId, DateTime from, DateTime to, int packTypeId, int packGroupId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int targetId = 0;
                object field = null;
                string query = $@"Select Max(TargetID) TargetID From AchievementTargetCustomer where CustomerID={customerId} And achievementID={achievementId}";
                result = dBHelper.ExecuteScalar(query, ref field);
                if(result == GlobalErrors.Success)
                {
                    if(field != null && !string.IsNullOrEmpty(field.ToString()))
                    {
                        targetId = int.Parse(field.ToString()) + 1;
                    }
                    else
                    {
                        targetId = 1;
                    }
                    query = $@"Insert into AchievementTargetCustomer 
                        (TargetID,AchievementID,CustomerID,OutletID,ItemID,PackTypeID,FromDate,ToDate,Value,Value2, PackGroupID,BrandID,EmployeeID,CurrencyID) 
                        values
                        ({targetId},{achievementId},{customerId},{outletId},{itemId},{packTypeId},{LocalUtilities.ParseDateToSQLString(from)},{LocalUtilities.ParseEndDateToSQLString(to)},{targetValue},{target2Value},{packGroupId},{-1},{-1},{-1})";
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors LinkCustomerPromotionWithTarget(int promotionId, int optionDetailId, int customerId, int outletId, int achievementId, int AchievementTypeId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = 0;
                int targetId= -1;
                string query = string.Format(@"Select Max(TargetID) TargetID From AchievementTargetCustomer where CustomerID={0} And achievementID={2}", customerId, outletId, achievementId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if(result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    targetId = int.Parse(field.ToString());
                    if (targetId == -1) return GlobalErrors.Error;
                    query = $@"Insert into PromotionCustomerAchievement (PromotionID,CustomerID,OutletID,TargetID, AchievementID) values ({promotionId},{customerId},{outletId},{targetId},{achievementId}) ";
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors AddTargetPromotionAchievementsAndTargets(int promotionId, DateTime startDate, DateTime endDate, int customerId, int outletId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<PromotionOptionDetail> dBHelper_PromotionOptionDetail = null;
            DBHelper<ItemPackModel> dBHelper_ItemPackModel = null;
            int packTypeId = -1;
            int itemId = -1;
            try
            {
                #region[Get Promotion Details]
                // Get Promotions details for current INCLUDED promotion.
                List<PromotionOptionDetail> promotionDetails = new List<PromotionOptionDetail>();
                if (dBHelper != null && dBHelper_PromotionOptionDetail == null)
                {
                    dBHelper_PromotionOptionDetail = new DBHelper<PromotionOptionDetail>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                string query = string.Format(@"select PromotionOptionDetail.* , Promotion.StartDate , Promotion.EndDate, Promotion.AchievementID
                , Achievement.AchievementPeriodID,Value as TargetValue
                from PromotionOptionDetail 
                inner join promotion on Promotion.PromotionID = PromotionOptionDetail.PromotionID
                inner join Achievement on Achievement.AchievementID = Promotion.AchievementID
                where Promotion.promotionID = {0} order by PromotionOptionDetail.PromotionOptionDetailID "
                    , promotionId);
                result = dBHelper_PromotionOptionDetail.GetQueryList(query, ref promotionDetails);
                #endregion
                if (result == GlobalErrors.Success)
                {
                    if (promotionDetails != null && promotionDetails.Count > 0)
                    {
                        if (promotionDetails.FirstOrDefault().PackId != -1)
                        {
                            if (dBHelper_ItemPackModel == null && dBHelper != null)
                            {
                                dBHelper_ItemPackModel = new DBHelper<ItemPackModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                            }
                            result = GetItemIdAndPackTypeIdFromPackId(promotionDetails.FirstOrDefault().PackId, ref packTypeId, ref itemId, dBHelper_ItemPackModel);
                        }
                        // Handle Achievements based on Period Type.
                        if (promotionDetails.FirstOrDefault().AchievementPeriodId == (int)AchievementPeriodValues.Month)
                        {
                            var p = promotionDetails.FirstOrDefault();
                            result = CheckMonthlyAchievementForCustomer(p.AchievementId, customerId, outletId, p.TargetValue, p.PackGroupId, promotionId, itemId, packTypeId, startDate, endDate, dBHelper);
                        }
                        else if (promotionDetails.FirstOrDefault().AchievementPeriodId == (int)AchievementPeriodValues.Week)
                        {
                            var p = promotionDetails.FirstOrDefault();
                            result = CheckWeeklyAchievementForCustomer(p.AchievementId, customerId, outletId, p.TargetValue, p.PackGroupId, promotionId, itemId, packTypeId, startDate, endDate, dBHelper);
                        }
                        else if (promotionDetails.FirstOrDefault().AchievementPeriodId == (int)AchievementPeriodValues.Dynamic)
                        {
                            var p = promotionDetails.FirstOrDefault();
                            result = CheckDynamicAchievementForCustomer(p.AchievementId, customerId, outletId, p.TargetValue, p.PackGroupId, promotionId, itemId, packTypeId, startDate, endDate, dBHelper);
                        }
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors CheckMonthlyAchievementForCustomer(int achievementId, int customerId, int outletId, decimal targetValue, int packGroupId, int promotionId, int itemId, int packTypeId, DateTime startDate, DateTime endDate, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            #region[Declare Variables]
            int startMonth = -1;
            int endMonth = -1;
            int startYear = -1;
            int endYear = -1;
            int multiYearStartMonth = -1;
            bool isThereAnyTarget = false;
            #endregion
            try
            {
                startMonth = startDate.Month;
                endMonth = endDate.Month;
                startYear = startDate.Year;
                endYear = endDate.Year;
                int startedValue;
                for (int currentYear = startYear; currentYear <= endYear; currentYear++)
                {
                    if (currentYear != endYear)
                        multiYearStartMonth = 12;
                    else
                        multiYearStartMonth = endMonth;
                    startedValue = startMonth;
                    if (currentYear != startYear) startedValue = 1;
                    for (int currentMonth = startedValue; currentMonth <= multiYearStartMonth; currentMonth++)
                    {
                        isThereAnyTarget = false;
                        startDate = new DateTime(currentYear, currentMonth, 1);
                        endDate = startDate.AddMonths(1).AddSeconds(-1);
                        // Check if target already exists for the current customer - promotion.
                        result = CheckForTargetsDefinedForSamePromotionAndCustomer(achievementId, customerId, outletId, startDate, endDate, packGroupId, promotionId, itemId, ref isThereAnyTarget, dBHelper);
                        if (result != GlobalErrors.Success) break;
                        if (!isThereAnyTarget)
                        {
                            // Current target per Customer - Promotion does not exist ==> Add Target to customer.
                            result = SaveTargetToCustomer(achievementId, customerId, outletId, targetValue, 0, itemId, startDate, endDate, packTypeId, packGroupId, dBHelper);
                            if (result != GlobalErrors.Success) break;
                            result = LinkCustomerPromotionWithTarget(promotionId, -1, customerId, outletId, achievementId, -1, dBHelper);
                            if (result != GlobalErrors.Success) break;
                        }
                        // else , target exists for customer ==> do not add target.
                    }
                    if (result != GlobalErrors.Success) break;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckWeeklyAchievementForCustomer(int achievementId, int customerId, int outletId, decimal targetValue, int packGroupId, int promotionId, int itemId, int packTypeId, DateTime startDate, DateTime endDate, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool isThereAnyTarget = false;
            try
            {
                DateTime targetStartDate, targetEndDate;
                for (var day = startDate.Date; day.Date <= endDate.Date; day = day.AddDays(7))
                {
                    if (day.DayOfWeek == DayOfWeek.Saturday)
                    {
                        isThereAnyTarget = false;
                        targetStartDate = day.Date;
                        targetEndDate = day.Date.AddDays(7).AddSeconds(-1);
                        result = CheckForTargetsDefinedForSamePromotionAndCustomer(achievementId, customerId, outletId, targetStartDate, targetEndDate, packGroupId, promotionId, itemId, ref isThereAnyTarget, dBHelper);
                        if (result != GlobalErrors.Success) break;
                        if (!isThereAnyTarget)
                        {
                            result = SaveTargetToCustomer(achievementId, customerId, outletId, targetValue, 0, itemId, targetStartDate, targetEndDate, packTypeId, packGroupId, dBHelper);
                            if (result != GlobalErrors.Success) break;
                            result = LinkCustomerPromotionWithTarget(promotionId, -1, customerId, outletId, achievementId, -1, dBHelper);
                            if (result != GlobalErrors.Success) break;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors CheckDynamicAchievementForCustomer(int achievementId, int customerId, int outletId, decimal targetValue, int packGroupId, int promotionId, int itemId, int packTypeId, DateTime startDate, DateTime endDate, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool isThereAnyTarget = false;
            try
            {
                result = CheckForTargetsDefinedForSamePromotionAndCustomer(achievementId, customerId, outletId, startDate, endDate, packGroupId, promotionId, itemId, ref isThereAnyTarget, dBHelper);
                if (result == GlobalErrors.Success && !isThereAnyTarget)
                {
                    result = SaveTargetToCustomer(achievementId, customerId, outletId, targetValue, 0, itemId, startDate, endDate, packTypeId, packGroupId, dBHelper);
                    if (result == GlobalErrors.Success)
                        result = LinkCustomerPromotionWithTarget(promotionId, -1, customerId, outletId, achievementId, -1, dBHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors CheckForTargetsDefinedForSamePromotionAndCustomer(int achievementId, int customerId, int outletId, DateTime fromDate, DateTime toDate, int packGroupId, int promotionId, int itemId, ref bool isThereAnyTarget, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            try
            {
                string query = $@"select Count(*) PCACounter from PromotionCustomerAchievement pca
                inner join AchievementTargetCustomer ATC on atc.CustomerID = pca.CustomerID
                and atc.OutletID = pca.OutletID and atc.AchievementID = pca.AchievementID
                where ATC.AchievementID = {achievementId} and atc.CustomerID = {customerId} and atc.OutletID = {outletId}
                and atc.FromDate = {LocalUtilities.ParseDateToSQLString(fromDate)} and atc.ToDate = {LocalUtilities.ParseEndDateToSQLString(toDate)} and atc.PackGroupID = {packGroupId} 
                and pca.PromotionID = {promotionId} and atc.ItemID = {itemId}";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null)
                {
                    isThereAnyTarget = Convert.ToInt32(field.ToString()) > 0;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetItemIdAndPackTypeIdFromPackId(int packId, ref int packTypeId, ref int itemId, DBHelper<ItemPackModel> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                ItemPackModel packObj = new ItemPackModel();
                string query = string.Format("select PackTypeID, ItemID from Pack where packID = {0}", packId);
                result = dBHelper.GetQuerySingle(query, ref packObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteCustomerIncludeOrExcludeFromPromotion(string tableName, int customerId, int outletId, int promotionId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                // If customer is added to group -> tableName [CustomerPromotionExclusion]. The added customer will be deleted (if exists) from [CustomerPromotionExclusion] for this promotion
                string query = $@"delete from {tableName} where promotionID = {promotionId} and CustomerID = {customerId} and OutletID = {outletId}";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetMaxCustomerPromotionExclusionId(ref int CustomerPromotionExclusionId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                string query = $@"SELECT (MAX(CustomerPromotionExclusionID) + 1) MAX FROM CustomerPromotionExclusion";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success)
                {
                    if (field != null && !field.ToString().Equals(string.Empty))
                    {
                        CustomerPromotionExclusionId = int.Parse(field.ToString());
                    }
                    else
                    {
                        CustomerPromotionExclusionId = 1;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors CheckIfCustomerIsAlreadyIncludedOrExcluded(string tableName, int customerId, int outletId, int promotionId, DBHelper<int> dBHelper, ref bool isIncludedOrExcluded)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                string query = $@"Select count(*) RowsCount from {tableName} where promotionID = {promotionId} and CustomerID = {customerId} and OutletID = {outletId} ";
                result = dBHelper.ExecuteScalar(query, ref field);
                if(result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    if (int.Parse(field.ToString()) > 0) isIncludedOrExcluded = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors ExcludePromotionToCustomers(int CustomerPromotionExclusionId, int promotionId, long customerId, int outletId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"Insert into CustomerPromotionExclusion (CustomerPromotionExclusionId, PromotionId, CustomerId, OutletId) values 
                ({CustomerPromotionExclusionId},{promotionId},{customerId},{outletId})";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteTargetPromotionAchievementsAndTargets(int promotionId,int customerId, int outletId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string customerFilter = string.Empty;
            string query = string.Empty;
            DBHelper<AchievementTargetCustomer> dBHelper_ATC = null;
            List<AchievementTargetCustomer> achievementTargetsList = new List<AchievementTargetCustomer>();
            try
            {
                if(customerId > -1)
                {
                    customerFilter = $" And CustomerID = {customerId} And OutletID = {outletId} ";
                }

                if(dBHelper != null && dBHelper_ATC == null)
                {
                    dBHelper_ATC = new DBHelper<AchievementTargetCustomer>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                query = $@"Select * from PromotionCustomerAchievement where PromotionID = {promotionId} {customerFilter}";
                result = dBHelper_ATC.GetQueryList(query, ref achievementTargetsList);
                if(result == GlobalErrors.Success && achievementTargetsList != null && achievementTargetsList.Count > 0)
                {
                    query = $"Delete from PromotionCustomerAchievement where PromotionID = {promotionId} {customerFilter}";
                    result = dBHelper.ExecuteNonQuery(query);
                    if(result == GlobalErrors.Success)
                    {
                        foreach(AchievementTargetCustomer target in achievementTargetsList)
                        {
                            // delete from AchievementCustomerDetail
                            query = $@"Delete FROM AchievementCustomerDetail
                                                   WHERE DocumentID in
                                            (select DocumentID from AchievementCustomerDetail ACD
                                            INNER JOIN AchievementCustomer AC on  ACD.AchievementID = AC.AchievementID and ACD.TargetID = AC.TargetID and ACD.CustomerID = AC.CustomerID and 
					                        ACD.OutletID = AC.OutletID
                                            where ACD.AchievementID={target.AchievementID} AND ACD.CustomerID = {target.CustomerID} AND ACD.OutletID = {target.OutletID} AND AC.TargetID = {target.TargetID}) ";
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;

                            if (result == GlobalErrors.Success)
                            {
                                // delete from AchievementCustomer
                                query = $@"Delete  FROM AchievementCustomer 
                                     WHERE (AchievementID = {target.AchievementID} AND CustomerID = {target.CustomerID} AND OutletID={target.OutletID} AND TargetID={target.TargetID}) ";
                                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                            }
                            if (result == GlobalErrors.Success)
                            {
                                // delete from AchievementTargetCustomer
                                query = $@"Delete  FROM AchievementTargetCustomer
                                     WHERE (AchievementID =  {target.AchievementID}  AND CustomerID = {target.CustomerID} AND OutletID={target.OutletID} AND TargetID={target.TargetID})";
                                result = dBHelper.ExecuteNonQuery(query);
                            }
                        }
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetMaxCustomerPromotionId(ref int customerPromotionId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                string query = "SELECT (MAX(CustomerPromotionID) + 1) MAX FROM CustomerPromotion";
                result = dBHelper.ExecuteScalar(query, ref field);
                if(result == GlobalErrors.Success)
                {
                    if (field != null && !field.ToString().Equals(string.Empty))
                    {
                        customerPromotionId = int.Parse(field.ToString());
                    }
                    else
                    {
                        customerPromotionId = 1;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors ApplyPromotionToCustomers(int customerPromotionId, int promotionId,  int customerId, int outletId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"Insert into CustomerPromotion (CustomerPromotionId, PromotionId,CustomerId,OutletId) 
                values (
                {customerPromotionId},
                {promotionId},
                {(customerId  == -1 ? "NULL" : customerId.ToString())},
                {outletId}
                )";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors CheckIfThereIsAnotherOutletForThisCustomerInTheGroup(int customerGroupId, int customerId, int outletId, ref bool isThereAnotherOutlet, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            try
            {
                string query = $@"Select count(*) RowsCount from CustomerOutletGroup where  CustomerID = {customerId} and OutletID <> {outletId} and GroupID = {customerGroupId}";
                result = dBHelper.ExecuteScalar(query, ref field);
                if(result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    isThereAnotherOutlet = Convert.ToInt32(field.ToString()) > 0;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors AddCustomerPromotionDataRelatedToCustomerGroup(int groupId, int customerId, int outletId, List<Promotion> includedAchievementPromotions, List<Promotion> excludedAchievementPromotions,DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            int originalOutletId = outletId;
            try
            {
                #region[Add Included Achievements to Customers Promotions]
                if (includedAchievementPromotions != null && includedAchievementPromotions.Count > 0)
                {
                    foreach (Promotion promotion in includedAchievementPromotions)
                    {
                        if (promotion.PromotionLevel == PromotionLevel.CustomerLevel)
                        {
                            outletId = -1;
                        }
                        else
                        {
                            outletId = originalOutletId;
                        }
                        result = AddTargetPromotionAchievementsAndTargets(promotion.PromotionId, promotion.StartDate, promotion.EndDate, customerId, outletId,dBHelper);
                        if (result == GlobalErrors.Success)
                        {
                            result = DeleteCustomerIncludeOrExcludeFromPromotion(CoreDataBaseConstants.TableNames.CustomerPromotionExclusion, customerId, outletId, promotion.PromotionId, dBHelper);
                        }
                        if (result != GlobalErrors.Success) break;
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }
                #endregion

                #region[Remove Excluded Achievements from Customers Promotions]
                if (result == GlobalErrors.Success)
                {
                    if (excludedAchievementPromotions != null && excludedAchievementPromotions.Count > 0)
                    {
                        int customerPromotionExclusionId = 0;
                        result = GetMaxCustomerPromotionExclusionId(ref customerPromotionExclusionId, dBHelper);
                        foreach (Promotion promotion in excludedAchievementPromotions)
                        {
                            bool isAlreadyExcluded = false;
                            if (promotion.PromotionLevel == PromotionLevel.CustomerLevel)
                            {
                                outletId = -1;
                            }
                            else
                            {
                                outletId = originalOutletId;
                            }
                            result = CheckIfCustomerIsAlreadyIncludedOrExcluded(CoreDataBaseConstants.TableNames.CustomerPromotionExclusion, customerId, outletId, promotion.PromotionId, dBHelper, ref isAlreadyExcluded);
                            if (result == GlobalErrors.Success && !isAlreadyExcluded)
                            {
                                result = ExcludePromotionToCustomers(customerPromotionExclusionId, promotion.PromotionId, customerId, outletId, dBHelper);
                                if (result == GlobalErrors.Success && (promotion.PromotionLevel == PromotionLevel.OutletLevel || (promotion.PromotionLevel == PromotionLevel.CustomerLevel /*&& !isThereAnotherOutlet*/)))
                                {
                                    result = DeleteTargetPromotionAchievementsAndTargets(promotion.PromotionId, customerId, outletId, dBHelper);
                                    if (result == GlobalErrors.Success)
                                    {
                                        result = DeleteCustomerIncludeOrExcludeFromPromotion(CoreDataBaseConstants.TableNames.CustomerPromotion
                                               , customerId, outletId, promotion.PromotionId, dBHelper);
                                    }
                                }
                                customerPromotionExclusionId++;
                            }
                            //  else , Customer is already excluded from this promotion
                            if (result != GlobalErrors.Success) break;
                        }
                    }
                }
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteCustomerPromotionDataRelatedToCustomerGroup(int groupId, int customerId, int outletId, List<Promotion> includedAchievementPromotions, List<Promotion> excludedAchievementPromotions, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            int originalOutletId = outletId;
            try
            {
                #region[Add Included Achievements to Customers Promotions]
                if (includedAchievementPromotions != null && includedAchievementPromotions.Count > 0)
                {
                    int customerPromotionId = 0;
                    bool isAlreadyIncluded = false;
                    result = GetMaxCustomerPromotionId(ref customerPromotionId, dBHelper);
                    foreach (Promotion promotion in includedAchievementPromotions)
                    {
                        if (promotion.PromotionLevel == PromotionLevel.CustomerLevel)
                        {
                            outletId = -1;
                        }
                        else
                        {
                            outletId = originalOutletId;
                        }
                        // Check if customer is already included to promotion in [CustomerPromotion] table
                        result = CheckIfCustomerIsAlreadyIncludedOrExcluded(CoreDataBaseConstants.TableNames.CustomerPromotion, customerId, outletId, promotion.PromotionId, dBHelper, ref isAlreadyIncluded);
                        if (result == GlobalErrors.Success && !isAlreadyIncluded)
                        {
                            result = ApplyPromotionToCustomers(customerPromotionId, promotion.PromotionId, customerId, outletId, dBHelper);
                            if (result == GlobalErrors.Success)
                            {
                                result = AddTargetPromotionAchievementsAndTargets(promotion.PromotionId, promotion.StartDate, promotion.EndDate, customerId, outletId, dBHelper);
                                if (result == GlobalErrors.Success)
                                {
                                    // delete any single exclusion for the customer
                                    result = DeleteCustomerIncludeOrExcludeFromPromotion(CoreDataBaseConstants.TableNames.CustomerPromotionExclusion, customerId, outletId, promotion.PromotionId, dBHelper);
                                }
                            }
                            customerPromotionId++;
                        }
                        if (result != GlobalErrors.Success) break;
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }
                #endregion

                #region[Remove Excluded Achievements from Customers Promotions]
                if (result == GlobalErrors.Success)
                {
                    if (excludedAchievementPromotions != null && excludedAchievementPromotions.Count > 0)
                    {
                        bool isThereAnotherOutlet = false;
                        foreach (Promotion promotion in excludedAchievementPromotions)
                        {
                            if (result == GlobalErrors.Success)
                            {
                                if (promotion.PromotionLevel == PromotionLevel.CustomerLevel)
                                {
                                    result = CheckIfThereIsAnotherOutletForThisCustomerInTheGroup(groupId, customerId, outletId, ref isThereAnotherOutlet, dBHelper);
                                    if (result != GlobalErrors.Success) break;
                                    if (!isThereAnotherOutlet)
                                    {
                                        outletId = -1;
                                    }
                                    else
                                    {
                                        outletId = originalOutletId;
                                    }
                                }
                                else // Outlet Level.
                                {
                                    outletId = originalOutletId;
                                }
                                if (result == GlobalErrors.Success && (promotion.PromotionLevel == PromotionLevel.OutletLevel || (promotion.PromotionLevel == PromotionLevel.CustomerLevel && !isThereAnotherOutlet)))
                                {
                                    result = DeleteTargetPromotionAchievementsAndTargets(promotion.PromotionId, customerId, outletId, dBHelper);
                                    if (result == GlobalErrors.Success)
                                    {
                                        result = DeleteCustomerIncludeOrExcludeFromPromotion(CoreDataBaseConstants.TableNames.CustomerPromotion, customerId, outletId, promotion.PromotionId, dBHelper);
                                    }
                                }
                            }
                            if (result != GlobalErrors.Success) break;
                        }
                    }
                }

                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region[old static method]
        public static List<PromotionGroupPackDetail> FillGroupPacksQuantityOld(PromotionOptionDetail detail)
        {
            var groupDetails = new List<PromotionGroupPackDetail>();
            var query = string.Empty;
            DBHelper<PromotionGroupPackDetail> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<PromotionGroupPackDetail>();

                if (detail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantity)
                {
                    query = string.Format(@"SELECT Pack.ItemID,Pack.Quantity PackQuantity, PromotionOptionDetailGroup.PackID, PromotionOptionDetailGroup.Quantity PromotionValue
                    FROM PromotionOptionDetailGroup
                    INNER JOIN Pack ON  PromotionOptionDetailGroup.PackID = Pack.PackID
                    INNER JOIN Item on Item.ItemID = Pack.ItemID AND Item.Inactive = 0
                    WHERE PromotionID = {0} AND PromotionOptionID = {1} AND PromotionOptionDetailID = {2} AND  PackgroupID = {3} "
                    , detail.PromotionId
                    , detail.PromotionOptionId
                    , detail.PromotionOptionDetailId
                    , detail.PackGroupId);
                }
                else if(detail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel)
                {
                    query = string.Format(@"SELECT Pack.ItemID,Pack.Quantity PackQuantity, PromotionOptionDetailGroup.PackID, PromotionOptionDetailGroup.Quantity PromotionValue, PromotionOptionDetailGroup.SalesOrderTypeIDs
                    FROM PromotionOptionDetailGroup
                    INNER JOIN Pack ON  PromotionOptionDetailGroup.PackID = Pack.PackID
                    INNER JOIN Item on Item.ItemID = Pack.ItemID AND Item.Inactive = 0
                    WHERE PromotionID = {0} AND PromotionOptionID = {1} AND PromotionOptionDetailID = {2} AND  PackgroupID = {3} "
                    , detail.PromotionId
                    , detail.PromotionOptionId
                    , detail.PromotionOptionDetailId
                    , detail.PackGroupId);
                }
                else
                {
                    query = string.Format(@"SELECT Pack.ItemID , Pack.Quantity PackQuantity,PackGroupDetail.PackID, {0} PromotionValue
                    FROM PackGroupDetail
                    INNER JOIN Pack ON  PackGroupDetail.PackID = Pack.PackID
					INNER JOIN Item on Item.ItemID = Pack.ItemID AND Item.Inactive = 0
                    WHERE PackGroupDetail.PackgroupID = {1} ", detail.Value, detail.PackGroupId);
                }

                GlobalErrors result = dbHelper.GetQueryList(query, ref groupDetails);
                if (result == GlobalErrors.Success)
                {

                    detail.IsAllGroupItemsHavingSameUOM = groupDetails.GroupBy(j => j.PackQuantity).ToList().Count == 1;

                    if (detail.IsAllGroupItemsHavingSameUOM)
                    {
                        detail.PackGroupQuantity = groupDetails.FirstOrDefault().PackQuantity;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return groupDetails;
        }
        public static List<PromotionGroupPackDetail> FillGroupBenefitDetailsForBundle(PromotionOptionDetail detail)
        {
            var groupDetails = new List<PromotionGroupPackDetail>();
            var query = string.Empty;
            DBHelper<PromotionGroupPackDetail> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<PromotionGroupPackDetail>();
                
                query = string.Format(@"SELECT Pack.ItemID, PromotionBenefitDetailGroup.PackGroupID, Pack.Quantity PackQuantity, PromotionBenefitDetailGroup.PackID, PromotionBenefitDetailGroup.{4} PromotionValue
                FROM PromotionBenefitDetailGroup
                INNER JOIN Pack ON  PromotionBenefitDetailGroup.PackID = Pack.PackID
                INNER JOIN Item on Item.ItemID = Pack.ItemID AND Item.Inactive = 0
                WHERE PromotionID = {0} AND PromotionOptionID = {1} AND PromotionOptionDetailID = {2} AND  PackgroupID = {3} "
                , detail.PromotionId
                , detail.PromotionOptionId
                , detail.PromotionOptionDetailId
                , detail.PackGroupId
                , detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems ? CoreDataBaseConstants.QueryColumnsNames.DiscountValue : CoreDataBaseConstants.QueryColumnsNames.PriceValue);
                
                GlobalErrors result = dbHelper.GetQueryList(query, ref groupDetails);
                if (result == GlobalErrors.Success)
                {
                    detail.IsAllGroupItemsHavingSameUOM = groupDetails.GroupBy(j => j.PackQuantity).ToList().Count == 1;

                    if (detail.IsAllGroupItemsHavingSameUOM)
                    {
                        detail.PackGroupQuantity = groupDetails.FirstOrDefault().PackQuantity;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return groupDetails;
        }
        public string GetInvoiceID(string orderID, int customerID, int outletID, int divisionID)
        {
            string transactionID = string.Empty;
            GlobalErrors err = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string outletIDFilter = string.Empty;

            try
            {
                dbHelper = new DBHelper<int>();
                object field = null;
                if (outletID != -1)
                {
                    outletIDFilter = string.Format(@" AND OutletID = {0}", outletID);
                }
                string query = string.Format(@"Select TransactionID from [Transaction]
                   where  SourceTransactionID ='{0}' AND CustomerID = {1} {2} AND DivisionID = {3} and Voided={4}", orderID
                    , customerID, outletIDFilter, divisionID, 0);
                err = dbHelper.ExecuteScalar(query , ref field);
                if (err == GlobalErrors.Success && field != null)
                {
                    transactionID = (string)field;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return transactionID;
        }
        public bool CheckIfAchievementDetailsAlreadySaved(int customerID, int outletID, int achievementID, int targetID, string documentID, int routeHistoryID, int ItemID, int packGroupID, ref decimal netTotal)
        {
            bool alreadySaved = false;
            DBHelper<decimal> dbHelper = null;
            Object obj = null;
            try
            {
                string BrandFilter = "";
                string outletFilter = string.Empty;
                GlobalErrors err = GlobalErrors.NotInitialized;
                dbHelper = new DBHelper<decimal>();

                if (outletID != -1)
                {
                    outletFilter = string.Format(@" And OutletID={0}", outletID);
                }
                netTotal = 0;

                string query = string.Format(@"Select Value From AchievementCustomerDetail where CustomerID={0} {1} And achievementID={2} AND  DocumentID='{3}' AND RouteHistoryID='{4}' AND ItemID = {5} AND PackGroupID = {6} {7} AND TargetID = {8}"
                    , customerID, outletFilter, achievementID, documentID, routeHistoryID, ItemID, packGroupID, BrandFilter, targetID);
                err = dbHelper.ExecuteScalar(query, ref obj);
                if (err == GlobalErrors.Success && obj != null)
                {
                    if (decimal.Parse(obj.ToString())>0) {
                        netTotal = decimal.Parse(obj.ToString());
                        alreadySaved = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return alreadySaved;
        }

        public GlobalErrors DeleteVoidedDataFromPromotionsHistory(string transactionId,ref List<PromotionsHistoryModel> oldPromotionBenefitHistoryData, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<PromotionsHistoryModel> dbHistory = new DBHelper<PromotionsHistoryModel>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                string query = string.Format(@" Select * from PromotionsHistory Where TransactionID = '{0}' and LastInvoiceDate is not null", transactionId);
                result = dbHistory.GetQueryList(query, ref oldPromotionBenefitHistoryData);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"DELETE FROM PromotionsHistory WHERE TransactionID = '{0}'", transactionId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteVoidedDataFromAccumulativePromotionsHistory(string tableName,string transactionId,int customerId , int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object count = null;
            string promotionsString = "";
            string query = "";
            bool isTested = false;
            List<RelatedToTargetPromotion> relatedToTargetSatisfiedPromotions = new List<RelatedToTargetPromotion>();
            try
            {
                if (tableName == CoreDataBaseConstants.TableNames.TestAccumulativePromotionsHistory)
                    isTested = true;
                query = string.Format(@"DELETE FROM {3} WHERE TransactionID = '{0}' AND CustomerID = {1} AND OutletID = {2}", transactionId, customerId, outletId,tableName);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = RunCalculateSatisfiedPromotionsProcedure(isTested, customerId, outletId, promotionsString, 0, 0, 0, false, "",false, ref relatedToTargetSatisfiedPromotions,-1, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteVoidedDataFromPromBenefitSequenceDetail(string tableName, string transactionId,int customerId , int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object count = null;
            string promotionsString = "";
            string query = "";
            bool isTested = false;
            List<RelatedToTargetPromotion> relatedToTargetSatisfiedPromotions = new List<RelatedToTargetPromotion>();
            try
            {
                if (tableName == CoreDataBaseConstants.TableNames.TestPromBenefitSequenceDetail)
                    isTested = true;
                query = string.Format(@"DELETE FROM {3} WHERE TransactionID = '{0}' AND CustomerID = {1} AND OutletID = {2}", transactionId, customerId, outletId,tableName);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = RunCalculateSatisfiedPromotionsProcedure(isTested, customerId, outletId, promotionsString, 0, 0, 0, false, "",false, ref relatedToTargetSatisfiedPromotions,-1, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors RunCalculateAchievementProcedure(TransactionModel transaction, bool isVoid, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                bool calculateForMultipleCustomers = false;
                DBHelper<string> dbHelper1 = new DBHelper<string>();
                if (DBManager.CheckIfProcedureExisted(CoreDataBaseConstants.ProceduresConstants.ReCalculateAchievements, dbHelper1))
                {
                    if(transaction.CustomerId == -1 && transaction.OutletId == -1) // Make sure customers are filled in TempCustomerOutlets Table.
                    {
                        calculateForMultipleCustomers = true;
                    }
                    string query = string.Format(@"EXEC {0} @CustomerID = {1}, @OutletID = {2}, @DateString = '{3}', @IsVoid = {4}, @CalculateForMultipleCustomers = {5},@RouteID =-1,@TerritoryID = -1,
                        @SessionId ='{6}';",
                        CoreDataBaseConstants.ProceduresConstants.ReCalculateAchievements, transaction.CustomerId, transaction.OutletId,
                        LocalUtilities.ParseDateToSQLString(transaction.TransactionDate).Replace("'", "''"), isVoid ? 1 : 0, calculateForMultipleCustomers ? 1 : 0, _requestRepository.SessionId);
                    object obj = new object();
                    result = dbHelper.ExecuteScalar(query, ref obj);
                    if (obj != null && !string.IsNullOrEmpty(obj.ToString()))
                    {
                        result = (int.Parse(obj.ToString()) ==1) ? GlobalErrors.Success : GlobalErrors.Error;
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors RunCalculateSatisfiedPromotionsProcedure(bool isTest, int CustomerId,int OutletId,string promotionIds , decimal grossTotal, decimal NetTotal, decimal discountTotal,bool isPartialDelivery, string toBeVoidedInvoiceId, bool calculateForMultipleCustomers,ref List<RelatedToTargetPromotion>  relatedToTargetSatisfiedPromotions,int sequence ,DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper1;
            DBHelper<RelatedToTargetPromotion> dbHelper2;
            bool commitNow = false;
            string procedureName = string.Empty;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                    dBHelper.BeginTransaction();
                    commitNow = true;
                }
                dbHelper2 = new DBHelper<RelatedToTargetPromotion>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                dbHelper1 = new DBHelper<string>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());

                if (isTest)
                    procedureName = CoreDataBaseConstants.ProceduresConstants.CalculateTestSatisfiedPromotions;
                else
                    procedureName = CoreDataBaseConstants.ProceduresConstants.CalculateSatisfiedPromotions;

                if (DBManager.CheckIfProcedureExisted(procedureName, dbHelper1))
                {
                    string query = string.Format(@$"
                        EXEC {procedureName} 
                        @CustomerID = {CustomerId},
                        @OutletID = {OutletId},
                        @RouteID = {-1},
                        @TerritoryID = {-1},
                        @Sequence = {sequence},
                        @PromotionIds = {(promotionIds.Equals("") ? "''" : promotionIds)} ,
                        @CurrentInvoiceGrossTotal = {grossTotal},
                        @CurrentInvoiceNetTotal={NetTotal},
                        @CurrentInvoiceDiscountTotal={discountTotal} ,
                        @IsPartialDelivery={(isPartialDelivery ? 1 : 0)},
                        @ToBeVoidedTransactionId ='{toBeVoidedInvoiceId}',
                        @SessionId ='{_requestRepository.SessionId}' ,
                        @ForceCustomerOrganizationSelection = {(_requestRepository.Configurations.ForceCustomerOrganizationSelection ? 1 : 0)},
                        @JoinTempCustOutTable = {(calculateForMultipleCustomers ? 1: 0)};");

                    result = dbHelper2.GetQueryList(query, ref relatedToTargetSatisfiedPromotions);
                    if (relatedToTargetSatisfiedPromotions != null && relatedToTargetSatisfiedPromotions.Count() > 0)
                    {
                        if (!string.IsNullOrEmpty(relatedToTargetSatisfiedPromotions[0].Result.ToString()))
                            result = (int.Parse(relatedToTargetSatisfiedPromotions[0].Result.ToString()) == 1) ? GlobalErrors.Success : GlobalErrors.Error;
                        if (result == GlobalErrors.Success && relatedToTargetSatisfiedPromotions[0].PromotionId <= 0)
                            relatedToTargetSatisfiedPromotions = new List<RelatedToTargetPromotion>();
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally {
                if (commitNow)
                {
                    if (result == GlobalErrors.Success)
                        dBHelper.CommitTransaction();
                    else
                        dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        public GlobalErrors GetCustomerDefinedTargets(ref List<AchievementTargetCustomer> targetsList,ref string targetsString, TransactionModel transaction ,DBHelper<int> dbHelper)
        {
            DBHelper<AchievementTargetCustomer> dbHelperTargets = null;
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                targetsList = new List<AchievementTargetCustomer>();
                dbHelperTargets = new DBHelper<AchievementTargetCustomer>();
                dbHelperTargets = new DBHelper<AchievementTargetCustomer>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                string queryString = string.Format(@" SELECT ATC.*
                FROM AchievementTargetCustomer ATC 
                INNER JOIN PromotionCustomerAchievement PCA on ATC.CustomerID = PCA.CustomerID and ATC.OutletID = PCA.OutletID and  ATC.TargetID = PCA.TargetID and  ATC.AchievementID = PCA.AchievementID
                INNER JOIN Promotion on Promotion.PromotionID = PCA.PromotionID and Promotion.AchievementID = PCA.AchievementID 
	            and promotion.Inactive <> 1 and promotion.IsDeleted <> 1
                left JOIN PromotionsHistory PH ON PH.PromotionID = Promotion.PromotionID and  PH.AchievementID = ATC.AchievementID AND PH.TargetID = ATC.TargetID 
                AND PH.CustomerID = ATC.CustomerID AND ((PH.OutletID = ATC.OutletID and Promotion.PromotionLevel = 2) or (ATC.OutletID = -1 and Promotion.PromotionLevel = 1)) and PH.TransactionID = '{0}'
                WHERE ATC.CustomerID = {1} and ((ATC.OutletID = {2} and Promotion.PromotionLevel = 2)  or (ATC.OutletID = -1 and Promotion.PromotionLevel = 1))", transaction.TransactionId, transaction.CustomerId, transaction.OutletId);
                err = dbHelperTargets.GetQueryList(queryString, ref targetsList);
                if (err == GlobalErrors.Success && targetsList != null && targetsList.Count > 0) {
                    foreach (AchievementTargetCustomer t in targetsList)
                    {
                        targetsString = targetsString + t.TargetID + ",";
                    }
                    targetsString = targetsString.Substring(0, targetsString.Length - 1);
                }
                
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return err;
        }
        public bool IsAnyTransactionAchievedPromotion(OrderModel selectedOrder)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            bool isThereAnyTrans = false;
            Object field = null;
            string orderTransaction = "";
            try
            {
                string queryString = string.Format(" SELECT TransactionID FROM [Transaction] WHERE SourceTransactionID = '{0}' And voided <> 1 ", selectedOrder.OrderId);
                err = dBHelper.ExecuteScalar(queryString, ref field);
                if (err == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString())) {
                    orderTransaction = field.ToString();
                }
                DateTime transDate = DateTime.Now;
                queryString = string.Format(" SELECT TransactionDate FROM [Transaction] WHERE [Transaction].TransactionID = '{0}' ", orderTransaction);
                dBHelper.ExecuteScalar(queryString ,ref field );
               
                if (err == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    transDate = (DateTime)field;
                }
                queryString = string.Format(@"
SELECT SUM(cc) FROM (
                SELECT Count(*) as cc, 1 temp FROM
                PromotionsHistory PH
                INNER JOIN Promotion On Promotion.PromotionID = PH.PromotionID and Promotion.AchievementID = PH.AchievementID and Promotion.Inactive <> 1 and Promotion.IsDeleted <> 1
                INNER JOIN [Transaction] TR ON TR.CustomerID = PH.CustomerID
                AND TR.OutletID = PH.OutletID
                AND TR.TransactionID = PH.TransactionID
                INNER JOIN AchievementTargetCustomer ATC ON ATC.CustomerID = PH.CustomerID
                AND ((ATC.OutletID = PH.OutletID and Promotion.PromotionLevel = 2) or (ATC.OutletID = -1 and Promotion.PromotionLevel = 1))
                AND ATC.TargetID = PH.TargetID 
                AND ATC.AchievementID = PH.AchievementID

                WHERE TR.CustomerID = {0}
                AND ((TR.OutletID = {1} and Promotion.PromotionLevel = 2) or Promotion.PromotionLevel = 1)
                AND (TR.TransactionDate > {3})
                AND TR.Voided = 0
                AND TR.TransactionTypeID IN (1,3)
                AND TR.TransactionID <> '{2}' AND 
				(ATC.AchievementID <> {4} and
				((PH.LastInvoiceDate IS NOT NULL
				OR
				ATC.PromotedOnTransactionID = PH.TransactionID
				OR 
				ATC.PromotedOnTransactionID = '{2}')))
                UNION 
                SELECT Count(*) as cc, 2 temp FROM
                PromotionsHistory PH
                INNER JOIN Promotion On Promotion.PromotionID = PH.PromotionID and Promotion.AchievementID = PH.AchievementID and Promotion.Inactive <> 1 and Promotion.IsDeleted <> 1
                INNER JOIN [Transaction] TR ON TR.CustomerID = PH.CustomerID
                AND TR.OutletID = PH.OutletID
                AND TR.TransactionID = PH.TransactionID
                INNER JOIN AchievementTargetCustomer ATC ON ATC.CustomerID = PH.CustomerID
                AND ((ATC.OutletID = PH.OutletID and Promotion.PromotionLevel = 2) or (ATC.OutletID = -1 and Promotion.PromotionLevel = 1))
                AND ATC.TargetID = PH.TargetID 
                AND ATC.AchievementID = PH.AchievementID
                WHERE TR.CustomerID = {0}
                AND ((TR.OutletID = {1} and Promotion.PromotionLevel = 2) or Promotion.PromotionLevel = 1)
                AND (TR.TransactionDate > {3})
                AND TR.Voided = 0
                AND TR.TransactionTypeID IN (1,3)
                AND TR.TransactionID <> '{2}' AND 
	            ATC.AchievementID = {4}) as tt",
                selectedOrder.CustomerId, selectedOrder.OutletId, orderTransaction, LocalUtilities.ParseDateAndTimeToSQL(transDate), AchievementValues.DynamicSalesPerPackGroupPerCustomer.GetHashCode());
                err = dBHelper.ExecuteScalar(queryString , ref field);

                if (err == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    if (int.Parse(field.ToString()) > 0)
                        isThereAnyTrans = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isThereAnyTrans;
        }
        public bool IsAnyLaterTransactionAchievedRelatedToTargetPromotion(OrderModel selectedOrder)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            bool isThereAnyTrans = false;
            Object field = null;
            string orderTransaction = "";
            bool lastInvoiceRecord = false;
            try
            {
                string queryString = string.Format(" SELECT TransactionID FROM [Transaction] WHERE SourceTransactionID = '{0}' And voided <> 1 ", selectedOrder.OrderId);
                err = dBHelper.ExecuteScalar(queryString, ref field);
                if (err == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    orderTransaction = field.ToString();
                }
                DateTime transDate = DateTime.Now;
                queryString = string.Format(" SELECT TransactionDate FROM [Transaction] WHERE [Transaction].TransactionID = '{0}' ", orderTransaction);
                dBHelper.ExecuteScalar(queryString, ref field);

                if (err == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    transDate = (DateTime)field;
                }
                DateTime lastInvoiceDate = DateTime.Now;
                queryString = string.Format(" SELECT LastInvoiceDate FROM AccumulativePromotionsHistory PH WHERE PH.TransactionID = '{0}' ", orderTransaction);
                dBHelper.ExecuteScalar(queryString, ref field);

                if (err == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    lastInvoiceDate = (DateTime)field;
                    lastInvoiceRecord = true;
                }
                queryString = string.Format(@"SELECT Count(*) FROM
                AccumulativePromotionsHistory PH
                INNER JOIN Promotion On Promotion.PromotionID = PH.PromotionID and Promotion.Inactive <> 1 and Promotion.IsDeleted <> 1
                INNER JOIN [Transaction] TR ON TR.CustomerID = PH.CustomerID
                AND TR.OutletID = PH.OutletID
                AND TR.TransactionID = PH.TransactionID
                WHERE TR.CustomerID = {0}
                AND ((TR.OutletID = {1} and Promotion.PromotionLevel = 2) or Promotion.PromotionLevel = 1)
                AND (TR.TransactionDate > {3})
                AND TR.Voided = 0
                AND TR.TransactionTypeID IN (1,3)
                AND TR.TransactionID <> '{2}' ",
                selectedOrder.CustomerId, selectedOrder.OutletId, orderTransaction, lastInvoiceRecord ? LocalUtilities.ParseDateAndTimeToSQL(lastInvoiceDate) : LocalUtilities.ParseDateAndTimeToSQL(transDate));
                err = dBHelper.ExecuteScalar(queryString, ref field);

                if (err == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    if (int.Parse(field.ToString()) > 0)
                        isThereAnyTrans = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isThereAnyTrans;
        }
        public decimal GetCustomerOldBenefitValue(AchievementTargetCustomer item, int promotionID, string transactionID, bool isPartialDelivery, PromotionLevel promotionLevel)
        {
            decimal value = 0;
            string outletFilter = string.Empty;
            string outletIDCondition = string.Empty;
            string partialDeliveryTranactionID = string.Empty;
            object field = null;
            string query = string.Empty;
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<int>();
                if (isPartialDelivery && !string.IsNullOrEmpty(transactionID))
                {
                    partialDeliveryTranactionID = string.Format(" and PromotionsHistory.TransactionID <> '{0}' ", transactionID);
                }
                if (promotionLevel == PromotionLevel.OutletLevel)
                {
                    outletFilter = " and [Transaction].OutletID = PromotionsHistory.OutletID ";
                    outletIDCondition = string.Format(@" and PromotionsHistory.OutletID = {0} ", item.OutletID);
                }
                query = string.Format(@" select BenefitValue from PromotionsHistory 
                Inner join [Transaction] on [Transaction].TransactionID =PromotionsHistory.TransactionID 
                and [Transaction].CustomerID = PromotionsHistory.CustomerID {0}
                Where PromotionsHistory.CustomerID = {1} {2} and PromotionsHistory.AchievementID = {3} and PromotionsHistory.PromotionID = {4}  and [Transaction].Voided <> 1 {5} order by [Transaction].TransactionDate desc", outletFilter, item.CustomerID, outletIDCondition, item.AchievementID, promotionID, partialDeliveryTranactionID);
                result = dBHelper.ExecuteScalar(query , ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    value = Convert.ToDecimal(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return value;
        }
        public int GetPromotionOptionID(int promotionID, decimal value)
        {
            int promotionOptionID = -1;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object filed = null;
                string query = string.Format(@"select PromotionOptionID from PromotionOptionDetail where promotionid = {0}
                and PromotionOptionTypeID = 2 and Value = {1}"
                , promotionID, value);
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref filed);
                if (result == GlobalErrors.Success && filed != null && !string.IsNullOrEmpty(filed.ToString()))
                {
                    promotionOptionID = int.Parse(filed.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return promotionOptionID;
        }






        #endregion

        #region[Calculate Customer Target Promotions]
        public GlobalErrors DeleteFromTempCustomerOutlets(DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"Delete from TempCustomerOutlets where sessionId = '{_requestRepository.SessionId}'";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertIntoTempCustomerOutlets(List<CustomerModel> customersList,  DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder values = new StringBuilder();
                foreach (CustomerModel custOut in customersList)
                {
                    values.AppendFormat("({0},{1},'{2}'),",
                       custOut.CustomerId, //0
                       custOut.OutletId, // 1
                       _requestRepository.SessionId //2
                        );
                }
                string query = string.Format(@"Insert Into TempCustomerOutlets 
                    (CustomerId, OutletId, sessionId) 
                        Values {0}", values.ToString().TrimEnd(','));
                result = dBHelper.ExecuteNonQuery(query);
                //result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustsWithActiveTargetOrAchievementPromos(int employeeId, int customerId, int outletId, bool isViewMode, ref List<CustomerModel> customersList, ref List<Promotion> promotionsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<CustomerModel> dBHelper = null;
                DBHelper<Promotion> dBHelper2 = null;

                StringBuilder orgAccess = new StringBuilder();
                string promotionIdSelection = string.Empty;
                string custOutFilter = string.Empty;
                string promotionJoin = string.Empty;
                string promotionData = string.Empty;
                string outletFilter = string.Empty;
                //string customersPromotionsTable = @"declare @CustomersPromotions table 
                //    (
	               //     CustomerId int,
	               //     OutletId int,
	               //     Description nvarchar(200),
	               //     CustomerCodeName nvarchar(200),
	               //     OutletCodeName nvarchar(200),
	               //     CustomerCode nvarchar(200),
	               //     CustomerDescription  nvarchar(200),
	               //     CustomerOutletDescription nvarchar(200),
	               //     PromotionId int
                //    ) ";
                //string customerPromotionFinalSelect = $@"SELECT 
                //  A.CustomerId, A.OutletId,A.Description, 
				            //    A.CustomerCodeName, A.OutletCodeName, A.CustomerCode, 
				            //    A.CustomerDescription, A.CustomerOutletDescription,
                //  STUFF( (
                //    SELECT ', ' +   CAST(B.PromotionId AS VARCHAR(10)) 
                //    FROM @CustomersPromotions B
                //    WHERE (A.CustomerId = B.CustomerId and B.outletID = A.outletID) 
                //    FOR XML PATH(''))
                //  ,1,1,'') AS AchievementAndTargetPromotionIds
                //FROM @CustomersPromotions A
                //GROUP BY A.CustomerId, A.OutletId, A.Description, 
				            //    A.CustomerCodeName, A.OutletCodeName, A.CustomerCode, 
				            //    A.CustomerDescription, A.CustomerOutletDescription";

                promotionIdSelection = ", p.promotionId";
      
                if (customerId > -1)
                {
                    if (isViewMode)
                    {
                        //promotionIdSelection = ", p.promotionId";
                        promotionJoin = $@" inner join promotion p on p.PromotionID = tt.PromotionId
                            Left Join promotionLanguage PL on PL.promotionId = p.promotionId and pl.languageId = {_requestRepository.LanguageId}";
                        promotionData = $@" , p.PromotionType, p.RelatedToTarget, PL.description promotionName, p.promotionCode, p.startDate, p.enddate,CASE WHEN p.PromotionType = 4 THEN 'Desc_Monthly_Target_Promotion_Type' when p.PromotionType = 6 then 'Desc_Dynamic_Target_Promotion_Type' when ISNULL(p.RelatedToTarget,0) = 1 and p.PromotionType = 2 then 'Desc_Ranges_Promotion_Type'
				            when ISNULL(p.RelatedToTarget,0) = 1 and p.PromotionType = 3 then 'Desc_Steps_Promotion_Type' end as PromotionTypeName";
                        dBHelper2 = new DBHelper<Promotion>();
                    }
                    else
                    {
                        dBHelper = new DBHelper<CustomerModel>();
                    }
                    if (outletId > -1)
                    {
                        outletFilter = $@" and CO.outletId = {outletId}";
                    }
                    custOutFilter = $" and CO.customerId = {customerId} {outletFilter}";
                }
                else
                {
                    dBHelper = new DBHelper<CustomerModel>();
                }
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccess.AppendFormat(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery , "tt", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                string routeTerritoryJoin = string.Empty;
                if (_requestRepository.Configurations.AllowTerritoryCustomerVisit)
                {
                    routeTerritoryJoin = string.Format(@"INNER JOIN CustOutTerritory CT ON CT.CustomerID = CO.CustomerID AND CT.OutletID = CO.OutletID 
                        INNER JOIN EmployeeTerritory ET ON ET.TerritoryID = CT.TerritoryID AND ET.EmployeeID = {0}", employeeId);
                }
                else
                {
                    routeTerritoryJoin = string.Format(@"INNER JOIN RouteCustomer CT ON CT.CustomerID = CO.CustomerID AND CT.OutletID = CO.OutletID 
                        INNER JOIN Route on Route.RouteID = CT.RouteID       
                        INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = Route.TerritoryID And EmployeeTerritory.EmployeeID = {0}", employeeId);
                }
                string activePromotions = $@"
                -- Get Active related to target and achievement promotions 
                Declare @ActiveTargetAndAchievementPromotionIds table (PromotionId int, PromotionLevel int)
                Insert into @ActiveTargetAndAchievementPromotionIds

                SELECT distinct  Promotion.PromotionID , promotion.PromotionLevel
                FROM Promotion 
                INNER JOIN CustomerPromotionOrganization cpo ON cpo.PromotionID = Promotion.PromotionID AND cpo.OrganizationID IN ({_requestRepository.CurrentOperator.OrganizationAccess})
                WHERE 
                ISNULL(Promotion.IsDeleted,0) = 0 
                AND ISNULL(Inactive,0) = 0
                AND StartDate <= {LocalUtilities.ParseDateToSQLString(DateTime.Now)}  AND ((EndDate >= {LocalUtilities.ParseDateToSQLString(DateTime.Now)}  and AppliedAfterPeriod = 0) OR ( AppliedAfterPeriod = 1 And {LocalUtilities.ParseDateToSQLString(DateTime.Now)}  > EndDate) )
                and 
                (
	                (ISNULL(Promotion.RelatedToTarget,0) = 1)
	                OR
	                (Promotion.PromotionType in ({(int)PromotionTypes.DynamicTargetPromotion},{(int)PromotionTypes.TargetPromotion}))
                )";
                string query = $@"{activePromotions}
                select distinct tt.CustomerID,tt.OutletID , COL.Description {promotionData}   , 
                IsNull( C.CustomerCode , '--') + ' - ' + IsNull( CL.Description , '--') as CustomerCodeName,
                IsNull( CO.CustomerCode , '--') + ' - ' + IsNull( COL.Description , '--') as OutletCodeName,
                C.CustomerCode,
                CL.Description CustomerDescription,
                COL.Description CustomerOutletDescription,
                tt.promotionId
                from
                (
                ---- SubChannel
                SELECT  CO.CustomerID, CO.OutletID {promotionIdSelection}
                FROM CustomerPromotion CP
                INNER JOIN CustomerGroup CG ON CG.ChannelID = CP.ChannelID AND CG.SubChannelID = CP.SubChannelID
                INNER JOIN CustomerOutletGroup CO ON CO.GroupID = CG.GroupID 
                {routeTerritoryJoin}
                INNER JOIN @ActiveTargetAndAchievementPromotionIds P on P.PromotionId = CP.PromotionID
                where 1=1 {custOutFilter}
                UNION
                ---- Group level
                SELECT  CO.CustomerID, CO.OutletID {promotionIdSelection}
                FROM CustomerPromotion CP
                INNER JOIN CustomerOutletGroup CO ON CO.GroupID = CP.CustomerGroupID 
                {routeTerritoryJoin}
                INNER JOIN @ActiveTargetAndAchievementPromotionIds P on P.PromotionId = CP.PromotionID
                where 1=1 {custOutFilter}

                UNION
                ---- Customer level
                SELECT  CO.CustomerID, CO.OutletID {promotionIdSelection}
                FROM CustomerPromotion CP 
                INNER JOIN @ActiveTargetAndAchievementPromotionIds P on P.PromotionId = CP.PromotionID
                INNER JOIN CustomerOutlet CO ON CO.CustomerID = CP.CustomerID and 
                (
	                (CO.OutletID = CP.OutletID and P.PromotionLevel = 2) 
	                Or
	                (CP.OutletID = -1 and P.PromotionLevel = 1)
                )
                {routeTerritoryJoin}
                where 1=1 {custOutFilter}
                UNION
                ---- All Customers
                SELECT  CO.CustomerID, CO.OutletID {promotionIdSelection}
                FROM CustomerPromotion CP
                INNER JOIN CustomerOutlet CO ON CP.AllCustomers = 1 
                INNER JOIN @ActiveTargetAndAchievementPromotionIds P on P.PromotionId = CP.PromotionID
                {routeTerritoryJoin}
                WHERE CP.AllCustomers = 1 {custOutFilter}
                ) tt
                {orgAccess}
                INNER JOIN Customer C on C.CustomerID = tt.CustomerID
                Inner join CustomerOutlet CO on CO.CustomerID = tt.CustomerID and CO.OutletID = tt.OutletID
                {promotionJoin}                
                LEFT JOIN CustomerLanguage CL on CL.CustomerID = tt.CustomerID and CL.LanguageID = {_requestRepository.LanguageId}
                LEFT JOIN CustomerOutletLanguage COL on COL.CustomerID = tt.CustomerID and COL.OutletID = tt.OutletID and COL.LanguageID = {_requestRepository.LanguageId}
				where ISNULL(CO.Inactive,0) = 0
                order by  CL.Description";
                if (dBHelper != null)
                {
                    result = dBHelper.GetQueryList(query, ref customersList , true);
                }
                else if (dBHelper2 != null)
                {
                    result = dBHelper2.GetQueryList(query, ref promotionsList , true);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPromotionsFromIdsString(string promotionIdsString, ref List<Promotion> promotionsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<Promotion> dBHelper = new DBHelper<Promotion>();
                string query = $@"select  p.promotionid, p.PromotionType, p.RelatedToTarget, PL.description promotionName, p.promotionCode, p.startDate, p.enddate,CASE WHEN p.PromotionType = {(int) PromotionTypes.TargetPromotion} THEN 'Desc_Monthly_Target_Promotion_Type' when p.PromotionType ={(int)PromotionTypes.DynamicTargetPromotion} then 'Desc_Dynamic_Target_Promotion_Type' when ISNULL(p.RelatedToTarget,0) = 1 and p.PromotionType = {(int)PromotionTypes.RangeValues} then 'Desc_Ranges_Promotion_Type'
				            when ISNULL(p.RelatedToTarget,0) = 1 and p.PromotionType ={(int)PromotionTypes.DynamicTargetPromotion} then 'Desc_Dynamic_Target_Promotion_Type' when ISNULL(p.RelatedToTarget,0) = 1 and p.PromotionType = {(int)PromotionTypes.StepsValues} then 'Desc_Steps_Promotion_Type' end as PromotionTypeName
                            from promotion p
                            left join PromotionLanguage pl on pl.PromotionID = p.PromotionID and pl.LanguageID = {_requestRepository.LanguageId}
                            where p.PromotionID in ({promotionIdsString})";
                result = dBHelper.GetQueryList(query, ref promotionsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetRelatedToTargetPromotionIds(string promotionIdsString, ref List<int> relatedToTargePromotionIdsList , DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if(!string.IsNullOrEmpty(promotionIdsString))
                {
                    string query = $@" select DISTINCT promotionid from promotion where promotionid in ({promotionIdsString}) AND ISNULL(RelatedToTarget,0) = 1";
                    result = dBHelper.GetQueryList(query, ref relatedToTargePromotionIdsList);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        #endregion

        public GlobalErrors GetOrderBundlesDetails(int bundleId, int customerId, int outletId, ref List<ItemPackModel> bundlesDetails)
        {
            GlobalErrors result = GlobalErrors.Success;
            string query = string.Empty;
            try
            {
                DBHelper<ItemPackModel> dBHelper = new DBHelper<ItemPackModel>();
                query = string.Format(@" select BenefitValues.PriceValue,BenefitValues.DiscountValue,BundleItems.PromotionID,Item.ForceDefaultPack ,Item.DefaultPackID,ItemCategory.divisionID,Pack.Quantity PackQuantity,Pack.ItemID,Item.ItemCode,BundleItems.PackID,PackTypeLanguage.Description UOM,
                ItemLanguage.Description ItemName,BundleItems.Quantity,Item.IsBatchPriced,DiscountDetails.PromotionOptionDetailTypeID,BenefitValues.DiscountValue Value
                ,DiscountDetails.PromotionOptionID,DiscountDetails.PromotionOptionDetailID,DiscountDetails.PromotionOptionTypeID,BundleItems.PackGroupID
                FROM PromotionOptionDetailGroup BundleItems
                INNER JOIN PromotionOptionDetail DiscountDetails ON BundleItems.PromotionID = DiscountDetails.PromotionID
                AND BundleItems.PackGroupID = DiscountDetails.PackGroupID
                AND DiscountDetails.PromotionOptionTypeID = {1}
                INNER JOIN PromotionBenefitDetailGroup BenefitValues ON BundleItems.PromotionID = BenefitValues.PromotionID AND
                BundleItems.PackGroupID = BenefitValues.PackGroupID AND
                BundleItems.PackID = BenefitValues.PackID
                left join(select distinct pbg.PromotionID from PromotionBenefitDetailGroup pbg
                inner join promotion on promotion.promotionid = pbg.promotionid
                left join pack on pack.PackID = pbg.PackID
                where Promotion.IsBundle =1 and pack.packid is null
                )t on t.PromotionID = BundleItems.PromotionID 
                INNER JOIN Pack ON BundleItems.PackID = Pack.PackID
                INNER JOIN Item ON Pack.ItemID = Item.ItemID
                INNER JOIN ItemCategory ON Item.ItemCategoryID = ItemCategory.ItemCategoryID
                LEFT OUTER JOIN PackTypeLanguage ON PACK.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                LEFT OUTER JOIN ItemLanguage ON ItemLanguage.ItemID = Pack.ItemID AND ItemLanguage.LanguageID = {0}
                WHERE BundleItems.PromotionID = {2}  and t.PromotionID is null and (BundleItems.Quantity is not null and BundleItems.Quantity >0)
                and BundleItems.PromotionID not in (select CPR.PromotionID from CustomerPromotionExclusion CPR where CPR.PromotionID =  BundleItems.PromotionID and CPR.CustomerID = {3} and  CPR.OutletId = {4})", _requestRepository.LanguageId, PromotionOptionTypes.Output.GetHashCode(), bundleId, customerId, outletId);
                result = dBHelper.GetQueryList(query, ref bundlesDetails);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
    }
}