﻿using Sonic.Web.Core.AutoService;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.AutoService;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Threading;
using Sonic.Web.Resources;
using Sonic.Web.Service.SendEmail;
using DinkToPdf.Contracts;
using Microsoft.AspNetCore.Http;
using DinkToPdf;
using System.IO;
using Microsoft.AspNetCore.Hosting;
using RestSharp;
using Sonic.Web.Core;
using Newtonsoft.Json.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using System.Net.Http.Headers;
using System.Linq;

namespace Sonic.Web.Service.AutoService
{
    public class AutoServiceComponent
    {
        #region [DECLARATIONS]

        public AutoServiceModel _serviceModel;
        private bool _isSleepThread = false;
        private bool _isStarted;
        private bool _isRunning;
        private readonly IConverter _converter;
        private readonly SendEmailService _sendEmailService;
        private readonly EmailService _emailService;
        private TemplateGenerator _templateGenerator;
        private ServicesService _servicesService;

        private Timer _timerServices;
        private Timer _timerInsertImages;
        //private int executionCount = 0;
        //private IWebHostEnvironment _webHostEnvironment;
        //private CancellationToken _cancellationToken;

        //private ProofService _proofService;

        #endregion

        #region [METHODS]

        public AutoServiceComponent(CancellationToken cancellationToken, AutoServiceModel serviceModel,IConverter converter)
        {
            try
            {
                _serviceModel = serviceModel;
                _sendEmailService = new SendEmailService(null, converter);
                _isStarted = false;
                _isRunning = false;
                _emailService = new EmailService(null);
                _templateGenerator = new TemplateGenerator(null);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }


        public void RunService()
        {
            try
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Run Service ==> " + _serviceModel.ServiceName, null, string.Empty, 0);
                //Read Details 
                string message = string.Empty;
                TimeSpan startTimeSpan, periodTimeSpan;
                GlobalErrors result = GlobalErrors.Success;

                if (_serviceModel != null)
                {
                    _serviceModel.StartRunTime = DateTime.Now;                   
                    if (!_serviceModel.IsCertainTimeRuning)
                    {
                        startTimeSpan = TimeSpan.Zero;
                        periodTimeSpan = TimeSpan.FromMilliseconds(GetSleepTime());
                    }
                    else
                    {
                        startTimeSpan = TimeSpan.FromMilliseconds(GetSleepTime());
                        periodTimeSpan = TimeSpan.FromMilliseconds(86400000);
                    }
                    switch (_serviceModel.ServiceName)
                    {
                        case WebServiceActions.SendTransactionByEmail:
                            _timerServices = new Timer(SendTransactionsByEmail, null, startTimeSpan, periodTimeSpan);
                            break;

                        case WebServiceActions.CheckOnlineEPayment:
                            _timerServices = new Timer(CheckOnlineEPayments, null, startTimeSpan, periodTimeSpan);
                            break;
                        case WebServiceActions.ReportScheduleService:
                            _timerServices = new Timer(SendReportScheduleByEmail, _serviceModel, startTimeSpan, periodTimeSpan);
                            break;
                    }
                    AutoServiceManager autoServiceManager = new AutoServiceManager(null);
                }
                else
                {
                    message = "Error While Reading Services";
                }

                if (result == GlobalErrors.Success)
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, string.Format("Success Running Service ==> {0}, Message ==> {1}", _serviceModel.ServiceName, result.ToString()), null, string.Empty, 0);
                }
                else
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Failed Running Service ==> " + _serviceModel.ServiceName + " , Error ==> " + GlobalErrors.Error.ToString(), null, string.Empty, 0);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public void RunImagesService()
        {
            try
            {
                _timerInsertImages = new Timer(DoWorkImageInserting, null, TimeSpan.Zero,TimeSpan.FromMinutes(10));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        private bool ExecuteMethodCheck()
        {
            bool execute = false;
            try
            {
                if (_serviceModel.IsCertainTimeRuning)
                {
                    if ((_serviceModel.TimeToRun.Hour == DateTime.Now.Hour) && (_serviceModel.TimeToRun.Minute == DateTime.Now.Minute))
                    {
                        execute = true;
                    }
                }
                else
                {
                    execute = true;
                }
            }
            catch (Exception ex)
            {
                execute = false;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return execute;
        }
        /// <summary>
        /// calculate sleep time in millisecond
        /// </summary>
        /// <returns></returns>
        private int GetSleepTime()
        {
            int SleepTime = 0;
            try
            {
                if (!_serviceModel.IsCertainTimeRuning)
                {
                     SleepTime = _serviceModel.NumberOfMinutesToSleep * 60000;
                }
                else
                {
                    DateTime currentTime = DateTime.Now;
                    int hour = currentTime.Hour;
                    int minute = currentTime.Minute;

                    if (currentTime.Date >= _serviceModel.TimeToRun.Date)
                    {
                        if ((hour < _serviceModel.TimeToRun.Hour))
                        {
                            //if (minute <= _serviceModel.TimeToRun.Minute)
                            //{
                                SleepTime = (_serviceModel.TimeToRun.Minute - minute);
                                SleepTime = SleepTime + ((_serviceModel.TimeToRun.Hour - hour) * 60);
                            //}
                            //else
                            //{
                            //    SleepTime = 60 - minute;
                            //    SleepTime = SleepTime + ((_serviceModel.TimeToRun.Hour - hour - 1) * 60);
                            //}
                        }
                        else if ((hour == _serviceModel.TimeToRun.Hour))
                        {
                            if (minute <= _serviceModel.TimeToRun.Minute)
                            {
                                SleepTime = (_serviceModel.TimeToRun.Minute - minute);
                            }
                            else
                            {
                                SleepTime = 60 - minute;
                                SleepTime = SleepTime + (23 * 60);
                            }
                        }
                        else if (hour > _serviceModel.TimeToRun.Hour)
                        {
                            if (minute <= _serviceModel.TimeToRun.Minute)
                            {
                                SleepTime = (_serviceModel.TimeToRun.Minute - minute);
                                SleepTime = (24 * 60) - (SleepTime + ((hour - _serviceModel.TimeToRun.Hour) * 60));
                            }
                            else
                            {
                                SleepTime = 60 - minute;
                                SleepTime = (24 * 60) - (SleepTime + ((hour - _serviceModel.TimeToRun.Hour - 1) * 60));
                            }
                        }
                        // Sleep Time in Millisecond
                        if (SleepTime == 0)
                        {
                            SleepTime = (24 * 60 * 60000) - 1000;
                        }
                        else
                        {
                            SleepTime = (SleepTime * 60000) - 1000;
                        }
                    }
                    else
                    {
                        SleepTime = 86400000;
                    }
                }
            }
            catch (Exception ex)
            {
                SleepTime = 0;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return SleepTime;
        }

        //        public void CheckOnlineEPayments(object state)
        //        {
        //            GlobalErrors result = GlobalErrors.NotInitialized;
        //            var _paymentService = new PaymentService(null);
        //            try
        //            {
        //                List<PaymentModel> onlineEPayments = new List<PaymentModel>();
        //                result = AutoServiceManager.InsertWindowsServiceHistoryRecord(WebServiceActions.CheckOnlineEPayment);
        //                if (result == GlobalErrors.Success)
        //                    result = _paymentService.GetOnlineEPaymentsList(onlineEPayments, true);
        //                if (result == GlobalErrors.Success && onlineEPayments != null && onlineEPayments.Count > 0)
        //                {

        //                    ConfigurationManager _configurationManager = new ConfigurationManager(null);
        //                    dynamic keyValue = "Demo Merchant";
        //                    result = _configurationManager.GetConfigurationValueFromDB($"CompanyName", ref keyValue);

        //                    dynamic terminal = "Terminal";
        //                    result = _configurationManager.GetConfigurationValueFromDB($"E-PaymentTerminal", ref terminal);
        //                    dynamic Store = "Store";
        //                    result = _configurationManager.GetConfigurationValueFromDB($"E-PaymentStore", ref Store);
        //                    dynamic OnlineEPaymentExpiryDateLimit = 0;
        //                    result = _configurationManager.GetConfigurationValueFromDB($"OnlineEPaymentExpiryDateLimit", ref OnlineEPaymentExpiryDateLimit);
        //                    dynamic paymentGateWay = "";
        //                    result = _configurationManager.GetConfigurationValueFromDB($"PaymentGateway", ref paymentGateWay);

        //                    dynamic paymentGateWayUserName = "";
        //                    result = _configurationManager.GetConfigurationValueFromDB($"PaymentGateWayUserName", ref paymentGateWayUserName);

        //                    dynamic paymentGateWayPassword = "";
        //                    result = _configurationManager.GetConfigurationValueFromDB($"PaymentGateWayPassword", ref paymentGateWayPassword);

        //                    List<string> checkedPayments = new List<string>();
        //                    foreach (PaymentModel payment in onlineEPayments)
        //                    {
        //                        if (checkedPayments.Contains(payment.ThirdPartyTransactionId.ToString())) continue;
        //                        var body = @"{
        //                        " + "\n" +
        //@"""QueryInvoice"": {
        //                        " + "\n" +
        //@$"""InvoiceID"": "" {payment.ThirdPartyTransactionId.ToString()}"",
        //                        " + "\n" +
        //@"""Customer"": [
        //                        " + "\n" +
        //@$"""{(string)keyValue}"",
        //                        " + "\n" +
        //@$"""{(string)Store}"",
        //                        " + "\n" +
        //@$"""{(string)terminal}""
        //                        " + "\n" +
        //@"],
        //                        " + "\n" +
        //$@"""UserName"": ""{paymentGateWayUserName}"",
        //                        " + "\n" +
        //$@"""Password"": ""{paymentGateWayPassword}""
        //                        " + "\n" +
        //@"}
        //                        " + "\n" +
        //@"}";
        //                        var client = new RestClient(paymentGateWay);
        //                        var request = new RestRequest();
        //                        request.AddHeader("Accept", " application/json");
        //                        request.AddHeader("Content-Type", "application/json");
        //                        request.AddParameter("application/json", body, ParameterType.RequestBody);

        //                        if (LocalUtilities.PrintEPaymentInErrorLogger != null
        //                            && !string.IsNullOrEmpty(LocalUtilities.PrintEPaymentInErrorLogger)
        //                            && LocalUtilities.PrintEPaymentInErrorLogger.ToLower().Equals("true"))
        //                        {
        //                            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, body.ToString(), new Exception(), "", 0);

        //                        }
        //                        var response = client.ExecutePost(request);
        //                        Console.WriteLine(response.Content);
        //                        JObject jObject = JObject.Parse(response.Content);
        //                        JToken jTransaction = jObject["Transaction"];
        //                        JToken jTransactions = jTransaction["Transactions"];
        //                        string UniqueID, ResponseCode, TransactionStatus = "", ResponseDescription = "", ApprovalCode = "";
        //                        int TransactionsAuthorized = (int)jTransaction["TransactionsAuthorized"];
        //                        UniqueID = jTransaction["UniqueID"] == null ? "" : (string)jTransaction["UniqueID"];
        //                        ResponseDescription = jTransaction["ResponseDescription"] == null ? "" : (string)jTransaction["ResponseDescription"];
        //                        ResponseCode = jTransaction["ResponseCode"] == null ? "" : (string)jTransaction["ResponseCode"];
        //                        ApprovalCode = jTransactions == null ? "" : (string)(jTransactions["InvoiceTransaction"].ToArray()[0]["ApprovalCode"]);

        //                        if (_paymentService.SaveOnlineEPaymentResponse(ResponseDescription, UniqueID, ResponseCode, payment, response.Content) != GlobalErrors.Success)
        //                        {

        //                            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Failed to save Online e-payment respone" + "PaymentID => [ " + payment.CustomerPaymentId + " ] UUID => [ " /*+ payment.UUID */+ " ]" + "Response content => [ " + response.Content + " ]", null, "", 0);

        //                        }
        //                        if (TransactionsAuthorized > 0) // TransactionsAuthorized == 0 didnt enterd payment link
        //                        {
        //                            JToken jInvoiceTransaction = jTransactions["InvoiceTransaction"];
        //                            if (TransactionsAuthorized == 1)
        //                                TransactionStatus = jInvoiceTransaction[0]["TransactionStatus"] == null ? "" : (string)jInvoiceTransaction[0]["TransactionStatus"];
        //                            else
        //                                for (int i = 0; i < TransactionsAuthorized; i++)
        //                                {
        //                                    if (jInvoiceTransaction[i]["TransactionStatus"] != null && ((string)jInvoiceTransaction[i]["TransactionStatus"]).ToLower().Equals("Authorized".ToLower()))
        //                                    {
        //                                        TransactionStatus = (string)jInvoiceTransaction[i]["TransactionStatus"];
        //                                        break;
        //                                    }

        //                                }
        //                            if (TransactionStatus.ToLower().Equals("Authorized".ToLower()))
        //                            { //post payments onlineEPayments.Where(p => p.ThirdPartyTransactionId.ToString().Equals(payment.ThirdPartyTransactionId.ToString())).ToList() 
        //                                result = _paymentService.PostOnlineEpayment(payment, ApprovalCode);
        //                            }
        //                            else if (DateTime.Now > payment.PaymentDate.AddHours(Int16.Parse(OnlineEPaymentExpiryDateLimit)))
        //                            { //void
        //                                result = _paymentService.VoidOnlineEPayment(payment);
        //                            }
        //                        }
        //                        else if (DateTime.Now > payment.PaymentDate.AddHours(Int16.Parse(OnlineEPaymentExpiryDateLimit)))
        //                        { //void
        //                            result = _paymentService.VoidOnlineEPayment(payment);
        //                        }


        //                        checkedPayments.Add(payment.ThirdPartyTransactionId);

        //                    }
        //                }
        //            }
        //            catch (Exception ex)
        //            {
        //                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //            }
        //        }
        public void CheckOnlineEPayments(object state)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            var _paymentService = new PaymentService(null);
            try
            {
                List<PaymentModel> onlineEPayments = new List<PaymentModel>();
                int historyId = -1;
                result = AutoServiceManager.InsertWindowsServiceHistoryRecord(WebServiceActions.CheckOnlineEPayment);
                if (result == GlobalErrors.Success)
                {
                    result = AutoServiceManager.GetWindowsServiceHistoryId(ref historyId);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _paymentService.GetOnlineEPaymentsList(onlineEPayments);
                }
                if (result == GlobalErrors.Success && onlineEPayments != null && onlineEPayments.Count > 0)
                {
                    ConfigurationManager _configurationManager = new ConfigurationManager(null);

                    dynamic OnlineEPaymentExpiryDateLimit = 0;
                    result = _configurationManager.GetConfigurationValueFromDB("OnlineEPaymentExpiryDateLimit", ref OnlineEPaymentExpiryDateLimit);

                    dynamic paymentGateWay = "";
                    result = _configurationManager.GetConfigurationValueFromDB("PaymentGateway", ref paymentGateWay);

                    if(string.IsNullOrEmpty(OnlineEPaymentExpiryDateLimit) || string.IsNullOrEmpty(paymentGateWay))
                    {
                        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Missing Configuration Values", null, "", 0);
                    }

                    List<string> checkedPayments = new List<string>();
                    string PaymentGateWayPassword = string.Empty;

                    foreach (PaymentModel payment in onlineEPayments)
                    {
                        if (checkedPayments.Contains(payment.ThirdPartyTransactionId.ToString()))
                        {
                            continue;
                        }
                        var config = ConfigurationManager.GetConfigurationOnOrganization("PaymentGateWayPassword", payment.OrganizationId);
                        if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                        {
                            PaymentGateWayPassword = config.KeyValue.Trim().ToString();
                        }
                        if (string.IsNullOrEmpty(PaymentGateWayPassword))
                        {
                            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Missing Configuration Value : PaymentGateWayPassword, For Organization " + payment.OrganizationId, null, "", 0);
                            continue;
                        }



                        var options = new RestClientOptions(paymentGateWay)
                        {
                            MaxTimeout = 30000,
                        };
                        var client = new RestClient(options);
                        var request = new RestRequest("/v2/invoices/" + payment.ThirdPartyTransactionId.ToString(), Method.Get);
                        request.AddHeader("Authorization", PaymentGateWayPassword);
                        RestResponse response = client.Execute(request);

                        if (LocalUtilities.PrintEPaymentInErrorLogger != null
                            && !string.IsNullOrEmpty(LocalUtilities.PrintEPaymentInErrorLogger)
                            && LocalUtilities.PrintEPaymentInErrorLogger.ToLower().Equals("true"))
                        {
                            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, response.Content.ToString(), new Exception(), "", 0);
                        }

                        OnlineEPaymentResponseModel responseModel = new OnlineEPaymentResponseModel();
                        responseModel.ResponseCode = response.StatusCode.GetHashCode();
                        responseModel.ResponseDescription = response.StatusDescription == null ? "" : (string)response.StatusDescription;
                        responseModel.ResponseContent = response.Content;
                        responseModel.UUID = payment.UUID;

                        if (_paymentService.SaveOnlineEPaymentResponseForUpdateStatus(responseModel.ResponseDescription, payment.ThirdPartyTransactionId.ToString(), responseModel.ResponseCode.ToString(), payment, response.Content, null) != GlobalErrors.Success)
                        {
                            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Failed to save Online e-payment respone" + "PaymentID => [ " + payment.CustomerPaymentId + " ] UUID => [ " + payment.UUID + " ]" + "Response content => [ " + response.Content + " ]", null, "", 0);
                            continue;
                        }
                        if (response.StatusCode == System.Net.HttpStatusCode.OK)
                        {
                            JObject jObject = JObject.Parse(response.Content);
                            string epaymentStatus = jObject["status"] == null ? "" : (string)jObject["status"];

                            if (epaymentStatus.ToLower() == "paid" || epaymentStatus.ToLower() == "captured")
                            {
                                JToken transactions = jObject["transactions"];
                                if (transactions != null && transactions.ToList().Count > 0)
                                {
                                    if (transactions.ToList().Any(transaction => (transaction["status"].ToString().ToLower() == "paid" || transaction["status"].ToString().ToLower() == "captured") && transaction["transaction"] != null))
                                    {
                                        string receiptId = transactions.ToList().First(transaction => (transaction["status"].ToString().ToLower() == "paid" || transaction["status"].ToString().ToLower() == "captured") && transaction["receipt"] != null && transaction["receipt"]["id"] != null && !string.IsNullOrEmpty(transaction["receipt"]["id"].ToString()))["receipt"]["id"].ToString();
                                        if (!string.IsNullOrEmpty(receiptId))
                                        {
                                            payment.ReceiptId = receiptId;
                                        }
                                        if (transactions.ToList().Any(transaction => (transaction["status"].ToString().ToLower() == "paid" || transaction["status"].ToString().ToLower() == "captured") && transaction["transaction"] != null && transaction["transaction"]["authorization_id"] != null && !string.IsNullOrEmpty(transaction["transaction"]["authorization_id"].ToString())))
                                        {
                                            string approvalCode = transactions.ToList().First(transaction => (transaction["status"].ToString().ToLower() == "paid" || transaction["status"].ToString().ToLower() == "captured") &&  transaction["transaction"] != null && transaction["transaction"]["authorization_id"] != null && !string.IsNullOrEmpty(transaction["transaction"]["authorization_id"].ToString()))["transaction"]["authorization_id"].ToString();
                                            if (!string.IsNullOrEmpty(approvalCode))
                                            {
                                                result = _paymentService.PostOnlineEpayment(payment, approvalCode);
                                            }
                                        }
                                        else
                                        {
                                            if (transactions.ToList().Any(transaction => (transaction["status"].ToString().ToLower() == "paid" || transaction["status"].ToString().ToLower() == "captured") && transaction["transaction"] != null && (transaction["transaction"]["authorization_id"] == null || string.IsNullOrEmpty(transaction["transaction"]["authorization_id"].ToString()))))
                                            {
                                                string chg_id  = transactions.ToList().First(transaction => (transaction["status"].ToString().ToLower() == "paid" || transaction["status"].ToString().ToLower() == "captured") && transaction["transaction"] != null && (transaction["transaction"]["authorization_id"] == null || string.IsNullOrEmpty(transaction["transaction"]["authorization_id"].ToString())))["id"].ToString();
                                                if (!string.IsNullOrEmpty(chg_id))
                                                {
                                                    result = CheckOnlineEpaymentFromChargeNo(paymentGateWay, PaymentGateWayPassword, chg_id, payment);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            else if (epaymentStatus.ToLower() == "EXPIRED".ToLower() || epaymentStatus.ToLower() == "CANCELLED".ToLower())
                            {
                                result = _paymentService.VoidOnlineEPayment(payment);
                            }
                        }
                        else if (DateTime.Now > payment.PaymentDate.AddHours(Int16.Parse(OnlineEPaymentExpiryDateLimit)))
                        {
                            result = _paymentService.VoidOnlineEPayment(payment);
                        }

                        checkedPayments.Add(payment.ThirdPartyTransactionId);
                    }
                }
                AutoServiceManager.UpdateWindowsServiceHistory(historyId, result.ToString());
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public GlobalErrors CheckOnlineEpaymentFromChargeNo(string paymentGateWay, string paymentGateWayPassword, string chg_id, PaymentModel payment)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var _paymentService = new PaymentService(null);
                var options = new RestClientOptions(paymentGateWay)
                {
                    MaxTimeout = 30000,
                };
                var client = new RestClient(options);
                var request = new RestRequest("/v2/charges/" + chg_id, Method.Get);
                request.AddHeader("Authorization", paymentGateWayPassword);
                RestResponse response = client.Execute(request);

                OnlineEPaymentResponseModel responseModel = new OnlineEPaymentResponseModel();
                responseModel.ResponseCode = response.StatusCode.GetHashCode();
                responseModel.ResponseDescription = response.StatusDescription == null ? "" : (string)response.StatusDescription;
                responseModel.ResponseContent = response.Content;
                responseModel.UUID = payment.UUID;
                if (_paymentService.SaveOnlineEPaymentResponseForUpdateStatus(responseModel.ResponseDescription, payment.ThirdPartyTransactionId, responseModel.ResponseCode.ToString(), payment, response.Content, chg_id) == GlobalErrors.Success)
                {
                    if (response.StatusCode == System.Net.HttpStatusCode.OK)
                    {
                        JObject jObject = JObject.Parse(response.Content);
                        string epaymentStatus = jObject["status"] == null ? "" : (string)jObject["status"];
                        string approvalCode = string.Empty;
                        string receiptId = string.Empty;
                        if (epaymentStatus.ToLower() == "paid" || epaymentStatus.ToLower() == "captured")
                        {
                            #region[recipt]
                            JToken receipt = jObject["receipt"];
                            if (receipt != null && receipt["id"] != null && !string.IsNullOrEmpty(receipt["id"].ToString()))
                            {
                                receiptId = receipt["id"].ToString();
                                if (!string.IsNullOrEmpty(receiptId))
                                {
                                    payment.ReceiptId = receiptId;
                                }
                            }
                            #endregion

                            #region[auth]
                            JToken transaction = jObject["transaction"];
                            if (transaction != null && transaction["authorization_id"] != null && !string.IsNullOrEmpty(transaction["authorization_id"].ToString()))
                            {
                                approvalCode = transaction["authorization_id"].ToString();
                            }
                            #endregion

                            if (!string.IsNullOrEmpty(approvalCode) || !string.IsNullOrEmpty(payment.ReceiptId))
                            {
                                result = _paymentService.PostOnlineEpayment(payment, approvalCode);

                            }
                            else
                            {
                                result = _paymentService.SaveEPaymentNoAuthResponse(payment.ThirdPartyTransactionId, chg_id);
                                if (result != GlobalErrors.Success)
                                {
                                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Failed to save EPaymentNoAuthResponse for Charge id => [ " + chg_id + " ] UUID => [ " + payment.UUID + " ]" + "InvoiceId => [ " + payment.ThirdPartyTransactionId + " ]", null, "", 0);
                                }
                            }
                        }
                    }
                }
                else
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Failed to save Online e-payment respone for Charge id => [ " + chg_id + " ] " + "PaymentID => [ " + payment.CustomerPaymentId + " ] UUID => [ " + payment.UUID + " ]" + "Response content => [ " + response.Content + " ]", null, "", 0);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private void DoWorkImageInserting(object state)
        {
            _servicesService = new ServicesService(null);

            if (_servicesService.FillSystemImages() != GlobalErrors.Success)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Running Images Background Service Failed", null, "", 0);
            }
            else
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Images Background Service Finished Successfully", null, "", 0);
            }
            _timerInsertImages.Dispose();
        }
        private void SendTransactionsByEmail(object state)
        {
            _sendEmailService.SendTransactionsByEmail(null, true);
        }
        private void SendReportScheduleByEmail(object state)
        {
            if (state is AutoServiceModel autoService)
            {
               _sendEmailService.SendReportScheduleByEmail(autoService);
            }
        }               
        #endregion
    }
}
