﻿using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Linq;
using InCube.Security;

namespace Sonic.Web.Service
{
    public class ConfigurationService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ConfigurationManager _configurationManager;
        private readonly Configurations _configurations;
        LocalUtilities _localUtilities;
        public ConfigurationService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _configurationManager = new ConfigurationManager(requestRepository);
            _configurations = new Configurations(_requestRepository);
            _localUtilities = new LocalUtilities();
        }
        #region [CUSTOM CONFIGURATIONS]
        public  bool GetBooleanValue(string keyName,int employeeId)
        {
            bool result = false;
            try
            {
                var config = _configurations.GetConfigurationValue(keyName,employeeId);

                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    result = bool.Parse(config.KeyValue.Trim());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public  bool GetBooleanValue(string keyName)
        {
            bool result = false;
            try
            {
                var config = GetCustomizedConfigurationValue(keyName);

                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    result = bool.Parse(config.KeyValue.Trim());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public  string GetStringValue(string keyName)
        {
            string result = string.Empty;
            try
            {
                var config = GetCustomizedConfigurationValue(keyName);
                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    result = config.KeyValue.Trim();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public  int GetIntegerValue(string keyName)
        {
            int result = 0;
            try
            {
                var config = GetCustomizedConfigurationValue(keyName);
                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    result = int.Parse(config.KeyValue.Trim());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public  GlobalErrors GetAllConfigurations(ref List<ConfigurationModel> allConfigurations)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _configurationManager.GetAllConfigurations(ref allConfigurations);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public  GlobalErrors GetLevelConfigurations(int levelId,string configFilter, ref List<ConfigurationModel> allConfigurations)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _configurationManager.GetLevelConfigurations(levelId, configFilter, ref allConfigurations);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        private  ConfigurationModel GetCustomizedConfigurationValue(string keyName)
        {
            var config = new ConfigurationModel();
            try
            {
               
                if (_localUtilities.CustomLevelConfigurations != null && _localUtilities.CustomLevelConfigurations.Where(c => c.KeyName == keyName).ToList().Count > 0)
                {
                    config = _localUtilities.CustomLevelConfigurations.Find(a => a.KeyName == keyName);
                }
                else if (_localUtilities.SpecificEmployeeConfigurations != null && _localUtilities.SpecificEmployeeConfigurations.Where(c => c.KeyName == keyName).ToList().Count > 0)
                {
                    config = _localUtilities.SpecificEmployeeConfigurations.Find(a => a.KeyName == keyName);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return config;
        }

        public  GlobalErrors SaveLevelConfigurations(List<ConfigurationModel> changedConfigurationsList,ConfigurationLevels configLevel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _configurationManager.SaveLevelConfigurations(changedConfigurationsList, configLevel);
               
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public  GlobalErrors UpdateSystemConfigurations(List<ConfigurationModel> changedConfigurationsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
              result =_configurationManager.UpdateSystemConfigurations(changedConfigurationsList);

            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public  void ReadEmployeeConfigurations(int employeeId)
        {
            try
            {
                _localUtilities.SpecificEmployeeConfigurations = ConfigurationManager.FillSpecificEmployeeConfigurations(employeeId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public  void ReadCustomConfigurations(bool AllowTerritoryCustomerVisit, int routeId, int territoryId)
        {
            try
            {
               _localUtilities.CustomLevelConfigurations = ConfigurationManager.FillCustomConfigurations(AllowTerritoryCustomerVisit , routeId , territoryId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public  void ClearEmployeeConfigurations()
        {
            _localUtilities.SpecificEmployeeConfigurations.Clear();
        }

        public  void ClearCustomConfigurations()
        {
            _localUtilities.CustomLevelConfigurations.Clear();
        }

        #endregion

        public GlobalErrors GetConfigurationValue(string keyName, string encryptedDivisionId, ref string keyValue)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                ConfigurationModel configurationOnGeneralLevel = null;
                int divisionId = -1;
                if (!string.IsNullOrEmpty(encryptedDivisionId.Trim()) && encryptedDivisionId != "-1")
                {
                    // Decrypt divisionId
                    divisionId = int.Parse(EncryptionManager.Instance.DecryptData(encryptedDivisionId.ToString()));
                }
                if (_requestRepository.CurrentOperator == null || string.IsNullOrEmpty(_requestRepository.CurrentOperator.EncryptedEmployeeId.Trim()))
                {
                    keyValue = string.Empty;
                    return GlobalErrors.Error;
                }
                if (_requestRepository.ConfigurationsList == null || _requestRepository.ConfigurationsList.Count == 0)
                {
                    _configurationManager.FillOperatorConfigurations();
                }
                configurationOnGeneralLevel = _requestRepository.ConfigurationsList.Find(c => c.KeyName == keyName);
                if (configurationOnGeneralLevel == null)
                    configurationOnGeneralLevel = new ConfigurationModel();
                if (divisionId == -1
                   // || CoreSession.Instance.ConfigurationsListOnDivisionLevel == null || CoreSession.Instance.ConfigurationsListOnDivisionLevel.Count == 0
                    || configurationOnGeneralLevel.ConfigurationLevelPriority.GetHashCode() < ConfigurationLevelPriority.DivisionLevel.GetHashCode()
                    )
                {
                    keyValue = configurationOnGeneralLevel.KeyValue;
                    return GlobalErrors.Success;
                }
                else
                {
                    //ConfigurationModel divConfiguration = CoreSession.Instance.ConfigurationsListOnDivisionLevel.Find(c => c.KeyName == keyName && c.DivisionId == divisionId);
                    //if (divConfiguration != null)
                    //{
                    //    keyValue = divConfiguration.KeyValue;
                    //    return GlobalErrors.Success;
                    //}
                }
                keyValue = configurationOnGeneralLevel.KeyValue;
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetConfigurationValueFromDB(string configurationName, ref dynamic keyvalue)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                result = _configurationManager.GetConfigurationValueFromDB(configurationName, ref keyvalue);

            }catch(Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
    }
}
