﻿using System;
using System.Collections.Generic;
using System.Text;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;

namespace Sonic.Web.Service
{
    public class CurrencyService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly CurrencyManager _currencyManager;
        public CurrencyService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _currencyManager = new CurrencyManager(_requestRepository);
        }
        public GlobalErrors GetAllCurrencies(int organizationId, ref List<CurrencyModel> currencyList)
        {
            return _currencyManager.GetAllCurrencies(organizationId, ref currencyList);

        }
        public GlobalErrors GetBaseCurrency(ref string baseCurrency)
        {
            return _currencyManager.GetBaseCurrency(ref baseCurrency);
        }
      public int GetBaseCurrencyId()
        {
            return _currencyManager.GetBaseCurrencyId();
        }
    }
}
