﻿using Microsoft.AspNetCore.Http;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.Customer;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Web;
using InCube.Security;
using System.Net.NetworkInformation;
using Sonic.Web.Models;
using static EchoCustomerOutletModel;

namespace Sonic.Web.Service
{
    public class CustomerService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly MasterDataService _masterDataService;
        private readonly CustomerManager _customerManager;
        private readonly AccountManager _accountManager;
        private readonly SettingService _settingService;
        private readonly DocumentSequenceManager _documentSequenceManager;
        private readonly CurrencyService _currencyService;
        private readonly NotificationManager _notificationManager;
        private readonly PromotionService _promotionService;
        private readonly ItemManager _itemManager;

        public CustomerService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _masterDataService = new MasterDataService(requestRepository);
            _customerManager = new CustomerManager(requestRepository);
            _accountManager = new AccountManager(requestRepository);
            _settingService = new SettingService(requestRepository);
            _documentSequenceManager = new DocumentSequenceManager(requestRepository);
            _currencyService = new CurrencyService(requestRepository);
            _notificationManager = new NotificationManager(requestRepository);
            _promotionService = new PromotionService(requestRepository);
            _itemManager = new ItemManager(requestRepository);
        }

        public GlobalErrors DeleteNewCustomerTemplate(int TemplateId)
        {
            return _customerManager.DeleteNewCustomerTemplate(TemplateId);
        }

        public GlobalErrors getAddedDisplayFields(ref List<ComboBoxModel> addedDisplayFields, FieldsObject fields)
        {
            return _customerManager.getAddedDisplayFields(ref addedDisplayFields, fields);
        }
        public GlobalErrors GetAllCustomerGroups(int channelId, int subChannelId, string organizationIds, ref List<CustomerGroupModel> customerGroupObj)
        {
            return _customerManager.GetAllCustomerGroups(channelId, subChannelId, organizationIds, ref customerGroupObj);
        }


        public GlobalErrors ValidateEchoCustomerEmail(string email, ref bool uniqueEmail)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                // 1. Validate Email
                if (!string.IsNullOrEmpty(email))
                {
                    result = _masterDataService.CheckIfUniqueValue(CoreDataBaseConstants.TableNames.CustomerOutlet, CoreDataBaseConstants.QueryColumnsNames.Email, email, string.Empty, ref uniqueEmail);
                }
                else
                {
                    uniqueEmail = true;
                }
                if (!uniqueEmail)
                {
                    return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetAllCustomersList(ref List<CustomerModel> custList)
        {
            try
            {
                SharedTableResult<CustomerModel> custModel = new SharedTableResult<CustomerModel>();
                if (_customerManager.GetCustomerList(null, true, ref custModel) == GlobalErrors.Success)
                {
                    custList = (List<CustomerModel>)custModel.Data;
                    return GlobalErrors.Success;
                }
                else
                {
                    custList = null;
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custList = null;
                return GlobalErrors.Error;
            }
        }

        public static GlobalErrors GetContactConfigurations(ref List<ContactConfiguration> contactConfigurations)
        {
            try
            {
                return CustomerManager.GetContactConfigurations(ref contactConfigurations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerClasses(ref List<CustomerClassModel> customerClassObj)
        {
            return _customerManager.GetCustomerClasses(ref customerClassObj);
        }

        public GlobalErrors GetCustomerData(int customerId, ref CustomerModel customerObj)
        {
            return _customerManager.GetCustomerData(customerId, false, ref customerObj);
        }
        public GlobalErrors GetCustomerData(int customerId, bool showInActive, ref CustomerModel customerObj)
        {
            GlobalErrors result = GlobalErrors.Success;
            result = _customerManager.GetCustomerData(customerId, showInActive, ref customerObj);
            //if (result == GlobalErrors.Success && customerObj.Outlets != null)
            //{
            //    if (!String.IsNullOrEmpty(LocalUtilities.CustomerAttachmentsDummy) && Directory.Exists(LocalUtilities.CustomerAttachmentsDummy))
            //    {
            //        string customersDummyAttachmentFolderPath = Path.Combine(LocalUtilities.CustomerAttachmentsDummy, _requestRepository.SessionId);
            //        if (Directory.Exists(customersDummyAttachmentFolderPath))
            //        Directory.Delete(customersDummyAttachmentFolderPath, true);
            //        Directory.CreateDirectory(customersDummyAttachmentFolderPath);
            //        foreach (CustomerOutletModel outlet in customerObj.Outlets)
            //        {
            //            outlet.OutletAttachments = GetOutletAttachments(ref customerObj, outlet.OutletId.ToString());
            //        }
            //    }
            //}

            return result;
        }
        #region[OutletAttachments]
        private GlobalErrors DeleteCustomerAttachmentFolders(string customerID)
        {
            try
            {
                if (Directory.Exists(LocalUtilities.CustomerAttachmentsDummy + "\\" + _requestRepository.SessionId))
                {
                    Directory.Delete(LocalUtilities.CustomerAttachmentsDummy + "\\" + _requestRepository.SessionId, true);
                }
                if (Directory.Exists(LocalUtilities.CustomerAttachments))
                {
                    Directory.Delete(LocalUtilities.CustomerAttachments + "\\" + customerID, true);
                }
                //if (Directory.Exists(LocalUtilities.CustomerAttachmentsDummy + "\\" + _requestRepository.SessionId))
                //{
                //    var attachmentFolders = Directory.GetDirectories(LocalUtilities.CustomerAttachmentsDummy + "\\" + _requestRepository.SessionId).Where(x => x.Contains(customerID));
                //    if (attachmentFolders != null)
                //    {
                //        foreach (string attachmentFolder in attachmentFolders)
                //        {
                //            if (Directory.Exists(attachmentFolder))
                //            {
                //                Directory.Delete(attachmentFolder, true);

                //            }
                //        }
                //    }
                //}
                //if (Directory.Exists(LocalUtilities.CustomerAttachments))
                //{
                //    var attachmentFolders = Directory.GetDirectories(LocalUtilities.CustomerAttachments).Where(x => x.Contains(customerID));
                //    if (attachmentFolders != null)
                //    {
                //        foreach (string attachmentFolder in attachmentFolders)
                //        {
                //            if (Directory.Exists(attachmentFolder))
                //            {
                //                Directory.Delete(attachmentFolder, true);
                //            }
                //        }
                //    }
                //}
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        private List<string> GetOutletAttachments(ref CustomerModel customerObj, string outletID)
        {
            List<string> attachementNames = new List<string>();
            string dummyCustomerFolderPath = Path.Combine(LocalUtilities.CustomerAttachmentsDummy, _requestRepository.SessionId + "\\" + customerObj.CustomerId.ToString());
            customerObj.CustomerAttachmentsBasePath = dummyCustomerFolderPath.Substring(dummyCustomerFolderPath.IndexOf("wwwroot"));// + "/" + customerObj.CustomerId.ToString();
            customerObj.CustomerAttachmentsBasePath = customerObj.CustomerAttachmentsBasePath.Replace('\\', '/');
            string CustomerFolderPath = Path.Combine(LocalUtilities.CustomerAttachments, customerObj.CustomerId.ToString());
            try
            {
                if (Directory.Exists(CustomerFolderPath))
                {
                    string outletAttachmentFolderPath = CustomerFolderPath + "\\" + outletID;
                    string dummyOutletAttachmentsFolderPath = Path.Combine(dummyCustomerFolderPath, outletID);

                    attachementNames = new List<string>();
                    if (Directory.Exists(outletAttachmentFolderPath))
                    {
                        Directory.CreateDirectory(dummyOutletAttachmentsFolderPath);
                        DirectoryInfo Attachementdir = new DirectoryInfo(outletAttachmentFolderPath);
                        FileInfo[] files = Attachementdir.GetFiles();
                        if (files != null && files.Length > 0)
                        {
                            foreach (FileInfo file in files)
                            {
                                if (!System.IO.File.Exists(Path.Combine(dummyOutletAttachmentsFolderPath, file.Name)))
                                    System.IO.File.Copy(file.FullName, Path.Combine(dummyOutletAttachmentsFolderPath, file.Name));//check if file is not exist else add its name
                                attachementNames.Add(file.Name);
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

            }
            return attachementNames;

        }

        #endregion

        public GlobalErrors GetCustomerSubChannels(GeneralFilter filter, ref List<CustomerSubChannelModel> subChannelsList)
        {
            try
            {
                return _customerManager.GetCustomerSubChannels(filter.CustomerId, filter.OutletId, ref subChannelsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                subChannelsList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerList(OrderListFilter filter, ref SharedTableResult<CustomerModel> custList)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetCustomerList(filter, false, ref custList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateInactiveCustomer(int customerId, bool isActive)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.UpdateInactiveCustomer(customerId, isActive);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors getICashDataInEdit(int icashListID, ref ICashEntryModel data)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                var ICashDetailsModel = new List<ICashDetailsModel>();
                var SimpleCustomerModel = new List<SimpleCustomerModel>();
                var CustomerGroupModel = new List<CustomerGroupModel>();
                var CustomerChannelModel = new List<CustomerChannelModel>();
                var ICashMasterData = new ICashModel();



                result = _customerManager.GetICashMasterData(icashListID, ref ICashMasterData);
                if (result == GlobalErrors.Success)
                    result = _customerManager.GetICashDetailsData(icashListID, ref ICashDetailsModel);
                if (result == GlobalErrors.Success)
                    result = _customerManager.GetICashCustomerChannelData(icashListID, ref CustomerChannelModel);
                if (result == GlobalErrors.Success)
                    result = _customerManager.GetICashCustomerGroupData(icashListID, ref CustomerGroupModel);
                if (result == GlobalErrors.Success)
                    result = _customerManager.GetICashSimpleCustomerData(icashListID, ref SimpleCustomerModel);


                if (result == GlobalErrors.Success)
                {
                    data.ICashCode = ICashMasterData.ICashCode;
                    data.ICashListID = ICashMasterData.ICashListID;
                    data.OrganizationID = ICashMasterData.OrganizationID;
                    data.IsInactive = ICashMasterData.IsInactive;
                    data.StartDate = ICashMasterData.StartDate;
                    data.EndDate = ICashMasterData.EndDate;
                    data.ICashDetailsModel = ICashDetailsModel;
                    data.AppliedCustomers = SimpleCustomerModel;
                    data.AppliedGroups = CustomerGroupModel;
                    data.AppliedChannels = CustomerChannelModel;

                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerOutlets(GeneralFilter filter, ref List<CustomerOutletModel> custOutList)
        {
            try
            {
                return _customerManager.GetCustomerOutlets(filter, ref custOutList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custOutList = null;
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerComment(int customerID, ref List<CustomerComment> CommnetList)
        {
            try
            {
                return _customerManager.GetCustomerCommnet(customerID, ref CommnetList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                CommnetList = null;
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors addCustomerComment(int customerID, String Commnet)
        {
            try
            {
                return _customerManager.addCustomerCommnet(customerID,  Commnet);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerSubClasses(ref List<CustomerSubClassModel> customerSubClassObj)
        {
            return _customerManager.GetCustomerSubClasses(ref customerSubClassObj);
        }
        public GlobalErrors GetCustomerStatus(ref List<CustomerStatusModel> customerStatusObj, int languageId)
        {
            return _customerManager.GetCustomerStatus(ref customerStatusObj, languageId);
        }
        public GlobalErrors GetCustomerTypes(ref List<CustomerTypeModel> customerTypesObj, int languageId)
        {
            return _customerManager.GetCustomerTypes(ref customerTypesObj, languageId);
        }

        public GlobalErrors GetNewCustomerTemplates(ref List<CustomerTemplateModel> customerTemplates, int LanguageId)
        {
            return _customerManager.GetNewCustomerTemplates(ref customerTemplates, LanguageId);
        }



        public GlobalErrors GetDivisionsCredits(ref List<DivisionsCredits> divisionsCredits, int customerTemplateId)
        {
            return _customerManager.GetDivisionsCredits(ref divisionsCredits, customerTemplateId);
        }

        public static DataTable GetNewTemplateCustomerTypes()
        {
            return CustomerManager.GetNewTemplateCustomerTypes();
        }

        public GlobalErrors GetNewTemplateDiscountGroups(ref List<ComboBoxModel> discountGroup)
        {
            return _customerManager.GetNewTemplateDiscountGroups(ref discountGroup);
        }

        public GlobalErrors GetNewTemplatePriceList(ref List<ComboBoxModel> priceList)
        {
            return _customerManager.GetNewTemplatePriceList(ref priceList);
        }

        public GlobalErrors GetNewTemplatePromotionGroups(ref List<ComboBoxModel> promotionGroup)
        {
            return _customerManager.GetNewTemplatePromotionGroups(ref promotionGroup);
        }

        public GlobalErrors GetOutletData(int customerId, int outletId, bool hasPrivilegeOnPaymentTermDivision, bool hasPrivilegeOnOnHoldDivision, ref CustomerOutletModel oultetObj)
        {
            return _customerManager.GetOutletData(customerId, outletId, hasPrivilegeOnPaymentTermDivision, hasPrivilegeOnOnHoldDivision, ref oultetObj);
        }


        public GlobalErrors IsValidToDeleteCustomer(int customerId, ref CustomerModel customerObj, ref List<string> tables)
        {
            try
            {
                CustomerOutletModel outletObj = null;
                return _customerManager.IsValidToDeleteCustomer(customerId, -1, ref customerObj, ref outletObj, ref tables);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors IsValidToDeleteCustomerOutlet(int customerId, int outletId, ref CustomerOutletModel outletObj, ref List<string> tables)
        {
            try
            {
                CustomerModel customerobj = null;
                return _customerManager.IsValidToDeleteCustomer(customerId, outletId, ref customerobj, ref outletObj, ref tables);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetInformationHistory(CustomerFilter filter, ref List<FieldHistory> history)
        {
            try
            {
                return _customerManager.GetCustomerInfoHistory(filter, ref history);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors DeleteCustomer(int customerId)
        {
            try
            {
                return _customerManager.DeleteCustomer(customerId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteICashData(int icashListID)
        {
            try
            {
                return _customerManager.DeleteICash(icashListID);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetAddressHistory(CustomerFilter filter, ref List<AddressHistory> history)
        {
            try
            {
                return _customerManager.GetAddressHistory(filter, ref history);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetOutletList(CustomerFilter filter, ref SharedTableResult<CustomerOutletModel> custList)
        {
            try
            {
                //_requestRepository.LanguageId = 2;
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 20;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetOutletsList(filter, ref custList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                custList = null;
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetPaymentTerms(ref List<PaymentTermModel> paymentTermObj)
        {
            return _customerManager.GetPaymentTerms(ref paymentTermObj);
        }

        public GlobalErrors GetPaymentTermTypes(ref List<PaymentTermTypeModel> paymentTermObj)
        {
            return _customerManager.GetPaymentTermTypes(ref paymentTermObj);
        }

        public GlobalErrors GetPeriodTypes(ref List<PeriodTypeModel> periodTypeObj)
        {
            return _customerManager.GetPeriodTypes(ref periodTypeObj);
        }

        public GlobalErrors ValidateCustomerToSave(CustomerModel customerObj, ref bool isValid, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool isValidPassword = false;
            errorMessage = string.Empty;
            bool isValueUnique = true;
            isValid = true;
            try
            {
                string excludedString = string.Empty;

                // Validate Code
                if (!customerObj.IsNewCustomer)
                {
                    excludedString = string.Format(" And Customer.CustomerId Not In ({0})",
                    customerObj.CustomerId);
                }
                result = _masterDataService.CheckIfUniqueValue("Customer", "CustomerCode", customerObj.CustomerCode, excludedString, ref isValueUnique);
                if (result != GlobalErrors.Success || !isValueUnique)
                {
                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Unique_Code, _requestRepository.LanguageId);
                    isValid = false;
                    return result;
                }
                // Validate Email
                if (result == GlobalErrors.Success && isValueUnique)
                {
                    result = _masterDataService.CheckIfUniqueValue("Customer", "Email", customerObj.Email, excludedString, ref isValueUnique);
                    if (result != GlobalErrors.Success || !isValueUnique)
                    {
                        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Email_Must_Be_Unique, _requestRepository.LanguageId);
                        isValid = false;
                        return result;
                    }
                }

                // Validate Email
                if (result == GlobalErrors.Success && isValueUnique)
                {
                    result = _masterDataService.CheckIfUniqueValue("Customer", "Phone", customerObj.Phone, excludedString, ref isValueUnique);
                    if (result != GlobalErrors.Success || !isValueUnique)
                    {
                        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Phone_Must_Be_Unique, _requestRepository.LanguageId);
                        isValid = false;
                        return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetMustSellItemsSharedTable(GeneralFilter filter, ref SharedTableResult<MustSellItemSharedTable> mustSellItemsList)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetMustSellItemsSharedTable(filter, ref mustSellItemsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                mustSellItemsList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors InsertMustSellItems(MustSellItem mustSellItems)
        {
            return _customerManager.InsertMustSellItems(mustSellItems);
        }
        public GlobalErrors DeletetMustSellItems(List<MustSellItemSharedTable> mustSellItemSharedTable)
        {
            return _customerManager.DeletetMustSellItems(mustSellItemSharedTable);
        }
        public GlobalErrors GettMustSellItems(MustSellItemSharedTable mustSellItemSharedTable, ref MustSellItem mustSellItem)
        {
            return _customerManager.GettMustSellItems(mustSellItemSharedTable,ref mustSellItem);
        }
        public GlobalErrors InsertNewCustomer(CustomerModel customerObj, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.Success;
            result = _customerManager.InsertNewCustomer(customerObj, ref errorMessage);


            return result;
        }
        public GlobalErrors InsertOrUpdateICashData(ICashEntryModel icashObj)
        {
            if (icashObj.ICashListID <= 0)
            {
                return _customerManager.InsertICashCustomer(icashObj);
            }
            else
            {
                return _customerManager.UpdateICashCustomer(icashObj);
            }
        }

        public GlobalErrors InsertNewCustomerClass(CustomerClassModel customerClass)
        {
            return _customerManager.InsertNewCustomerClass(customerClass);
        }

        public GlobalErrors InsertNewCustomerGroup(ref CustomerGroupModel groupObj)
        {
            return _customerManager.InsertNewCustomerGroup(ref groupObj);
        }

        public GlobalErrors InsertNewCustomerOutlet(CustomerOutletModel outletObj)
        {
            return _customerManager.InsertNewCustomerOutlet(outletObj, null);
        }

        public GlobalErrors InsertNewCustomerSubClass(CustomerSubClassModel customerSubClass)
        {
            return _customerManager.InsertNewCustomerSubClass(customerSubClass);
        }
        public GlobalErrors InsertNewPaymentTerm(PaymentTermModel paymentTermObj)
        {
            return _customerManager.InsertNewPaymentTerm(paymentTermObj);
        }
        public GlobalErrors UpdateCustomer(CustomerModel customerObj, ref string errorMessage)
        {
            return _customerManager.UpdateCustomer(customerObj, ref errorMessage);
        }
        public GlobalErrors InsertNewCustomerData(CustomerOutletModel customeObj)
        {
            return _customerManager.InsertNewCustomerData(customeObj);
        }
        public GlobalErrors UpdateCustomerGroup(CustomerGroupModel groupObj)
        {
            return _customerManager.UpdateCustomerGroup(groupObj);
        }

        //public GlobalErrors UpdateOutletActiveStatus(int outletId,bool isActive)
        //{
        //    return _customerManager.UpdateOutletActiveStatus(outletId, isActive);
        //}

        public GlobalErrors UpdateCustomerOutlet(CustomerOutletModel outletObj)
        {
            return _customerManager.UpdateCustomerOutlet(outletObj, null);
        }

        public GlobalErrors EditOutletFromCRM(CustomerOutletModel oldData, CustomerOutletModel newData)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                // Update Customer outlet table
                result = _customerManager.UpdateCustomerOutletFromCRM(newData, dBHelper);
                if (result != GlobalErrors.Success)
                {
                    return result;
                }

                // Update Customer outlet Extra info
                if (newData.AreaId != "")
                {
                    result = _customerManager.UpdateOutletArea(newData, dBHelper);
                }

                // Update Customer Languages
                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage textLanguage in newData.CustomerLanguages)
                    {
                        if (string.IsNullOrEmpty(textLanguage.Description))
                        {
                            textLanguage.Description = newData.CustomerName;
                        }
                        result = _customerManager.UpdateCustomerLanguage(newData.CustomerId, textLanguage.LanguageId, textLanguage.Description, dBHelper);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }

                }
                // Update New Customer
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.UpdateIsNewCustomer(newData.CustomerId, newData.IsNewCustomer);
                }
                // update CustomerOutlet Langugaes
                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage textLanguage in newData.OutletLanguages)
                    {
                        if (string.IsNullOrEmpty(textLanguage.Description))
                        {
                            textLanguage.Description = newData.OutletName;
                        }
                        result = _customerManager.UpdateOutletLanguage(newData.CustomerId, newData.OutletId, textLanguage.LanguageId, textLanguage.Description, dBHelper);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }

                // Update Customer Address 
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.UpdateOutletAddress(newData, dBHelper);
                }

                // Delete Old outlet contacts
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.DeleteOutletContact(newData.CustomerId, newData.OutletId, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.DeleteOutletContactLanguage(newData.CustomerId, newData.OutletId, dBHelper);
                }
                //Save Customer Contact List
                if (result == GlobalErrors.Success)
                {
                    foreach (CustomerContact contact in newData.OutletContacts)
                    {
                        contact.CustomerId = newData.CustomerId;
                        contact.OutletId = newData.OutletId;

                        result = _customerManager.SaveOutletContacts(contact, dBHelper);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        if (result == GlobalErrors.Success)
                        {
                            result = _customerManager.SaveOutletContactsLanguage(contact, _requestRepository.LanguageId, contact.ContactName, dBHelper);
                            if (result != GlobalErrors.Success) break;
                        }
                    }
                }
                // add customer to the employee routes 
                if (result == GlobalErrors.Success && !_requestRepository.Configurations.HideSalesPersonInfoInCRM
                    && (newData.EmployeeId != oldData.EmployeeId || newData.AreaId != oldData.AreaId || newData.CityId != oldData.CityId))
                {
                    // Delete Customer from Old Employee Routes
                    result = _customerManager.DeleteCustomerFromEmployeeRoutes(oldData, dBHelper);

                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = _customerManager.InsertCustomerIntoEmployeeRoutes(newData, dBHelper);

                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.AllowTerritoryCustomerVisit)
                    {
                        // Delete Customer from Old Employee Territory
                        result = _customerManager.DeleteCustomerFromEmployeeTerritory(oldData, dBHelper);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = _customerManager.InsertCustomerIntoEmployeeTerritory(newData, dBHelper);

                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;
                    }
                }

                // Check for changes history
                if (result == GlobalErrors.Success)
                {
                    result = CheckForChangesHistory(newData, oldData, dBHelper);
                }

                //Check For Address history
                if (result == GlobalErrors.Success)
                {
                    result = CheckForAddressChangeHistory(newData, oldData, dBHelper);
                }


                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
        }
        private GlobalErrors SaveTemplateDetails(List<int> list, List<int> customerTemplateList, List<int> mandatoryFields, int nTemplateID, bool isEditMode, DBHelper<int> dBHelper, int type = -1)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            for (int nCounter = 0; nCounter < list.Count; nCounter++)
            {
                int nFieldID = list[nCounter];
                bool bisMandatory = false;
                bool isVisable = false;

                if (customerTemplateList != null && customerTemplateList.Contains(nFieldID))
                    isVisable = true;
                else
                    isVisable = false;

                if (isVisable && mandatoryFields != null && mandatoryFields.Contains(nFieldID))
                    bisMandatory = true;
                else
                    bisMandatory = false;
                if (isEditMode)
                {
                    result = _customerManager.UpdateNewCustomerTemplateFields(nTemplateID, nFieldID, bisMandatory, isVisable, dBHelper, type);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = _customerManager.AddNewCustomerTemplateFields(nTemplateID, nFieldID, bisMandatory, isVisable, dBHelper, type);
                    }
                }
                else
                    result = _customerManager.AddNewCustomerTemplateFields(nTemplateID, nFieldID, bisMandatory, isVisable, dBHelper,type);
                if (result != GlobalErrors.Success)
                {
                    break;
                }
            }
            return result;
        }
        public GlobalErrors AddEditNewCustomerTemplate(bool isEditMode, CustomerTemplateModel customerTemplate)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            bool isRouteUploaded = false;
            bool isNewCustomerNotApprove = false;
            bool isNew = false;
            try
            {
                List<int> DetailsList = new List<int>(new int[] { 3, 4, 5, 6, 7, 8, 14, 49 });
                List<int> AddressList = new List<int>(new int[] { 31, 32, 33, 34, 35, 36, 37, 38, 39, 10, 47 });
                List<int> DisplayList = new List<int>(new int[] { 22, 23, 24, 25, 26, 27, 28, 29, 30 });
                List<int> GeneralList = new List<int>(new int[] { 1, 9, 11, 12, 13, 15, 16, 17, 18, 19, 20, 40, 41, 42, 48 });
                int MaxTemplateID = -1;
                dBHelper.BeginTransaction();
                // Fill NewCustomerTemplate
                if (isEditMode)
                {
                    result = _customerManager.CheckIfAnyNewCustomerOnCustTemplate(customerTemplate.NewCustomerTemplateId, ref isNewCustomerNotApprove);
                    if(result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    if(result == GlobalErrors.Success)
                    {
                        if(isNewCustomerNotApprove)
                        {
                            isNew = true;
                            result = _customerManager.SetCustomerTemplateAsDeleted(customerTemplate.NewCustomerTemplateId, dBHelper);
                            if (result == GlobalErrors.Success)
                            {
                                customerTemplate.OldCustomerTemplateID = customerTemplate.NewCustomerTemplateId;
                                customerTemplate.NewCustomerTemplateId = -1;
                            }
                        }
                        else
                        {
                            isNew = false;
                            MaxTemplateID = customerTemplate.NewCustomerTemplateId;
                            result = _customerManager.UpdateNewCustomerTemplate(customerTemplate, dBHelper);
                        }
                    }
                }
                else
                {
                    isNew = true;
                }
                if (isNew || !isEditMode)
                {
                    MaxTemplateID = CustomerManager.GetMaxNewCustomerTemplateID(dBHelper);
                    customerTemplate.NewCustomerTemplateId = MaxTemplateID;
                    result = _customerManager.AddNewCustomerTemplate(customerTemplate, MaxTemplateID, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    // fill NewCustTempDiv
                    if (result == GlobalErrors.Success)
                    {
                        result = SaveTemplateDetails(GeneralList, customerTemplate.GeneralFields, customerTemplate.GeneralMandatoryFields, MaxTemplateID, !isNew, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = SaveTemplateDetails(AddressList, customerTemplate.AddressFields, customerTemplate.AddressMandatoryFields, MaxTemplateID, !isNew, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = SaveTemplateDetails(DisplayList, customerTemplate.DisplayFields, customerTemplate.DisplayMandatoryFields, MaxTemplateID, !isNew, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = SaveTemplateDetails(DetailsList, customerTemplate.DetailsFields, customerTemplate.DetailsMandatoryFields, MaxTemplateID, !isNew, dBHelper);
                    }
                    if (result == GlobalErrors.Success && customerTemplate.ImagesFields != null && customerTemplate.ImagesFields.Count > 0)
                    {
                        int type = 5;
                        result = SaveTemplateDetails(customerTemplate.AllImagesFields, customerTemplate.ImagesFields, customerTemplate.ImagesMandatoryFields, MaxTemplateID, !isNew, dBHelper, type);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        // Save Tabs
                        if (!isNew)
                        {
                            result = _customerManager.UpdateNewCustomerTemplateFields(MaxTemplateID, 43, customerTemplate.DetailsFields != null && customerTemplate.GeneralFields.Count > 0, customerTemplate.GeneralFields != null && customerTemplate.GeneralFields.Count > 0, dBHelper);
                            if (result == GlobalErrors.Success)
                                result = _customerManager.UpdateNewCustomerTemplateFields(MaxTemplateID, 44, customerTemplate.DetailsFields != null && customerTemplate.DetailsFields.Count > 0, customerTemplate.DetailsFields != null && customerTemplate.DetailsFields.Count > 0, dBHelper);
                            if (result == GlobalErrors.Success)
                                result = _customerManager.UpdateNewCustomerTemplateFields(MaxTemplateID, 46, customerTemplate.AddressFields != null && customerTemplate.AddressFields.Count > 0, customerTemplate.AddressFields != null && customerTemplate.AddressFields.Count > 0, dBHelper);
                            if (result == GlobalErrors.Success)
                                result = _customerManager.UpdateNewCustomerTemplateFields(MaxTemplateID, 21, customerTemplate.DisplayFields != null && customerTemplate.DisplayFields.Count > 0, customerTemplate.DisplayFields != null && customerTemplate.DisplayFields.Count > 0, dBHelper);
                        }
                        else
                        {
                            result = _customerManager.AddNewCustomerTemplateFields(MaxTemplateID, 43, customerTemplate.DetailsFields != null && customerTemplate.GeneralFields.Count > 0, customerTemplate.GeneralFields != null && customerTemplate.GeneralFields.Count > 0, dBHelper);
                            if (result == GlobalErrors.Success)
                                result = _customerManager.AddNewCustomerTemplateFields(MaxTemplateID, 44, customerTemplate.DetailsFields != null && customerTemplate.DetailsFields.Count > 0, customerTemplate.DetailsFields != null && customerTemplate.DetailsFields.Count > 0, dBHelper);
                            if (result == GlobalErrors.Success)
                                result = _customerManager.AddNewCustomerTemplateFields(MaxTemplateID, 46, customerTemplate.AddressFields != null && customerTemplate.AddressFields.Count > 0, customerTemplate.AddressFields != null && customerTemplate.AddressFields.Count > 0, dBHelper);
                            if (result == GlobalErrors.Success)
                                result = _customerManager.AddNewCustomerTemplateFields(MaxTemplateID, 21, customerTemplate.DisplayFields != null && customerTemplate.DisplayFields.Count > 0, customerTemplate.DisplayFields != null && customerTemplate.DisplayFields.Count > 0, dBHelper);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors SaveNewOutletForCRM(ICollection<IFormFile> files, CustomerOutletModel outlet)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            var account = new AccountModel();
            var oldOutlet = new CustomerOutletModel();
            try
            {
                outlet.CustomerId = CustomerManager.GetMaxID(CoreDataBaseConstants.TableNames.Customer, CoreDataBaseConstants.QueryColumnsNames.CustomerID);
                if (outlet.CustomerId == -1) return GlobalErrors.Error;

                outlet.OutletId = 1;

                outlet.CustomerCode = _documentSequenceManager.GetMaxDocumentSequence(_requestRepository.CurrentOperator.EmployeeId, DocumentTypes.NewCustomerCode, -1);
                if (string.IsNullOrEmpty(outlet.CustomerCode)) return GlobalErrors.Error;

                int accountId = CustomerManager.GetMaxID(CoreDataBaseConstants.TableNames.Account, CoreDataBaseConstants.QueryColumnsNames.AccountID);
                if (accountId == -1) return GlobalErrors.Error;

                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                outlet.CurrencyId = _currencyService.GetBaseCurrencyId();
                // Insert Into Customer table
                result = _customerManager.InsertNewCustomerForCRM(outlet, dBHelper);


                // Insert into  Customer Languages
                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage textLanguage in outlet.CustomerLanguages)
                    {
                        if (string.IsNullOrEmpty(textLanguage.Description))
                        {
                            textLanguage.Description = outlet.CustomerName;
                        }
                        result = CustomerManager.InsertIntoCustomerLanguage(outlet.CustomerId, textLanguage.LanguageId, textLanguage.Description, dBHelper);
                    }
                }

                // Insert Into CustomerOutlet table
                if (result == GlobalErrors.Success)
                {
                    outlet.OrganizationId = _requestRepository.CurrentOperator.OrganizationId;
                    result = _customerManager.InsertNewOutletForCRM(outlet, dBHelper);
                }

                // Insert into CustomerOutlet Langugaes
                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage textLanguage in outlet.OutletLanguages)
                    {
                        if (string.IsNullOrEmpty(textLanguage.Description))
                        {
                            textLanguage.Description = outlet.OutletName;
                        }
                        result = _customerManager.InsertIntoOutletLanguage(outlet, textLanguage.LanguageId, textLanguage.Description, dBHelper);
                    }
                }

                // Insert into Extra info 
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.InsertIntoExtraInfo(outlet, dBHelper);
                }


                // Create Customer Account
                if (result == GlobalErrors.Success)
                {
                    account.AccountId = accountId;
                    account.AccountTypeId = 1;
                    account.CurrencyId = outlet.CurrencyId;
                    account.Balance = 0;
                    account.CreditLimit = 0;
                    account.OrganizationId = _requestRepository.CurrentOperator.OrganizationId;

                    result = _accountManager.CreateNewAccount(account, dBHelper);

                    if (result == GlobalErrors.Success)
                    {
                        result = _accountManager.CreateCustomerAccount(account.AccountId, outlet.CustomerId, dBHelper);
                    }
                }

                // Create Outlet Account
                if (result == GlobalErrors.Success)
                {
                    account = new AccountModel();
                    account.ParentAccountId = accountId; // customer account 
                    account.AccountId = accountId + 1;
                    account.AccountTypeId = 1;
                    account.CurrencyId = outlet.CurrencyId;
                    account.Balance = 0;
                    account.CreditLimit = 0;
                    account.OrganizationId = _requestRepository.CurrentOperator.OrganizationId;

                    result = _accountManager.CreateNewAccount(account, dBHelper);

                    if (result == GlobalErrors.Success)
                    {
                        result = _accountManager.CreateCustomerOutletAccount(account.AccountId, outlet.CustomerId, outlet.OutletId, dBHelper);
                    }
                }

                // Insert into H&O Group
                if (result == GlobalErrors.Success && !_requestRepository.Configurations.RemoveHomeAndOfficesConceptFromCRM)
                {
                    result = _customerManager.AssignOutletToGroup(outlet.CustomerId, outlet.OutletId, outlet.HHGroupId, dBHelper);
                }


                // Insert Into Discounted Group
                //if (outlet.HHGroupId != outlet.DiscountGroupId)
                {
                    if (result == GlobalErrors.Success && outlet.IsDiscounted && outlet.DiscountPriceListId != -1)
                    {
                        result = _customerManager.AssignOutletToPriceList(outlet.CustomerId, outlet.OutletId, outlet.DiscountPriceListId, dBHelper);
                    }
                }

                //Save Customer Contact List
                if (result == GlobalErrors.Success)
                {
                    foreach (CustomerContact contact in outlet.OutletContacts)
                    {
                        contact.CustomerId = outlet.CustomerId;
                        contact.OutletId = outlet.OutletId;

                        result = _customerManager.SaveOutletContacts(contact, dBHelper);
                        if (result != GlobalErrors.Success) break;
                        if (result == GlobalErrors.Success)
                        {
                            if (result == GlobalErrors.Success)
                            {
                                result = _customerManager.SaveOutletContactsLanguage(contact, _requestRepository.LanguageId, contact.ContactName, dBHelper);
                                if (result != GlobalErrors.Success) break;
                            }
                        }
                    }
                }

                // add customer to the employee routes 
                if (result == GlobalErrors.Success && !_requestRepository.Configurations.HideSalesPersonInfoInCRM)
                {
                    result = _customerManager.InsertCustomerIntoEmployeeRoutes(outlet, dBHelper);

                    if (result == GlobalErrors.Success && _requestRepository.Configurations.AllowTerritoryCustomerVisit)
                    {
                        result = _customerManager.InsertCustomerIntoEmployeeTerritory(outlet, dBHelper);
                    }
                }


                // Check for changes history
                if (result == GlobalErrors.Success)
                {
                    result = CheckForChangesHistory(outlet, oldOutlet, dBHelper);
                }

                //Check For Address history
                if (result == GlobalErrors.Success)
                {
                    result = CheckForAddressChangeHistory(outlet, oldOutlet, dBHelper);
                }

                if (result == GlobalErrors.Success)
                {
                    result = _documentSequenceManager.UpdateMaxTransactionID(dBHelper, DocumentTypes.NewCustomerCode, outlet.CustomerCode, _requestRepository.CurrentOperator.EmployeeId, -1);
                }

                if (result == GlobalErrors.Success && files != null && files.Count > 0)
                {
                    _settingService.SaveCustomerAttachments(files, outlet.CustomerCode);
                }

                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors UpdateCustomerOutletExtraInfo(CustomerOutletModel outlet)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                result = _customerManager.UpdateCustomerOutletExtraInfo(outlet, dBHelper);
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        private GlobalErrors CheckForAddressChangeHistory(CustomerOutletModel newData, CustomerOutletModel oldData, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.Success;
            try
            {
                var customerId = newData.CustomerId;
                var outleId = newData.OutletId;

                if (newData.CityId != oldData.CityId
                    || newData.AreaId != oldData.AreaId
                    || !newData.Address.Equals(oldData.Address ?? string.Empty)
                    || !newData.Address2.Equals(oldData.Address2 ?? string.Empty))
                {
                    result = _customerManager.InsertIntoOutletAddressHistory(customerId, outleId, newData.CityName, newData.AreaName, newData.Address, newData.Address2, dbHelper);
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetNationalities(ref List<Nationality> nationalities)
        {
            try
            {
                return _customerManager.GetNationalities(ref nationalities);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors GetHomeAndOffice(ref List<CustomerGroupModel> hhGroups)
        {
            try
            {
                return _customerManager.GetHomeAndOfficeSubChannel(ref hhGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetDiscountedGoupCRM(ref List<CustomerGroupModel> groups)
        {
            try
            {
                return _customerManager.GetDiscountedGroupsCRM(ref groups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetDiscountedPriceListsCRM(ref List<priceListModel> priceLists)
        {
            try
            {
                return _customerManager.GetDiscountedPriceListsCRM(ref priceLists);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors getGeneralFields(ref List<ComboBoxModel> generalFields)
        {
            return _customerManager.getGeneralFields(ref generalFields);
        }

        //public static GlobalErrors getAddedFields(ref List<ComboBoxModel> generalAddedFields, FieldsObject fields)
        //{
        //    return CustomerManager.getAddedFields(ref generalAddedFields, fields);
        //}
        public GlobalErrors getAddedFields(ref List<ComboBoxModel> AddedFields, int type, FieldsObject fields)
        {
            return _customerManager.getAddedFields(ref AddedFields, type, fields);
        }

        public GlobalErrors GetGroups(ref List<ComboBoxModel> defaultGroup)
        {
            return _customerManager.GetGroups(ref defaultGroup);
        }

        public static bool getFieldVisablity(int fieldId, int templateId)
        {
            return CustomerManager.getFieldVisablity(fieldId, templateId);
        }
        public GlobalErrors getAddedMandatoryFields(ref List<ComboBoxModel> AddedMandatoryFields, int type, FieldsObject fields)
        {
            return _customerManager.getAddedMandatoryFields(ref AddedMandatoryFields, type, fields);
        }
        public GlobalErrors getDetailsFields(ref List<ComboBoxModel> detailsFields, FieldsObject fields)
        {
            return _customerManager.getDetailsFields(ref detailsFields, fields);
        }
        public GlobalErrors getAddressFields(ref List<ComboBoxModel> addressFields, FieldsObject fields)
        {
            return _customerManager.getAddressFields(ref addressFields, fields);
        }
        public GlobalErrors getImagesFields(ref List<ComboBoxModel> imagesFields, FieldsObject fields)
        {
            return _customerManager.getImagesFields(ref imagesFields, fields);
        }
        public GlobalErrors GetCustomerSources(ref List<CustomerSource> sources)
        {
            try
            {
                return _customerManager.GetCustomerSources(ref sources);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        private GlobalErrors CheckForChangesHistory(CustomerOutletModel newData, CustomerOutletModel oldData, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.Success;
            try
            {
                var customerId = newData.CustomerId;
                var outleId = newData.OutletId;


                if (!(newData.Email ?? string.Empty).Trim().Equals((oldData.Email ?? string.Empty).Trim()))
                {
                    result = _customerManager.InsertIntoOutletHistory(customerId, outleId, CoreDataBaseConstants.QueryColumnsNames.Email, oldData.Email, newData.Email, dbHelper);
                    if (result != GlobalErrors.Success) return result;
                }

                if (newData.Inactive != oldData.Inactive)
                {
                    result = _customerManager.InsertIntoOutletHistory(customerId, outleId, CoreDataBaseConstants.QueryColumnsNames.InActive, oldData.Inactive ? "1" : "0", newData.Inactive ? "1" : "0", dbHelper);
                    if (result != GlobalErrors.Success) return result;
                }

                if (!(newData.Address ?? string.Empty).Trim().Equals((oldData.Address ?? string.Empty).Trim()))
                {
                    result = _customerManager.InsertIntoOutletHistory(customerId, outleId, CoreDataBaseConstants.QueryColumnsNames.Address, oldData.Address, newData.Address, dbHelper);
                    if (result != GlobalErrors.Success) return result;
                }

                if (!(newData.Address2 ?? string.Empty).Trim().Equals((oldData.Address2 ?? string.Empty).Trim()))
                {
                    result = _customerManager.InsertIntoOutletHistory(customerId, outleId, CoreDataBaseConstants.QueryColumnsNames.Address2, oldData.Address2, newData.Address2, dbHelper);
                    if (result != GlobalErrors.Success) return result;
                }

                if (newData.AreaId != oldData.AreaId)
                {
                    result = _customerManager.InsertIntoOutletHistory(customerId, outleId, CoreDataBaseConstants.QueryColumnsNames.Landmark, oldData.AreaName, newData.AreaName, dbHelper);
                    if (result != GlobalErrors.Success) return result;
                }

                if (newData.EmployeeId != oldData.EmployeeId)
                {
                    result = _customerManager.InsertIntoOutletHistory(customerId, outleId, CoreDataBaseConstants.QueryColumnsNames.Employee, oldData.EmployeeName, newData.EmployeeName, dbHelper);
                    if (result != GlobalErrors.Success) return result;
                }

                foreach (TextLanguage textLanguage in newData.CustomerLanguages)
                {
                    var oldName = oldData.CustomerLanguages.Where(a => a.LanguageId == textLanguage.LanguageId).SingleOrDefault()?.Description;

                    if (!textLanguage.Description.Trim().Equals((oldName ?? string.Empty).Trim()))
                    {
                        result = _customerManager.InsertIntoOutletHistory(customerId, outleId, CoreDataBaseConstants.QueryColumnsNames.CustomerName, oldName, textLanguage.Description, dbHelper);
                        if (result != GlobalErrors.Success) return result;
                    }
                }

                foreach (TextLanguage textLanguage in newData.OutletLanguages)
                {
                    var oldName = oldData.OutletLanguages.Where(a => a.LanguageId == textLanguage.LanguageId).SingleOrDefault()?.Description;

                    if (!textLanguage.Description.Trim().Equals((oldName ?? string.Empty).Trim()))
                    {
                        result = _customerManager.InsertIntoOutletHistory(customerId, outleId, CoreDataBaseConstants.QueryColumnsNames.OutletName, oldName, textLanguage.Description, dbHelper);
                        if (result != GlobalErrors.Success) return result;
                    }
                }

                // loop over longest list to read all contact id's
                if (newData.OutletContacts.Count >= oldData.OutletContacts.Count)
                {
                    foreach (CustomerContact contact in newData.OutletContacts)
                    {
                        var oldPhone = oldData.OutletContacts.Where(a => a.ContactId == contact.ContactId).SingleOrDefault()?.Number;

                        if (!contact.Number.Trim().Equals((oldPhone ?? string.Empty).Trim()))
                        {
                            result = _customerManager.InsertIntoOutletHistory(customerId, outleId, CoreDataBaseConstants.QueryColumnsNames.Phone, oldPhone, contact.Number, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                }
                else
                {
                    foreach (CustomerContact contact in oldData.OutletContacts)
                    {
                        var newPhone = newData.OutletContacts.Where(a => a.ContactId == contact.ContactId).SingleOrDefault()?.Number;

                        if (!contact.Number.Trim().Equals((newPhone ?? string.Empty).Trim()))
                        {
                            result = _customerManager.InsertIntoOutletHistory(customerId, outleId, CoreDataBaseConstants.QueryColumnsNames.Phone, contact.Number, newPhone, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                        }

                    }
                }


                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CheckIfContactDataExists(CustomerOutletContactModel customerOutletContact, ref string errorMessage)
        {
            try
            {
                return _customerManager.CheckIfContactDataExists(customerOutletContact, ref errorMessage);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors ValidateOutletToSave(CustomerOutletModel outlet, ref bool uniqueCode, ref bool uniqueBarcode, ref bool uniqueMachineSerialNumber, ref bool uniqueMachineIMEINumber, ref bool uniquePhone, ref bool uniqueEmail, ref bool uniqueOperatorName, ref bool isValid)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string excludedString = string.Empty;

                if (outlet.CustomerId != -1)
                {
                    excludedString = string.Format(" And( (CustomerId != {0}) )", outlet.CustomerId);
                }

                // 1. Validate Code
                result = _masterDataService.CheckIfUniqueValue(CoreDataBaseConstants.TableNames.CustomerOutlet, CoreDataBaseConstants.QueryColumnsNames.CustomerCode, outlet.OutletCode, excludedString, ref uniqueCode);
                if (!uniqueCode)
                {
                    isValid = false;
                    return result;
                }

                // 2. Validate Barcode
                if (!string.IsNullOrEmpty(outlet.Barcode))
                {
                    result = _masterDataService.CheckIfUniqueValue(CoreDataBaseConstants.TableNames.CustomerOutlet, CoreDataBaseConstants.QueryColumnsNames.Barcode, outlet.Barcode, excludedString, ref uniqueBarcode);
                }
                else
                {
                    uniqueBarcode = true;
                }
                if (!uniqueBarcode)
                {
                    isValid = false;
                    return result;
                }

                // 3. Validate Phone
                if (!string.IsNullOrEmpty(outlet.Phone) && _requestRepository.Configurations.CheckCustomerUniquenessEntry)
                {
                    result = _masterDataService.CheckIfUniqueValue(CoreDataBaseConstants.TableNames.CustomerOutlet, CoreDataBaseConstants.QueryColumnsNames.Phone, outlet.Phone, excludedString, ref uniquePhone);
                }
                else
                {
                    uniquePhone = true;
                }
                if (!uniquePhone)
                {
                    isValid = false;
                    return result;
                }

                // 4. Validate Email
                if (!string.IsNullOrEmpty(outlet.Email) && _requestRepository.Configurations.CheckCustomerUniquenessEntry)
                {
                    result = _masterDataService.CheckIfUniqueValue(CoreDataBaseConstants.TableNames.CustomerOutlet, CoreDataBaseConstants.QueryColumnsNames.Email, outlet.Email, excludedString, ref uniqueEmail);
                }
                else
                {
                    uniqueEmail = true;
                }
                if (!uniqueEmail)
                {
                    isValid = false;
                    return result;
                }

                // 5. Validate operator name
                if (!string.IsNullOrEmpty(outlet.OperatorName) && !outlet.MatchWithExistsOperator)
                {
                    result = _customerManager.CheckValidOutletOperator(outlet.OperatorName, excludedString, ref uniqueOperatorName);
                    if (!uniqueOperatorName)
                    {
                        isValid = false;
                        return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAllCustomerChannels(ref List<CustomerChannelModel> customerChannelObj, string groupID)
        {
            return _customerManager.GetAllCustomerChannels(ref customerChannelObj, groupID);
        }
        public GlobalErrors GetAllChannels(ref List<CustomerChannelModel> customerChannelList)
        {
            return _customerManager.GetAllChannels(ref customerChannelList);
        }
        public GlobalErrors GetAllSubChannels(int channelId, ref List<CustomerSubChannelModel> subChannelList)
        {
            return _customerManager.GetAllSubChannels(channelId, ref subChannelList);
        }
        public GlobalErrors SaveCustomerCreditRelease(CreditReleaseModel creditReleaseObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                creditReleaseObj.StartDate = new DateTime(creditReleaseObj.StartDateModel.Year, creditReleaseObj.StartDateModel.Month, creditReleaseObj.StartDateModel.Day);
                creditReleaseObj.EndDate = new DateTime(creditReleaseObj.EndDateModel.Year, creditReleaseObj.EndDateModel.Month, creditReleaseObj.EndDateModel.Day);
                if (creditReleaseObj.CreditReleaseId > 0)
                {
                    result = _customerManager.UpdateCustomerCreditRelease(creditReleaseObj);
                }
                else
                {
                    result = _customerManager.SaveCustomerCreditRelease(creditReleaseObj);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCreditReleaseList(GeneralFilter filter, ref SharedTableResult<CreditReleaseModel> creditReleaseList)
        {
            if (filter.CustomListFilter.Page < 0)
                filter.CustomListFilter.Page = 0;
            if (filter.CustomListFilter.PageSize <= 0)
                filter.CustomListFilter.PageSize = 100;
            if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
            {
                filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
            }
            return _customerManager.GetCreditReleaseList(filter, ref creditReleaseList);
        }
        public GlobalErrors GetCreditReleaseData(string id, ref CreditReleaseModel creditReleaseObj)
        {
            return _customerManager.GetCreditReleaseData(id, ref creditReleaseObj);
        }
        public GlobalErrors UpdateCustomerCreditRelease(CreditReleaseModel creditReleaseObj)
        {
            creditReleaseObj.StartDate = new DateTime(creditReleaseObj.StartDateModel.Year, creditReleaseObj.StartDateModel.Month, creditReleaseObj.StartDateModel.Day);
            creditReleaseObj.EndDate = new DateTime(creditReleaseObj.EndDateModel.Year, creditReleaseObj.EndDateModel.Month, creditReleaseObj.EndDateModel.Day);

            return _customerManager.UpdateCustomerCreditRelease(creditReleaseObj);
        }
        public GlobalErrors DeleteCustomerCreditRelease(int creditReleaseId)
        {
            return _customerManager.DeleteCustomerCreditRelease(creditReleaseId);
        }

        public GlobalErrors GetCustomerOutletPrices(int customerId, int outletId, ref string pricesCode)
        {
            return _customerManager.GetCustomerOutletPrices(customerId, outletId, ref pricesCode);
        }
        public GlobalErrors GetCustomerLazyLoading(GeneralFilter filter, ref SharedTableResult<CustomerModel> custList)
        {
            try
            {
                if (filter.CustomListFilter == null)
                {
                    filter.CustomListFilter = new CustomListFilters();
                }
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;

                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }

                return _customerManager.GetCustomerLazyLoading(filter, ref custList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custList = null;
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetOutletsLazyLoading(CustomListFilters filter, ref SharedTableResult<CustomerOutletModel> outList, int groupId, int territoryId, int classId, bool IsWitGetTerritories)
        {
            try
            {
                if (filter.Page < 0)
                    filter.Page = 0;

                if (filter.PageSize <= 0)
                    filter.PageSize = 100;

                if (!string.IsNullOrEmpty(filter.SearchFilter))
                {
                    filter.SearchFilter = filter.SearchFilter.Replace("'", "''");
                }

                return _customerManager.GetOutletsLazyLoading(filter, ref outList, groupId, territoryId, classId, IsWitGetTerritories);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                outList = null;
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CheckContactNumberIsExist(string number, int customerId, int outletId, int countryId, ref bool isExist)
        {
            try
            {
                return _customerManager.CheckContactNumberIsExist(number, customerId, outletId, countryId, ref isExist);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CheckCustomerEmailIsExist(string email, int customerId, int outletId, ref bool isExist)
        {
            try
            {
                return _customerManager.CheckCustomerEmailIsExist(email, customerId, outletId, ref isExist);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors IsCustomerHasUnpaidTransactions(int customerId, int outletId, ref bool isHasUnpaidTransactions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.IsCustomerHasUnpaidTransactions(customerId, outletId, ref isHasUnpaidTransactions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CallInvoiceLocationProcedure(List<CustomerModel> customer)
        {
            try
            {
                return _customerManager.CallInvoiceLocationProcedure(customer);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerGroupsListSharedTable(GeneralFilter filter, ref SharedTableResult<CustomerGroupModel> groupsList)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetCustomerGroupsListSharedTable(filter, ref groupsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                groupsList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetOutletsListSharedTable(CustomerOutletFilter filter, ref SharedTableResult<SimpleCustomerModel> outletsList)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetOutletsListSharedTable(filter, ref outletsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                outletsList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomersListSharedTable(CustomerOutletFilter filter, ref SharedTableResult<SimpleCustomerModel> outletsList)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetCustomersListSharedTable(filter, ref outletsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                outletsList = null;
                return GlobalErrors.Error;
            }
        }
        public static bool IsTaxableOutlet(int customerId, int outletId)
        {
            return CustomerManager.IsTaxableOutlet(customerId, outletId);
        }
        public GlobalErrors GetNewCustomerList(GeneralFilter filter, ref SharedTableResult<CustomerOutletModel> custList)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetNewCustomerList(filter, ref custList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors MatchNewCustomer(CustomerOutletModel outletObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (outletObj.MatchCustomerId != -1)
                {
                    result = _customerManager.MatchNewCustomerWithExistingOne(outletObj);
                }
                else
                {
                    result = _customerManager.SetNewCustomerAsCustomer(outletObj);
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors IsValidToDeleteAccount(int accountId, ref bool isUsed)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.IsValidToDeleteAccount(accountId, ref isUsed);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAllEchoCustomers(ref SharedTableResult<EchoCustomersModel> allEchoCustomers)
        {
            try
            {
                return _customerManager.GetAllEchoCustomers(ref allEchoCustomers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllEchoCustomerChannels(ref List<CustomerChannelModel> customerChannelObj)
        {
            return _customerManager.GetAllEchoCustomerChannels(ref customerChannelObj);
        }
        public GlobalErrors GetAllEchoCustomerGroups(ref List<CustomerGroupModel> customerGroupObj)
        {
            return _customerManager.GetAllEchoCustomerGroups(ref customerGroupObj);
        }
        public GlobalErrors SaveCustomerNotifications(NotificaitonsModel CustomerNotifications)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.SaveCustomerNotifications(ref CustomerNotifications);
                if (result == GlobalErrors.Success)
                {
                    List<CustomerOutletModel> customerTokenList = new List<CustomerOutletModel>();
                    result = _notificationManager.GetCustomerTokenIds(CustomerNotifications, ref customerTokenList);
                    if (result == GlobalErrors.Success && customerTokenList != null && customerTokenList.Count > 0)
                    {
                        foreach (CustomerOutletModel customer in customerTokenList)
                        {
                            int badge = 0;
                            result = _notificationManager.SaveNotificationHistroy(customer.CustomerId, customer.OutletId, CustomerNotifications.NotificationId);
                            if (result == GlobalErrors.Success)
                            {
                                result = _notificationManager.GetBadgeCount(customer.CustomerId, customer.OutletId, ref badge);
                            }

                            FCMNotificationModel fCMNotificationModel = new FCMNotificationModel();
                            fCMNotificationModel.To = customer.Token;
                            fCMNotificationModel.priority = "high";
                            fCMNotificationModel.Message = new MessageModel();
                            fCMNotificationModel.Message.title = CustomerNotifications.Subject;
                            fCMNotificationModel.Message.body = CustomerNotifications.Body;
                            fCMNotificationModel.Message.click_action = "FCM_PLUGIN_ACTIVITY";
                            //fCMNotificationModel.Message.click_action = "FLUTTER_NOTIFICATION_CLICK";
                            fCMNotificationModel.Message.icon = "fcm_push_icon";
                            fCMNotificationModel.Message.badge = badge.ToString();
                            fCMNotificationModel.Message.sound = "default";
                            fCMNotificationModel.data = new NotificaitonDataModel();
                            fCMNotificationModel.data.badge = badge.ToString();
                            fCMNotificationModel.data.orderId = "";
                            fCMNotificationModel.data.employeeId = "";
                            fCMNotificationModel.data.statusId = "";

                            _notificationManager.SendNotificationToCustomer(fCMNotificationModel);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors Check(GeneralFilter filter, ref List<CustomerOutletModel> custOutList)
        {
            try
            {
                return _customerManager.GetCustomerOutlets(filter, ref custOutList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custOutList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerOperatorsList(string outletCode, ref List<CustomerOutletModel> operatorList)
        {
            try
            {
                return _customerManager.GetCustomerOperatorList(outletCode, ref operatorList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorList = null;
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetICashCustomersList(icashFilter filter, ref SharedTableResult<ICashModel> icashSharedList)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetICashCustomersList(filter, ref icashSharedList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                icashSharedList = null;
                return GlobalErrors.Error;
            }
        }
        public bool GetImagesToRootFolder(string targetfile, string sourceFilePath, string key)
        {
            string fileName = string.Empty;
            string fullPath = string.Empty;
            string sourceFile = string.Empty;
            string targetFile = string.Empty;
            int sequenceNo = 0;
            string sourceFolderPath = !string.IsNullOrEmpty(sourceFilePath) ? LocalUtilities.SonicWebPath : LocalUtilities.OutletImagesSourcePath;
            try
            {
                // Use Path class to manipulate file and directory paths.
                sourceFile = Path.Combine(sourceFolderPath, fileName);
                targetFile = Path.Combine(targetfile, fileName);
                // To copy a folder's contents to a new location:
                // Create a new target folder.
                // If the directory already exists, this method does not create a new directory.
                if (!Directory.Exists(targetfile))
                {
                    Directory.CreateDirectory(targetfile);
                }

                if (Directory.Exists(sourceFolderPath))
                {
                    string[] files = new string[] { };
                    if (!string.IsNullOrEmpty(sourceFilePath))
                    {
                        files = Directory.GetFiles(sourceFilePath);
                    }
                    else
                    {
                        files = Directory.GetFiles(sourceFolderPath, key + "*.*");
                    }

                    var isFilesExist = Directory.GetFiles(targetfile, key + "*.*").ToList();
                    if (isFilesExist != null && isFilesExist.Count > 0)
                    {
                        foreach (var file in isFilesExist)
                        {
                            File.Delete(file);
                        }
                    }
                    // Move the files and overwrite destination files if they already exist.
                    foreach (string informationFile in files)
                    {
                        sequenceNo++;
                        // Use static Path methods to extract only the file name from the path.
                        fileName = Path.GetFileName(informationFile);
                        if (!string.IsNullOrEmpty(sourceFilePath))
                        {
                            fileName = key + "_" + sequenceNo + Path.GetExtension(informationFile);
                        }
                        fullPath = Path.GetFullPath(informationFile);
                        targetFile = Path.Combine(targetfile, fileName);
                        sourceFile = Path.Combine(sourceFolderPath, fileName);
                        if (string.IsNullOrEmpty(sourceFilePath))
                        {
                            System.IO.File.Move(sourceFile, targetFile);
                        }
                        else
                        {
                            System.IO.File.Move(fullPath, targetFile);
                        }
                    }
                }
                else
                {
                    return false;
                }

                return true;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        public int GetCustomerType(int customer, int outlet)
        {
            return _customerManager.GetCustomerType(customer, outlet);
        }

        public GlobalErrors GetMaxNotificationId(ref int maxId)
        {
            try
            {
                maxId = CustomerManager.GetMaxID(CoreDataBaseConstants.TableNames.EchoNotifications, CoreDataBaseConstants.QueryColumnsNames.NotificationId, null);
                if(maxId == -1)
                {
                    return GlobalErrors.Error;
                }
                else
                {
                    return GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerCallsHistory(CustomerFilter filter, ref SharedTableResult<CallsHistoryModel> history)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;

                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 20;

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }

                return _customerManager.GetCustomerCallsHistory(filter, ref history);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        #region blackListItem
        public static int GetMaxID(string columnName, string tableName, DBHelper<int> dBHelper)
        {
            try
            {
                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object max = null;
                string query = string.Format(@"select isnull(max({0}),0)+1 from {1} ", columnName, tableName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref max);
                if (result == GlobalErrors.Success && max != null && !string.IsNullOrEmpty(max.ToString()))
                {
                    return int.Parse(max.ToString());
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return 1;
        }
        public GlobalErrors GetBlackListData(int itemBlackListId, ref BlackListItemModel data)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                List<CustomerChannelModel> appliedChannels = new List<CustomerChannelModel>();
                List<CustomerGroupModel> appliedGroups = new List<CustomerGroupModel>();
                List<SimpleCustomerModel> appliedCustomers = new List<SimpleCustomerModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                List<OrganizationModel> orginazations = new List<OrganizationModel>();
                List<ItemBlackListModel> addedItemsList = new List<ItemBlackListModel>();

                result = _customerManager.GetItemsForItemList(itemBlackListId, ref addedItemsList);
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.GetCustomerItemBlackListOrganizations(itemBlackListId, ref orginazations);
                    if (result == GlobalErrors.Success)
                    {
                        result = _customerManager.GetItemBlackListDescriptions(itemBlackListId, ref descriptions);
                        if (result == GlobalErrors.Success)
                        {
                            result = _customerManager.GetItemBlackListAppliedChannels(itemBlackListId, ref appliedChannels);
                            if (result == GlobalErrors.Success)
                                result = _customerManager.GetItemBlackListAppliedGroups(itemBlackListId, ref appliedGroups);
                            if (result == GlobalErrors.Success)
                                result = _customerManager.GetItemBlackListAppliedCustomers(itemBlackListId, ref appliedCustomers);
                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    data.AddedItemsList = addedItemsList;
                    data.AppliedChannels = appliedChannels;
                    data.AppliedCustomers = appliedCustomers;
                    data.AppliedGroups = appliedGroups;
                    data.DescriptionLanguages = descriptions;
                    data.AppliedOrganizations = orginazations;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetItemsBlackLists( GeneralFilter filter, ref List<BlackListItemModel> data)
        {
            try
            {

                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetItemsBlackLists( filter, ref data);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveItemBlackListData(BlackListItemModel itemBlackList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();

                if (itemBlackList.ItemBlackListId < 0)
                {
                    itemBlackList.ItemBlackListId = GetMaxID("ItemBlackListID", "ItemBlackList", dbHelper);
                    if (itemBlackList.ItemBlackListId != -1)
                    {
                        result = _customerManager.InsertNewItemBlackList(itemBlackList, dbHelper);
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }
                }
                else
                {
                    //result = _customerManager.UpdateItemBlackList(itemBlackList, dbHelper);
                    //if (result == GlobalErrors.Success)
                    //{
                    result = _customerManager.DeleteItemBlackListLanguage(itemBlackList.ItemBlackListId, dbHelper);
                    if (result == GlobalErrors.Success)
                        result = _customerManager.DeleteItemBlackListDetails(itemBlackList.ItemBlackListId, dbHelper);
                    if (result == GlobalErrors.Success)
                    {
                        result = _customerManager.DeleteCustomerItemBlackListOrganization(itemBlackList.ItemBlackListId, dbHelper);
                        if (result == GlobalErrors.Success)
                        {
                            result = _customerManager.DeleteCustomerItemBlackListAssignment(itemBlackList.ItemBlackListId, dbHelper);
                        }
                    }
                    //}
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.SaveItemBlackListLanguage(itemBlackList, dbHelper);
                    if (result == GlobalErrors.Success)
                    {
                        result = _customerManager.SaveItemBlackListDetails(itemBlackList, dbHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _customerManager.SaveCustomerItemBlackListOrganization(itemBlackList, dbHelper);
                        if (result != GlobalErrors.Success) return result;
                    }
                    if (result == GlobalErrors.Success)
                    {
                        int itemBlackListCustomerId = 0;

                        itemBlackListCustomerId = GetMaxID("CustomerItemBlackListID", "itemBlackListCustomers", dbHelper);

                        result = _customerManager.InsertItemBlackListCustomer(itemBlackListCustomerId, itemBlackList, dbHelper);
                        //result = GlobalErrors.Success;
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors DeleteItemBlackList(int itemBlackListId)
        {
            try
            {
                return CustomerManager.DeleteItemBlackList(itemBlackListId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        #endregion

        #region[CustomerMapping]
        public GlobalErrors GetCustomerMappingList(CustomerMappingFilter filter, ref List<CustomerOutletModel> customersList)
        {
            try
            {
                return _customerManager.GetCustomerMappingList(filter, ref customersList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetRouteCustomerMappingList(CustomerMappingFilter filter, ref List<CustomerOutletModel> customersList)
        {
            try
            {
                return _customerManager.GetRouteCustomerMappingList(filter, ref customersList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetRouteHistoryMappingList(CustomerMappingFilter filter, ref List<CustomerOutletModel> customersList)
        {
            try
            {
                return _customerManager.GetRouteHistoryMappingList(filter, ref customersList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetTerritoryCustomersMappingList(CustomerMappingFilter filter, ref List<CustomerOutletModel> customersList)
        {
            try
            {
                return _customerManager.GetTerritoryCustomersMappingList(filter, ref customersList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetEmployeeCustomersMappingList(CustomerMappingFilter filter, ref List<CustomerOutletModel> customersList)
        {
            try
            {
                return _customerManager.GetEmployeeCustomersMappingList(filter, ref customersList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerOutletMappingDetails(CustomerMappingFilter filter, ref CustomerOutletModel customersOutletDetailsObject)
        {
            try
            {
                return _customerManager.GetMappingCustomersData(filter, ref customersOutletDetailsObject);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }

        public bool PingHost(bool isChatting)
        {
            string host = string.Empty;
            if (isChatting)
            {
                host = "https://fcm.googleapis.com/fcm/send";
            }
            else
            {
                host = "https://js.api.here.com/v3/3.0/mapsjs-core.js";
            }
            Uri uri = new Uri(host);

            bool result = false;
            Ping p = new Ping();
            try
            {
                PingReply reply = p.Send(uri.Host,5000);

                if (reply.Status == IPStatus.Success)
                    return true;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        #endregion

 

        #region [Price Protection]
        public GlobalErrors GetPriceProtection(PriceProtectionFilterModel filter, ref SharedTableResult<PriceProtectionModel> PriceProtection)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetPriceProtection(filter, ref PriceProtection);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                PriceProtection = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetPriceProtectionData(string RequestID, ref List<PriceProtectionDetailModel> priceProtectionDetail)
        {
            try
            {
                return _customerManager.GetPriceProtectionData(RequestID, ref priceProtectionDetail);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }
        public GlobalErrors UpdatePriceProtection(List<PriceProtectionDetailModel> PricesProtectionList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.UpdatePriceProtection(PricesProtectionList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateStatusForPriceProtection(PriceProtectionModel request, int statusId, ref string message)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.UpdateStatusForPriceProtection(request, statusId, ref message);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region APIs

        public GlobalErrors InsertCustomerFromAPI(CustomersModel customerObj, ref bool isEmailUsed)
        {
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                GlobalErrors result = GlobalErrors.NotInitialized;
                result = _customerManager.InsertCustomerFromAPI(customerObj, ref isEmailUsed, dbHelper);
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerDetailsFromAPI(string SiteCode, ref CustomersModel CustomerDetails)
        {
            return _customerManager.GetCustomerDetailsFromAPI(SiteCode, ref CustomerDetails);
        }

        public GlobalErrors UpdateCustomerDetailsFromAPI(CustomersModel CustomerDetails, ref bool isEmailUsed)
        {
            return _customerManager.UpdateCustomerDetailsFromAPI(CustomerDetails, ref isEmailUsed);
        }

        public GlobalErrors GetCustomertOutletIds(string customerCode, ref CustomerOutletModel oultetObj)
        {
            return CustomerManager.GetCustomerOutletIds(customerCode, ref oultetObj);
        }
        #endregion

        #region Customer Points 
        public GlobalErrors GetAllCustomersPoints(GeneralFilter filter, ref SharedTableResult<CustomerPointsBalanceModel> allCustomerPoints)
        {
            try
            {
                if (filter.CustomListFilter != null && filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter != null && filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 25;
                if (filter.CustomListFilter != null && !string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetAllCustomersPoints(filter, ref allCustomerPoints);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                allCustomerPoints = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateCustomersPoints(CustomerPointsBalanceModel customerPointsObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.UpdateCustomersPoints(customerPointsObj);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        #endregion

        #region [ECHO]

        public GlobalErrors SaveNewCustomerEcho(EchoCustomerModel customerModel, ref CustomerOutletModel outlet, ref string msg)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                bool uniquePhone = false, uniqueOperatorName = false;
                result = ValidateEchoCustomerToSave(customerModel, ref uniquePhone, ref uniqueOperatorName);
                if (result == GlobalErrors.Success)
                {
                    if (!uniquePhone)
                    {
                        msg = "phone-already-exits";
                        return GlobalErrors.NoMoreRows;
                    }
                    if (!uniqueOperatorName)
                    {
                        msg = "username-already-exits";
                        return GlobalErrors.NoMoreRows;
                    }

                    var account = new AccountModel();
                    _requestRepository.CurrentOperator = new OperatorModel();
                    _requestRepository.CurrentOperator.EmployeeId = 0;
                    _requestRepository.CurrentOperator.OperatorId = 0;
                    _requestRepository.CurrentOperator.OrganizationId = 1;

                    outlet = new CustomerOutletModel();
                    outlet.CustomerId = CustomerManager.GetMaxID(CoreDataBaseConstants.TableNames.Customer, CoreDataBaseConstants.QueryColumnsNames.CustomerID);
                    if (outlet.CustomerId == -1) return GlobalErrors.Error;
                    outlet.OutletId = 1;
                    outlet.CustomerCode = _documentSequenceManager.GetMaxDocumentSequence(0, DocumentTypes.NewCustomerCode, -1);
                    if (string.IsNullOrEmpty(outlet.CustomerCode))
                        outlet.CustomerCode = customerModel.Username;
                    int accountId = CustomerManager.GetMaxID(CoreDataBaseConstants.TableNames.Account, CoreDataBaseConstants.QueryColumnsNames.AccountID);
                    if (accountId == -1) return GlobalErrors.Error;
                    outlet.CurrencyId = _currencyService.GetBaseCurrencyId();
                    outlet.OutletId = 1;
                    outlet.Phone = customerModel.PhoneNumber;
                    outlet.CustomerTypeId = CustomerTypes.CashCustomer.GetHashCode();
                    outlet.CreatedDate = DateTime.Now;
                    outlet.GPSLatitude = customerModel.Latitude;
                    outlet.GPSLongitude = customerModel.Longitude;
                    outlet.TradeLicenceNumber = customerModel.TradeLicenseNumber;
                    outlet.IsNewCustomer = true;


                    if (_requestRepository.Configurations.AutoApproveNewCustomer)
                        outlet.IsNewCustomer = false;
                    outlet.Address = customerModel.Address;
                    dBHelper = new DBHelper<int>();
                    dBHelper.BeginTransaction();
                    // INSERT INTO Customer 
                    result = _customerManager.InsertNewOutletForEcho(outlet, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        outlet.OperatorName = customerModel.Username;
                        outlet.OperatorPassword = EncryptionManager.Instance.EncryptPassword(customerModel.Password);
                        result = _customerManager.InsertNewOutletOperator(outlet, dBHelper);
                    }
                    // INSERT INTO Languages
                    if (result == GlobalErrors.Success)
                    {
                        for (int langId = 1; langId <= 2; langId++)
                        {
                            result = CustomerManager.InsertIntoCustomerLanguage(outlet.CustomerId, langId, customerModel.CustomerName, dBHelper);
                            if (result == GlobalErrors.Success)
                            {
                                result = _customerManager.InsertIntoOutletLanguage(outlet, langId, customerModel.CustomerName, dBHelper);
                            }
                            if (result != GlobalErrors.Success)
                            {
                                break;
                            }
                        }
                    }
                    // Create Customer Account
                    if (result == GlobalErrors.Success)
                    {
                        account.AccountId = accountId;
                        account.AccountTypeId = 1;
                        account.CurrencyId = outlet.CurrencyId;
                        account.Balance = 0;
                        account.CreditLimit = 0;
                        account.OrganizationId = _requestRepository.CurrentOperator.OrganizationId;
                        result = _accountManager.CreateNewAccount(account, dBHelper);
                        if (result == GlobalErrors.Success)
                        {
                            result = _accountManager.CreateCustomerAccount(account.AccountId, outlet.CustomerId, dBHelper);
                        }
                    }
                    // Create Outlet Account
                    if (result == GlobalErrors.Success)
                    {
                        account = new AccountModel();
                        account.AccountId = accountId + 1;
                        account.AccountTypeId = 1;
                        account.CurrencyId = outlet.CurrencyId;
                        account.Balance = 0;
                        account.CreditLimit = 0;
                        account.OrganizationId = _requestRepository.CurrentOperator.OrganizationId;
                        result = _accountManager.CreateNewAccount(account, dBHelper);
                        if (result == GlobalErrors.Success)
                        {
                            result = _accountManager.CreateCustomerOutletAccount(account.AccountId, outlet.CustomerId, outlet.OutletId, dBHelper);
                        }
                    }

                    if (result == GlobalErrors.Success)
                    {
                        result = _documentSequenceManager.UpdateMaxTransactionID(dBHelper, DocumentTypes.NewCustomerCode, outlet.CustomerCode, 0, -1);
                    }
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors updateCustomerOrg(int customerId, int outletId, int organizationId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<string> recieversDbHelper = new DBHelper<string>();
            int newStatus = 0;
            try
            {
                result = _customerManager.updateCustomerOrg(customerId, outletId, organizationId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors ValidateEchoCustomerToSave(EchoCustomerModel custModel, ref bool uniquePhone, ref bool uniqueOperatorName)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                // 1. Validate Phone
                if (!string.IsNullOrEmpty(custModel.PhoneNumber))
                {
                    result = _masterDataService.CheckIfUniqueValue(CoreDataBaseConstants.TableNames.CustomerOutlet, CoreDataBaseConstants.QueryColumnsNames.Phone, custModel.PhoneNumber, string.Empty, ref uniquePhone);
                }
                else
                {
                    uniquePhone = true;
                }
                if (!uniquePhone)
                {
                    return result;
                }
                // 2. Validate operator name
                if (!string.IsNullOrEmpty(custModel.Username))
                {
                    result = _customerManager.CheckValidOutletOperator(custModel.Username, string.Empty, ref uniqueOperatorName);
                    if (!uniqueOperatorName)
                    {
                        return result;
                    }
                }
                else
                {
                    uniqueOperatorName = false;
                    return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerSOA(ref List<SOATransactionModel> list)
        {
            return GetCustomerSOA(ref list, false);
        }
        public GlobalErrors GetCustomerSOA(ref List<SOATransactionModel> list, bool orderByDesc)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.GetCustomerSOA(ref list, orderByDesc);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        #endregion [ECHO]


        #region Customer Hierarchy

        public GlobalErrors GetCustomerHierarchyData(ref dynamic customerHierarchyData)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                var channels = new List<CustomerChannelModel>();
                var subChannels = new List<CustomerSubChannelModel>();
                var customerGroups = new List<CustomerGroupModel>();

                result = _customerManager.GetAllChannels(ref channels, true);

                if (result == GlobalErrors.Success && channels != null && channels.Count > 0)
                {
                    result = _customerManager.GetAllSubChannels(-1, ref subChannels,true);
                }

                if (subChannels != null && subChannels.Count > 0 && result == GlobalErrors.Success)
                {
                    result = _customerManager.GetAllCustomerGroups(-1, -1, string.Empty, ref customerGroups,true);
                }


                customerHierarchyData = (from ch in channels
                                         select new
                                         {
                                             nodeName = ch.ChannelCodeName,
                                             nodeCode = ch.ChannelCode,
                                             nodeId = ch.ChannelId,
                                             isParent = true,
                                             parentId = -1,
                                             level = CustomersHierarchyLevel.Channel,
                                             isExpanded = true,
                                             descriptions = ch.Descriptions,
                                             dummyCode = CustomersHierarchyLevel.Channel.GetHashCode() +"-" + ch.ChannelId,
                                             children = (from subCh in subChannels
                                                         where subCh.ChannelId == ch.ChannelId
                                                         select new
                                                         {
                                                             nodeName = subCh.SubChannelCodeName,
                                                             nodeCode = subCh.SubChannelCode,
                                                             nodeId = subCh.SubChannelId,
                                                             isParent = true,
                                                             parentId = subCh.ChannelId,
                                                             level = CustomersHierarchyLevel.SubChannel,
                                                             isExpanded = true,
                                                             descriptions = subCh.Descriptions,
                                                             dummyCode = CustomersHierarchyLevel.SubChannel.GetHashCode() + "-" + subCh.SubChannelId,
                                                             dummyCodeParent = CustomersHierarchyLevel.Channel.GetHashCode() + "-" + subCh.ChannelId,
                                                             children = (from gr in customerGroups
                                                                         where gr.ChannelId == ch.ChannelId && gr.SubChannelId == subCh.SubChannelId
                                                                         select new
                                                                         {
                                                                             nodeName = gr.GroupCodeName,
                                                                             nodeCode = gr.GroupCode,
                                                                             nodeId = gr.GroupId,
                                                                             isParent = false,
                                                                             parentId = gr.SubChannelId,
                                                                             isExpanded = false,
                                                                             descriptions = gr.Descriptions,
                                                                             level = CustomersHierarchyLevel.Group,
                                                                             organizationId = gr.OrganizationId,
                                                                             dummyCode = CustomersHierarchyLevel.Group.GetHashCode() + "-" + gr.GroupId,
                                                                             channelId = gr.ChannelId,
                                                                             dummyCodeParent = CustomersHierarchyLevel.SubChannel.GetHashCode() + "-" + gr.SubChannelId,
                                                                             dummyCodeChannel = CustomersHierarchyLevel.Channel.GetHashCode() + "-" + gr.ChannelId
                                                                         }).ToArray()

                                                         }).ToArray()
                                         }).ToArray();

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors SaveUpdateCustomersHierarchyData(CustomerHierarchyModel customerHierarchyData,ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.Success;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Empty;

                switch (customerHierarchyData.CustomersHierarchyLevel)
                {
                    case CustomersHierarchyLevel.Channel:
                        result = _customerManager.InsertUpdateChannel(customerHierarchyData.IsEditMode, customerHierarchyData.ChannelId, customerHierarchyData.Code, customerHierarchyData.Descriptions,dbHelper, ref errorMessage);
                        break;
                    case CustomersHierarchyLevel.SubChannel:
                        result = _customerManager.InsertUpdateSubChannel(customerHierarchyData.IsEditMode, customerHierarchyData.SubChannelId, customerHierarchyData.ChannelId, customerHierarchyData.Code, customerHierarchyData.Descriptions,dbHelper, ref errorMessage);
                        break;
                    case CustomersHierarchyLevel.Group:
                        result = _customerManager.InsertUpdateCustomerGroup(customerHierarchyData.IsEditMode, customerHierarchyData.SubChannelId, customerHierarchyData.ChannelId, customerHierarchyData.GroupId, customerHierarchyData.organizationId, customerHierarchyData.Code, customerHierarchyData.Descriptions,dbHelper, ref errorMessage);
                        if (result == GlobalErrors.Success && customerHierarchyData.DeleteCustomersFromGroup && customerHierarchyData.IsEditMode)
                            result = _customerManager.DeleteCustomerFromGroup(customerHierarchyData.GroupId, dbHelper);
                        break;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }

            return result;

        }
        public GlobalErrors DeletCustomersHierarchyData(CustomerHierarchyModel customerHierarchyData, ref string errorMessage)
        {
            try
            {
                return _customerManager.DeletCustomersHierarchyData(customerHierarchyData, ref errorMessage);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveCustomersGroup(CustomersGroup customersGroup)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                result = _customerManager.SaveCustomersGroup(customersGroup, dbHelper);
                if(result == GlobalErrors.Success && customersGroup.IsThereAnyAchievementPromotions)
                {
                    result = _promotionService.ApplyGroupAchievementTargetPromotionsToCustomers(customersGroup, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return  GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors CheckCustomerGroupAchievementPromotions(List<int> groupIdsList, ref List<Promotion> groupPromotions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string groupIds = string.Empty;
                if(groupIdsList != null && groupIdsList.Count > 0)
                {
                    groupIds = string.Join(',', groupIdsList);
                    if(!string.IsNullOrEmpty(groupIds))
                    {
                        result = _customerManager.CheckCustomerGroupAchievementPromotions(groupIds, ref groupPromotions);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }



        #endregion

        #region[Must Sell Item]
        public GlobalErrors GetMustSellItemsList(GeneralFilter filter, ref SharedTableResult<MustSellItems> mustSellItemsList)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetMustSellItemsList(filter, ref mustSellItemsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                mustSellItemsList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveMustSellItem(MustSellItems mustSellItems)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (mustSellItems.MustSellItemId <= 0)
                {
                    result = _customerManager.InsertMustSellItem(mustSellItems);
                }
                else
                {
                    result = _customerManager.UpdateMustSellItem(mustSellItems);
                }
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAppliedMustSellItemDetails(MustSellItems mustSellObject, ref List<MustSellItems> mustSellItem)
        {
            try
            {

                return _customerManager.GetAppliedMustSellItemDetails(mustSellObject, ref mustSellItem);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                mustSellItem = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAppliedMustSellItemCustomerGroups(MustSellItems mustSellObject, ref List<CustomerGroupModel> customerGroupList)
        {
            try
            {

                return _customerManager.GetAppliedMustSellItemCustomerGroups(mustSellObject, ref customerGroupList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerGroupList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAppliedMustSellItemAllCustomers(MustSellItems mustSellObject, ref bool allCustomers)
        {
            try
            {

                return _customerManager.GetAppliedMustSellItemAllCustomers(mustSellObject, ref allCustomers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                allCustomers = false;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAppliedMustSellItemCustomers(MustSellItems mustSellObject, ref List<SimpleCustomerModel> customerList)
        {
            try
            {

                return _customerManager.GetAppliedMustSellItemCustomers(mustSellObject, ref customerList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAppliedMustSellItemExcludedCustomers(MustSellItems mustSellObject, ref List<SimpleCustomerModel> excludedCustomers)
        {
            try
            {

                return _customerManager.GetAppliedMustSellItemExcludedCustomers(mustSellObject, ref excludedCustomers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                excludedCustomers = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAppliedMustSellItemEmployee(MustSellItems mustSellObject, ref List<EmployeeModel> employee)
        {
            try
            {

                return _customerManager.GetAppliedMustSellItemEmployee(mustSellObject, ref employee);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                employee = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAppliedMustSellItemSecurityGroup(MustSellItems mustSellObject, ref List<SecurityGroupModel> securityGroups)
        {
            try
            {

                return _customerManager.GetAppliedMustSellItemSecurityGroup(mustSellObject, ref securityGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                securityGroups = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAppliedMustSellItemOrganizations(MustSellItems mustSellObject, ref List<MustSellItems> mustSellItem)
        {
            try
            {

                return _customerManager.GetAppliedMustSellItemOrganizations(mustSellObject, ref mustSellItem);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                mustSellItem = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteMustSellItem(int mustSellItemId)
        {
            try
            {
                return _customerManager.DeleteMustSellItem(mustSellItemId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors ActivateDeactivatMustSellItem(int mustSellItemId, bool isActivate)
        {
            try
            {
                return _customerManager.ActivateDeactivatMustSellItem(mustSellItemId, isActivate);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }
        #endregion

        #region[Customer Container Limit]
        public GlobalErrors InsertContainerLimit(ref CustomerContainerLimitModel containerLimit, ref string message)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                ItemPackModel smallestPack = new ItemPackModel();
                result = _itemManager.GetSmallestItemPack(containerLimit.ItemId, ref smallestPack);
                if (result == GlobalErrors.Success && smallestPack != null && smallestPack.PackId > -1)
                {
                    containerLimit.PackId = smallestPack.PackId;
                    containerLimit.PackTypeId = smallestPack.PackTypeId;
                    containerLimit.UOM = smallestPack.Uom;
                    bool exists = false;
                    result = _customerManager.CheckIfContainerLimitExists(containerLimit, ref exists);
                    if (result == GlobalErrors.Success)
                    {
                        if (exists)
                        {
                            message = "Desc_Container_Limit_Is_Already_Defined";
                            result = GlobalErrors.Error;
                        }
                        else
                        {
                            result = _customerManager.InsertContainerLimit(containerLimit);
                        }
                    }
                }
                else
                {
                    result = GlobalErrors.Error;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateContainerLimit(CustomerContainerLimitModel containerLimit)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.UpdateContainerLimit(containerLimit,null);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateContainerLimits(List<CustomerContainerLimitModel> containerLimits)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                foreach (CustomerContainerLimitModel container in containerLimits)
                {
                    result = _customerManager.UpdateContainerLimit(container, dBHelper);
                    if (result != GlobalErrors.Success) break;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors DeleteContainerLimit(CustomerContainerLimitModel containerLimit)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.DeleteContainerLimit(containerLimit);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomersContainersLimit(GeneralFilter filter, ref List<CustomerContainerLimitModel> containerLimitList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.GetCustomersContainersLimit(filter, ref containerLimitList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion
        #region [Payer Account]
        public GlobalErrors GetPayerAccountSharedTable(GeneralFilter filter, ref SharedTableResult<PayerAccountModel> payerAccountList)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _customerManager.GetPayerAccountSharedTable(filter, ref payerAccountList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                payerAccountList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SavePayerAccount(PayerAccountModel payerAccounts)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (payerAccounts.PayerId <= 0)
                {
                    result = _customerManager.InsertPayerAccount(payerAccounts);
                }
                else
                {
                    result = _customerManager.UpdatePayerAccount(payerAccounts);
                }
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.SuccessWithZeroRowAffected;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPayerAccountData(PayerAccountModel payer, ref List<PayerAccountModel> payerList)
        {
            try
            {

                return _customerManager.GetPayerAccountData(payer, ref payerList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                payerList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeletePayerAccount(int payerId, int accountId,ref string deleteMsg)
        {
            try
            {
                return _customerManager.DeletePayerAccount(payerId, accountId,ref deleteMsg);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetPayerAccount(int currencyId, ref List<PayerAccountModel> payers)
        {
            try
            {
                return _customerManager.GetPayerAccount(currencyId,ref payers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                payers = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomersPayerOutlets(GeneralFilter filter, ref List<PayerAccountModel> custOutList)
        {
            try
            {
                filter.IsFromPayerAccount = true;
                return _customerManager.GetCustomersPayerOutlets(filter, ref custOutList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custOutList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAppliedPayerAccountDivisions(PayerAccountModel payer, ref List<DivisionModel> division)
        {
            try
            {

                return _customerManager.GetAppliedPayerAccountDivisions(payer, ref division);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                division = null;
                return GlobalErrors.Error;
            }
        }
        #endregion

        #region[Sales Distribution Channel]

        public GlobalErrors GetSalesDistributionChannels(ref List<SalesDistributionChannelModel> channels, GeneralFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.GetSalesDistributionChannels(ref channels, filter);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSalesDistributionChannel(ref SalesDistributionChannelModel channel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.GetSalesDistributionChannelMainData(ref channel);
                if(result == GlobalErrors.Success)
                {
                    List<TextLanguage> languages = new List<TextLanguage>();
                    result = _customerManager.GetSalesDistributionChannelLanguages(channel.SDCId, ref languages);
                    if (result == GlobalErrors.Success && languages != null)
                    {
                        TextLanguage currentLang = languages.Where(lang => lang.LanguageId == _requestRepository.LanguageId).FirstOrDefault();
                        channel.DescriptionLanguages = languages;
                        channel.SDCDescription = currentLang != null ? currentLang.Description : string.Empty;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    List<OrganizationModel> organizations = new List<OrganizationModel>();
                    result = _customerManager.GetSalesDistributionChannelOrganizations(channel.SDCId, ref organizations);
                    if (result == GlobalErrors.Success && organizations != null) channel.OrganizationsList = organizations;
                }
                if (result == GlobalErrors.Success)
                {
                    List<SimpleCustomerModel> customers = new List<SimpleCustomerModel>();
                    result = _customerManager.GetSalesDistributionChannelCustomers(channel.SDCId, ref customers);
                    if (result == GlobalErrors.Success && customers != null) channel.CustomersList = customers;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertSalesDistributionChannelProcess(SalesDistributionChannelModel channel)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                int maxId = MasterDataManager.GetMaxID("SDCID", "SDC", dBHelper);
                if (maxId <= 0) return GlobalErrors.Error;

                channel.SDCId = maxId;
                result = _customerManager.InsertSalesDistributionChannel(channel, dBHelper);
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.InsertSalesDistributionChannelLanguage(channel, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.InsertSalesDistributionChannelOrganization(channel, dBHelper);
                }
                if (result == GlobalErrors.Success && channel.CustomersList != null && channel.CustomersList.Count > 0)
                {
                    result = _customerManager.InsertSalesDistributionChannelCustomers(channel, dBHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            if (dBHelper != null)
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
                dBHelper.Dispose();
                dBHelper = null;
            }
            return result;
        }

        public GlobalErrors UpdateSalesDistributionChannelProcess(SalesDistributionChannelModel channel)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                result = _customerManager.UpdateSalesDistributionChannel(channel, dBHelper);
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.DeleteSalesDistributionChannelLanguage(channel.SDCId, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        result = _customerManager.InsertSalesDistributionChannelLanguage(channel, dBHelper);
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.DeleteSalesDistributionChannelOrganization(channel.SDCId, true, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        result = _customerManager.InsertSalesDistributionChannelOrganization(channel, dBHelper);
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.DeleteSalesDistributionChannelCustomers(channel.SDCId, -1,-1,true, dBHelper);
                    if (result == GlobalErrors.Success && channel.CustomersList != null && channel.CustomersList.Count > 0)
                    {
                        result = _customerManager.InsertSalesDistributionChannelCustomers(channel, dBHelper);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            if (dBHelper != null)
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
                dBHelper.Dispose();
                dBHelper = null;
            }
            return result;
        }

        public GlobalErrors DeleteSalesDistributionChannelProcess(int channelId, ref string message)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                result = _customerManager.IsSDCUsedInPromotion(channelId,ref message, dBHelper);
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.IsSDCUsedInPrice(channelId, ref message, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.IsSDCUsedInDiscount(channelId, ref message, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.IsSDCUsedInOrder(channelId, ref message, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.IsSDCUsedInTransaction(channelId, ref message, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.DeleteSalesDistributionChannelLanguage(channelId, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.DeleteSalesDistributionChannelOrganization(channelId, false, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.DeleteSalesDistributionChannelCustomers(channelId,-1,-1, false, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _customerManager.DeleteSalesDistributionChannel(channelId, dBHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            if (dBHelper != null)
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
                dBHelper.Dispose();
                dBHelper = null;
            }
            return result;
        }


        #endregion
        #region [Customer Order Limit]
        public GlobalErrors GetCustomerOrderLimitData(GeneralFilter generalFilter, ref SharedTableResult<CustomerOrderLimitModel> customerOrderLimitList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.GetCustomerOrderLimitData(generalFilter, ref customerOrderLimitList);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors SaveCustomerOrderLimitList(List<CustomerOrderLimitModel> data)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                GeneralFilter generalFilter = new GeneralFilter();
                SharedTableResult<CustomerOrderLimitModel> customerOrderLimitSharedTable = new SharedTableResult<CustomerOrderLimitModel>();
                foreach (CustomerOrderLimitModel item in data)
                {
                    result = _customerManager.SaveCustomerOrderLimitList(item);
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors UpdateCustomerOrderLimit(CustomerOrderLimitModel data)
        {
            try
            {
                return _customerManager.UpdateCustomerOrderLimit(data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        #endregion
        public GlobalErrors SaveCustomerVisit(TeleRepVisitModel teleRepVisitModel, ref int visitId)
        {
            try
            {
                return _customerManager.SaveCustomerVisit(teleRepVisitModel, ref visitId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors CheckIfProductiveVisit(TeleRepVisitModel teleRepVisitModel, ref bool isProductive)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.CheckIfProductiveVisit(teleRepVisitModel, ref isProductive);
                if (result == GlobalErrors.Success && isProductive)
                {
                    teleRepVisitModel.VisitStatusId = TeleRepVisitStatus.Productive;
                    result = EndCustomerVisit(teleRepVisitModel);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors EndCustomerVisit(TeleRepVisitModel teleRepVisitModel)
        {
            try
            {
                return _customerManager.EndCustomerVisit(teleRepVisitModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetNonProductiveReasonList(ref List<GeneralModel> reasonsList)
        {
            try
            {
                return _customerManager.GetNonProductiveReasonList(ref reasonsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveNewCall(CallsHistoryModel callModel, ref int callId)
        {
            try
            {
                return _customerManager.SaveNewCall(callModel, ref callId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetIncompleteCalls(int customerId, int outletId, ref List<CallsHistoryModel> calls)
        {
            try
            {
                return _customerManager.GetIncompleteCalls(customerId, outletId, ref calls);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateCallsDetails(ActualCallsModel callsModel)
        {
            try
            {
                return _customerManager.UpdateCallDetails(callsModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors CheckForIncompleteVistis(CustomerFilter filter, ref SimpleCustomerModel outlet)
        {
            try
            {
                return _customerManager.CheckForIncompleteVistis(filter, ref outlet);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors CheckCustomerOutletDivisionIsExist(ref bool isExist)
        {
            try
            {
                return _customerManager.CheckCustomerOutletDivisionIsExist(ref isExist);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors CheckCustomerOrganizationIsExist(ref bool isExist,GeneralFilter filter)
        {
            try
            {
                return _customerManager.CheckCustomerOrganizationIsExist(ref isExist,filter);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public string GetMaxCustomerCodeSequence()
        {
            try
            {
                return _customerManager.GetMaxCustomerCodeSequence();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }
        public string GetMaxNewOutletCodeSequence()
        {
            try
            {
                return _customerManager.GetMaxNewOutletCodeSequence();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }
        public GlobalErrors GetCustomerLastInvoice(int customerId, int outletId, ref TransactionModel lastInvoice)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _customerManager.GetCustomerLastInvoice(customerId, outletId, ref lastInvoice);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAccoutDataForCRMOrder(int customerId, int outletId, int divisionId, ref AccountModel account, ref decimal overDueAmount)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                CustomerOutletModel outlet = new CustomerOutletModel();
                outlet.CustomerId = customerId;
                outlet.OutletId = outletId;
                _customerManager.ReadCustomerAccount(ref outlet, divisionId, null);
                if (outlet.Account != null && outlet.Account.AccountId > 0)
                {
                    account = outlet.Account;
                    result = _customerManager.GetOverDueTransactions(customerId, outletId, account.AccountId, ref overDueAmount);
                }
                else
                {
                    result = GlobalErrors.Error;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerComplain(CustomerFilter filter, ref List<ComplainModel> complains)
        {
            try
            {
                return _customerManager.GetCustomerComplain(filter, ref complains);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveCustomerComplain(CustomerFilter filter)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                result = _customerManager.InsertCustomerComplain(filter);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public void ReadCustomerAccount(ref CustomerOutletModel outlet, int divisionId, DBHelper<int> dBHelper)
        {
            try
            {
               _customerManager.ReadCustomerAccount(ref outlet,divisionId,dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

    }
}