﻿using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Reflection;


namespace Sonic.Web.Service
{
    public class FQAsService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly FQAsManager _fQAsManager;

        public FQAsService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _fQAsManager = new FQAsManager(requestRepository);
        }

        public GlobalErrors GetFQASList(ref SharedTableResult<FQAsModel> fQAsList)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                result = _fQAsManager.GetFQASList(ref fQAsList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }        
        public GlobalErrors InsertFQA(List<FQAsModel> fQAs)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                var MaxID = GetMaxID("FqaId", "CustomerAppFAQs", dbHelper);
                foreach (var fqa in fQAs)
                {
                    if (fqa.Id < 0)
                    {
                        fqa.Id = MaxID;
                        MaxID++;
                    }
                }
                result = _fQAsManager.InsertFQA(fQAs, dbHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public static int GetMaxID(string columnName, string tableName, DBHelper<int> dBHelper)
        {
            try
            {
                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object max = null;
                string query = string.Format(@"select isnull(max({0}),0)+1 from {1} ", columnName, tableName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref max);
                if (result == GlobalErrors.Success && max != null && !string.IsNullOrEmpty(max.ToString()))
                {
                    return int.Parse(max.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return 1;
        }
    }
}
