﻿using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using InCube.Security;

namespace Sonic.Web.Service
{
    public class DashboardService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly DashboardManager _dashboardManager;
        public DashboardService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _dashboardManager = new DashboardManager(_requestRepository);
        }
        public int GetOperationDashboardId(DashboardOperations operation)
        {
            int id = 0;
            try
            {
                id = _dashboardManager.GetOperationDashboardId(operation);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return id;
        }
        public GlobalErrors GetAvailableReport(ref List<Category> data)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                //var dashboards = new List<Dashboard>();
                //result = _dashboardManager.GetNotAdvancedReportsAvailable(ref dashboards);//GetAvailableReport(ref dashboards);
                //if (result == GlobalErrors.Success && dashboards.Count > 0)
                //{
                //    data = dashboards.GroupBy(category => category.CategoryId).Select(grp => new Category()
                //    {
                //        CategoryId = grp.Key,
                //        CategoryName = grp.ToList().First().CategoryName,
                //        Dashboards = grp.ToList().Select(v => new Dashboard()
                //        {
                //            ID = v.ID,
                //            Name = v.Name,
                //            URL = LocalUtilities.RDLCReportURL +
                //            "?Signature="
                //            + EncryptionManager.Instance.EncryptData(_requestRepository.CurrentOperator.EmployeeId.ToString() + "@" + _requestRepository.CurrentOperator.OperatorId.ToString() + "@" + v.ID.ToString() + "@" + v.MenuID)
                //             + "&langId=" + _requestRepository.LanguageId.ToString()
                //        }).ToList()
                //    }).ToList();
                //}
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors GetAvailableAdvancedToolReport(ref List<Category> data)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                var dashboards = new List<Dashboard>();
                result = _dashboardManager.GetAvailableReport(ref dashboards);
                if (result == GlobalErrors.Success && dashboards.Count > 0)
                {
                    string signature = _dashboardManager.GenerateDashboardSignature(string.Empty, string.Empty, string.Empty);
                    data = dashboards.GroupBy(category => category.CategoryId).Select(grp => new Category()
                    {
                        CategoryId = grp.Key,
                        CategoryName = grp.ToList().First().CategoryName,
                        Dashboards = grp.ToList().Select(v => new Dashboard()
                        {
                            ID = v.ID,
                            Name = v.Name,
                            URL = LocalUtilities.ATReportURL +
                            "?id="
                            + EncryptionManager.Instance.EncryptData(string.Format(signature, v.ID)).Replace('+', '*')
                        }).ToList()
                    }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors GetAvailableDashboard(ref List<Category> data)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                var dashboards = new List<Dashboard>();
                result = _dashboardManager.GetAvailableDashboard(ref dashboards);
                if (result == GlobalErrors.Success && dashboards.Count > 0)
                {
                    string signature = _dashboardManager.GenerateDashboardSignature(string.Empty, string.Empty, string.Empty);
                    data = dashboards.GroupBy(category => category.CategoryId).Select(grp => new Category()
                    {
                        CategoryId = grp.Key,
                        CategoryName = grp.ToList().First().CategoryName,
                        Dashboards = grp.ToList().Select(v => new Dashboard()
                        {
                            ID = v.ID,
                            ImageName = v.ImageName,
                            Name = v.Name,
                            URL = LocalUtilities.DashboardURL +
                            "?id="
                            + EncryptionManager.Instance.EncryptData(string.Format(signature, v.ID)).Replace('+', '*')
                        }).ToList()
                    }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors GetEndOfDayDashboards(int routeHistoryId, ref List<Dashboard> dashboards)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                dashboards = new List<Dashboard>();
                result = _dashboardManager.GetEndOfDayDashboards(ref dashboards);
                if (result == GlobalErrors.Success && dashboards.Count > 0)
                {
                    string signature = _dashboardManager.GenerateDashboardSignature(routeHistoryId.ToString(), string.Empty, string.Empty);
                    dashboards.ForEach(a =>
                    {
                        a.URL = LocalUtilities.DashboardURL +
                                "?id="
                                + EncryptionManager.Instance.EncryptData(string.Format(signature, a.ID)).Replace('+', '*');
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors GetEndOfDayReoports(int routeHistoryId, ref List<Category> data)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                var dashboards = new List<Dashboard>();
                result = _dashboardManager.GetEndOfDayReoports(ref dashboards);
                if (result == GlobalErrors.Success && dashboards.Count > 0)
                {
                    string signature = _dashboardManager.GenerateDashboardSignature(routeHistoryId.ToString(), string.Empty, string.Empty);
                    data = dashboards.GroupBy(category => category.CategoryId).Select(grp => new Category()
                    {
                        CategoryId = grp.Key,
                        CategoryName = grp.ToList().First().CategoryName,
                        Dashboards = grp.ToList().Select(v => new Dashboard()
                        {
                            ID = v.ID,
                            Name = v.Name,
                            URL = LocalUtilities.ATReportURL +
                                "?id="
                                + EncryptionManager.Instance.EncryptData(string.Format(signature, v.ID)).Replace('+', '*')
                        }).ToList()
                    }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors GetEndorsementDashboards(int routeHistoryId, ref List<Dashboard> dashboards)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                result = _dashboardManager.GetEndorsementDashboards(ref dashboards);
                if (result == GlobalErrors.Success && dashboards.Count > 0)
                {
                    string signature = _dashboardManager.GenerateDashboardSignature(routeHistoryId.ToString(), string.Empty, string.Empty);
                    dashboards.ForEach(v =>
                    {
                        v.URL = LocalUtilities.DashboardURL +
                                "?id="
                                + EncryptionManager.Instance.EncryptData(string.Format(signature, v.ID)).Replace('+', '*');
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
    }
}
