﻿using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Service
{
    public class DiscountService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly CustomerManager _customerManager;

        public DiscountService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _customerManager = new CustomerManager(requestRepository);
        }
        public GlobalErrors GetAllDiscounts(ref List<DiscountModel> discounts)
        {
            try
            {
                return _customerManager.GetAllDiscounts(ref discounts);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
    }
}
