﻿
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using System;
using System.Reflection;


namespace Sonic.Web.Services
{
    public class DocumentSequenceService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly DocumentSequenceManager _documentSequenceManager;

        public DocumentSequenceService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _documentSequenceManager = new DocumentSequenceManager(requestRepository);
        }
        public string GetMaxDocumentSequence(int employeeId, DocumentTypes documentType, int divisionID,int sdcId = -1)
        {
            try
            {
                return GetMaxDocumentSequence(employeeId, documentType, divisionID, null, sdcId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }
        public string GetMaxDocumentSequence(int employeeId, DocumentTypes documentType, int divisionID, DBHelper<int> dbHelper, int sdcId = -1)
        {
            try
            {
                return _documentSequenceManager.GetMaxDocumentSequence(dbHelper, employeeId, documentType, divisionID, sdcId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }
    }
}
