﻿using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using InCube.Security;
using System.Data;
using System.IO;
using System.Net.Mail;
using DinkToPdf.Contracts;
using DinkToPdf;
using Newtonsoft.Json;
using Razor.Templating.Core;
using Sonic.Web.Resources;
using DocumentFormat.OpenXml.Bibliography;
//using Sonic.Web.Core.Survey;

namespace Sonic.Web.Service
{
    public class DynamicReportService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly IConverter _converter;
        private readonly DynamicReportManager _dynamicReportManager;
        private readonly EmployeeManager _employeeManager;
        private SharedMethod _sharedMethod;
        private readonly EmailManager _emailManager;
        private readonly EmailService _emailService;
        //private readonly SurveyManager _surveyManager;
        public DynamicReportService(IRequestRepository requestRepository , IConverter converter)
        {
            _requestRepository = requestRepository;
            _converter = converter;
            _dynamicReportManager = new DynamicReportManager(_requestRepository);
            _employeeManager = new EmployeeManager(_requestRepository);
            _sharedMethod = new SharedMethod(_requestRepository);
            _emailManager = new EmailManager(requestRepository);
            _emailService = new EmailService(requestRepository);
            //_surveyManager = new SurveyManager(requestRepository);
        }
        public GlobalErrors GetReportFilters(int reportId, ref List<ReportFilterModel> filtersList)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                result = _dynamicReportManager.GetReportFilters(reportId, ref filtersList);

                if (result == GlobalErrors.Success && filtersList != null && filtersList.Count > 0)
                {
                    int filterIndex = 0;
                    foreach (ReportFilterModel filter in filtersList)
                    {
                        filter.FilterIndex = filterIndex;
                        filter.FormControlName = reportId + "_" + "filter_" + filterIndex;
                        filter.CheckAllFormControlName = "chkAll_" + filter.FormControlName;
                        //filter.ParameterName = filter.ParameterName.ToLower();
                        filterIndex++;
                        if (filter.ReportFilterTypeId == ReportFilterTypes.Lookup || filter.ReportFilterTypeId == ReportFilterTypes.LookUp_WithoutAll)
                        {
                            #region [Fill Filter Data]
                            if (result == GlobalErrors.Success)
                            {
                                List<ReportFilterDataSourceModel> filterData = new List<ReportFilterDataSourceModel>();

                                result = FillFilterDataSource(filter, ref filterData);
                                if(result == GlobalErrors.Success)
                                {
                                    if (filterData != null && filterData.Count > 0)
                                    {
                                        filter.FilterData = filterData;
                                        filter.SelectedValue = filter.FilterData[0].BindValue;
                                    }
                                    else
                                    {
                                        filter.FilterData = new List<ReportFilterDataSourceModel>();
                                    }
                                }
                                else
                                {
                                    return result;
                                }
                            }
                            #endregion

                            #region [Replace Parameter In Childs Filters]
                            if (filter.ReportFilterTypeId == ReportFilterTypes.Lookup || filter.ReportFilterTypeId == ReportFilterTypes.LookUp_WithoutAll)
                            {
                                if (filtersList.Any(childFilter => childFilter.QueryString.Contains(filter.ParameterName)))
                                {
                                    filtersList.Where(childFilter => childFilter.QueryString.Contains(filter.ParameterName)
                                    && (childFilter.ReportFilterTypeId == ReportFilterTypes.Lookup || childFilter.ReportFilterTypeId == ReportFilterTypes.LookUp_WithoutAll)).ToList().ForEach(childFilter =>
                                    {
                                        childFilter.ParentFilterIndex = filter.FilterIndex;
                                        childFilter.ParentFilterParameterName = filter.ParameterName;
                                        childFilter.ParentFilterTypeId = filter.ReportFilterTypeId;
                                        childFilter.ParentFilterValue = filter.SelectedValue;
                                    });
                                }
                            }
                            #endregion
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillFilterDataSource(ReportFilterModel filter, ref List<ReportFilterDataSourceModel> filterData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                //string query = filter.QueryString.ToLower();
                string query = filter.QueryString;
                result = ReplaceSessionParameters(null,ref query);
                if (result == GlobalErrors.Success)
                {
                    if(filter.ParentFilterIndex != -1 && !string.IsNullOrEmpty(filter.ParentFilterParameterName))
                    {
                        if (filter.ParentFilterTypeId == ReportFilterTypes.Lookup || filter.ParentFilterTypeId == ReportFilterTypes.LookUp_WithoutAll)
                        {
                            if (string.IsNullOrEmpty(filter.ParentFilterValue) || filter.ParentFilterValue == "-1")
                            {
                                query = query.Replace(filter.ParentFilterParameterName, "-1");
                            }
                            else
                            {
                                query = query.Replace(filter.ParentFilterParameterName, filter.ParentFilterValue);
                            }
                        }
                    }
                    filter.QueryString = query;

                    DataTable dt = new DataTable();

                    result = _dynamicReportManager.FillFilterDataSource(filter.QueryString, ref dt);
                    if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                    {
                        //DynamicProperty dynamic;

                        filter.ValueMember = filter.ValueMember.ToLower();
                        filter.DisplayMember1 = filter.DisplayMember1.ToLower();
                        filter.DisplayMember2 = filter.DisplayMember2.ToLower();

                        for (int rowIndex = 0; rowIndex < dt.Rows.Count; rowIndex++)
                        {
                            ReportFilterDataSourceModel obj = new ReportFilterDataSourceModel();
                            int indexOfValue = -1;
                            int indexOfDisplay1 = -1;
                            int indexOfDisplay2 = -1;

                            indexOfValue = dt.Columns.IndexOf(filter.ValueMember);
                            indexOfDisplay1 = dt.Columns.IndexOf(filter.DisplayMember1);
                            indexOfDisplay2 = dt.Columns.IndexOf(filter.DisplayMember2);

                            if(indexOfDisplay1 != -1 && dt.Rows[rowIndex][indexOfDisplay1] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[rowIndex][indexOfDisplay1].ToString()))
                            {
                                obj.BindLabel = dt.Rows[rowIndex][indexOfDisplay1].ToString();
                            }
                            if (indexOfDisplay2 != -1 && dt.Rows[rowIndex][indexOfDisplay2] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[rowIndex][indexOfDisplay2].ToString()))
                            {
                                if (!string.IsNullOrEmpty(obj.BindLabel))
                                {
                                    obj.BindLabel += " - ";
                                }
                                obj.BindLabel += dt.Rows[rowIndex][indexOfDisplay2].ToString();
                            }
                            
                            obj.BindValue = dt.Rows[rowIndex][indexOfValue].ToString();

                            filterData.Add(obj);

                            //dynamic = new DynamicProperty();
                            //dynamic["bindValue"] = dt.Rows[rowIndex][indexOfValue];
                            //dynamic["bindLabel"] = dt.Rows[rowIndex][indexOfDisplay1] + " - " + dt.Rows[rowIndex][indexOfDisplay2];
                            //dataList.Add(dynamic.Properties);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ReplaceSessionParameters(ReportFilterModel filter, ref string query)
        {
            try
            {
                Dictionary<String, String> Parameters = new Dictionary<string, string>();

                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParLanguage.ToString(), _requestRepository.LanguageId.ToString());
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParUserID.ToString(), _requestRepository.CurrentOperator.EmployeeId.ToString());
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.StockDigitFormat.ToString(), _requestRepository.Configurations.NumberOfStockDigits.ToString());
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.DigitFormat.ToString(), _requestRepository.Configurations.NumberOfDigits.ToString());
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParEmployeeSupervisor.ToString(), _employeeManager.GetSupervisorAccess().ToString());

                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgWarehouse.ToString(), _requestRepository.CurrentOperator.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgVehicle.ToString(), _requestRepository.CurrentOperator.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgTerritory.ToString(), _requestRepository.CurrentOperator.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgDivision.ToString(), _requestRepository.CurrentOperator.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgEmployee.ToString(), _requestRepository.CurrentOperator.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgAccount.ToString(), _requestRepository.CurrentOperator.OrganizationAccess);

                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgOrganization.ToString(), _requestRepository.CurrentOperator.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParCustomVehicle.ToString(), _employeeManager.GetVehiclesUnderEmployeeAccess());
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrganization.ToString(), _requestRepository.CurrentOperator.OrganizationAccess);
                
                if(filter != null && filter.ParameterName == DynamicReportConstants.ParField.ToString())
                {
                    FieldSubTypeModel fields = new FieldSubTypeModel(); /*_surveyManager.GetSubFields(int.Parse(filter.SelectedValue));*/
                    string tableName = string.Empty;
                    string fieldName = string.Empty;
                    string fieldNameWithFormat = string.Empty;
                    switch (fields.FieldTypeId)
                    {
                        case 1:
                            if (fields.FieldSubTypeId != null && fields.FieldSubTypeId.ToString().Trim() != "" && fields.FieldSubTypeId.ToString().Trim() == "1")
                            {
                                tableName = "FieldValueInt";
                                fieldName = "IntValue";
                                fieldNameWithFormat = fieldName;
                            }
                            else
                            {
                                tableName = "FieldValueFlo";
                                fieldName = "FloValue";
                                fieldNameWithFormat = fieldName;
                            }

                            break;
                        case 2:
                            tableName = "FieldValueString";
                            fieldName = "StringValue";
                            fieldNameWithFormat = fieldName;
                            break;

                        case 3:
                            tableName = "FieldValueDate";
                            fieldName = "DateValue";
                            fieldNameWithFormat = " convert(varchar, " + fieldName + ", 103) ";
                            break;

                        case 7:
                            tableName = "FieldValueDate";
                            fieldName = "DateValue";
                            fieldNameWithFormat = " convert(varchar, " + fieldName + ", 108) ";
                            break;

                        case 4:
                            tableName = "FieldValueBit";
                            fieldName = "BitValue";
                            fieldNameWithFormat = " (case " + fieldName + " when 0 then 'N' else 'Y' end)";
                            break;
                        default:
                            tableName = "FieldValueString";
                            fieldName = "StringValue";
                            fieldNameWithFormat = fieldName;
                            break;
                    }
                    Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.tableName.ToString(), tableName);
                    Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.fieldName.ToString(), fieldName);
                    Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.fieldFormat.ToString(), fieldNameWithFormat);
                }
                foreach (KeyValuePair<string, string> entery in Parameters)
                {
                    if (entery.Key.ToString() == "@Organization_Custom_Vehicle")
                    {
                        if (query.Contains(entery.Key.ToString()))
                        {

                        }
                    }
                   
                    query = query.Replace(entery.Key.ToString(), entery.Value.ToString());
                    query = query.Replace(entery.Key.ToString().ToLower(), entery.Value.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors GetChildFilterData(ReportFilterModel filter, ref List<ReportFilterDataSourceModel> filterData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                result = _dynamicReportManager.GetReportFilterQuery(filter, ref query);
                if(result == GlobalErrors.Success && !string.IsNullOrEmpty(query))
                {
                    //filter.QueryString = query.ToLower();
                    filter.QueryString = query;
                    result = FillFilterDataSource(filter, ref filterData);
                    if(filterData != null && filterData.Count > 0)
                    {
                        filter.FilterData = filterData;
                    }
                    else
                    {
                        filter.FilterData = new List<ReportFilterDataSourceModel>();
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ShowReportData(ref string uniqueIdentifier, DynamicReportModel report)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = PrepareReportQuery(ref report);
                if(result == GlobalErrors.Success && report != null && !string.IsNullOrEmpty(report.ToString()))
                {
                    result = _dynamicReportManager.SaveTempReportQuery(ref uniqueIdentifier, report);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors PrepareReportQuery(ref DynamicReportModel report , bool isFromScheduleReports = false , EmployeeModel employee = null , int languageId = -1 , int numberOfDigits = -1 ,int numberOfStockDigits = -1 , int EndOfDayEmployeeId = -1)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                // get report  query
                DateTime fromDate = new DateTime();
                string query = string.Empty;
                ReportFilterModel fieldFilter = null;
                if (!isFromScheduleReports)
                {
                    languageId = _requestRepository.LanguageId;
                }
                result = _dynamicReportManager.GetOriginalReportQuery(report.ReportId, ref query , languageId);
                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(query))
                {
                    //query = query.ToLower();
                    if(result == GlobalErrors.Success)
                    {
                        foreach (ReportFilterModel filter in report.ReportFilters)
                        {
                            #region [Date] 
                            if (filter.IsDateFilter || filter.IsDateTimeFilter)
                            {
                                if (!filter.Disabled && filter.IsDateFilter)
                                {
                                    if (filter.SelectedDateModelValue != null)
                                    {
                                        if (isFromScheduleReports)
                                        {
                                            filter.SelectedDateValue = new DateTime(filter.SelectedDateModelValue.Year, filter.SelectedDateModelValue.Month, filter.SelectedDateModelValue.Day, filter.SelectedDateModelValue.Hour, filter.SelectedDateModelValue.Minute, filter.SelectedDateModelValue.Second);
                                        }
                                        else
                                        {
                                            filter.SelectedDateValue = new DateTime(filter.SelectedDateModelValue.Year, filter.SelectedDateModelValue.Month, filter.SelectedDateModelValue.Day);
                                        }
                                        filter.SelectedText = filter.SelectedDateValue.GetValueOrDefault().ToString("dd/MM/yyyy");
                                    }
                                }
                                if (!filter.Disabled && filter.IsDateTimeFilter)
                                {
                                    if (filter.SelectedDateModelValue != null)
                                    {
                                        filter.SelectedDateValue = new DateTime(filter.SelectedDateModelValue.Year, filter.SelectedDateModelValue.Month, filter.SelectedDateModelValue.Day, filter.SelectedDateModelValue.Hour, filter.SelectedDateModelValue.Minute, filter.SelectedDateModelValue.Second);
                                        filter.SelectedText = filter.SelectedDateValue.GetValueOrDefault().ToString("dd/MM/yyyy HH:mm:ss");
                                    }
                                }
                                if (filter.Disabled && (filter.IsDateFilter || filter.IsDateTimeFilter))
                                {
                                    if (filter.ReportFilterTypeId == ReportFilterTypes.Date_Min || filter.ReportFilterTypeId == ReportFilterTypes.DateTime_Min || filter.ReportFilterTypeId == ReportFilterTypes.NumericDate_Min)
                                    {
                                        filter.SelectedDateValue = DateTime.MinValue.AddYears(1752);
                                    }
                                    if (filter.ReportFilterTypeId == ReportFilterTypes.Date_Max || filter.ReportFilterTypeId == ReportFilterTypes.DateTime_Max || filter.ReportFilterTypeId == ReportFilterTypes.NumericDate_Max)
                                    {
                                        filter.SelectedDateValue = DateTime.MaxValue.AddDays(-1);
                                    }
                                }
                                if (filter.ReportFilterTypeId == ReportFilterTypes.Date || filter.ReportFilterTypeId == ReportFilterTypes.Date_Min || filter.ReportFilterTypeId == ReportFilterTypes.Date_Max)
                                {
                                    query = query.Replace(filter.ParameterName, LocalUtilities.ParseDateToSQLString(filter.SelectedDateValue.GetValueOrDefault()).ToString());
                                }
                                if (filter.ReportFilterTypeId == ReportFilterTypes.DateTime_Min || filter.ReportFilterTypeId == ReportFilterTypes.DateTime_Max)
                                {
                                    query = query.Replace(filter.ParameterName, LocalUtilities.ParseDateAndTimeToSQL(filter.SelectedDateValue.GetValueOrDefault()).ToString());
                                }
                                if (filter.ReportFilterTypeId == ReportFilterTypes.NumericDate || filter.ReportFilterTypeId == ReportFilterTypes.NumericDate_Min || filter.ReportFilterTypeId == ReportFilterTypes.NumericDate_Max)
                                {
                                    filter.SelectedText = filter.SelectedDateValue.GetValueOrDefault().ToString("yyyyMMdd");
                                    query = query.Replace(filter.ParameterName, filter.SelectedDateValue.GetValueOrDefault().ToString("yyyyMMdd"));
                                }


                                #region [Date Validations]
                                if (filter.ReportFilterTypeId == ReportFilterTypes.Date || filter.ReportFilterTypeId == ReportFilterTypes.NumericDate)
                                {
                                    if (fromDate == DateTime.MinValue)
                                    {
                                        fromDate = filter.SelectedDateValue.GetValueOrDefault();
                                    }
                                    else if (fromDate > filter.SelectedDateValue.GetValueOrDefault())
                                    {
                                        result = GlobalErrors.ValueIsMoreThanRequested;
                                        return result;
                                    }
                                }
                                if (filter.ReportFilterTypeId == ReportFilterTypes.Date_Min || filter.ReportFilterTypeId == ReportFilterTypes.DateTime_Min || filter.ReportFilterTypeId == ReportFilterTypes.NumericDate_Min)
                                {
                                    if (!filter.Disabled)
                                    {
                                        fromDate = filter.SelectedDateValue.GetValueOrDefault();
                                    }
                                }
                                if (filter.ReportFilterTypeId == ReportFilterTypes.Date_Max || filter.ReportFilterTypeId == ReportFilterTypes.DateTime_Max || filter.ReportFilterTypeId == ReportFilterTypes.NumericDate_Max)
                                {
                                    if (fromDate != DateTime.MinValue)
                                    {
                                        if (fromDate > Convert.ToDateTime(filter.SelectedDateValue.GetValueOrDefault()))
                                        {
                                            result = GlobalErrors.ValueIsMoreThanRequested;
                                            return result;
                                        }
                                    }
                                }

                                #endregion
                            }
                            #endregion

                            #region[Text]
                            if (filter.ReportFilterTypeId == ReportFilterTypes.Text)
                            {
                                query = query.Replace(filter.ParameterName, filter.SelectedValue);
                            }
                            #endregion

                            #region[Combo]
                            if (filter.ReportFilterTypeId == ReportFilterTypes.Lookup || filter.ReportFilterTypeId == ReportFilterTypes.LookUp_WithoutAll)
                            {
                                if (!string.IsNullOrEmpty(filter.SelectedValue) && filter.SelectedValue != "-1")
                                {
                                    query = query.Replace(filter.ParameterName, "'" + filter.SelectedValue + "'");
                                }
                                else
                                {
                                    string codeSeparator = "~";
                                    string[] ArrStr = new string[1];
                                    query = query.Replace(filter.ParameterName, codeSeparator);
                                    ArrStr = query.Split(codeSeparator.ToCharArray());
                                    query = string.Empty;
                                    int i;
                                    for (i = 0; i < ArrStr.Length - 1; i++)
                                    {
                                        ArrStr[i] = ArrStr[i].TrimEnd(' ');
                                        ArrStr[i] = ArrStr[i].TrimEnd('!');
                                        ArrStr[i] = ArrStr[i].TrimEnd('=');
                                        ArrStr[i] = ArrStr[i].TrimEnd('<');
                                        ArrStr[i] = ArrStr[i].TrimEnd('>');
                                        ArrStr[i] = string.Concat(ArrStr[i], " Not IN ('-111') "); query += ArrStr[i].ToString();
                                    }
                                    query += ArrStr[i].ToString();
                                }
                            }
                            #endregion
                            if (filter.ParameterName == DynamicReportConstants.ParField.ToString())
                            {
                                fieldFilter = filter;
                            }
                        }
                        if (isFromScheduleReports)
                        {
                            result = _sharedMethod.ReplaceReportScheduleParameters(ref query, employee, languageId, numberOfDigits, numberOfStockDigits, EndOfDayEmployeeId);
                        }
                        else
                        {
                            result = ReplaceSessionParameters(fieldFilter, ref query);
                        }
                        report.QueryString = query;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        #region [Report Schedule]
        public GlobalErrors GetReportScheduledToday(ref List<ReportScheduleModel> reportSchedule)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _dynamicReportManager.GetReportScheduledToday(ref reportSchedule);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateNewTimeToRun(ReportScheduleModel reportSchedule , DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _dynamicReportManager.UpdateNewTimeToRun(ref reportSchedule , dBHelper, true);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetReportSchedule(ref List<ReportScheduleModel> reportSchedule)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _dynamicReportManager.GetReportSchedule(ref reportSchedule);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        } 
        public GlobalErrors PopulateScheduledReports(ref List<ReportScheduleModel> reportSchedule , ref List<ReportFilterModel> reportFilters, int reportId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _dynamicReportManager.PopulateScheduledReports(ref reportSchedule , reportId);
                if(result == GlobalErrors.Success)
                {
                    result = _dynamicReportManager.PopulateScheduledReportsFilter(ref reportFilters , reportId);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        } 
        public GlobalErrors GetReportScheduleFilter(ref string HeaderFilter , int scheduleId , int ReportScheduleAssignmentId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _dynamicReportManager.GetReportScheduleFilter(ref HeaderFilter, scheduleId , ReportScheduleAssignmentId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteReportScheduleAssignment(int scheduleId, int ReportScheduleAssignmentId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                result = _dynamicReportManager.DeleteReportScheduleAssignment(scheduleId, ReportScheduleAssignmentId , dBHelper);
                if(result == GlobalErrors.Success)
                {
                    result = _dynamicReportManager.DeleteReportScheduleAssignmentDetails(ReportScheduleAssignmentId, dBHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveReportScheduleData(DynamicReportModel reportModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string headerFilterJson = string.Empty;
            try
            {
                {
                    if (reportModel.ScheduleId > -1)
                    {
                        result = _dynamicReportManager.PrepareHeaderString(reportModel, ref headerFilterJson);                        

                        if(result == GlobalErrors.Success)
                        {
                            result = _dynamicReportManager.SaveReportScheduleAssignment(reportModel, headerFilterJson);
                        }
                        if(result == GlobalErrors.Success)
                        {
                            result = _dynamicReportManager.SaveReportScheduleAssignmentDetails(reportModel);
                        }
                    }
                }                
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }              
        public GlobalErrors SendEmailOnEndOfDaySubmission(EODModel EODModel, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int languageId = _requestRepository.LanguageId;
                int numberOfDigits = _requestRepository.Configurations.NumberOfDigits;
                int numberOfStockDigits = _requestRepository.Configurations.NumberOfStockDigits;
                bool printHeaderPerPage = _requestRepository.Configurations.PrintHeaderPerPage;
                List<ReportFilterModel> reportFilter = new List<ReportFilterModel>();
                List<EmployeeModel> employeesList = new List<EmployeeModel>();
                List<DynamicReportModel> dynamicreportModel = new List<DynamicReportModel>(); 
                int PeriodTypeId = (int)ReportSchedulePeriodTypes.EndOfDaySubmission;
                int EndOfDayEmployeeId = EODModel.EmployeeId;

                result = _dynamicReportManager.GetScheudleIdForEmployee(ref EODModel);
                if(EODModel == null) 
                {
                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.MsgEmpNotConnectedtoSchedule, languageId);
                    return result = GlobalErrors.Error;
                }
                else
                {
                    result = _emailManager.GetReportScheduleEmployees(ref employeesList, EODModel.ScheduleId);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _emailManager.GetReportScheduleAssignment(ref dynamicreportModel, EODModel.ScheduleId, languageId);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _emailManager.GetReportScheduleAssignmentDetails(ref reportFilter, EODModel.ScheduleId);
                }
                if (result == GlobalErrors.Success && reportFilter.Count > 0)
                {
                    foreach (EmployeeModel employee in employeesList)
                    {
                        List<Attachment> reportPDF = new List<Attachment>();
                        string reportName = string.Empty;
                        for (int j = 0; j < dynamicreportModel.Count; j++)
                        {
                            DynamicReportModel reportModel = dynamicreportModel[j];
                            result = PrepareReportForEmployee(employee, reportModel, PeriodTypeId, reportFilter, reportPDF, languageId, numberOfDigits, numberOfStockDigits, printHeaderPerPage, ref reportName, EODModel.ActualStart, EODModel.ActualEnd, errorMessage , EndOfDayEmployeeId);
                        }
                        result = _emailService.SendReportScheduleByEmail(reportPDF, employee, EODModel.ScheduleId , languageId, reportName , errorMessage);
                    }                    
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors PrepareReportForEmployee(EmployeeModel employee, DynamicReportModel reportModel, int PeriodTypeId, List<ReportFilterModel> reportFilter, List<Attachment> reportPDF, int languageId, int numberOfDigits, int numberOfStockDigits, bool printHeaderPerPage, ref string reportName, DateTime ActualStart = default, DateTime ActualEnd = default, string errorMessage = "", int EndOfDayEmployeeId = -1)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DateTime startOfPeriod = DateTime.MinValue;
            DateTime EndOfPeriod = DateTime.MinValue;
            string path = string.Empty;
            string htmlContent = string.Empty;
            string headerPath = string.Empty;
            string folderName = string.Empty;
            string EmployeeDescription = string.Empty;
            double topMargin = 10;
            try
            {
                #region [Filters]           

                result = _sharedMethod.GetPeriodTime(ref startOfPeriod, ref EndOfPeriod, PeriodTypeId,ActualStart , ActualEnd);

                reportModel.ReportFilters = reportFilter.Where(filter =>
                reportModel.ReportScheduleAssignmentId == filter.ReportScheduleAssignmentId).ToList();

                foreach (var filter in reportModel.ReportFilters)
                {
                    if (filter.ReportFilterTypeId == ReportFilterTypes.Date || filter.ReportFilterTypeId == ReportFilterTypes.Date_Min || filter.ReportFilterTypeId == ReportFilterTypes.DateTime_Min)
                    {
                        filter.SelectedDateValue = startOfPeriod;
                    }
                    else if (filter.ReportFilterTypeId == ReportFilterTypes.Date_Max || filter.ReportFilterTypeId == ReportFilterTypes.DateTime_Max)
                    {
                        filter.SelectedDateValue = EndOfPeriod;
                    }
                }

                result = PrepareReportQuery(ref reportModel, true, employee, languageId, numberOfDigits, numberOfStockDigits , EndOfDayEmployeeId);
                #endregion

                #region [Filters Keys]
                List<KeyValueModel> deserializedFiltersData = JsonConvert.DeserializeObject<List<KeyValueModel>>(reportModel.HeaderFilterString);
                reportModel.FiltersData = deserializedFiltersData;
                KeyValueModel PeriodHeaderFilter;

                if (PeriodTypeId == ReportSchedulePeriodTypes.EndOfDaySubmission.GetHashCode())
                {
                    EmployeeDescription = _dynamicReportManager.GetEndOfDayEmployeeName(EndOfDayEmployeeId, languageId);
                    PeriodHeaderFilter = new KeyValueModel(_isEven: true, _key: "Salesperson", _value: $"{EmployeeDescription}");
                    reportModel.FiltersData.Add(PeriodHeaderFilter);
                }
                PeriodHeaderFilter = new KeyValueModel(_isEven: true, _key: "Report Period", _value: $"{startOfPeriod.ToString("dd/MM/yyyy")} - {EndOfPeriod.ToString("dd/MM/yyyy")}");                

                // Add the new item to the list
                reportModel.FiltersData.Add(PeriodHeaderFilter);

                // Set the isEven property of KeyValueModel based on the index (even or odd)
                for (int index = 0; index < reportModel.FiltersData.Count; index++)
                {
                    var filter = reportModel.FiltersData[index];
                    bool isEven = index % 2 == 0;
                    filter.isEven = isEven;
                }
                #endregion

                #region [PDF]                           
                if (result == GlobalErrors.Success)
                {
                    result = ExportReport(ref path, ref reportModel, languageId);
                    path = LocalUtilities.ReportScheduleFolderPath;
                }
                string pageFooter = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Report_Page_Footer, languageId);
                string ofString = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Of_String, languageId);
                string footer = string.Format("{0} [page] {1} [toPage]", pageFooter, ofString);
                RazorTemplateEngine.Initialize();
                htmlContent = RazorTemplateEngine.RenderAsync(path, reportModel).Result;

                if (printHeaderPerPage)
                {
                    double totalLines = 0;
                    result = _sharedMethod.PrepareCustomHeader(ref htmlContent, ref headerPath);

                    if (reportModel != null)
                    {
                        var detail = reportModel;
                        object value = null;
                        if (((IDictionary<string, object>)detail).ContainsKey("HeaderLines"))
                        {
                            ((IDictionary<string, object>)detail).TryGetValue("HeaderLines", out value);
                        }
                        if (value != null && !string.IsNullOrEmpty(value.ToString()))
                        {
                            totalLines = double.Parse(value.ToString());
                        }
                    }
                    double singleLineMargin = 7;

                    topMargin = (singleLineMargin * (totalLines));
                }

                if (result != GlobalErrors.Success) return result = GlobalErrors.Error;

                var globalSettings = new GlobalSettings
                {
                    ColorMode = ColorMode.Color,
                    Orientation = Orientation.Portrait,
                    PaperSize = PaperKind.A4,
                    DocumentTitle = reportModel.ReportName,
                    Margins = new MarginSettings { Top = topMargin, Left = 3, Right = 3 },
                    DPI = 500
                };

                var objectSettings = new ObjectSettings
                {
                    PagesCount = true,
                    HtmlContent = htmlContent,
                    WebSettings = { DefaultEncoding = "utf-8", UserStyleSheet = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "ReportsStyle.css") },
                    HeaderSettings = { FontName = "Arial", FontSize = 9, HtmUrl = headerPath },
                    FooterSettings = { FontName = "Arial", FontSize = 9, Left = DateTime.Now.ToString(), Right = footer, Spacing = 1.8 }
                };
                var pdf = new HtmlToPdfDocument()
                {
                    GlobalSettings = globalSettings,
                    Objects = { objectSettings }
                };
                reportName = reportModel.ReportName;
                if (PeriodTypeId == ReportSchedulePeriodTypes.EndOfDaySubmission.GetHashCode())
                {
                    folderName = $"{reportModel.ReportName}-{EmployeeDescription}.pdf";
                }
                else
                {
                    folderName = $"{reportModel.ReportName}.pdf";
                }

                reportPDF.Add(new Attachment(new MemoryStream(_converter.Convert(pdf)), folderName));
                #endregion  
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        // Grid Part
        public static GlobalErrors ShowGridData(string uniqueIdentifier, ref List<dynamic> data)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string queryString = string.Empty;
                result = DynamicReportManager.GetTempReportQuery(uniqueIdentifier, ref queryString);
                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(queryString))
                {
                    result = DynamicReportManager.FillGridDataSource(queryString, ref data);
                    if(result == GlobalErrors.Success)
                    {
                        result = DynamicReportManager.DeleteUsedTempRecords(uniqueIdentifier);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors MarkReportAsFavorite(int reportId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _dynamicReportManager.MarkReportAsFavorite(reportId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UnMarkReportAsFavorite(int reportId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _dynamicReportManager.UnMarkReportAsFavorite(reportId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors ExportReport(ref string reportPath, ref DynamicReportModel reportModel , int languageId = -1)
        {
            var result = GlobalErrors.NotInitialized;
            if (languageId < 0)
            {
                languageId = _requestRepository.LanguageId;
            }
            try
            {
                string path = LocalUtilities.CustomizedReportsFolderPath + languageId.ToString() + "/";
                path = Path.Combine(path, reportModel.FileName + ".cshtml");
                var data = new List<dynamic>();
                reportPath = path;

                result = DynamicReportManager.FillGridDataSource(reportModel.QueryString, ref data);
                reportModel.ReportData = data;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ExportExcel(ref DynamicReportModel reportModel)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                var data = new List<dynamic>();

                result = DynamicReportManager.FillGridDataSource(reportModel.QueryString, ref data);
                reportModel.ReportData = data;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
    }
}
