﻿using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Reflection;
using System.Linq;
using Microsoft.AspNetCore.Http;

namespace Sonic.Web.Service
{
    public class EchoService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly EchoManager _echoManager;
        private readonly CustomerService _customerService;
        private readonly LocationService _locationService;
        public static List<CustomerAppGestUserOperatorModel> CustomerAppGestUserOperators = new List<CustomerAppGestUserOperatorModel>();
        public static CustomerAppSettingsModel CustomerAppSettings = new CustomerAppSettingsModel();
        public static List<TextLanguage> CustomerAppGuestUserCaption = new List<TextLanguage>();
        private readonly ItemService _itemService;
        public EchoService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _echoManager = new EchoManager(requestRepository);
            _locationService = new LocationService(requestRepository);
            _itemService = new ItemService(requestRepository);
        }
        public GlobalErrors GetCustomerProperties(ref CustAppPropertiesModel custAppProperties)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetCustomerProperties(ref custAppProperties);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetCustomerAppDashboards(ref List<CustomerDashboardModel> list)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetCustomerAppDashboards(ref list);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors SaveCustomerProperties(CustAppPropertiesModel custAppProperties)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.SaveCustomerProperties(custAppProperties);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors SaveBanner(BannerModel banner, Collection<IFormFile> files, string hostingEnv)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                if (banner.BannerId < 0)
                {
                    banner.BannerId = GetMaxID("BannerID", "Banner", dbHelper);
                    banner.BannerName = banner.BannerId + ".png";
                    result = _echoManager.SaveBanner(banner);
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                result = _itemService.HandleImages(hostingEnv, banner.BannerId, true, files, true, _requestRepository.Configurations.AllowCustomerAppLogin, ImageMode.Banners, dbHelper);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public static int GetMaxID(string columnName, string tableName, DBHelper<int> dBHelper)
        {
            try
            {
                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object max = null;
                string query = string.Format(@"select isnull(max({0}),0)+1 from {1} ", columnName, tableName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref max);
                if (result == GlobalErrors.Success && max != null && !string.IsNullOrEmpty(max.ToString()))
                {
                    return int.Parse(max.ToString());
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return 1;
        }

        public GlobalErrors SaveFeedbackReply(FeedbackModel feedBackReply)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            NotificaitonsModel notification = new NotificaitonsModel();
            EchoCustomers customers = new EchoCustomers();
            try
            {
                result = _echoManager.SaveFeedbackReply(feedBackReply);
                if (result == GlobalErrors.Success)
                {
                    notification.Body = feedBackReply.ReplyBody;
                    notification.EmployeeId = _requestRepository.CurrentOperator.EmployeeId;
                    customers.CustomerOutletIds = feedBackReply.CustomerId + "-" + feedBackReply.OutletId;
                    notification.Customers.Add(customers);
                    notification.Subject = "Message Reply";
                    notification.TypeId = 1;
                    _customerService.SaveCustomerNotifications(notification);
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors SaveContactUsMessage(ContactUsModel message)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.SaveContactUsMessage(message);
                if (result == GlobalErrors.Success)
                    _echoManager.SendEmail(message);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors ChangePassword(OperatorModel operatorModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.ChangeCustomerPassword(operatorModel);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors UpdateCustomerProfileData(OperatorCustomerModel customerOperators)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.UpdateCustomerProfileData(customerOperators);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetCustomerAppProfileData(ref List<OperatorCustomerModel> userListData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetCustomerAppProfileData(ref userListData);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetCustomerAppFAQs(ref List<CustomerAppFAQs> customerAppFAQs)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetCustomerAppFAQs(ref customerAppFAQs);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetContactUsList(FeedbackFilterModel filter, ref SharedTableResult<FeedbackModel> sharedList)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetContactUsList(filter, ref sharedList);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetEchoItems(ref SharedTableResult<ItemPackModel> itemPacklistSharedTable)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetEchoItems(ref itemPacklistSharedTable);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors SaveEchoItems(List<ItemPackModel> PacksList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.SaveEchoItems(PacksList);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors GetEchoDivisions(ref List<DivisionModel> divisionsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetEchoDivisions(ref divisionsList);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors GetEchoCategories(int divisionId, ref List<CategoryModel> categoriesList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetEchoCategories(divisionId, ref categoriesList);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetEchoBrands(int divisionID, int itemCategoryId, ref List<BrandModel> brandsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetEchoBrands(divisionID, itemCategoryId, ref brandsList);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetEchoFirstOrderItems(GeneralFilter filter, bool getAddedItems, ref List<ItemPackModel> firstOrderFreeItems)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;

                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 1000000;

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                result = _echoManager.GetEchoFirstOrderItems(filter, getAddedItems, ref firstOrderFreeItems);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors SaveEchoFirstOrderItems(List<ItemPackModel> addedFirstOrderFreeItems)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                result = _echoManager.DeleteEchoFirstOrderItems(dBHelper);
                if (result == GlobalErrors.Success)
                {
                    if (addedFirstOrderFreeItems != null && addedFirstOrderFreeItems.Count > 0)
                    {
                        var items = addedFirstOrderFreeItems.Where(i => i.CustomerAppQuantity > 0).ToList();
                        if (items != null && items.Count > 0)
                        {
                            result = _echoManager.SaveEchoFirstOrderItems(items, dBHelper);
                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }

            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetCustomerAppSignUpFields(ref List<CustomerAppSignUpFields> signUpFields)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetCustomerAppSignUpFields(ref signUpFields);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetLocationHierarchy(ref int levelId, ref List<Country> countries, ref List<State> states, ref List<City> cities, ref List<Area> areas, ref List<Street> streets)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetLocationHierarchyConfigurationLevel(ref levelId);
                if (result == GlobalErrors.Success && levelId > 0)
                {
                    if (levelId >= GeographicalLocationHierarchyLevel.Country.GetHashCode())
                    {
                        result = _locationService.GetCountries(ref countries);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                    if (levelId >= GeographicalLocationHierarchyLevel.State.GetHashCode())
                    {
                        result = _locationService.GetStates(-1, ref states);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                    if (levelId >= GeographicalLocationHierarchyLevel.City.GetHashCode())
                    {
                        result = _locationService.GetCities(-1, -1, ref cities);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                    if (levelId >= GeographicalLocationHierarchyLevel.Area.GetHashCode())
                    {
                        result = _locationService.GetAreas(-1, -1, -1, ref areas);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                    if (levelId >= GeographicalLocationHierarchyLevel.Street.GetHashCode())
                    {
                        result = _locationService.GetStreets(-1, -1, -1, -1, ref streets);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors UpdateCustomerAppSettings(List<CustomerAppSettingsModel> customerAppSettings, List<EchoCustomeHomePageModel> customizeHomePage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                result = _echoManager.UpdateCustomerAppSettings(customerAppSettings, dBHelper);
                if (result == GlobalErrors.Success && customizeHomePage != null && customizeHomePage.Count > 0)
                {
                    result = _echoManager.UpdateCustomizeHomePage(customizeHomePage, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }

            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetCustomizeHomePage(ref List<EchoCustomeHomePageModel> customizeHomePageList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetCustomizeHomePage(ref customizeHomePageList);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetCompany(ref List<CompanyDetails> companyDetailsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetCompany(ref companyDetailsList);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetOrganizationListCompanyDetails(bool IsEditMode, ref List<OrganizationModel> organizationList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetOrganizationListCompanyDetails(IsEditMode, ref organizationList);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetCompanyDetails(int organizationId, ref CompanyDetails companyDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetCompanyDetails(organizationId, ref companyDetails);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertCompanyDetails(CompanyDetails companyDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.InsertCompanyDetails(companyDetails);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors UpdateCompanyDetails(CompanyDetails companyDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.UpdateCompanyDetails(companyDetails);
            }

            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors DeleteCompanyDetails(int organizationId, ref string errorMessage)
        {
            try
            {
                return _echoManager.DeleteCompanyDetails(organizationId, ref errorMessage);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetOrganizationListOrganizationDetails(bool IsEditMode, ref List<OrganizationModel> organizationList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetOrganizationListOrganizationDetails(IsEditMode, ref organizationList);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetOrganization(ref List<OrganizationDetails> organizationDetailsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetOrganization(ref organizationDetailsList);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetOrganizationDetails(int organizationId, ref OrganizationDetails organizationDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetOrganizationDetails(organizationId, ref organizationDetails);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertOrganizationDetails(OrganizationDetails organizationDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.InsertOrganizationDetails(organizationDetails);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors UpdateOrganizationDetails(OrganizationDetails organizationDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.UpdateOrganizationDetails(organizationDetails);
            }

            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors DeleteOrganizationDetails(int organizationId, ref string errorMessage)
        {
            try
            {
                return _echoManager.DeleteOrganizationDetails(organizationId, ref errorMessage);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerAppSettings(ref List<CustomerAppSettingsModel> customerAppSettings)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetCustomerAppSettings(ref customerAppSettings);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public static void FillEchoGuestOpratorDataAndSettings()
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                List<CustomerAppGestUserOperatorModel> GestUsers = new List<CustomerAppGestUserOperatorModel>();
                CustomerAppSettingsModel customerAppSettingsModel = new CustomerAppSettingsModel();
                List<TextLanguage> texts = new List<TextLanguage>();

                result = EchoManager.GetGestUsers(ref GestUsers);
                if (result == GlobalErrors.Success && GestUsers != null && GestUsers.Count() > 0)
                {
                    CustomerAppGestUserOperators = GestUsers;
                }

                if (result == GlobalErrors.Success)
                {
                    result = EchoManager.GetCustomerAppSettings(ref customerAppSettingsModel);
                    CustomerAppSettings = customerAppSettingsModel;
                }

                if (result == GlobalErrors.Success)
                {
                    result = EchoManager.GetCustomerSelectAppGuestUserCaption(ref texts);
                    CustomerAppGuestUserCaption = texts;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public GlobalErrors DeleteBanner(string fileName, ref string errorMessage)
        {
            try
            {
                return _echoManager.DeleteBanner(fileName, ref errorMessage);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetBanners(ref List<BannerModel> banner)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _echoManager.GetBanners(ref banner);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
    }
}
