﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Net.Mail;
using System.Reflection;
using System.Threading.Tasks;
using System.Linq;
using Sonic.Web.Core.SendEmail;
using Sonic.Web.Resources;
using InCube.Security;

namespace Sonic.Web.Service
{
    public class EmailService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly EmailManager _emailManager;
        public EmailService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _emailManager = new EmailManager(requestRepository);
        }
        public GlobalErrors GetEmailTemplateDetail(int emailTempId, ref EmailTemplateModel emailTemp)
        {
            try
            {
                return _emailManager.GetEmailTemplateDetail(emailTempId, ref emailTemp);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailTemp = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetEmailTypes(bool isExcludedTypeCRM, ref List<EmailTypeModel> emailTypes)
        {
            try
            {
                return _emailManager.GetEmailTypes(isExcludedTypeCRM,ref emailTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailTypes = null;
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetEmailTemplatesList(bool showActiveOnly, ref SharedTableResult<EmailTemplateModel> emailTempList)
        {
            try
            {
                return _emailManager.GetEmailTemplatesList(showActiveOnly, ref emailTempList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailTempList = null;
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertReportScheduleTemplate(EmailTemplateModel emailTempObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                bool isEdit = false;

                string countQuery = string.Format(@"SELECT COUNT(*) FROM ScheduleReportConfiguration");
                // get count
                object Count = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref Count);
                if (result == GlobalErrors.Success && Count != null && Count is int && (int)Count > 0 && (int)Count == 1)
                {
                    isEdit = true;
                }
                else
                {
                    isEdit = false;
                }
                if (result == GlobalErrors.Success && Count != null && Count is int && (int)Count > 1)
                {
                    string deleteQuery = string.Format(@"DELETE FROM ScheduleReportConfiguration");
                    result = dbHelper.ExecuteNonQuery(deleteQuery);
                }
                if (result == GlobalErrors.Success && isEdit)
                {
                  result = _emailManager.UpdateReportScheduleTemplate(emailTempObj, dbHelper);
                }
                else
                {
                    if(result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                    result = _emailManager.SaveReportScheduleTemplate(emailTempObj, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetReportScheduleTemplateDetail(ref EmailTemplateModel emailTemp)
        {
            try
            {
                return _emailManager.GetReportScheduleTemplateDetail(ref emailTemp);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailTemp = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors ModifyEmailTemplate(EmailTemplateModel model)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                if (model.EmailTypeId != EmailTypes.CRMOther.GetHashCode() &&  model.EmailTypeId > 0 && _emailManager.checkIfEmailTemplateTypeIsAvailable(model))
                {
                    return GlobalErrors.ValueIsMoreThanRequested;
                }
                bool isEdit = false;
                if (model.EmailTempId <= 0)
                {
                    model.EmailTempId = _emailManager.GetMaxId("EmailTemplateId", "EmailTemplate", null);
                }
                else
                {
                    isEdit = true;
                }
                if (model.EmailTempId == -1)
                {
                    return GlobalErrors.Error;
                }
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                if (isEdit)
                {
                    // EDIT
                    result = _emailManager.UpdateEmailTemplate(model, dbHelper);
                    if (result == GlobalErrors.Success)
                    {
                        result = _emailManager.DeleteEmailTemplateLanguages(model.EmailTempId, dbHelper);
                        if (result == GlobalErrors.Success)
                        {
                            result = _emailManager.SaveNewEmailTemplateLanguage(model, dbHelper);
                        }
                    }
                }
                else
                {
                    // NEW
                    result = _emailManager.SaveNewEmailTemplate(model, dbHelper);
                    if (result == GlobalErrors.Success)
                    {
                        result = _emailManager.SaveNewEmailTemplateLanguage(model, dbHelper);
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors SaveDynamicTemplate(DynamicTemplateModel dynamicTemplate)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                // New Template
                if (dynamicTemplate.TemplateId == -1)
                {
                    int templateId = _emailManager.GetMaxId("TemplateID", "DT", dBHelper);
                    if (templateId == -1 || templateId == 0)
                    {
                        return GlobalErrors.Error;
                    }

                    dynamicTemplate.TemplateId = templateId;
                    result = _emailManager.SaveNewDynamicTemplate(dynamicTemplate, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        // save [DynamicTemplateTypeLanguage]
                        result = _emailManager.SaveDynamicTemplateLanguages(dynamicTemplate.TemplateId, dynamicTemplate.DescriptionLanguages, dynamicTemplate.DisplayNameLanguages, dynamicTemplate.SubjectLanguages, dynamicTemplate.BodyLanguages, dBHelper);
                        if (result == GlobalErrors.Success)
                        {
                            // save [DynamicTempEmailType]
                            result = _emailManager.SaveDynamicTemplateEmailTypes(dynamicTemplate, dBHelper);
                            if (result == GlobalErrors.Success)
                            {
                                // save [DynamicTemplateAssignment]
                                result = _emailManager.SaveDynamicTemplateAssignment(dynamicTemplate, dBHelper);
                                if (result == GlobalErrors.Success)
                                {
                                    // save [DynamicTemplateOrganizations]
                                    result = _emailManager.SaveDynamicTemplateOrganizations(dynamicTemplate, dBHelper);
                                    if (result == GlobalErrors.Success && dynamicTemplate.DTEmailType == DynamicTemplateEmailTypes.Employee)
                                    {
                                        result = _emailManager.SaveDynamicTemplateEmailReceiver(dynamicTemplate, dBHelper);
                                    }
                                }
                            }
                        }
                    }

                }
                // Edit Template
                else
                {
                    result = _emailManager.UpdateDynamicTemplate(dynamicTemplate, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        result = _emailManager.DeleteDynamicTemplateLanguages(dynamicTemplate.TemplateId, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _emailManager.DeleteDynamicTemplateEmailTypes(dynamicTemplate.TemplateId, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _emailManager.DeleteDynamicTemplateAssignment(dynamicTemplate.TemplateId, dynamicTemplate.AllCustomers, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _emailManager.DeleteDynamicTemplateOrganizations(dynamicTemplate.TemplateId, dBHelper);
                    }
                    if (result == GlobalErrors.Success && dynamicTemplate.DTEmailType == DynamicTemplateEmailTypes.Employee)
                    {
                        result = _emailManager.DeleteDynamicTemplateEmailReceiver(dynamicTemplate.TemplateId, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _emailManager.SaveDynamicTemplateLanguages(dynamicTemplate.TemplateId, dynamicTemplate.DescriptionLanguages, dynamicTemplate.DisplayNameLanguages, dynamicTemplate.SubjectLanguages, dynamicTemplate.BodyLanguages, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _emailManager.SaveDynamicTemplateEmailTypes(dynamicTemplate, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _emailManager.SaveDynamicTemplateAssignment(dynamicTemplate, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _emailManager.SaveDynamicTemplateOrganizations(dynamicTemplate, dBHelper);
                    }
                    if (result == GlobalErrors.Success && dynamicTemplate.DTEmailType == DynamicTemplateEmailTypes.Employee)
                    {
                        result = _emailManager.SaveDynamicTemplateEmailReceiver(dynamicTemplate, dBHelper);
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;

        }

        public GlobalErrors GetDynamicTemplates(ref List<DynamicTemplateModel> dynamicTemplates, int dynamicTemplateEmailType)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _emailManager.GetDynamicTemplates(ref dynamicTemplates, dynamicTemplateEmailType);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetDynamicTemplateData(int templateId, ref DynamicTemplateModel dynamicTemplateObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<DynamicTemplateLanguageModel> tempLanguages = new List<DynamicTemplateLanguageModel>();
                // Get Main Data
                result = _emailManager.GetDynamicTemplateMainData(templateId, ref dynamicTemplateObj);
                if (result == GlobalErrors.Success)
                {
                    // Get Languages
                    result = _emailManager.GetDynamicTemplateLanguages(templateId, ref tempLanguages);
                    if (result == GlobalErrors.Success && tempLanguages != null)
                    {
                        dynamicTemplateObj.DescriptionLanguages = tempLanguages.Select(a => new TextLanguage()
                        {
                            LanguageId = a.LanguageId,
                            Description = a.Description
                        }).ToList();
                        dynamicTemplateObj.BodyLanguages = tempLanguages.Select(a => new TextLanguage()
                        {
                            LanguageId = a.LanguageId,
                            Description = a.Body
                        }).ToList();
                        dynamicTemplateObj.SubjectLanguages = tempLanguages.Select(a => new TextLanguage()
                        {
                            LanguageId = a.LanguageId,
                            Description = a.Subject
                        }).ToList();
                        dynamicTemplateObj.DisplayNameLanguages = tempLanguages.Select(a => new TextLanguage()
                        {
                            LanguageId = a.LanguageId,
                            Description = a.DisplayName
                        }).ToList();
                    }
                }

                // Get Types
                if (result == GlobalErrors.Success)
                {
                    List<DynamicTemplateReportTypeModel> tempTypes = new List<DynamicTemplateReportTypeModel>();
                    List<DynamicTemplateEmployeeReportTypes> employeeTempTypes = new List<DynamicTemplateEmployeeReportTypes>();
                    if (dynamicTemplateObj.DTEmailType == DynamicTemplateEmailTypes.Employee)
                    {
                        if (dynamicTemplateObj.HasAttachment)
                        {
                            result = _emailManager.GetEmployeeDynamicTemplate(templateId, ref employeeTempTypes);
                            if (result == GlobalErrors.Success && tempTypes != null)
                            {
                                dynamicTemplateObj.EmployeeReports = employeeTempTypes;
                            }
                        }
                        else
                        {
                            result = _emailManager.GetDynamicTemplateTypes(templateId, ref tempTypes);
                            if (result == GlobalErrors.Success && tempTypes != null)
                            {
                                dynamicTemplateObj.EmailTypes = tempTypes;
                            }

                        }
                    }
                    else
                    {
                        result = _emailManager.GetDynamicTemplateTypes(templateId, ref tempTypes);
                        if (result == GlobalErrors.Success && tempTypes != null)
                        {
                            dynamicTemplateObj.EmailTypes = tempTypes;
                        }
                    }
                }

                // Get Assignment
                if (result == GlobalErrors.Success)
                {
                    if (dynamicTemplateObj.DTEmailType == DynamicTemplateEmailTypes.Customer)
                    {


                        List<SimpleCustomerModel> tempCustomers = new List<SimpleCustomerModel>();
                        List<CustomerGroupModel> tempGroups = new List<CustomerGroupModel>();
                        List<CustomerChannelModel> tempChannels = new List<CustomerChannelModel>();

                        bool allCustomers = false;
                        result = _emailManager.IsDynamicTemplateAssignedToAllCustomers(templateId, ref allCustomers, "AllCustomers");
                        if (result == GlobalErrors.Success)
                        {
                            if (allCustomers)
                            {
                                dynamicTemplateObj.AllCustomers = allCustomers;
                            }
                            else
                            {
                                result = _emailManager.GetDynamicTemplateCustomers(templateId, ref tempCustomers);
                                if (result == GlobalErrors.Success)
                                {
                                    result = _emailManager.GetDynamicTemplateGroups(templateId, ref tempGroups);
                                }
                                if (result == GlobalErrors.Success)
                                {
                                    result = _emailManager.GetDynamicTemplateChannels(templateId, ref tempChannels);
                                }
                                if (result == GlobalErrors.Success)
                                {
                                    dynamicTemplateObj.DynamicTemplateCustomers = tempCustomers;
                                    dynamicTemplateObj.DynamicTemplateGroups = tempGroups;
                                    dynamicTemplateObj.DynamicTemplateChannels = tempChannels;
                                }
                            }

                        }
                    }
                    else
                    #region [employee]
                    if (dynamicTemplateObj.DTEmailType == DynamicTemplateEmailTypes.Employee)
                    {
                        List<EmployeeModel> employeeModelTemp = new List<EmployeeModel>();
                        List<SecurityGroupModel> securityGroupModelTemp = new List<SecurityGroupModel>();
                        List<EmployeeModel> employeeReceiverModelTemp = new List<EmployeeModel>();
                        List<SecurityGroupModel> securityGroupReceiverModelTemp = new List<SecurityGroupModel>();
                        bool allEmployees = false;
                        result = _emailManager.IsDynamicTemplateAssignedToAllCustomers(templateId, ref allEmployees, "AllEmployees");
                        if (result == GlobalErrors.Success)
                        {
                            if (allEmployees)
                            {
                                dynamicTemplateObj.AllEmployees = allEmployees;
                            }
                            else
                            {
                                result = _emailManager.GetDynamicTemplateEmployees(templateId, ref employeeModelTemp);
                                if (result == GlobalErrors.Success)
                                {
                                    result = _emailManager.GetDynamicTemplateSecurityGroups(templateId, ref securityGroupModelTemp);
                                }
                                if (result == GlobalErrors.Success)
                                {
                                    dynamicTemplateObj.DynamicTemplateEmployees = employeeModelTemp;
                                    dynamicTemplateObj.DynamicTemplateSGs = securityGroupModelTemp;
                                }
                            }
                            if (result == GlobalErrors.Success)
                            {
                                result = _emailManager.GetDynamicTemplateReceiverEmployees(templateId, ref employeeReceiverModelTemp);
                            }
                            if (result == GlobalErrors.Success)
                            {
                                result = _emailManager.GetDynamicTemplateReceiverSecurityGroups(templateId, ref securityGroupReceiverModelTemp);
                            }
                            if (result == GlobalErrors.Success)
                            {
                                dynamicTemplateObj.DynamicTemplateReceiverEmployees = employeeReceiverModelTemp;
                                dynamicTemplateObj.DynamicTemplateReceiverSGs = securityGroupReceiverModelTemp;
                            }
                        }

                        #endregion
                    }
                    else //other ReportId
                    {
                        return GlobalErrors.Error;
                    }
                }

                // Get Organizations
                if (result == GlobalErrors.Success)
                {
                    List<OrganizationModel> organizationsList = new List<OrganizationModel>();

                    result = _emailManager.GetDynamicTemplateOrganizations(templateId, ref organizationsList);
                    if (result == GlobalErrors.Success)
                    {
                        dynamicTemplateObj.OrganizationsList = organizationsList;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateEmailTypes(int emailTypeId, ref List<DynamicTemplateReportTypeModel> emailTypes)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _emailManager.GetDynamicTemplateEmailTypes(emailTypeId, ref emailTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetDynamicTemplateReportFiles(int transactionTypeId, ref List<DynamicTemplateReportFileModel> reportFiles)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                result = _emailManager.GetDynamicTemplateReportFiles(transactionTypeId, ref reportFiles);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;

        }
        public GlobalErrors UpdateDynamicTemplateActiveStatus(DynamicTemplateModel dynamicTemplate)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _emailManager.UpdateDynamicTemplateActiveStatus(dynamicTemplate);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SendEmail(ICollection<IFormFile> file, EmailModel email, EmailFilter filter = null)
        {
            return SendEmail(file, email, null, string.Empty, string.Empty, string.Empty, string.Empty, filter);
        }
        public GlobalErrors SendEmail(ICollection<IFormFile> file, EmailModel email, List<Attachment> attachments, ApprovalCycleOperations operation, int Id)
        {
            return SendEmail(file, email, null, string.Empty, string.Empty, string.Empty, string.Empty, attachments, operation, Id);
        }
        public GlobalErrors SendEmail(ICollection<IFormFile> file, EmailModel email, List<Attachment> attachments, ApprovalCycleOperations operation, string operationCode, int Id)
        {
            return SendEmail(file, email, null, string.Empty, string.Empty, string.Empty, operationCode, attachments, operation, Id);
        }
        public GlobalErrors SendEmail(ICollection<IFormFile> file, EmailModel email, MemoryStream memo, string pdfName, string printoutPath, string customerName, string note, EmailFilter filter = null)
        {
            var result = GlobalErrors.Success;
            try
            {
                if (email.EmailTempId <= 0)
                {
                    result = GlobalErrors.Error;
                }
                EmailTemplateModel emailTemp = new EmailTemplateModel();
                GlobalErrors err = _emailManager.GetEmailTemplateDetail(email.EmailTempId, ref emailTemp);
                if (emailTemp.EmailTypeId == 9)
                {
                    emailTemp.Body = emailTemp.Body.Replace("{0}", customerName).Replace("@@", "\n");
                    email.Body = emailTemp.Body;
                }
                if (emailTemp.EmailTypeId == 11)
                {
                    //emailTemp.Body = emailTemp.Body.Replace("{0}", customerName).Replace("@@", "\n");
                    email.Body = emailTemp.Body;
                }
                if(emailTemp.EmailTypeId == 18)
                {
                     emailTemp.Subject = email.Subject;
                    email.Subject = emailTemp.Subject;
                     emailTemp.Body = email.Body;
                    email.Body = emailTemp.Body;
                }
                if (err == GlobalErrors.Success && emailTemp != null)
                {
                    //var fromEmail = new MailAddress(emailTemp.Email);
                    //email.SenderEmail = emailTemp.Email;
                    //email.Subject = emailTemp.Subject;
                    //MailMessage message = new MailMessage();
                    //message.To.Add(email.ToEmail); 
                    //message.From = fromEmail;
                    //message.Subject = email.Subject;
                    //message.Body = email.Body;
                    //message.IsBodyHtml = email.IsBodyHtml;
                    //var smtp = new SmtpClient
                    //{
                    //    Host = emailTemp.ServerAddress,
                    //    Port = emailTemp.EmailPort,
                    //    EnableSsl = emailTemp.EnableSSL,
                    //    DeliveryMethod = SmtpDeliveryMethod.Network,
                    //    UseDefaultCredentials = emailTemp.EnableSSL,
                    //    Credentials = new NetworkCredential(fromEmail.Address, emailTemp.Password)
                    //};
                    //// ADD ATTACHMENT
                    //if (file != null && file.Count > 0)
                    //{
                    //    foreach (IFormFile fi in file)
                    //    {
                    //        message.Attachments.Add(new Attachment(fi.OpenReadStream(), fi.FileName));
                    //    }
                    //}
                    //if (!string.IsNullOrEmpty(pdfName) && memo != null)
                    //{
                    //    message.Attachments.Add(new Attachment(memo, pdfName));
                    //}
                    //if (!string.IsNullOrEmpty(printoutPath))
                    //{
                    //    Attachment attachment = new Attachment(printoutPath);
                    //    message.Attachments.Add(attachment);
                    //}
                    //smtp.Send(message);
                    //smtp.Dispose();
                    //_emailManager.SaveEmailHistory(email, EmailStatus.Success, note);
                    result = SendEmail(file, email, memo, printoutPath, pdfName, note, emailTemp, null, false, filter);
                }
                result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                //_emailManager.SaveEmailHistory(email, EmailStatus.Failed, ex.Message);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SendEmail(ICollection<IFormFile> file, EmailModel email, MemoryStream memo, string pdfName, string printoutPath, string customerName, string note, List<Attachment> attachmentsList, ApprovalCycleOperations operation, int Id)
        {
            string operationName = "";
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (email.EmailTempId <= 0)
                {
                    result = GlobalErrors.Error;
                }
                EmailTemplateModel emailTemp = new EmailTemplateModel();
                GlobalErrors err = _emailManager.GetEmailTemplateDetail(email.EmailTempId, ref emailTemp);
                if (emailTemp.EmailTypeId == 9)
                {
                    emailTemp.Body = emailTemp.Body.Replace("{0}", customerName).Replace("@@", "\n");
                    email.Body = emailTemp.Body;
                }
                if (emailTemp.EmailTypeId == 11)
                {
                    switch (operation)
                    {
                        case ApprovalCycleOperations.Promotions:
                            operationName = "Promotion";
                            break;
                        case ApprovalCycleOperations.Discounts:
                            operationName = "Discount";
                            break;
                        case ApprovalCycleOperations.CreditRelease:
                            operationName = "CreditRelease";
                            break;
                    }

                    emailTemp.Body = emailTemp.Body.Replace("{0}", _requestRepository.CurrentOperator.EmployeeName + " - " + _requestRepository.CurrentOperator.EmployeeCode).Replace("@@", "\n")
                        .Replace("{1}", operationName);

                    email.Body = emailTemp.Body;
                }
                if (err == GlobalErrors.Success && emailTemp != null)
                {
                    var fromEmail = new MailAddress(emailTemp.Email);
                    email.SenderEmail = emailTemp.Email;
                    email.Subject = emailTemp.Subject;
                    MailMessage message = new MailMessage();
                    message.To.Add(email.ToEmail);
                    message.From = fromEmail;
                    message.Subject = email.Subject;
                    message.Body = email.Body;
                    //message.IsBodyHtml = true;
                    var smtp = new SmtpClient
                    {
                        Host = emailTemp.ServerAddress,
                        Port = emailTemp.EmailPort,
                        EnableSsl = emailTemp.EnableSSL,
                        DeliveryMethod = SmtpDeliveryMethod.Network,
                        UseDefaultCredentials = emailTemp.EnableSSL,
                        Credentials = new NetworkCredential(fromEmail.Address, emailTemp.Password)
                    };
                    // ADD ATTACHMENT
                    foreach (Attachment att in attachmentsList)
                    {
                        message.Attachments.Add(att);
                    }
                    smtp.Send(message);
                    smtp.Dispose();
                    _emailManager.SaveEmailHistory(email, EmailStatus.Success, note);

                    //result = SendEmail(file, email, memo, printoutPath, pdfName, note, emailTemp, attachmentsList);
                }
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                _emailManager.SaveEmailHistory(email, EmailStatus.Failed, ex.Message);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SendEmail(ICollection<IFormFile> file, EmailModel email, MemoryStream memo, string printoutPath, string pdfName, string note, EmailTemplateModel emailTemp, List<Attachment> attachmentsList, bool isTransactionEmail, EmailFilter filter = null)
        {
            string failureReason = string.Empty;
            return SendEmail(file, email, memo, printoutPath, pdfName, note, emailTemp, attachmentsList, isTransactionEmail, ref failureReason, filter);
        }
        public GlobalErrors SendEmail(ICollection<IFormFile> file, EmailModel email, MemoryStream memo, string printoutPath, string pdfName, string note, EmailTemplateModel emailTemp, List<Attachment> attachmentsList, bool isTransactionEmail, ref string failureReason, EmailFilter filter = null)
        {
            var result = GlobalErrors.Success;
            try
            {
                var fromEmail = new MailAddress(emailTemp.Email);
                email.SenderEmail = emailTemp.Email;
                email.Subject = emailTemp.Subject;
                MailMessage message = new MailMessage();
                message.To.Add(email.ToEmail);
                message.From = fromEmail;
                message.Subject = email.Subject;
                message.Body = email.Body;
                message.IsBodyHtml = email.IsBodyHtml;
                var smtp = new SmtpClient
                {
                    Host = emailTemp.ServerAddress,
                    Port = emailTemp.EmailPort,
                    EnableSsl = emailTemp.EnableSSL,
                    DeliveryMethod = SmtpDeliveryMethod.Network,
                    UseDefaultCredentials = emailTemp.EnableSSL,
                    Credentials = new NetworkCredential(fromEmail.Address, emailTemp.Password)
                };
                // ADD ATTACHMENT
                if (file != null && file.Count > 0)
                {
                    foreach (IFormFile fi in file)
                    {
                        message.Attachments.Add(new Attachment(fi.OpenReadStream(), fi.FileName));
                    }
                }
                if (!string.IsNullOrEmpty(pdfName) && memo != null)
                {
                    message.Attachments.Add(new Attachment(memo, pdfName));
                }
                if (!string.IsNullOrEmpty(printoutPath))
                {
                    Attachment attachment = new Attachment(printoutPath);
                    message.Attachments.Add(attachment);
                }
                if (attachmentsList != null && attachmentsList.Count > 0)
                {
                    foreach (var attachment in attachmentsList)
                    {
                        message.Attachments.Add(attachment);
                    }

                }
                smtp.Send(message);
                smtp.Dispose();

                if (!isTransactionEmail)
                    result = _emailManager.SaveEmailHistory(email, EmailStatus.Success, note);
                else if(emailTemp.ReceiverEmployeeID > -1)
                {
                    result = _emailManager.SaveEmployeeEmailHistory(filter, emailTemp, email, EmailStatus.Success, note);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                failureReason = ex.InnerException != null ? ex.InnerException.Message : ex.Message;
                if (!isTransactionEmail)
                    _emailManager.SaveEmailHistory(email, EmailStatus.Failed, ex.Message);
                else if (emailTemp.ReceiverEmployeeID > -1)
                {
                    if (failureReason.ToLower().Contains("Unable to read data from the transport connection: The connection was closed.".ToLower()))
                        failureReason = ResourcesManager.TranslateKey(MessagesConstants.Desc_Sender_Email_Or_Password_Is_Wrong, _requestRepository.LanguageId);
                    else if (failureReason.ToLower().Contains("No such host is known.".ToLower()))
                        failureReason = ResourcesManager.TranslateKey(MessagesConstants.Desc_Sender_Server_Address_Email_Is_Wrong, _requestRepository.LanguageId);
                    else if (failureReason.ToLower().Contains("The operation has timed out.".ToLower()))
                        failureReason = ResourcesManager.TranslateKey(MessagesConstants.Desc_Sender_Email_Port_Is_Wrong, _requestRepository.LanguageId);
                    else if (failureReason.ToLower().Contains("Mailbox unavailable. The server response was".ToLower()))
                        failureReason = ResourcesManager.TranslateKey(MessagesConstants.Desc_Customer_Email_Is_Wrong, _requestRepository.LanguageId);
                    else
                        failureReason = ResourcesManager.TranslateKey(MessagesConstants.Desc_Unknown_Error, _requestRepository.LanguageId);
                    return _emailManager.SaveEmployeeEmailHistory(filter, emailTemp, email, EmailStatus.Failed, failureReason);
                }
                result = GlobalErrors.Error;
            }
            return result;
        }

        public void SendEmailAsync(ICollection<IFormFile> file, EmailModel email)
        {
            try
            {
                Task.Run(async () => await SendEmailAsyncTask(file, email));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public void SendEmailAsync(ICollection<IFormFile> file, EmailModel email, MemoryStream memo, string pdfName)
        {
            try
            {
                Task.Run(async () => await SendEmailAsyncTask(file, email, memo, pdfName));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        private async Task<GlobalErrors> SendEmailAsyncTask(ICollection<IFormFile> file, EmailModel email, MemoryStream memo, string pdfName)
        {
            try
            {
                return SendEmail(null, email, memo, pdfName, string.Empty, string.Empty, string.Empty);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        private async Task<GlobalErrors> SendEmailAsyncTask(ICollection<IFormFile> file, EmailModel email)
        {
            try
            {
                return SendEmail(file, email);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetEmailTemplateTypes(int EmailTypeId, ref EmailTemplateModel emailModel)
        {
            try
            {
                return _emailManager.GetEmailTemplateTypes(EmailTypeId, ref emailModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailModel = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SendReportScheduleByEmail(List<Attachment> attachmentReport , EmployeeModel employee , int scheduleId , int languageId , string ReportName , string errorMessage = "")
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            EmailTemplateModel templateModel = new EmailTemplateModel();
            try
            {
                result = _emailManager.GetScheduleReportConfiguration(ref templateModel , scheduleId , languageId , employee.EmployeeId);

                string subject = templateModel.Subject
                    .Replace("{0}", templateModel.Description)
                    .Replace("{1}", ReportName);

                string body = templateModel.Body
                    .Replace("{0}", templateModel.Description)
                    .Replace("{1}", ReportName);

                if (result == GlobalErrors.Success)
                {

                    string Email = templateModel.Email;
                    string Password = EncryptionManager.Instance.DecryptPassword(templateModel.Password);

                    MailMessage mail = new MailMessage();
                    mail.From = new MailAddress(Email);
                    mail.To.Add(employee.Email);
                    mail.Subject = subject;
                    mail.Body = body;

                    foreach (Attachment attachment in attachmentReport)
                    {
                        mail.Attachments.Add(attachment);
                    }
                    // Configure the SMTP client
                    SmtpClient smtpClient = new SmtpClient(templateModel.ServerAddress);
                    smtpClient.Port = templateModel.EmailPort;
                    smtpClient.Credentials = new NetworkCredential(Email, Password);
                    smtpClient.EnableSsl = templateModel.EnableSSL;

                    smtpClient.Send(mail);
                    smtpClient.Dispose();

                    result = GlobalErrors.Success;
                }
                else
                {
                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.MsgWrongEmailConfig, languageId);
                    result = GlobalErrors.Error;
                }           
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
    }
}