﻿using Newtonsoft.Json;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Http;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Sonic.Web.Service
{
    public class ExternalNotificationsService
    {
        public static GlobalErrors SendUpdateOrderNotification(ExternalOrderModel order)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                RequestRepository requestRepository = new RequestRepository();
                requestRepository.CurrentOperator = new OperatorModel();
                requestRepository.CurrentOperator.EmployeeId = 0;
                requestRepository.CurrentOperator.OperatorId = 0;
                requestRepository.LanguageId = 1;
                NotificationManager _notificationManager = new NotificationManager(requestRepository);
                DBHelper<int> dBHelper = new DBHelper<int>();
                result = _notificationManager.SendOrderUpdatedNotificationToCustomerApp(order.CustomerId, order.OutletId, order.EmployeeId, order.OrderId, order.OrderStatusId, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
    }
}
