﻿using Newtonsoft.Json;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.General;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.Services;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
namespace Sonic.Web.Service
{
    public class ImportService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ImportManager _importManager;
        private readonly SettingService _settingService;
        private readonly DocumentSequenceService _documentSequenceService;
        private readonly OrderManager _orderManager;
        private readonly ItemManager _itemManager;
        private readonly PricesAndOffersManager _pricesAndOffersManager;
        private readonly CustomerManager _customerManager;
        private readonly EmployeeManager _employeeManager;
        private readonly WebFormManager _webFormManager;
        private readonly WebFormService _webFormService;

        public ImportService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _importManager = new ImportManager(_requestRepository);
            _settingService = new SettingService(_requestRepository);
            _orderManager = new OrderManager(_requestRepository);
            _documentSequenceService = new DocumentSequenceService(_requestRepository);
            _itemManager = new ItemManager(_requestRepository);
            _pricesAndOffersManager = new PricesAndOffersManager(_requestRepository);
            _customerManager = new CustomerManager(_requestRepository);
            _employeeManager = new EmployeeManager(_requestRepository);
            _webFormManager = new WebFormManager(_requestRepository);
            _webFormService = new WebFormService(_requestRepository);
        }
        public GlobalErrors ImportFromExcelSheet(ImportDataTypes dataType, string path, ref int importedCount, ref int notImportedCount, ref List<dynamic> items, ref bool isValid, ref List<ImportedExcelErrorModel> importedExcelErrors, ref List<ImportErrorData> importErrorDataModel)
        {
            string errorMessage = string.Empty;
            return ImportFromExcelSheet(dataType, path,ref importedCount, ref notImportedCount, ref items, ref isValid, ref importedExcelErrors, ref errorMessage, -1,ref importErrorDataModel);
        }
        public GlobalErrors ImportFromExcelSheet(ImportDataTypes dataType, string path, ref int importedCount, ref int notImportedCount, ref List<dynamic> items, ref bool isValid, ref List<ImportedExcelErrorModel> importedExcelErrors, ref string errorMessage, int entryFormId, ref List<ImportErrorData> importErrorDataModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            isValid = true;
            DBHelper<int> dBHelper = null;
            bool commitNow = false;
            try
            {
                string triggerID = string.Empty;
                string tableName = string.Empty;
                string storedProcedureName = string.Empty;
                DataTable dt = new DataTable();
                Dictionary<string, object> inputParamters = new Dictionary<string, object>();
                Dictionary<string, object> outputParamters = new Dictionary<string, object>();
                Dictionary<string, object> resultParameters = new Dictionary<string, object>();
                int sheetNo = 1;
                DataTable correctExcelSheetColumns = new DataTable();

                string validationMessage = string.Empty;
                bool isValidSavedProcedure = false;
                List<WebFormActionProcedure> procedures = new List<WebFormActionProcedure>();                

                DBHelper<string> dBHelper_String = null;
                DBHelper<ImportModel> dBHelper_ImportModel = null;
                if (dataType == ImportDataTypes.AppData)
                {
                    dBHelper = new DBHelper<int>();
                    dBHelper.BeginTransaction();
                    commitNow = true;
                }
                if (dBHelper_String == null && dBHelper != null)
                    dBHelper_String = new DBHelper<string>(dBHelper.GetConnection(),dBHelper.GetDBTransaction());
                result = ImportManager.GetTableNameAndProcedureName(dataType, ref tableName, ref storedProcedureName, _requestRepository.CurrentOperator.EmployeeId, _requestRepository.SessionId);
                if (result == GlobalErrors.Success && (dataType == ImportDataTypes.ItemsPricesWithoutQtyRange || dataType == ImportDataTypes.KPIs || dataType == ImportDataTypes.ItemsPricesWithQtyRange || dataType == ImportDataTypes.MustSellItems || dataType == ImportDataTypes.CommissionCalc || dataType == ImportDataTypes.CommissionSkipPlan || dataType == ImportDataTypes.CustomerPromotion || dataType == ImportDataTypes.ExcludeCustomerPromotion || dataType == ImportDataTypes.CustomerOutletPromotion || dataType == ImportDataTypes.ExcludeCustomerOutletPromotion || dataType == ImportDataTypes.ContactCustomers))
                {
                    result = _importManager.DeleteCurrentUserDataFromTemplateTableInSQL(tableName,dBHelper);
                    if (result != GlobalErrors.Success) return result;
                }
                if (result == GlobalErrors.Success && dataType == ImportDataTypes.AppData)
                {
                    result = _importManager.DeleteTableInSQL(tableName, dBHelper);
                }
                if ((result == GlobalErrors.Success && !string.IsNullOrEmpty(tableName) && !string.IsNullOrEmpty(storedProcedureName))
                    || (string.IsNullOrEmpty(storedProcedureName) && (dataType == ImportDataTypes.ItemsPricesWithoutQtyRange || dataType == ImportDataTypes.ItemsPricesWithQtyRange))
                    || dataType == ImportDataTypes.ShopContractTargets || dataType == ImportDataTypes.MustSellItems || dataType == ImportDataTypes.CommissionCalc || dataType == ImportDataTypes.CommissionSkipPlan || dataType == ImportDataTypes.CustomerPromotion || dataType == ImportDataTypes.ExcludeCustomerPromotion || dataType == ImportDataTypes.CustomerOutletPromotion || dataType == ImportDataTypes.ExcludeCustomerOutletPromotion)
                {
                    //var filePath = Path.Combine(Directory.GetCurrentDirectory(), "wwwroot", fileName);
                    FileInfo file = new FileInfo(path);
                    if (file != null && file.Length > 0)
                    {
                        if (dataType == ImportDataTypes.KPIs || dataType == ImportDataTypes.CommissionCalc || dataType == ImportDataTypes.CommissionSkipPlan || dataType == ImportDataTypes.KPIScorecard || dataType == ImportDataTypes.TeleRepPlan || dataType == ImportDataTypes.CustomerPromotion || dataType == ImportDataTypes.CustomerOutletPromotion || dataType == ImportDataTypes.ExcludeCustomerOutletPromotion || dataType == ImportDataTypes.ExcludeCustomerPromotion)
                            sheetNo = 2;
                        if (dataType == ImportDataTypes.AppData)
                        {
                            List<string> columnNamesList = new List<string>();
                            result = _importManager.GetWebFormColumns(entryFormId, ref columnNamesList, dBHelper_String);
                            if (result == GlobalErrors.Success && columnNamesList != null && columnNamesList.Count > 0)
                            {
                                columnNamesList.ForEach(col => correctExcelSheetColumns.Columns.Add(col));
                            }
                        }
                        result = ImportManager.ValidateUploadedExcelSheetColumns(file, dataType, -1, sheetNo, ref isValid, correctExcelSheetColumns, dBHelper);
                        if (result == GlobalErrors.Success && isValid)
                        {
                            result = ImportManager.GetExcelSheetDataAsDataTable(file, sheetNo, ref dt);
                            if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0 && dataType != ImportDataTypes.ShopContractTargets)
                            {
                                result = _importManager.AddStoredProcedureNeededColumnsToDataTable(ref dt, dataType, ref triggerID);
                                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                                {
                                    result = _importManager.CreateTemplateTableInSQL(dt, tableName, dBHelper);

                                    if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                                    {
                                        result = _importManager.CopyExcelSheetTableToTemplateTableInSQL(dt, tableName, dBHelper);
                                        if (result == GlobalErrors.Success && (dataType != ImportDataTypes.CommissionCalc && dataType != ImportDataTypes.CommissionSkipPlan && dataType != ImportDataTypes.ItemsPricesWithoutQtyRange && dataType != ImportDataTypes.ItemsPricesWithQtyRange && dataType != ImportDataTypes.MustSellItems && dataType != ImportDataTypes.CustomerPromotion && dataType != ImportDataTypes.ExcludeCustomerPromotion && dataType != ImportDataTypes.CustomerOutletPromotion && dataType != ImportDataTypes.ExcludeCustomerOutletPromotion))
                                        {
                                            string inputParamter1 = "@TriggerID";
                                            string inputParamter2 = "@UserID";
                                            string inputParamter3 = "@LanguageId";
                                            string inputParamter4 = "@OrgAccess";
                                            string inputParamter5 = "@ForceCustomerOrganizationSelection";

                                            string inputParamter6 = "@DivisionAccess";
                                            string inputParamter7 = "@SupervisorAccess";
                                            string inputParamter8 = "@ExcelDateFormat";
                                            string inputParamter9 = "@NumberOfDigits";
                                            string inputParamter10 = "@NumberOfStockDigits";
                                            string inputParamter11 = "@WebFormID";

                                            string outputParameter1 = "@ResultID";
                                            string outputParameter2 = "@Message";

                                            inputParamters.Add(inputParamter1, triggerID);
                                            inputParamters.Add(inputParamter2, _requestRepository.CurrentOperator.EmployeeId);
                                            if (dataType == ImportDataTypes.KPIs || dataType == ImportDataTypes.KPIScorecard || dataType == ImportDataTypes.TeleRepPlan || dataType == ImportDataTypes.AppData) inputParamters.Add(inputParamter3, _requestRepository.LanguageId);
                                            if (dataType == ImportDataTypes.KPIScorecard || dataType == ImportDataTypes.TeleRepPlan || dataType == ImportDataTypes.AppData) inputParamters.Add(inputParamter4, _requestRepository.CurrentOperator.OrganizationAccess);
                                            if (dataType == ImportDataTypes.TeleRepPlan)
                                            {
                                                inputParamters.Add(inputParamter5, _requestRepository.Configurations.ForceCustomerOrganizationSelection);
                                                outputParamters.Add(outputParameter1, 0);
                                            }
                                            if (dataType == ImportDataTypes.AppData) 
                                            {
                                                inputParamters.Add(inputParamter6, _requestRepository.CurrentOperator.DivisionAccess);
                                                inputParamters.Add(inputParamter7, _employeeManager.GetSupervisorAccess());
                                                inputParamters.Add(inputParamter8, _requestRepository.Configurations.ExcelSheetDateFormat);
                                                inputParamters.Add(inputParamter9, _requestRepository.Configurations.NumberOfDigits);
                                                inputParamters.Add(inputParamter10, _requestRepository.Configurations.NumberOfStockDigits); 
                                                inputParamters.Add(inputParamter11, entryFormId);

                                                outputParamters.Add(outputParameter1,0);
                                                outputParamters.Add(outputParameter2, String.Empty);

                                            }
                                            result = _importManager.DeleteImportDetailsStatus(storedProcedureName, dBHelper);

                                            if (result == GlobalErrors.Success)
                                                result = _importManager.DeleteImportErrors(dBHelper);

                                            if (result == GlobalErrors.Success)
                                            {
                                                result = _importManager.ExecuteStoredProcedure(storedProcedureName, inputParamters, outputParamters, ref resultParameters, dBHelper_String);
                                                if (result == GlobalErrors.Success)
                                                {
                                                    if ((dataType == ImportDataTypes.AppData || dataType == ImportDataTypes.TeleRepPlan) && resultParameters != null && resultParameters.ContainsKey("@ResultID") && int.Parse(resultParameters.GetValueOrDefault("@ResultID").ToString()) == 2)
                                                    {
                                                        result = GlobalErrors.Error;
                                                        return result;
                                                    }
                                                    if (dataType == ImportDataTypes.KPIScorecard) tableName = "ImportScorecardResult";
                                                    List<ImportModel> importModel = new List<ImportModel>();
                                                    if(dBHelper != null)
                                                        dBHelper_ImportModel = new DBHelper<ImportModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                                                   
                                                    result = _importManager.GetImportDetailsList(tableName, triggerID, ref importModel, dBHelper_ImportModel);


                                                    result = _importManager.GetImportErrorsList(tableName, ref importErrorDataModel);

                                                    if (result == GlobalErrors.Success && importModel != null && importModel.Count > 0)
                                                    {
                                                        result = _importManager.SaveImportHistory(dataType, triggerID, importModel[0].TotalRecordsCount, importModel[0].SucceedRecordsCount, importModel[0].FailedRecordsCount, dBHelper_String);
                                                        if (result == GlobalErrors.Success)
                                                        {
                                                            importedCount = importModel[0].SucceedRecordsCount;
                                                            notImportedCount = importModel[0].FailedRecordsCount;
                                                        }
                                                    }
                                                }
                                            }
                                            if (result == GlobalErrors.Success && (dataType == ImportDataTypes.KPIs || dataType == ImportDataTypes.KPIScorecard || dataType == ImportDataTypes.TeleRepPlan || dataType == ImportDataTypes.AppData || dataType == ImportDataTypes.ContactCustomers))
                                            {
                                                DBHelper<ImportedExcelErrorModel> dBHelper_ImportedExcelErrorModel = null;
                                                if (dBHelper != null)
                                                    dBHelper_ImportedExcelErrorModel = new DBHelper<ImportedExcelErrorModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                                                result = _importManager.GetImportedExcelErrors(dataType, triggerID, ref importedExcelErrors, dBHelper_ImportedExcelErrorModel);

                                                if (result == GlobalErrors.Success && dataType == ImportDataTypes.AppData)
                                                {
                                                    result = _webFormManager.FillWebFormProcedures(entryFormId, ref procedures);
                                                    if (result == GlobalErrors.Success && procedures != null && procedures.Count > 0 && procedures.Any(p => p.ActionId == 1))
                                                    {
                                                        result = _webFormService.PerformActionProcedure("", procedures.Find(x => x.ActionId == 1).ProcedureName, ref isValidSavedProcedure, ref validationMessage, dBHelper);
                                                        if (!isValidSavedProcedure)
                                                        {
                                                            result = GlobalErrors.Error;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        else
                                        {
                                            if (result == GlobalErrors.Success && dt.Rows.Count > 0 && dataType != ImportDataTypes.MustSellItems && dataType != ImportDataTypes.CommissionCalc && dataType != ImportDataTypes.CommissionSkipPlan && dataType != ImportDataTypes.CustomerPromotion && dataType != ImportDataTypes.ExcludeCustomerPromotion && dataType != ImportDataTypes.CustomerOutletPromotion && dataType != ImportDataTypes.ExcludeCustomerOutletPromotion)
                                            {
                                                result = _pricesAndOffersManager.PreparePricesWhileImportFromExcel(ref items, ref importedCount, ref notImportedCount, dBHelper);
                                                if (result == GlobalErrors.Success)
                                                {
                                                    result = _importManager.DeleteCurrentUserDataFromTemplateTableInSQL(tableName, dBHelper);
                                                    return result;
                                                }
                                                else
                                                {
                                                    return result;
                                                }

                                            }
                                            else if (result == GlobalErrors.Success && dt.Rows.Count > 0 && dataType == ImportDataTypes.MustSellItems)
                                            {
                                                result = _itemManager.PrepareMustSellItemWhileImportFromExcel(ref items, ref importedCount, ref notImportedCount, dBHelper);
                                                if (result == GlobalErrors.Success)
                                                {
                                                    result = _importManager.DeleteCurrentUserDataFromTemplateTableInSQL(tableName, dBHelper);
                                                    return result;
                                                }
                                                else
                                                {
                                                    return result;
                                                }
                                            }
                                            else if (result == GlobalErrors.Success && dt.Rows.Count > 0 && (dataType == ImportDataTypes.CustomerPromotion || dataType == ImportDataTypes.CustomerOutletPromotion))
                                            {
                                                result = _customerManager.PrepareCustomersWhileImportFromExcel(ref items, ref importedCount, ref notImportedCount, dataType, dBHelper);
                                                if (result == GlobalErrors.Success)
                                                {
                                                    result = _importManager.DeleteCurrentUserDataFromTemplateTableInSQL(tableName, dBHelper);
                                                    return result;
                                                }
                                                else
                                                {
                                                    return result;
                                                }
                                            }
                                            else if (result == GlobalErrors.Success && dt.Rows.Count > 0 && (dataType == ImportDataTypes.ExcludeCustomerPromotion || dataType == ImportDataTypes.ExcludeCustomerOutletPromotion))
                                            {
                                                result = _customerManager.PrepareExcludeCustomersWhileImportFromExcel(ref items, ref importedCount, ref notImportedCount, dataType, dBHelper);
                                                if (result == GlobalErrors.Success)
                                                {
                                                    result = _importManager.DeleteCurrentUserDataFromTemplateTableInSQL(tableName, dBHelper);
                                                    return result;
                                                }
                                                else
                                                {
                                                    return result;
                                                }
                                            }
                                            else if (result == GlobalErrors.Success && (dataType == ImportDataTypes.CommissionCalc || dataType == ImportDataTypes.CommissionSkipPlan))
                                            {
                                                return GlobalErrors.Success;
                                            }
                                            else
                                            {
                                                return GlobalErrors.Error;
                                            }
                                        }
                                    }
                                }
                            }
                            else if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0 && dataType == ImportDataTypes.ShopContractTargets)
                            {
                              
                            }
                            else

                            {
                                if (result == GlobalErrors.Success && (dt == null || dt.Rows.Count == 0))
                                {
                                    errorMessage = MessagesConstants.Desc_Cannot_Import_Empty_Template;
                                }
                                importedCount = 0;
                                notImportedCount = 0;
                                return result = GlobalErrors.Error;
                            }

                        }
                    }
                    else
                    {
                        // empty
                        result = GlobalErrors.Error;
                    }

                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally 
            {
                if (dataType == ImportDataTypes.AppData)
                {
                    // always delete temp table
                    GlobalErrors deletionResult =  _importManager.DeleteTableInSQL($"ImportAppDataTemplate_{_requestRepository.CurrentOperator.EmployeeId}_{_requestRepository.SessionId.Replace("-", "_")}", dBHelper);
                    if (deletionResult != GlobalErrors.Success) result = GlobalErrors.Error;
                }
                if (dBHelper != null && commitNow)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }

            return result;
        }
    
        public static GlobalErrors BuildExcelSheetTemplatesBasedOnActiveLanguages()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var langauges = new List<LanguageModel>();
                result = SettingService.GetAllLanguages(ref langauges, true);

                if (result == GlobalErrors.Success && langauges.Count > 0)
                {
                    result = ImportManager.ModifyExcelSheetColumns(langauges);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ModifyDynamicExcelSheet(DataTable currentExcelSheetDataTable, int vendorID, List<ExcelSheetDynamicTemplateModel> excelSheetlist, ref DataTable expectedExcelSheetDataTable, ref string errorMsg)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string gtinString = string.Empty;
                List<string> gtinList = new List<string>();
                List<ImportItemDetailsModel> itemsDetails = new List<ImportItemDetailsModel>();
                ExcelSheetDynamicTemplateModel templateObject = new ExcelSheetDynamicTemplateModel();
                DataRow[] drDetails = null;
                string gtin = string.Empty;
                string itemCode = string.Empty;
                string uom = string.Empty;
                string currentGtin = string.Empty;
                string serial = string.Empty;
                string expiryDate = string.Empty;
                string parentSerial = string.Empty;
                string batchNo = string.Empty;
                string parentUOM = string.Empty;
                string ssccBarcode = string.Empty;
                string parentSSCCBarcode = string.Empty;
                string gtinColumnName = string.Empty;
                string serialColumnName = string.Empty;
                string expiryDateColumnName = string.Empty;
                string expiryDateFormat = string.Empty;
                string batchNoColumnName = string.Empty;
                string parentColumnName = string.Empty;
                string childColumnName = string.Empty;
                string ssccBarcodeColumnName = string.Empty;
                string parentSSCCBarcodeColumnName = string.Empty;
                string templateIDs = string.Empty;
                List<int> templateIDsList = new List<int>();
                DataRow Row = null;
                ImportItemDetailsModel importItemDetailsModel = new ImportItemDetailsModel();
                List<string> parentSerials = new List<string>();
                List<TemplateFieldModel> templateFields = new List<TemplateFieldModel>();
                gtinColumnName = excelSheetlist.First(x => x.DefaultValue == "GTIN").DynamicValue;
                List<TemplateFieldModel> currentItemtemplateField = new List<TemplateFieldModel>();
                errorMsg = string.Empty;
                if (currentExcelSheetDataTable != null && currentExcelSheetDataTable.Rows.Count > 0)
                {
                    foreach (DataRow dr in currentExcelSheetDataTable.Rows)
                    {
                        if (!gtinList.Contains(dr[gtinColumnName].ToString()) && !string.IsNullOrEmpty(dr[gtinColumnName].ToString()))
                        {
                            gtinList.Add(dr[gtinColumnName].ToString());
                            gtinString += "'" + dr[gtinColumnName].ToString() + "'" + ',';
                        }
                    }
                    if (!string.IsNullOrEmpty(gtinString))
                    {
                        gtinString = gtinString.TrimEnd(',');
                        templateIDs = string.Empty;
                        templateIDsList = new List<int>();
                        foreach (ImportItemDetailsModel itemModel in itemsDetails)
                        {
                            if (!templateIDsList.Contains(itemModel.TemplateId))
                            {
                                templateIDsList.Add(itemModel.TemplateId);
                                templateIDs += itemModel.TemplateId.ToString() + ',';
                            }
                        }
                        if (!string.IsNullOrEmpty(templateIDs))
                        {
                            templateIDs = templateIDs.TrimEnd(',');
                            result = MasterDataManager.GetTemplatesFields(templateIDs, ref templateFields);
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        templateObject.ExcelSheetTypeId = 1;
                        templateObject.VendorId = vendorID;
                        templateObject.IsEditMode = true;
                        expectedExcelSheetDataTable = new DataTable();
                        expectedExcelSheetDataTable.Columns.Add("ItemCode", typeof(string));
                        expectedExcelSheetDataTable.Columns.Add("UOM", typeof(string));
                        expectedExcelSheetDataTable.Columns.Add("FromSerial", typeof(string));
                        expectedExcelSheetDataTable.Columns.Add("ToSerial", typeof(string));
                        expectedExcelSheetDataTable.Columns.Add("ParentSerial", typeof(string));
                        expectedExcelSheetDataTable.Columns.Add("BatchNo", typeof(string));
                        expectedExcelSheetDataTable.Columns.Add("ExpiryDate", typeof(string));
                        expectedExcelSheetDataTable.Columns.Add("SSCCBarcode", typeof(string));
                        expectedExcelSheetDataTable.Columns.Add("ParentSSCCBarcode", typeof(string));

                        foreach (string gtinValue in gtinList)
                        {
                            gtin = gtinValue;
                            if (currentGtin != gtin)
                            {
                                importItemDetailsModel = new ImportItemDetailsModel();
                                currentItemtemplateField = new List<TemplateFieldModel>();
                                drDetails = currentExcelSheetDataTable.Select(string.Format(@"Gtin ='{0}'", gtin));
                                if (itemsDetails.FindIndex(available => available.GTIN == gtin) > -1)
                                    importItemDetailsModel = itemsDetails.Where(available => available.GTIN == gtin).FirstOrDefault();
                                if (templateFields.FindIndex(available => available.TemplateId == importItemDetailsModel.TemplateId) > -1)
                                    currentItemtemplateField = templateFields.Where(available => available.TemplateId == importItemDetailsModel.TemplateId).ToList();
                                if (drDetails.Length > 0 && currentItemtemplateField != null && currentItemtemplateField.Count > 0)
                                {
                                    parentUOM = importItemDetailsModel.ParentUOM;
                                    itemCode = importItemDetailsModel.ItemCode;
                                    uom = importItemDetailsModel.UOM;
                                    expiryDateColumnName = excelSheetlist.First(x => x.DefaultValue == "ExpiryDate").DynamicValue;
                                    expiryDateFormat = excelSheetlist.First(x => x.DefaultValue == "ExpiryDateFormat").DynamicValue;
                                    serialColumnName = excelSheetlist.First(x => x.DefaultValue == "Serial").DynamicValue;
                                    batchNoColumnName = excelSheetlist.First(x => x.DefaultValue == "BatchNo").DynamicValue;
                                    templateObject.SSCCLevelId = excelSheetlist[0].SSCCLevelId;
                                    templateObject.ParentLevelId = excelSheetlist[0].ParentLevelId;
                                    if (templateObject.SSCCLevelId == 1 && templateObject.ParentLevelId == 1)
                                    {
                                        parentColumnName = excelSheetlist.First(x => x.DefaultValue == "ParentSerial").DynamicValue;
                                        ssccBarcodeColumnName = excelSheetlist.First(x => x.DefaultValue == "SSCCBarcode").DynamicValue;
                                        if (string.IsNullOrEmpty(parentColumnName) || string.IsNullOrEmpty(ssccBarcodeColumnName))
                                            return GlobalErrors.Error;
                                    }
                                    else if (templateObject.SSCCLevelId == 1 && templateObject.ParentLevelId == 0)
                                    {
                                        ssccBarcodeColumnName = excelSheetlist.First(x => x.DefaultValue == "SSCCBarcode").DynamicValue;
                                        if (string.IsNullOrEmpty(ssccBarcodeColumnName))
                                            return GlobalErrors.Error;
                                    }
                                    else if (templateObject.SSCCLevelId == 2 && templateObject.ParentLevelId == 0)
                                    {
                                        ssccBarcodeColumnName = excelSheetlist.First(x => x.DefaultValue == "SSCCBarcode").DynamicValue;
                                        parentSSCCBarcodeColumnName = excelSheetlist.First(x => x.DefaultValue == "ParentSSCCBarcode").DynamicValue;
                                        if (string.IsNullOrEmpty(ssccBarcodeColumnName) || string.IsNullOrEmpty(parentSSCCBarcodeColumnName))
                                            return GlobalErrors.Error;
                                    }

                                    foreach (DataRow row in drDetails)
                                    {
                                        expiryDate = string.Empty;
                                        batchNo = string.Empty;
                                        ssccBarcode = string.Empty;
                                        parentSerial = string.Empty;
                                        parentSSCCBarcode = string.Empty;

                                        Row = expectedExcelSheetDataTable.NewRow();
                                        DateTime excelSheetDateValue;
                                        if (!string.IsNullOrEmpty(expiryDateColumnName))
                                        {
                                            if (DateTime.TryParseExact(row[expiryDateColumnName].ToString(), expiryDateFormat, System.Globalization.CultureInfo.InvariantCulture, System.Globalization.DateTimeStyles.None, out excelSheetDateValue))
                                                expiryDate = excelSheetDateValue.ToString(_requestRepository.Configurations.SerialTemplateDateFormat);
                                        }
                                        if (!string.IsNullOrEmpty(batchNoColumnName))
                                            batchNo = row[batchNoColumnName].ToString();
                                        int seq = 1;
                                        serial = string.Empty;
                                        foreach (TemplateFieldModel temp in currentItemtemplateField)
                                        {
                                            if (seq == temp.FieldSequence)
                                            {
                                                if (temp.FieldId == BarcodeTemplateFields.GTIN.GetHashCode())
                                                    serial += "01" + gtin;
                                                else if (temp.FieldId == BarcodeTemplateFields.Serial.GetHashCode() && !string.IsNullOrEmpty(row[serialColumnName].ToString()))
                                                    serial += "21" + row[serialColumnName].ToString();
                                                else if (temp.FieldId == BarcodeTemplateFields.BatchNumber.GetHashCode() && !string.IsNullOrEmpty(batchNo))
                                                    serial += "10" + batchNo;
                                                else if (temp.FieldId == BarcodeTemplateFields.ExpiryDate.GetHashCode() && !string.IsNullOrEmpty(expiryDate))
                                                    serial += "17" + expiryDate;
                                            }
                                            seq++;
                                        }
                                        if (!string.IsNullOrEmpty(row[gtinColumnName].ToString()))
                                        {
                                            if (templateObject.SSCCLevelId == 1 && templateObject.ParentLevelId == 1)
                                            {
                                                if (!string.IsNullOrEmpty(row[ssccBarcodeColumnName].ToString()))
                                                    ssccBarcode = row[ssccBarcodeColumnName].ToString().Replace(")", "").Replace("(", "");
                                                if (!string.IsNullOrEmpty(row[parentColumnName].ToString()))
                                                    parentSerial = row[parentColumnName].ToString().Replace(")", "").Replace("(", "");
                                                if (!parentSerials.Contains(itemCode + "@" + parentUOM + "@" + ssccBarcode + "@" + parentSerial + "@" + batchNo + "@" + expiryDate))
                                                    parentSerials.Add(itemCode + "@" + parentUOM + "@" + ssccBarcode + "@" + parentSerial + "@" + batchNo + "@" + expiryDate);
                                                expectedExcelSheetDataTable.Rows.Add(new object[] { itemCode, uom, serial, serial, parentSerial, batchNo, expiryDate, ssccBarcode, "" });
                                            }
                                            else if (templateObject.SSCCLevelId == 2 && templateObject.ParentLevelId == 0)
                                            {
                                                if (!string.IsNullOrEmpty(row[parentSSCCBarcodeColumnName].ToString()))
                                                    parentSSCCBarcode = row[parentSSCCBarcodeColumnName].ToString().Replace(")", "").Replace("(", "");
                                                if (!string.IsNullOrEmpty(row[ssccBarcodeColumnName].ToString()))
                                                    ssccBarcode = row[ssccBarcodeColumnName].ToString().Replace(")", "").Replace("(", "");
                                                expectedExcelSheetDataTable.Rows.Add(new object[] { itemCode, uom, serial, serial, "", batchNo, expiryDate, ssccBarcode, parentSSCCBarcode });
                                            }
                                            else if (templateObject.SSCCLevelId == 1 && templateObject.ParentLevelId == 0)
                                            {
                                                if (!string.IsNullOrEmpty(row[ssccBarcodeColumnName].ToString()))
                                                    ssccBarcode = row[ssccBarcodeColumnName].ToString().Replace(")", "").Replace("(", "");
                                                expectedExcelSheetDataTable.Rows.Add(new object[] { itemCode, uom, serial, serial, "", batchNo, expiryDate, ssccBarcode, "" });
                                            }
                                        }
                                    }

                                }
                                else if (currentItemtemplateField == null || (currentItemtemplateField != null && currentItemtemplateField.Count == 0) || importItemDetailsModel.TemplateId == -1)
                                {
                                    errorMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_Barcode_Not_Compatible_With_Template, _requestRepository.LanguageId);
                                    return GlobalErrors.Error;
                                }
                            }
                            currentGtin = gtin;
                        }
                        if (templateObject.SSCCLevelId == 1 && templateObject.ParentLevelId == 1)
                        {
                            if (parentSerials != null && parentSerials.Count > 0)
                            {
                                string[] palletParent = null;
                                foreach (string parentSer in parentSerials)
                                {
                                    palletParent = parentSer.Split("@");
                                    if (palletParent != null && palletParent.Length > 0)
                                        expectedExcelSheetDataTable.Rows.Add(new object[] { palletParent[0], palletParent[1], palletParent[3], palletParent[3], "", palletParent[4], palletParent[5], palletParent[2], "" });
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        #region[Import for AppData screens]
        public GlobalErrors DownloadDynamicExcelTemplate(int entryFormId, ref string errorMessage ,ref string contentType, ref string fileName, ref MemoryStream memory) 
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<string> columnNames = new List<string>();

                contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                fileName = "AppDataTemplate.xlsx";

                #region[Get WebFormEntry columns]
                result = _importManager.GetWebFormColumns(entryFormId, ref columnNames);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                if (columnNames == null || columnNames.Count == 0) 
                {
                    errorMessage = "";
                    return GlobalErrors.Error;
                }
                #endregion
                result = _importManager.GenerateExcelSheet(columnNames, ref memory);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion
    }
    static class Extensions
    {
        public static IList<T> Clone<T>(this IList<T> listToClone) where T : ICloneable
        {
            return listToClone.Select(item => (T)item.Clone()).ToList();
        }
    }
    public static class ExtensionMethods
    {
        public static T DeepCopy<T>(this T self)
        {
            var serialized = JsonConvert.SerializeObject(self);
            return JsonConvert.DeserializeObject<T>(serialized);
        }
    }
}
