﻿using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Reflection.Metadata;

namespace Sonic.Web.Service
{
    public class ItemService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ItemManager _itemManager;
        private readonly MasterDataService _masterDataService;
        private readonly NotificationService _notificationService;
        public ItemService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _itemManager = new ItemManager(requestRepository);
            _masterDataService = new MasterDataService(requestRepository);
            _notificationService = new NotificationService(null,_requestRepository);

        }
        #region [GENERAL METHODS]

        public GlobalErrors GetItemCategoryList(ref List<ItemCategoryModel> categoryList)
        {
            try
            {
                return _itemManager.GetItemCategoryList(ref categoryList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                categoryList = null;
                return GlobalErrors.Error;
            }
        }
        public static GlobalErrors FillItemsImages(string rootPath)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = ItemManager.FillItemsImages(rootPath);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors ValidateItemListToSave(ItemListModel itemListModel, ref bool isValid, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                bool isUniqueItemListCode = false;
                string excludedString = String.Empty;
                string tableName = itemListModel.OOSListMode ? "OOSListHeader" : "ItemsList";
                string columnName = itemListModel.OOSListMode ? "OOSItemsListCode" : "ItemListCode";
                string idColumnName = itemListModel.OOSListMode ? "OOSItemsListID" : "ItemListID";

                excludedString = string.Format(" And {0} != {1}", idColumnName, itemListModel.ItemListId);

                result = _masterDataService.CheckIfUniqueValue(tableName, columnName, itemListModel.ItemListCode, excludedString, ref isUniqueItemListCode);
                if (result == GlobalErrors.Success && !isUniqueItemListCode)
                {
                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Unique_Code, _requestRepository.LanguageId);
                    isValid = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public static GlobalErrors FillCategoriesImages(string rootPath)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = ItemManager.FillCategoriesImages(rootPath);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public static GlobalErrors FillBrandsImages(string rootPath)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = ItemManager.FillBrandsImages(rootPath);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetItemsLazyLoading(GeneralFilter filter, ref SharedTableResult<ItemPackModelSimple> ItemsListTable)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;

                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 1000000; // get all items

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }

                return _itemManager.GetItemsLazyLoading(filter, ref ItemsListTable);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                ItemsListTable = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetItemGroupLoading(GeneralFilter filter, ref SharedTableResult<ItemGroupModel> ItemsListTable)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;

                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 1000000; // get all items

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }

                return _itemManager.GetItemGroupLazyLoading(filter, ref ItemsListTable);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                ItemsListTable = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllItems(GeneralFilter itemsFilter, ref SharedTableResult<ItemPackModel> itemList)
        {
            try
            {
                if (itemsFilter.CustomListFilter != null && itemsFilter.CustomListFilter.Page < 0)
                    itemsFilter.CustomListFilter.Page = 0;
                if (itemsFilter.CustomListFilter != null && itemsFilter.CustomListFilter.PageSize <= 0)
                    itemsFilter.CustomListFilter.PageSize = 100;
                if (itemsFilter.CustomListFilter != null && !string.IsNullOrEmpty(itemsFilter.CustomListFilter.SearchFilter))
                {
                    itemsFilter.CustomListFilter.SearchFilter = itemsFilter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                int stockWHId = -1;
                switch (itemsFilter.FormProcessMode)
                {
                    case ItemFormProcessMode.Sales:
                    case ItemFormProcessMode.OutputVoucher:
                    case ItemFormProcessMode.TransferOut:
                    case ItemFormProcessMode.LoadRequest:
                    case ItemFormProcessMode.MoveOrder:
                        stockWHId = itemsFilter.WarehouseId;
                        break;
                    case ItemFormProcessMode.TransferIn:
                    case ItemFormProcessMode.InputVoucher:
                        stockWHId = itemsFilter.WarehouseId;
                        break;
                    case ItemFormProcessMode.Orders:
                        if (itemsFilter.EmployeeId != -1)
                        {
                            //int vanID = -1;
                            //vanID = _warehouseManager.GetVehicleConnectedToEmployee(itemsFilter.EmployeeId);
                            //if (vanID == -1)
                            //{
                            //    //return GlobalErrors.Error;
                            //}
                            //int wHID = -1;
                            //wHID = _warehouseManager.GetVehicleLoadingWH(vanID);
                            //if (wHID != -1)
                            //{
                            //    stockWHId = wHID;
                            //}
                        }
                        break;

                    case ItemFormProcessMode.OffLoad:
                        stockWHId = itemsFilter.VehicleId;
                        break;

                    default:
                        stockWHId = -1;
                        break;
                }
                return _itemManager.GetAllItems(itemsFilter, ref itemList, stockWHId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllItemsWithCustomerOperations(int divisionId, int warehouseId, int customerId, int outletId, ItemFormProcessMode processMode, ref List<ItemPackModel> itemsList, ref List<ItemStockBatches> itemsStock,ref List<PriceRangeModel> PriceRangeList, bool includeTax, string editedTransactionItemIds, string editedTransactionPackIds, string orderSignature, string loadingWarehouses, string excludedOrderID, bool showQuantityInOrder, int orderTypeId, bool restictReturnFromInvoices, int sdcId , int requestedBy)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                #region [Get Items]
                bool checkAvailabilityItemLevel = false;
                bool checkAvailabilityBatchLevel = false;
                string returnOrderItemsString = string.Empty;
                if (processMode == ItemFormProcessMode.Delivery || processMode == ItemFormProcessMode.PartialDelivery || processMode == ItemFormProcessMode.SSCCFromDelivery)
                {
                    checkAvailabilityItemLevel = _requestRepository.Configurations.AffectMainWarehouseUponOrderBOInvoicing && !_requestRepository.Configurations.AllowBatchSelectionInDelivery;
                    checkAvailabilityBatchLevel = _requestRepository.Configurations.AffectMainWarehouseUponOrderBOInvoicing && _requestRepository.Configurations.AllowBatchSelectionInDelivery;
                }
                else if (((processMode == ItemFormProcessMode.Sales || processMode == ItemFormProcessMode.ExchangeReturn) && _requestRepository.Configurations.LimitBOSalesToWarehouseStock)) 
                {
                    checkAvailabilityItemLevel = true;
                }
                else if (processMode == ItemFormProcessMode.Orders && orderTypeId == OrderTypes.Sales.GetHashCode())
                {
                    checkAvailabilityItemLevel = true;
                }
                bool isCRM = false;
                bool includePrices = true;
                if (processMode == ItemFormProcessMode.SerialReassignment)
                {
                    includePrices = false;
                }
                bool restrictItemsInReturn = false;
                result = _itemManager.GetAllItemsNew(divisionId, warehouseId, -1, customerId, outletId, processMode, ref itemsList, isCRM, includePrices, checkAvailabilityItemLevel, includeTax, editedTransactionItemIds, editedTransactionPackIds, orderSignature, loadingWarehouses, excludedOrderID, showQuantityInOrder, restrictItemsInReturn, returnOrderItemsString, sdcId, requestedBy, orderTypeId);
                #endregion

                #region [Discount]
                if (result == GlobalErrors.Success && itemsList != null && itemsList.Count > 0 && orderTypeId != 2)
                {
                    List<ItemDiscountModel> discountList = new List<ItemDiscountModel>();
                    result = ItemManager.GetAllDiscount(customerId, outletId, divisionId, sdcId, _requestRepository.Configurations.EnableSalesDistributionChannel,ref discountList,false, _requestRepository.CurrentOperator.OrganizationAccess, string.Empty, _requestRepository.CurrentOperator.EmployeeId);
                    if (result == GlobalErrors.Success && discountList != null && discountList.Count > 0)
                    {
                        var numberOfDigits = _requestRepository.Configurations.NumberOfDigits;
                        itemsList.ForEach(i =>
                        {
                            var discount = discountList.Find(d => d.PackId == i.PackId);
                            if (discount != null && discount.Discount > 0)
                            {
                                i.Discount = discount.Discount;
                                i.BaseDiscount = discount.Discount;
                                i.DiscountTypeId = discount.DiscountTypeId;
                                i.BaseDiscountTypeId = discount.DiscountTypeId;
                                i.CalculatedDiscount = discount.DiscountTypeId == 1 ? i.Price * (i.Discount / 100) : i.Discount;
                            }
                            i.RetailValue = !_requestRepository.Configurations.CalculateRetailTaxBasedOnGeneralPriceList ? i.RetailValue : (i.Price - i.CalculatedDiscount) * i.RetailTax / 100;
                        });
                    }
                }
                #endregion

                #region[Build stock for items]
                if (result == GlobalErrors.Success)
                {
                    if (checkAvailabilityItemLevel)
                    {
                        List<int> allItemIdsList = itemsList.Select(c => c.ItemId).Distinct().ToList();
                        decimal avlInWH = 0;

                        if (result == GlobalErrors.Success)
                        {
                            ItemStockBatches batch = null;
                            foreach (int itemId in allItemIdsList)
                            {
                                batch = new ItemStockBatches();
                                avlInWH = 0;
                                if (processMode == ItemFormProcessMode.Orders && orderTypeId == OrderTypes.Sales.GetHashCode())
                                {
                                    avlInWH = itemsList.Where(item => item.ItemId == itemId).First().StockQty;
                                }
                                else
                                {
                                    avlInWH = itemsList.Where(item => item.ItemId == itemId).First().AvailableQtyInPcs;
                                }
                                batch.ItemId = itemId;
                                batch.AvailableQtyInPcs = avlInWH;
                                batch.ActualAvailableQtyInPcs = batch.AvailableQtyInPcs;
                                batch.ExpiryDate = LocalUtilities.DefaultExpiryDate;
                                batch.BatchNo = LocalUtilities.DefaultBatchNo;
                                batch.RequiredQty = 0;
                                batch.IsNewBatch = false;
                                itemsStock.Add(batch);
                            }
                        }
                    }
                     if (!string.IsNullOrEmpty(editedTransactionPackIds) && !string.IsNullOrEmpty(editedTransactionItemIds) &&
                       orderTypeId == OrderTypes.Return.GetHashCode() && restictReturnFromInvoices)
                    {
                        //..instead of foreach.
                        //string ids = string.Empty;
                        //List<ReturnFromInvoiceBatchStock> packTotals1 = new List<ReturnFromInvoiceBatchStock>();

                        //List<ItemPackModel> editedItemsList = 
                        //itemsList.Where(item => editedTransactionItemIds.Contains(item.ItemId.ToString())).ToList();
                        //itemsList.RemoveAll(item => editedTransactionItemIds.Contains(item.ItemId.ToString()));
                        //editedItemsList.ForEach(i => {
                        //    packTotals1 = new List<ReturnFromInvoiceBatchStock>();
                        //    result = _itemManager.GetReturnOrderItemsBatchesList(customerId, outletId, i.ItemId, false, true, ref ids, ref packTotals1);
                        //    if (result == GlobalErrors.Success && packTotals1 != null && packTotals1.Count > 0)
                        //    {
                        //        i.ReturnFromInvoiceBatchStockList = packTotals1;
                        //    }
                        //});
                        //itemsList.AddRange(editedItemsList);
                        //..
                        // Editing return order with items returned from invoices.
                        // get pack details from customerbatcheslist to calculate pack totals in edit.
       

                    }
                }
                #endregion
                #region[Build Batches for order items]
                if (itemsList != null && itemsList.Count > 0 && processMode == ItemFormProcessMode.SSCCFromDelivery && !_requestRepository.Configurations.UseDefaultExpiryAndBatchForItems)
                {
                    //var index = itemsList.FindIndex(i => !i.InStock && !i.InSCS);
                    //if (index >= 0)
                    //{
                        List<ItemPackModel> tempItemsList = new List<ItemPackModel>(itemsList);
                        itemsList = new List<ItemPackModel>();
                        ItemStockBatches tempBatch = new ItemStockBatches();
                        foreach (ItemPackModel item in tempItemsList)
                        {
                            tempBatch = new ItemStockBatches();
                            tempBatch.ItemId = item.ItemId;
                            tempBatch.PackId = item.PackId;
                            tempBatch.PiecesInPack = item.PiecesInPack;
                            tempBatch.Quantity = item.Quantity;
                            tempBatch.BatchNo = item.BatchNo;
                            tempBatch.ExpiryDate = item.ExpiryDate;
                            tempBatch.ExpiryDateModel = item.ExpiryDateModel;
                            tempBatch.SalesTransactionTypeId = item.SalesTransactionTypeId.GetHashCode();
                            if (itemsList.FindIndex(i => i.ItemId == item.ItemId && i.PackId == item.PackId) == -1)
                            {
                                item.OrderDetailsBatches = new List<ItemStockBatches>();
                                item.OrderDetailsBatches.Add(tempBatch);
                                itemsList.Add(item);
                            }
                            else if(itemsList.Find(i => i.ItemId == item.ItemId && i.PackId == item.PackId).OrderDetailsBatches.FindIndex(b => b.BatchNo == item.BatchNo && b.ExpiryDate == item.ExpiryDate && b.SalesTransactionTypeId == item.SalesTransactionTypeId.GetHashCode()) == -1)
                            {
                                itemsList.Find(i => i.ItemId == item.ItemId && i.PackId == item.PackId).Quantity += item.Quantity;
                                itemsList.Find(i => i.ItemId == item.ItemId && i.PackId == item.PackId).OrderDetailsBatches.Add(tempBatch);
                            }
                            else
                            {
                                itemsList.Find(i => i.ItemId == item.ItemId && i.PackId == item.PackId).Quantity += item.Quantity;
                                itemsList.Find(i => i.ItemId == item.ItemId && i.PackId == item.PackId).OrderDetailsBatches.Find(b => b.BatchNo == item.BatchNo && b.ExpiryDate == item.ExpiryDate).RequiredQty += item.RequiredQty;
                            }

                        }
                    }
               // }
                #endregion
                #region [build PriceRangeList for items]
                int priceListId;
                int returnPriceListId;
                DBHelper<PriceRangeModel> dbHelper = null;
                string returnJoin = string.Empty;
                dbHelper = new DBHelper<PriceRangeModel>();
                string query = string.Empty;
                string taxJoin = string.Empty;
                string PriceCal = string.Empty;
                string priceListIds = string.Empty;
                List<ItemPackModel> allItems = new List<ItemPackModel>();
                if (itemsList != null && itemsList.Count > 0)
                {
                    priceListId = (int)itemsList[0].UsedPriceListId;
                    allItems = itemsList.Where(x => x.UsedPriceListId != priceListId).ToList();
                    if (allItems != null && allItems.Count > 0)
                    {
                        priceListIds = string.Join(',', allItems.Select(x => x.UsedPriceListId).Distinct().ToList());
                    }
                    returnPriceListId = itemsList.Find(x => x.ReturnUsedPriceListID != -1) != null ? (int)itemsList.Find(x => x.ReturnUsedPriceListID != -1).ReturnUsedPriceListID : -1;
                    if (includeTax)
                    {
                        if(_requestRepository.Configurations.IncludeTaxInPrice)
                        {
                            taxJoin = string.Format(@" ,0 AS Tax");
                            PriceCal = string.Format(@" (isnull(Tax,0)/100) * isnull(Price,0) + isnull(Price,0) AS price , Tax AS TaxIncludedInPrice , ISNULL(Price,0) AS BasePrice");
                        }
                        else
                        {
                            taxJoin = string.Format(@" ,Tax");
                            PriceCal = string.Format(@" Price , ISNULL(Price,0) AS BasePrice");
                        }
                    }
                    else
                    {
                        PriceCal = string.Format(@" Price , ISNULL(Price,0) AS BasePrice ");
                    }
                    if (_requestRepository.Configurations.UseReturnPriceListForReturns && (processMode == ItemFormProcessMode.Return || processMode == ItemFormProcessMode.ExchangeReturn))
                    {
                        returnJoin = string.Format(@" union 
					    select distinct PriceList.PriceListID PriceListId,PriceDefinition.PacKID PackId,PriceDefinition.Price,RangeStart,RangeEnd,1 isReturnItem {1},MinPrice,MaxPrice
                        from PriceList 
					    inner join PriceDefinition on PriceDefinition.PriceListID = PriceList.PriceListID and PriceList.PriceListTypeID = 2
                        inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID
                        where
					    PriceList.PriceListID = {0} And PriceList.IsDeleted = 0 ", returnPriceListId, taxJoin);
                    }
                    query = string.Format(@"select PriceList.PriceListID PriceListId,PacKID PackId,{4},RangeStart,RangeEnd,0 isReturnItem {2},MinPrice,MaxPrice
                    from PriceList 
                    Inner Join PriceDefinition on PriceList.PriceListID = PriceDefinition.PriceListID
                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID
                    where PriceList.PriceListID in ({0} {3}) And  PriceList.IsDeleted = 0
                    {1} ", priceListId, returnJoin, taxJoin, !string.IsNullOrEmpty(priceListIds)? ','+ priceListIds: priceListIds , PriceCal);

                    result = dbHelper.GetQueryList(query, ref PriceRangeList);
                    List<ItemPackModel> newItemList = itemsList;
                    List<PriceRangeModel> finalRangePriceList = PriceRangeList.Where(e => !newItemList.Any(item => item.PackId == e.PackId && item.UsedPriceListId != e.PriceListId)).ToList();
                    PriceRangeList = finalRangePriceList;
                }
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemsList = null;
                itemsStock = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        //public GlobalErrors GetAllItemsWarehouseOperations(int divisionId, int stockWarehouseId, int detailsWarehouseId, int refWarehouseId, ItemFormProcessMode processMode, ref List<ItemPackModel> itemsList, ref List<ItemStockBatches> itemsStock, string editedTransactionId, WarehouseTransactionStatus status, string editedTransactionItemIds, string editedTransactionPackIds, int vendorId, bool isQualityControl, bool allowAddingNewItems, bool isExecuteOperation, int requestedBy)
        //{
        //    return GetAllItemsWarehouseOperations(divisionId, stockWarehouseId, detailsWarehouseId, refWarehouseId, processMode, ref itemsList, ref itemsStock, editedTransactionId, status, editedTransactionItemIds, editedTransactionPackIds, vendorId, isQualityControl, allowAddingNewItems, isExecuteOperation, requestedBy, string.Empty);
        //}
        public GlobalErrors GetAllItemsWarehouseOperations(int selectedEmployeeId, int divisionId, int stockWarehouseId, int detailsWarehouseId, int refWarehouseId, ItemFormProcessMode processMode, ref List<ItemPackModel> itemsList, ref List<ItemStockBatches> itemsStock, ref List<PriceRangeModel> PriceRangeList, string editedTransactionId, WarehouseTransactionStatus status, string editedTransactionItemIds, string editedTransactionPackIds, int vendorId, bool isQualityControl, bool allowAddingNewItems, bool isExecuteOperation, int requestedBy, string stockCountingTaskId,string purchaseOrderId, ref List<ROIPackModel> roiPackList,string ssccBarcode ,bool isFullyOffload)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool checkAvailabilityItemLevel = false;
            bool checkAvailabilityBatchLevel = false;
            bool calculatePendingQty = false;
            bool excludeZeroAndMinusStock = false;
            bool getOnlyBatchesSavedInDetails = false;
            WarehouseTransactionOperation WHOperationToCalculatePendingQty = WarehouseTransactionOperation.LoadRequest;
            string vehicleWhJoin = string.Empty;
            string vehicleSelectedQuantity = string.Empty;

            try
            {
                #region[Check Availability]
                if (processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.SSCCFromLoadExecute || processMode == ItemFormProcessMode.SSCCFromMainList)
                {
                    if (_requestRepository.Configurations.CheckMainWHStockForLoad)
                    {
                        if (_requestRepository.Configurations.AllowTripGeneration || _requestRepository.Configurations.UseDefaultExpiryAndBatchForItems || !_requestRepository.Configurations.AllowBatchSelectionInWarehouseOperations)
                        {
                            checkAvailabilityItemLevel = true;
                        }
                        else if (!_requestRepository.Configurations.UseDefaultExpiryAndBatchForItems && _requestRepository.Configurations.AllowBatchSelectionInWarehouseOperations)
                        {
                            checkAvailabilityBatchLevel = true;
                        }
                        if (_requestRepository.Configurations.AutoExecuteLoadRequestInBO)
                        {
                            calculatePendingQty = false;
                            excludeZeroAndMinusStock = true;
                            if (!string.IsNullOrEmpty(editedTransactionId) && !isExecuteOperation) // edit FO load request when AutoExecuteLoadRequestInBO is true
                            {
                                calculatePendingQty = true;
                            }
                        }
                        else if ((!_requestRepository.Configurations.AutoExecuteLoadRequestInBO && !isExecuteOperation) || (processMode == ItemFormProcessMode.SSCCFromLoadExecute))
                        {
                            calculatePendingQty = true;
                        }
                    }
                    else if (!_requestRepository.Configurations.UseDefaultExpiryAndBatchForItems)
                    {
                        getOnlyBatchesSavedInDetails = true;
                    }


                }
                else if (processMode == ItemFormProcessMode.OffLoad || processMode == ItemFormProcessMode.OutputVoucher || processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.MoveOrder || processMode == ItemFormProcessMode.ROIIncommingReturnsWithoutRef)
                {
                    excludeZeroAndMinusStock = true;

                    if (_requestRepository.Configurations.UseDefaultExpiryAndBatchForItems || !_requestRepository.Configurations.AllowBatchSelectionInWarehouseOperations || (_requestRepository.Configurations.AllowTripGeneration && processMode == ItemFormProcessMode.MoveOrder))
                    {
                        checkAvailabilityItemLevel = true;
                    }
                    else if (!_requestRepository.Configurations.UseDefaultExpiryAndBatchForItems && _requestRepository.Configurations.AllowBatchSelectionInWarehouseOperations)
                    {
                        checkAvailabilityBatchLevel = true;
                    }
                    if (processMode == ItemFormProcessMode.OffLoad && (
                        (!_requestRepository.Configurations.AutoExecuteOffloadRequestInBO && !isExecuteOperation) ||
                        (_requestRepository.Configurations.AutoExecuteOffloadRequestInBO && !string.IsNullOrEmpty(editedTransactionId) && !isExecuteOperation)
                        ))
                    {
                        calculatePendingQty = true;
                    }
                }
                else if (processMode == ItemFormProcessMode.TransferIn)
                {
                    // here we will get stock from transfer-out items that connected with this transfer in
                    getOnlyBatchesSavedInDetails = true;
                }
                //if(processMode== ItemFormProcessMode.SSCCFromLoadExecute)
                //{
                //    limitAvailabilityToWhTransDetailsOnly = true;
                //}
                #endregion

                #region[Get Items]
                bool isCRM = false;
                bool includePrices = true;
                bool includeTax = _requestRepository.Configurations.AllowTax && _requestRepository.Configurations.AllowTaxInWarehouseOperations;
                bool joinWithStock = true;// checkAvailabilityItemLevel || checkAvailabilityBatchLevel || processMode == ItemFormProcessMode.TransferIn || processMode == ItemFormProcessMode.InputVoucher;
                result = _itemManager.GetAllItemsNew(selectedEmployeeId, divisionId, stockWarehouseId, detailsWarehouseId, refWarehouseId, -1, -1, processMode, ref itemsList, isCRM, includePrices, joinWithStock, includeTax, editedTransactionItemIds, editedTransactionPackIds, string.Empty, vendorId, isQualityControl, allowAddingNewItems, requestedBy, stockCountingTaskId, purchaseOrderId, string.Empty, string.Empty, false,false,string.Empty,-1,-1);
                #endregion

                #region[Build Stock]
                if (result == GlobalErrors.Success && itemsList != null && itemsList.Count > 0)
                {
                    if (processMode == ItemFormProcessMode.OffLoad)
                    {
                        WHOperationToCalculatePendingQty = WarehouseTransactionOperation.Offload;
                    }
                    int numberOfContainerItems = itemsList.FindAll(x => x.ItemTypeId == ItemTypes.Container.GetHashCode()).Count;
                    #region[Build stock for all items if use default batch]

                    List<ItemStockBatches> reservedVehicleSerialsItemsList = null;
                    List<ItemStockBatches> reservedMWHSerialsItemsList = null;
                    List<ItemStockBatches> itemsPendingQtyList = null;
                    List<ItemStockBatches> itemsSSCCPendingQtyList = null;
                    string ssccLoadTransactions = string.Empty;
                    List<int> allItemIdsList = itemsList.Select(c => c.ItemId).Distinct().ToList();
                    string allItemsIdsString = string.Join(",", allItemIdsList.Select(n => n.ToString()).ToArray());
                    string allSerialItemsIdsString = string.Join(",", itemsList.Where(item => item.HasSerialNumber).Select(c => c.ItemId).Distinct().ToList());
                    decimal avlInWH = 0;
                    decimal pendingQty = 0;
                    decimal reservedSerialsQtyInVehicle = 0;
                    decimal reservedSerialsQtyInWarehouse = 0;
                    decimal warehouseQty = 0;
                    decimal vehicleQty = 0;



                    if (result == GlobalErrors.Success)
                    {
                        ItemStockBatches batch = null;
                        foreach (int itemId in allItemIdsList)
                        {
                            avlInWH = 0;
                            pendingQty = 0;
                            vehicleQty = 0;
                            warehouseQty = 0;
                            reservedSerialsQtyInVehicle = 0;
                            reservedSerialsQtyInWarehouse = 0;

                            avlInWH = itemsList.Where(item => item.ItemId == itemId).First().AvailableQtyInPcs;

                            if (itemsSSCCPendingQtyList != null && itemsSSCCPendingQtyList.Any(item => item.ItemId == itemId))
                            {
                                pendingQty = itemsSSCCPendingQtyList.Where(item => item.ItemId == itemId).ToList().Sum(x => x.AvailableQtyInPcs);
                            }
                            if (calculatePendingQty && itemsPendingQtyList != null && itemsPendingQtyList.Any(item => item.ItemId == itemId))
                            {
                                pendingQty += itemsPendingQtyList.Where(item => item.ItemId == itemId).ToList().Sum(x => x.AvailableQtyInPcs);
                            }
                            if (reservedVehicleSerialsItemsList != null && reservedVehicleSerialsItemsList.Any(item => item.ItemId == itemId))
                            {
                                reservedSerialsQtyInVehicle = reservedVehicleSerialsItemsList.First(item => item.ItemId == itemId).ReservedQtyInPCs;
                            }
                            if (reservedMWHSerialsItemsList != null && reservedMWHSerialsItemsList.Any(item => item.ItemId == itemId))
                            {
                                reservedSerialsQtyInWarehouse = reservedMWHSerialsItemsList.First(item => item.ItemId == itemId).ReservedQtyInPCs;
                            }

                            itemsList.Where(item => item.ItemId == itemId).ToList().ForEach(x =>
                            {
                                if (processMode == ItemFormProcessMode.OffLoad)
                                {
                                    avlInWH -= reservedSerialsQtyInVehicle;
                                    vehicleQty = avlInWH;
                                    warehouseQty = x.WarehouseAvailableQtyInPCs - reservedSerialsQtyInWarehouse;
                                }
                                else
                                {
                                    avlInWH -= reservedSerialsQtyInWarehouse;
                                    vehicleQty = x.VehicleAvailableQtyInPCs - reservedSerialsQtyInVehicle;
                                    warehouseQty = avlInWH;
                                }
                                x.VehicleAvailableQtyInPCs = vehicleQty;
                                x.WarehouseAvailableQtyInPCs = warehouseQty;
                                x.PendingQtyInPcs = pendingQty;
                                x.AvailableQtyInPcs = avlInWH - pendingQty;
                            });
                            if (checkAvailabilityItemLevel || itemsList.Where(item => item.ItemId == itemId).First().ItemTypeId == ItemTypes.Container.GetHashCode())
                            {
                                batch = new ItemStockBatches();
                                batch.ItemId = itemId;
                                batch.PendingQtyInPcs = pendingQty;
                                batch.VehicleAvailableQtyInPCs = vehicleQty;
                                batch.WarehouseAvailableQtyInPCs = warehouseQty;
                                batch.AvailableQtyInPcs = avlInWH - pendingQty;
                                batch.ActualAvailableQtyInPcs = batch.AvailableQtyInPcs;
                                batch.ExpiryDate = LocalUtilities.DefaultExpiryDate;
                                batch.BatchNo = LocalUtilities.DefaultBatchNo;
                                batch.RequiredQty = 0;
                                batch.IsNewBatch = false;
                                itemsStock.Add(batch);
                            }
                        }
                    }
                    #endregion

                    #endregion
                }
                #endregion

                #region[ROI Get Prices Discount & Tax]
                if (result == GlobalErrors.Success && itemsList != null && itemsList.Count > 0)
                {
                    roiPackList = new List<ROIPackModel>();
                    string menu = string.Empty;
                    switch (processMode)
                    {
                        case ItemFormProcessMode.DamagedStock:
                            menu = CoreDataBaseConstants.WebMenusConstants.DamagedStock;
                            break;
                        case ItemFormProcessMode.ManufacturingDefects:
                            menu = CoreDataBaseConstants.WebMenusConstants.ManufacturingDefects;
                            break;
                        case ItemFormProcessMode.ROIIncomming:
                            menu = CoreDataBaseConstants.WebMenusConstants.Incoming;
                            break;
                        case ItemFormProcessMode.ROIIncommingReturns:
                            menu = CoreDataBaseConstants.WebMenusConstants.IncomingReturns;
                            break;
                        case ItemFormProcessMode.ROIIncommingWithoutRef:
                            menu = CoreDataBaseConstants.WebMenusConstants.IncommingWithoutRef;
                            break;
                        case ItemFormProcessMode.ROIIncommingReturnsWithoutRef:
                            menu = CoreDataBaseConstants.WebMenusConstants.IncommingReturnsWithoutRef;
                            break;
                    }
                    //if (!string.IsNullOrEmpty(menu))
                    //{
                    //    result = ROIManager.GetROIPrices(stockWarehouseId, refWarehouseId, menu, ref roiPackList);
                    //}
                }
                #endregion
                #region [build PriceRangeList for items]
                int priceListId;
                DBHelper<PriceRangeModel> dbHelper = null;
                dbHelper = new DBHelper<PriceRangeModel>();
                string query = string.Empty;
                string taxJoin = string.Empty;
                string priceListIds = string.Empty;
                List<ItemPackModel> allItems = new List<ItemPackModel>();
                if (itemsList != null && itemsList.Count > 0)
                {
                    priceListId = (int)itemsList[0].UsedPriceListId;
                    allItems = itemsList.Where(x => x.UsedPriceListId != priceListId).ToList();
                    if (allItems != null && allItems.Count > 0)
                    {
                        priceListIds = string.Join(',', allItems.Select(x => x.UsedPriceListId).Distinct().ToList());
                    }
                    if (_requestRepository.Configurations.AllowTax && _requestRepository.Configurations.AllowTaxInWarehouseOperations)
                    {
                        taxJoin = string.Format(@" ,Tax");
                    }
                    query = string.Format(@"select PriceList.PriceListID PriceListId,PacKID PackId,Price,RangeStart,RangeEnd,0 isReturnItem {1}
                    from PriceList 
                    Inner Join PriceDefinition on PriceList.PriceListID = PriceDefinition.PriceListID
                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID
                    where PriceList.PriceListID in ({0} {2}) And  PriceList.IsDeleted = 0", priceListId, taxJoin, !string.IsNullOrEmpty(priceListIds) ? ',' + priceListIds : priceListIds);

                    result = dbHelper.GetQueryList(query, ref PriceRangeList);
                    List<ItemPackModel> newItemList = itemsList;
                    List<PriceRangeModel> finalRangePriceList = PriceRangeList.Where(e => !newItemList.Any(item => item.PackId == e.PackId && item.UsedPriceListId != e.PriceListId)).ToList();
                    PriceRangeList = finalRangePriceList;
                }
                #endregion
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemsList = null;
                itemsStock = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllItemsCategoryView(int divisionId, int customerId, int outletId, string warehouseIds, ref List<ItemCategoryModel> categoryList, bool onlyCRM)
        {
            try
            {
                TimeSpan ts = new TimeSpan();
                Stopwatch stopWatch = new Stopwatch();
                string elapsedTime = string.Empty;

                if (customerId <= 0 || outletId <= 0)
                {
                    return GlobalErrors.Error;
                }
                List<ItemPackModel> itemList = null;
                bool includePrices = true;
                bool checkAvl = false;
                bool includeTax = _requestRepository.Configurations.AllowTax && CustomerManager.IsTaxableOutlet(customerId, outletId);
                string editedTransactionItemIds = string.Empty;
                string editedTransactionPackIds = string.Empty;
                onlyCRM = true;
                GlobalErrors err = _itemManager.GetAllItemsNew(divisionId, -1, -1, customerId, outletId, ItemFormProcessMode.Orders, ref itemList, onlyCRM, includePrices, checkAvl, includeTax, editedTransactionItemIds, editedTransactionPackIds, string.Empty, warehouseIds, string.Empty, false, false, string.Empty, -1,-1,-1);
                //GlobalErrors err = _itemManager.GetAllItemsNew(divisionId, -1, customerId, outletId, ItemFormProcessMode.Orders, ref itemList, onlyCRM, includePrices, checkAvl, includeTax, editedTransactionItemIds, editedTransactionPackIds);
                if (err == GlobalErrors.Success)
                {
                    if (itemList != null && itemList.Count > 0)
                    {
                        string packIdsString = string.Join(',', itemList.Select(x => x.PackId).Distinct().ToList());
                        bool isBRFCRM = onlyCRM && _requestRepository.Configurations.ConsiderStockStatusInWarehouseStock && _requestRepository.Configurations.ConsiderStockStatusInOrderFlow;
                        if (isBRFCRM)
                        {
                            #region[Get Price Discount]
                            List<ItemDiscountModel> priceDiscountList = new List<ItemDiscountModel>();
                            err = ItemManager.GetAllDiscount(customerId, outletId, divisionId, -1, _requestRepository.Configurations.EnableSalesDistributionChannel, ref priceDiscountList,true, _requestRepository.CurrentOperator.OrganizationAccess, packIdsString, _requestRepository.CurrentOperator.EmployeeId);
                            if (err != GlobalErrors.Success) return GlobalErrors.Error;
                            
                            stopWatch = new Stopwatch();
                            stopWatch.Start();
                            
                            if (priceDiscountList != null && priceDiscountList.Count > 0)
                            {
                                itemList.Where(itm => priceDiscountList.Select(disc => disc.PackId).Contains(itm.PackId)).ToList().ForEach(i =>
                                {
                                    var priceDiscount = priceDiscountList.Find(d => d.PackId == i.PackId && d.SalesOrderTypeId == i.SalesOrderTypeId);
                                    if (priceDiscount != null && priceDiscount.Discount > 0)
                                    {
                                        // price discount is always percentage.
                                        //i.Price = i.Price * (1 - priceDiscount.Discount / 100); // price discount will never applied on orginal price
                                        i.ApprovalPrice = i.ApprovalPrice * (1 - priceDiscount.Discount / 100);
                                        i.MinPrice = i.MinPrice * (1 - priceDiscount.Discount / 100);
                                        if (_requestRepository.Configurations.ApplyDiscountOnMaxPrice) i.MaxPrice = i.MaxPrice * (1 - priceDiscount.Discount / 100);
                                    }
                                });
                            }

                            stopWatch.Stop();
                            ts = stopWatch.Elapsed;
                            elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                            ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Price Discount", elapsedTime);

                            #endregion

                            #region[Prepare Items By Stock Status]

                            stopWatch = new Stopwatch();
                            stopWatch.Start();

                            List<ItemPackModel> itemsByStock = prepareItemsByStockStatus(itemList);
                            if (itemsByStock == null || itemsByStock.Count == 0) return GlobalErrors.Error;
                            itemList = itemsByStock;

                            stopWatch.Stop();
                            ts = stopWatch.Elapsed;
                            elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                            ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Stock Status View", elapsedTime);
                            #endregion
                        }

                        List<ItemDiscountModel> discountList = new List<ItemDiscountModel>();
                        err = ItemManager.GetAllDiscount(customerId, outletId, divisionId, -1, _requestRepository.Configurations.EnableSalesDistributionChannel, ref discountList,false, _requestRepository.CurrentOperator.OrganizationAccess, packIdsString, _requestRepository.CurrentOperator.EmployeeId);
                        
                        stopWatch = new Stopwatch();
                        stopWatch.Start();
                        
                        if (err == GlobalErrors.Success && discountList != null && discountList.Count > 0)
                        {
                            itemList.ForEach(i =>
                            {
                                var discount = discountList.Find(d => d.PackId == i.PackId);
                                if (discount != null && discount.Discount > 0)
                                {
                                    i.Discount = discount.Discount;
                                    i.DiscountTypeId = discount.DiscountTypeId;
                                }
                            });
                        }
                        stopWatch.Stop();
                        ts = stopWatch.Elapsed;
                        elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                        ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Normal Discount", elapsedTime);


                        stopWatch = new Stopwatch();
                        stopWatch.Start();

                        categoryList = new List<ItemCategoryModel>();
                        categoryList = itemList.GroupBy(c => c.ItemCategoryId).Select(c => c.First()).ToList().Select(c => new ItemCategoryModel
                        {
                            ItemCategoryId = c.ItemCategoryId,
                            Code = c.CategoryCode,
                            Name = c.Category,
                            ItemsList = itemList.Where(i => i.ItemCategoryId == c.ItemCategoryId).ToList()
                        }).ToList();

                        stopWatch.Stop();
                        ts = stopWatch.Elapsed;
                        elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                        ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Category View", elapsedTime);

                        return err;
                    }
                }
                return err;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                categoryList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllItemsWithStockStatus(int divisionId, int customerId, int outletId, string warehouseIds, ref List<CRMSimpleItemPackModel> itemList, bool onlyCRM, int customerOrganizationId)
        {
            try
            {
                TimeSpan ts = new TimeSpan();
                Stopwatch stopWatch = new Stopwatch();
                string elapsedTime = string.Empty;
                
                bool includeTax = _requestRepository.Configurations.AllowTax && CustomerManager.IsTaxableOutlet(customerId, outletId);
                GlobalErrors err = _itemManager.ExecuteCRMItemsWithStockStatusProcedure(customerId, outletId, warehouseIds, customerOrganizationId, includeTax, ref itemList);
                if (err == GlobalErrors.Success)
                {
                    if (itemList != null && itemList.Count > 0)
                    {
                        string packIdsString = string.Join(',', itemList.Select(x => x.PackId).Distinct().ToList());
                        bool isBRFCRM = onlyCRM && _requestRepository.Configurations.ConsiderStockStatusInWarehouseStock && _requestRepository.Configurations.ConsiderStockStatusInOrderFlow;
                        if (isBRFCRM)
                        {
                            #region[Get Price Discount]
                            List<ItemDiscountModel> priceDiscountList = new List<ItemDiscountModel>();
                            err = ItemManager.GetAllDiscount(customerId, outletId, divisionId, -1, _requestRepository.Configurations.EnableSalesDistributionChannel, ref priceDiscountList, true, _requestRepository.CurrentOperator.OrganizationAccess, packIdsString, _requestRepository.CurrentOperator.EmployeeId);
                            if (err != GlobalErrors.Success) return GlobalErrors.Error;

                            stopWatch = new Stopwatch();
                            stopWatch.Start();

                            if (priceDiscountList != null && priceDiscountList.Count > 0)
                            {
                                itemList.Where(itm => priceDiscountList.Select(disc => disc.PackId).Contains(itm.PackId)).ToList().ForEach(i =>
                                {
                                    var priceDiscount = priceDiscountList.Find(d => d.PackId == i.PackId && d.SalesOrderTypeId == i.SalesOrderTypeId);
                                    if (priceDiscount != null && priceDiscount.Discount > 0)
                                    {
                                        // price discount is always percentage.
                                        //i.Price = i.Price * (1 - priceDiscount.Discount / 100); // price discount will never applied on orginal price
                                        i.ApprovalPrice = i.ApprovalPrice * (1 - priceDiscount.Discount / 100);
                                        i.MinPrice = i.MinPrice * (1 - priceDiscount.Discount / 100);
                                        if (_requestRepository.Configurations.ApplyDiscountOnMaxPrice) i.MaxPrice = i.MaxPrice * (1 - priceDiscount.Discount / 100);
                                    }
                                });
                            }

                            stopWatch.Stop();
                            ts = stopWatch.Elapsed;
                            elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                            ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Price Discount", elapsedTime);

                            #endregion

                            #region[Prepare Items By Stock Status]
                            //stopWatch = new Stopwatch();
                            //stopWatch.Start();

                            //itemsByStock = CRMPrepareItemsByStockStatusSimple(itemList);
                            //if (itemsByStock == null || itemsByStock.Count == 0) return GlobalErrors.Error;

                            //stopWatch.Stop();
                            //ts = stopWatch.Elapsed;
                            //elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                            //ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Stock Status View", elapsedTime);
                            #endregion
                        }

                        List<ItemDiscountModel> discountList = new List<ItemDiscountModel>();
                        err = ItemManager.GetAllDiscount(customerId, outletId, divisionId, -1, _requestRepository.Configurations.EnableSalesDistributionChannel, ref discountList, false, _requestRepository.CurrentOperator.OrganizationAccess, packIdsString, _requestRepository.CurrentOperator.EmployeeId);

                        stopWatch = new Stopwatch();
                        stopWatch.Start();

                        if (err == GlobalErrors.Success && discountList != null && discountList.Count > 0)
                        {
                            itemList.ForEach(i =>
                            {
                                var discount = discountList.Find(d => d.PackId == i.PackId);
                                if (discount != null && discount.Discount > 0)
                                {
                                    i.Discount = discount.Discount;
                                    i.DiscountTypeId = discount.DiscountTypeId;
                                }
                            });
                        }
                        stopWatch.Stop();
                        ts = stopWatch.Elapsed;
                        elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                        ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Normal Discount", elapsedTime);


                        //stopWatch = new Stopwatch();
                        //stopWatch.Start();

                        //categoryList = new List<CRMSimpleItemCategoryModel>();
                        //categoryList = itemsByStock.GroupBy(c => c.ItemCategoryId).Select(c => c.First()).ToList().Select(c => new CRMSimpleItemCategoryModel
                        //{
                        //    ItemCategoryId = c.ItemCategoryId,
                        //    Code = c.CategoryCode,
                        //    Name = c.Category,
                        //    ItemsList = itemsByStock.Where(i => i.ItemCategoryId == c.ItemCategoryId).ToList()
                        //}).ToList();

                        //stopWatch.Stop();
                        //ts = stopWatch.Elapsed;
                        //elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                        //ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Category View", elapsedTime);

                        return err;
                    }
                }
                return err;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                itemList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors CRMGetAllItemsCategoryView(int divisionId, int customerId, int outletId, string warehouseIds, ref List<CRMItemCategoryModel> categoryList, bool onlyCRM)
        {
            try
            {
                TimeSpan ts = new TimeSpan();
                Stopwatch stopWatch = new Stopwatch();
                string elapsedTime = string.Empty;

                if (customerId <= 0 || outletId <= 0)
                {
                    return GlobalErrors.Error;
                }
                List<CRMItemPackModel> itemList = null;
                bool includePrices = true;
                bool checkAvl = false;
                bool includeTax = _requestRepository.Configurations.AllowTax && CustomerManager.IsTaxableOutlet(customerId, outletId);
                string editedTransactionItemIds = string.Empty;
                string editedTransactionPackIds = string.Empty;
                onlyCRM = true;
                GlobalErrors err = _itemManager.CRMGetAllItemsNew(divisionId, -1, -1, customerId, outletId, ItemFormProcessMode.Orders, ref itemList, onlyCRM, includePrices, checkAvl, includeTax, editedTransactionItemIds, editedTransactionPackIds, string.Empty, warehouseIds, string.Empty, false, false, string.Empty, -1, -1, -1);
                //GlobalErrors err = _itemManager.GetAllItemsNew(divisionId, -1, customerId, outletId, ItemFormProcessMode.Orders, ref itemList, onlyCRM, includePrices, checkAvl, includeTax, editedTransactionItemIds, editedTransactionPackIds);
                if (err == GlobalErrors.Success)
                {
                    if (itemList != null && itemList.Count > 0)
                    {
                        string packIdsString = string.Join(',', itemList.Select(x => x.PackId).Distinct().ToList());
                        bool isBRFCRM = onlyCRM && _requestRepository.Configurations.ConsiderStockStatusInWarehouseStock && _requestRepository.Configurations.ConsiderStockStatusInOrderFlow;
                        if (isBRFCRM)
                        {
                            #region[Get Price Discount]
                            List<ItemDiscountModel> priceDiscountList = new List<ItemDiscountModel>();
                            err = ItemManager.GetAllDiscount(customerId, outletId, divisionId, -1, _requestRepository.Configurations.EnableSalesDistributionChannel, ref priceDiscountList, true, _requestRepository.CurrentOperator.OrganizationAccess, packIdsString, _requestRepository.CurrentOperator.EmployeeId);
                            if (err != GlobalErrors.Success) return GlobalErrors.Error;

                            stopWatch = new Stopwatch();
                            stopWatch.Start();

                            if (priceDiscountList != null && priceDiscountList.Count > 0)
                            {
                                itemList.Where(itm => priceDiscountList.Select(disc => disc.PackId).Contains(itm.PackId)).ToList().ForEach(i =>
                                {
                                    var priceDiscount = priceDiscountList.Find(d => d.PackId == i.PackId && d.SalesOrderTypeId == i.SalesOrderTypeId);
                                    if (priceDiscount != null && priceDiscount.Discount > 0)
                                    {
                                        // price discount is always percentage.
                                        //i.Price = i.Price * (1 - priceDiscount.Discount / 100); // price discount will never applied on orginal price
                                        i.ApprovalPrice = i.ApprovalPrice * (1 - priceDiscount.Discount / 100);
                                        i.MinPrice = i.MinPrice * (1 - priceDiscount.Discount / 100);
                                        if (_requestRepository.Configurations.ApplyDiscountOnMaxPrice) i.MaxPrice = i.MaxPrice * (1 - priceDiscount.Discount / 100);
                                    }
                                });
                            }

                            stopWatch.Stop();
                            ts = stopWatch.Elapsed;
                            elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                            ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Price Discount", elapsedTime);

                            #endregion

                            #region[Prepare Items By Stock Status]

                            stopWatch = new Stopwatch();
                            stopWatch.Start();

                            List<CRMItemPackModel> itemsByStock = CRMprepareItemsByStockStatus(itemList);
                            if (itemsByStock == null || itemsByStock.Count == 0) return GlobalErrors.Error;
                            itemList = itemsByStock;

                            stopWatch.Stop();
                            ts = stopWatch.Elapsed;
                            elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                            ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Stock Status View", elapsedTime);
                            #endregion
                        }

                        List<ItemDiscountModel> discountList = new List<ItemDiscountModel>();
                        err = ItemManager.GetAllDiscount(customerId, outletId, divisionId, -1, _requestRepository.Configurations.EnableSalesDistributionChannel, ref discountList, false, _requestRepository.CurrentOperator.OrganizationAccess, packIdsString, _requestRepository.CurrentOperator.EmployeeId);

                        stopWatch = new Stopwatch();
                        stopWatch.Start();

                        if (err == GlobalErrors.Success && discountList != null && discountList.Count > 0)
                        {
                            itemList.ForEach(i =>
                            {
                                var discount = discountList.Find(d => d.PackId == i.PackId);
                                if (discount != null && discount.Discount > 0)
                                {
                                    i.Discount = discount.Discount;
                                    i.DiscountTypeId = discount.DiscountTypeId;
                                }
                            });
                        }
                        stopWatch.Stop();
                        ts = stopWatch.Elapsed;
                        elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                        ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Normal Discount", elapsedTime);


                        stopWatch = new Stopwatch();
                        stopWatch.Start();

                        categoryList = new List<CRMItemCategoryModel>();
                        categoryList = itemList.GroupBy(c => c.ItemCategoryId).Select(c => c.First()).ToList().Select(c => new CRMItemCategoryModel
                        {
                            ItemCategoryId = c.ItemCategoryId,
                            Code = c.CategoryCode,
                            Name = c.Category,
                            ItemsList = itemList.Where(i => i.ItemCategoryId == c.ItemCategoryId).ToList()
                        }).ToList();

                        stopWatch.Stop();
                        ts = stopWatch.Elapsed;
                        elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                        ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Prepare Category View", elapsedTime);

                        return err;
                    }
                }
                return err;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                categoryList = null;
                return GlobalErrors.Error;
            }
        }

        public List<ItemPackModel> prepareItemsByStockStatus(List<ItemPackModel>  itemsList)
        {
            List<ItemPackModel> preparedItemsList = new List<ItemPackModel>();
            try
            {
                if (itemsList != null && itemsList.Count > 0)
                {
                    preparedItemsList = itemsList.GroupBy(i => new { i.ItemId, i.PackId })
                        .Select(grp => new ItemPackModel
                        {
                            ItemId = grp.Key.ItemId,
                            PackId = grp.Key.PackId,
                            ItemName = grp.FirstOrDefault().ItemName,
                            ItemCode = grp.FirstOrDefault().ItemCode,
                            ItemCodeName = grp.FirstOrDefault().ItemCodeName,
                            Uom = grp.FirstOrDefault().Uom,
                            ItemCategoryId = grp.FirstOrDefault().ItemCategoryId,
                            Category = grp.FirstOrDefault().Category,
                            CategoryCode = grp.FirstOrDefault().CategoryCode,
                            CategoryNameCode = grp.FirstOrDefault().CategoryNameCode,
                            PiecesInPack = grp.FirstOrDefault().PiecesInPack,
                            AvailableQtyInPcs = grp.Sum(el => el.AvailableQtyInPcs),
                            StockQty = grp.Sum(el => el.StockQty),
                            StockStatusItemsList = grp.OrderBy(x => x.StockStatusId).ToList()
                        }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
            return preparedItemsList;
        }
        public List<CRMItemPackModel> CRMprepareItemsByStockStatus(List<CRMItemPackModel> itemsList)
        {
            List<CRMItemPackModel> preparedItemsList = new List<CRMItemPackModel>();
            try
            {
                if (itemsList != null && itemsList.Count > 0)
                {
                    preparedItemsList = itemsList.GroupBy(i => new { i.ItemId, i.PackId })
                        .Select(grp => new CRMItemPackModel
                        {
                            ItemId = grp.Key.ItemId,
                            PackId = grp.Key.PackId,
                            ItemName = grp.FirstOrDefault().ItemName,
                            ItemCode = grp.FirstOrDefault().ItemCode,
                            ItemCodeName = grp.FirstOrDefault().ItemCodeName,
                            Uom = grp.FirstOrDefault().Uom,
                            ItemCategoryId = grp.FirstOrDefault().ItemCategoryId,
                            Category = grp.FirstOrDefault().Category,
                            CategoryCode = grp.FirstOrDefault().CategoryCode,
                            CategoryNameCode = grp.FirstOrDefault().CategoryNameCode,
                            PiecesInPack = grp.FirstOrDefault().PiecesInPack,
                            AvailableQtyInPcs = grp.Sum(el => el.AvailableQtyInPcs),
                            StockQty = grp.Sum(el => el.StockQty),
                            StockStatusItemsList = grp.OrderBy(x => x.StockStatusId).ToList()
                        }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
            return preparedItemsList;
        }
        //public List<CRMSimpleMainItemPackModel> CRMPrepareItemsByStockStatusSimple(List<CRMSimpleItemPackModel> itemsList)
        //{
        //    List<CRMSimpleMainItemPackModel> preparedItemsList = new List<CRMSimpleMainItemPackModel>();
        //    try
        //    {
        //        if (itemsList != null && itemsList.Count > 0)
        //        {
        //            preparedItemsList = itemsList.GroupBy(i => new { i.ItemId, i.PackId })
        //                .Select(grp => new CRMSimpleMainItemPackModel
        //                {
        //                    ItemId = grp.Key.ItemId,
        //                    PackId = grp.Key.PackId,
        //                    ItemName = grp.FirstOrDefault().ItemName,
        //                    ItemCode = grp.FirstOrDefault().ItemCode,
        //                    ItemCodeName = grp.FirstOrDefault().ItemCodeName,
        //                    Uom = grp.FirstOrDefault().Uom,
        //                    ItemCategoryId = grp.FirstOrDefault().ItemCategoryId,
        //                    Category = grp.FirstOrDefault().Category,
        //                    CategoryCode = grp.FirstOrDefault().CategoryCode,
        //                    CategoryNameCode = grp.FirstOrDefault().CategoryNameCode,
        //                    PiecesInPack = grp.FirstOrDefault().PiecesInPack,
        //                    AvailableQtyInPcs = grp.Sum(el => el.AvailableQtyInPcs),
        //                    StockQty = grp.Sum(el => el.StockQty),
        //                    StockStatusItemsList = grp.OrderBy(x => x.StockStatusId).ToList()
        //                }).ToList();
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return null;
        //    }
        //    return preparedItemsList;
        //}
        public GlobalErrors GetDivisions(GeneralFilter filter, ref List<DivisionModel> divisionList)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (filter.EmployeeId != 0 && filter.CustomerId != 0)
                {
                    result = _itemManager.GetEmpOutDivisions(filter, ref divisionList);
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllDivisions(int selectedEmployeeId, ref List<DivisionModel> divisionList)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                DivisionFilter filter = new DivisionFilter();
                filter.EmployeeId = selectedEmployeeId;
                return GetAllDivisions(filter, ref divisionList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAllDivisions(DivisionFilter filter, ref List<DivisionModel> divisionList) 
        {
            List<TextLanguage> descriptions = new List<TextLanguage>();
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                result = _itemManager.GetAllDivisions(filter, ref divisionList);
                if (result == GlobalErrors.Success)
                {
                    foreach (DivisionModel division in divisionList)
                    {
                        descriptions = new List<TextLanguage>();
                        result = _itemManager.GetDivisionLanguages(division.DivisionId, ref descriptions);
                        if (result != GlobalErrors.Success) break;
                        division.DescriptionLanguages = descriptions;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetAllMasterGroup(ref List<MasterItemGroupModel> masterGroupList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _itemManager.GetAllMasterGroup(ref masterGroupList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors IsDivisionLinkedToCustomerAccount(int customerId, int outletId, int divisionId, ref bool isLinked)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _itemManager.IsDivisionLinkedToCustomerAccount(customerId, outletId, divisionId, ref isLinked);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDivisionsUnderOrgAccess(ref List<DivisionModel> divisionsList, bool checkEmployeeAccess , bool isFromStaffEmployeeOrgAccess)
        {
            try
            {
                return _itemManager.GetDivisionsUnderOrgAccess(ref divisionsList, checkEmployeeAccess, isFromStaffEmployeeOrgAccess);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                divisionsList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetDivisionsAccessForEmployee(ref List<DivisionModel> divisionsList, int employeeID)
        {
            try
            {
                return _itemManager.GetDivisionsAccessForEmployee(ref divisionsList, employeeID);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                divisionsList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllItemsList(int divisionId, int customerId, int outletId, ref List<ItemPackModel> itemsList)
        {
            try
            {
                if (customerId <= 0 || outletId <= 0)
                {
                    return GlobalErrors.Error;
                }
                bool includePrices = true;
                bool checkAvl = false;
                bool includeTax = _requestRepository.Configurations.AllowTax && CustomerManager.IsTaxableOutlet(customerId, outletId);
                GlobalErrors err = _itemManager.GetAllItemsNew(divisionId, -1, customerId, outletId, ItemFormProcessMode.Orders, ref itemsList, false, includePrices, checkAvl, includeTax, string.Empty, string.Empty,-1, -1);
                if (err == GlobalErrors.Success && itemsList != null && itemsList.Count > 0)
                {
                    List<ItemDiscountModel> discountList = new List<ItemDiscountModel>();
                    err = ItemManager.GetAllDiscount(customerId, outletId, divisionId, -1, _requestRepository.Configurations.EnableSalesDistributionChannel, ref discountList,false, _requestRepository != null && _requestRepository.CurrentOperator != null ? _requestRepository.CurrentOperator.OrganizationAccess : "", string.Empty, _requestRepository.CurrentOperator.EmployeeId);
                    if (err == GlobalErrors.Success && discountList != null && discountList.Count > 0)
                    {
                        itemsList.ForEach(i =>
                        {
                            var discount = discountList.Find(d => d.PackId == i.PackId);
                            if (discount != null && discount.Discount > 0)
                            {
                                i.Discount = discount.Discount;
                                i.DiscountTypeId = discount.DiscountTypeId;
                            }
                        });
                    }
                    return err;
                }
                else
                {
                    return GlobalErrors.NoMoreRows;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemsList = null;
                return GlobalErrors.Error;
            }
        }


        #region [ITEM BATCHES]

        public GlobalErrors FillItemsBatches(int warehouseId, ref List<ItemPackModel> items, bool fillForMismatch, int tripId, DBHelper<ItemStockBatches> dBHelper)
        {
            // get warehouse stock batches with quantity in pcs on item level.
            var result = GlobalErrors.NotInitialized;
            try
            {
                var itemIds = string.Join(",", items.Select(x => x.ItemId)); // fill batches for some items

                var stockBatches = ItemManager.GetAvailableBatches(warehouseId, itemIds, fillForMismatch, tripId, dBHelper);

                foreach (var pack in items)
                {
                    pack.ItemStockBatches = stockBatches.Where(g => g.ItemId == pack.ItemId).ToList();
                    if (fillForMismatch)
                    {
                        var notMatched = pack.ItemStockBatches.FindIndex(a => a.RequiredQty == -1);
                        var totalOfRequiredQnty = pack.ItemStockBatches.Sum(a => a.RequiredQty);
                        if (totalOfRequiredQnty == pack.RequestedQuantity && notMatched == -1)
                        {
                            pack.SelectedBatches = pack.ItemStockBatches;
                            pack.RequiredQty = totalOfRequiredQnty;
                        }
                        else
                        {
                            pack.ItemStockBatches.ForEach(a => a.RequiredQty = 0);
                            pack.RequiredQty = 0;
                        }
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteDivision(int divisionId)
        {
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                return _itemManager.DeleteDivision(divisionId, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors AllowToDeleteDivision(int divisionId, ref string response)
        {
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                if (_itemManager.IsDivisionLinkedToItemCategory(divisionId, dBHelper))
                {
                    response = "Desc_Linked_To_Category";
                    return GlobalErrors.Error;
                }

                if (_itemManager.IsDivisionLinkedToAccount(divisionId, dBHelper))
                {
                    response = "Desc_Linked_To_Account";
                    return GlobalErrors.Error;
                }
                if (_itemManager.IsDivisionLinkedToDocumentSequence(divisionId, dBHelper))
                {
                    response = "Desc_Linked_To_DecumentSeq";
                    return GlobalErrors.Error;
                }
                if (_itemManager.IsDivisionLinkedToCustomerAccount(divisionId, dBHelper))
                {
                    response = "Desc_Linked_To_Customer_Account";
                    return GlobalErrors.Error;
                }
                if (_itemManager.IsDivisionLinkedToCustomers(divisionId, dBHelper))
                {
                    response = "Desc_Linked_To_Customer";
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors DeleteCategory(int categoryId, string hostingEnv, ref bool isCategoryLinkedToItem)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                isCategoryLinkedToItem = false;
                if (_itemManager.IsCategoryLinkedToItem(categoryId, dBHelper))
                {
                    isCategoryLinkedToItem = true;
                    return GlobalErrors.NotInitialized;
                }
                result = _itemManager.DeleteCategory(categoryId, dBHelper);
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                    string folderName = "Resources\\categories-img";
                    string newPath = Path.Combine(hostingEnv, folderName);
                    string fileName = categoryId + ".png";
                    string fullPath = Path.Combine(newPath, fileName);
                    // Delete the file if it exists.
                    if (System.IO.File.Exists(fullPath))
                    {
                        System.IO.File.Delete(fullPath);
                    }
                    // Delete the file if it exists.
                    string path = string.Format(@"{0}", LocalUtilities.CustomerAppServicePath);
                    folderName = "wwwroot\\img\\Echo\\category";
                    newPath = Path.Combine(path, folderName);
                    fullPath = Path.Combine(newPath, fileName);
                    // Delete the file if it exists.
                    if (System.IO.File.Exists(fullPath))
                    {
                        System.IO.File.Delete(fullPath);
                    }
                }
                else
                    dBHelper.RollBackTransaction();

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPacksHierarchy(int customerId, int outletId, ref ItemPackModel itemPack)
        {
            return _itemManager.GetPacksHierarchy(customerId, outletId, ref itemPack);
        }
        public GlobalErrors GetFieldsStartAndEndIndexTemplate(ref ItemPackModel itemPack)
        {
            GlobalErrors result = _itemManager.GetSerialStartAndEndIndexTemplate(null, ref itemPack);
            if (result == GlobalErrors.Success)
                result = _itemManager.GetBatchNoStartAndEndIndexTemplate(null, ref itemPack);
            if (result == GlobalErrors.Success)
                result = _itemManager.GetExpiryDateStartAndEndIndexTemplate(null, ref itemPack);
            if (result == GlobalErrors.Success)
                result = _itemManager.GetProductionDateStartAndEndIndexTemplate(ref itemPack);
            if (result == GlobalErrors.Success)
                result = _itemManager.GetGTINStartAndEndIndexTemplate(ref itemPack);
            if (result == GlobalErrors.Success)
                result = _itemManager.GetGLNStartAndEndIndexTemplate(ref itemPack);
            if (result == GlobalErrors.Success)
                result = _itemManager.GetTotalFieldsLengthOfItemTemplate(null, ref itemPack);
            return result;
        }
        public GlobalErrors GetGS1TemplateDetail(int TemplateID, ref ItemPackModel pack)
        {
            return _itemManager.GetGS1TemplateDetail(TemplateID, ref pack);
        }

        #endregion [ITEM BATCHES]

        #region [PRICES]

        public GlobalErrors GetPriceList(GeneralFilter filter, ref List<PriceModel> itemList)
        {
            try
            {
                if (filter.CustomerId != -1 && filter.OutletId != -1)
                {
                    return _itemManager.GetPriceList(filter, ref itemList);
                }
                else
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemList = null;
                return GlobalErrors.Error;
            }
        }

        public static GlobalErrors GetPriceListOld(GeneralFilter filter, ref List<PriceModel> itemList, int DefaultPriceListID)
        {
            try
            {
                if (filter.CustomerId != -1 && filter.OutletId != -1)
                {
                    return ItemManager.GetPriceListOld(filter, ref itemList, DefaultPriceListID);
                }
                else
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors getPackGroups(ref List<PackGroupModel> data, bool getGroupsHavingSamePackQuantity, string selectedOraganizationIds,bool includePacks, List<int> allowedPackGroupIds = null)
        {
            try
            {
                return _itemManager.getPackGroups(ref data, getGroupsHavingSamePackQuantity, selectedOraganizationIds, includePacks, null,allowedPackGroupIds);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetPackGroupsListSharedTable(CustomListFilters filter, ref SharedTableResult<PackGroupModel> sharedTableList)
        {
            try
            {
                if (filter.Page < 0)
                    filter.Page = 0;
                if (filter.PageSize <= 0)
                    filter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.SearchFilter))
                {
                    filter.SearchFilter = filter.SearchFilter.Replace("'", "''");
                }
                return _itemManager.GetPackGroupsListSharedTable(filter, ref sharedTableList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetPackGroupsDescriptions(int packGroupId, ref List<TextLanguage> descriptionLanguages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _itemManager.GetPackGroupLanguages(packGroupId, ref descriptionLanguages);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getItemsLists(int itemListType, GeneralFilter filter, ref List<ItemListModel> data)
        {
            try
            {

                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _itemManager.getItemsLists(itemListType, filter, ref data);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllItemsForItemsLists(ref List<ItemPackModel> data, int DivisionId, int BrandId, int CategoryId, GeneralFilter generalFilter)
        {
            try
            {
                if (generalFilter != null && generalFilter.CustomListFilter != null)
                {
                    if (generalFilter.CustomListFilter.Page < 0)
                        generalFilter.CustomListFilter.Page = 0;
                    if (generalFilter.CustomListFilter.PageSize <= 0)
                        generalFilter.CustomListFilter.PageSize = 100;
                    if (!string.IsNullOrEmpty(generalFilter.CustomListFilter.SearchFilter))
                    {
                        generalFilter.CustomListFilter.SearchFilter = generalFilter.CustomListFilter.SearchFilter.Replace("'", "''");
                    }
                    return _itemManager.GetAllItemsLazyLoading(ref data, DivisionId, BrandId, CategoryId, generalFilter);


                }
                else
                {

                    return _itemManager.GetAllItems(ref data, DivisionId, BrandId, CategoryId, generalFilter);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors getItemGroupData(int itemGroupId, ref ItemGroupEntryModel itemGroup)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string resourceFolderName = string.Empty;
            try
            {
                var descriptions = new List<TextLanguage>();
                var organizations = new List<OrganizationModel>();
                var items = new List<ItemPackModel>();
                var allItems = false;
              
                result = _itemManager.getItemsForItemGroup(itemGroupId, ref items);
                if(result == GlobalErrors.Success)
                result = _itemManager.GetItemGroupDescriptions(itemGroupId, ref descriptions);
                if (result == GlobalErrors.Success)
                result = _itemManager.GetItemGroupOrganizations(itemGroupId, ref organizations);
                string fileName = itemGroupId + LocalUtilities.ImageExtension;
                string path = string.Format(@"{0}", LocalUtilities.ItemGroupImageFolderPath);
                string resourceAppPath = Path.Combine(path, resourceFolderName);
                string resourceAppFullPath = Path.Combine(resourceAppPath, fileName);

                if (File.Exists(resourceAppFullPath))
                {
                    itemGroup.HasImage = true;
                }
           
                if (result == GlobalErrors.Success)
                {
                    itemGroup.languageDescriptions = descriptions;
                    itemGroup.itemIdsList = items;
                    itemGroup.AllItems = allItems;
                    itemGroup.ItemGroupId = itemGroupId;
                    itemGroup.OrganizationsList = organizations;
                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getItemsListData(int itemListID, int itemListType, ref ItemListModel data, bool oosListMode)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                List<CustomerChannelModel> appliedChannels = new List<CustomerChannelModel>();
                List<CustomerGroupModel> appliedGroups = new List<CustomerGroupModel>();
                List<SimpleCustomerModel> appliedCustomers = new List<SimpleCustomerModel>();
                List<EmployeeModel> appliedEmployees = new List<EmployeeModel>();
                List<SecurityGroupModel> appliedSecurityGroups = new List<SecurityGroupModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                List<ItemPackModel> items = new List<ItemPackModel>();
                List<OrganizationModel> orginazations = new List<OrganizationModel>();
                var ItemsId = new List<int>();
                bool allCustomers = false;
                bool allEmployees = false;
                
                result = _itemManager.getItemsForItemList(itemListID, ref items, oosListMode);
                if (result == GlobalErrors.Success)
                result = _itemManager.GetItemListDescriptions(itemListID, ref descriptions);
                if (result == GlobalErrors.Success)
                {
                    if (oosListMode)
                    {
                        result = _itemManager.GetOOSListOrganizations(itemListID, ref orginazations);
                        if (result != GlobalErrors.Success) return result;
                    }
                    else if (itemListType == ItemListType.ItemListCustomer.GetHashCode())
                    {
                        result = _itemManager.GetCustomerItemListOrganizations(itemListID, ref orginazations);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                if (result == GlobalErrors.Success)
                    if (itemListType == ItemListType.ItemListCustomer.GetHashCode())
                    {
                        result = _itemManager.GetItemListAppliedChannels(itemListID, ref appliedChannels, oosListMode);
                        if (result == GlobalErrors.Success)
                            result = _itemManager.GetItemListAppliedGroups(itemListID, ref appliedGroups, oosListMode);
                        if (result == GlobalErrors.Success)
                            result = _itemManager.GetItemListAppliedCustomers(itemListID, ref appliedCustomers, oosListMode);
                        if (result == GlobalErrors.Success)
                            result = _itemManager.GetIsAppliedToAllCustomers(itemListID, ref allCustomers, oosListMode);
                        if (result == GlobalErrors.Success && oosListMode)
                            result = _itemManager.GetItemListAppliedEmployees(itemListID, ref appliedEmployees, oosListMode);
                        if (result == GlobalErrors.Success && oosListMode)
                            result = _itemManager.GetItemListAppliedSecurityGroups(itemListID, ref appliedSecurityGroups);
                    }
                    else if (itemListType == ItemListType.ItemListEmployee.GetHashCode())
                    {
                        result = _itemManager.GetItemListAppliedEmployees(itemListID, ref appliedEmployees, oosListMode);
                        if (result == GlobalErrors.Success)
                            result = _itemManager.GetIsAppliedToAllEmployees(itemListID, ref allEmployees);
                    }

                if (result == GlobalErrors.Success)
                {
                    data.items = items;
                    data.AppliedChannels = appliedChannels;
                    data.AppliedCustomers = appliedCustomers;
                    data.AppliedGroups = appliedGroups;
                    data.AppliedEmployees = appliedEmployees;
                    data.AppliedSecurityGroups = appliedSecurityGroups;
                    data.DescriptionLanguages = descriptions;
                    data.AllCustomers = allCustomers;
                    data.AllEmployees = allEmployees;
                    data.AppliedOrganizations = orginazations;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors getGroupPacks(int groupID, ref List<PackModel> packs)
        {
            try
            {
                return _itemManager.getGroupPacks(groupID, ref packs);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors CheckIfUniqueValue(string tableName, string columnName, string insertedValue, string excludedString, ref bool isUniqueValue)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _itemManager.CheckIfUniqueValue(tableName, columnName, insertedValue, excludedString, ref isUniqueValue);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAllPacks(ref List<PackModel> packs)
        {
            try
            {
                return _itemManager.GetAllPacks(ref packs);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public static GlobalErrors GetPriceList(int customerId, int outletId, ref List<PriceModel> priceList, int DefaultPriceListID)
        {
            try
            {

                if (customerId <= 0 || outletId <= 0)
                {
                    return GlobalErrors.Error;
                }
                else
                {
                    GeneralFilter filter = new GeneralFilter();
                    filter.CustomerId = customerId;
                    filter.OutletId = outletId;
                    return ItemManager.GetPriceListOld(filter, ref priceList, DefaultPriceListID);

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceList = null;
                return GlobalErrors.Error;
            }
        }

        #endregion [Prices]

        public GlobalErrors GetAllActiveItems(ref List<ItemPackModel> itemsList)
        {
            try
            {
                return _itemManager.GetAllActiveItems(ref itemsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemsList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors deletePackGroup(int groupID, ref string errorMessage)
        {
            try
            {
                return _itemManager.deletePackGroup(groupID, ref errorMessage);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteItemList(int itemListID, int itemListType, bool oosListMode)
        {
            try
            {
                return ItemManager.DeleteItemList(itemListID, itemListType, oosListMode);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors deleteItemGroupData(int itemGroupId, ref string errorMessage)
        {
            try
            {
                return _itemManager.DeleteItemGroup(itemGroupId, ref errorMessage);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors AddEditPackGroup(PackGroupModel packGroup)
        {
            try
            {
                return ItemManager.AddEditPackGroup(packGroup);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveDivision(DivisionModel division, Collection<IFormFile> files, string hostingEnv)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                division.DivisionId = ItemManager.GetMaxDivisionId();
                result = _itemManager.SaveDivisionData(division, dBHelper);

                if (result == GlobalErrors.Success)
                    result = _itemManager.SaveDivisionEmployee(division, dBHelper);

                if(result == GlobalErrors.Success && _requestRepository.CurrentOperator.EmployeeId != 0)
                    result = _itemManager.SaveDivisionEmployeeAdmin(division, dBHelper);

                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage textLanguage in division.DescriptionLanguages)
                    {
                        if (string.IsNullOrEmpty(textLanguage.Description))
                        {
                            textLanguage.Description = division.Description;
                        }
                        result = _itemManager.SaveDivisionLanguage(division.DivisionId, textLanguage.LanguageId, textLanguage.Description, dBHelper);
                    }
                }

                result = HandleImages(hostingEnv, division.DivisionId, division.HasImage, files, division.IsImageChanged, _requestRepository.Configurations.AllowCustomerAppLogin, ImageMode.Division, dBHelper);

                if (result == GlobalErrors.Success)
                    dBHelper.CommitTransaction();
                else
                    dBHelper.RollBackTransaction();

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors EditDivision(DivisionModel division , Collection<IFormFile> files, string hostingEnv)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                result = _itemManager.EditDivisionData(division, dBHelper);

                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage textLanguage in division.DescriptionLanguages)
                    {
                        result = _itemManager.EditDivisionLanguage(division.DivisionId, textLanguage.LanguageId, textLanguage.Description, dBHelper);
                    }
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                result = HandleImages(hostingEnv, division.DivisionId, division.HasImage, files, division.IsImageChanged, _requestRepository.Configurations.AllowCustomerAppLogin, ImageMode.Division, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckCodeIsExist(string tableName, string columnName, string code, string IdColumnName, int Id, ref bool isExist)
        {
            try
            {
                return _itemManager.CheckCodeExist(tableName, columnName, code, IdColumnName, Id, ref isExist);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetDivisionData(int divisionId, ref DivisionModel division)
        {
            var result = GlobalErrors.NotInitialized;
            var descriptions = new List<TextLanguage>();
            try
            {
                result = _itemManager.GetDivisionData(divisionId, ref division);

                result = _itemManager.GetDivisionLanguages(divisionId, ref descriptions);

                division.DescriptionLanguages = descriptions;

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors EditCategory(CategoryModel category, Collection<IFormFile> files, string hostingEnv)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                result = _itemManager.EditCategoryData(category, dBHelper);
                if (result == GlobalErrors.Success)
                {
                    result = _itemManager.EditCategoryLanguage(category, dBHelper);
                }

                if (result == GlobalErrors.Success && _requestRepository.Configurations.AllowCustomerAppLogin)
                {
                    result = _itemManager.SaveItemCategoryCustomerApp(category.ItemCategoryId, category.DivisionId, category.ShowInCustomerApp, dBHelper);
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                result = HandleImages(hostingEnv, category.ItemCategoryId, category.HasImage, files, category.IsImageChanged, _requestRepository.Configurations.AllowCustomerAppLogin, ImageMode.Categories, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetAlllCategories(int divisionId, ref List<CategoryModel> data)
        {
            try
            {
                ItemCategoryFilter filter = new ItemCategoryFilter();
                filter.DivisionId = divisionId;
                return GetAlllCategories(filter, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAlllCategories(ItemCategoryFilter filter, ref List<CategoryModel> data)
        {
            try
            {
                return _itemManager.GetAlllCategories(filter, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCategoryData(int categoryId, ref CategoryModel category)
        {
            var result = GlobalErrors.NotInitialized;
            var descriptions = new List<TextLanguage>();
            try
            {
                result = _itemManager.GetCategoryData(categoryId, ref category);
                if (result == GlobalErrors.Success)
                {
                    result = _itemManager.GetCategoryLanguages(categoryId, ref descriptions);

                    category.DescriptionLanguages = descriptions;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveCategory(CategoryModel category, Collection<IFormFile> files, string hostingEnv)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                category.ItemCategoryId = ItemManager.GetMaxCategoryId();
                result = _itemManager.SaveCategoryData(category, dBHelper);

                if (result == GlobalErrors.Success && _requestRepository.Configurations.AllowCustomerAppLogin && category.ShowInCustomerApp)
                {
                    result = _itemManager.SaveItemCategoryCustomerApp(category.ItemCategoryId, category.DivisionId, category.ShowInCustomerApp, dBHelper);
                }

                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage textLanguage in category.DescriptionLanguages)
                    {
                        if (string.IsNullOrEmpty(textLanguage.Description))
                        {
                            textLanguage.Description = category.ItemCategoryName;
                        }
                        result = _itemManager.SaveCategoryLanguage(category.ItemCategoryId, textLanguage.LanguageId, textLanguage.Description, dBHelper);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }
                result = HandleImages(hostingEnv, category.ItemCategoryId, category.HasImage, files, category.IsImageChanged, _requestRepository.Configurations.AllowCustomerAppLogin, ImageMode.Categories, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InactivateSalesRestriction(int salesRestrictionId)
        {
            return _itemManager.InactivateSalesRestriction(salesRestrictionId);
        }
        public GlobalErrors GetPackGroupItems(PackGroupModel filter, ref List<ItemPackModel> items)
        {
            try
            {
                return _itemManager.GetPackGroupItems(filter, ref items);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetPackItemsWithPrice(int customerId, int outletId, int packGroupId, ref List<ItemPackModel> items, bool includeTax,bool isSkipPromotion)
        {
            try
            {
                return _itemManager.GetPackItemsWithPrice(customerId, outletId, packGroupId, ref items, includeTax, isSkipPromotion);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetPackGroupName(int packGroupId, ref string name)
        {
            try
            {
                return _itemManager.GetPackGroupName(packGroupId, ref name); ;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllVendors(bool IncludeInactive, ref List<VendorModel> vendorList)
        {
            return _itemManager.GetAllVendors(IncludeInactive,ref vendorList);
        }
        #region[Item Definition]
        public GlobalErrors SaveNewPackType(PackTypeModel packType)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                result = _itemManager.SavePackType(packType, dbHelper);
                if (result == GlobalErrors.Success)
                {
                    result = _itemManager.SavePackTypeLanguage(packType, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }

                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public string IsPackValidToDelete(int packId)
        {
            DBHelper<int> dBHelper = new DBHelper<int>();
            string result = string.Empty;
            try
            {
                if (_itemManager.IsPackUsedInTransactions(packId, dBHelper))
                {
                    return "Desc_Used_Transaction";
                }
                if (_itemManager.IsPackUsedInPromotion(packId, dBHelper))
                {
                    return "Desc_Has_Promotion";
                }
                if (_itemManager.IsPackUsedInDiscount(packId, dBHelper))
                {
                    return "Desc_Has_Discount";
                }
                if (_itemManager.IsPackExistingInTheWarehouseStock(packId, dBHelper))
                {
                    return "Desc_In_WarehouseStock";
                }
                if (_itemManager.IsPackExistingInTheVehicleUploadStock(packId, dBHelper))
                {
                    return "Desc_Uploaded_Vehicle";
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return "Desc_Error_Happend";
            }
        }
        public GlobalErrors GetPackTypeList(ref List<PackTypeModel> packTypes)
        {
            try
            {
                return _itemManager.getPackType(ref packTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetPackTypeOfPackGroup(ref List<PackTypeModel> packTypes)
        {
            try
            {
                return _itemManager.GetPackTypeOfPackGroup(ref packTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetKPIPackTypes(ref List<PackTypeModel> packTypes)
        {
            try
            {
                return _itemManager.GetKPIPackTypes(ref packTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetItemData(int itemId, ref ItemPackModel item)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<PackModel> packsList = new List<PackModel>();
                result = _itemManager.GetItemPacksAndGroups(itemId, ref packsList);
                if (result == GlobalErrors.Success)
                {
                    if (packsList != null && packsList.Count > 0)
                    {
                        item.Packs = packsList;
                    }
                    List<TextLanguage> descriptions = new List<TextLanguage>();
                    result = _itemManager.GetItemDescriptions(itemId, ref descriptions);
                    if (result == GlobalErrors.Success)
                    {
                        if (descriptions != null && descriptions.Count > 0)
                        {
                            item.DescriptionLanguages = descriptions;
                        }
                    }
                }
                if (result == GlobalErrors.Success && item.ItemTypeId == ItemTypes.TradingItem.GetHashCode())
                {
                    List<CompetitorModel> itemCompetitorsList = new List<CompetitorModel>();
                    result = _itemManager.GetTradingItemCompetitorsInEditMode(itemId, item.ItemTypeId, ref itemCompetitorsList);
                    if (result == GlobalErrors.Success && itemCompetitorsList != null && itemCompetitorsList.Count > 0)
                    {
                        item.CompetitorsList = itemCompetitorsList;
                    }
                }
                if (result == GlobalErrors.Success && item.ItemTypeId == ItemTypes.CompetitorItem.GetHashCode())
                {
                    int tradingItemId = -1;
                    CompetitorModel competitor = new CompetitorModel();
                    result = _itemManager.GetCompetitorItemDataInEditMode(itemId, item.ItemTypeId, ref competitor);
                    if (result == GlobalErrors.Success && competitor != null )
                    {
                        item.Competitor = competitor;
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateItemActiveStatus(int promotionId, bool setInactive)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _itemManager.UpdateItemActiveStatus(promotionId, setInactive);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        
        public GlobalErrors UpdateSelectedItemsProperities(ItemAction itemAction)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _itemManager.UpdateSelectedItemsProperities(itemAction);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemsListSharedTable(ItemsFilter filter, ref SharedTableResult<ItemPackModel> itemsSharedList)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _itemManager.GetItemsListSharedTable(filter, ref itemsSharedList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemsSharedList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateItemsListIsNewExpireDate( ref List<ItemPackModel> itemList )
        {
            try
            {
                return _itemManager.UpdateItemsListIsNewExpireDate(itemList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetItemModel(ref List<Item_Model> itemModel)
        {
            try
            {
                return _itemManager.GetItemModel(ref itemModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetItemBrand(ref List<ItemBrandModel> brandsList)
        {
            try
            {
                return _itemManager.GetItemBrand(ref brandsList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetItemTypes(ref List<ItemTypeModel> typesList)
        {
            try
            {
                return _itemManager.GetItemTypes(ref typesList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveItem(ItemPackModel item, Collection<IFormFile> files, string hostingEnv, Collection<IFormFile> attahcedImages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            int maxPackId = -1;
            int maxSecondaryPackId = -1;
            Dictionary<int, int> newPackIds = new Dictionary<int, int>();
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                if (item.ItemId < 0)
                {
                    item.ItemId = ItemManager.GetMaxItemId(dbHelper);
                    if (item.ItemId != -1)
                    {
                        result = _itemManager.InsertNewItem(item, dbHelper);
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }
                }
                else
                {
                    result = _itemManager.UpdateItem(item, dbHelper);
                    if (result == GlobalErrors.Success)
                    {
                        result = _itemManager.DeleteItemLanguage(item.ItemId, dbHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _itemManager.DeleteItemSensors(item.ItemId, dbHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _itemManager.DeleteCompetitor(item, dbHelper);
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    result = _itemManager.SaveItemLanguage(item, dbHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    maxPackId = ItemManager.MaxPackID(dbHelper);
                    item.Packs = item.Packs.OrderBy(x => x.DataAction).ToList();
                    item.Packs = item.Packs.OrderBy(x => x.Quantity).ToList();
                    foreach (PackModel pack in item.Packs)
                    {
                        pack.HasSerialNumber = item.HasSerialNumber;
                        switch (pack.DataAction)
                        {
                            case DataActions.Add:
                                if (newPackIds != null && !newPackIds.ContainsKey(pack.PackId))
                                    newPackIds.Add(pack.PackId, maxPackId);
                                pack.PackId = maxPackId;
                                if (pack.ChildPackId < -1 && newPackIds != null && newPackIds.ContainsKey(pack.ChildPackId))
                                    pack.ChildPackId = newPackIds[pack.ChildPackId];
                                if (pack.PackId != -1)
                                {
                                    pack.ItemId = item.ItemId;
                                    result = _itemManager.SaveNewPack(pack, dbHelper);
                                    if (result == GlobalErrors.Success)
                                    {
                                        if (pack.IsDefaultPack)
                                        {
                                            item.DefaultPackId = pack.PackId;
                                            result = _itemManager.SetItemDefaultPackId(item, dbHelper);
                                        }
                                        if (result == GlobalErrors.Success && pack.PackGroupsList != null && pack.PackGroupsList.Count > 0)
                                        {
                                            result = _itemManager.SavePackGroupDetail(pack, dbHelper);
                                        }
                                        if (result == GlobalErrors.Success && pack.PackOperationsList != null && pack.PackOperationsList.Count > 0)
                                        {
                                            result = _itemManager.SavePackOperationList(pack, dbHelper);
                                        }
                                    }
                                    maxPackId++;
                                }
                                else
                                {
                                    result = GlobalErrors.Error;
                                    return GlobalErrors.Error;
                                }
                                break;
                            case DataActions.Edit:
                            case DataActions.NoChange:
                                if (pack.ChildPackId < -1 && newPackIds != null && newPackIds.ContainsKey(pack.ChildPackId))
                                    pack.ChildPackId = newPackIds[pack.ChildPackId];
                                result = _itemManager.UpdatePack(pack, dbHelper);
                                if (result == GlobalErrors.Success)
                                {
                                    if (pack.IsDefaultPack)
                                    {
                                        item.DefaultPackId = pack.PackId;
                                        result = _itemManager.SetItemDefaultPackId(item, dbHelper);
                                    }
                                    if (result == GlobalErrors.Success)
                                    {
                                        result = _itemManager.DeletePackGroupDetails(pack.PackId, dbHelper);
                                        if (result == GlobalErrors.Success)
                                        {
                                            result = _itemManager.SavePackGroupDetail(pack, dbHelper);
                                        }
                                    }
                                    if (result == GlobalErrors.Success)
                                    {
                                        result = _itemManager.DeletePackOperationsList(pack, dbHelper);
                                        if (result == GlobalErrors.Success && pack.PackOperationsList != null && pack.PackOperationsList.Count > 0)
                                        {
                                            result = _itemManager.SavePackOperationList(pack, dbHelper);

                                        }
                                    }
                                }
                                break;
                            case DataActions.Delete:
                                result = _itemManager.DeletePackGroupDetails(pack.PackId, dbHelper);
                                if (result == GlobalErrors.Success)
                                {
                                    result = _itemManager.DeletePackOperationsList(pack, dbHelper);
                                }
                                if (result == GlobalErrors.Success)
                                {
                                    result = _itemManager.DeletePack(pack.PackId, dbHelper);
                                }
                                break;
                        }
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    maxSecondaryPackId = _itemManager.MaxSecondaryPackID(dbHelper);
                    result = _itemManager.DeleteSecondaryPacksOfItem(item.ItemId, dbHelper);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    foreach (SecondaryPackModel secondary in item.SecondaryPacks)
                    {
                        if (secondary.SecondaryPackId < 0)
                            secondary.SecondaryPackId = maxSecondaryPackId;
                        result = _itemManager.InsertSecondaryPacksOfItem(item.ItemId, secondary, dbHelper);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        maxSecondaryPackId++;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    if ((item.ItemTypeId == ItemTypes.CompetitorItem.GetHashCode() && item.Competitor != null && item.Competitor.CompetitorId > 0) ||
                        (item.ItemTypeId == ItemTypes.TradingItem.GetHashCode() && item.CompetitorsList != null && item.CompetitorsList.Count > 0))
                    {
                        result = _itemManager.InsertCompetitor(item, dbHelper);
                    }
                }
                if (result == GlobalErrors.Success && attahcedImages != null && attahcedImages.Count > 0 && result == GlobalErrors.Success)
                {
                    string itemPath = "";
                    result = UploadItemAttachments(item.ItemId, attahcedImages);
                   
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                result = HandleImages(hostingEnv, item.ItemId, item.HasImage, files, item.IsImageChanged, _requestRepository.Configurations.AllowCustomerAppLogin, ImageMode.Items, dbHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors UploadItemAttachments(int itemId, Collection<IFormFile> attahcedImages)
        {

            //Web

            string path = string.Format(@"{0}", LocalUtilities.ItemAttachFolderPath);
            string folderName = itemId.ToString();
            string newPath = Path.Combine(path, folderName);
            string pathEcho = string.Format(@"{0}", LocalUtilities.CustomerAppServicePath);
            string folderNameEcho = LocalUtilities.CustomerAppItemAttachFolderPath + "\\" + itemId.ToString();
            string newPathEcho = Path.Combine(pathEcho, folderNameEcho);


            if (Directory.Exists(newPath))
            {
                Directory.Delete(newPath, true);
            }
            Directory.CreateDirectory(newPath);

            if (Directory.Exists(newPathEcho))
            {
                Directory.Delete(newPathEcho, true);
            }
            Directory.CreateDirectory(newPathEcho);
            foreach (IFormFile file in attahcedImages)
            {
                if (file.Length > 0)
                {
                    string extension = Path.GetExtension(file.FileName).ToLowerInvariant();
                    if (!string.IsNullOrEmpty(extension))
                    {
                        string fileName = file.FileName;
                        string fullPath = Path.Combine(newPath, fileName);
                        string fullPathEcho = Path.Combine(newPathEcho, fileName);
                        using (var stream = new FileStream(fullPath, FileMode.Create))
                        {
                            file.CopyTo(stream);
                        }

                        using (var stream = new FileStream(fullPathEcho, FileMode.Create))
                        {
                            file.CopyTo(stream);
                        }
                    }
                    else
                    {
                        Directory.Delete(newPath, true);
                        Directory.Delete(newPathEcho, true);
                        return GlobalErrors.Error;
                    }

                }
            }

            return GlobalErrors.Success;
        }


        public GlobalErrors GetSecondaryPacks(int itemId, ref List<SecondaryPackModel> secondaryPacks)
        {
            return _itemManager.GetSecondaryPacks(itemId, ref secondaryPacks);
        }
        public string IsSecondaryPackValidToDelete(int secondaryPackId)
        {
            DBHelper<int> dBHelper = new DBHelper<int>();
            string result = string.Empty;
            try
            {
                if (_itemManager.IsSecondaryPackUsedInOrders(secondaryPackId, dBHelper))
                {
                    return MessagesConstants.Desc_Secondary_Used_Order;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return MessagesConstants.Desc_Error_Happend;
            }
        }
        public GlobalErrors HandleImages(string rootPath, int id, bool hasImage, Collection<IFormFile> files, bool imageChanged, bool allowCustomerAppLogin, ImageMode imageMode, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                IFormFile file = null;
                if (files != null && files.Count > 0)
                {
                    file = files[0];
                }
                string resourcesFolderName = string.Empty;
                string customerFolderName = string.Empty;
                switch (imageMode)
                {
                    case ImageMode.Items:
                        resourcesFolderName = LocalUtilities.ItemImageFolderPath;
                        customerFolderName = LocalUtilities.CustomerAppItemImageFolderPath;
                        break;
                    case ImageMode.Categories:
                        resourcesFolderName = LocalUtilities.ItemCategoryImageFolderPath;
                        customerFolderName = LocalUtilities.CustomerAppCategoryImageFolderPath;
                        break;
                    case ImageMode.Brands:
                        resourcesFolderName = LocalUtilities.BrandImageFolderPath;
                        customerFolderName = LocalUtilities.CustomerAppBrandImageFolderPath;
                        break;
                    case ImageMode.Groups:
                        resourcesFolderName = LocalUtilities.ItemGroupImageFolderPath;
                        customerFolderName = LocalUtilities.CustomerAppGroupImageFolderPath;
                        break;
                    case ImageMode.Banners:
                        resourcesFolderName = LocalUtilities.BannerImageFolderPath;
                        customerFolderName = LocalUtilities.CustomerAppBannerImageFolderPath;
                        break;
                    case ImageMode.Division:
                        resourcesFolderName = LocalUtilities.DivisionImageFolderPath;
                        customerFolderName = LocalUtilities.CustomerAppDivisonImageFolderPath;
                        break;
                    default:
                        return GlobalErrors.Error;
                        break;
                }
                string fileName = id + LocalUtilities.ImageExtension;
                string resourcesNewPath = Path.Combine(rootPath, resourcesFolderName);
                string resourcesFullPath = Path.Combine(resourcesNewPath, fileName);
                string path = string.Format(@"{0}", LocalUtilities.CustomerAppServicePath);
                string customerAppPath = Path.Combine(path, customerFolderName);
                string customerAppFullPath = Path.Combine(customerAppPath, fileName);
                if (hasImage)
                {
                    if (imageChanged && (file != null && file.Length > 0))
                    {
                        if (!Directory.Exists(resourcesNewPath))
                        {
                            Directory.CreateDirectory(resourcesNewPath);
                        }
                        if (File.Exists(resourcesFullPath))
                        {
                            File.Delete(resourcesFullPath);
                        }
                        result = ItemManager.SaveImageFile(file, resourcesFullPath);
                        //Save Image to DB only Items
                        if (result == GlobalErrors.Success)
                        {
                            byte[] buff = null;
                            switch (imageMode)
                            {
                                case ImageMode.Items:
                                    result = _itemManager.DeleteItemImage(id, dBHelper);
                                    if (result == GlobalErrors.Success && hasImage)
                                    {
                                        buff = System.IO.File.ReadAllBytes(resourcesFullPath);
                                        result = _itemManager.SaveItemImage(id, buff, dBHelper);
                                    }
                                    break;
                                case ImageMode.Categories:
                                    result = _itemManager.DeleteItemCategoryImage(id, dBHelper);
                                    if (result == GlobalErrors.Success && hasImage)
                                    {
                                        buff = System.IO.File.ReadAllBytes(resourcesFullPath);
                                        result = _itemManager.SaveItemCategoryImage(id, buff, dBHelper);
                                    }
                                    break;
                                case ImageMode.Brands:
                                    result = _itemManager.DeleteBrandImage(id, dBHelper);
                                    if (result == GlobalErrors.Success && hasImage)
                                    {
                                        buff = System.IO.File.ReadAllBytes(resourcesFullPath);
                                        result = _itemManager.SaveBrandImage(id, buff, dBHelper);
                                    }
                                    break;
                                case ImageMode.Division:
                                    result = GlobalErrors.Success;
                                    break;
                                case ImageMode.Groups:
                                    result = GlobalErrors.Success;
                                    break;
                                case ImageMode.Banners:
                                    result = GlobalErrors.Success;
                                    break;
                                default:
                                    return GlobalErrors.Error;
                                    break;

                            }
                        }
                        if (result != GlobalErrors.Success)
                        {
                            return GlobalErrors.Error;
                        }
                        if (allowCustomerAppLogin)
                        {
                            if (!Directory.Exists(customerAppPath))
                            {
                                try
                                {
                                    Directory.CreateDirectory(customerAppPath);
                                }
                                catch (Exception ex)
                                {
                                    result = GlobalErrors.CustomerAppPath;
                                    return result;
                                }
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Success ;
                    }
                    if (allowCustomerAppLogin)
                    {
                        if (!Directory.Exists(customerAppPath))
                        {
                            try
                            {
                                Directory.CreateDirectory(customerAppPath);
                            }
                            catch (Exception ex)
                            {
                                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                                result = GlobalErrors.CustomerAppPath;
                                return result;
                            }
                        }
                        if (File.Exists(customerAppFullPath))
                        {
                            File.Delete(customerAppFullPath);
                        }
                        File.Copy(resourcesFullPath, customerAppFullPath);
                        result = GlobalErrors.Success;
                    }
                }
                else
                {
                    //Image Deleted From Echo & Sonic
                    if (File.Exists(resourcesFullPath))
                    {
                        File.Delete(resourcesFullPath);
                    }
                    if (File.Exists(customerAppFullPath))
                    {
                        File.Delete(customerAppFullPath);
                    }
                    switch (imageMode)
                    {
                        case ImageMode.Items:
                            result = _itemManager.DeleteItemImage(id, dBHelper);
                            break;
                        case ImageMode.Categories:
                            result = _itemManager.DeleteItemCategoryImage(id, dBHelper);
                            break;
                        case ImageMode.Brands:
                            result = _itemManager.DeleteBrandImage(id, dBHelper);
                            break;
                        case ImageMode.Division:
                            result = GlobalErrors.Success;
                            break;
                        case ImageMode.Groups:
                            result = GlobalErrors.Success;
                            break;
                        case ImageMode.Banners:
                            result = GlobalErrors.Success;
                            break;
                        default:
                            return GlobalErrors.Error;
                            break;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertOrUpdateItemGroup(ItemGroupEntryModel itemGroup, Collection<IFormFile> files, string hostingEnv)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                if (itemGroup.ItemGroupId == 0)
                {
                    itemGroup.ItemGroupId = GetMaxID("ItemGroupID", "ItemGroup", dbHelper);
                    result = _itemManager.InsertItemGroup(itemGroup);
                }
                else
                {
                    result = _itemManager.UpdateItemGroup(itemGroup);
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }

        result = HandleImages(hostingEnv, itemGroup.ItemGroupId, itemGroup.HasImage, files, itemGroup.IsImageChanged, _requestRepository.Configurations.AllowCustomerAppLogin, ImageMode.Groups, dbHelper);
        }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveItemList(ItemListModel itemList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                if (itemList.StartDateModel != null && itemList.EndDateModel != null)
                {
                    itemList.StartDate = new DateTime(itemList.StartDateModel.Year, itemList.StartDateModel.Month, itemList.StartDateModel.Day);
                    itemList.EndDate = new DateTime(itemList.EndDateModel.Year, itemList.EndDateModel.Month, itemList.EndDateModel.Day);
                }
                if (itemList.ItemListId < 0)
                {
                    if (itemList.OOSListMode)
                    {
                        itemList.ItemListId = GetMaxID("OOSItemsListID", "OOSListHeader", dbHelper);
                    }
                    else
                    {
                        itemList.ItemListId = GetMaxID("ItemListID", "ItemsList", dbHelper);
                    }
                    if (itemList.ItemListId != -1)
                    {
                        result = _itemManager.InsertNewItemList(itemList, dbHelper);
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }


                }
                else
                {
                    result = _itemManager.UpdateItemList(itemList, dbHelper, itemList.OOSListMode);
                    if (result == GlobalErrors.Success)
                    {
                        result = _itemManager.DeleteItemListLanguage(itemList.ItemListId, dbHelper, itemList.OOSListMode);
                        if (result == GlobalErrors.Success)
                            result = _itemManager.DeleteItemListDetails(itemList.ItemListId, dbHelper, itemList.OOSListMode);
                        if (result == GlobalErrors.Success)
                            result = _itemManager.DeleteItemListAssignment(itemList.ItemListType, itemList.ItemListId, dbHelper, itemList.OOSListMode);
                        if (result == GlobalErrors.Success)
                        {
                            if (itemList.OOSListMode)
                            {
                                result = _itemManager.DeleteOOSListOrganization(itemList.ItemListId, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                            else if (itemList.ItemListType == ItemListType.ItemListCustomer.GetHashCode().ToString())
                            {//accsess
                                result = _itemManager.DeleteCustomerItemListOrganization(itemList.ItemListId, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        } 
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    result = _itemManager.SaveItemListLanguage(itemList, dbHelper);
                    if (result == GlobalErrors.Success)
                    {
                        result = _itemManager.SaveItemListDetails(itemList, dbHelper);
                    }
                    if(result == GlobalErrors.Success)
                    {
                        if (itemList.OOSListMode)
                        {
                            result = _itemManager.SaveOOSListOrganization(itemList, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                        else 
                        {
                            if (itemList.ItemListType == ItemListType.ItemListCustomer.GetHashCode().ToString())
                            {
                                result = _itemManager.SaveCustomerItemListOrganization(itemList, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        int itemListAssignmentID = 0;
                        if (itemList.OOSListMode)
                        {
                            if (itemList.ItemListType == ItemListType.ItemListCustomer.GetHashCode().ToString())
                                itemListAssignmentID = GetMaxID("OOSItemsListID", "OOSListAssignment", dbHelper);
                            else
                                itemListAssignmentID = GetMaxID("ItemListEmployeeID", "ItemListEmployee", dbHelper);
                        }
                        else
                        {
                            if (itemList.ItemListType == ItemListType.ItemListCustomer.GetHashCode().ToString())
                                itemListAssignmentID = GetMaxID("ItemsListAssignmentID", "ItemsListAssignment", dbHelper);
                            else
                                itemListAssignmentID = GetMaxID("ItemListEmployeeID", "ItemListEmployee", dbHelper);

                        }
                        result = _itemManager.InsertItemListAssignment(itemListAssignmentID, itemList, dbHelper, itemList.OOSListMode);
                        //result = GlobalErrors.Success;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetPackGroupsItemDefinition(ref List<PackGroupModel> data)
        {
            try
            {
                return _itemManager.GetPackGroupsItemDefinition(ref data);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public static int GetMaxID(string columnName, string tableName, DBHelper<int> dBHelper)
        {
            try
            {
                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object max = null;
                string query = string.Format(@"select isnull(max({0}),0)+1 from {1} ", columnName, tableName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref max);
                if (result == GlobalErrors.Success && max != null && !string.IsNullOrEmpty(max.ToString()))
                {
                    return int.Parse(max.ToString());
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return 1;
        }
        public GlobalErrors GetItemsTemplate(ref List<BarcodeTemplateModel> itemTemplatesList)
        {
            try
            {
                return _itemManager.GetItemsTemplate(ref itemTemplatesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemTemplatesList = null;
                return GlobalErrors.Error;
            }
        }

        #endregion
        public GlobalErrors GetAlllBrands(ref List<BrandModel> allBrands)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                return GetAlllBrands(string.Empty, ref allBrands);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAlllBrands(string brandIdsString ,ref List<BrandModel> allBrands)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<TextLanguage> descriptions = new List<TextLanguage>();
                result = _itemManager.GetAlllBrands(brandIdsString, ref allBrands);
                if (result == GlobalErrors.Success)
                {
                    foreach (BrandModel brand in allBrands)
                    {
                        descriptions = new List<TextLanguage>();
                        result = _itemManager.GetBrandDescriptions(brand.BrandId, ref descriptions);
                        if (result != GlobalErrors.Success) break;
                        brand.DescriptionLanguages = descriptions;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public int getMaxBrandID()
        {
            int brandID = -1;
            try
            {
                brandID = ItemManager.GetMaxBrandID();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return brandID;
        }

        public GlobalErrors SaveBrand(BrandModel brand, Collection<IFormFile> files, string hostingEnv)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                //brand.BrandId = ItemManager.GetMaxBrandID();

                result = _itemManager.SaveBrandData(brand, dBHelper);

                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage textLanguage in brand.DescriptionLanguages)
                    {
                        if (string.IsNullOrEmpty(textLanguage.Description))
                        {
                            textLanguage.Description = brand.BrandName;
                        }
                        result = _itemManager.SaveBrandLanguage(brand.BrandId, textLanguage.LanguageId, textLanguage.Description, dBHelper);
                    }
                }
                if (result == GlobalErrors.Success && _requestRepository.Configurations.AllowCustomerAppLogin && brand.ShowInCustomerApp)
                {
                    result = _itemManager.SaveBrandCustomerApp(brand.BrandId, brand.ShowInCustomerApp, dBHelper);
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                result = HandleImages(hostingEnv, brand.BrandId, brand.HasImage, files, brand.IsImageChanged, _requestRepository.Configurations.AllowCustomerAppLogin, ImageMode.Brands, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors EditBrand(BrandModel brand, Collection<IFormFile> files, string hostingEnv)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                result = _itemManager.SaveBrandData(brand, dBHelper);

                if (result == GlobalErrors.Success)
                    result = _itemManager.EditBrandLanguage(brand, dBHelper);

                if (result == GlobalErrors.Success && _requestRepository.Configurations.AllowCustomerAppLogin)
                {
                    result = _itemManager.SaveBrandCustomerApp(brand.BrandId, brand.ShowInCustomerApp, dBHelper);
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                result = HandleImages(hostingEnv, brand.BrandId, brand.HasImage, files, brand.IsImageChanged, _requestRepository.Configurations.AllowCustomerAppLogin, ImageMode.Brands, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors AllowToDeleteBrand(int brandId, ref string response)
        {
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                if (_itemManager.IsBrandLinkedToItem(brandId, dBHelper))
                {
                    response = ResourcesManager.TranslateKey(MessagesConstants.Desc_Brand_Linked_To_Item, _requestRepository.LanguageId);
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors DeleteBrand(int brandId, string hostingEnv)
        {
            try
            {
                return _itemManager.DeleteBrand(brandId, hostingEnv);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CheckIfItemSerialsAvailable(ref bool isExist, ref bool isAnyPackHasTrimRule)
        {
            try
            {
                return _itemManager.CheckIfItemSerialsAvailable(ref isExist, ref isAnyPackHasTrimRule);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCompetitorsList(ref List<CompetitorModel> competitorsList)
        {
            try
            {
                return _itemManager.GetCompetitorsList(ref competitorsList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAvailableCompetitorItemList(int itemId, ref List<CompetitorModel> competitorItemList)
        {
            try
            {
                return _itemManager.GetAvailableCompetitorItemList(itemId ,ref competitorItemList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        
        public GlobalErrors fillDataInItemExtraInfo()
        {
            return _itemManager.fillDataInItemExtraInfo();
        }
        
        public GlobalErrors UpdateItemSerialOperations(List<ItemSerialOperations> serialOperations)
        {
            try
            {
                return _itemManager.UpdateItemSerialOperations(serialOperations);  
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors CheckIfItemsWithUpperLimitAvailable(ref bool allowCheckUpperLimit)
        {
            try
            {
                return _itemManager.CheckIfItemsWithUpperLimitAvailable(ref allowCheckUpperLimit);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors GetPromotionItemsWithStockStatus(GeneralFilter filter, ref List<CRMPromotionItem> promotionItem)
        {
            try
            {
                return _itemManager.GetPromotionItemsWithStockStatus(filter, ref promotionItem);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetPromotionsDetailsWithStockStatus(string promotionIds, ref List<CRMPromotionItem> promotionDetails)
        {
            try
            {
                return _itemManager.GetPromotionsDetailsWithStockStatus(promotionIds, ref promotionDetails);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        #region [ECHO]
        public GlobalErrors FillItemDocumentImages(int itemId)
        {
            try
            {
                return ItemManager.FillItemDocumentImages(itemId, "");
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }  
        public GlobalErrors GetItemDocuments(int itemId, ref List<string> itemDocuments)
        {
            try
            {
                return ItemManager.GetItemDocuments(itemId, ref itemDocuments);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetEchoCategories(int divisionId, ref List<CategoryModel> list)
        {
            try
            {
                if (!string.IsNullOrEmpty(_requestRepository.CurrentEchoOperator.DivisionIds))
                {
                    return _itemManager.GetEchoCategories(divisionId, ref list);
                }
                else
                    return GlobalErrors.NoMoreRows;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetEchoDivisions(ref List<DivisionModel> list)
        {
            try
            {
                if (!string.IsNullOrEmpty(_requestRepository.CurrentEchoOperator.DivisionIds))
                {
                    return _itemManager.GetEchoDivisions(ref list);
                }
                else
                    return GlobalErrors.NoMoreRows;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetEchoBrands(ref List<GeneralModel> list)
        {
            try
            {
                return _itemManager.GetEchoBrands(ref list);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetEchoItems(EchoGeneralFilter filter, ref List<ItemPackModel> itemsList, ref List<int> categoryIds,bool fromFlutter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                #region [Get Items]

                result = _itemManager.GetEchoItems(filter, string.Empty, ref itemsList, fromFlutter);
                if (result != GlobalErrors.Success) return result;
                if (result == GlobalErrors.Success && itemsList != null && itemsList.Count > 0)
                {
                    if (_requestRepository.CurrentEchoOperator.ItemOffers != null && _requestRepository.CurrentEchoOperator.ItemOffers.Count > 0)
                    {
                        itemsList.Where(item => _requestRepository.CurrentEchoOperator.ItemOffers.Any(offerItem => offerItem.ItemId == item.ItemId)).ToList().ForEach(i => i.HasOffer = true);
                    }
                    categoryIds = new List<int>();
                    categoryIds = itemsList.GroupBy(i => i.ItemCategoryId).Select(grp => grp.First().ItemCategoryId).ToList();
                }

                #endregion

                #region [Discount]

                //if (result == GlobalErrors.Success && itemsList != null && itemsList.Count > 0)
                //{
                //    List<ItemDiscountModel> discountList = new List<ItemDiscountModel>();
                //    result = ItemManager.GetAllDiscount(_requestRepository.CurrentEchoOperator.CustomerId, _requestRepository.CurrentEchoOperator.OutletId, ref discountList);
                //    if (result == GlobalErrors.Success && discountList != null && discountList.Count > 0)
                //    {
                //        itemsList.ForEach(i =>
                //        {
                //            var discount = discountList.Find(d => d.PackId == i.PackId);
                //            if (discount != null && discount.Discount > 0)
                //            {
                //                if (discount.DiscountTypeId == DiscountValueTypes.Amount.GetHashCode())
                //                {
                //                    if (_requestRepository.Configurations.ApplyAmountDiscountPerQuantity)
                //                    {
                //                        i.Price = i.Price - discount.Discount;
                //                        if (i.Price < 0)
                //                        {
                //                            i.Price = 0;
                //                        }
                //                    }
                //                    //else Disocunt will be discarded 
                //                }
                //                else
                //                {
                //                    i.Price = i.Price - (i.Price * discount.Discount / 100);
                //                    if (i.Price < 0)
                //                    {
                //                        i.Price = 0;
                //                    }
                //                }
                //                i.Discount = discount.Discount;
                //                i.DiscountTypeId = discount.DiscountTypeId;
                //            }
                //        });
                //    }
                //}

                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetMasterPackGroups(ref List<MasterPackGroupModel> masterPackGroups)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _itemManager.GetMasterPackGroups(ref masterPackGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetEchoHomePageData(ref List<EchoCustomeHomePageModel> homePagesections, ref List<ItemPackModel> itemsList, ref int NotificationCount, EchoGeneralFilter filter)
        {
             GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                // result = _itemManager.GetEchoItemsNew(ref itemsList);
                string orderId = string.Empty;
                result = _itemManager.GetEchoItems(filter, orderId, ref itemsList, true);

                if (result == GlobalErrors.Success && itemsList != null && itemsList.Count > 0)
                {
                    List<EchoCustomeHomePageModel> echoCustomeHomePageModel = new List<EchoCustomeHomePageModel>();
                    result = _itemManager.getMainCustomeHomePageDetails(ref echoCustomeHomePageModel);

                    if (result == GlobalErrors.Success && echoCustomeHomePageModel != null && echoCustomeHomePageModel.Count > 0)
                    {
                        homePagesections = new List<EchoCustomeHomePageModel>();
                        foreach (EchoCustomeHomePageModel part in echoCustomeHomePageModel)
                        {
                            if (part.SectionTypeId == EchoCustomeHomePageTypes.Brands.GetHashCode())
                            {
                                var dataList = itemsList.
                                      Where(x => x.BrandInCustomerApp && x.BrandId != -1).
                                      GroupBy(x => x.BrandId).
                                      Select(grp => grp.First()).
                                      Select(t => new EchoCustomeHomePageDataList
                                      {
                                          SectionTypeId = EchoCustomeHomePageTypes.Brands.GetHashCode(),
                                          Id = t.BrandId,
                                          Name = t.Brand,
                                          Selected = part.Selected
                                      }).ToList();
                                if (dataList.Count > 0)
                                {
                                    EchoCustomeHomePageModel obj = new EchoCustomeHomePageModel();
                                    obj.SectionTypeId = EchoCustomeHomePageTypes.Brands.GetHashCode();
                                    obj.SectionName = ResourcesManager.TranslateKey(MessagesConstants.Desc_echo_Brands, _requestRepository.LanguageId);
                                    obj.Sequence = part.Sequence;
                                    obj.dataList = dataList;
                                    homePagesections.Add(obj);
                                }
                            }

                            if (part.SectionTypeId == EchoCustomeHomePageTypes.Categories.GetHashCode())
                            {
                                var dataList = itemsList.
                                   Where(x => x.ItemCategoryInCustomerApp && x.ItemCategoryId != -1).
                                   GroupBy(x => x.ItemCategoryId).
                                   Select(grp => grp.First()).
                                   Select(t => new EchoCustomeHomePageDataList
                                   {
                                       SectionTypeId = EchoCustomeHomePageTypes.Categories.GetHashCode(),
                                       Id = t.ItemCategoryId,
                                       Name = t.Category,
                                       Selected = part.Selected
                                   }).ToList();
                                if (dataList.Count > 0)
                                {
                                    EchoCustomeHomePageModel obj = new EchoCustomeHomePageModel();
                                    obj.SectionTypeId = EchoCustomeHomePageTypes.Categories.GetHashCode();
                                    obj.SectionName = obj.SectionName = ResourcesManager.TranslateKey(MessagesConstants.Desc_echo_Categories, _requestRepository.LanguageId);
                                    obj.Sequence = part.Sequence;
                                    obj.dataList = dataList;
                                    homePagesections.Add(obj);
                                }
                            }

                            if (part.SectionTypeId == EchoCustomeHomePageTypes.MasterGroupes.GetHashCode())
                            {
                                List<EchoCustomeHomePageModel> itemGroupSection = new List<EchoCustomeHomePageModel>();
                                List<ItemPackModel> groupItems = new List<ItemPackModel>();
                                result = _itemManager.GetMasterGroupesItems(ref groupItems, true);
                                if (result == GlobalErrors.Success)
                                {
                                    if (groupItems != null && groupItems.Count > 0)
                                    {
                                        var itemsListTemp = itemsList.ToList();
                                        var ItemsInItemsGroupesNotFoundInItemList = groupItems.Where(p => itemsListTemp.All(p2 => p2.ItemId != p.ItemId)).ToList();
                                        for (int i = 0; i < ItemsInItemsGroupesNotFoundInItemList.Count(); i++)
                                        {
                                            groupItems.RemoveAll(groupItems => groupItems.ItemId == ItemsInItemsGroupesNotFoundInItemList[i].ItemId);
                                        }
                                        result = GetGroupesStructure(groupItems, ref itemGroupSection);
                                        if (result == GlobalErrors.Success)
                                        {
                                            homePagesections.AddRange(itemGroupSection);
                                        }
                                    }
                                }
                                else return result;
                            }

                            if (part.SectionTypeId == EchoCustomeHomePageTypes.Special.GetHashCode())
                            {
                                EchoCustomeHomePageModel obj = new EchoCustomeHomePageModel();
                                obj.SectionTypeId = EchoCustomeHomePageTypes.Special.GetHashCode();
                                obj.SectionName = ResourcesManager.TranslateKey(MessagesConstants.Desc_echo_Special, _requestRepository.LanguageId);
                                obj.Sequence = part.Sequence;
                                if (itemsList.Any(x => x.IsCustomerAppMostSelling))
                                    obj.dataList.Add(new EchoCustomeHomePageDataList(obj.SectionTypeId, EchoSpecialItemsTypes.TopSailing.GetHashCode(), ResourcesManager.TranslateKey(MessagesConstants.Desc_Most_Selling, _requestRepository.LanguageId), false));

                                if (itemsList.Any(x => x.IsNew))
                                    obj.dataList.Add(new EchoCustomeHomePageDataList(obj.SectionTypeId, EchoSpecialItemsTypes.IsNew.GetHashCode(), ResourcesManager.TranslateKey(MessagesConstants.Desc_IsNew, _requestRepository.LanguageId), false));

                                if (itemsList.Any(x => x.IsInitiative))
                                    obj.dataList.Add(new EchoCustomeHomePageDataList(obj.SectionTypeId, EchoSpecialItemsTypes.IsInitiative.GetHashCode(), ResourcesManager.TranslateKey(MessagesConstants.Desc_IsInitiactive, _requestRepository.LanguageId), false));

                                if (itemsList.Any(x => x.IsPowerSKU))
                                    obj.dataList.Add(new EchoCustomeHomePageDataList(obj.SectionTypeId, EchoSpecialItemsTypes.IsPowerSKU.GetHashCode(), ResourcesManager.TranslateKey(MessagesConstants.Desc_isPowerSKU, _requestRepository.LanguageId), false));
                                if (obj.dataList.Count > 0)
                                    homePagesections.Add(obj);
                            }
                        }
                    }
                }
                if(result == GlobalErrors.Success)
                {
                    result = _notificationService.GetEchoNotificationCount(ref NotificationCount);
                }

            }

            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetGroupesStructure(List<ItemPackModel> itemPacks, ref List<EchoCustomeHomePageModel> ItemGroupSection)
        {

            try
            {
                var distinctItemGroups = itemPacks.GroupBy(s => new { s.MasterItemGroupID }).Select(s => s.First()).ToList();
                var distinctItemsPerdistinctItemGroup = itemPacks.GroupBy(s => new { s.ItemGroupID }).Select(s => s.First()).ToList();
                ItemGroupSection = new List<EchoCustomeHomePageModel>();
                ItemGroupSection = distinctItemGroups.Select(a => new EchoCustomeHomePageModel()
                {
                    SectionTypeId = EchoCustomeHomePageTypes.MasterGroupes.GetHashCode(),
                    MasterGroupId = a.MasterItemGroupID,
                    SectionName = a.MasterItemGroup,
                    Sequence = 0,
                    Enabled = true,
                    dataList = distinctItemsPerdistinctItemGroup.Where(i => i.MasterItemGroupID == a.MasterItemGroupID).Select(i => new EchoCustomeHomePageDataList()
                    {
                        SectionTypeId = EchoCustomeHomePageTypes.MasterGroupes.GetHashCode(),
                        Id = i.ItemGroupID,
                        Name = i.ItemGroup,
                        Selected = false,
                        ItemsIds = itemPacks.Where(z => z.ItemGroupID == i.ItemGroupID && z.MasterItemGroupID == i.MasterItemGroupID).Select(item => item.ItemId).ToList(),
                    }).ToList(),
                }).ToList();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors SaveCustomerBasket(BasketModel basket)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                result = _itemManager.DeleteCustomerBasket(dBHelper);
                if (result == GlobalErrors.Success)
                {
                    foreach (var pack in basket.Packs)
                    {
                        result = _itemManager.SaveCustomerBasket(pack, basket.Token, dBHelper);
                        if (result != GlobalErrors.Success)
                            return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors savePackRate(RateModel rate)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                result = _itemManager.SetPackRate(dBHelper,rate);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }
        #endregion [ECHO]

    }
}