﻿using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Enums;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.NetworkInformation;
using System.Reflection;
using GlobalErrors = Sonic.Web.Model.GlobalErrors;
using InCube.Security;
using Sonic.Web.Licensing.Models;

namespace Sonic.Web.Service
{
    public class LoginService
    {
        private readonly LoginManager _loginManager;
        private readonly IRequestRepository _requestRepository;
        private readonly IActiveTokens _IactiveToken;

        public LoginService(IRequestRepository requestRepository, IActiveTokens activeToken)
        {
            _requestRepository = requestRepository;
            _IactiveToken = activeToken;
            _loginManager = new LoginManager(requestRepository);

        }

        #region [SONIC]

        public static GlobalErrors Login(string username, string password, ref OperatorModel operatorModel, bool isCRM,ref List<CRMMenuModel> teleRepMenus)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (string.IsNullOrEmpty(username) || string.IsNullOrEmpty(password))
                {
                    return GlobalErrors.Error;
                }
                password = EncryptionManager.Instance.EncryptPassword(password);
                result = LoginManager.Login(username, password, ref operatorModel, isCRM);
                if (result == GlobalErrors.Success && operatorModel != null && operatorModel.EmployeeTypeId == Sonic.Web.Model.EmployeeTypes.TeleRep.GetHashCode())
                {
                    result = LoginManager.GetCRMMenus(ref operatorModel, ref teleRepMenus);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public static GlobalErrors Logout()
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                //result = CoreSession.RemoveSession();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertSessionToDB(ILicensing _licensing, string sessionId, int employeeId, SonicModules moduleId , string browserName)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                result = (GlobalErrors)_licensing.InsertSessionToDB(sessionId
                             , employeeId
                             , DateTime.Now.AddHours(LocalUtilities.SessionExpiryHours) // AddHours(LocalUtilities.SessionExpiryWeb)
                             , moduleId
                             , browserName);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors SaveDeviceToken(int employeeId, String DeviceToken)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _loginManager.InsertSupervisorAppDeviceToken(DeviceToken, employeeId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;

        }


        public GlobalErrors Login(OperatorForLogin operatorData, ILicensing _licensing, ref OperatorModel operatorModel, ref List<MenuModel> AllAvailableMenus, ref List<MenuModel> addedMenu, ref string errorMessage, int langId, ref bool showPrivacy, ref List<OrganizationModel> operatorOrganizations, string remoteIpAddress = "" , bool CheckEnableActiveDirectoryLogin = false , bool ValidADLogin = false , string browserName = "")
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            int employeeId = -1;
            showPrivacy = false;
            try
            {
                if (string.IsNullOrEmpty(operatorData.Username) || string.IsNullOrEmpty(operatorData.Password))
                {
                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, langId);
                    return GlobalErrors.Error;
                }

                result = _loginManager.SimpleLogin(operatorData.Username, operatorData.Password, operatorData.DeviceInfo, ref operatorModel, ref errorMessage, langId, remoteIpAddress , CheckEnableActiveDirectoryLogin , ValidADLogin);
                if (result == GlobalErrors.Success && operatorModel != null)
                {
                    employeeId = operatorModel.EmployeeId;

                    #region[Sessions]
                    if (operatorModel.EmployeeId != 0 && IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() != LocalUtilities.DomainName)
                    {
                        // 0. ValidateLicense
                        //result = (GlobalErrors)_licensing.ValidateLicense(langId, ref errorMessage);
                        //if (result != GlobalErrors.Success)
                        //{
                        //    errorMessage = ResourcesManager.TranslateKey(errorMessage, langId);
                        //    return result;
                        //}

                        // 1. Remove other active sessions for employee on diff machines
                        //if (operatorData.RemoveCurrentOperatorSession)
                        //{
                        //    result = (GlobalErrors)_licensing.RemoveAllEmployeeSessionFromDB(employeeId, SonicModules.SonicWeb);
                        //    if (result != GlobalErrors.Success)
                        //    {
                        //        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Remove_Session, langId);
                        //        return result;
                        //    }
                        //}

                        // 2. validate sessions count
                        //result = (GlobalErrors)_licensing.IsValidNumberOfConcurrentSessions(employeeId, SonicModules.SonicWeb, langId, ref errorMessage ,operatorData.KeepCurrentOperatorSessions , browserName);
                        //if (result != GlobalErrors.Success)
                        //{
                        //    errorMessage = ResourcesManager.TranslateKey(errorMessage, langId);
                        //    return result;
                        //}
                    }
                    #endregion

                    // Selecting an org on Login
                    if (result == GlobalErrors.Success && operatorModel != null && operatorModel.EmployeeId > -1 &&  _requestRepository.Configurations.ForceOrganizationSelectionOnLogin && operatorData.SelectOrganization)
                    {
                        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Need_Org_Access, langId);                        
                        result = _loginManager.GetEmployeeOrganizationAccess(ref operatorOrganizations , employeeId);
                        return result = GlobalErrors.NeedOrganizationSelection;
                    }
                    result = _loginManager.GetlandingMenus(ref operatorModel);

                    if (result == GlobalErrors.Success)
                    {
                        #region [Encrypt Operator Data]

                        operatorModel.EncryptedEmployeeId = EncryptionManager.Instance.EncryptData(operatorModel.EmployeeId.ToString());
                        operatorModel.EncryptedOperatorId = EncryptionManager.Instance.EncryptData(operatorModel.OperatorId.ToString());

                        #endregion [Encrypt Operator Data]
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _loginManager.GetMenus(ref operatorModel, ref AllAvailableMenus, ref addedMenu, langId);
                    }
                    if (result == GlobalErrors.Success && _requestRepository.Configurations.ShowPrivacyPolicy)
                    {
                        //check the Privacy policy
                        result = PrivacyManager.CheckPrivacyPolicy(operatorModel.EmployeeId, ref showPrivacy);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        
        public void SetLanguage(int languageId)
        {
            try
            {
                _requestRepository.LanguageId = languageId;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public GlobalErrors GetExternalURLs(ref List<ExternalURLModel> externalURLs)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _loginManager.GetExternalURLs(ref externalURLs);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateLoginStatus(string deviceInfo, int operatorId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _loginManager.UpdateLoginStatus(deviceInfo, operatorId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetNumberofLoginOperator(ref object objField,int operatorId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _loginManager.GetNumberofLoginOperator(ref objField, operatorId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        

        #endregion [SONIC]

        #region [APIs]

        public GlobalErrors SimpleLogin(string Username, string Password, ref OperatorModel Operator, ref string ErrorMessage, int LanguageId)
        {
            try
            {
                return _loginManager.SimpleLogin(Username, Password, "", ref Operator, ref ErrorMessage, LanguageId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        #endregion [APIs]

        #region [ECHO CUSTOMER APP]

        public static GlobalErrors EchoLogin(EchoOperatorLoginModel loginOperator, ref EchoOperatorModel operatorModel, ref string errorMessage, ref CustomerAppSettingsModel customerAppSettingsModel, int langId, ref List<OrganizationModel> organizationsList)
        {
            try
            {
                string ForceCustomerOrganizationSelection = "false";
                if (string.IsNullOrEmpty(loginOperator.UserName) || string.IsNullOrEmpty(loginOperator.Password))
                {
                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, langId);
                    return GlobalErrors.Error;
                }
                string version = string.Empty;
                GlobalErrors err = ConfigurationManager.GetConfigurationGeneralValue(ConfigurationConstants.CurrentCustomerAppVersion, ref version);
                if (err == GlobalErrors.Success)
                {
                    err = ConfigurationManager.GetConfigurationGeneralValue(ConfigurationConstants.ForceCustomerOrganizationSelection, ref ForceCustomerOrganizationSelection);
                }
                if (err == GlobalErrors.Success && loginOperator.AppVersion.Equals(version))
                {
                    List<EchoOperatorModel> operatorList = new List<EchoOperatorModel>();
                    err = LoginManager.EchoLogin(loginOperator.UserName, loginOperator.Password, ref operatorList, langId);
                    if (err == GlobalErrors.Success)
                    {
                        if (true || operatorList != null && operatorList.Count > 0)
                        {
                            operatorList.RemoveAll(op => op.Active == false);
                            if (operatorList.Count > 0)
                            {
                                EchoOperatorModel tempModel = null;
                                int customerId = -1;

                                foreach (EchoOperatorModel model in operatorList)
                                {
                                    operatorModel = model;

                                    if (loginOperator.FromFlutter && ForceCustomerOrganizationSelection.ToLower() == "true")
                                    {
                                        organizationsList = new List<OrganizationModel>();
                                        err = LoginManager.GetOrganizationsList(operatorModel.OperatorId, langId, ref organizationsList);
                                        if (err != GlobalErrors.Success)
                                        {
                                            return err;
                                        }
                                        if (err == GlobalErrors.Success && organizationsList != null && organizationsList.Count > 1 && loginOperator.OrganizationId == -1)
                                        {
                                            err = GlobalErrors.EchoCustomerMultiAccount;
                                            //model.CustomerOutletId = "'" + tempModel.CustomerId + "-" + tempModel.OutletId + "'";
                                            //return err;
                                        }
                                    }


                                    err = LoginManager.GetEchoCachedData(operatorModel.CustomerId, operatorModel.OutletId, loginOperator.OrganizationId, ref tempModel);
                                    if (err == GlobalErrors.Success)
                                    {
                                        if (tempModel != null && (tempModel.CustomerId > -1 || tempModel.CustomerId == LocalUtilities.GestCustomerId) && !string.IsNullOrEmpty(tempModel.DivisionIds))
                                        {
                                            customerId = tempModel.CustomerId;
                                            operatorModel.DivisionIds = tempModel.DivisionIds;
                                            operatorModel.RouteLoadingWarehouseIds = tempModel.RouteLoadingWarehouseIds;
                                            operatorModel.RouteEmployeeId = tempModel.RouteEmployeeId;
                                            operatorModel.RouteOperatorId = tempModel.RouteOperatorId;
                                            operatorModel.RouteOrganizationId = tempModel.RouteOrganizationId;
                                            operatorModel.RouteVehicleId = tempModel.RouteVehicleId;
                                            errorMessage = string.Empty;
                                            operatorModel.NumberOfDigit = tempModel.NumberOfDigit;
                                            operatorModel.NumberOfStockDigits = tempModel.NumberOfStockDigits;
                                            operatorModel.EchoFirstDiscountCustomerOutlet = tempModel.EchoFirstDiscountCustomerOutlet;
                                            operatorModel.AppVersion = LocalUtilities.AppVersion;
                                            operatorModel.CurrencyCode = tempModel.CurrencyCode;
                                            operatorModel.CustomerOutletId = "'" + tempModel.CustomerId + "-" + tempModel.OutletId + "'";
                                            operatorModel.OperatorCustomers.Add(new OperatorCustomerModel(tempModel.CustomerId, tempModel.OutletId, tempModel.RouteEmployeeId, tempModel.MainDivisionId));
                                            break;
                                        }
                                        else
                                        {
                                            errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Customer_Not_Having_Data_To_Show, langId);
                                        }
                                    }
                                    else
                                    {
                                        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Customer_Not_Having_Data_To_Show, langId);
                                    }
                                }
                                if (errorMessage != string.Empty)
                                    return GlobalErrors.Error;
                                if (operatorList.Count > 1)
                                {
                                    operatorModel.isMultiUser = true;

                                    foreach (EchoOperatorModel model in operatorList)
                                    {
                                        if (model.CustomerId != operatorModel.CustomerId || (model.CustomerId == operatorModel.CustomerId && model.OutletId != operatorModel.OutletId))
                                        {
                                            tempModel = new EchoOperatorModel();
                                            err = LoginManager.GetEchoCachedData(model.CustomerId, model.OutletId, loginOperator.OrganizationId, ref tempModel);
                                            if (tempModel != null && tempModel.CustomerId > 0 && !string.IsNullOrEmpty(tempModel.DivisionIds))
                                            {
                                                model.DivisionIds = tempModel.DivisionIds;
                                                model.RouteLoadingWarehouseIds = tempModel.RouteLoadingWarehouseIds;
                                                model.RouteEmployeeId = tempModel.RouteEmployeeId;
                                                model.RouteOrganizationId = tempModel.RouteOrganizationId;
                                                model.RouteVehicleId = tempModel.RouteVehicleId;
                                                model.CustomerOutletId = "'" + tempModel.CustomerId + "-" + tempModel.OutletId + "'";
                                                operatorModel.OperatorCustomers.Add(new OperatorCustomerModel(model.CustomerId, model.OutletId, model.RouteEmployeeId, tempModel.MainDivisionId));
                                            }
                                        }
                                    }
                                }
                                operatorModel.DivisionIds = string.Join(",", operatorList.Select(o => o.DivisionIds).Distinct());
                                operatorModel.RouteLoadingWarehouseIds = string.Join(",", operatorList.Select(o => o.RouteLoadingWarehouseIds).Distinct());
                                operatorModel.RouteEmployeeIds = string.Join(",", operatorList.Select(o => o.RouteEmployeeId).Distinct());
                                operatorModel.RouteOrganizationIds = string.Join(",", operatorList.Select(o => o.RouteOrganizationId).Distinct());
                                operatorModel.RouteVehicleIds = string.Join(",", operatorList.Select(o => o.RouteVehicleId).Distinct());
                                operatorModel.CustomerOutletIds = string.Join(",", operatorList.Select(o => o.CustomerOutletId).Distinct());
                                List<ItemOffers> itemOffers = new List<ItemOffers>();
                                GlobalErrors result = LoginManager.GetItemOfferList(operatorModel, ref itemOffers, ForceCustomerOrganizationSelection);
                                if (result == GlobalErrors.Success && itemOffers != null && itemOffers.Count > 0)
                                {
                                    operatorModel.ItemOffers = itemOffers;
                                }
                              


                                LoginManager.SaveCustomerLoginHisotry(operatorModel.OperatorId, CustomerLoginSource.Echo);
                                return GlobalErrors.Success;
                            }
                            else
                            {
                                errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Customer_Is_Inactive, langId);
                                return GlobalErrors.Error;
                            }
                        }
                        else
                        {
                            errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, langId);
                            return GlobalErrors.Error;
                        }
                    }
                    else
                    {
                        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, langId);
                        return GlobalErrors.Error;
                    }
                }
                else
                    return GlobalErrors.VersionNotMatch;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public static GlobalErrors GetSettingsWhenPublishingIOSConfig(ref dynamic keyValue)
        {
            try
            {
                ConfigurationManager _configurationManager = new ConfigurationManager(null);
                keyValue = false;
                GlobalErrors result = _configurationManager.GetConfigurationValueFromDB(ConfigurationConstants.SettingsWhenPublishingIOS, ref keyValue);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }
        #endregion [ECHO CUSTOMER APP]

        #region [STOREKEEPER APP]
        public static GlobalErrors StorekeeperLogin(OperatorLoginModel loginOperator, ref StorekeeperOperatorModel storekeeperModel, ref string errorMessage, int langId)
        {
            try
            {
                if (string.IsNullOrEmpty(loginOperator.Username) || string.IsNullOrEmpty(loginOperator.Password))
                {
                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, langId);
                    return GlobalErrors.Error;
                }
                string version = string.Empty;
                storekeeperModel = new StorekeeperOperatorModel();
                GlobalErrors err = ConfigurationManager.GetConfigurationGeneralValue(ConfigurationConstants.CurrentStorekeeperAppVersion, ref version);
               
                if (err == GlobalErrors.DatabaseConnection)
                    return err;
                if (err == GlobalErrors.Success)
                {
                    if (loginOperator.AppVersion.Equals(version))
                    {
                        err = LoginManager.StorekeeperLogin(loginOperator.Username, loginOperator.Password, ref storekeeperModel, langId);
                        if (err == GlobalErrors.Success)
                        {
                            if (storekeeperModel != null)
                            {
                                if (!storekeeperModel.Inactive)
                                {
                                 
                                        List<string> menuIds = new List<string>();
                                        err = LoginManager.GetStorekeeperMenus(storekeeperModel.OperatorId, ref menuIds);
                                        if (err == GlobalErrors.Success && menuIds != null && menuIds.Count > 0)
                                        {
                                            storekeeperModel.AppVersion = version;
                                            storekeeperModel.MenuIds = menuIds;

                                            StorekeeperOperatorModel model = new StorekeeperOperatorModel();
                                            err = LoginManager.GetStorekeeperCachedData(storekeeperModel.EmployeeId, langId, ref model);
                                            if (err == GlobalErrors.Success)
                                            {

                                                storekeeperModel.ConfigurationList = model.ConfigurationList;
                                                storekeeperModel.EmployeeCode = model.EmployeeCode;
                                                storekeeperModel.EmployeeName = model.EmployeeName;
                                                storekeeperModel.OrganizationId = model.OrganizationId;
                                                storekeeperModel.OrgnizationIds = model.OrgnizationIds;
                                                storekeeperModel.DivisionIds = model.DivisionIds;
                                                storekeeperModel.DivisionList = model.DivisionList;
                                                //storekeeperVehicleLoadingWarehouses = WarehouseManager.GetStorekeeperVehicleLoadingWarehouses(storekeeperModel.EmployeeId, langId);
                                                //storekeeperVehicleOffLoadingWarehouses = WarehouseManager.GetStorekeeperVehicleOffloadingWarehouses(storekeeperModel.EmployeeId, langId);
                                            }
                                            return err;
                                        }
                                        else
                                        {
                                            errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Storekeeper_Menus, langId);
                                            return GlobalErrors.Error;
                                        }
                                    
                                  
                                }
                                else
                                {
                                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Employee_Is_Inactive, langId);
                                    return GlobalErrors.Error;
                                }
                            }
                            else
                            {
                                errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, langId);
                                return GlobalErrors.Error;
                            }
                        }
                        else
                        {
                            errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, langId);
                            return GlobalErrors.Error;
                        }
                    }
                    else
                        return GlobalErrors.VersionNotMatch;
                }
                else
                    return GlobalErrors.Error;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public static GlobalErrors CheckDeviceLic(string deviceSerial, ref bool isLicensed)
        {
            try
            {
                return LoginManager.CheckDeviceLic(deviceSerial, ref isLicensed);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }       
        public static void LoadDevicesSerialNumber()
        {
            try
            {
                string encFilePath = Path.Combine(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase), "Devices.enc");
                encFilePath = encFilePath.TrimStart("file:\\".ToCharArray());
                if (System.IO.File.Exists(encFilePath))
                {
                    InCube.Sync.Licensing.BackSyncLicense.LoadSerials(encFilePath);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        #endregion

        #region [Session Screen]
        public GlobalErrors GetAllSessions(ref List<SessionInfoModel> sessionsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                return _loginManager.GetAllSessions(ref sessionsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }  
        
        public GlobalErrors InsertIntoConcurrentSessionsLogsHistory(SessionInfoModel sessionInfoModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                return _loginManager.InsertIntoConcurrentSessionsLogsHistory(sessionInfoModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        #endregion
    }
}