﻿using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.MasterData;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.Services;
using System;
using System.Collections.Generic;
using System.Data;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Service
{
    public class MasterDataService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly MasterDataManager _masterDataManager;
        public MasterDataService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _masterDataManager = new MasterDataManager(_requestRepository);
        }
        public GlobalErrors GetOrganizationList(int excludedOrganizationId, ref List<OrganizationModel> organizationList , bool isFromStaffEmployeeOrgAccess)
        {
            try
            {
                return _masterDataManager.GetOrganizationList(excludedOrganizationId, ref organizationList , isFromStaffEmployeeOrgAccess);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                organizationList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetDistributorOrganizations(ref List<OrganizationModel> organizationList)
        {
            try
            {
                return _masterDataManager.GetOrganizationList(-1, false, true, ref organizationList , false);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                organizationList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetBanks(ref List<BankModel> banksList)
        {
            try
            {
                return _masterDataManager.GetBanks(ref banksList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                banksList = null;
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetSecurityGroupsList(int employeeId, int organizationId, ref List<SecurityGroupModel> securityGroupsList , bool isFromApprovalCyclePromotion)
        {
            try
            {
                return _masterDataManager.GetSecurityGroupsList(employeeId, organizationId, ref securityGroupsList, isFromApprovalCyclePromotion);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                securityGroupsList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors CheckIfUniqueValue(string tableName, string columnName, string insertedValue, string excludedString, ref bool isUniqueValue)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _masterDataManager.CheckIfUniqueValue(tableName, columnName, insertedValue, excludedString, ref isUniqueValue, null);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckIfUniqueValue(string tableName, string columnName, string insertedValue, string excludedString, ref bool isUniqueValue, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _masterDataManager.CheckIfUniqueValue(tableName, columnName, insertedValue, excludedString, ref isUniqueValue, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ValidateEmployeeDeviceToSave(DeviceModel device, ref bool isValid, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                bool isUniqueEmployeeDeviceSerial = false;
                result = _masterDataManager.CheckIfUniqueDeviceSerial(device, ref isUniqueEmployeeDeviceSerial, null);
                if (result == GlobalErrors.Success && !isUniqueEmployeeDeviceSerial)
                {
                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Unique_Serial, _requestRepository.LanguageId);
                    isValid = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckIfUniqueDescription(UniqueDescriptionModel uniqueDescription, ref bool isUniqueValue)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (TextLanguage textLanguage in uniqueDescription.descriptionLanguages)
                {
                    if (string.IsNullOrEmpty(textLanguage.Description))
                    {
                        textLanguage.Description = uniqueDescription.insertedValue;
                    }

                    result = _masterDataManager.CheckIfUniqueDescription(uniqueDescription.tableName, uniqueDescription.columnName, uniqueDescription.excludedString, ref isUniqueValue, textLanguage.Description);
                    if (result != GlobalErrors.Success || !isUniqueValue)
                        break;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveDevice(DeviceModel device)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _masterDataManager.SaveDevice(device);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveCreditRelease(DeviceModel device)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _masterDataManager.SaveDevice(device);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetDevicesList(int employeeId, int organizationId, bool getFreeDevicesOnly, ref List<DeviceModel> devicesList)
        {
            try
            {
                return _masterDataManager.GetDevicesList(employeeId, organizationId, getFreeDevicesOnly, ref devicesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                devicesList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveBarcodeTemplate(BarcodeTemplateModel templateObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _masterDataManager.SaveBarcodeTemplate(templateObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAllBarcodeTemplates(GeneralFilter filter, ref SharedTableResult<BarcodeTemplateModel> templates)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<TextLanguage> descriptions = new List<TextLanguage>();
                List<TemplateFieldModel> fields = new List<TemplateFieldModel>();
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                result = _masterDataManager.GetAllBarcodeTemplates(filter, ref templates);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                templates = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetTemplateDescriptions(int templateId, ref List<TextLanguage> descriptions)
        {
            try
            {
                return _masterDataManager.GetTemplateDescriptions(templateId, ref descriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetTemplateDetails(int templateId, ref List<TemplateFieldModel> fields)
        {
            try
            {
                return _masterDataManager.GetTemplateDetails(templateId, ref fields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                fields = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors EditBarcodeTemplate(BarcodeTemplateModel templateObj)
        {
            try
            {
                return _masterDataManager.EditBarcodeTemplate(templateObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors AllowToDeleteBarcodeTemplate(int templateId, ref string response)
        {
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                if (_masterDataManager.IsTemplateLinkedToPack(templateId, dBHelper))
                {
                    response = ResourcesManager.TranslateKey(MessagesConstants.Desc_Template_Linked_To_Item, _requestRepository.LanguageId);
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors DeleteBarcodeTemplate(int templateId)
        {
            try
            {
                return _masterDataManager.DeleteBarcodeTemplate(templateId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetTemplateFields(ref List<TemplateFieldModel> templateFields)
        {
            try
            {
                return _masterDataManager.GetTemplateFields(ref templateFields); 
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                templateFields = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetActivateDeactivateReason(MasterDataScreens screen, MasterDataStatus status,ref List<dynamic> reasonsList)
        {
            try
            {
                return _masterDataManager.GetActivateDeactivateReason(screen,status,ref reasonsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors InsertAuditMasterReason(AuditMasterData auditMaster)
        {
            try
            {
                return _masterDataManager.InsertAuditMasterReason(auditMaster,false,null);
            }
            catch(Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors CheckIfDeviceLinkedToUploadedRoute(DeviceModel employeeDevice, ref bool isUploadedRoute)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _masterDataManager.CheckIfDeviceLinkedToUploadedRoute(employeeDevice, ref isUploadedRoute);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


    }
}