﻿using DinkToPdf;
using DinkToPdf.Contracts;
using Microsoft.AspNetCore.Hosting;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Xml;

namespace Sonic.Web.Service
{
    public class TemplateGenerator
    {
        private readonly IRequestRepository _requestRepository;
        private readonly TransactionManager _transactionManager;
        private readonly IHostingEnvironment _hostingEnvironment;
        private IConverter _converter;
        private  ConfigurationService _configurationService;
        public TemplateGenerator(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _transactionManager = new TransactionManager(requestRepository);
            _configurationService = new ConfigurationService(requestRepository);
        }
        public TemplateGenerator(IRequestRepository requestRepository, IHostingEnvironment hostingEnvironment, IConverter converter)
        {
            _requestRepository = requestRepository;
            _transactionManager = new TransactionManager(requestRepository);
            _hostingEnvironment = hostingEnvironment;
            _converter = converter;
        }

        public string GetOrderHTMLString(TransactionHistory transaction)
        {
            var transactionDetails = new List<ItemPackModel>();

            var result = _transactionManager.GetOrderDetailsAsReport(transaction, ref transactionDetails);
            var numberOfDigits = _requestRepository.Configurations.NumberOfDigits;
            var sb = new StringBuilder();
            var detailsSection = new StringBuilder();
            var serailNumber = 1;

            detailsSection.Append(@"<tr bgcolor='#b0c4de'>
                            <td width='35' height='23'>
                                <span class='style12'>&nbsp;SL#</span><br>
                                <span class='style12 invoiceArabic'>&nbsp;الرقم التسلسلي</span>
                            </td>
                            <td width='74' height='23'>
                                <span class='style12'>&nbsp;ITEM CODE</span><br>
                                <span class='style12 invoiceArabic'>&nbsp;رمز الصنف</span>
                            </td>
                            <td width='285' height='23'>
                                <span class='style12'>&nbsp;DESCRIPTION</span><br>
                                <span class='style12 invoiceArabic'>&nbsp;التفاصيل / وصف الصنف</span>
                            </td>
                            <td width='50' height='23'>
                                <span class='style12'>&nbsp;QTY</span><br>

                                <span class='style12 invoiceArabic'>&nbsp;الكمية</span>
                            </td>
                            <td width='50' height='23'>
                                <span class='style12'>&nbsp;UOM</span><br>
                                <span class='style12 invoiceArabic'>&nbsp;وحدة القياس</span>
                            </td>
                            <td width='85' height='23'>
                                <span class='style12'>&nbsp;UNIT GROSS PRICE</span><br>
                                <span class='style12 invoiceArabic'>&nbsp;سعر الوحدة</span>
                            </td>
                            <td width='55' height='23'>
                                <span class='style12'>&nbsp;VAT</span>
                            </td>
                            <td width='88' height='23'>
                                <span class='style12'>&nbsp;TOTAL AMOUNT</span><br>
                                <span class='style12 invoiceArabic'>&nbsp;المجموع</span>
                            </td>
                        </tr>");
            foreach (var detail in transactionDetails)
            {
                detailsSection.AppendFormat(@"<tr>
                                    <td height='23'>&nbsp;{0}</td>
                                    <td height='23' align='left'>&nbsp;{1}</td>
                                    <td height='23' align='left'>
                                     <span style='float: left;'>&nbsp;{2}</span><br>
                                    </td>
                                    <td height='23' align='left'>&nbsp;{3}</td>
                                    <td height='23' align='right'>&nbsp;{4}</td>
                                    <td height='23' align='right'>&nbsp;{5}</td>
                                    <td height='23' align='right'>&nbsp;{6}</td>
                                    <td height='23' align='right'>&nbsp;{7}</td>
                                  </tr>"
                        , serailNumber++
                        , detail.ItemCode
                        , detail.ItemName
                        , detail.Uom
                        , LocalUtilities.GetRoundedDecimal(detail.RequiredQty, _requestRepository.Configurations.NumberOfStockDigits)
                        , LocalUtilities.GetRoundedDecimal(detail.Price, numberOfDigits)
                        , LocalUtilities.GetRoundedDecimal(detail.Tax, numberOfDigits)
                        , LocalUtilities.GetRoundedDecimal(detail.NetTotal, numberOfDigits));

            }



            var path = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "transaction-pdf.html");
            string readText = File.ReadAllText(path);
            sb.AppendFormat(readText
                , "Order"
                , transaction.OrderDate
                , transaction.CustomerName
                , transaction.OutletName
                , transaction.OrderId
                , transaction.TaxNumber
                , transaction.OrderBy
                , transaction.CustomerCode
                , transaction.OutletCode
                , ""
                , ""
                , detailsSection.ToString()
                , LocalUtilities.GetRoundedDecimal(transactionDetails.Sum(x => x.RequiredQty), _requestRepository.Configurations.NumberOfStockDigits)
                , LocalUtilities.GetRoundedDecimal(transactionDetails.Sum(x => x.GrossTotal), numberOfDigits)
                , LocalUtilities.GetRoundedDecimal(transactionDetails.Sum(x => x.Tax), numberOfDigits)
                , LocalUtilities.GetRoundedDecimal(transactionDetails.Sum(x => x.NetTotal), numberOfDigits),
                LocalUtilities.CustomerLogoPath);
            return sb.ToString();
        }
        public string GetTopupHTMLString(TransactionHistory transaction)
        {
            var transactionDetails = new List<ItemPackModel>();

            //var result = _iCashManager.GetTopupDetails(transaction, ref transactionDetails);
            var numberOfDigits = _requestRepository.Configurations.NumberOfDigits;
            var sb = new StringBuilder();
            var detailsSection = new StringBuilder();
            var serailNumber = 1;

            detailsSection.Append(@"<tr bgcolor='#b0c4de'>
                            <td width='35' height='23'>
                                <span class='style12'>&nbsp;SL#</span><br>
                            </td>
                            <td width='74' height='23'>
                                <span class='style12'>&nbsp;Recharge Value</span><br>
                            </td>
                            <td width='50' height='23'>
                                <span class='style12'>&nbsp;Recharge Quantity</span><br>
                            </td>
                            <td width='50' height='23'>
                                <span class='style12'>&nbsp;Bonus Value</span><br>
                            </td>
                            <td width='50' height='23'>
                                <span class='style12'>&nbsp;Bonus Quantity</span><br>
                            </td>
                            <td width='85' height='23'>
                                <span class='style12'>&nbsp;Total</span><br>
                            </td>
                        </tr>");
            foreach (var detail in transactionDetails)
            {
                detailsSection.AppendFormat(@"<tr>
                                    <td height='23' align='left'>&nbsp;{0}</td>
                                    <td height='23' align='right'>&nbsp;{1}</td>
                                    <td height='23' align='right'>&nbsp;{2}</td>
                                    <td height='23' align='right'>&nbsp;{3}</td>
                                    <td height='23' align='right'>&nbsp;{4}</td>
                                    <td height='23' align='right'>&nbsp;{5}</td>
                                  </tr>"
                                , serailNumber++
                                , LocalUtilities.GetRoundedDecimal(detail.RechargeValue, numberOfDigits)
                                , LocalUtilities.GetRoundedDecimal(detail.RechargeQuantity, _requestRepository.Configurations.NumberOfStockDigits)
                                , LocalUtilities.GetRoundedDecimal(detail.BonusValue, numberOfDigits)
                                , LocalUtilities.GetRoundedDecimal(detail.BonusQuantity, _requestRepository.Configurations.NumberOfStockDigits)
                                , LocalUtilities.GetRoundedDecimal(detail.NetTotal, numberOfDigits));
            }


            var path = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "transaction-pdf.html");
            string readText = File.ReadAllText(path);
            sb.AppendFormat(readText
                , "Top up"
                , transaction.InvoiceDate
                , transaction.CustomerName
                , transaction.OutletName
                , transaction.TransactionId
                , transaction.TaxNumber
                , transaction.DeliveredBy
                , transaction.CustomerCode
                , transaction.OutletCode
                , ""
                , ""
                , detailsSection.ToString()
                , LocalUtilities.GetRoundedDecimal(transactionDetails.Sum(x => x.RechargeQuantity) + transactionDetails.Sum(x => x.BonusQuantity), numberOfDigits)
                , LocalUtilities.GetRoundedDecimal(transactionDetails.Sum(x => x.NetTotal), numberOfDigits)
                , LocalUtilities.GetRoundedDecimal(0, numberOfDigits)
                , LocalUtilities.GetRoundedDecimal(transactionDetails.Sum(x => x.NetTotal), numberOfDigits),
                Path.Combine(Directory.GetCurrentDirectory(), "Resources", "Masafi_Logo.jpg"));

            return sb.ToString();
        }
        public static string GetlogoImagePath()
        {
            string notificationAppID = string.Empty;
            try
            {
                string _dataSourceFilePath = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase) + "\\DataSources.xml";
                XmlDocument xmlDoc = new XmlDocument();
                xmlDoc.Load(_dataSourceFilePath);
                if (xmlDoc.SelectSingleNode("Connections/ReportLogoImagePath [Name ='ReportLogoImagePath']/Data") != null)
                    notificationAppID = xmlDoc.SelectSingleNode("Connections/ReportLogoImagePath[Name ='ReportLogoImagePath']/Data").InnerText;

            }
            catch (Exception ex) { }
            return notificationAppID;
        }
        public string GetSurveyHTMLString(SurveyReadingModel surveyReadingModel, SurveyHeaderForPDF surveyHeader)
        {
            var detailsSection = new StringBuilder();
            var imageSelection = new StringBuilder();
            string direction = string.Empty;
            if (_requestRepository.LanguageId == 2)
            {
                direction = " dir = 'rtl'";
            }
            detailsSection.AppendFormat(@" <h2 align='center'>{0}</h2><br>", surveyHeader.SurveyName);
            detailsSection.AppendFormat(@"<h4 {8}> <b>{0}:</b> {1}</h4> 
           <h4 {8}> <b>{2}: </b>{3}</h4>
           <h4 {8}> <b>{4}: </b>{5}</h4>
           <hr>
           <h4 {8}> <b>{6}: </b></h4>
           {7} "
          , ResourcesManager.TranslateKey(MessagesConstants.Desc_Date, _requestRepository.LanguageId),//0
          DateTime.Now.ToString("MM/dd/yyyy"), //1
          ResourcesManager.TranslateKey(MessagesConstants.Desc_Inspector, _requestRepository.LanguageId),//2
          surveyHeader.EmployeeCodeName,//3
          surveyHeader.vehicleWarehouse,//4
          surveyHeader.WarehouseCodeName,//5
           ResourcesManager.TranslateKey(MessagesConstants.Desc_Items, _requestRepository.LanguageId),//6
          surveyHeader.ItemCodeName, direction); //7
            detailsSection.AppendFormat(@"<br>");
            detailsSection.AppendFormat(@"<h4 {1}> <b>{0}</b></h4>", ResourcesManager.TranslateKey(MessagesConstants.Desc_Details_Tap, _requestRepository.LanguageId), direction);
            detailsSection.AppendFormat(@"<ol {0}>", direction);
            foreach (SurveyReadingResultModel result in surveyReadingModel.ResultList)
            {
                detailsSection.AppendFormat(@"<b {0}><li {0}>", direction);
                detailsSection.AppendFormat(@"{0}<br>", result.Field);
                detailsSection.AppendFormat(@"</li></b>");
                detailsSection.AppendFormat(@"{0}<br>", result.Answer);
                if (!string.IsNullOrEmpty(result.AcceptableValueNote))
                    detailsSection.AppendFormat(@"<b {1}>{0}</b>", string.Format(ResourcesManager.TranslateKey(MessagesConstants.Desc_Acceptable_Value, _requestRepository.LanguageId), result.AcceptableValueNote), direction);
                detailsSection.AppendFormat(@"<hr>");
            }
            detailsSection.AppendFormat(@"<ol>");
            return detailsSection.ToString();
        }
        public MemoryStream CreateQualityControlsPDF(HtmlToPdfDocument pdf)
        {

            var file = _converter.Convert(pdf);
            MemoryStream memo = new MemoryStream(file);
            return memo;
        }

        public HtmlToPdfDocument HtmlToPDF(SurveyReadingModel surveyReadingModel, SurveyHeaderForPDF surveyHeader, IConverter converter)
        {
            HtmlToPdfDocument pdf = new HtmlToPdfDocument();
            try
            {
                string pageFooter = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Report_Page_Footer, _requestRepository.LanguageId);
                string ofString = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Of_String, _requestRepository.LanguageId);
                string footer = string.Format("{0} [page] {1} [toPage]", pageFooter, ofString);
                var globalSettings = new GlobalSettings
                {
                    ColorMode = ColorMode.Color,
                    Orientation = Orientation.Portrait,
                    PaperSize = PaperKind.A4,
                    Margins = new MarginSettings { Top = 10, Left = 3, Right = 3 },
                    DocumentTitle = ResourcesManager.TranslateKey(MessagesConstants.Desc_Quality_Control_Report, _requestRepository.LanguageId),
                    DPI = 500
                };
                var objectSettings = new ObjectSettings
                {
                    UseLocalLinks = true,
                    PagesCount = true,
                    HtmlContent = GetSurveyHTMLString(surveyReadingModel, surveyHeader),
                    WebSettings = { DefaultEncoding = "utf-8", UserStyleSheet = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "styles.css"), LoadImages = true },
                    HeaderSettings = { FontName = "Arial", FontSize = 9 },
                    FooterSettings = { FontName = "Arial", FontSize = 9, Left = DateTime.Now.ToString(), Right = footer, Spacing = 1.8 }
                };

                pdf = new HtmlToPdfDocument()
                {
                    GlobalSettings = globalSettings,
                    Objects = { objectSettings }
                };
                var file = converter.Convert(pdf);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return pdf;
        }
        public bool GetImagesToRootFolder(string key)
        {
            string fileName = string.Empty;
            string sourceFilePath = LocalUtilities.ProofImagesSourcePath + "\\" + key.Split('_')[0];
            string targetFilePath = LocalUtilities.ProofImagesDistPath;
            string sourceFile = string.Empty;
            string targetFile = string.Empty;
            try
            {
                // Use Path class to manipulate file and directory paths.
                sourceFile = Path.Combine(sourceFilePath, fileName);
                targetFile = Path.Combine(targetFilePath, fileName);

                // To copy a folder's contents to a new location:
                // Create a new target folder.
                // If the directory already exists, this method does not create a new directory.
                if (!Directory.Exists(targetFilePath))
                {
                    Directory.CreateDirectory(targetFilePath);
                }

                if (Directory.Exists(sourceFilePath))
                {
                    string[] files = Directory.GetFiles(sourceFilePath, key + "*.*");

                    // Copy the files and overwrite destination files if they already exist.
                    foreach (string s in files)
                    {
                        // Use static Path methods to extract only the file name from the path.
                        fileName = Path.GetFileName(s);
                        targetFile = Path.Combine(targetFilePath, fileName);
                        File.Copy(s, targetFile, true);
                    }
                }
                else
                {
                    return false;
                }

                return true;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        public bool DeleteImages(string key, List<string> files)
        {
            string fileName = string.Empty;
            string sourceFilePath = LocalUtilities.ProofImagesSourcePath + "\\" + key.Split('_')[0];
            string targetFilePath = LocalUtilities.ProofImagesDistPath;
            string sourceFile = string.Empty;
            string targetFile = string.Empty;
            try
            {
                // Use Path class to manipulate file and directory paths.
                sourceFile = Path.Combine(sourceFilePath, fileName);
                targetFile = Path.Combine(targetFilePath, fileName);

                // To copy a folder's contents to a new location:
                // Create a new target folder.
                // If the directory already exists, this method does not create a new directory.

                if (Directory.Exists(targetFilePath))
                {
                    //string[] files = Directory.GetFiles(targetFilePath, key + "*.*");

                    foreach (string s in files)
                    {
                        fileName = Path.GetFileName(s);
                        targetFile = Path.Combine(targetFilePath, fileName);
                        File.Delete(targetFile);
                    }
                }

                if (Directory.Exists(sourceFilePath))
                {
                    //string[] files = Directory.GetFiles(sourceFilePath, key + "*.*");

                    foreach (string s in files)
                    {
                        fileName = Path.GetFileName(s);
                        targetFile = Path.Combine(sourceFilePath, fileName);
                        File.Delete(targetFile);
                    }
                }
                else
                {
                    return false;
                }

                return true;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        public GlobalErrors GetModel(TransactionHistory transaction, int reportId, ref ReportModel reportModel, DynamicTemplateReportFileModel dynamicTemplateReport, bool isSendEmailMode,int languageId)
        {
            try
            {
                return _transactionManager.GetReportDetails(reportId, transaction, ref reportModel, dynamicTemplateReport, isSendEmailMode,languageId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }

        public GlobalErrors GetReportModel( int reportId, ref ReportModel reportModel)
        {
            try
            {
                return _transactionManager.GetReportModel( reportId, ref  reportModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }



        public GlobalErrors ExportReport(TransactionHistory transaction, ref string reportPath, ref ReportModel reportModel, DynamicTemplateReportFileModel dynamicTemplateReport, bool isSendEmailMode,int languageId = -1)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string path = "~/PDFUtility/" + (isSendEmailMode ? "DynamicTemplates" : "Reports") + "/";
                var ReportKey = string.Empty;
                dynamic numberOfDigits = null;
                dynamic numberOfStockDigits = null;
                dynamic useDefaultBatchAndExpiry = null;
                dynamic allowTax = null;
                dynamic allowTaxInWarehouseOperations = null;
                if (_requestRepository != null && !isSendEmailMode)
                {
                    numberOfDigits = _requestRepository.Configurations.NumberOfDigits;
                    numberOfStockDigits = _requestRepository.Configurations.NumberOfStockDigits;
                    useDefaultBatchAndExpiry = _requestRepository.Configurations.UseDefaultExpiryAndBatchForItems;
                    allowTax = _requestRepository.Configurations.AllowTax;
                    allowTaxInWarehouseOperations = _requestRepository.Configurations.AllowTaxInWarehouseOperations;
                }
                else
                {
                    if(_configurationService == null)
                    {
                        _configurationService = new ConfigurationService(null);
                    }
                    
                    result = _configurationService.GetConfigurationValueFromDB($"NumberOfDigits",ref numberOfDigits);
                    if(result == GlobalErrors.Success)
                    {
                        result = _configurationService.GetConfigurationValueFromDB($"NumberOfStockDigits",ref numberOfStockDigits);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _configurationService.GetConfigurationValueFromDB($"UseDefaultExpiryAndBatchForItems", ref useDefaultBatchAndExpiry);
                    }
                    if (result == GlobalErrors.Success) 
                    {
                        result = _configurationService.GetConfigurationValueFromDB($"AllowTax", ref allowTax);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = _configurationService.GetConfigurationValueFromDB($"AllowTaxInWarehouseOperations", ref allowTaxInWarehouseOperations);
                    }
                }

                if (isSendEmailMode)
                {
                    path = Path.Combine(path, languageId.ToString() + "/");
                }
                else
                {
                    path = Path.Combine(path, _requestRepository.LanguageId.ToString() + "/");
                }

                if (isSendEmailMode && dynamicTemplateReport != null && !string.IsNullOrWhiteSpace(dynamicTemplateReport.FileName))
                {
                    path = Path.Combine(path, dynamicTemplateReport.FileName + ".cshtml");
                }
                else
                {

                    switch (transaction.reportMode)
                    {
                        //case ReportMode.ReturnOrder:
                        case ReportMode.SalesOrder:
                            path = Path.Combine(path, ReportConstants.OrderReport);
                            break;

                        case ReportMode.InputVoucher:
                        case ReportMode.OutputVoucher:
                            path = Path.Combine(path, ReportConstants.WarehouseReport);
                            break;

                        case ReportMode.TransferIn:
                        case ReportMode.TransferOut:
                            path = Path.Combine(path, ReportConstants.TransferReport);
                            break;

                        case ReportMode.LoadRequest:
                        case ReportMode.OffloadRequest:
                            path = Path.Combine(path, ReportConstants.VehicleReport);
                            break;

                        case ReportMode.Transaction:
                        case ReportMode.TestTransaction:
                            path = Path.Combine(path, ReportConstants.TransactionReport);
                            break;

                        case ReportMode.Payment:
                            path = Path.Combine(path, ReportConstants.PaymentReport);
                            break;

                        case ReportMode.DownPayment:
                            path = Path.Combine(path, ReportConstants.DownPaymentReport);
                            break;

                        case ReportMode.Invoiced:
                            path = Path.Combine(path, ReportConstants.InvoicedReport);
                            break;

                        case ReportMode.Delivered:
                            path = Path.Combine(path, ReportConstants.DeliveredReport);
                            break;

                        case ReportMode.ROIFormula:
                            path = Path.Combine(path, ReportConstants.ROIFormulaReport);
                            break;

                        case ReportMode.StockCountingResult:
                            path = Path.Combine(path, ReportConstants.StockCountingResultReport);
                            break;
                        case ReportMode.CreditNote:
                            path = Path.Combine(path, ReportConstants.CreditNoteReport);
                            break;
                        case ReportMode.DebitNote:
                            path = Path.Combine(path, ReportConstants.DebitNoteReport);
                            break;
                        case ReportMode.Return:
                            path = Path.Combine(path, ReportConstants.ReturnReport);
                            break;
                        case ReportMode.Exchange:
                            path = Path.Combine(path, ReportConstants.ExchangeReport);
                            break;
                        case ReportMode.DisplayUnitImage:
                            path = Path.Combine(path, ReportConstants.DisplayUnitImgReport);
                            break;
                        case ReportMode.SurveyCustomerImages:
                            path = Path.Combine(path, ReportConstants.SurveyCustomerImgReport);
                            break;
                        case ReportMode.SurveyEmployeeImages:
                            path = Path.Combine(path, ReportConstants.SurveyEmployeeImgReport);
                            break;
                        case ReportMode.ROIIncommingWithoutRef:
                        case ReportMode.ROIIncommingReturnsWithoutRef:
                            path = Path.Combine(path, ReportConstants.ROIWithoutRefReport);
                            break;

                        default:
                            return GlobalErrors.NotFound;
                    }
                }
                int reportId = isSendEmailMode ? dynamicTemplateReport.ReportId : transaction.reportMode.GetHashCode();
                result = GetModel(transaction, reportId, ref reportModel, dynamicTemplateReport, isSendEmailMode,languageId);
                reportModel.NumberOfStockDigits = Convert.ToInt32(numberOfStockDigits);
                reportModel.NumberOfDigits = Convert.ToInt32(numberOfDigits);
                reportModel.UseDefaultBatchAndExpiry = Convert.ToBoolean(useDefaultBatchAndExpiry);
                reportModel.ReportTitle = ResourcesManager.TranslateKey(reportModel.ReportTitle, _requestRepository != null ? _requestRepository.LanguageId : languageId);
                reportModel.AllowTaxInWarehouseOperations = Convert.ToBoolean(allowTax) && Convert.ToBoolean(allowTaxInWarehouseOperations);
                if (File.Exists(@LocalUtilities.CustomerLogoPath))
                {
                    reportModel.LogoPath = LocalUtilities.CustomerLogoPath;
                }
                else
                {
                    reportModel.LogoPath = string.Empty;
                }
                if (!isSendEmailMode && transaction.reportMode != ReportMode.StockCountingResult && reportModel != null && reportModel.TransactionDetails != null && reportModel.TransactionDetails.Count > 0 && reportModel.TransactionDetails[0].OrderTypeID != null && reportModel.TransactionDetails[0].OrderTypeID == 2)
                {
                    reportModel.ReportTitle = ResourcesManager.TranslateKey("Desc_Return_Order", _requestRepository.LanguageId);
                }
                reportPath = path;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

    }
}
