﻿using DinkToPdf;
using DinkToPdf.Contracts;
using Microsoft.AspNetCore.Hosting;
using Sonic.Web.Core;
using Sonic.Web.Core.Survey;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Reflection;

namespace Sonic.Web.Service
{
    public class PriceRequestService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly PriceRequestManager _priceRequestManager;
        private readonly IHostingEnvironment _hostingEnvironment;
        private IConverter _converter;
        public PriceRequestService(IRequestRepository requestRepository, IHostingEnvironment hostingEnvironment, IConverter converter)
        {
            _requestRepository = requestRepository;
            _priceRequestManager = new PriceRequestManager(requestRepository);
            _hostingEnvironment = hostingEnvironment;
            _converter = converter;
        }
       
        public GlobalErrors SavePriceRequest(PendingPriceListModel priceRequest)
        {
            string itemIDs = string.Empty;
            string errorMessage = "";
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _priceRequestManager.SavePriceRequest(priceRequest);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
    }
}
