﻿using Newtonsoft.Json;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;

namespace Sonic.Web.Service
{
    public class PromotionService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ItemManager _itemManager;
        private readonly PromotionManager _promotionManager;
        private readonly TransactionManager _transactionManager;

        public PromotionService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _itemManager = new ItemManager(_requestRepository);
            _promotionManager = new PromotionManager(_requestRepository);
            _transactionManager = new TransactionManager(_requestRepository);
        }
        public bool GetBenefitsForTargetedPromotions(Promotion promotion, int selectedOptionId, TransactionCommonData transactionCommonData)
        {
            bool isPromotionTaken = false;
            int newRepetCount = 1;
            decimal discountAmount = 0;
            decimal itemsPromotedDiscount = 0;
            decimal benefitPromotedAmount = 0;
            decimal total = 0;
            RelatedToTargetPromotion satisfiedOption;
            try
            {
                decimal achievedWithCurrInv = 0;
                decimal actualAddedValue = 0;
                //PromotionOption CurrentPromotionOption = promotion.PromotionOutputs.Find(x => x.PromotionOptionId == selectedOptionId);
                foreach (PromotionOption promotionOption in promotion.PromotionOutputs)
                {
                    if (promotion.AllowOring && !promotion.ResetLastInvRem)
                    {
                        // here we should add remaining value manually not from procedure in case of allowOring and resetLastInvRem false
                        // because it is not fixed and user can select from options 
                        actualAddedValue = promotion.PromotionOutputs.Sum(x => x.PromotionOptionDetails[0].RepeatCount * x.RelatedToTargetOption.OptionTargetValue);
                        achievedWithCurrInv = promotionOption.RelatedToTargetOption.RemainingValue;
                    }
                    foreach (PromotionOptionDetail detail in promotionOption.PromotionOptionDetails)
                    {
                        benefitPromotedAmount = 0;
                        //PromotionOption option = promotion.PromotionOutputs.Where(a => a.PromotionOptionId == selectedOptionId).First();
                        detail.IsBenefitTaken = false;
                        //if (promotion.PromotionType == PromotionTypes.StepsValues) detail.Value = detail.Value * detail.RepeatCount;
                        satisfiedOption = promotionOption.RelatedToTargetOption;
                        BenefitSequenceDetails seqDtl = new BenefitSequenceDetails();
                        if (promotion.AllowOring && !promotion.ResetLastInvRem)
                            detail.RemainingValue = achievedWithCurrInv - actualAddedValue;
                        else
                            detail.RemainingValue = satisfiedOption.RemainingValue;
                        if (promotion.AllowOring) {
                                satisfiedOption.Benefit = satisfiedOption.Benefit * detail.RepeatCount;
                        }
                        switch (detail.OutputOptionDetailTypeId)
                        {
                            case PromotionOutputDetailTypes.AllItemDiscountPercentage: // 12 
                                {
                                    if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                    {
                                        var currentBenefitDetails = new PromotionBenefitDetails();
                                        currentBenefitDetails.ItemId = detail.ItemId;
                                        currentBenefitDetails.PackId = detail.PackId;
                                        currentBenefitDetails.OptionDetailId = detail.PromotionOptionDetailId;
                                        currentBenefitDetails.OptionId = detail.PromotionOptionId;
                                        currentBenefitDetails.PromotionId = detail.PromotionId;
                                        currentBenefitDetails.PromotedDiscount = detail.Value * newRepetCount;
                                        currentBenefitDetails.IsRepeated = promotion.IsRepeated;
                                        currentBenefitDetails.RepeatCount = promotion.NewRepeatCount;

                                        if (!transactionCommonData.PromotionBenefitDetails.ContainsKey(detail.OutputOptionDetailTypeId))
                                        {
                                            transactionCommonData.PromotionBenefitDetails.Add(detail.OutputOptionDetailTypeId, new List<PromotionBenefitDetails>());
                                            transactionCommonData.PromotionBenefitDetails[detail.OutputOptionDetailTypeId].Add(currentBenefitDetails);
                                        }
                                        else
                                        {
                                            transactionCommonData.PromotionBenefitDetails[detail.OutputOptionDetailTypeId].Add(currentBenefitDetails);
                                        }
                                    }
                                    //satisfiedOption = promotion.RelatedToTargetsOptions.Find(x => x.ReferenceOptionId == detail.PromotionOptionDetailId);
                                    transactionCommonData.SoldItems.ForEach(pack =>
                                    {
                                        //if (transactionCommonData.IsDeliveryHasRelatedToTarget)
                                        //    total = pack.NetTotal + pack.CalculatedPromotedDiscount;
                                        //else
                                        //    total = pack.NetTotal;                                        
                                        itemsPromotedDiscount = Math.Min(satisfiedOption.Benefit /** pack.SeqFactor*/ * newRepetCount, 100 - transactionCommonData.SoldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount);
                                        pack.RelatedToTargetDiscount += itemsPromotedDiscount;
                                        if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                            pack.AllItemDiscount += itemsPromotedDiscount;
                                        else
                                            pack.ItemPromotedDiscount += itemsPromotedDiscount;
                                        //if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionBenefits != 1)
                                        //{
                                        //    benefitPromotedAmount += (pack.NetTotal-pack.CalculatedTax)*itemsPromotedDiscount/100;
                                        //}
                                        //else
                                        {
                                            benefitPromotedAmount += (pack.GrossTotal) * itemsPromotedDiscount / 100;
                                        }
                                        if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                        {
                                            if (promotion.BenefitSequenceDtls == null)
                                                promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                            seqDtl = new BenefitSequenceDetails();
                                            seqDtl.PromotionId = promotion.PromotionId;
                                            seqDtl.ItemId = pack.ItemId;
                                            seqDtl.PackId = pack.PackId;
                                            seqDtl.Sequence = promotion.Sequence;
                                            seqDtl.BenefitPGID = detail.PackGroupId;
                                            seqDtl.Value = benefitPromotedAmount;
                                            promotion.BenefitSequenceDtls.Add(seqDtl);
                                        }
                                    });
                                    detail.BenefitPromotedAmount = benefitPromotedAmount;
                                    isPromotionTaken = true;
                                }
                                break;
                            case PromotionOutputDetailTypes.DiscountPercentageForItem: //7
                                {
                                    //  satisfiedOption = promotion.RelatedToTargetsOptions.Find(x => x.ReferenceOptionId == detail.PromotionOptionDetailId);
                                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                                    {
                                        if (transactionCommonData.SoldItems.Where(a => a.ItemId == detail.ItemId).ToList().Count == 0)
                                            break;
                                        newRepetCount = 1;
                                        if (promotion.IsRepeated)
                                        {
                                            newRepetCount = promotion.NewRepeatCount;
                                        }
                                        var soldPacksFromItem = transactionCommonData.SoldItems.Where(a => a.ItemId == detail.ItemId).ToList();

                                        foreach (var pack in soldPacksFromItem)
                                        {
                                            discountAmount = 0;
                                            itemsPromotedDiscount = Math.Min(satisfiedOption.Benefit /** pack.SeqFactor*/ * newRepetCount, 100 - pack.ItemPromotedDiscount);
                                            transactionCommonData.SoldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                            transactionCommonData.SoldItems.Find(a => a.PackId == pack.PackId).RelatedToTargetDiscount += itemsPromotedDiscount;
                                            //if (transactionCommonData.IsDeliveryHasRelatedToTarget)
                                            //{
                                            //    detail.BenefitPromotedAmount =
                                            //  (transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).NetTotal + transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).CalculatedPromotedDiscount - transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).CalculatedTax) * itemsPromotedDiscount / 100;
                                            //}
                                            //else
                                            //{
                                            //    detail.BenefitPromotedAmount =
                                            // (transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).NetTotal - transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).CalculatedTax) * itemsPromotedDiscount / 100;
                                            //}
                                            //if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionBenefits != 1)
                                            //{
                                            //    detail.BenefitPromotedAmount = (pack.NetTotal-pack.CalculatedTax)*itemsPromotedDiscount/100;
                                            //}
                                            //else
                                            {
                                                detail.BenefitPromotedAmount = (pack.GrossTotal) * itemsPromotedDiscount / 100;
                                            }
                                            AddPromotionWrapperItem(detail, pack.PackId, pack.RequiredQty, detail.BenefitPromotedAmount);
                                            if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                            {
                                                if (promotion.BenefitSequenceDtls == null)
                                                    promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                                seqDtl = new BenefitSequenceDetails();
                                                seqDtl.PromotionId = promotion.PromotionId;
                                                seqDtl.ItemId = pack.ItemId;
                                                seqDtl.PackId = pack.PackId;
                                                seqDtl.Sequence = promotion.Sequence;
                                                seqDtl.BenefitPGID = detail.PackGroupId;
                                                seqDtl.Value = detail.BenefitPromotedAmount;
                                                promotion.BenefitSequenceDtls.Add(seqDtl);
                                            }
                                        }
                                    }
                                    else
                                    {
                                        if (transactionCommonData.SoldItems.Where(a => a.PackId == detail.PackId).ToList().Count == 0)
                                            break;
                                        newRepetCount = 1;
                                        if (promotion.IsRepeated)
                                        {
                                            newRepetCount = promotion.NewRepeatCount;
                                        }

                                        itemsPromotedDiscount = Math.Min(satisfiedOption.Benefit  /**transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).SeqFactor */ * newRepetCount, 100 - transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).ItemPromotedDiscount);
                                        transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                        transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).RelatedToTargetDiscount += itemsPromotedDiscount;
                                        //if (transactionCommonData.IsDeliveryHasRelatedToTarget)
                                        //{
                                        //    detail.BenefitPromotedAmount =
                                        //  (transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).NetTotal + transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).CalculatedPromotedDiscount - transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).CalculatedTax) * itemsPromotedDiscount / 100;
                                        //}
                                        //else
                                        //{
                                        //    detail.BenefitPromotedAmount =
                                        // (transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).NetTotal - transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).CalculatedTax) * itemsPromotedDiscount / 100;
                                        //}
                                        //if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionBenefits != 1)
                                        //{
                                        //    detail.BenefitPromotedAmount = (transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).NetTotal - transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).CalculatedTax) * itemsPromotedDiscount / 100;
                                        //}
                                        //else
                                        {
                                            detail.BenefitPromotedAmount = (transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).GrossTotal) * itemsPromotedDiscount / 100;
                                        }
                                        if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                        {
                                            if (promotion.BenefitSequenceDtls == null)
                                                promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                            seqDtl = new BenefitSequenceDetails();
                                            seqDtl.PromotionId = promotion.PromotionId;
                                            seqDtl.ItemId = detail.ItemId;
                                            seqDtl.PackId = detail.PackId;
                                            seqDtl.Sequence = promotion.Sequence;
                                            seqDtl.BenefitPGID = detail.PackGroupId;
                                            seqDtl.Value = detail.BenefitPromotedAmount;
                                            promotion.BenefitSequenceDtls.Add(seqDtl);
                                        }
                                    }
                                    isPromotionTaken = true;
                                }
                                break;
                            case PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount://31
                                {
                                    var soldPacksFromPackGroup = new List<ItemPackModel>();
                                    //satisfiedOption = promotion.RelatedToTargetsOptions.Find(x => x.ReferenceOptionId == detail.PromotionOptionDetailId);

                                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                                    {
                                        soldPacksFromPackGroup = transactionCommonData.SoldItems
                                   .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId)).ToList();
                                    }
                                    else
                                    {
                                        soldPacksFromPackGroup = transactionCommonData.SoldItems
                                          .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && o.PackId == pack.PackId)).ToList();
                                    }
                                    if (promotionOption.TakeMode == 0)
                                    {
                                        if (promotion.IsProductDiscount)
                                            transactionCommonData.IsSecondLevelProductDiscountTaken = true;
                                        soldPacksFromPackGroup.ForEach(pack =>
                                        {
                                            //if (transactionCommonData.IsDeliveryHasRelatedToTarget)
                                            //    total = pack.NetTotal + pack.CalculatedPromotedDiscount;
                                            //else
                                            //    total = pack.NetTotal;
                                            itemsPromotedDiscount = Math.Min(satisfiedOption.Benefit /** transactionCommonData.SoldItems.Find(a => a.PackId == pack.PackId).SeqFactor */* newRepetCount, 100 - transactionCommonData.SoldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount);
                                            pack.ItemPromotedDiscount += itemsPromotedDiscount;
                                            pack.RelatedToTargetDiscount += itemsPromotedDiscount;

                                            // benefitPromotedAmount += (total - pack.CalculatedTax) * itemsPromotedDiscount / 100;
                                            //if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionBenefits != 1)
                                            //{
                                            //    benefitPromotedAmount = (benefitPromotedAmount + ((pack.NetTotal-pack.CalculatedTax)*itemsPromotedDiscount/100));//// should be + tax
                                            //}
                                            //else
                                            {
                                                benefitPromotedAmount = (benefitPromotedAmount + (pack.GrossTotal*itemsPromotedDiscount/100));
                                            }
                                            if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                            {
                                                if (promotion.BenefitSequenceDtls == null)
                                                    promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                                seqDtl = new BenefitSequenceDetails();
                                                seqDtl.PromotionId = promotion.PromotionId;
                                                seqDtl.ItemId = pack.ItemId;
                                                seqDtl.PackId = pack.PackId;
                                                seqDtl.Sequence = promotion.Sequence;
                                                seqDtl.BenefitPGID = detail.PackGroupId;
                                                seqDtl.Value = benefitPromotedAmount;
                                                promotion.BenefitSequenceDtls.Add(seqDtl);
                                            }
                                        });
                                        isPromotionTaken = true;
                                    }
                                    else
                                    {
                                        if (promotion.IsProductDiscount)
                                        {
                                            ProductDiscountModel prodDis = new ProductDiscountModel();

                                            foreach (var item in detail.SelectedPromotedItems)
                                            {
                                                prodDis = new ProductDiscountModel();
                                                prodDis.BenefitPackGroupId = detail.PackGroupId;
                                                prodDis.BenefitItemId = item.ItemId;
                                                prodDis.BenefitPackId = item.PackId;
                                                prodDis.PromotionId = promotion.PromotionId;

                                                prodDis.SatisfiedPrerequisitesDetails = promotion.SatisfiedPrerequisitesDetails;
                                                transactionCommonData.ProductDiscountSecondLevelList.Add(prodDis);
                                                AddItemQuantityToSoldItems(promotion, detail, transactionCommonData, item.PackId, item.RequiredQty, true);
                                                prodDis.ProductDiscountQty = item.RequiredQty;
                                                isPromotionTaken = true;
                                            }
                                        }
                                        else
                                        {
                                            foreach (var item in detail.SelectedPromotedItems)
                                            {
                                                AddItemToPromotedItems(promotion, detail, transactionCommonData, item.PackId, item.RequiredQty, false);
                                            }
                                        }
                                        // in this case , we will take the promotion as a quantity , but we need to fill BenefitPromotedAmount value to save it in AccumulativePromotionsHistory
                                        soldPacksFromPackGroup.ForEach(pack =>
                                        {
                                            //if (transactionCommonData.IsDeliveryHasRelatedToTarget)
                                            //    total = pack.NetTotal + pack.CalculatedPromotedDiscount;
                                            //else
                                            //    total = pack.NetTotal;
                                            itemsPromotedDiscount = Math.Min(satisfiedOption.Benefit  /* * transactionCommonData.SoldItems.Find(a => a.PackId == pack.PackId).SeqFactor */  * newRepetCount, 100 - transactionCommonData.SoldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount);
                                            // benefitPromotedAmount += (total - pack.CalculatedTax) * itemsPromotedDiscount / 100;
                                            //if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionBenefits != 1)
                                            //{
                                            //    benefitPromotedAmount = (benefitPromotedAmount + ((pack.NetTotal - pack.CalculatedTax) * itemsPromotedDiscount / 100));//// should be + tax
                                            //}
                                            //else
                                            {
                                                benefitPromotedAmount = (benefitPromotedAmount + (pack.GrossTotal * itemsPromotedDiscount / 100));
                                            }
                                         
                                        });
                                        isPromotionTaken = true;
                                    }
                                    detail.BenefitPromotedAmount = benefitPromotedAmount;
                                }
                                break;
                            case PromotionOutputDetailTypes.SummationOverGroup:
                                if (promotion.IsProductDiscount)
                                {
                                    ProductDiscountModel prodDis = new ProductDiscountModel();

                                    foreach (var item in detail.SelectedPromotedItems)
                                    {
                                        prodDis = new ProductDiscountModel();
                                        prodDis.BenefitPackGroupId = detail.PackGroupId;
                                        prodDis.BenefitItemId = item.ItemId;
                                        prodDis.BenefitPackId = item.PackId;
                                        prodDis.PromotionId = promotion.PromotionId;
                                        prodDis.SatisfiedPrerequisitesDetails = promotion.SatisfiedPrerequisitesDetails;
                                        transactionCommonData.ProductDiscountFirstLevelList.Add(prodDis);
                                        AddItemQuantityToSoldItems(promotion, detail, transactionCommonData, item.PackId, item.RequiredQty, true);
                                        prodDis.ProductDiscountQty = item.RequiredQty;
                                        isPromotionTaken = true;
                                    }
                                }
                                else
                                {
                                    foreach (var item in detail.SelectedPromotedItems)
                                    {
                                        AddItemToPromotedItems(promotion, detail, transactionCommonData, item.PackId, item.RequiredQty, false);
                                        isPromotionTaken = true;
                                    }
                                }
                                break;
                            case PromotionOutputDetailTypes.DiscountPercentageForGroupItems:
                                {
                                    // satisfiedOption = promotion.RelatedToTargetsOptions.Find(x => x.ReferenceOptionId == detail.PromotionOptionDetailId);
                                    List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                    soldItems = transactionCommonData.SoldItems;
                                    if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                                    {
                                        soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                    }
                                    var soldPacksFromPackGroup = soldItems
                                        .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && o.PackId == pack.PackId)).ToList();

                                    if (_requestRepository.Configurations.AllowConversionInPromotion)
                                    {
                                        soldPacksFromPackGroup = soldItems
                                               .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId)).ToList();
                                    }

                                    decimal totalAmount = 0, totalDiscount = 0;

                                    foreach (var pack in soldPacksFromPackGroup)
                                    {
                                        newRepetCount = 1;
                                        if (promotion.IsRepeated) newRepetCount = promotion.NewRepeatCount;

                                        totalAmount = pack.RequiredQty * pack.Price;
                                        totalDiscount = pack.Discount + pack.AdditionalDiscountPercentage;
                                        totalAmount = totalAmount - (totalAmount * totalDiscount / 100);
                                        discountAmount = (satisfiedOption.Benefit * totalAmount) / 100;
                                        discountAmount = discountAmount * newRepetCount;

                                        itemsPromotedDiscount = Math.Min(satisfiedOption.Benefit /* * pack.SeqFactor */* newRepetCount, 100 - pack.ItemPromotedDiscount);

                                        soldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                        soldItems.Find(a => a.PackId == pack.PackId).RelatedToTargetDiscount += itemsPromotedDiscount;

                                        // detail.BenefitPromotedAmount = (pack.GrossTotal) * itemsPromotedDiscount / 100;/// - calculated discount
                                        //if (_requestRepository.Configurations.InvoiceValueConsideredInPromotionBenefits != 1)
                                        //{
                                        //    detail.BenefitPromotedAmount=(pack.NetTotal-pack.CalculatedTax)*(itemsPromotedDiscount/100);
                                        //}
                                        //else
                                        {
                                            detail.BenefitPromotedAmount=(pack.GrossTotal*itemsPromotedDiscount /100);
                                        }
                                        AddPromotionWrapperItem(detail, pack.PackId, pack.RequiredQty, detail.BenefitPromotedAmount);

                                        if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                        {
                                            if (promotion.BenefitSequenceDtls == null)
                                                promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                            seqDtl = new BenefitSequenceDetails();
                                            seqDtl.PromotionId = promotion.PromotionId;
                                            seqDtl.ItemId = pack.ItemId;
                                            seqDtl.PackId = pack.PackId;
                                            seqDtl.Sequence = promotion.Sequence;
                                            seqDtl.BenefitPGID = detail.PackGroupId;
                                            seqDtl.Value = detail.BenefitPromotedAmount;
                                            promotion.BenefitSequenceDtls.Add(seqDtl);
                                        }
                                    }
                                    isPromotionTaken = true;
                                }
                                break;
                            case PromotionOutputDetailTypes.ItemQuantity:
                                {
                                    AddItemToPromotedItems(promotion, detail, transactionCommonData, detail.PackId, satisfiedOption.Benefit, true);
                                    isPromotionTaken = true;
                                }
                                break;
                            case PromotionOutputDetailTypes.DiscountAmountOverGroup:
                                 var soldPacksFromPG = transactionCommonData.SoldItems
                                .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && o.PackId == pack.PackId)).ToList();
                                if (_requestRepository.Configurations.AllowConversionInPromotion)
                                {
                                    soldPacksFromPG = transactionCommonData.SoldItems
                                           .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId)).ToList();
                                }
                                decimal totalAmt = 0, totalDisc = 0;
                                decimal netTotalForSoldItemsInGroup = 0, qtyForSoldItemsInGroup =0, newDiscAmountValue = 0;
                                soldPacksFromPG.ForEach(pack =>
                                {
                                    netTotalForSoldItemsInGroup += pack.RequiredQty * pack.Price;
                                    qtyForSoldItemsInGroup += pack.RequiredQty;// we need this in uom of defined promotion pg 
                                });
                                foreach (var pack in soldPacksFromPG)
                                {
                                    newRepetCount = 1;
                                    if (promotion.IsRepeated) newRepetCount = promotion.NewRepeatCount;
                                    totalAmt = pack.RequiredQty * pack.Price;
                                    totalDisc = pack.Discount + pack.AdditionalDiscountPercentage;
                                    totalAmt = totalAmt - (totalAmt * totalDisc / 100);
                                    if (_requestRepository.Configurations.DistributeBenefitAmountPerQuantities)
                                    {
                                        newDiscAmountValue = (satisfiedOption.Benefit * pack.RequiredQty) / qtyForSoldItemsInGroup;
                                    }
                                    else
                                    {
                                        newDiscAmountValue = (satisfiedOption.Benefit * totalAmt) / netTotalForSoldItemsInGroup;
                                    }
                                    itemsPromotedDiscount = _promotionManager.CalculatePromotedDiscount(pack, promotion.IsRepeated, promotion.NewRepeatCount, newDiscAmountValue, ref discountAmount, detail.OutputOptionDetailTypeId, false);
                                    transactionCommonData.SoldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                    transactionCommonData.SoldItems.Find(a => a.PackId == pack.PackId).RelatedToTargetDiscount += itemsPromotedDiscount;
                                    detail.BenefitPromotedAmount =  (pack.NetTotal - pack.CalculatedTax) * itemsPromotedDiscount / 100;
                                    AddPromotionWrapperItem(detail, pack.PackId, pack.RequiredQty, detail.BenefitPromotedAmount);
                                    if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                    {
                                        if (promotion.BenefitSequenceDtls == null)
                                            promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                        seqDtl = new BenefitSequenceDetails();
                                        seqDtl.PromotionId = promotion.PromotionId;
                                        seqDtl.ItemId = pack.ItemId;
                                        seqDtl.PackId = pack.PackId;
                                        seqDtl.Sequence = promotion.Sequence;
                                        seqDtl.BenefitPGID = detail.PackGroupId;
                                        seqDtl.Value = detail.BenefitPromotedAmount;
                                        promotion.BenefitSequenceDtls.Add(seqDtl);
                                    }
                                }
                                isPromotionTaken = true;
                                break;
                            case PromotionOutputDetailTypes.DiscountAmountOverTransaction:
                                {
                                    var soldItems = transactionCommonData.SoldItems;
                                    decimal totalAmount = 0, totalDiscount = 0;
                                    decimal netTotalForSoldItems = 0, qtyForSoldItems = 0;
                                    newDiscAmountValue = 0;
                                    soldItems.ForEach(item =>
                                    {
                                        netTotalForSoldItems += item.RequiredQty * item.Price;
                                        qtyForSoldItems += item.RequiredQty;
                                    });
                                    foreach (var item in soldItems)
                                    {
                                        newRepetCount = 1;
                                        if (promotion.IsRepeated) newRepetCount = promotion.NewRepeatCount;
                                        totalAmount = item.RequiredQty * item.Price;
                                        totalDiscount = item.Discount + item.AdditionalDiscountPercentage;
                                        totalAmount = totalAmount - (totalAmount * totalDiscount / 100);
                                        if (_requestRepository.Configurations.DistributeBenefitAmountPerQuantities)
                                        {
                                            newDiscAmountValue = (satisfiedOption.Benefit * item.RequiredQty) / qtyForSoldItems;
                                        }
                                        else
                                        {
                                            newDiscAmountValue = (satisfiedOption.Benefit * totalAmount) / netTotalForSoldItems;
                                        }
                                        itemsPromotedDiscount = _promotionManager.CalculatePromotedDiscount(item, promotion.IsRepeated, promotion.NewRepeatCount, newDiscAmountValue, ref discountAmount, detail.OutputOptionDetailTypeId, false);
                                        transactionCommonData.SoldItems.Find(a => a.PackId == item.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                        transactionCommonData.SoldItems.Find(a => a.PackId == item.PackId).RelatedToTargetDiscount += itemsPromotedDiscount;
                                        detail.BenefitPromotedAmount = detail.BenefitPromotedAmount + (item.GrossTotal) * itemsPromotedDiscount / 100;////// 
                                        AddPromotionWrapperItem(detail, item.PackId, item.RequiredQty, detail.BenefitPromotedAmount);
                                        if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                        {
                                            if (promotion.BenefitSequenceDtls == null)
                                                promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                            seqDtl = new BenefitSequenceDetails();
                                            seqDtl.PromotionId = promotion.PromotionId;
                                            seqDtl.ItemId = item.ItemId;
                                            seqDtl.PackId = item.PackId;
                                            seqDtl.Sequence = promotion.Sequence;
                                            seqDtl.BenefitPGID = detail.PackGroupId;
                                            seqDtl.Value = detail.BenefitPromotedAmount;
                                            promotion.BenefitSequenceDtls.Add(seqDtl);
                                        }
                                    }
                                }
                                isPromotionTaken = true;
                                break;
                        }
                        detail.IsBenefitTaken = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return isPromotionTaken;
        }

        public bool GetBenefits(Promotion promotion, int selectedOptionId, TransactionCommonData transactionCommonData)
        {
            bool isPromotionTaken = false;
            int newRepetCount = 1;
            decimal discountAmount = 0;
            decimal itemsPromotedDiscount = 0;
            decimal promotedDiscount = 0;
            decimal tempRepeatCount = 1;
            try
            {
                foreach (PromotionOptionDetail detail in promotion.PromotionOutputs.Where(a => a.PromotionOptionId == selectedOptionId).First().PromotionOptionDetails)
                {
                    detail.IsBenefitTaken = false;
                    BenefitSequenceDetails seqDtl = new BenefitSequenceDetails();
                    if (promotion.PromotionType == PromotionTypes.StepsValues) detail.Value = detail.Value * detail.RepeatCount;

                    switch (detail.OutputOptionDetailTypeId)
                    {
                        #region [ALL ITEM PROMOTIONS]

                        case PromotionOutputDetailTypes.AllItemDiscountPercentage: // 2 & 12
                            {
                                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                soldItems = transactionCommonData.SoldItems;
                                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                                {
                                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                }
                                if (_requestRepository.Configurations.ExcludeItemFromNextPromotion && _requestRepository.Configurations.ApplyPriorityOnPromotionGroups && promotion.Priority > -1 && promotion.PromotionGroupId > -1)
                                {
                                    List<ItemPackModel> includedItems = new List<ItemPackModel>();
                                    includedItems = soldItems.ToList();
                                    _promotionManager.ExcludeBenefitItemsIncludedInHigherPriorityPromotions(transactionCommonData, promotion.PromotionGroupId, promotion.Priority, ref includedItems);
                                   
                                    foreach(ItemPackModel itemPack in includedItems)
                                    {
                                        discountAmount = 0;
                                        itemsPromotedDiscount = Math.Min(detail.Value * newRepetCount * itemPack.SeqFactor, 100 - itemPack.ItemPromotedDiscount);
                                        soldItems.Find(a => a.PackId == itemPack.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                        discountAmount =
                                          (soldItems.Find(a => a.PackId == itemPack.PackId).NetTotal - soldItems.Find(a => a.PackId == itemPack.PackId).CalculatedTax) * itemsPromotedDiscount / 100;
                                        AddPromotionWrapperItem(detail, itemPack.PackId, itemPack.RequiredQty, discountAmount);
                                        if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                        {
                                            if (promotion.BenefitSequenceDtls == null)
                                                promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                            seqDtl = new BenefitSequenceDetails();
                                            seqDtl.PromotionId = promotion.PromotionId;
                                            seqDtl.ItemId = itemPack.ItemId;
                                            seqDtl.PackId = itemPack.PackId;
                                            seqDtl.Sequence = promotion.Sequence;
                                            seqDtl.BenefitPGID = detail.PackGroupId;
                                            seqDtl.Value = discountAmount;
                                            promotion.BenefitSequenceDtls.Add(seqDtl);
                                        }
                                    }
                                } 
                                else
                                {
                                    var currentBenefitDetails = new PromotionBenefitDetails();
                                    currentBenefitDetails.ItemId = detail.ItemId;
                                    currentBenefitDetails.PackId = detail.PackId;
                                    currentBenefitDetails.OptionDetailId = detail.PromotionOptionDetailId;
                                    currentBenefitDetails.OptionId = detail.PromotionOptionId;
                                    currentBenefitDetails.PromotionId = detail.PromotionId;
                                    currentBenefitDetails.PromotedDiscount = detail.Value * newRepetCount;
                                    currentBenefitDetails.IsRepeated = promotion.IsRepeated;
                                    currentBenefitDetails.RepeatCount = promotion.NewRepeatCount;

                                    if (!transactionCommonData.PromotionBenefitDetails.ContainsKey(detail.OutputOptionDetailTypeId))
                                    {
                                        transactionCommonData.PromotionBenefitDetails.Add(detail.OutputOptionDetailTypeId, new List<PromotionBenefitDetails>());
                                        transactionCommonData.PromotionBenefitDetails[detail.OutputOptionDetailTypeId].Add(currentBenefitDetails);
                                    }
                                    else
                                    {
                                        transactionCommonData.PromotionBenefitDetails[detail.OutputOptionDetailTypeId].Add(currentBenefitDetails);
                                    }
                                    if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                    {
                                        foreach (ItemPackModel pack in soldItems)
                                        {
                                            if (currentBenefitDetails.IsRepeated)
                                                tempRepeatCount = currentBenefitDetails.RepeatCount;
                                            promotedDiscount = currentBenefitDetails.PromotedDiscount * pack.SeqFactor * tempRepeatCount;
                                            discountAmount = (pack.NetTotal - pack.CalculatedTax) * currentBenefitDetails.PromotedDiscount / 100;
                                            pack.AllItemDiscount += promotedDiscount;
                                            transactionCommonData.CustomerPromotions.Find(a => a.PromotionId == currentBenefitDetails.PromotionId)
                                                .PromotionOutputs.Find(a => a.PromotionOptionId == currentBenefitDetails.OptionId)
                                                .PromotionOptionDetails.Find(a => a.PromotionOptionDetailId == currentBenefitDetails.OptionDetailId).BenefitPromotedAmount += discountAmount;
                                            if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                            {
                                                if (promotion.BenefitSequenceDtls == null)
                                                    promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                                seqDtl = new BenefitSequenceDetails();
                                                seqDtl.PromotionId = promotion.PromotionId;
                                                seqDtl.ItemId = pack.ItemId;
                                                seqDtl.PackId = pack.PackId;
                                                seqDtl.Sequence = promotion.Sequence;
                                                seqDtl.BenefitPGID = detail.PackGroupId;
                                                seqDtl.Value = discountAmount;
                                                promotion.BenefitSequenceDtls.Add(seqDtl);
                                            }
                                        }
                                    }
                                }
                                
                                isPromotionTaken = true;
                            }
                            break;
                        case PromotionOutputDetailTypes.AllItemDiscountAmount:// 1 & 11
                            {
                                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                soldItems = transactionCommonData.SoldItems;
                                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                                {
                                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                }
                                if (_requestRepository.Configurations.ExcludeItemFromNextPromotion && _requestRepository.Configurations.ApplyPriorityOnPromotionGroups && promotion.Priority > -1 && promotion.PromotionGroupId > -1)
                                {
                                    List<ItemPackModel> includedItems = new List<ItemPackModel>();
                                    includedItems = soldItems.ToList();
                                    _promotionManager.ExcludeBenefitItemsIncludedInHigherPriorityPromotions(transactionCommonData, promotion.PromotionGroupId, promotion.Priority, ref includedItems);
                                    
                                    foreach (ItemPackModel itemPack in includedItems)
                                    {
                                        discountAmount = 0;
                                        itemsPromotedDiscount = _promotionManager.CalculatePromotedDiscount(soldItems.Find(a => a.PackId == itemPack.PackId), promotion.IsRepeated, promotion.NewRepeatCount, detail.Value, ref discountAmount, detail.OutputOptionDetailTypeId, false);
                                        soldItems.Find(a => a.PackId == itemPack.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                        discountAmount =
                                          (soldItems.Find(a => a.PackId == itemPack.PackId).NetTotal - soldItems.Find(a => a.PackId == itemPack.PackId).CalculatedTax) * itemsPromotedDiscount / 100;
                                        AddPromotionWrapperItem(detail, itemPack.PackId, itemPack.RequiredQty, discountAmount);
                                    }
                                }
                                else
                                {
                                    var currentBenefitDetails = new PromotionBenefitDetails();
                                    currentBenefitDetails.ItemId = detail.ItemId;
                                    currentBenefitDetails.PackId = detail.PackId;
                                    currentBenefitDetails.OptionDetailId = detail.PromotionOptionDetailId;
                                    currentBenefitDetails.OptionId = detail.PromotionOptionId;
                                    currentBenefitDetails.PromotionId = detail.PromotionId;
                                    currentBenefitDetails.PromotedDiscount = detail.Value * newRepetCount;
                                    currentBenefitDetails.IsRepeated = promotion.IsRepeated;
                                    currentBenefitDetails.RepeatCount = promotion.NewRepeatCount;

                                    if (!transactionCommonData.PromotionBenefitDetails.ContainsKey(detail.OutputOptionDetailTypeId))
                                    {
                                        transactionCommonData.PromotionBenefitDetails.Add(detail.OutputOptionDetailTypeId, new List<PromotionBenefitDetails>());
                                        transactionCommonData.PromotionBenefitDetails[detail.OutputOptionDetailTypeId].Add(currentBenefitDetails);
                                    }
                                    else
                                    {
                                        transactionCommonData.PromotionBenefitDetails[detail.OutputOptionDetailTypeId].Add(currentBenefitDetails);
                                    }
                                    if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                    {
                                        foreach (ItemPackModel pack in soldItems)
                                        {
                                            promotedDiscount = _promotionManager.CalculatePromotedDiscount(pack, currentBenefitDetails.IsRepeated, currentBenefitDetails.RepeatCount, currentBenefitDetails.PromotedDiscount, ref discountAmount, PromotionOutputDetailTypes.AllItemDiscountAmount,false);
                                            discountAmount = currentBenefitDetails.PromotedDiscount;
                                            pack.AllItemDiscount += promotedDiscount;
                                            transactionCommonData.CustomerPromotions.Find(a => a.PromotionId == currentBenefitDetails.PromotionId)
                                                .PromotionOutputs.Find(a => a.PromotionOptionId == currentBenefitDetails.OptionId)
                                                .PromotionOptionDetails.Find(a => a.PromotionOptionDetailId == currentBenefitDetails.OptionDetailId).BenefitPromotedAmount += discountAmount;
                                        }
                                    }
                                }
                                isPromotionTaken = true;
                            }
                            break;

                        #endregion [ALL ITEM PROMOTIONS]

                        #region [FIXED PRICE PROMOTIONS]
                        case PromotionOutputDetailTypes.FixedPriceOverItem:
                            {
                                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                discountAmount = 0;
                                soldItems = transactionCommonData.SoldItems;
                                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x=> x.ApprovalPrice > x.Price))
                                {
                                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                }
                                if (soldItems.Where(a => a.PackId == detail.PackId).ToList().Count == 0)
                                    break;

                                //itemsPromotedDiscount = CalculatePromotedDiscount(transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId), promotion.IsRepeated, promotion.NewRepeatCount, detail.Value, ref discountAmount, detail.OutputOptionDetailTypeId);
                                //transactionCommonData.SoldItems.Find(a => a.PackId == detail.PackId).Price = detail.Value;

                                soldItems.ForEach(item =>
                                {
                                    if (item.PackId == detail.PackId)
                                    {
                                        item.Price = detail.Value;
                                        item = _transactionManager.CalculatePackTotals(item);
                                    }
                                });

                                isPromotionTaken = true;
                            }
                            break;

                        case PromotionOutputDetailTypes.FixedPriceOverAllItem:
                            {
                                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                soldItems = transactionCommonData.SoldItems;
                                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                                {
                                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                }
                                soldItems.ForEach(item =>
                                {
                                    item.Price = detail.Value;
                                    item = _transactionManager.CalculatePackTotals(item);
                                });
                            }
                            isPromotionTaken = true;
                            break;

                        case PromotionOutputDetailTypes.FixedPriceOverGroup:
                        case PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel:
                            {
                                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                soldItems = transactionCommonData.SoldItems;
                                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                                {
                                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                }
                                bool stockStatus = detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel ? true : false;
                                    if (soldItems.Any(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && o.PackId == pack.PackId && (!stockStatus || (stockStatus && o.SalesOrderTypeIDs.Contains(pack.SalesOrderTypeId.ToString()))))))
                                    {
                                        soldItems.Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && o.PackId == pack.PackId && (!stockStatus || (stockStatus && o.SalesOrderTypeIDs.Contains(pack.SalesOrderTypeId.ToString()))))).ToList().ForEach(item =>
                                        {
                                            item.Price = transactionCommonData.IsBundle ? item.PriceValue : detail.Value;
                                            item = _transactionManager.CalculatePackTotals(item);
                                            AddPromotionWrapperItem(detail, item.PackId, 0, 0, item.SalesOrderTypeId);
                                        });
                                    }
                           }
                                isPromotionTaken = true;
                            break;
                        #endregion [FIXED PRICE PROMOTIONS]

                        #region [GENERAL PROMOTIONS]
                        case PromotionOutputDetailTypes.FreeItemsWithCertainValue:
                        case PromotionOutputDetailTypes.SummationOverGroup:
                        case PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage:
                        case PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems:
                        case PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel:
                            if (promotion.IsProductDiscount)
                            {
                                ProductDiscountModel prodDis = new ProductDiscountModel();

                                foreach (var item in detail.SelectedPromotedItems)
                                {
                                    prodDis = new ProductDiscountModel();
                                    prodDis.BenefitPackGroupId = detail.PackGroupId;
                                    prodDis.BenefitItemId = item.ItemId;
                                    prodDis.BenefitPackId = item.PackId;
                                    prodDis.PromotionId = promotion.PromotionId;
                                    prodDis.SatisfiedPrerequisitesDetails = promotion.SatisfiedPrerequisitesDetails;
                                    transactionCommonData.ProductDiscountFirstLevelList.Add(prodDis);
                                    AddItemQuantityToSoldItems(promotion, detail, transactionCommonData, item.PackId, item.RequiredQty, true);
                                    prodDis.ProductDiscountQty = item.RequiredQty;
                                    isPromotionTaken = true;
                                }
                                break;
                            }
                            else
                            {
                                foreach (var item in detail.SelectedPromotedItems)
                                {
                                    AddItemToPromotedItems(promotion, detail, transactionCommonData, item.PackId, item.RequiredQty, false,false, item.SalesOrderTypeId, item.IconColor, item.StockStatusId);
                                    isPromotionTaken = true;
                                }
                                break;
                            }

                        case PromotionOutputDetailTypes.ItemQuantity:
                            { 
                                if (detail.SelectedPromotedItems != null && detail.SelectedPromotedItems.Count > 0)
                                {
                                    foreach (var item in detail.SelectedPromotedItems)
                                    {
                                        AddItemToPromotedItems(promotion, detail, transactionCommonData, detail.PackId, item.RequiredQty, !item.IsMultiplyRepeatCount, false,item.SalesOrderTypeId,item.IconColor, item.StockStatusId);
                                        isPromotionTaken = true;
                                    }
                                }
                                else
                                {
                                    AddItemToPromotedItems(promotion, detail, transactionCommonData, detail.PackId, detail.Value, true);
                                    isPromotionTaken = true;
                                }
                            }
                            break;
                        case PromotionOutputDetailTypes.GroupEqualQuantity:
                            {
                                foreach (var pack in detail.PackGroupDetails)
                                {
                                    AddItemToPromotedItems(promotion, detail, transactionCommonData, pack.PackId, detail.Value, true);
                                }
                                isPromotionTaken = true;
                            }
                            break;

                        #endregion [GENERAL PROMOTIONS]

                        #region [ITEM LEVEL PROMOTIONS]

                        case PromotionOutputDetailTypes.DiscountAmountForItem:
                            {
                                discountAmount = 0;
                                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                soldItems = transactionCommonData.SoldItems;
                                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                                {
                                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                }
                                if (_requestRepository.Configurations.AllowConversionInPromotion)
                                {
                                    if (soldItems.Where(a => a.ItemId == detail.ItemId).ToList().Count == 0)
                                        break;
                                  
                                    var soldPacksFromItem = soldItems.Where(a => a.ItemId == detail.ItemId).ToList();
                                    foreach (var pack in soldPacksFromItem)
                                    {
                                        discountAmount = 0;
                                        itemsPromotedDiscount = _promotionManager.CalculatePromotedDiscount(pack, promotion.IsRepeated, promotion.NewRepeatCount, detail.Value, ref discountAmount, detail.OutputOptionDetailTypeId,false);
                                        soldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount += itemsPromotedDiscount;

                                        discountAmount =
                                          (soldItems.Find(a => a.PackId == pack.PackId).NetTotal - soldItems.Find(a => a.PackId == pack.PackId).CalculatedTax) * itemsPromotedDiscount / 100;
                                        AddPromotionWrapperItem(detail, pack.PackId, pack.RequiredQty, discountAmount);

                                    }
                                }
                                else
                                {

                                    if (soldItems.Where(a => a.PackId == detail.PackId).ToList().Count == 0)
                                        break;

                                    var soldPacksFromItem = soldItems.Where(a => a.PackId == detail.PackId).ToList();
                                    foreach (var pack in soldPacksFromItem)
                                    {
                                        discountAmount = 0;
                                        itemsPromotedDiscount = _promotionManager.CalculatePromotedDiscount(pack, promotion.IsRepeated, promotion.NewRepeatCount, detail.Value, ref discountAmount, detail.OutputOptionDetailTypeId,false);
                                        pack.ItemPromotedDiscount += itemsPromotedDiscount;

                                        discountAmount =
                                          (pack.NetTotal - pack.CalculatedTax) * itemsPromotedDiscount / 100;
                                        AddPromotionWrapperItem(detail, pack.PackId, pack.RequiredQty, discountAmount);

                                    }

                                }
                                isPromotionTaken = true;
                            }
                            break;

                        case PromotionOutputDetailTypes.DiscountPercentageForItem:
                            {
                                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                soldItems = transactionCommonData.SoldItems;
                                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                                {
                                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                }
                                if (_requestRepository.Configurations.AllowConversionInPromotion)
                                {
                                    if (soldItems.Where(a => a.ItemId == detail.ItemId).ToList().Count == 0)
                                        break;
                                    newRepetCount = 1;
                                    if (promotion.IsRepeated)
                                    {
                                        newRepetCount = promotion.NewRepeatCount;
                                    }
                                    var soldPacksFromItem = soldItems.Where(a => a.ItemId == detail.ItemId).ToList();
                                    if (_requestRepository.Configurations.ExcludeItemFromNextPromotion && _requestRepository.Configurations.ApplyPriorityOnPromotionGroups && promotion.Priority > -1 && promotion.PromotionGroupId > -1)
                                    {
                                        _promotionManager.ExcludeBenefitItemsIncludedInHigherPriorityPromotions(transactionCommonData, promotion.PromotionGroupId, promotion.Priority, ref soldPacksFromItem);
                                    }
                                    foreach (var pack in soldPacksFromItem)
                                    {
                                        discountAmount = 0;
                                        itemsPromotedDiscount = Math.Min(detail.Value * newRepetCount * pack.SeqFactor, 100 - pack.ItemPromotedDiscount);
                                        soldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                        discountAmount =
                                          (soldItems.Find(a => a.PackId == pack.PackId).NetTotal - soldItems.Find(a => a.PackId == pack.PackId).CalculatedTax) * itemsPromotedDiscount / 100;
                                        AddPromotionWrapperItem(detail, pack.PackId, pack.RequiredQty, discountAmount);
                                        if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                        {
                                            if (promotion.BenefitSequenceDtls == null)
                                                promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                            seqDtl = new BenefitSequenceDetails();
                                            seqDtl.PromotionId = promotion.PromotionId;
                                            seqDtl.ItemId = pack.ItemId;
                                            seqDtl.PackId = pack.PackId;
                                            seqDtl.Sequence = promotion.Sequence;
                                            seqDtl.BenefitPGID = detail.PackGroupId;
                                            seqDtl.Value = discountAmount;
                                            promotion.BenefitSequenceDtls.Add(seqDtl);
                                        }
                                    }
                                }
                                else
                                {
                                    if (soldItems.Where(a => a.PackId == detail.PackId).ToList().Count == 0)
                                        break;
                                    newRepetCount = 1;
                                    if (promotion.IsRepeated)
                                    {
                                        newRepetCount = promotion.NewRepeatCount;
                                    }
                                    var soldPacksFromItem = soldItems.Where(a => a.PackId == detail.PackId).ToList();
                                    if (_requestRepository.Configurations.ExcludeItemFromNextPromotion && _requestRepository.Configurations.ApplyPriorityOnPromotionGroups && promotion.Priority > -1 && promotion.PromotionGroupId > -1)
                                    {
                                        _promotionManager.ExcludeBenefitItemsIncludedInHigherPriorityPromotions(transactionCommonData, promotion.PromotionGroupId, promotion.Priority, ref soldPacksFromItem);
                                    }
                                    foreach (var pack in soldPacksFromItem)
                                    {
                                        discountAmount = 0;
                                        itemsPromotedDiscount = Math.Min(detail.Value * newRepetCount * pack.SeqFactor, 100 - pack.ItemPromotedDiscount);
                                        pack.ItemPromotedDiscount += itemsPromotedDiscount;

                                        discountAmount =
                                          (pack.NetTotal - pack.CalculatedTax) * itemsPromotedDiscount / 100;
                                        AddPromotionWrapperItem(detail, pack.PackId, pack.RequiredQty, discountAmount);

                                        if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                                        {
                                            if (promotion.BenefitSequenceDtls == null)
                                                promotion.BenefitSequenceDtls = new List<BenefitSequenceDetails>();
                                            seqDtl = new BenefitSequenceDetails();
                                            seqDtl.PromotionId = promotion.PromotionId;
                                            seqDtl.ItemId = pack.ItemId;
                                            seqDtl.PackId = pack.PackId;
                                            seqDtl.Sequence = promotion.Sequence;
                                            seqDtl.BenefitPGID = detail.PackGroupId;
                                            seqDtl.Value = discountAmount;
                                            promotion.BenefitSequenceDtls.Add(seqDtl);
                                        }
                                    }

                                }
                                isPromotionTaken = true;
                            }
                            break;

                        case PromotionOutputDetailTypes.DiscountAmountForGroupItems:
                            {
                                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                soldItems = transactionCommonData.SoldItems;
                                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x => x.ApprovalPrice > x.Price))
                                {
                                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                }
                                var soldPacksFromPackGroup = soldItems
                                .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && (o.PackId == pack.PackId || _requestRepository.Configurations.AllowConversionInPromotion))).ToList();

                                if (_requestRepository.Configurations.ExcludeItemFromNextPromotion && _requestRepository.Configurations.ApplyPriorityOnPromotionGroups && promotion.Priority > -1 && promotion.PromotionGroupId > -1)
                                {
                                    _promotionManager.ExcludeBenefitItemsIncludedInHigherPriorityPromotions(transactionCommonData, promotion.PromotionGroupId, promotion.Priority, ref soldPacksFromPackGroup);
                                }
                                foreach (var pack in soldPacksFromPackGroup)
                                {
                                    discountAmount = 0;
                                    itemsPromotedDiscount = _promotionManager.CalculatePromotedDiscount(pack, promotion.IsRepeated, promotion.NewRepeatCount, detail.Value, ref discountAmount, detail.OutputOptionDetailTypeId,false);
                                    soldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                    detail.BenefitPromotedAmount = (pack.NetTotal - pack.CalculatedTax) * itemsPromotedDiscount / 100;
                                    AddPromotionWrapperItem(detail, pack.PackId, pack.RequiredQty, discountAmount);
                                }
                                isPromotionTaken = true;
                            }
                            break;

                        case PromotionOutputDetailTypes.DiscountPercentageForGroupItems:
                        case PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel:
                            {
                                bool stockStatus = detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel ? true : false;
                                List<ItemPackModel> soldPacksFromPackGroup = new List<ItemPackModel>();
                                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                soldItems = transactionCommonData.SoldItems;
                                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x=> x.ApprovalPrice > x.Price))
                                {
                                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                }
                                if (stockStatus)
                                {
                                    soldPacksFromPackGroup = soldItems
                                                            .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && o.PackId == pack.PackId && o.SalesOrderTypeIDs.Contains(pack.SalesOrderTypeId.ToString()))).ToList();
                                }
                                else
                                {
                                    soldPacksFromPackGroup = soldItems
                                    .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && o.PackId == pack.PackId)).ToList();
                                }
                                if (_requestRepository.Configurations.AllowConversionInPromotion)
                                {
                                    if (stockStatus)
                                    {
                                        soldPacksFromPackGroup = soldItems
                                            .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && o.SalesOrderTypeIDs.Contains(pack.SalesOrderTypeId.ToString()))).ToList();
                                    }
                                    else
                                    {
                                        soldPacksFromPackGroup = soldItems
                                           .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId)).ToList();
                                    }
                                }

                                if (_requestRepository.Configurations.ExcludeItemFromNextPromotion && _requestRepository.Configurations.ApplyPriorityOnPromotionGroups && promotion.Priority > -1 && promotion.PromotionGroupId > -1)
                                {
                                    _promotionManager.ExcludeBenefitItemsIncludedInHigherPriorityPromotions(transactionCommonData, promotion.PromotionGroupId, promotion.Priority, ref soldPacksFromPackGroup);
                                }

                                decimal totalAmount = 0, totalDiscount = 0;
                                decimal value = 0;
                                foreach (var pack in soldPacksFromPackGroup)
                                {
                                        newRepetCount = 1;
                                        if (promotion.IsRepeated) newRepetCount = promotion.NewRepeatCount;
                                        totalAmount = pack.RequiredQty * pack.Price;
                                        totalDiscount = pack.Discount + pack.AdditionalDiscountPercentage;
                                        totalAmount = totalAmount - (totalAmount * totalDiscount / 100);
                                        if (transactionCommonData.IsBundle)
                                        {
                                            value = detail.PackGroupDetails.Where(x => x.PackId == pack.PackId && detail.PromotionId == promotion.PromotionId).ToList().Select(y => y.PromotionValue).FirstOrDefault();
                                            detail.Value = value;
                                        }
                                        discountAmount = (detail.Value * totalAmount) / 100;
                                        discountAmount = discountAmount * newRepetCount;
                                    if (stockStatus)
                                    {
                                        itemsPromotedDiscount = Math.Min(detail.Value * newRepetCount * soldItems.Find(a => a.PackId == pack.PackId && a.SalesOrderTypeId == pack.SalesOrderTypeId).SeqFactor, 100 - pack.ItemPromotedDiscount);
                                        soldItems.Find(a => a.PackId == pack.PackId && a.SalesOrderTypeId == pack.SalesOrderTypeId).ItemPromotedDiscount += itemsPromotedDiscount;
                                    }
                                    else
                                    {
                                        itemsPromotedDiscount = Math.Min(detail.Value * newRepetCount * soldItems.Find(a => a.PackId == pack.PackId).SeqFactor, 100 - pack.ItemPromotedDiscount);
                                        soldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                    }
                                        detail.BenefitPromotedAmount = transactionCommonData.IsBundle? (totalAmount) * itemsPromotedDiscount / 100 :(pack.NetTotal - pack.CalculatedTax) * itemsPromotedDiscount / 100;
                                        AddPromotionWrapperItem(detail, pack.PackId, pack.RequiredQty, detail.BenefitPromotedAmount,pack.SalesOrderTypeId);
                                }
                            }
                            isPromotionTaken = true;
                            break;
                        case PromotionOutputDetailTypes.DiscountAmountOverGroup:
                            {
                                List<ItemPackModel> soldItems = new List<ItemPackModel>();
                                soldItems = transactionCommonData.SoldItems;
                                if (_requestRepository.Configurations.CheckEditPriceOnPromotion && soldItems.Any(x=> x.ApprovalPrice > x.Price))
                                {
                                    soldItems = soldItems.Where(x => x.Price >= x.ApprovalPrice).ToList();
                                }
                                var soldPacksFromPackGroup = soldItems
                                .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId && o.PackId == pack.PackId)).ToList();
                                if (_requestRepository.Configurations.AllowConversionInPromotion)
                                {
                                    soldPacksFromPackGroup = soldItems
                                           .Where(pack => detail.PackGroupDetails.Any(o => o.ItemId == pack.ItemId)).ToList();
                                }
                                decimal totalAmount = 0, totalDiscount = 0;
                                decimal netTotalForSoldItemsInGroup = 0, qtyForSoldItemsInGroup =0, newDiscAmountValue = 0;
                                soldPacksFromPackGroup.ForEach(pack =>
                                {
                                    netTotalForSoldItemsInGroup += pack.RequiredQty * pack.Price;
                                    qtyForSoldItemsInGroup += pack.RequiredQty;
                                });
                                foreach (var pack in soldPacksFromPackGroup)
                                {
                                    newRepetCount = 1;
                                    if (promotion.IsRepeated) newRepetCount = promotion.NewRepeatCount;
                                    totalAmount = pack.RequiredQty * pack.Price;
                                    totalDiscount = pack.Discount + pack.AdditionalDiscountPercentage;
                                    totalAmount = totalAmount - (totalAmount * totalDiscount / 100);
                                    if (_requestRepository.Configurations.DistributeBenefitAmountPerQuantities)
                                    {
                                        newDiscAmountValue = (detail.Value * pack.RequiredQty) / qtyForSoldItemsInGroup;
                                    }
                                    else
                                    {
                                        newDiscAmountValue = (detail.Value * totalAmount) / netTotalForSoldItemsInGroup;
                                    }
                                    itemsPromotedDiscount = _promotionManager.CalculatePromotedDiscount(pack, promotion.IsRepeated, promotion.NewRepeatCount, newDiscAmountValue, ref discountAmount, detail.OutputOptionDetailTypeId, false);
                                    soldItems.Find(a => a.PackId == pack.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                    detail.BenefitPromotedAmount =  (pack.NetTotal - pack.CalculatedTax) * itemsPromotedDiscount / 100;
                                    AddPromotionWrapperItem(detail, pack.PackId, pack.RequiredQty, detail.BenefitPromotedAmount);
                                }
                            }
                            isPromotionTaken = true;
                            break;
                        case PromotionOutputDetailTypes.DiscountAmountOverTransaction:
                            {
                                var soldItems = transactionCommonData.SoldItems;
                                decimal totalAmount = 0, totalDiscount = 0;
                                decimal netTotalForSoldItems = 0, qtyForSoldItems = 0, newDiscAmountValue = 0;
                                soldItems.ForEach(item =>
                                {
                                    netTotalForSoldItems += item.RequiredQty * item.Price;
                                    qtyForSoldItems += item.RequiredQty;
                                });
                                foreach (var item in soldItems)
                                {
                                    newRepetCount = 1;
                                    if (promotion.IsRepeated) newRepetCount = promotion.NewRepeatCount;
                                    totalAmount = item.RequiredQty * item.Price;
                                    totalDiscount = item.Discount + item.AdditionalDiscountPercentage;
                                    totalAmount = totalAmount - (totalAmount * totalDiscount / 100);
                                    if (_requestRepository.Configurations.DistributeBenefitAmountPerQuantities)
                                    {
                                        newDiscAmountValue = (detail.Value * item.RequiredQty) / qtyForSoldItems;
                                    }
                                    else
                                    {
                                        newDiscAmountValue = (detail.Value * totalAmount) / netTotalForSoldItems;
                                    }
                                    itemsPromotedDiscount = _promotionManager.CalculatePromotedDiscount(item, promotion.IsRepeated, promotion.NewRepeatCount, newDiscAmountValue, ref discountAmount, detail.OutputOptionDetailTypeId, false);
                                    transactionCommonData.SoldItems.Find(a => a.PackId == item.PackId).ItemPromotedDiscount += itemsPromotedDiscount;
                                    detail.BenefitPromotedAmount = (item.NetTotal - item.CalculatedTax) * itemsPromotedDiscount / 100;
                                    AddPromotionWrapperItem(detail, item.PackId, item.RequiredQty, detail.BenefitPromotedAmount);
                                }
                            }
                            isPromotionTaken = true;
                            break;
                        case PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems:
                            {
                                decimal soldItemsTotalQuantityInPcs = 0, value = 0;
                                var soldItems = transactionCommonData.SoldItems.Where(x => x.ItemId == detail.ItemId).ToList();
                                soldItemsTotalQuantityInPcs = soldItems.Sum(item => item.RequiredQty * item.PiecesInPack);
                                soldItemsTotalQuantityInPcs = soldItemsTotalQuantityInPcs / detail.PiecesInPack;
                                value = soldItemsTotalQuantityInPcs * detail.Value / 100;
                                AddItemToPromotedItems(promotion, detail, transactionCommonData, detail.PackId, value, true,true);
                                isPromotionTaken = true;
                            }
                            break;
                        #endregion [ITEM LEVEL PROMOTIONS]
                        #region [Target PROMOTIONS]
                        case PromotionOutputDetailTypes.RetailContractDiscount:
                            {
                                decimal totalPromotedDiscount = 0;
                                decimal discountValue = 0;
                                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                                    totalPromotedDiscount = _promotionManager.CalculateCurrentPromotedDiscount(transactionCommonData);//?

                                decimal targetValue = 0, targetDiscount = 0, alreadySavedInvoiceValue = 0;
                                if (promotion.CustomerTargets != null)
                                {
                                    string TransID = string.Empty;
                                    foreach (AchievementTargetCustomer customerTarget in promotion.CustomerTargets)
                                    {
                                        if (customerTarget.TargetID == detail.TargetId && customerTarget.CustomerID == detail.CustomerId && customerTarget.OutletID == detail.OutletId
                                            && customerTarget.PromotedOnPromotionID == promotion.PromotionId)
                                        {
                                            if (customerTarget.IsFirstTimePromoted)
                                            {
                                                targetValue = _promotionManager.GetAchievementValue(customerTarget, promotion.PromotionType, promotion.StartDate, promotion.EndDate);
                                                if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && targetValue > 0)
                                                {
                                                    alreadySavedInvoiceValue = 0;
                                                    TransID = _promotionManager.GetInvoiceID(transactionCommonData.OrderId, int.Parse(detail.CustomerId.ToString()), detail.OutletId, -1);
                                                    if (_promotionManager.CheckIfAchievementDetailsAlreadySaved(int.Parse(transactionCommonData.CustomerId.ToString()), transactionCommonData.OutletId, detail.AchievementId, detail.TargetId, TransID, -1, -1, -1, ref alreadySavedInvoiceValue))
                                                    {
                                                        targetValue -= alreadySavedInvoiceValue;
                                                    }
                                                }
                                                if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && _requestRepository.Configurations.RecalculatePromotionInDelivery)
                                                {
                                                    targetValue += transactionCommonData.NetTotal - totalPromotedDiscount;
                                                    targetDiscount = (targetValue * (detail.Value / 100)) / (transactionCommonData.NetTotal) * 100;
                                                }
                                                else
                                                {
                                                    targetValue += transactionCommonData.NetTotal;
                                                    targetDiscount = (targetValue * (detail.Value / 100)) / (transactionCommonData.NetTotal + totalPromotedDiscount) * 100;
                                                }
                                            }
                                            else
                                            {
                                                if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && _requestRepository.Configurations.RecalculatePromotionInDelivery)
                                                {
                                                    targetDiscount = detail.Value * ((transactionCommonData.NetTotal - totalPromotedDiscount) / transactionCommonData.NetTotal);
                                                }
                                                else
                                                {
                                                    targetDiscount = detail.Value * (transactionCommonData.NetTotal / (transactionCommonData.NetTotal + totalPromotedDiscount));
                                                }
                                            }
                                            foreach (ItemPackModel packModel in transactionCommonData.SoldItems)
                                            {
                                                discountAmount = 0;
                                                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                                                    itemsPromotedDiscount = Math.Min(targetDiscount * newRepetCount, 100 - (packModel.ExciseContractPromotedDiscount + packModel.AllItemDiscount + packModel.ItemPromotedDiscount));
                                                else
                                                    itemsPromotedDiscount = Math.Min(targetDiscount * newRepetCount, 100 - packModel.ExciseContractPromotedDiscount);
                                                packModel.ExciseContractPromotedDiscount += itemsPromotedDiscount;
                                                //if (promotion.FreeGoodsType.Equals(FreeGoodsTypes.CashIncentiveDiscount))
                                                //    packModel.CashIncentivePromotedDiscount += itemsPromotedDiscount;
                                                packModel.RetailCalculatedPromotedDiscount = (packModel.GrossTotal - packModel.CalculatedDiscount) * itemsPromotedDiscount / 100;
                                                detail.BenefitPromotedAmount += packModel.RetailCalculatedPromotedDiscount;
                                            }
                                        }
                                    }
                                }
                                isPromotionTaken = true;
                            }
                            break;
                        case PromotionOutputDetailTypes.WholesalesContractsDiscount:
                            {
                                bool isLastInvoice = false;
                                // promotionInputValue = PromotionManager.GetWholesalesPromotionInputValue(promotion.PromotionID);
                                decimal totalPromotedDiscount = 0, discountValue = 0;
                                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                                    totalPromotedDiscount = _promotionManager.CalculateCurrentPromotedDiscount(transactionCommonData);
                                decimal targetValue = 0, targetDiscount = 0, alreadySavedInvoiceValue = 0;
                                if (promotion.CustomerTargets != null)
                                {
                                    string TransID = string.Empty;
                                    foreach (AchievementTargetCustomer customerTarget in promotion.CustomerTargets)
                                    {
                                        if (customerTarget.TargetID == detail.TargetId && customerTarget.CustomerID == detail.CustomerId && customerTarget.OutletID == detail.OutletId
                                            && customerTarget.PromotedOnPromotionID == promotion.PromotionId)
                                        {
                                            targetValue = _promotionManager.GetAchievementValue(customerTarget, promotion.PromotionType, promotion.StartDate, promotion.EndDate);
                                            if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                                            {
                                                TransID = _promotionManager.GetInvoiceID(transactionCommonData.OrderId, int.Parse(detail.CustomerId.ToString()), detail.OutletId, -1);
                                                isLastInvoice = _promotionManager.CheckIfTransactionIsLastInvoice(int.Parse(customerTarget.CustomerID.ToString()), customerTarget.OutletID, customerTarget.AchievementID, promotion.PromotionId, TransID, promotion.PromotionLevel);
                                                if (isLastInvoice)
                                                {
                                                    targetValue = _promotionManager.GetOldAchievementValue(int.Parse(customerTarget.CustomerID.ToString()), customerTarget.OutletID, customerTarget.AchievementID, customerTarget.TargetID, promotion.PromotionLevel, TransID);
                                                }
                                                else
                                                {
                                                    alreadySavedInvoiceValue = 0;
                                                    if (_promotionManager.CheckIfAchievementDetailsAlreadySaved(int.Parse(detail.CustomerId.ToString()), detail.OutletId, detail.AchievementId, detail.TargetId, TransID, -1, -1, -1, ref alreadySavedInvoiceValue))
                                                    {
                                                        targetValue -= alreadySavedInvoiceValue;
                                                    }
                                                }
                                            }
                                            //if (promotionInputValue > (targetValue + (_soldItemsAmount - ((_isPartiallyDelivered && Configuration.RecalculatePromotionInDelivery) ? totalPromotedDiscount : 0))))
                                            //{
                                            //    _currentWholeSaleUnsatisfiedProm.Add(promotion.PromotionID);
                                            //    return true;
                                            //}
                                            if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && _requestRepository.Configurations.RecalculatePromotionInDelivery)
                                            {
                                                targetValue += transactionCommonData.NetTotal - totalPromotedDiscount;
                                                targetDiscount = (targetValue * (detail.Value / 100)) / (transactionCommonData.NetTotal) * 100;
                                            }
                                            else
                                            {
                                                targetValue += transactionCommonData.NetTotal;
                                                targetDiscount = (targetValue * (detail.Value / 100)) / (transactionCommonData.NetTotal + totalPromotedDiscount) * 100;
                                            }
                                            foreach (ItemPackModel packModel in transactionCommonData.SoldItems)
                                            {
                                                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                                                    itemsPromotedDiscount = Math.Min(targetDiscount * newRepetCount, 100 - (packModel.WholeSalesPromotedDiscount + packModel.AllItemDiscount + packModel.ItemPromotedDiscount));
                                                else
                                                    itemsPromotedDiscount = Math.Min(targetDiscount * newRepetCount, 100 - packModel.WholeSalesPromotedDiscount);

                                                packModel.WholeSalesPromotedDiscount += itemsPromotedDiscount;
                                                //if (promotion.FreeGoodsType.Equals(FreeGoodsTypes.CashIncentiveDiscount))
                                                //    _soldItems[item.ItemID].Packs[pack.PackID].CashIncentivePromotedDiscount += itemsPromotedDiscount;
                                                packModel.WholeSalesCalPromotedDiscount = (packModel.GrossTotal - packModel.CalculatedDiscount) * itemsPromotedDiscount / 100;
                                                detail.BenefitPromotedAmount += packModel.WholeSalesCalPromotedDiscount;

                                            }
                                        }
                                    }
                                }
                                isPromotionTaken = true;
                            }
                            break;
                        case PromotionOutputDetailTypes.DynamicTargetDiscount:
                            {
                                decimal totalPromotedDiscount = 0;
                                decimal totalAchievementDiscount = 0;
                                bool isLastInvoice = false;
                                //promotionInputValue = PromotionManager.GetWholesalesPromotionInputValue(promotion.PromotionId);
                                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                                {
                                    totalPromotedDiscount = _promotionManager.CalculateCurrentPromotedDiscount(transactionCommonData, ref totalAchievementDiscount);
                                }
                                decimal targetValue = 0, targetDiscount = 0, alreadySavedInvoiceValue = 0;
                                if (promotion.CustomerTargets != null)
                                {
                                    string TransID = string.Empty;
                                    foreach (AchievementTargetCustomer customerTarget in promotion.CustomerTargets)
                                    {
                                        if (customerTarget.TargetID == detail.TargetId && customerTarget.CustomerID == detail.CustomerId && customerTarget.OutletID == detail.OutletId
                                            && customerTarget.PromotedOnPromotionID == promotion.PromotionId)
                                        {
                                            if (customerTarget.IsFirstTimePromoted)
                                            {
                                                targetValue = _promotionManager.GetAchievementValue(customerTarget, promotion.PromotionType, promotion.StartDate, promotion.EndDate);
                                                if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                                                {
                                                    TransID = _promotionManager.GetInvoiceID(transactionCommonData.OrderId, int.Parse(detail.CustomerId.ToString()), detail.OutletId, -1);
                                                    isLastInvoice = _promotionManager.CheckIfTransactionIsLastInvoice(int.Parse(customerTarget.CustomerID.ToString()), customerTarget.OutletID, customerTarget.AchievementID, promotion.PromotionId, TransID, promotion.PromotionLevel);
                                                    if (isLastInvoice)
                                                    {
                                                        targetValue = _promotionManager.GetOldAchievementValue(int.Parse(customerTarget.CustomerID.ToString()), customerTarget.OutletID, customerTarget.AchievementID, customerTarget.TargetID, promotion.PromotionLevel, TransID);
                                                    }
                                                    else
                                                    {
                                                        alreadySavedInvoiceValue = 0;
                                                        if (_promotionManager.CheckIfAchievementDetailsAlreadySaved(int.Parse(transactionCommonData.CustomerId.ToString()), transactionCommonData.OutletId, detail.AchievementId, detail.TargetId, TransID, -1, -1, -1, ref alreadySavedInvoiceValue))
                                                        {
                                                            targetValue -= alreadySavedInvoiceValue;
                                                        }
                                                    }
                                                }
                                                //if (promotionInputValue > (targetValue + (_soldItemsAmount - ((_isPartiallyDelivered && Configuration.RecalculatePromotionInDelivery) ? totalPromotedDiscount : 0))))
                                                //{
                                                //    _currentDynamicSalesAmountUnsatisfiedProm.Add(promotion.PromotionID);
                                                //    return true;
                                                //}
                                                if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && _requestRepository.Configurations.RecalculatePromotionInDelivery)
                                                {
                                                    targetValue += transactionCommonData.NetTotal - totalPromotedDiscount;
                                                    targetDiscount = (targetValue * (detail.Value / 100)) / (transactionCommonData.NetTotal) * 100;
                                                }
                                                else
                                                {
                                                    targetValue += transactionCommonData.GrossTotal - totalPromotedDiscount;
                                                    targetDiscount = (targetValue * (detail.Value / 100)) / (transactionCommonData.GrossTotal) * 100;

                                                }
                                                promotion.BenefitValue = detail.Value;
                                                customerTarget.BenefitValue = detail.Value;
                                            }
                                            else
                                            {
                                                detail.Value = promotion.BenefitValue;
                                                if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && _requestRepository.Configurations.RecalculatePromotionInDelivery)
                                                {
                                                    targetDiscount = detail.Value * ((transactionCommonData.NetTotal - totalPromotedDiscount) / transactionCommonData.NetTotal);
                                                }
                                                {
                                                    targetDiscount = detail.Value * ((transactionCommonData.GrossTotal - totalPromotedDiscount) / (transactionCommonData.GrossTotal));
                                                    //targetDiscount = detail.Value * ((transactionCommonData.NetTotal - totalAchievementDiscount - transactionCommonData.Tax) / (transactionCommonData.NetTotal + totalPromotedDiscount - totalAchievementDiscount - transactionCommonData.Tax));
                                                }
                                            }
                                            foreach (ItemPackModel packModel in transactionCommonData.SoldItems)
                                            {
                                                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                                                    itemsPromotedDiscount = Math.Min(targetDiscount * newRepetCount, 100 - (packModel.DynamicPromotedDiscount + packModel.ExciseContractPromotedDiscount + packModel.WholeSalesPromotedDiscount + packModel.AllItemDiscount + packModel.ItemPromotedDiscount));
                                                else
                                                    itemsPromotedDiscount = Math.Min(targetDiscount * newRepetCount, 100 - packModel.DynamicPromotedDiscount);

                                                packModel.DynamicPromotedDiscount += itemsPromotedDiscount;
                                                //if (promotion.FreeGoodsType.Equals(FreeGoodsTypes.CashIncentiveDiscount))
                                                //    _soldItems[item.ItemID].Packs[pack.PackID].CashIncentivePromotedDiscount += itemsPromotedDiscount;
                                                packModel.DynamicCalTargetPromotedDiscount = (packModel.GrossTotal - packModel.CalculatedDiscount) * packModel.DynamicPromotedDiscount / 100;
                                                detail.BenefitPromotedAmount += (packModel.GrossTotal - packModel.CalculatedDiscount) * itemsPromotedDiscount / 100;


                                            }
                                        }
                                    }
                                }
                                isPromotionTaken = true;
                            }
                            break;
                        case PromotionOutputDetailTypes.OpenSteps:
                        case PromotionOutputDetailTypes.DynamicTargetSummationOverGroup:
                            {
                                decimal targetQuantity = 0;
                                decimal originalBenefitValue = 0;
                                foreach (var item in detail.SelectedPromotedItems)
                                {
                                    AddItemToPromotedItems(promotion, detail, transactionCommonData, item.PackId, item.RequiredQty, false);
                                    isPromotionTaken = true;
                                }
                                if (promotion.CustomerTargets != null)
                                {
                                    foreach (AchievementTargetCustomer customerTarget in promotion.CustomerTargets)
                                    {
                                        if (customerTarget.TargetID == detail.TargetId && customerTarget.AchievementID == detail.AchievementId && customerTarget.CustomerID == detail.CustomerId && customerTarget.OutletID == detail.OutletId)
                                        {
                                            if (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DynamicTargetSummationOverGroup)
                                            {
                                                originalBenefitValue = decimal.Round(((promotion.TotalQuantityfromPackGroup / promotion.TargetBenefitQuantity) * detail.Value), _requestRepository.Configurations.NumberOfStockDigits);
                                                if (detail.PackGroupQuantity == 1)
                                                {
                                                    originalBenefitValue = decimal.Round(originalBenefitValue, 0);
                                                }
                                                promotion.BenefitValue = originalBenefitValue;
                                                customerTarget.BenefitValue = promotion.BenefitValue;
                                            }
                                        }
                                    }
                                }
                            }

                            break;
                            #endregion [Target PROMOTIONS]

                    }
                    detail.IsBenefitTaken = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return isPromotionTaken;
        }

        public GlobalErrors TakePromotions(ref TransactionCommonData transactionCommonData, bool selectPromotionFirstOptionAutomatically)
        {
            var result = GlobalErrors.Success;
            bool recalculatePromotions = true;
            try
            {
                if ((transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.Delivery && !transactionCommonData.IsThereAnyProductDiscountDefined) || (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && !_requestRepository.Configurations.RecalculatePromotionInDelivery) || (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && _requestRepository.Configurations.RecalculatePromotionInDelivery && !_requestRepository.Configurations.ConsiderCurrentPromotionsInDelivery))
                        recalculatePromotions = false;
                transactionCommonData.PromotionBenefitDetails = new Dictionary<PromotionOutputDetailTypes, List<PromotionBenefitDetails>>();
                //transactionCommonData.PromotedItems = new List<ItemPackModel>();
                int selectedOptionId = 0;
                if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.Delivery && !transactionCommonData.IsThereAnyProductDiscountDefined && transactionCommonData.CustomerPromotions.Where(x => x.RelatedToTarget).Count() > 0)
                {
                        transactionCommonData.IsDeliveryHasRelatedToTarget = true;
                }
                transactionCommonData.CustomerPromotions = _promotionManager.orderSatisfiedPromotions(transactionCommonData.CustomerPromotions);
                if(transactionCommonData.CustomerPromotions.Any(x=> x.HasFixedPrice == true))
                {
                    transactionCommonData.CustomerPromotions = transactionCommonData.CustomerPromotions.OrderByDescending(promo => promo.HasFixedPrice).ToList();
                }
                foreach (Promotion promotion in transactionCommonData.CustomerPromotions)
                {
                    
                    if (!promotion.RelatedToTarget)
                    {
                        if (promotion.PromotionType != PromotionTypes.StepsValues)
                        {
                            if (selectPromotionFirstOptionAutomatically && promotion.PromotionOutputs.Count > 0)
                            {
                                promotion.PromotionOutputs[0].IsSelected = true;
                            }
                            promotion.PromotionOutputs.RemoveAll(a => a.IsSelected == false);
                        }
                        if (promotion.PromotionType != PromotionTypes.StepsValues)
                        {
                            selectedOptionId = promotion.PromotionOutputs.Where(a => a.IsSelected == true).First().PromotionOptionId;
                                if (GetBenefits(promotion, selectedOptionId, transactionCommonData))
                                {
                                    transactionCommonData.CustomerPromotions.Find(a => a.PromotionId == promotion.PromotionId).IsTaken = true;
                                }
                        }
                        else
                        {
                            foreach (var output in promotion.PromotionOutputs)
                            {
                                selectedOptionId = output.PromotionOptionId;
                                if (GetBenefits(promotion, selectedOptionId, transactionCommonData))
                                {
                                    transactionCommonData.CustomerPromotions.Find(a => a.PromotionId == promotion.PromotionId).IsTaken = true;
                                }
                            }
                        }

                    }
                    else
                    {
                        if (promotion.PromotionType != PromotionTypes.StepsValues)
                        {
                            if (selectPromotionFirstOptionAutomatically && promotion.PromotionOutputs.Count > 0)
                            {
                                promotion.PromotionOutputs[0].IsSelected = true;
                            }
                            promotion.PromotionOutputs.RemoveAll(a => a.IsSelected == false);
                        }
                        selectedOptionId = promotion.PromotionOutputs.Where(a => a.IsSelected == true).First().PromotionOptionId;
                        if (GetBenefitsForTargetedPromotions(promotion, selectedOptionId, transactionCommonData))
                        {
                            transactionCommonData.CustomerPromotions.Find(a => a.PromotionId == promotion.PromotionId).IsTaken = true;
                        }
                    }
                    if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                    {
                        if (promotion.BenefitSequenceDtls != null && promotion.BenefitSequenceDtls.Count() > 0)
                        {
                            result = _promotionManager.SaveTempBenefitSequenceDetails( transactionCommonData.CustomerId, transactionCommonData.OutletId, promotion.BenefitSequenceDtls);
                            if (result != GlobalErrors.Success)
                                return result;
                        }
                    }
                }


                if (transactionCommonData.PromotionBenefitDetails != null)
                {
                    if(_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode() || _requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.NormalFlow.GetHashCode())
                        _promotionManager.AccumlateAllPromotedDiscounts(transactionCommonData);
                    else if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                        _promotionManager.RecalculatePromotedDiscountFactor(transactionCommonData);
                }
                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                {
                        transactionCommonData.PromotionsForAllLevels.AddRange(transactionCommonData.CustomerPromotions.Where(a => a.IsTaken).ToList());
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        private void AddAllItemPromotedDiscount(TransactionCommonData transactionCommonData)
        {
            try
            {
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        private void AddItemToPromotedItems(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transactionCommonData, int packId, decimal value, bool multiplyByRepeatCount, bool isFreeQtyPromotion = false,int salesOrderTypeId = -1,string IconColor ="", int stockStatusId = -1)
        {
            List<PriceModel> priceModel = new List<PriceModel>();
            var outlet = transactionCommonData.Outlet;
            List<ItemPackModel> promotiedItems = new List<ItemPackModel>();
            try
            {
                //bushra
                if (promotion.IsRepeated && multiplyByRepeatCount)// if  multiplyByRepeatCount=false this mean that the value is already multiplied by the repeat count when selecting benefit items
                    value = value * promotion.NewRepeatCount;
                if (salesOrderTypeId <= 0)
                {
                    promotiedItems = transactionCommonData.PromotedItems.Where(a => a.PackId == packId).ToList();
                }
                else
                {
                    promotiedItems = transactionCommonData.PromotedItems.Where(a => a.PackId == packId && a.SalesOrderTypeId == salesOrderTypeId).ToList();
                }
                if (isFreeQtyPromotion)
                {
                    value = decimal.Round(value, MidpointRounding.ToZero); //normal rounding
                }
                if (promotiedItems.Count == 0)
                {
                    ItemPackModel item = new ItemPackModel();
                    _itemManager.GetItemByPackID(packId, ref item);

                    item.RequiredQty = value;
                    item.SalesTransactionTypeId = SalesTransactionTypes.Promotion;
                    item.IconColor = IconColor;
                    item.Icon = "fa fa-circle fa-2x";
                    item.SalesOrderTypeId = salesOrderTypeId;
                    item.StockStatusId = stockStatusId;
                    item.RequestedQuantity = 0;

                    #region [GET PACK PRICE AND TAX]

                    GeneralFilter filter = new GeneralFilter();
                    filter.CustomerId = transactionCommonData.CustomerId;
                    filter.OutletId = transactionCommonData.OutletId;
                    filter.PackId = item.PackId;
                    _itemManager.GetPriceList(filter, ref priceModel);

                    #endregion [GET PACK PRICE AND TAX]

                    if (priceModel.ToList().Count > 0)
                    {
                        item.BasePrice = priceModel.First().Price;
                        item.BaseTax = priceModel.First().Tax;
                        item.UsedPriceListId = priceModel.First().PriceListId;
                        item.RetailPrice = priceModel.First().RetailPrice;
                        item.RetailTax = priceModel.First().RetailTax;
                        item.RetailValue = priceModel.First().RetailValue;
                    }
                    _itemManager.GetPacksHierarchy(outlet.CustomerId, outlet.OutletId, ref item);
                    transactionCommonData.PromotedItems.Add(item);
                }
                else
                {
                        transactionCommonData.PromotedItems.Find(a => a.PackId == packId).RequiredQty += value;
                }

                if (outlet.Taxable && _requestRepository.Configurations.AllowTax && _requestRepository.Configurations.AllowTaxOverFreeItems)
                {
                    transactionCommonData.PromotedItems.Find(a => a.PackId == packId).Tax = transactionCommonData.PromotedItems.Find(a => a.PackId == packId).BaseTax;

                    //if (_requestRepository.Configurations.AllowRetailTaxOnItems)
                    //{
                    //    // TODO
                    //}
                }

                AddPromotionWrapperItem(detail, packId, value, 0, salesOrderTypeId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        private void AddItemQuantityToSoldItems(Promotion promotion, PromotionOptionDetail detail, TransactionCommonData transactionCommonData, int packId, decimal value, bool isDiscountOverGroup)
        {
            List<PriceModel> priceModel = new List<PriceModel>();
            var outlet = transactionCommonData.Outlet;
            try
            {
                if (isDiscountOverGroup)
                {
                    bool isNewPack = false;
                    if (transactionCommonData.SoldItems.Where(a => a.PackId == packId).ToList().Count == 0)
                    {
                        isNewPack = true;
                        ItemPackModel item = new ItemPackModel();
                        _itemManager.GetItemByPackID(packId, ref item);

                        item.RequiredQty = value;
                        item.SalesTransactionTypeId = SalesTransactionTypes.Promotion;
                        item.RequestedQuantity = 0;

                        #region [GET PACK PRICE AND TAX]

                        GeneralFilter filter = new GeneralFilter();
                        filter.CustomerId = outlet.CustomerId;
                        filter.OutletId = outlet.OutletId;
                        filter.PackId = item.PackId;
                        _itemManager.GetPriceList(filter, ref priceModel);

                        #endregion [GET PACK PRICE AND TAX]

                        if (priceModel.ToList().Count > 0)
                        {
                            item.BasePrice = priceModel.First().Price;
                            item.BaseTax = priceModel.First().Tax;
                            item.UsedPriceListId = priceModel.First().PriceListId;
                            item.RetailPrice = priceModel.First().RetailPrice;
                            item.RetailTax = priceModel.First().RetailTax;
                            item.RetailValue = priceModel.First().RetailValue;
                            item.Price= priceModel.First().Price;
                            item.Tax= priceModel.First().Tax;
                        }
                        _itemManager.GetPacksHierarchy(outlet.CustomerId, outlet.OutletId, ref item);
                        transactionCommonData.SoldItems.Add(item);
                    }
                    decimal promotedDiscount = 0, discountAmount = 0;
                    decimal incentiveAmount = transactionCommonData.SoldItems.Find(a => a.PackId == packId).Price * value;
                    //promotedDiscount = _promotionManager.CalculatePromotedDiscount(transactionCommonData.SoldItems.Find(a => a.PackId == packId), promotion.IsRepeated, promotion.NewRepeatCount, incentiveAmount, ref discountAmount, detail.OutputOptionDetailTypeId, true);
                    if (!isNewPack) transactionCommonData.SoldItems.Find(a => a.PackId == packId).RequiredQty += decimal.Round(value, _requestRepository.Configurations.NumberOfDigits);
                    transactionCommonData.SoldItems.Find(a => a.PackId == packId).SalesTransactionTypeId = SalesTransactionTypes.Sales;
                    transactionCommonData.SoldItems.Find(a => a.PackId == packId).TotalProductDiscountQuantity += value;
                    transactionCommonData.SoldItems.Find(a => a.PackId == packId).CurrentProductDiscountQuantity = value;
                    //transactionCommonData.SoldItems.Find(a => a.PackId == packId).ProductDiscount += promotedDiscount;
                    //transactionCommonData.SoldItems.Find(a => a.PackId == packId).PromotedDiscount += promotedDiscount;
                    // transactionCommonData.SoldItems.Find(a => a.PackId == packId).CashIncentivePromotedDiscount += promotedDiscount;
                    AddPromotionWrapperItem(detail, packId, value, incentiveAmount);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        private void AddPromotionWrapperItem(PromotionOptionDetail detail, int packId, decimal qty, decimal discount,int salesOrderTypeId=-1)
        {
            try
            {
                PromotionBenefitWrapper obj = new PromotionBenefitWrapper();
                obj.TotalQuantity = qty;
                obj.TotalDiscount = discount;
                obj.PackId = packId;
                obj.OptionDetailId = detail.PromotionOptionDetailId;
                obj.OptionDetailTypeId = (int)detail.PromotionOptionTypeId;
                obj.OptionId = detail.PromotionOptionId;
                obj.PromotionId = detail.PromotionId;
                obj.SalesOrderTypeId = salesOrderTypeId;
                detail.PromotionWrapper.Add(obj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public GlobalErrors GetAvilablePromotions(ref List<Promotion> customerPromotions, bool exculdeBenifitSelectionPromotion)
        {
            try
            {
                customerPromotions = _promotionManager.FillCustomerPromotions(_requestRepository.CurrentEchoOperator.CustomerId, _requestRepository.CurrentEchoOperator.OutletId, exculdeBenifitSelectionPromotion , true, false,1,-1,false, ItemFormProcessMode.Orders);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        #region[Apply Group Achievements to Customers]

        public GlobalErrors ApplyGroupAchievementTargetPromotionsToCustomers(CustomersGroup customersGroup, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (customersGroup.IsThereAnyAchievementPromotions
                    && (customersGroup.IncludedAchievementPromotions != null && customersGroup.IncludedAchievementPromotions.Count > 0
                    || customersGroup.ExcludedAchievementPromotions != null && customersGroup.ExcludedAchievementPromotions.Count > 0)
                    )
                {
                    #region[New Customers]
                    if (customersGroup.NewCustomers != null && customersGroup.NewCustomers.Count > 0)
                    {
                        foreach (SimpleCustomerModel newCustomer in customersGroup.NewCustomers)
                        {
                            result = _promotionManager.AddCustomerPromotionDataRelatedToCustomerGroup(customersGroup.GroupId, newCustomer.CustomerId, newCustomer.OutletId, customersGroup.IncludedAchievementPromotions, customersGroup.ExcludedAchievementPromotions, dBHelper);
                            if (result != GlobalErrors.Success)
                            {
                                break;
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Success;
                    }
                    #endregion

                    #region[Deleted Customers]
                    if (result == GlobalErrors.Success && customersGroup.DeletedCustomers != null && customersGroup.DeletedCustomers.Count > 0)
                    {
                        foreach (SimpleCustomerModel deletedCustomer in customersGroup.DeletedCustomers)
                        {
                            result = _promotionManager.DeleteCustomerPromotionDataRelatedToCustomerGroup(customersGroup.GroupId, deletedCustomer.CustomerId, deletedCustomer.OutletId, customersGroup.IncludedAchievementPromotions, customersGroup.ExcludedAchievementPromotions, dBHelper);
                            if (result != GlobalErrors.Success)
                            {
                                break;
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Success;
                    }
                    #endregion

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }



        #endregion

        #region[Calculate Customer Target Promotions]
        public GlobalErrors GetCustsWithActiveTargetOrAchievementPromos(int employeeId, int customerId, int outletId, ref List<CustomerModel> customersList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<Promotion> t = new List<Promotion>(); // not used only passed for method
                result = _promotionManager.GetCustsWithActiveTargetOrAchievementPromos(employeeId, customerId, outletId, false, ref customersList, ref t);
                if(result == GlobalErrors.Success && customersList != null && customersList.Count > 0)
                {
                    List<CustomerModel> customersGroupedPromotions = customersList.GroupBy(c => new { c.CustomerId, c.OutletId, c.CustomerCodeName, c.OutletCodeName }).Select(grp =>new CustomerModel { CustomerId = grp.Key.CustomerId, OutletId = grp.Key.OutletId,CustomerCodeName = grp.Key.CustomerCodeName,OutletCodeName = grp.Key.OutletCodeName, AchievementAndTargetPromotionIds = string.Join(",", grp.Select(x => x.PromotionId).ToList()) } ).ToList();
                    customersList = customersGroupedPromotions;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetCustomerActiveAchievementAndTargetPromotions(int customerId, int outletId, int employeeId, string promotionIdsString,ref List<Promotion> promotionsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(promotionIdsString)) // if promotionIds string is filled for current customer, get promotions from string
                {
                    result = _promotionManager.GetPromotionsFromIdsString(promotionIdsString, ref promotionsList);
                } 
                else // else, get promotions for customer from DB.
                {
                    List<CustomerModel> c = new List<CustomerModel>();
                    result = _promotionManager.GetCustsWithActiveTargetOrAchievementPromos(employeeId, customerId, outletId, true, ref c, ref promotionsList);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors CalculateTargetPromotions(List<CustomerModel> customerOutlets)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                bool isForSingleCustomer = false;
                int customerId = -1;
                int outletId = -1;

                if(customerOutlets != null && customerOutlets.Count > 0)
                {
                    dBHelper = new DBHelper<int>();
                    dBHelper.BeginTransaction();

                    if (customerOutlets.Count == 1)
                    {
                        isForSingleCustomer = true;
                        customerId = customerOutlets.FirstOrDefault().CustomerId;
                        outletId = customerOutlets.FirstOrDefault().OutletId;
                    }
                    else
                    {
                        result = _promotionManager.InsertIntoTempCustomerOutlets(customerOutlets ,dBHelper);
                    }

                    if(result == GlobalErrors.Success || isForSingleCustomer)
                    {
                        DateTime endDateMinusOneWeek = new DateTime(DateTime.Now.Year, DateTime.Now.Month, 1);
                        endDateMinusOneWeek = endDateMinusOneWeek.AddDays(-8);

                        #region[Run SP_ReCalculateAchievements Procedure]
                        TransactionModel tempObj = new TransactionModel();

                        tempObj.CustomerId = customerId;
                        tempObj.OutletId = outletId;
                        tempObj.TransactionDate = endDateMinusOneWeek;
                        result = _promotionManager.RunCalculateAchievementProcedure(tempObj, false, dBHelper);
                        #endregion
                    }

                    #region[Run SP_CalculateSatisfiedPromotions Procedure]
                    List<RelatedToTargetPromotion> relatedToTargetPromotions = new List<RelatedToTargetPromotion>();
                    List<int> relatedToTargetPromotionIdsList = new List<int>();
                    string promotionIdsString = string.Empty;
                    if (result == GlobalErrors.Success)
                    {
                        if (!isForSingleCustomer)
                        {
                            // get all selected customer outlet's promoton ids in a string, then return RELATED TO TARGET promotionIds ONLY.
                            List<string> allPromotionIdsList = customerOutlets.Select(custOut => custOut.AchievementAndTargetPromotionIds).ToList();
                            promotionIdsString = string.Join(',', allPromotionIdsList);
                            result = _promotionManager.GetRelatedToTargetPromotionIds(promotionIdsString, ref relatedToTargetPromotionIdsList, dBHelper);
                            if (result == GlobalErrors.Success && relatedToTargetPromotionIdsList != null && relatedToTargetPromotionIdsList.Count > 0)
                            {
                                promotionIdsString = "'" + string.Join(",", relatedToTargetPromotionIdsList) + "'";
                            }
                        }
                        if (result == GlobalErrors.Success)
                        {
                            result = _promotionManager.RunCalculateSatisfiedPromotionsProcedure(false,customerId, outletId, promotionIdsString, 0, 0, 0, false, string.Empty, !isForSingleCustomer, ref relatedToTargetPromotions,-1, dBHelper);
                        }
                    }
                    #endregion

                    GlobalErrors result2 = _promotionManager.DeleteFromTempCustomerOutlets(dBHelper);

                    if (result == GlobalErrors.Success && result2 == GlobalErrors.Success)
                    {
                        result = GlobalErrors.Success;
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

        #endregion
        public GlobalErrors EchoGeneratePromotionFile(string rootPath, ref List<Promotion> customerPromotions)
        {
            try
            {
                customerPromotions = new List<Promotion>();


               // CustomerAppSettingsModel customerAppSettingsModel = new CustomerAppSettingsModel();
              //  GlobalErrors result = LoginManager.GetCustomerAppSettings(ref customerAppSettingsModel);
                
              //  if (result != GlobalErrors.Success) return result;

                if (_requestRepository.CurrentEchoOperator.isMultiUser)
                {
                    List<Promotion> tempPromotion = new List<Promotion>();
                    List<Promotion> allCustomerPromotions = new List<Promotion>();
                    _requestRepository.CurrentEchoOperator.OperatorCustomers.ForEach(cusOperator =>
                    {
                        tempPromotion = _promotionManager.FillCustomerPromotions(cusOperator.CustomerId, cusOperator.OutletId, true, true, false, EchoService.CustomerAppSettings.ShowAchievements,1,-1,false, ItemFormProcessMode.Orders);
                        if (tempPromotion != null && tempPromotion.Count > 0)
                            allCustomerPromotions.AddRange(tempPromotion);
                    });
                    customerPromotions = allCustomerPromotions.GroupBy(car => car.PromotionId).Select(g => g.First()).OrderBy(promo => promo.PromotionName).ToList();
                }
                else
                {
                    customerPromotions = _promotionManager.FillCustomerPromotions(_requestRepository.CurrentEchoOperator.CustomerId, _requestRepository.CurrentEchoOperator.OutletId, true, true, false, EchoService.CustomerAppSettings.ShowAchievements, 1, -1,false, ItemFormProcessMode.Orders) ;
                }
                //convert object to json string.
                string json = JsonConvert.SerializeObject(customerPromotions);

                var path = Path.Combine(rootPath, "wwwroot", "Echo\\offers");
                if (!System.IO.File.Exists(path))
                {
                    Directory.CreateDirectory(path);
                }
                if (json != null && json.Length > 0)
                {
                    string fileName = string.Format("{0}.json", _requestRepository.CurrentEchoOperator.OperatorId);
                    string fullPath = Path.Combine(path, fileName);
                    //export data to json file. 
                    using (TextWriter tw = new StreamWriter(fullPath))
                    {
                        tw.WriteLine(json);
                    };
                }
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

    }
}