﻿using Sonic.Web.Core;
using Sonic.Web.Core.SendEmail;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Linq;
using System.Text;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Razor.Templating.Core;
using DinkToPdf;
using Sonic.Web.Resources;
using System.IO;
using DinkToPdf.Contracts;
using System.Net.Mail;
using InCube.Security;
using Sonic.Web.Core.AutoService;
using Sonic.Web.Model.AutoService;

namespace Sonic.Web.Service.SendEmail
{
    public class SendEmailService
    {
        public IRequestRepository _requestRepository;
        private readonly SendEmailManager _sendEmailManager;
        private readonly EmailManager _emailManager;
        private readonly EmailService _emailService;
        private readonly TransactionManager _transactionManager;
        private readonly PaymentManager _paymentManager;
        private readonly TemplateGenerator _templateGeneratorService;
        private readonly IConverter _converter;
        private ConfigurationManager _configurationManager;
        private SharedMethod _sharedMethod;
        private DynamicReportService _dynamicReportService;
        public SendEmailService(IRequestRepository requestRepository, IConverter converter)
        {
            _converter = converter;
            _requestRepository = requestRepository;
            _emailManager = new EmailManager(requestRepository);
            _emailService = new EmailService(requestRepository);
            _transactionManager = new TransactionManager(requestRepository);
            _paymentManager = new PaymentManager(requestRepository);
            _sendEmailManager = new SendEmailManager(requestRepository);
            _templateGeneratorService = new TemplateGenerator(requestRepository);
            _configurationManager = new ConfigurationManager(requestRepository);
            _sharedMethod = new SharedMethod(requestRepository);
            _dynamicReportService = new DynamicReportService(requestRepository,converter);
        }


        public GlobalErrors SendTransactionsByEmail(EmailFilter filter, bool isBackgroundService)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                var transactions = new List<TransactionHistory>();
                var payments = new List<TransactionHistory>();
                string query = string.Empty;
                DBHelper<int> dBHelper = new DBHelper<int>();
                int historyId = -1;
                result = AutoServiceManager.InsertWindowsServiceHistoryRecord(WebServiceActions.SendTransactionByEmail);
                if (result == GlobalErrors.Success)
                {
                    result = AutoServiceManager.GetWindowsServiceHistoryId(ref historyId);
                }

                if (result == GlobalErrors.Success && historyId > 0)
                {
                    int languageId = -1;
                    if (_configurationManager == null)
                    {
                        _configurationManager = new ConfigurationManager(null);
                    }
                    dynamic keyValue = null;
                    result = _configurationManager.GetConfigurationValueFromDB($"EmailPhrasesLanguage", ref keyValue);
                    if (result == GlobalErrors.Success && keyValue != null)
                    {
                        languageId = Convert.ToInt32(keyValue);
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }

                    result = _transactionManager.GetTransactionsToSendEmail(filter, ref transactions, languageId, isBackgroundService, -1, 1);

                    if (result == GlobalErrors.Success && transactions != null && transactions.Count > 0)
                    {
                        foreach (var transaction in transactions)
                        {
                            filter = new EmailFilter();
                            filter.CustomerId = transaction.CustomerId;
                            filter.OutletId = transaction.OutletId;
                            filter.DivisionId = transaction.DivisionId;
                            filter.TransactionId = transaction.TransactionId;
                            filter.TransactionTypeId = transaction.TransactionTypeID;
                            filter.ReportTypeID = TransactionManager.getReportTypeID(transaction);
                            if (transaction.LanguageID > 0)
                            {
                                languageId = transaction.LanguageID;
                            }

                            result = PrepareEmailAndSendTransactions(filter, languageId, transaction);
                        }
                    }

                    result = _transactionManager.GetTransactionsToSendEmail(filter, ref payments, languageId, isBackgroundService, -1, 2);
                    if (result == GlobalErrors.Success && payments != null && payments.Count > 0)
                    {
                        foreach (var payment in payments)
                        {
                            filter = new EmailFilter();
                            filter.CustomerId = payment.CustomerId;
                            filter.OutletId = payment.OutletId;
                            filter.DivisionId = payment.DivisionId;
                            filter.TransactionId = payment.CustomerPaymentId;
                            filter.TransactionTypeId = payment.PaymentTypeId.GetHashCode();
                            filter.ReportTypeID = EmailReportTypes.Collection.GetHashCode();
                            if (payment.LanguageID > 0)
                            {
                                languageId = payment.LanguageID;
                            }

                            result = PrepareEmailAndSendTransactions(filter, languageId, payment);
                        }
                    }

                    AutoServiceManager.UpdateWindowsServiceHistory(historyId, result.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors PrepareEmailAndSendTransactions(EmailFilter filter, int languageId, TransactionHistory transaction, TransactionEmailHistory oldEmail = null)
        {
            var result = GlobalErrors.Success;
            try
            {
                DynamicTemplateModel dynamicTemplateObj = null;
                DynamicTemplateReportFileModel dynamicTemplateReport = null;
                //if (oldEmail == null || String.IsNullOrEmpty(oldEmail.ServerAddress) || oldEmail.ReportID == -1 || oldEmail.ServerPort == -1 || String.IsNullOrEmpty(oldEmail.EmailPassword) || oldEmail.TemplateID == -1)
                //{
                result = _emailManager.GetDynamicTemplateForMail(filter, languageId, ref dynamicTemplateObj, oldEmail);
                //}
                //else
                //{
                //    dynamicTemplateObj = new DynamicTemplateModel();
                //    dynamicTemplateObj.TemplateId = oldEmail.TemplateID;
                //    dynamicTemplateObj.Email = oldEmail.SenderEmail;
                //    dynamicTemplateObj.ServerAddress = oldEmail.ServerAddress;
                //    dynamicTemplateObj.Password = oldEmail.EmailPassword;
                //    dynamicTemplateObj.EnableSSL = oldEmail.EnableSSL;
                //    dynamicTemplateObj.ServerPort = oldEmail.ServerPort;
                //    dynamicTemplateObj.HasAttachment = oldEmail.HasAttachment;
                //    dynamicTemplateObj.Body = oldEmail.EmailBody;
                //    dynamicTemplateObj.Subject = oldEmail.EmailSubject;
                //    dynamicTemplateObj.ReportID = oldEmail.ReportID;
                //}
                if (dynamicTemplateObj != null)
                {
                    //result = _emailManager.GetDynamicTemplateForMail(filter, languageId, ref dynamicTemplateObj);
                    if (result == GlobalErrors.Success && dynamicTemplateObj != null)
                    {
                        result = _emailManager.GetDynamicReportFileData(dynamicTemplateObj.ReportID, ref dynamicTemplateReport);
                        if (result == GlobalErrors.Success)
                        {
                            result = PrepareAttachmentAndSendEmail(languageId, dynamicTemplateObj, dynamicTemplateReport, transaction, filter.ReportTypeID);
                        }
                    }
                }
                else
                {
                    result = GlobalErrors.Error;
                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors PrepareAttachmentAndSendEmail(int languageId, DynamicTemplateModel dynamicTemplateObj, DynamicTemplateReportFileModel dynamicTemplateReport, TransactionHistory transaction, int reportTypeID)
        {
            var result = GlobalErrors.NotInitialized;
            var sendEmailResult = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                var numberOfDigits = 0;
                string query = string.Empty;

                dynamic keyValue = null;
                result = _configurationManager.GetConfigurationValueFromDB($"NumberOfDigits", ref keyValue);
                if (result == GlobalErrors.Success && keyValue != null)
                {
                    numberOfDigits = Convert.ToInt32(keyValue);
                }
                else
                {
                    return GlobalErrors.Error;
                }

                #region Prepare Email Information (sender,receiver,body ,subject ...)
                EmailModel email = new EmailModel();
                string body = dynamicTemplateObj.Body;
                string subject = dynamicTemplateObj.Subject;
                if (string.IsNullOrEmpty(transaction.OutletEmail) && string.IsNullOrEmpty(transaction.CustomerEmail))
                {
                    return GlobalErrors.Error;
                }
                else
                {
                    email.ToEmail = !string.IsNullOrEmpty(transaction.OutletEmail) ? transaction.OutletEmail.Trim() : transaction.CustomerEmail.Trim();

                    if (!IsValidEmail(email.ToEmail))
                        return GlobalErrors.Error;
                }
                if (!string.IsNullOrEmpty(body))
                {
                    email.Body = body.Replace("{0}", transaction.CustomerName)
                        .Replace("{1}", transaction.CustomerCode)
                        .Replace("{2}", transaction.TransactionDate.ToString($"dd/MM/yyyy"))
                        .Replace("{3}", transaction.TransactionTypeID != 3 ? transaction.TransactionId : (transaction.TransactionId + "-" + transaction.SourceTransactionID))
                        .Replace("{4}", $" {LocalUtilities.GetRoundedDecimal(reportTypeID == EmailReportTypes.Collection.GetHashCode() ? transaction.AppliedAmount : transaction.NetTotal, numberOfDigits)}  {transaction.CurrencyCode} ")
                        .Replace("@", "\n");
                }
                if (!string.IsNullOrEmpty(subject))
                {
                    email.Subject = subject.Replace("{0}", transaction.CustomerName)
                        .Replace("{1}", transaction.CustomerCode)
                        .Replace("{2}", transaction.TransactionDate.ToString($"dd/MM/yyyy"))
                        .Replace("{3}", transaction.TransactionId)
                        .Replace("{4}", $" {LocalUtilities.GetRoundedDecimal(reportTypeID == EmailReportTypes.Collection.GetHashCode() ? transaction.AppliedAmount : transaction.NetTotal, numberOfDigits)}  {transaction.CurrencyCode} ")
                        .Replace("@", "\n");
                }
                email.SenderEmail = dynamicTemplateObj.Email;

                EmailTemplateModel emailTemplate = new EmailTemplateModel();
                emailTemplate.Email = dynamicTemplateObj.Email;
                emailTemplate.ServerAddress = dynamicTemplateObj.ServerAddress;
                emailTemplate.Subject = email.Subject;
                emailTemplate.Body = email.Body;
                emailTemplate.Password = EncryptionManager.Instance.DecryptPassword(dynamicTemplateObj.Password);
                emailTemplate.EnableSSL = dynamicTemplateObj.EnableSSL;
                emailTemplate.EmailPort = dynamicTemplateObj.ServerPort;
                emailTemplate.MandatoryAttachement = dynamicTemplateObj.HasAttachment;
                #endregion

                #region Prepare Attachment File
                List<Attachment> attachments = new List<Attachment>();
                if (dynamicTemplateObj.HasAttachment)
                {
                    string reportPath = string.Empty;
                    var reportModel = new ReportModel();
                    transaction.reportMode = ReportMode.Transaction;
                    result = _templateGeneratorService.ExportReport(transaction, ref reportPath, ref reportModel, dynamicTemplateReport, true, languageId);
                    if (result == GlobalErrors.Success)
                    {
                        RazorTemplateEngine.Initialize();
                        string htmlContent = RazorTemplateEngine.RenderAsync(reportPath + (reportPath.Contains(".cshtml") ? "" : ".cshtml"), reportModel).Result;
                        string pageFooter = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Report_Page_Footer, _requestRepository.LanguageId);
                        string ofString = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Of_String, _requestRepository.LanguageId);
                        string footer = string.Format("{0} [page] {1} [toPage]", pageFooter, ofString);
                        var globalSettings = new GlobalSettings
                        {
                            ColorMode = ColorMode.Color,
                            Orientation = Orientation.Portrait,
                            PaperSize = PaperKind.A4,
                            Margins = new MarginSettings { Top = 10, Left = 3, Right = 3 },
                            DocumentTitle = reportModel.ReportTitle,
                            DPI = 500
                            //Out = @"D:\PDFCreator\Employee_Report.pdf"  USE THIS PROPERTY TO SAVE PDF TO A PROVIDED LOCATION
                        };
                        var objectSettings = new ObjectSettings
                        {
                            PagesCount = true,
                            HtmlContent = htmlContent,
                            //Page = "https://code-maze.com/", USE THIS PROPERTY TO GENERATE PDF CONTENT FROM AN HTML PAGE
                            WebSettings = { DefaultEncoding = "utf-8", UserStyleSheet = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "ReportsStyle.css") },
                            HeaderSettings = { FontName = "Arial", FontSize = 9 },
                            FooterSettings = { FontName = "Arial", FontSize = 9, Left = DateTime.Now.ToString(), Right = footer, Spacing = 1.8 }
                        };
                        var pdf = new HtmlToPdfDocument()
                        {
                            GlobalSettings = globalSettings,
                            Objects = { objectSettings }
                        };
                        ////_converter.Convert(pdf); IF WE USE Out PROPERTY IN THE GlobalSettings CLASS, THIS IS ENOUGH FOR CONVERSION
                        attachments.Add(new Attachment(new MemoryStream(_converter.Convert(pdf)), $"{dynamicTemplateReport.FileName}.pdf"));
                    }
                    else
                    {
                        return result;
                    }
                }
                #endregion
                string failureReason = string.Empty;
                #region Send Email
                sendEmailResult = _emailService.SendEmail(null, email, null, string.Empty, string.Empty, string.Empty, emailTemplate, attachments, true, ref failureReason);
                if (!String.IsNullOrEmpty(failureReason))
                {
                    if (failureReason.ToLower().Contains("Unable to read data from the transport connection: The connection was closed.".ToLower()))
                        failureReason = ResourcesManager.TranslateKey(MessagesConstants.Desc_Sender_Email_Or_Password_Is_Wrong, _requestRepository.LanguageId);
                    else if (failureReason.ToLower().Contains("No such host is known.".ToLower()))
                        failureReason = ResourcesManager.TranslateKey(MessagesConstants.Desc_Sender_Server_Address_Email_Is_Wrong, _requestRepository.LanguageId);
                    else if (failureReason.ToLower().Contains("The operation has timed out.".ToLower()))
                        failureReason = ResourcesManager.TranslateKey(MessagesConstants.Desc_Sender_Email_Port_Is_Wrong, _requestRepository.LanguageId);
                    else if (failureReason.ToLower().Contains("Mailbox unavailable. The server response was".ToLower()))
                        failureReason = ResourcesManager.TranslateKey(MessagesConstants.Desc_Customer_Email_Is_Wrong, _requestRepository.LanguageId);
                    else
                        failureReason = ResourcesManager.TranslateKey(MessagesConstants.Desc_Unknown_Error, _requestRepository.LanguageId);
                }
                //loop to get error message based on exception id
                if (reportTypeID == EmailReportTypes.Collection.GetHashCode())
                {
                    result = _sendEmailManager.SaveTransactionEmailHistory(transaction.CustomerPaymentId, transaction.CustomerId, transaction.OutletId,
                        transaction.DivisionId, dynamicTemplateObj.TemplateId, email.SenderEmail, email.ToEmail, email.Subject, email.Body,
                        transaction.PaymentStatusId == PaymentStatusTypes.Voided ? true : false,
                        sendEmailResult == GlobalErrors.Success ? EmailStatus.Success : EmailStatus.Failed, failureReason);

                }
                else
                {
                    result = _sendEmailManager.SaveTransactionEmailHistory(transaction.TransactionId, transaction.CustomerId, transaction.OutletId,
                        transaction.DivisionId, dynamicTemplateObj.TemplateId, email.SenderEmail, email.ToEmail, email.Subject, email.Body,
                        transaction.Voided, sendEmailResult == GlobalErrors.Success ? EmailStatus.Success : EmailStatus.Failed, failureReason);

                }

                #endregion

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                sendEmailResult = GlobalErrors.Error;
            }
            return sendEmailResult;
        }

        public GlobalErrors PrepareEmployeeEmailAttachment(List<Attachment> attachments, dynamic reportModel, string reportName, int languageId)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {

                RazorTemplateEngine.Initialize();
                string htmlContent = RazorTemplateEngine.RenderAsync($"~/PDFUtility/DynamicTemplates/{languageId}/{reportName}.cshtml", reportModel).Result;
                string pageFooter = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Report_Page_Footer, _requestRepository.LanguageId);
                string ofString = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Of_String, _requestRepository.LanguageId);
                string footer = string.Format("{0} [page] {1} [toPage]", pageFooter, ofString);
                var globalSettings = new GlobalSettings
                {
                    ColorMode = ColorMode.Color,
                    Orientation = Orientation.Portrait,
                    PaperSize = PaperKind.A4,
                    Margins = new MarginSettings { Top = 10, Left = 3, Right = 3 },
                    DocumentTitle = reportModel.ReportTitle,
                    DPI = 500
                    //Out = @"D:\PDFCreator\Employee_Report.pdf"  USE THIS PROPERTY TO SAVE PDF TO A PROVIDED LOCATION
                };
                var objectSettings = new ObjectSettings
                {
                    PagesCount = true,
                    HtmlContent = htmlContent,
                    //Page = "https://code-maze.com/", USE THIS PROPERTY TO GENERATE PDF CONTENT FROM AN HTML PAGE
                    WebSettings = { DefaultEncoding = "utf-8", UserStyleSheet = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "ReportsStyle.css") },
                    HeaderSettings = { FontName = "Arial", FontSize = 9 },
                    FooterSettings = { FontName = "Arial", FontSize = 9, Left = DateTime.Now.ToString(), Right = footer, Spacing = 1.8 }
                };
                var pdf = new HtmlToPdfDocument()
                {
                    GlobalSettings = globalSettings,
                    Objects = { objectSettings }
                };
                ////_converter.Convert(pdf); IF WE USE Out PROPERTY IN THE GlobalSettings CLASS, THIS IS ENOUGH FOR CONVERSION
                attachments.Add(new Attachment(new MemoryStream(_converter.Convert(pdf)), $"{reportName}.pdf"));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors PrepareEmployeeTemplateAndSendSummaryEmail(EmailFilter filter)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {

                int languageId = 0, numberOfDigits = 0;
                dynamic keyValue = null;
                result = _configurationManager.GetConfigurationValueFromDB($"EmailPhrasesLanguage", ref keyValue);
                List<Attachment> attachments = new List<Attachment>();

                if (result == GlobalErrors.Success && keyValue != null)
                {
                    languageId = Convert.ToInt32(keyValue);
                }
                else
                {
                    return GlobalErrors.Error;
                }
                result = _configurationManager.GetConfigurationValueFromDB($"NumberOfDigits", ref keyValue);
                if (result == GlobalErrors.Success && keyValue != null)
                {
                    numberOfDigits = Convert.ToInt32(keyValue);
                }
                else numberOfDigits = 0;
                List<DynamicTemplateModel> dynamicTemplates = new List<DynamicTemplateModel>();
                result = _emailManager.GetEmployeeDynamicTemplateForMail(filter, languageId, ref dynamicTemplates);

                if (result == GlobalErrors.Success && dynamicTemplates != null && dynamicTemplates.Count > 0)
                {
                    List<dynamic> allRecvivers = new List<dynamic>();
                    List<dynamic> templateSercivers = new List<dynamic>();
                    EmployeeModel sender = new EmployeeModel();
                    string endOfDayDate = "", routeName = "", routeCode = "";
                    sender.EmployeeId = filter.EmployeeID;
                    string templatesId = string.Join(",", dynamicTemplates.Select(x => x.TemplateId).ToList());
                    result = _emailManager.CacheEmailData(templatesId, ref sender, ref allRecvivers, filter.RouteHistoryID, ref endOfDayDate, languageId, ref routeName, ref routeCode);
                    if (result != GlobalErrors.Success) return result;

                    List<dynamic> detailsList = new List<dynamic>();
                    if (filter.ReportTypeID == EmailReportTypes.LoadRequest.GetHashCode() || filter.ReportTypeID == EmailReportTypes.OffloadRequest.GetHashCode() || filter.ReportTypeID == EmailReportTypes.NewCustomer.GetHashCode())
                    {
                        //get operation data
                        result = _emailManager.GetOperationData(filter, languageId, ref detailsList);
                        if (result != GlobalErrors.Success) return result;
                    }

                    foreach (DynamicTemplateModel dynamicTemplateObj in dynamicTemplates)
                    {
                        attachments = new List<Attachment>();
                        if (allRecvivers.Any(x => x.TemplateId == dynamicTemplateObj.TemplateId))
                        {
                            templateSercivers = allRecvivers.Where(x => x.TemplateId == dynamicTemplateObj.TemplateId).ToList();
                        }
                        List<DynamicTemplateEmployeeReportTypes> reports = new List<DynamicTemplateEmployeeReportTypes>();
                        if ((templateSercivers != null && templateSercivers.Count > 0))
                        {

                            result = _emailManager.GetTemplateReports(languageId, dynamicTemplateObj.TemplateId, ref reports);
                        }
                        if (result == GlobalErrors.Success )
                        {
                            if ((filter.ReportTypeID == EmailReportTypes.LoadRequest.GetHashCode() || filter.ReportTypeID == EmailReportTypes.OffloadRequest.GetHashCode() || filter.ReportTypeID == EmailReportTypes.NewCustomer.GetHashCode()) && detailsList.Count > 0)
                            {
                                foreach (var detail in detailsList)
                                {
                                    result = EmployeeSendEmail(dynamicTemplateObj, reports, sender, routeName, routeCode, numberOfDigits, languageId, filter, attachments, templateSercivers, endOfDayDate, detail);
                                }
                            }
                            else
                            {
                                result = EmployeeSendEmail(dynamicTemplateObj, reports, sender, routeName, routeCode, numberOfDigits, languageId, filter, attachments, templateSercivers, endOfDayDate, null);
                            }
                        }
                        else
                        {
                            return result;

                        }
                       
                    }
                }
                else result = GlobalErrors.Error;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private GlobalErrors EmployeeSendEmail(DynamicTemplateModel dynamicTemplateObj, List<DynamicTemplateEmployeeReportTypes> reports, EmployeeModel sender, string routeName, string routeCode, int numberOfDigits, int languageId, EmailFilter filter, List<Attachment> attachments, List<dynamic> templateSercivers, string endOfDayDate, dynamic detail)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                dynamicTemplateObj.EmployeeReports = new List<DynamicTemplateEmployeeReportTypes>(reports);

                foreach (DynamicTemplateEmployeeReportTypes typeModel in dynamicTemplateObj.EmployeeReports)
                {
                    ReportModel reportModel = new ReportModel();
                    reportModel.EmployeeName = sender.EmployeeName;
                    reportModel.EmployeeCode = sender.EmployeeCode;
                    reportModel.Date = DateTime.Now;
                    reportModel.RouteName = routeName;
                    reportModel.RouteCode = routeCode;
                    reportModel.NumberOfDigits = numberOfDigits;
                    if (!string.IsNullOrEmpty(typeModel.Query))
                    {
                        result = _emailManager.PrepareReportModelQuery(languageId, filter, ref reportModel, dynamicTemplateObj.TemplateId, typeModel);
                        if (result != GlobalErrors.Success) return result;
                    }
                    if (dynamicTemplateObj.HasAttachment)
                    {
                        result = PrepareEmployeeEmailAttachment(attachments, reportModel, typeModel.ReportDescription, languageId);
                        if (result != GlobalErrors.Success) return result;
                    }
                    //if (result != GlobalErrors.Success) break;
                }

                for (int i = 0; i < templateSercivers.Count; i++)
                {

                    EmailModel email = new EmailModel();
                    string body = dynamicTemplateObj.Body;
                    string subject = dynamicTemplateObj.Subject;

                    email.ToEmail = templateSercivers[i].Email;
                    if (!IsValidEmail(email.ToEmail))
                        continue;

                    if (!string.IsNullOrEmpty(body))
                    {
                        email.Body = body.Replace("{0}", string.IsNullOrEmpty(sender.EmployeeName) ? "---" : sender.EmployeeName)//Employee name
                            .Replace("{1}", string.IsNullOrEmpty(sender.EmployeeCode) ? "---" : sender.EmployeeCode)//Employee code
                            .Replace("{2}", string.IsNullOrEmpty(templateSercivers[i].EmployeeName) ? "---" : templateSercivers[i].EmployeeName)//Recevier name
                            .Replace("{3}", string.IsNullOrEmpty(templateSercivers[i].EmployeeCode) ? "---" : templateSercivers[i].EmployeeCode)//Receiver employee code
                            .Replace("{4}", string.IsNullOrEmpty(routeName) ? "---" : routeName)//Route name
                            .Replace("{5}", string.IsNullOrEmpty(routeCode) ? "---" : routeCode);//Route code
                          
                    }
                    if (!string.IsNullOrEmpty(subject))
                    {
                        email.Subject = subject.Replace("{0}", string.IsNullOrEmpty(sender.EmployeeName) ? "---" : sender.EmployeeName)//Employee name
                           .Replace("{1}", string.IsNullOrEmpty(sender.EmployeeCode) ? "---" : sender.EmployeeCode)//Employee code
                           .Replace("{2}", string.IsNullOrEmpty(templateSercivers[i].EmployeeName) ? "---" : templateSercivers[i].EmployeeName)//Recevier name
                           .Replace("{3}", string.IsNullOrEmpty(templateSercivers[i].EmployeeCode) ? "---" : templateSercivers[i].EmployeeCode)//Receiver employee code
                           .Replace("{4}", string.IsNullOrEmpty(routeName) ? "---" : routeName)//Recevier name
                           .Replace("{5}", string.IsNullOrEmpty(routeCode) ? "---" : routeCode);//Route code
                           
                    }

                    if (filter.ReportTypeID == EmailReportTypes.LoadRequest.GetHashCode() || filter.ReportTypeID == EmailReportTypes.OffloadRequest.GetHashCode())
                    {
                        if (!string.IsNullOrEmpty(body))
                        {
                            email.Body = email.Body.Replace("{6}", string.IsNullOrEmpty(detail.TransactionID) ? "---" : detail.TransactionID)
                                .Replace("{7}", detail.TransactionDate == null ? "---" : detail.TransactionDate.ToString())
                                .Replace("{8}", string.IsNullOrEmpty(detail.VehicleName) ? "---" : detail.VehicleName)
                                .Replace("{9}", string.IsNullOrEmpty(detail.VehicleCode) ? "---" : detail.VehicleCode)
                                .Replace("{10}", string.IsNullOrEmpty(detail.RefWarehouseName) ? "---" : detail.RefWarehouseName)
                                .Replace("{11}", string.IsNullOrEmpty(detail.RefWarehouseCode) ? "---" : detail.RefWarehouseCode)
                                .Replace("{12}", string.IsNullOrEmpty(detail.TransactionStatus) ? "---" : detail.TransactionStatus)
                                .Replace("@", "\n");
                        }
                        if (!string.IsNullOrEmpty(subject))
                        {
                            email.Subject = email.Subject.Replace("{6}", string.IsNullOrEmpty(detail.TransactionID) ? "---" : detail.TransactionID)
                                .Replace("{7}", detail.TransactionDate == null ? "---" : detail.TransactionDate.ToString())
                                .Replace("{8}", string.IsNullOrEmpty(detail.VehicleName) ? "---" : detail.VehicleName)
                                .Replace("{9}", string.IsNullOrEmpty(detail.VehicleCode) ? "---" : detail.VehicleCode)
                                .Replace("{10}", string.IsNullOrEmpty(detail.RefWarehouseName) ? "---" : detail.RefWarehouseName)
                                .Replace("{11}", string.IsNullOrEmpty(detail.RefWarehouseCode) ? "---" : detail.RefWarehouseCode)
                                .Replace("{12}", string.IsNullOrEmpty(detail.TransactionStatus) ? "---" : detail.TransactionStatus)
                                .Replace("@", "\n");
                        }
                    }
                    else if (filter.ReportTypeID == EmailReportTypes.NewCustomer.GetHashCode())
                    {
                        if (!string.IsNullOrEmpty(body))
                        {
                            email.Body = email.Body.Replace("{6}", string.IsNullOrEmpty(detail.CustomerName) ? "---" : detail.CustomerName)
                                .Replace("{7}", string.IsNullOrEmpty(detail.CustomerCode) ? "---" : detail.CustomerCode)
                                .Replace("{8}", string.IsNullOrEmpty(detail.CustomerPhone) ? "---" : detail.CustomerPhone)
                                .Replace("{9}", string.IsNullOrEmpty(detail.CustomerEmail) ? "---" : detail.CustomerEmail)
                                .Replace("{10}", string.IsNullOrEmpty(detail.CustomerAddress) ? "---" : detail.CustomerAddress)
                                .Replace("{11}", string.IsNullOrEmpty(detail.OutletCode) ? "---" : detail.OutletCode)
                                .Replace("{12}", string.IsNullOrEmpty(detail.OutletPhone) ? "---" : detail.OutletPhone)
                                .Replace("{13}", string.IsNullOrEmpty(detail.OutletEmail) ? "---" : detail.OutletEmail)
                                .Replace("{14}", string.IsNullOrEmpty(detail.OutletAddress) ? "---" : detail.OutletAddress)
                                .Replace("{15}", string.IsNullOrEmpty(endOfDayDate) ? "---" : endOfDayDate)
                                .Replace("@", "\n");
                        }
                        if (!string.IsNullOrEmpty(subject))
                        {
                            email.Subject = email.Subject.Replace("{6}", string.IsNullOrEmpty(detail.CustomerName) ? "---" : detail.CustomerName)
                                .Replace("{7}", string.IsNullOrEmpty(detail.CustomerCode) ? "---" : detail.CustomerCode)
                                .Replace("{8}", string.IsNullOrEmpty(detail.CustomerPhone) ? "---" : detail.CustomerPhone)
                                .Replace("{9}", string.IsNullOrEmpty(detail.CustomerEmail) ? "---" : detail.CustomerEmail)
                                .Replace("{10}", string.IsNullOrEmpty(detail.CustomerAddress) ? "---" : detail.CustomerAddress)
                                .Replace("{11}", string.IsNullOrEmpty(detail.OutletCode) ? "---" : detail.OutletCode)
                                .Replace("{12}", string.IsNullOrEmpty(detail.OutletPhone) ? "---" : detail.OutletPhone)
                                .Replace("{13}", string.IsNullOrEmpty(detail.OutletEmail) ? "---" : detail.OutletEmail)
                                .Replace("{14}", string.IsNullOrEmpty(detail.OutletAddress) ? "---" : detail.OutletAddress)
                                .Replace("{15}", string.IsNullOrEmpty(endOfDayDate) ? "---" : endOfDayDate)
                                .Replace("@", "\n");
                        }
                    }
                    else
                    {
                        email.Body = email.Body.Replace("{6}", string.IsNullOrEmpty(endOfDayDate) ? "---" : endOfDayDate)
                            .Replace("@", "\n"); ;
                        email.Subject = email.Subject.Replace("{6}", string.IsNullOrEmpty(endOfDayDate) ? "---" : endOfDayDate)
                            .Replace("@", "\n"); ;
                       
                    }
                  
                    

                    email.SenderEmail = dynamicTemplateObj.Email;

                    EmailTemplateModel emailTemplate = new EmailTemplateModel();
                    emailTemplate.Email = dynamicTemplateObj.Email;
                    emailTemplate.ServerAddress = dynamicTemplateObj.ServerAddress;
                    emailTemplate.Subject = email.Subject;
                    emailTemplate.Body = email.Body;
                    emailTemplate.Password = EncryptionManager.Instance.DecryptPassword(dynamicTemplateObj.Password);
                    emailTemplate.EnableSSL = dynamicTemplateObj.EnableSSL;
                    emailTemplate.EmailPort = dynamicTemplateObj.ServerPort;
                    emailTemplate.MandatoryAttachement = dynamicTemplateObj.HasAttachment;
                    emailTemplate.ReceiverEmployeeID = templateSercivers[i].EmployeeId;
                    emailTemplate.TemplateId = dynamicTemplateObj.TemplateId;
                    ////Send email
                    result = _emailService.SendEmail(null, email, null, string.Empty, string.Empty, string.Empty, emailTemplate, attachments, true, filter);
                    //if (result != GlobalErrors.Success) break;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors PrepareTransactionAndSendEmail(EmailFilter filter, TransactionEmailHistory oldEmail = null)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                int languageId = 0;
                dynamic keyValue = null;
                result = _configurationManager.GetConfigurationValueFromDB($"EmailPhrasesLanguage", ref keyValue);
                if (result == GlobalErrors.Success && keyValue != null)
                {
                    languageId = Convert.ToInt32(keyValue);
                }
                else
                {
                    return GlobalErrors.Error;
                }
                var transaction = new TransactionHistory();
                result = _transactionManager.PrepareTransactionAndSendEmail(filter, languageId, ref transaction);
                if (result == GlobalErrors.Success && transaction != null)
                {
                    filter.ReportTypeID = TransactionManager.getReportTypeID(transaction);
                    if (result == GlobalErrors.Success && filter.ReportTypeID > 0)
                    {
                        languageId = transaction.LanguageID;
                        result = PrepareEmailAndSendTransactions(filter, languageId, transaction, oldEmail);
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;

        }

        public GlobalErrors PrepareInvoicesOnDownload(int routeHistoryID)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                int languageId = 1;
                var payments = new List<TransactionHistory>();
                var transactions = new List<TransactionHistory>();
                result = _transactionManager.GetTransactionsToSendEmail(null, ref transactions, languageId, false, routeHistoryID, 1);
                if (result == GlobalErrors.Success && transactions != null && transactions.Count > 0)
                {
                    for (int i = 0; i < transactions.Count; i++)
                    {
                        var transaction = transactions[i];
                        if (transaction.LanguageID > 0)
                            languageId = transaction.LanguageID;
                        EmailFilter filter = new EmailFilter();
                        filter.CustomerId = transaction.CustomerId;
                        filter.OutletId = transaction.OutletId;
                        filter.TransactionId = transaction.TransactionId;
                        filter.TransactionTypeId = transaction.TransactionTypeID;
                        filter.ReportTypeID = TransactionManager.getReportTypeID(transaction);
                        result = _transactionManager.PrepareTransactionAndSendEmail(filter, languageId, ref transaction);
                        if (result == GlobalErrors.Success && transaction != null)
                        {
                            result = PrepareEmailAndSendTransactions(filter, languageId, transaction);
                        }
                    }
                }

                result = _transactionManager.GetTransactionsToSendEmail(null, ref payments, languageId, false, routeHistoryID, 2);
                if (result == GlobalErrors.Success && payments != null && payments.Count > 0)
                {
                    for (int i = 0; i < payments.Count; i++)
                    {
                        var payment = payments[i];
                        if (payment.LanguageID > 0)
                            languageId = payment.LanguageID;
                        EmailFilter filter = new EmailFilter();
                        filter.CustomerId = payment.CustomerId;
                        filter.OutletId = payment.OutletId;
                        filter.TransactionId = payment.CustomerPaymentId;
                        filter.TransactionTypeId = payment.PaymentTypeId.GetHashCode();
                        filter.ReportTypeID = EmailReportTypes.Collection.GetHashCode();
                        TransactionHistory paymentHistory = new TransactionHistory();

                        result = _transactionManager.PrepareTransactionAndSendEmail(filter, languageId, ref payment);
                        if (result == GlobalErrors.Success && payment != null)
                        {
                            result = PrepareEmailAndSendTransactions(filter, languageId, payment);
                        }
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;

        }

        bool IsValidEmail(string email)
        {
            try
            {
                if (string.IsNullOrEmpty(email) || email.Trim().EndsWith("."))
                {
                    return false;
                }
                var addr = new MailAddress(email);
                return addr.Address == email;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public GlobalErrors GetTransactionsEmails(ref List<TransactionEmailHistory> transactionEmails, TransactionEmailHistory filterModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _emailManager.GetTransactionsEmails(ref transactionEmails, filterModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ShowReport(EmailFilter filter, TransactionEmailHistory email, ref string path, ref ReportModel reportModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DynamicTemplateModel dynamicTemplateObj = null;
                DynamicTemplateReportFileModel dynamicTemplateReport = null;
                dynamicTemplateObj = new DynamicTemplateModel();
                dynamicTemplateObj.TemplateId = email.TemplateID;
                dynamicTemplateObj.Email = email.SenderEmail;
                dynamicTemplateObj.ServerAddress = email.ServerAddress;
                dynamicTemplateObj.Password = email.EmailPassword;
                dynamicTemplateObj.EnableSSL = email.EnableSSL;
                dynamicTemplateObj.ServerPort = email.ServerPort;
                dynamicTemplateObj.HasAttachment = email.HasAttachment;
                dynamicTemplateObj.Body = email.EmailBody;
                dynamicTemplateObj.Subject = email.EmailSubject;
                dynamicTemplateObj.ReportID = email.ReportID;
                var transaction = new TransactionHistory();
                result = _transactionManager.PrepareTransactionAndSendEmail(filter, _requestRepository.LanguageId, ref transaction);
                if (result == GlobalErrors.Success && transaction != null)
                    filter.ReportTypeID = TransactionManager.getReportTypeID(transaction);
                if (result == GlobalErrors.Success && dynamicTemplateObj != null)
                {
                    result = _emailManager.GetDynamicTemplateForMail(filter, _requestRepository.LanguageId, ref dynamicTemplateObj);//here, sonic will get the most priority report id
                    if (result == GlobalErrors.Success && dynamicTemplateObj != null)
                    {
                        result = _emailManager.GetDynamicReportFileData(dynamicTemplateObj.ReportID, ref dynamicTemplateReport);
                        if (result == GlobalErrors.Success)
                        {

                            result = _templateGeneratorService.ExportReport(transaction, ref path, ref reportModel, dynamicTemplateReport, true, _requestRepository.LanguageId);
                            //if(result == GlobalErrors.Success)
                            //result = _templateGenerator.ExportReport(transaction, ref path, ref reportModel, null, true, _requestRepository.LanguageId);
                            //path = "~/PDFUtility/" + "DynamicTemplates" + "/";
                            //path = Path.Combine(path, _requestRepository.LanguageId + "/");
                            //if (dynamicTemplateReport != null && !string.IsNullOrWhiteSpace(dynamicTemplateReport.FileName))
                            //{
                            //    path = Path.Combine(path, dynamicTemplateReport.FileName);
                            //}
                            //else
                            //{
                            //    result = GlobalErrors.Error;
                            //}

                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetTransactionsEmailsForSharedTable(ref SharedTableResult<TransactionEmailHistory> transactionEmails, GeneralFilter generalFilter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _emailManager.GetTransactionsEmailsForSharedTable(ref transactionEmails, generalFilter);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SendReportScheduleByEmail(AutoServiceModel autoService)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            int historyId = -1;

            try
            {
                #region [Declarations]
                List<EmployeeModel> employeesList = new List<EmployeeModel>();
                List<DynamicReportModel> reportsList = new List<DynamicReportModel>();
                List<ReportFilterModel> reportFilters = new List<ReportFilterModel>();
                List<ConfigurationModel> configurations = new List<ConfigurationModel>();
                List<ReportScheduleModel> reportScheduleList = new List<ReportScheduleModel>();
                DateTime startOfPeriod = DateTime.MinValue;
                DateTime EndOfPeriod = DateTime.MinValue;
                DateTime today = DateTime.Today;
                int languageId = -1;
                int numberOfDigits = -1;
                int numberOfStockDigits = -1;
                bool printHeaderPerPage = false;
                #endregion

                result = AutoServiceManager.InsertWindowsServiceHistoryRecord(WebServiceActions.ReportScheduleService);
                if (result == GlobalErrors.Success)
                {
                    result = AutoServiceManager.GetWindowsServiceHistoryId(ref historyId);
                }

                result = _dynamicReportService.GetReportScheduledToday(ref reportScheduleList);
                
                if(result == GlobalErrors.Success && (reportScheduleList == null || reportScheduleList.Count == 0))
                {
                    result = GlobalErrors.Success;
                    return result;
                }
                if (result == GlobalErrors.Success && historyId > 0 && reportScheduleList.Count > 0)
                {
                    foreach (ReportScheduleModel reportSchedule in reportScheduleList)
                    {
                        result = _emailManager.GetReportScheduleEmployees(ref employeesList, reportSchedule.ScheduleId);

                        #region [configurations]
                        foreach (EmployeeModel employee in employeesList)
                        {
                            configurations = ConfigurationManager.GetReportScheduleConfiguartionList(employee.EmployeeId);

                            if (configurations != null && configurations.Count > 0)
                            {
                                foreach (var configuration in configurations)
                                {
                                    if (configuration.KeyName == "EmailPhrasesLanguage")
                                    {
                                        languageId = Convert.ToInt32(configuration.KeyValue);
                                    }
                                    if (configuration.KeyName == "NumberOfDigits")
                                    {
                                        numberOfDigits = Convert.ToInt32(configuration.KeyValue);
                                    }
                                    if (configuration.KeyName == "NumberOfStockDigits")
                                    {
                                        numberOfStockDigits = Convert.ToInt32(configuration.KeyValue);
                                    }
                                    if (configuration.KeyName == "PrintHeaderPerPage")
                                    {
                                        printHeaderPerPage = Convert.ToBoolean(configuration.KeyValue);
                                    }
                                }
                            }
                        }
                        #endregion

                        if (result == GlobalErrors.Success)
                        {
                            result = _emailManager.GetReportScheduleAssignment(ref reportsList, reportSchedule.ScheduleId, languageId);
                        }
                        if (result == GlobalErrors.Success && reportsList.Count > 0)
                        {
                            result = _emailManager.GetReportScheduleAssignmentDetails(ref reportFilters, reportSchedule.ScheduleId);

                            if (result == GlobalErrors.Success)
                            {
                                foreach (EmployeeModel employee in employeesList)
                                {
                                    List<Attachment> reportPDF = new List<Attachment>();
                                    string reportName = string.Empty;

                                    for (int j = 0; j < reportsList.Count; j++)
                                    {
                                        DynamicReportModel reportModel = reportsList[j];

                                        result = _dynamicReportService.PrepareReportForEmployee(employee, reportModel, reportSchedule.PeriodTypeId, reportFilters, reportPDF, languageId, numberOfDigits, numberOfStockDigits, printHeaderPerPage, ref reportName);
                                    }
                                    result = _emailService.SendReportScheduleByEmail(reportPDF, employee, reportSchedule.ScheduleId, languageId, reportName);
                                }
                            }
                            if (result == GlobalErrors.Success)
                            {
                                result = _sharedMethod.GetReportScheduleNextRunTime(reportSchedule);
                            }
                            if (result == GlobalErrors.Success)
                            {
                                result = _dynamicReportService.UpdateNewTimeToRun(reportSchedule, null);
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                AutoServiceManager.UpdateWindowsServiceHistory(historyId, result.ToString());
            }
            return result;
        }        
    }
}
