﻿using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Linq;
using System.IO;

namespace Sonic.Web.Service
{
    public class ServicesService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ServicesManager _servicesManager;
        public ServicesService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _servicesManager = new ServicesManager(requestRepository);
        }
        public GlobalErrors GetAllServices(ref List<ServicesModel> allServicess)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _servicesManager.GetAllServices(ref allServicess);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors UpdateServices(ServicesModel changedService)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _servicesManager.UpdateServices(changedService);

            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public WindowsServiceData GetWindowsServiceData()
        {
            try
            {
                return _servicesManager.GetWindowsServiceData();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }
        public GlobalErrors FillImagesForServices()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string imagesPath = Path.Combine(Directory.GetCurrentDirectory(), "wwwroot\\img\\");
                if (!Directory.Exists(imagesPath))
                    Directory.CreateDirectory(imagesPath);
                FillSystemImages(imagesPath, false);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillSystemImages()
        {
            return FillSystemImages(Directory.GetCurrentDirectory(), true);
        }
        public GlobalErrors FillSystemImages(string path, bool fillExcel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = ItemService.FillItemsImages(path);
                if(result == GlobalErrors.Success)
                    result = ItemService.FillCategoriesImages(path);
                if (result == GlobalErrors.Success)
                    result = ItemService.FillBrandsImages(path);
                if (result == GlobalErrors.Success && fillExcel)
                    result = ImportService.BuildExcelSheetTemplatesBasedOnActiveLanguages();
                if (result == GlobalErrors.Success)
                    SettingService.MoveUsersProfileImages(Directory.GetCurrentDirectory());
                
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
    }
}
