﻿using Microsoft.AspNetCore.Http;
using Newtonsoft.Json;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.General;
using Sonic.Web.Model.MasterData;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Reflection;
using System.Threading.Tasks;
using System.Web;

namespace Sonic.Web.Service
{
    public class SettingService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly SettingManager _settingManager;
        public SettingService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _settingManager = new SettingManager(requestRepository);
        }
        public  GlobalErrors GetModuleEditableDescriptions(int moduleId, ref ChangeDescriptionsTable descriptionsTable)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {

                var captions = new List<dynamic>();
                var languages = new List<LanguageModel>();
                result = _settingManager.GetModuleEditableDescriptions(moduleId, ref captions);
                if (result == GlobalErrors.Success)
                {
                    result = SettingManager.GetSonicLanguages(ref languages);
                }
                if (result == GlobalErrors.Success)
                {
                    descriptionsTable.TableHeader = languages;
                    descriptionsTable.TableData = captions;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public  GlobalErrors UpdateDescriptions(List<ExpandoObject> captions , int moduleId)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (moduleId == 1100)
                    result = _settingManager.UpdateFODescriptions(captions);
                else
                    result = _settingManager.UpdateDescriptions(captions);
                if(result == GlobalErrors.Success)
                {
                    WriteJSONs();
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveOperationLevels(List<ApprovalCycleOperationsModel> Data)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                result = _settingManager.SaveOperationLevels(Data);
              
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public  GlobalErrors UpdateSecurityGroups(SecurityGroupData Data)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                result = _settingManager.UpdateSecurityGroups(Data);
                if (result == GlobalErrors.Success)
                {
                    WriteJSONs();
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public static GlobalErrors GetAllLanguages(ref List<LanguageModel> languages, bool activeLanguageOnly)
        {
            try
            {
                return SettingManager.GetAllLanguages(ref languages, activeLanguageOnly);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public static void WriteJSONs()
        {
            var activeLanguages = new List<LanguageModel>();
            try
            {
                var allCaptions = SettingManager.GetAllDescriptions();

                var result = SettingManager.GetSonicLanguages(ref activeLanguages);

               
                if (!Directory.Exists("wwwroot\\Lang"))
                {
                    Directory.CreateDirectory("wwwroot\\Lang");
                }
                foreach (var lang in activeLanguages)
                {
                    var JSON = allCaptions.Where(a => a.LanguageId == lang.LanguageId).ToDictionary(key => key.DescriptionKey, value => value.DescriptionValue);


                    using (StreamWriter file = File.CreateText(string.Format(@"Resources\Lang\{0}.json", lang.Code)))
                    {
                        JsonSerializer serializer = new JsonSerializer();
                        //serialize object directly into file stream
                        serializer.Serialize(file, JSON);
                    }
                    using (StreamWriter file = File.CreateText(string.Format(@"wwwroot\Lang\{0}.json", lang.Code)))
                    {
                        JsonSerializer serializer = new JsonSerializer();
                        //serialize object directly into file stream
                        serializer.Serialize(file, JSON);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

            }
        }

        private static void WriteEnglishJSONFile(List<LanguageCaption> captions)
        {
            try
            {
                var enJSON = captions.Where(a => a.LanguageId == 1).ToDictionary(key => key.DescriptionKey, value => value.DescriptionValue);


                using (StreamWriter file = File.CreateText("Resources\\Lang\\en.json"))
                {
                    JsonSerializer serializer = new JsonSerializer();
                    //serialize object directly into file stream
                    serializer.Serialize(file, enJSON);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        private static void WriteArabicJSONFile(List<LanguageCaption> captions)
        {
            try
            {
                var arJSON = captions.Where(a => a.LanguageId == 2).ToDictionary(key => key.DescriptionKey, value => value.DescriptionValue);

                using (StreamWriter file = File.CreateText("Resources\\Lang\\ac.json"))
                {
                    JsonSerializer serializer = new JsonSerializer();
                    //serialize object directly into file stream
                    serializer.Serialize(file, arJSON);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public  void SaveCustomerAttachments(ICollection<IFormFile> files , string outletCode)
        {

            try
            {
                var path = Path.Combine(
                            Directory.GetCurrentDirectory(), "wwwroot",
                            "CustomerAttachments");

                if (!Directory.Exists(path))
                {
                    DirectoryInfo di = Directory.CreateDirectory(path);
                }

                path = Path.Combine(
                      Directory.GetCurrentDirectory(), "wwwroot",
                      "CustomerAttachments", outletCode);

                if (!Directory.Exists(path))
                {
                    DirectoryInfo di = Directory.CreateDirectory(path);
                }
                else
                {
                    DirectoryInfo di = new DirectoryInfo(path);
                    foreach (FileInfo file in di.GetFiles())
                    {
                        file.Delete();
                    }
                }


                foreach (var file in files)
                {
                    path = Path.Combine(
                    Directory.GetCurrentDirectory(), "wwwroot",
                    "CustomerAttachments", outletCode, file.FileName);
                    using (var stream = new FileStream(path, FileMode.Create))
                    {
                         file.CopyTo(stream);
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }

        }

        public  string[] GetCustomerAttachmetsNames(string outletCode)
        {
            var names =  new string[] { };

            var path = Path.Combine(
                    Directory.GetCurrentDirectory(), "wwwroot",
                    "CustomerAttachments", outletCode);

            if (Directory.Exists(path))
            {
                names = Directory.GetFiles(path)
                     .Select(Path.GetFileName)
                     .ToArray();
            }

            return names;

        }

        public GlobalErrors GetAvailableSecurityGroupsList(ref List<SecurityGroupsListModel> securityGroupsList)
        {
            try
            {
                return _settingManager.GetAvailableSecurityGroupsList(ref securityGroupsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetApprovalCycleOperations(ref List<ApprovalCycleOperationsModel> approvalCycleOperations)
        {
            try
            {
                return _settingManager.GetApprovalCycleOperations(ref approvalCycleOperations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetDescriptionsList(int SecurityGroupId, ref List<TextLanguage> DescriptionsList)
        {
            try
            {
                return _settingManager.GetDescriptionsList(SecurityGroupId, ref DescriptionsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors DeleteSecurityGroup(int securityGroupId)
        {
            return _settingManager.DeleteSecurityGroup(securityGroupId);
        }
        public GlobalErrors GetSonicModulesList(ref List<SonicModulesModel> modulesList)
        {
            try
            {
                return _settingManager.GetSonicModules(ref modulesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors RestoreDefaultCaptions(ref List<SonicModulesModel> modulesList)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                result = _settingManager.RestoreDefaultCaptions(ref modulesList);
                if (result == GlobalErrors.Success)
                {
                    WriteJSONs();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ManageLanguages(List<LanguageModel> languages)
        {
            var result = GlobalErrors.Success;
            try
            {
                foreach (var language in languages)
                {
                    if (language.OldStatus != language.IsChecked)
                    {
                        result = _settingManager.UpdateLanguageStatus(language.LanguageId, language.IsChecked);

                        if (language.IsChecked)
                        {
                            result = _settingManager.CloneDescriptionsFromEnglish(language.LanguageId);
                        }
                        else
                        {
                           result = _settingManager.DeleteInActiveDescriptions(language.LanguageId);
                        }
                    }
                }
                if(result == GlobalErrors.Success)
                {
                    result = ImportService.BuildExcelSheetTemplatesBasedOnActiveLanguages();
                }
                if (result == GlobalErrors.Success)
                {
                    WriteJSONs();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public static void MoveUsersProfileImages(string rootPath)
        {
            try
            {
                string srcFolderName = $"{rootPath}\\ClientApp\\src\\assets\\img\\users-img";
                //string srcFolderName = $"{rootPath}\\ClientApp\\dist\\assets\\img\\users-img";
                string rootFolderPath = $"{rootPath}\\{LocalUtilities.UserImageFolderPath}";

                if (!Directory.Exists(rootFolderPath))
                {
                    Directory.CreateDirectory(rootFolderPath);
                }

                foreach (var file in new DirectoryInfo(srcFolderName).GetFiles())
                {
                    var fileIsExists = File.Exists(rootFolderPath +"\\"+ file.Name);
                    if(!fileIsExists)
                    File.Move(file.FullName, rootFolderPath + "\\" + file.Name);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public GlobalErrors GetExcelSheetDynamicTemplateListSharedTable(GeneralFilter filter, ref SharedTableResult<ExcelSheetDynamicTemplateModel> templatesListShared)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _settingManager.GetExcelSheetDynamicTemplateListSharedTable(filter, ref templatesListShared);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                templatesListShared = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetExcelSheetSharedTable(ExcelSheetDynamicTemplateModel templateObject, ref List<ExcelSheetDynamicTemplateModel> excelSheetTemplates)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = SettingManager.GetExcelSheetSharedTable(templateObject,false, ref excelSheetTemplates, null);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors InsertExcelSheetDynamicTemplate(ExcelSheetDynamicTemplateModel templateObject)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _settingManager.InsertExcelSheetDynamicTemplate(templateObject);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors UpdateExcelSheetDynamicTemplate(ExcelSheetDynamicTemplateModel templateObject)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _settingManager.UpdateExcelSheetDynamicTemplate(templateObject);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetExcelSheetTemplateData(ExcelSheetDynamicTemplateModel excelSheetDynamicTemplate, ref ExcelSheetDynamicTemplateModel excelSheetObject)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<ExcelSheetDynamicTemplateModel> excelSheetTemplate = new List<ExcelSheetDynamicTemplateModel>();
            try
            {
                result = _settingManager.GetExcelSheetTemplateData(excelSheetDynamicTemplate.VendorId,excelSheetDynamicTemplate.ExcelSheetTypeId, ref excelSheetTemplate);
                if (result == GlobalErrors.Success)
                {
                    excelSheetObject.ExcelSheetTypeId = excelSheetDynamicTemplate.ExcelSheetTypeId;
                    excelSheetObject.VendorId = excelSheetDynamicTemplate.VendorId;
                    excelSheetObject.ExcelSheetList = excelSheetTemplate;
                    foreach(ExcelSheetDynamicTemplateModel excelSheet in excelSheetTemplate)
                    {
                        excelSheetObject.ParentLevelId = excelSheet.ParentLevelId;
                        excelSheetObject.SSCCLevelId = excelSheet.SSCCLevelId;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteExcelSheetData(int vendorId,int excelSheetTypeId, ref string errorMessage)
        {
            try
            {
                return _settingManager.DeleteExcelSheetData(vendorId, excelSheetTypeId, ref errorMessage);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }




       
        




        

        public GlobalErrors GetOperatorLoginFailuresListSharedTable(GeneralFilter filter, ref SharedTableResult<OperatorLoginFailureModel> operatorListShared)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _settingManager.GetOperatorLoginFailuresListSharedTable(filter, ref operatorListShared);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorListShared = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetOperatorLoginFailuresDetailsSharedTable(OperatorLoginFailureModel operatorObject, ref List<OperatorLoginFailureModel> operatorModels)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _settingManager.GetOperatorLoginFailuresDetailsSharedTable(operatorObject, ref operatorModels);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetOperatorNames(ref List<OperatorLoginFailureModel> operatorNamesObj)
        {
            return _settingManager.GetOperatorNames(ref operatorNamesObj);
        }
        public GlobalErrors UnlockOperator(OperatorLoginFailureModel operatorObject, ref string errorMessage)
        {
            try
            {
                return _settingManager.UnlockOperator(operatorObject, ref errorMessage);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetNoProductiveReasonList(ref SharedTableResult<NoProductiveReasonModel> noProductiveReasonList)
        {
            try
            {
                return _settingManager.GetNoProductiveReasonList(ref noProductiveReasonList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                noProductiveReasonList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors ModifyNoProductiveReason(NoProductiveReasonModel model)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                if (_settingManager.checkIfNoProductiveReasonIsAvailable(model))
                {
                    return GlobalErrors.NoMoreRows;
                }
                bool isEdit = false;
                if (model.ReasonId <= 0)
                {
                    model.ReasonId = _settingManager.GetMaxId("ReasonId", "NonProductiveVisitReasonLanguage", null);
                }
                else
                {
                    isEdit = true;
                }
                if (model.ReasonId == -1)
                {
                    return GlobalErrors.Error;
                }
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                if (isEdit)
                {
                    // EDIT
                        result = _settingManager.DeleteNoProductiveReasonLanguages(model.ReasonId, dbHelper);
                        if (result == GlobalErrors.Success)
                        {
                            result = _settingManager.SaveNoProductiveReasonLanguage(model, dbHelper);
                        }
                }
                else
                {
                    // NEW
                        result = _settingManager.SaveNoProductiveReasonLanguage(model, dbHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetComplainTypeList(ref SharedTableResult<ComplainTypeModel> complainTypeList)
        {
            try
            {
                return _settingManager.GetComplainTypeList(ref complainTypeList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                complainTypeList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors ModifyComplainType(ComplainTypeModel model)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                bool isEdit = false;
                if (model.ComplainTypeId <= 0)
                {
                    model.ComplainTypeId = _settingManager.GetMaxId("ComplainTypeId", "ComplainType", null);
                }
                else
                {
                    isEdit = true;
                }
                if (model.ComplainTypeId == -1)
                {
                    return GlobalErrors.Error;
                }
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                if (isEdit)
                {
                    // EDIT
                    result = _settingManager.DeleteComplainType(model.ComplainTypeId, dbHelper);
                    if (result == GlobalErrors.Success)
                    {
                        result = _settingManager.SaveComplainType(model, dbHelper);
                    }
                }
                else
                {
                    // NEW
                    result = _settingManager.SaveComplainType(model, dbHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
    }
}