﻿using Newtonsoft.Json;
using Sonic.Web.Core.Setup;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Models;
using Sonic.Web.Model;
using System;
using System.Net.NetworkInformation;
using System.Reflection;

namespace Sonic.Web.Service
{
    public class SetupService
    {
        public static bool IsSettedUp()
        {
            var encData = string.Empty;
            try
            {
                //if (IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() == "incube.com")
                //    return true;

                var result = SetupManager.GetSystemSettings(ref encData);
                var info = JsonConvert.DeserializeObject<SiteInfoModel>(EncryptionManager.Instance.DecryptData(encData));

                if (info == null || string.IsNullOrEmpty(info.CustomerKey))
                {
                    return false;
                }

                return true;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
    }
}