﻿using ClosedXML.Excel;
using OfficeOpenXml.Style;
using System.Linq;
using Sonic.Web.Resources;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Reflection;
using System.IO;
using Microsoft.AspNetCore.Hosting;
using Sonic.Web.Model.AutoService;
using System.Collections.Generic;
using OfficeOpenXml.FormulaParsing.Excel.Functions.DateTime;
using DinkToPdf.Contracts;

namespace Sonic.Web.Service
{
    public class SharedMethod
    {
        private readonly IRequestRepository _requestRepository;
        private readonly EmployeeManager _employeeManager;
        private IWebHostEnvironment _hostEnvironment;
        private ConfigurationManager _configurationManager;

        public SharedMethod(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _employeeManager = new EmployeeManager(requestRepository);
            _configurationManager = new ConfigurationManager(requestRepository);
        }
        public GlobalErrors ReplaceDynamicQueryParameters(ref string query)
        {
            try
            {
                if (query.Contains(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInLanguageId.ToString().ToLower()))
                {
                    query = query.Replace(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInLanguageId.ToString().ToLower(), _requestRepository.LanguageId.ToString());
                }
                if (query.Contains(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInEmployeeId.ToString().ToLower()))
                {
                    query = query.Replace(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInEmployeeId.ToString().ToLower(), _requestRepository.CurrentOperator.EmployeeId.ToString());
                }
                if (query.Contains(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInOrganizationAccess.ToString().ToLower()))
                {
                    query = query.Replace(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInOrganizationAccess.ToString().ToLower(), _requestRepository.CurrentOperator.OrganizationAccess.ToString());
                }
                if (query.Contains(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInDivisionAccess.ToString().ToLower()))
                {
                    query = query.Replace(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInDivisionAccess.ToString().ToLower(), _requestRepository.CurrentOperator.DivisionAccess.ToString());
                }
                if (query.Contains(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParSupervisorAccess.ToString().ToLower()))
                {
                    query = query.Replace(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParSupervisorAccess.ToString().ToLower(), _employeeManager.GetSupervisorAccess());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors ReplaceReportScheduleParameters(ref string query , EmployeeModel employee , int languageId, int numberOfDigits, int numberOfStockDigits , int EndOfDayEmployeeId)
        {
            try
            {
                Dictionary<String, String> Parameters = new Dictionary<string, string>();

                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParLanguage.ToString(), languageId.ToString());
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParUserID.ToString(), employee.EmployeeId.ToString());
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.StockDigitFormat.ToString(), numberOfStockDigits.ToString());
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.DigitFormat.ToString(), numberOfDigits.ToString());
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParEmployeeSupervisor.ToString(), _employeeManager.GetSupervisorAccessForReport(employee.EmployeeTypeId, employee.EmployeeId).ToString());

                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgWarehouse.ToString(), employee.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgVehicle.ToString(), employee.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgTerritory.ToString(), employee.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgDivision.ToString(), employee.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgEmployee.ToString(), employee.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgAccount.ToString(), employee.OrganizationAccess);

                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrgOrganization.ToString(), employee.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParCustomVehicle.ToString(), _employeeManager.GetVehiclesUnderEmployeeAccess());
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParOrganization.ToString(), employee.OrganizationAccess);
                Parameters.Add(DynamicReportConstants.ParameterIdentifier + DynamicReportConstants.ParEndOfDayEmployee.ToString(), EndOfDayEmployeeId.ToString());


                foreach (KeyValuePair<string, string> entery in Parameters)
                {
                    if (entery.Key.ToString() == "@Organization_Custom_Vehicle")
                    {
                        if (query.Contains(entery.Key.ToString()))
                        {

                        }
                    }

                    query = query.Replace(entery.Key.ToString(), entery.Value.ToString());
                    query = query.Replace(entery.Key.ToString().ToLower(), entery.Value.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors GetPeriodTime(ref DateTime startOfPeriod, ref DateTime endOfPeriod, int PeriodTypeId , DateTime ActualStart, DateTime ActualEnd)
        {
            try
            {
                DateTime currentDate = DateTime.Now;

                switch (PeriodTypeId)
                {
                    case (int)ReportSchedulePeriodTypes.Daily:
                        startOfPeriod = currentDate.Date.AddHours(0).AddMinutes(0).AddSeconds(0);
                        endOfPeriod = currentDate.Date.AddHours(23).AddMinutes(59).AddSeconds(59);
                        break;

                    case (int)ReportSchedulePeriodTypes.Weekly:
                        DateTime startOfWeek = currentDate.AddDays(-(int)currentDate.DayOfWeek);
                        DateTime endOfWeek = startOfWeek.AddDays(6);
                        startOfPeriod = startOfWeek.Date.AddHours(0).AddMinutes(0).AddSeconds(0);
                        endOfPeriod = endOfWeek.Date.AddHours(23).AddMinutes(59).AddSeconds(59);
                        break;

                    case (int)ReportSchedulePeriodTypes.Monthly:
                        DateTime firstDayOfMonth = new DateTime(currentDate.Year, currentDate.Month, 1);
                        DateTime lastDayOfMonth = firstDayOfMonth.AddMonths(1).AddDays(-1);
                        startOfPeriod = firstDayOfMonth.Date.AddHours(0).AddMinutes(0).AddSeconds(0);
                        endOfPeriod = lastDayOfMonth.Date.AddHours(23).AddMinutes(59).AddSeconds(59);
                        break;

                    case (int)ReportSchedulePeriodTypes.Yearly:
                        startOfPeriod = new DateTime(currentDate.Year, 1, 1).Date.AddHours(0).AddMinutes(0).AddSeconds(0);
                        endOfPeriod = new DateTime(currentDate.Year, 12, 31).Date.AddHours(23).AddMinutes(59).AddSeconds(59);
                        break;

                    case (int)ReportSchedulePeriodTypes.Quarter:
                        int quarter = (currentDate.Month - 1) / 3 + 1;
                        int startQuarterMonth = (quarter - 1) * 3 + 1;
                        int endQuarterMonth = quarter * 3;
                        startOfPeriod = new DateTime(currentDate.Year, startQuarterMonth, 1).Date.AddHours(0).AddMinutes(0).AddSeconds(0);
                        endOfPeriod = new DateTime(currentDate.Year, endQuarterMonth, DateTime.DaysInMonth(currentDate.Year, endQuarterMonth)).Date.AddHours(23).AddMinutes(59).AddSeconds(59);
                        break;

                    case (int)ReportSchedulePeriodTypes.EndOfDaySubmission:
                        startOfPeriod = ActualStart;
                        endOfPeriod = ActualEnd;
                        break;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors GetReportScheduleNextRunTime(ReportScheduleModel reportSchedule)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DateTime currentDate = DateTime.Now;
                DateTime eod = DateTime.MinValue;
                DateTime sod = DateTime.MinValue;
                DateTime CertianTimeRun = DateTime.MinValue;

                dynamic keyValue = null;
                result = _configurationManager.GetConfigurationValueFromDB("RouteVisitStartDay", ref keyValue);
                if (result != GlobalErrors.Success || keyValue == null || string.IsNullOrEmpty(keyValue))
                {
                    return GlobalErrors.Error;
                }

                int startWeekDay = Convert.ToInt32(keyValue) - 1;

                result = _configurationManager.GetCertianTimeRunning(ref CertianTimeRun);

                switch ((ReportSchedulePeriodTypes)reportSchedule.PeriodTypeId)
                {
                    case ReportSchedulePeriodTypes.Daily:
                        sod = DateTime.Now.Date;
                        eod = sod;

                        if (CertianTimeRun != DateTime.MinValue && currentDate.TimeOfDay >= CertianTimeRun.TimeOfDay)
                        {
                            eod = eod.AddDays(1);
                        }
                        else if (reportSchedule.SendAtFirstDayOfNextPeriod && eod == sod)
                        {
                            eod = eod.AddDays(1);
                        }
                        reportSchedule.TimeToRun = eod;
                        break;

                    case ReportSchedulePeriodTypes.Weekly:
                        int daysUntilStartWeekDay = (startWeekDay - (int)currentDate.DayOfWeek + 7) % 7;
                        if (daysUntilStartWeekDay == 0 && currentDate.TimeOfDay > new TimeSpan(15))
                        {
                            daysUntilStartWeekDay = 7;
                        }
                        DateTime nextStartOfWeek = currentDate.Date.AddDays(daysUntilStartWeekDay);
                        if (reportSchedule.SendAtFirstDayOfNextPeriod)
                        {
                            nextStartOfWeek = nextStartOfWeek.AddDays(1);
                        }
                        reportSchedule.TimeToRun = nextStartOfWeek;
                        break;

                    case ReportSchedulePeriodTypes.Monthly:
                        sod = new DateTime(DateTime.Now.Year, DateTime.Now.Month, 1);
                        eod = reportSchedule.SendAtFirstDayOfNextPeriod ? sod.AddMonths(1) : sod.AddMonths(1).AddDays(-1);
                        reportSchedule.TimeToRun = eod;
                        break;

                    case ReportSchedulePeriodTypes.Yearly:
                        sod = new DateTime(DateTime.Now.Year, 1, 1);
                        eod = reportSchedule.SendAtFirstDayOfNextPeriod ? sod.AddYears(1) : sod.AddYears(1).AddDays(-1);
                        reportSchedule.TimeToRun = eod;
                        break;

                    case ReportSchedulePeriodTypes.Quarter:
                        int currentMonth = DateTime.Now.Month;
                        int quarterId = (currentMonth - 1) / 3 * 3 + 1; // Calculate the quarter
                        sod = new DateTime(DateTime.Now.Year, quarterId, 1);
                        eod = reportSchedule.SendAtFirstDayOfNextPeriod ? sod.AddMonths(3) : sod.AddMonths(3).AddDays(-1);
                        reportSchedule.TimeToRun = eod;
                        break;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(
                    MethodBase.GetCurrentMethod().DeclaringType.FullName,
                    System.Reflection.MethodBase.GetCurrentMethod().Name,
                    ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        #region [Export METHOD]
        public XLWorkbook ExportData(ExportModel export)
        {
            try
            {              
                    var workbook = new XLWorkbook();
                    var columns = export.ExportColumns;
                    var worksheet = workbook.Worksheets.Add(export.TableName);

                    // Set headers
                    var currentRow = 1;
                    var currentColumn = 1;
                    foreach (var column in columns)
                    {
                        var cell = worksheet.Cell(currentRow, currentColumn);
                        cell.SetValue(ResourcesManager.TranslateKey(column.Title, _requestRepository.LanguageId));
                        cell.Style.Font.Bold = true;
                        currentColumn++;
                    }

                    // Set the data
                    currentRow++;
                    foreach (var Data in export.Data)
                    {
                        currentColumn = 1;
                        foreach (var column in columns)
                        {
                            var columnKey = column.Key.ToLower(); // Convert column key to lowercase
                            var columnValue = GetColumnValue(Data, columnKey);
                            worksheet.Cell(currentRow, currentColumn).SetDataType(XLDataType.Text).SetValue(columnValue);
                            currentColumn++;
                        }
                        currentRow++;
                    }

                    // Set styling for columns
                    for (int i = 1; i <= columns.Count; i++)
                    {
                        var column = worksheet.Column(i);
                        column.Width = 19;
                        column.Style.Alignment.WrapText = true;
                        column.Style.Alignment.Vertical = (XLAlignmentVerticalValues)ExcelVerticalAlignment.Center;
                    }

                    return workbook;                               
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }
        private string GetColumnValue(object data, string columnName)
        {
            var property = data.GetType().GetProperties()
        .FirstOrDefault(p => p.Name.ToLower() == columnName); // Case-insensitive comparison
            if (property != null)
            {
                var value = property.GetValue(data);
                if (value != null)
                {
                    return value.ToString();
                }
            }
            return string.Empty;
        }
        public GlobalErrors PrepareCustomHeader(ref string htmlContent, ref string headerPath)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                const string HEADER_START = "<!-- HeaderStart -->";
                const string HEADER_END = "<!-- HeaderEnd -->";
                //const string FOOTER_START = "<!-- FooterStart -->";
                //const string FOOTER_END = "<!-- FooterEnd -->";

                string reportHeaderName = _requestRepository.SessionId.Replace("-", "_") + "_" + _requestRepository.CurrentOperator.EmployeeId + ".html";
                string rootPath = _hostEnvironment.ContentRootPath;
                string copyOfHTMLContent = htmlContent;

                if (htmlContent.IndexOf(HEADER_START) > 0 && htmlContent.IndexOf(HEADER_END) > 0)
                {
                    string s = copyOfHTMLContent.Split(HEADER_START)[0];
                    string e = copyOfHTMLContent.Split(HEADER_START)[1].Split(HEADER_END)[1];
                    string header = copyOfHTMLContent.Split(HEADER_START)[1].Split(HEADER_END)[0];
                    htmlContent = s + " " + e;
                    copyOfHTMLContent = htmlContent;
                    headerPath = Path.Combine(rootPath, "PDFUtility", "ReportHeaders");

                    if (!Directory.Exists(headerPath))
                    {
                        Directory.CreateDirectory(headerPath);
                    }

                    headerPath = Path.Combine(headerPath, reportHeaderName);

                    using (FileStream fs = new FileStream(headerPath, FileMode.Create))
                    {
                        using (StreamWriter w = new StreamWriter(fs, System.Text.Encoding.UTF8))
                        {

                            string headerHTML = string.Format(@"<!DOCTYPE html>
                                <html lang='en' xmlns='http:\\www.w3.org/1999/xhtml'>
                                <head>
                                    <meta charset= utf-8'/>
                                    <title></title>
                                    <style>
                                        .header-row {{ padding-left:50px; padding-right:50px; }}

                                        .report-info {{ }}
                                    </style>
                                </head>
                                <body>
                                <div class='header-row'>
                                    <div class='report-info'>{0}</div>
                                </div>
                                </body>
                                </html>", header);

                            w.WriteLine(headerHTML);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion
    }
}
