﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.IO;
using System.Reflection;
using System.Xml;
using InCube.Security;

namespace Sonic.Web.Service
{
    public class SystemConfigService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly DBManager _dBManager;
        public SystemConfigService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _dBManager = new DBManager(requestRepository);
        }
        public static void ReadConfiguration(string rootPath)
        {
            try
            {
                string originalDatasoucePath = Path.Combine(rootPath, "DataSources.xml");
                originalDatasoucePath = originalDatasoucePath.TrimStart("file:\\".ToCharArray());
                string datasource = string.Empty;
                string oldDatasource = string.Empty;
                if (File.Exists(originalDatasoucePath))
                {
                    XmlDocument doc = new XmlDocument();
                    XmlTextReader reader = new XmlTextReader(originalDatasoucePath);
                    doc.Load(reader);
                    //Read System Environement
                    if (doc.SelectSingleNode("Connections/SystemEnvironment") != null)
                    {
                        LocalUtilities.SystemEnvironment = (SystemEnvironment)int.Parse(doc.SelectSingleNode("Connections/SystemEnvironment").InnerText.ToString().Trim());
                    }
                    else
                    {
                        LocalUtilities.SystemEnvironment = SystemEnvironment.SQL;
                    }
                    //Read Token Expiry Hours
                    if (doc.SelectSingleNode("Connections/TokenExpiryHours") != null)
                    {
                        LocalUtilities.TokenExpiryHours = int.Parse(doc.SelectSingleNode("Connections/TokenExpiryHours").InnerText.ToString().Trim());
                    }
                    else
                    {
                        LocalUtilities.TokenExpiryHours = 12;
                    }
                    //Read Dashboard/Report URL
                    if (doc.SelectSingleNode("Connections/DashboardURL") != null)
                    {

                        LocalUtilities.DashboardURL = new Uri(new Uri(doc.SelectSingleNode("Connections/DashboardURL").InnerText.ToString()),
                                                        "Main/Dashboard").ToString();
                        LocalUtilities.ATReportURL = new Uri(new Uri(doc.SelectSingleNode("Connections/DashboardURL").InnerText.ToString()),
                                                        "Main/Report").ToString();
                    }
                    //Read Grid Report URL
                    LocalUtilities.GridReportURL = string.Empty;
                    if (doc.SelectSingleNode("Connections/GridReportURL") != null)
                    {
                        if (doc.SelectSingleNode("Connections/GridReportURL").InnerText != null && !string.IsNullOrEmpty(doc.SelectSingleNode("Connections/GridReportURL").InnerText.ToString().Trim()))
                        {
                            LocalUtilities.GridReportURL = new Uri(doc.SelectSingleNode("Connections/GridReportURL").InnerText.ToString().Trim() + "API/Report/ShowGrid?id=").ToString();
                        }
                    }
                    //Read Call Center URL
                    if (doc.SelectSingleNode("Connections/CallCenterURL") != null)
                    {
                        LocalUtilities.CallCenterURL = doc.SelectSingleNode("Connections/CallCenterURL").InnerText.ToString().Trim();
                    }
                    //Read Customer Logo For Auto Reports
                    if (doc.SelectSingleNode("Connections/CustomerLogoPath") != null)
                    {
                        LocalUtilities.CustomerLogoPath = doc.SelectSingleNode("Connections/CustomerLogoPath").InnerText.ToString().Trim();
                    }
                    //Read Customer App Related Info
                    if (doc.SelectSingleNode("Connections/CustomerAppNotificationID") != null)
                    {
                        LocalUtilities.CustomerAppNotificationID = doc.SelectSingleNode("Connections/CustomerAppNotificationID").InnerText.ToString().Trim();
                    }
                    if (doc.SelectSingleNode("Connections/CustomerAppNotificationSenderID") != null)
                    {
                        LocalUtilities.CustomerAppNotificationSenderID = doc.SelectSingleNode("Connections/CustomerAppNotificationSenderID").InnerText.ToString().Trim();
                    }
                    if (doc.SelectSingleNode("Connections/CustomerAppServicePath") != null)
                    {
                        LocalUtilities.CustomerAppServicePath = doc.SelectSingleNode("Connections/CustomerAppServicePath").InnerText.ToString().Trim();
                    }
                    //Read Sonic FCM ID
                    if (doc.SelectSingleNode("Connections/SonicFONotificationID") != null)
                    {
                        LocalUtilities.SonicFONotificationID = doc.SelectSingleNode("Connections/SonicFONotificationID").InnerText.ToString().Trim();
                    }
                    if (doc.SelectSingleNode("Connections/SonicFONotificationSenderID") != null)
                    {
                        LocalUtilities.SonicFONotificationSenderID = doc.SelectSingleNode("Connections/SonicFONotificationSenderID").InnerText.ToString().Trim();
                    }
                    //Read Sonic Web Path used for Customer App Services
                    if (doc.SelectSingleNode("Connections/SonicWebPath") != null)
                    {
                        LocalUtilities.SonicWebPath = doc.SelectSingleNode("Connections/SonicWebPath").InnerText.ToString().Trim();
                    }
                    //Read Sonic CRM Path
                    if (doc.SelectSingleNode("Connections/CRMPath") != null)
                    {
                        LocalUtilities.CRMAppPath = doc.SelectSingleNode("Connections/CRMPath").InnerText.ToString().Trim();
                    }
                    //Read Proof Path From Sonic FO Android
                    if (doc.SelectSingleNode("Connections/ProofImagesSourcePath") != null)
                    {
                        LocalUtilities.ProofImagesSourcePath = doc.SelectSingleNode("Connections/ProofImagesSourcePath").InnerText.ToString().Trim();
                    }
                    if (doc.SelectSingleNode("Connections/ATMSettlementImagesSourcePath") != null)
                    {
                        LocalUtilities.ATMSettlementImagesSourcePath = doc.SelectSingleNode("Connections/ATMSettlementImagesSourcePath").InnerText.ToString().Trim();
                    }
                    if (doc.SelectSingleNode("Connections/ExpenseSettlementImagesSourcePath") != null)
                    {
                        LocalUtilities.ExpenseSettlementImagesSourcePath = doc.SelectSingleNode("Connections/ExpenseSettlementImagesSourcePath").InnerText.ToString().Trim();
                    }
                    if (doc.SelectSingleNode("Connections/FOImagesFolderPath") != null)
                    {
                        LocalUtilities.FOImagesFolderPath = doc.SelectSingleNode("Connections/FOImagesFolderPath").InnerText.ToString().Trim();
                    }
                    //Read Outlet Path From Sonic FO Android
                    if (doc.SelectSingleNode("Connections/OutletImagesSourcePath") != null)
                    {
                        LocalUtilities.OutletImagesSourcePath = doc.SelectSingleNode("Connections/OutletImagesSourcePath").InnerText.ToString().Trim();
                    }
                    //Read Session Expiry Hours
                    if (doc.SelectSingleNode("Connections/SessionExpiryHours") != null)
                    {
                        LocalUtilities.SessionExpiryHours = int.Parse(doc.SelectSingleNode("Connections/SessionExpiryHours").InnerText.ToString().Trim());
                    }
                    else
                    {
                        LocalUtilities.SessionExpiryHours = 12;
                    }
                    //Read FO image URL
                    LocalUtilities.FOImagesURL = string.Empty;
                    if (doc.SelectSingleNode("Connections/FOImagesURL") != null)
                    {
                        if (doc.SelectSingleNode("Connections/FOImagesURL").InnerText != null && !string.IsNullOrEmpty(doc.SelectSingleNode("Connections/FOImagesURL").InnerText.ToString().Trim()))
                        {
                            LocalUtilities.FOImagesURL = new Uri(doc.SelectSingleNode("Connections/FOImagesURL").InnerText.ToString().Trim()).ToString();
                        }
                    }
                    //Read Printer Name
                    if (doc.SelectSingleNode("Connections/PrinterName") != null)
                    {
                        LocalUtilities.PrinterName = doc.SelectSingleNode("Connections/PrinterName").InnerText.ToString().Trim();
                    }
                    else
                    {
                        LocalUtilities.PrinterName = string.Empty;
                    }
                    //Read Thermal Printer Name
                    if (doc.SelectSingleNode("Connections/ThermalPrinterName") != null)
                    {
                        LocalUtilities.ThermalPrinterName = doc.SelectSingleNode("Connections/ThermalPrinterName").InnerText.ToString().Trim();
                    }
                    else
                    {
                        LocalUtilities.ThermalPrinterName = string.Empty;
                    }
                    //Read Unipall TT Neede URLs
                    if (doc.SelectSingleNode("Connections/ITrackServiceURL") != null)
                    {
                        LocalUtilities.ITrackServiceURL = doc.SelectSingleNode("Connections/ITrackServiceURL").InnerText.ToString().Trim();
                    }
                    if (doc.SelectSingleNode("Connections/AutoSendTransaction") != null)
                    {
                        LocalUtilities.AutoSendTransaction = doc.SelectSingleNode("Connections/AutoSendTransaction").InnerText.ToString().Trim().ToLower() == "true";
                    }
                    //Read Grid Report URL
                    LocalUtilities.GridReportURL = string.Empty;
                    if (doc.SelectSingleNode("Connections/GridReportURL") != null)
                    {
                        if (doc.SelectSingleNode("Connections/GridReportURL").InnerText != null && !string.IsNullOrEmpty(doc.SelectSingleNode("Connections/GridReportURL").InnerText.ToString().Trim()))
                        {
                            LocalUtilities.GridReportURL = new Uri(doc.SelectSingleNode("Connections/GridReportURL").InnerText.ToString().Trim() + "API/Report/ShowGrid?id=").ToString();
                        }
                    }
                    //Read Used Default Folders Path
                    LocalUtilities.PrepareDefaultFolderPath(rootPath);
                    //2. Read ConnectionString
                    string connStr = string.Empty;
                    GlobalErrors err = ReadConnectionString(doc, reader, ref connStr);
                    if (err != GlobalErrors.Success || string.IsNullOrEmpty(connStr))
                    {
                        return;
                    }
                    LocalUtilities.ConnectionString = connStr;
                    Sonic.Web.Licensing.Core.LicensingLocalUtilities.ConnectionString = LocalUtilities.ConnectionString;
                    Sonic.Web.Licensing.Core.LicensingLocalUtilities.SystemEnvironment = (Sonic.Web.Licensing.Enums.SystemEnvironment)(LocalUtilities.SystemEnvironment.GetHashCode());

                }
                else
                {
                    return;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
       
        private static string GetConnectionStr(string Conn)
        {
            string decryptedConnection = EncryptionManager.Instance.DecryptPassword(Conn);
            if (decryptedConnection == null || decryptedConnection=="-1") return Conn;
            else return decryptedConnection;
        }

        private static GlobalErrors ReadConnectionString(XmlDocument doc, XmlTextReader reader, ref string connectionString)
        {
            try
            {
                string oldDatasource = string.Empty;
                string datasource = string.Empty;
                string originalDatasoucePath = Path.Combine(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase), "DataSources.xml");
                originalDatasoucePath = originalDatasoucePath.TrimStart("file:\\".ToCharArray());
                if (doc.SelectSingleNode("Connections/Connection[Name = 'InCube']/Data") != null)
                {
                    oldDatasource = doc.SelectSingleNode("Connections/Connection[Name = 'InCube']/Data").InnerText;
                    datasource = GetConnectionStr(oldDatasource);
                    if (datasource != null && !string.IsNullOrEmpty(datasource.Trim()) &&
                        (System.Net.NetworkInformation.IPGlobalProperties.GetIPGlobalProperties().DomainName == null
                        || System.Net.NetworkInformation.IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() != LocalUtilities.DomainName))
                    {
                        string encryptedDatasource = EncryptionManager.Instance.EncryptPassword(datasource);
                        if (encryptedDatasource != oldDatasource)
                        {
                            doc.SelectSingleNode("Connections/Connection[Name = 'InCube']/Data").InnerText = encryptedDatasource;
                            reader.Close();
                            doc.Save(originalDatasoucePath);
                        }
                    }
                    else
                    {
                        reader.Close();
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }
                if (datasource != null && !string.IsNullOrEmpty(datasource.Trim()))
                {
                    connectionString = datasource;
                    return GlobalErrors.Success;
                }
                else
                    return GlobalErrors.Error;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public CachedGeneralData GetCachedGeneralData()
        {
            try
            {
                CachedGeneralData generalData = new CachedGeneralData();
                generalData.DatabaseVersion = _dBManager.ReadDatabaseVersion();
                generalData.AssemblyVersionNumber = LocalUtilities.AppVersion;
                generalData.WebApplication = LocalUtilities.WebApplication;
                return generalData;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }
    }
}