﻿using Sonic.Web.Core;
using Sonic.Web.Core.Validation;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;

namespace Sonic.Web.Service
{
    public class ValidationService
    {

        private readonly IRequestRepository _requestRepository;
        private readonly PromotionManager _promotionManager;
        private readonly TransactionManager _transactionManager;
        private readonly CustomerManager _customerManager;
        private readonly OrderManager _orderManager;
        private readonly AccountManager _accountManager;
        private readonly DocumentSequenceManager _documentSequenceManager;
        private readonly ValidationManager _validationManager;
        public ValidationService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _promotionManager = new PromotionManager(_requestRepository);
            _transactionManager = new TransactionManager(_requestRepository);
            _customerManager = new CustomerManager(_requestRepository);
            _orderManager = new OrderManager(_requestRepository);
            _accountManager = new AccountManager(_requestRepository);
            _documentSequenceManager = new DocumentSequenceManager(_requestRepository);
            _validationManager = new ValidationManager(_requestRepository);
        }
        public GlobalErrors CheckoutPromotions(TransactionCommonData transactionCommonData, ref List<Promotion> customerPromotions)
        {
            var result = GlobalErrors.NotInitialized;

            try
            {
                TransactionCommonData transationCommonData = new TransactionCommonData();
                transationCommonData.ItemFormProcessMode = ItemFormProcessMode.Orders;
                transationCommonData.SoldItems = transactionCommonData.SoldItems;
                transationCommonData.NetTotal = transactionCommonData.NetTotal;
                transationCommonData.GrossTotal = transactionCommonData.GrossTotal;
                transationCommonData.OrderStatus = OrderStatus.New;
                transationCommonData.Outlet = transactionCommonData.Outlet;

                if (_requestRepository.Configurations.AllowPromotion)
                    result = CheckPromotions(transationCommonData, ref customerPromotions, false);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors CheckPromotions(TransactionCommonData transationCommonData, ref List<Promotion> customerPromotions, bool exculdeBenifitSelectionPromotion)
        {
            bool hasWholeSalesTargetPromo = false;
            bool hasDynamicTargetSalesAmountPromo = false;
            bool isPromotionSelectionForEcho = false;
            bool hasLoyalityPromotion = false;
            bool hasNoSalesCertainPeriod = false;
            return CheckPromotions(transationCommonData, ref customerPromotions, exculdeBenifitSelectionPromotion, ref hasWholeSalesTargetPromo, ref hasDynamicTargetSalesAmountPromo, false, false, false, ref isPromotionSelectionForEcho, ref hasLoyalityPromotion, false,ref hasNoSalesCertainPeriod);
        }
        public GlobalErrors CheckPromotions(TransactionCommonData transationCommonData, ref List<Promotion> customerPromotions, bool exculdeBenifitSelectionPromotion, ref bool hasWholeSalesTargetPromo, ref bool hasDynamicTargetSalesAmountPromo, bool fromCustomerApp, bool justAchievement, bool isEcho, ref bool isPromotionSelectionForEcho, ref bool hasLoyalityPromotion, bool echoShowAchivement,ref bool hasNoSalesCertainPeriod)
        {
            bool recalculatePromotions = true;
            var result = GlobalErrors.NotInitialized;
            List<int> promotionsToBeRemoved = new List<int>();
            int quanityProductDiscountCount = 0;
            int discountOrFreeItemsProductDiscountCount = 0;   
            
            try
            {
                string transactionID = string.Empty;
                transationCommonData.CalculatedAchievemnetDiscount = 0;
                int _numberOfWholeSaleContract = 0;
                bool excludeTargetPromotions = true;
                transationCommonData.UnSatisfiedTargetPromotions = new List<int>();
                transationCommonData.UnSatisfiedDynamicAmountPromotions = new List<int>();
                List<Promotion> relatedToTargetPromotions = new List<Promotion>();
                List<Promotion> afterPeriodPromotions = new List<Promotion>();
                if ((transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Delivery && !transationCommonData.IsThereAnyProductDiscountDefined) || (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && !_requestRepository.Configurations.RecalculatePromotionInDelivery) || (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && _requestRepository.Configurations.RecalculatePromotionInDelivery && !_requestRepository.Configurations.ConsiderCurrentPromotionsInDelivery))
                        recalculatePromotions = false;
                if ((transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Delivery || isEcho) || transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                {
                    excludeTargetPromotions = false;
                }
                if (_requestRepository.Configurations.EnableSalesDistributionChannel && !string.IsNullOrEmpty(transationCommonData.OrderId) &&
                    (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Delivery || transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)) 
                {
                    int sdcId = -1;
                    result = _orderManager.GetOrderSDC(transationCommonData.OrderId, transationCommonData.CustomerId, transationCommonData.OutletId, ref sdcId);
                    if (result != GlobalErrors.Success) return GlobalErrors.Error;

                    transationCommonData.SDCId = sdcId;
                }

                if (!recalculatePromotions)
                {
                    // get order promtion and current valid promotion
                    customerPromotions = _promotionManager.FillOrderPromotions(transationCommonData, fromCustomerApp, justAchievement, transationCommonData.SDCId);
                    if (customerPromotions.Any(x => x.NoOfInvoices > 0))
                    {
                        hasNoSalesCertainPeriod = true;
                    }
                }
                else
                    // get current valid promotion
                    customerPromotions = _promotionManager.FillCustomerPromotions(transationCommonData.CustomerId, transationCommonData.OutletId, exculdeBenifitSelectionPromotion, excludeTargetPromotions, echoShowAchivement, transationCommonData.PromotionLevelId, transationCommonData.SDCId , transationCommonData.OnlyProductDiscount, transationCommonData.ItemFormProcessMode, transationCommonData.DivisionId,transationCommonData.IncludeInActive, transationCommonData.CustomerOrganizationId);

                #region[Filter customer promotions based on SalesMode]
                if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Delivery || transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery) 
                {
                    int salesMode = -1;
                    result =  _orderManager.GetOrderSalesMode(transationCommonData.OrderId, transationCommonData.CustomerId, transationCommonData.OutletId, ref salesMode);
                    if (result != GlobalErrors.Success) return GlobalErrors.Error;
                    transationCommonData.SalesMode = salesMode;
                }
                int promotionsSalesMode = transationCommonData.SalesMode == CustomerTypes.CashCustomer.GetHashCode() ? CustomerTypes.CashCustomer.GetHashCode() : CustomerTypes.CreditCustomer.GetHashCode();
                customerPromotions = customerPromotions.Where(promotion => promotion.SalesMode.Split(',').Select(str => int.Parse(str)).Contains(promotionsSalesMode)).ToList();
                #endregion

                customerPromotions = _promotionManager.CheckifThereMoreThanOneTargetPromotion(customerPromotions);
               
                relatedToTargetPromotions = customerPromotions.Where(a => a.RelatedToTarget && !a.AppliedAfterPeriod).ToList();
                if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                {
                    // exclude after period promotions for partial delivered orders . 
                    customerPromotions.RemoveAll(a => a.RelatedToTarget && a.AppliedAfterPeriod);
                }
                else
                {
                    afterPeriodPromotions = customerPromotions.Where(a => a.RelatedToTarget && a.AppliedAfterPeriod).ToList();
                    customerPromotions.RemoveAll(i => afterPeriodPromotions.Contains(i));
                }

                customerPromotions.RemoveAll(i => relatedToTargetPromotions.Contains(i));
                //if ((!recalculatePromotions) && relatedToTargetPromotions != null && relatedToTargetPromotions.Count > 0)
                //    transationCommonData.IsDeliveryHasRelatedToTarget = true;
                if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Orders){
                    customerPromotions.RemoveAll(i => i.IsLoyaltyPromotion && i.NoOfInvoices > 0);
                }
                transactionID = string.Empty;
                if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                {
                    transactionID = _promotionManager.GetInvoiceID(transationCommonData.OrderId, transationCommonData.CustomerId, transationCommonData.OutletId, transationCommonData.DivisionId);
                }
                if (customerPromotions.Count > 0)
                {
                    foreach (Promotion promotion in customerPromotions)
                    {
                        PromotionLoyaltyStatus promotionLoyaltyStatus = new PromotionLoyaltyStatus();
                        if (!promotion.RelatedToTarget)
                        {
                            if (promotion.PromotionType == PromotionTypes.TargetPromotion || promotion.PromotionType == PromotionTypes.DynamicTargetPromotion)
                            {
                                promotion.CustomerTargets = _promotionManager.GetCustomerTargetData(transationCommonData.CustomerId, transationCommonData.OutletId, promotion.PromotionId, transactionID, promotion.PromotionType, promotion.StartDate, promotion.EndDate, promotion.PromotionLevel);
                            }
                            if (promotion.IsWholeSaleContract)
                                hasWholeSalesTargetPromo = true;
                            if (promotion.IsDynamicSalesAmount)
                                hasDynamicTargetSalesAmountPromo = true;
                            promotion.IsTaken = false;
                            if (isEcho)
                            {
                                transationCommonData.DontCheckLoyalty = true;
                                transationCommonData.DontCheckLastInvoice = true;
                            }
                            promotion.EchoShowAchinment = echoShowAchivement;
                            if (promotion.IsLoyaltyPromotion)
                            {
                                if (promotion.IsNeedToCalculateLoyalty)
                                    promotion.IsSatisfied = _promotionManager.IsPromotionInputsSatisfied(promotion, transationCommonData, ref _numberOfWholeSaleContract);
                            }
                            else
                            {
                                promotion.IsSatisfied = _promotionManager.IsPromotionInputsSatisfied(promotion, transationCommonData, ref _numberOfWholeSaleContract);

                            }
                            // recalculatePromotions: partial and recalculate true and consider false ,,, or full delivery,,, then get currenct promotion join BH still valid
                            if (_validationManager.CheckIfOrderFromEchoAndSelectionBenifit(transationCommonData, null) && promotion.IsSatisfied && !recalculatePromotions)
                            {
                                result = _promotionManager.GetSatisfiedPromotionBenefitSelectionFromEcho(promotion, transationCommonData);

                            }

                            if (promotion.IsPromotionSelectionForEcho)
                            {
                                isPromotionSelectionForEcho = true;
                            }
                            if (transationCommonData.LastInvoicePromotionsList != null && transationCommonData.LastInvoicePromotionsList.Count > 0)
                                if (promotion.IsWholeSaleContract && transationCommonData.LastInvoicePromotionsList.Contains(promotion.PromotionId) && !promotion.IsSatisfied)
                                {
                                    transationCommonData.UnSatisfiedTargetPromotions.Add(promotion.PromotionId);
                                }
                            if (promotion.IsDynamicSalesAmount && transationCommonData.LastInvoicePromotionsList.Contains(promotion.PromotionId) && !promotion.IsSatisfied)
                            {
                                transationCommonData.UnSatisfiedDynamicAmountPromotions.Add(promotion.PromotionId);
                            }

                            if (promotion.PromotionType == PromotionTypes.StepsValues)
                            {
                                promotion.IsRepeated = false;
                            }
                            if (promotion.IsSatisfied)
                            {
                                checkForTarget(customerPromotions, promotion, transationCommonData);
                            }
                        }
                    }
                    // when wholeSales promotions and Dynamic sales amount Promotions are not satisfied ,
                    // we need to return it (don't remove it from customerPromotionsList) to let user check last invoice
                    // and to tell the user that these promotions will not be considered as last invoice although he checked it because they are not satisfied
                    customerPromotions.RemoveAll(p => p.PromotionOutputs.Count == 0);
                    if (transationCommonData.DontCheckLastInvoice && transationCommonData.DontCheckLoyalty && !isEcho)
                        customerPromotions.RemoveAll(a => a.IsSatisfied == false && !a.IsWholeSaleContract && !a.IsDynamicSalesAmount && !a.IsLoyaltyPromotion);
                    else
                        customerPromotions.RemoveAll(a => a.IsSatisfied == false);

                    if (((transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Delivery && !transationCommonData.IsThereAnyProductDiscountDefined) || isEcho) && !(_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode() && recalculatePromotions)) // in case of Full Delivery , we just need achievement promotions to be taken , the other promotion will be getten from the original order
                        {
                        if (isEcho)
                        {
                            // it get this promotion in achivement
                            customerPromotions.RemoveAll(a =>
                               a.PromotionType != PromotionTypes.TargetPromotion &&
                               a.PromotionType != PromotionTypes.DynamicTargetPromotion && !a.IsLoyaltyPromotion && a.IsSatisfied);
                        }
                        else
                        {
                            customerPromotions.RemoveAll(a =>
                               a.PromotionType != PromotionTypes.TargetPromotion &&
                               a.PromotionType != PromotionTypes.DynamicTargetPromotion &&
                               a.IsSatisfied &&
                               !a.IsPromotionSelectionForEcho &&
                               !a.IsLoyaltyPromotion
                               && a.NoOfInvoices <= 0
                               );
                            customerPromotions.RemoveAll(a =>
                              !a.IsSatisfied &&
                              a.IsLoyaltyPromotion
                              );
                            if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Orders)
                                customerPromotions.RemoveAll(x => x.IsLoyaltyPromotion);

                        }

                    }
                    customerPromotions = _promotionManager.orderSatisfiedPromotions(customerPromotions);
                }
                #region [Check Related To Target Promotions]
                if (relatedToTargetPromotions.Count > 0)
                {
                    checkRelatedToTargetSatisfiedPromo(relatedToTargetPromotions, transationCommonData);
                    customerPromotions.AddRange(relatedToTargetPromotions.Where(x => x.IsSatisfied));
                }

                #endregion [Check Related To Target Promotions]
                #region [Check After Period Promotions]
                if (afterPeriodPromotions.Count > 0)
                {
                    string promIDs = "";
                    foreach (Promotion p in afterPeriodPromotions)
                    {
                        promIDs = promIDs + p.PromotionId + ",";
                    }
                    promIDs = promIDs.Substring(0, promIDs.Length - 1);
                    List<RelatedToTargetPromotion> afterPerionRelatedPromo = _promotionManager.CheckAfterPeriodPromotion(transationCommonData.CustomerId, transationCommonData.OutletId, transactionID, transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery ? true : false, promIDs);
                    if (afterPerionRelatedPromo != null && afterPerionRelatedPromo.Count > 0)
                    {
                        modifyRelatedToTargetSatisfiedOutputs(afterPeriodPromotions, afterPerionRelatedPromo, transationCommonData);
                    }
                    customerPromotions.AddRange(afterPeriodPromotions.Where(x => x.IsSatisfied));
                }
                #endregion [Check Related To Target Promotions]
                if (transationCommonData.PromotionLevelId == 1)
                {
                    List<int> addedPromotionLevelIDs = new List<int>();
                    
                    transationCommonData.PromotionGroupLevels = new List<PromotionGroupLevelsModel>();
                    PromotionGroupLevelsModel promGroupModel = new PromotionGroupLevelsModel();
                    foreach (Promotion prom in customerPromotions)
                    {
                        if (!addedPromotionLevelIDs.Contains(prom.Sequence))
                        {
                            promGroupModel = new PromotionGroupLevelsModel();
                            promGroupModel.LevelId = prom.Sequence;
                            promGroupModel.promotions = customerPromotions.Where(x => x.Sequence == promGroupModel.LevelId).ToList();
                            transationCommonData.PromotionGroupLevels.Add(promGroupModel);
                            addedPromotionLevelIDs.Add(promGroupModel.LevelId);
                        }
                    }
                    if (transationCommonData.PromotionGroupLevels != null)
                        transationCommonData.PromotionGroupLevels = transationCommonData.PromotionGroupLevels.OrderBy(p => p.LevelId).ToList();
                }
                while (customerPromotions !=null && customerPromotions.Count > 0 && transationCommonData.PromotionLevelId <= _requestRepository.Configurations.PromotionSequenceLevels && customerPromotions.FindAll(x => x.Sequence == transationCommonData.PromotionLevelId).ToList().Count == 0)
                {
                    transationCommonData.PromotionLevelId++;
                }
                customerPromotions.RemoveAll(i => i.Sequence != transationCommonData.PromotionLevelId);
                if (customerPromotions.Where(x => x.IsLoyaltyPromotion).Count() > 0)
                {
                    bool isUploded = false;
                    result = _transactionManager.CheckIfCustomreRouteUploaded(transationCommonData.CustomerId, transationCommonData.OutletId, ref isUploded);
                    if (result == GlobalErrors.Success)
                    {
                        if (isUploded) return GlobalErrors.UploadedRoute;
                    }
                    else return GlobalErrors.Error;
                    hasLoyalityPromotion = true;
                }
                if (customerPromotions != null && customerPromotions.Count > 0)
                {
                    // In case there is only product discount quantity type (level 1) and there is no product discount (qty or free --> level 2) and there is promotion (not product --> level 3) and the first level already taken then the productDiscoyntPromotion level should be 2 and the not product promotion should be appear
                    if (transationCommonData.ProductDiscountFirstLevelList != null && transationCommonData.ProductDiscountFirstLevelList.Count > 0)
                    {
                        customerPromotions.RemoveAll(a => a.IsProductDiscount && transationCommonData.ProductDiscountFirstLevelList.Any(x => x.PromotionId == a.PromotionId));
                        if (customerPromotions.Count(a => a.IsProductDiscount) == 0)
                        {
                            transationCommonData.OnlyProductDiscount = false;
                            transationCommonData.ProductPromotionLevelId = 2;
                        }
                    }

                    if (transationCommonData.OnlyProductDiscount && customerPromotions.FindIndex(x => x.IsProductDiscount) != -1)
                    {
                        customerPromotions.RemoveAll(a => !a.IsProductDiscount);
                        transationCommonData.IsThereAnyProductDiscountDefined = true;
                        if (transationCommonData.LastInvoicePromotionsList == null || (transationCommonData.LastInvoicePromotionsList != null && transationCommonData.LastInvoicePromotionsList.Count ==0))
                        {
                            quanityProductDiscountCount = 0;
                            discountOrFreeItemsProductDiscountCount = 0;

                            foreach (Promotion prom in customerPromotions)
                            {
                                foreach (PromotionOption output in prom.PromotionOutputs)
                                {
                                    if (output.PromotionOptionDetails.Where(x => x.OutputOptionDetailTypeId != PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount).Count() > 0)
                                    {
                                        quanityProductDiscountCount += 1;
                                        break;
                                    }
                                    else if (output.PromotionOptionDetails.Where(x => x.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount).Count() > 0)
                                    {
                                        discountOrFreeItemsProductDiscountCount += 1;
                                        break;
                                    }
                                }
                            }
                        }
                        if (transationCommonData.LastInvoicePromotionsList == null || (transationCommonData.LastInvoicePromotionsList != null && transationCommonData.LastInvoicePromotionsList.Count == 0))
                        {
                            transationCommonData.QuanityProductDiscountCount = quanityProductDiscountCount;
                            transationCommonData.DiscountOrFreeItemsProductDiscountCount = discountOrFreeItemsProductDiscountCount;
                        }
                        foreach (Promotion prom in customerPromotions)
                        {
                            foreach (PromotionOption output in prom.PromotionOutputs)
                            {
                                if (transationCommonData.ProductPromotionLevelId == 1)
                                {   //Level 1
                                    if (output.PromotionOptionDetails.Where(x => x.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount).Count() > 0)
                                    {
                                        if (!promotionsToBeRemoved.Contains(prom.PromotionId))
                                        {
                                            promotionsToBeRemoved.Add(prom.PromotionId);
                                        }

                                    }
                                }
                                else
                                {
                                    //Level 2
                                    if (output.PromotionOptionDetails.Where(x => x.OutputOptionDetailTypeId != PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount).Count() > 0)
                                    {
                                        if (!promotionsToBeRemoved.Contains(prom.PromotionId))
                                        {
                                            promotionsToBeRemoved.Add(prom.PromotionId);
                                        }
                                    }
                                }
                            }
                        }
                        if (promotionsToBeRemoved != null && promotionsToBeRemoved.Count > 0)
                        {
                            if ((transationCommonData.ProductPromotionLevelId == 1 && (transationCommonData.QuanityProductDiscountCount > 0 && transationCommonData.DiscountOrFreeItemsProductDiscountCount > 0)) ||
                                (transationCommonData.ProductPromotionLevelId == 2 && transationCommonData.QuanityProductDiscountCount > 0))
                            {
                                foreach (int promotionID in promotionsToBeRemoved)
                                    customerPromotions.RemoveAll(a => a.PromotionId == promotionID);
                            }
                            else if (transationCommonData.ProductPromotionLevelId == 1 && transationCommonData.QuanityProductDiscountCount == 0 && transationCommonData.DiscountOrFreeItemsProductDiscountCount > 0)
                                transationCommonData.ProductPromotionLevelId = 2;

                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors CheckOrderBundles(TransactionCommonData transationCommonData, ref List<Promotion> orderBundles)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string bundleIds = string.Empty;
            string bundleBenefitIds = string.Empty;
            List<ItemPackModel> benefitDetails = new List<ItemPackModel>();
            string packIds = string.Empty;
            string currentPackIds = string.Empty;
            List<ItemPackModel> items = new List<ItemPackModel>();
            List<Promotion> orderBenefitPromotion = new List<Promotion>();
            List<Promotion> customerBundle = new List<Promotion>();
            List<ItemPackModel> bundlesDetails = new List<ItemPackModel>();
            List<ItemPackModel> AvaliableItemStock = new List<ItemPackModel>();
            List<Promotion> otherBundles = new List<Promotion>();
            List<ItemPackModel> currentBundleDetails= new List<ItemPackModel>();
            int promotionDetailTypeId = -1;

            string promBenefitBundlesFilter = string.Empty;
            try
            {
                result = _orderManager.ExecuteCalculateUsedBundles_SP();
                if (result == GlobalErrors.Success)
                {
                    result = _orderManager.GetOrderPromotionBenefitHistory(transationCommonData, ref orderBenefitPromotion);
                }
                if (result == GlobalErrors.Success)
                {
                    if (orderBenefitPromotion != null && orderBenefitPromotion.Count > 0)
                    {
                        promotionDetailTypeId = orderBenefitPromotion[0].PromotionOptionDetailTypeID;
                    }
                    result = _orderManager.GetCustomerBundles(transationCommonData, promotionDetailTypeId, ref customerBundle);
                    if (result == GlobalErrors.Success)
                    {
                        orderBundles = customerBundle.Concat(orderBenefitPromotion).ToList();
                        if(orderBundles != null && orderBundles.Count > 0)
                        {
                        bundleIds = string.Join(',', orderBundles.Select(x => x.PromotionId).Distinct().ToList());
                        result = _orderManager.GetOrderBundlesDetails(bundleIds, transationCommonData, ref bundlesDetails);
                            if(result != GlobalErrors.Success)
                                return result;
                            else
                            {
                                foreach (Promotion bundle in orderBundles.ToList())
                                {
                                    currentBundleDetails = new List<ItemPackModel>();
                                    currentPackIds = string.Empty;
                                    if (bundlesDetails != null && bundlesDetails.Count > 0)
                                    {
                                        currentBundleDetails = bundlesDetails.Where(x => x.PromotionID == bundle.PromotionId).ToList();
                                        if (currentBundleDetails != null && currentBundleDetails.Count > 0)
                                        {
                                            currentPackIds = string.Join(',', currentBundleDetails.Select(x => x.PackId).Distinct().ToList());
                                            result = _validationManager.GetPackItemsWithPrice(transationCommonData.CustomerId, transationCommonData.OutletId, currentPackIds, ref items, true);
                                            if (result != GlobalErrors.Success)
                                                return result;
                                            int packIdsCount = currentBundleDetails.Select(x => x.PackId).Distinct().ToList().Count;
                                            if (packIdsCount != items.Count())
                                            {
                                                orderBundles.Remove(bundle);
                                                bundlesDetails.RemoveAll(x => x.PromotionID == bundle.PromotionId);
                                            }
                                        }
                                    }
                                }
                                if (bundlesDetails != null && bundlesDetails.Count > 0)
                                    packIds = string.Join(',', bundlesDetails.Select(x => x.PackId).Distinct().ToList());
                            }
                            if (orderBundles != null && orderBundles.Count > 0)
                            {
                                int employeeTypeId = EmployeeManager.GetEmployeeType(transationCommonData.EmployeeId);
                                result = _validationManager.GetBundlesDetailsWarehouseStock(packIds, transationCommonData, ref AvaliableItemStock, employeeTypeId);
                                if (result == GlobalErrors.Success)
                                {
                                    orderBundles.ForEach(B =>
                                    {
                                        B.BundleItems = bundlesDetails.Where(x => x.PromotionID == B.PromotionId).ToList();
                                    });
                                    foreach (Promotion bundle in orderBundles)
                                    {
                                        //bundle.BundleItems = bundlesDetails.Where(x => x.PromotionID == bundle.PromotionId).ToList();
                                        foreach (ItemPackModel bundleItem in bundle.BundleItems)
                                        {
                                            if (transationCommonData.OrderItems.Any(x => x.ItemId == bundleItem.ItemId && x.PackId == bundleItem.PackId))
                                            {
                                                bundleItem.Price = transationCommonData.OrderItems.Where(item => item.ItemId == bundleItem.ItemId && item.PackId == bundleItem.PackId).ToList().Select(x => x.Price).FirstOrDefault();
                                                bundleItem.Tax = transationCommonData.OrderItems.Where(item => item.ItemId == bundleItem.ItemId && item.PackId == bundleItem.PackId).ToList().Select(x => x.Tax).FirstOrDefault();
                                            }
                                            else
                                            {
                                                bundleItem.Price = items.Where(item => item.ItemId == bundleItem.ItemId && item.PackId == bundleItem.PackId).ToList().Select(x => x.Price).FirstOrDefault();
                                                bundleItem.Tax = items.Where(item => item.ItemId == bundleItem.ItemId && item.PackId == bundleItem.PackId).ToList().Select(x => x.Tax).FirstOrDefault();
                                            }
                                            bundleItem.BundleDiscount = bundleItem.Price * bundleItem.DiscountValue / 100;
                                            bundleItem.BundlePrice = bundleItem.PromotionOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems.GetHashCode() ? (bundleItem.Price - bundleItem.BundleDiscount) : bundleItem.PriceValue;

                                            bundleItem.CalculatedDiscount = 0;
                                            bundleItem.GrossTotal = bundleItem.Price * bundleItem.Quantity;
                                            bundleItem.CalculatedTax = bundleItem.GrossTotal * bundleItem.Tax / 100;
                                            bundleItem.NetTotal = bundleItem.GrossTotal + bundleItem.CalculatedTax;

                                            bundleItem.BundleGrossTotal = bundleItem.BundlePrice * bundleItem.Quantity;
                                            bundleItem.BundleCalculatedTax = _requestRepository.Configurations.CalculateTaxBeforeDiscounts ? (bundleItem.GrossTotal * bundleItem.Tax) / 100 : (bundleItem.BundleGrossTotal * bundleItem.Tax) / 100;
                                            bundleItem.BundleNetTotal = bundleItem.BundleGrossTotal + bundleItem.BundleCalculatedTax;

                                            bundle.NetTotal += bundleItem.NetTotal;
                                            bundle.BundleNetTotal += bundleItem.BundleNetTotal;
                                            if (AvaliableItemStock != null && AvaliableItemStock.Count > 0)
                                            {
                                                if (AvaliableItemStock.Any(item => item.ItemId == bundleItem.ItemId))
                                                {
                                                    bundleItem.OriginalAvailableQty = AvaliableItemStock.Where(item => item.ItemId == bundleItem.ItemId).FirstOrDefault().AvailableQtyInPcs;
                                                }
                                            }
                                            otherBundles = orderBundles.Where(x => x.OriginalRepeatCount > 0 && x.PromotionId != bundle.PromotionId && x.BundleItems.Any(y => y.ItemId == bundleItem.ItemId)).ToList();
                                            decimal used = 0;
                                            foreach (Promotion otherBundle in otherBundles)
                                            {
                                                otherBundle.BundleItems.Where(x => x.ItemId == bundleItem.ItemId).ToList().ForEach(x =>
                                                {
                                                    used += otherBundle.OriginalRepeatCount * x.Quantity * x.PackQuantity;
                                                });
                                            }
                                            decimal qtyforSameItem = 0;
                                            if (bundle.BundleItems.Any(x => x.PackId != bundleItem.PackId && bundleItem.ItemId == x.ItemId))
                                            {
                                                qtyforSameItem = bundle.BundleItems.Where(x => x.PackId != bundleItem.PackId && bundleItem.ItemId == x.ItemId).Sum(x => x.PackQuantity * x.Quantity);
                                            }
                                            bundleItem.AvailableQtyInPcs = (bundleItem.OriginalAvailableQty - used) / ((bundleItem.Quantity * bundleItem.PackQuantity) + qtyforSameItem);

                                        }
                                        _validationManager.GetPromotionInputsAndOutputs(bundle, transationCommonData.CustomerId, transationCommonData.OutletId, true);
                                    }
                                }
                                foreach (Promotion bundle in orderBundles)
                                {
                                    bundle.BundleAvailableQty = Math.Floor(bundle.BundleItems.Min(x => x.AvailableQtyInPcs));
                                }
                            }
                            //if (_requestRepository.Configurations.LimitItemsToMainWarehouseStock.Contains(LimitItemsToWarehouseTypes.Order.GetHashCode().ToString()))
                            //{
                            //    orderBundles = orderBundles.Where(x => x.BundleAvailableQty > 0).ToList();
                            //}
                        }
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                orderBundles = null;
                return GlobalErrors.Error;
            }
        }
        private void checkRelatedToTargetSatisfiedPromo(List<Promotion> relatedToTargetPromotions ,TransactionCommonData transationCommonData) {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string toBeVoidedInvoiceID = "";
            string relatedToTargetPromotionsIDs = "";
            List<RelatedToTargetPromotion> relatedToTargetSatisfiedPromotions;
            List<Promotion> LastinvoiceAccumulativeList;
            List<Promotion> PromotedLastinvoiceAccumulativeToBeRemoved;
            List<RelatedToTargetPromotion> relatedToTargetAccLastInvList = new List<RelatedToTargetPromotion>();
            int sequence = -1;

            try
            {
                relatedToTargetSatisfiedPromotions = new List<RelatedToTargetPromotion>();
                LastinvoiceAccumulativeList = new List<Promotion>();
                PromotedLastinvoiceAccumulativeToBeRemoved = new List<Promotion>();
                LastinvoiceAccumulativeList = relatedToTargetPromotions.Where(x => x.TargetMode == TargetModes.LastInvoiceAccumulative.GetHashCode()).ToList();
                if (LastinvoiceAccumulativeList != null && LastinvoiceAccumulativeList.Count() > 0)
                {
                    relatedToTargetAccLastInvList = _promotionManager.checkIfIsLastInvoiceAccumuoativePromoted(LastinvoiceAccumulativeList , transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery , transationCommonData.OrderId);
                    LastinvoiceAccumulativeList.ForEach(q => {
                        if (q.IsPromoted)
                        {
                            relatedToTargetPromotions.RemoveAll(x => x.PromotionId == q.PromotionId); // remove it from promotions which will be sent to procedure .
                        }
                        else
                        {
                            PromotedLastinvoiceAccumulativeToBeRemoved.Add(q); // remove it from promotedLastInvoiceAccumulative if it is not promoted .
                        }
                    });
                }
                LastinvoiceAccumulativeList.RemoveAll(x => PromotedLastinvoiceAccumulativeToBeRemoved.Contains(x)); // here LastinvoiceAccumulativeList will contain only accumulative last invoice promoted promotions

                if (relatedToTargetPromotions != null && relatedToTargetPromotions.Count > 0)
                {
                    foreach (Promotion promotion in relatedToTargetPromotions)
                    {
                        if (promotion.IsProductDiscount && !IsValidProductDiscountLevel(transationCommonData, promotion))
                            continue;
                        if ((promotion.TargetMode == TargetModes.LastInvoiceAccumulative.GetHashCode() || promotion.TargetMode == TargetModes.LastInvoice.GetHashCode()) && !transationCommonData.DontCheckLastInvoice && (transationCommonData.LastInvoicePromotionsList == null || transationCommonData.LastInvoicePromotionsList.Count <= 0 || !transationCommonData.LastInvoicePromotionsList.Contains(promotion.PromotionId)))
                        {
                            if((transationCommonData.ProductPromotionLevelId == 2 && transationCommonData.ProductDiscountFirstLevelList.Where(x=> x.PromotionId == promotion.PromotionId).Count() > 0) || ((transationCommonData.NotSelectedFirstLevelLastInvoice == null || (transationCommonData.NotSelectedFirstLevelLastInvoice != null && transationCommonData.NotSelectedFirstLevelLastInvoice.Count ==0))
                            || (transationCommonData.NotSelectedFirstLevelLastInvoice!=null && transationCommonData.NotSelectedFirstLevelLastInvoice.Count > 0 && transationCommonData.NotSelectedFirstLevelLastInvoice.Contains(promotion.PromotionId)))  ) 
                                continue;
                        }
                        relatedToTargetPromotionsIDs += promotion.PromotionId + ",";
                    }
                    if(!string.IsNullOrEmpty(relatedToTargetPromotionsIDs))
                    relatedToTargetPromotionsIDs = "'" + relatedToTargetPromotionsIDs.Substring(0, relatedToTargetPromotionsIDs.Length - 1) + "'";
                }
                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialLevelsFlow.GetHashCode())
                {
                    sequence = relatedToTargetPromotions[0].Sequence; // all sequence for current promotions which will be checked will have the same sequences here .
                }

                if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                    toBeVoidedInvoiceID = _promotionManager.GetInvoiceID(transationCommonData.OrderId, transationCommonData.CustomerId, transationCommonData.OutletId, -1);

                result = _transactionManager.SaveInTempTransactionDetails(transationCommonData);
                if (result == GlobalErrors.Success)
                {
                    // before running the procedure , check if there is accumulative last invoice then check if it is promoted then dont send it to procedure and get saved detail in history to get it always 
                    // when sequence is on , we will use the calculated discount amount to subtract the discount value from previous levels in current calling of procedure (discount value = gross - (net - tax ))
                    result = _promotionManager.RunCalculateSatisfiedPromotionsProcedure(transationCommonData.IsTest, transationCommonData.CustomerId, transationCommonData.OutletId, relatedToTargetPromotionsIDs, transationCommonData.GrossTotal, transationCommonData.NetTotal, transationCommonData.GrossTotal - (transationCommonData.NetTotal - transationCommonData.Tax ), transationCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery, toBeVoidedInvoiceID , false,ref relatedToTargetSatisfiedPromotions, sequence, null);
                    if (result == GlobalErrors.Success )
                    {
                        // remove PromotedAccLstInvoice from promotions retrieved from procedure :
                        if (relatedToTargetSatisfiedPromotions != null && relatedToTargetSatisfiedPromotions.Count() > 0 && LastinvoiceAccumulativeList != null && LastinvoiceAccumulativeList.Count() > 0 )
                        {
                            relatedToTargetSatisfiedPromotions.RemoveAll(x => LastinvoiceAccumulativeList.Find(p => x.PromotionId == p.PromotionId) != null);
                        }
                        //result = _promotionManager.GetSatisfiedPromotionsData(ref relatedToTargetSatisfiedPromotions,transationCommonData.CustomerId ,transationCommonData.OutletId , LastinvoiceAccumulativeList);
                        relatedToTargetSatisfiedPromotions.AddRange(relatedToTargetAccLastInvList);
                        // here return PromotedAccumulativeLastInvoicePromotions to relatedToTargetPromotions .
                        relatedToTargetPromotions.AddRange(LastinvoiceAccumulativeList);
                        if (result == GlobalErrors.Success && relatedToTargetSatisfiedPromotions != null && relatedToTargetSatisfiedPromotions.Count > 0)
                        {
                            modifyRelatedToTargetSatisfiedOutputs(relatedToTargetPromotions , relatedToTargetSatisfiedPromotions , transationCommonData);
                            
                        }
                    }
                    if (result == GlobalErrors.Success)
                        result = _transactionManager.DeleteTempTransactionDetails();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        private bool IsValidProductDiscountLevel(TransactionCommonData transationCommonData, Promotion promotion)
        {
            bool isValid = true;
            try
            {
                foreach (PromotionOption output in promotion.PromotionOutputs)
                {
                    if (transationCommonData.ProductPromotionLevelId == 1)
                    {   //Level 1
                        if (output.PromotionOptionDetails.Where(x => x.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount).Count() > 0)
                        {
                            isValid = false;
                            return isValid;
                        }
                    }
                    else
                    {
                        //Level 2
                        if (output.PromotionOptionDetails.Where(x => x.OutputOptionDetailTypeId != PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount).Count() > 0)
                        {
                            isValid = false;
                            return isValid;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isValid;
        }
        private void modifyRelatedToTargetSatisfiedOutputs(List<Promotion> relatedToTargetPromotions, List<RelatedToTargetPromotion> relatedToTargetSatisfiedPromotions, TransactionCommonData transactionCommonData)
        {
            List<RelatedToTargetPromotion> promotionSatisfiedOptions = new List<RelatedToTargetPromotion>();
            try
            {
                foreach (Promotion promotion in relatedToTargetPromotions)
                {

                    promotionSatisfiedOptions = relatedToTargetSatisfiedPromotions.Where(a => a.PromotionId == promotion.PromotionId).ToList();
                    if (!transactionCommonData.AreDetailsFilled) // this means that check out promotions here is called before filling sold items details (from outside the entry) 
                    {
                        foreach (ItemPackModel pack in transactionCommonData.SoldItems)
                        {
                            pack.GrossTotal = pack.RequiredQty * pack.Price;
                        }
                    }
                        _promotionManager.FillDescriptions(promotionSatisfiedOptions, relatedToTargetPromotions.Find(x => x.PromotionId == promotion.PromotionId), transactionCommonData);
                    if (promotionSatisfiedOptions != null && promotionSatisfiedOptions.Count > 0)
                    {
                           if (!promotion.AppliedAfterPeriod &&( (promotion.TargetMode == TargetModes.LastInvoiceAccumulative.GetHashCode() || promotion.TargetMode == TargetModes.LastInvoice.GetHashCode()) && !transactionCommonData.DontCheckLastInvoice && (transactionCommonData.LastInvoicePromotionsList == null || transactionCommonData.LastInvoicePromotionsList.Count <= 0 || !transactionCommonData.LastInvoicePromotionsList.Contains(promotion.PromotionId))) && ((transactionCommonData.ProductPromotionLevelId == 2 && transactionCommonData.ProductDiscountFirstLevelList.Where(x => x.PromotionId == promotion.PromotionId).Count() > 0) || ((transactionCommonData.NotSelectedFirstLevelLastInvoice == null || (transactionCommonData.NotSelectedFirstLevelLastInvoice != null && transactionCommonData.NotSelectedFirstLevelLastInvoice.Count == 0))
                            || (transactionCommonData.NotSelectedFirstLevelLastInvoice != null && transactionCommonData.NotSelectedFirstLevelLastInvoice.Count > 0 && transactionCommonData.NotSelectedFirstLevelLastInvoice.Contains(promotion.PromotionId)))))
                            {
                            promotion.IsSatisfied = false;
                            promotion.SatisfiedInput = -1;
                            promotion.SatesfiedDetail = -1;
                        }
                        else
                        {
                            promotion.IsSatisfied = true;
                            foreach (RelatedToTargetPromotion option in promotionSatisfiedOptions)
                            {
                                PromotionInputDetailTypes inputType = (PromotionInputDetailTypes)option.PromotionOptionDetailTypeId;
                                promotion.SatisfiedInput = PromotionOptionTypes.Input.GetHashCode();
                                promotion.SatesfiedDetail = option.PromotionOptionDetailId;
                                promotion.PromotionOutputs.Find(x => option.ReferenceOptionId == x.PromotionOptionId).RelatedToTargetOption = option;
                            }
                        }
                    }
                    else
                    {
                        promotion.IsSatisfied = false;
                        promotion.SatisfiedInput = -1;
                        promotion.SatesfiedDetail = -1;
                    }
                    promotion.PromotionOutputs.RemoveAll(x => x.RelatedToTargetOption == null);
                    //Saving Prerequisites : 
                    if (promotion.IsSatisfied)
                    {
                        foreach (PromotionOption inputOption in promotion.PromotionInputs)
                        {
                            foreach (PromotionOptionDetail inputOptionDetail in inputOption.PromotionOptionDetails)
                            {
                                if (promotion.PromotionOutputs.Find(x => x.PromotionOptionId == inputOptionDetail.ReferenceOptionId) != null)// this means that this input is satisfied 
                                {
                                    if (inputOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.SummationOverGroup || inputOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.InvoiceAmountOnPackGroup)
                                    {
                                        if (_requestRepository.Configurations.AllowConversionInPromotion)
                                        {
                                            _promotionManager.FillPromotionPreRequiesiteDetails(promotion, transactionCommonData.SoldItems.Where(n => inputOptionDetail.PackGroupDetails.Any(o => o.ItemId == n.ItemId)).ToList(), inputOptionDetail.PackGroupId, inputOptionDetail);
                                        }
                                        else
                                        {
                                            _promotionManager.FillPromotionPreRequiesiteDetails(promotion, transactionCommonData.SoldItems.Where(n => inputOptionDetail.PackGroupDetails.Any(o => o.ItemId == n.ItemId && o.PackId == n.PackId)).ToList(), inputOptionDetail.PackGroupId);
                                        }
                                    }
                                    else if (inputOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.InvoiceValue)
                                    {
                                        _promotionManager.FillPromotionPreRequiesiteDetails(promotion, transactionCommonData.SoldItems, inputOptionDetail.PackGroupId);
                                    }
                                }
                            }
                        }
                    }
                }
            }
             catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            }

        private void checkForTarget(List<Promotion> customerPromotions ,Promotion promotion , TransactionCommonData transactionCommonData)
        {
            decimal _achievemnetBenefitValue = 0;
            try
            {
                if (promotion.CustomerTargets != null && promotion.CustomerTargets.Count > 0)//?
                {
                    foreach (Promotion item in customerPromotions)
                    {
                        if (item.PromotionId == promotion.PromotionId)
                        {
                            for (int i = 0; i < promotion.CustomerTargets.Count; i++)
                            {
                                if (promotion.CustomerTargets[i].AchievementID == promotion.CustomerTargets[i].AchievementID
                                    && promotion.CustomerTargets[i].TargetID == promotion.CustomerTargets[i].TargetID
                                    && promotion.CustomerTargets[i].AchievementPeriod == promotion.CustomerTargets[i].AchievementPeriod
                                    && promotion.CustomerTargets[i].CustomerID == promotion.CustomerTargets[i].CustomerID
                                    && promotion.CustomerTargets[i].OutletID == promotion.CustomerTargets[i].OutletID
                                    && promotion.CustomerTargets[i].IsPromoted == true)
                                {
                                    promotion.CustomerTargets[i].IsPromoted = true;
                                    if (promotion.CustomerTargets[i].PromotedOnPromotionID == -1)
                                        promotion.CustomerTargets[i].PromotedOnPromotionID = promotion.PromotionId;
                                }
                                // this part has been added for caching the satisfied output value of wholesales promotions
                                // and will be used while checking th dynamic promotion which should be checked after subtracting wholessales from nettotal
                                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                                {
                                    _achievemnetBenefitValue = 0;
                                    if (promotion.PromotionOutputs != null
                                        && promotion.PromotionOutputs.Count > 0 && promotion.PromotionOutputs.ElementAt(0).PromotionOptionDetails != null &&
                                         promotion.PromotionOutputs.ElementAt(0).PromotionOptionDetails.Count > 0)
                                    {
                                        _achievemnetBenefitValue = promotion.PromotionOutputs.ElementAt(0).PromotionOptionDetails.ElementAt(0).Value;
                                        if (item.IsWholeSaleContract)
                                            transactionCommonData.CalculatedAchievemnetDiscount += CalculateWholeSales(promotion, _achievemnetBenefitValue, transactionCommonData);
                                        else
                                        if (promotion.IsRetail)
                                            transactionCommonData.CalculatedAchievemnetDiscount += CalculateRetailAchievement(promotion, _achievemnetBenefitValue, transactionCommonData);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        private decimal CalculateWholeSales(Promotion promotion, decimal satesfiedPercentageValue , TransactionCommonData transactionCommonData)
        {
            decimal achievedValue = 0;
            try
            {
                decimal totalPromotedDiscount = 0, itemsPromotedDiscount = 0;
                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                    totalPromotedDiscount = _promotionManager.CalculateCurrentPromotedDiscount(transactionCommonData);
                decimal targetValue = 0, targetDiscount = 0, alreadySavedInvoiceValue = 0;
                bool isLastInvoice = false;
                if (promotion.CustomerTargets != null)
                {
                    string TransID = string.Empty;
                    foreach (AchievementTargetCustomer customerTarget in promotion.CustomerTargets)
                    {
                        if (customerTarget.PromotedOnPromotionID == promotion.PromotionId)
                        {
                            targetValue = _promotionManager.GetAchievementValue(customerTarget, promotion.PromotionType, promotion.StartDate, promotion.EndDate);
                            if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery)
                            {
                                TransID = _promotionManager.GetInvoiceID(transactionCommonData.OrderId, int.Parse(customerTarget.CustomerID.ToString()), customerTarget.OutletID, -1);
                                isLastInvoice = _promotionManager.CheckIfTransactionIsLastInvoice(int.Parse(customerTarget.CustomerID.ToString()), customerTarget.OutletID, customerTarget.AchievementID, promotion.PromotionId, TransID, promotion.PromotionLevel);
                                if (isLastInvoice)
                                {
                                    targetValue = _promotionManager.GetOldAchievementValue(int.Parse(customerTarget.CustomerID.ToString()), customerTarget.OutletID, customerTarget.AchievementID, customerTarget.TargetID, promotion.PromotionLevel, TransID);
                                }
                                else
                                {
                                    alreadySavedInvoiceValue = 0;
                                    if (_promotionManager.CheckIfAchievementDetailsAlreadySaved(int.Parse(customerTarget.CustomerID.ToString()), customerTarget.OutletID, customerTarget.AchievementID, customerTarget.TargetID, TransID, -1, -1, -1, ref alreadySavedInvoiceValue))
                                    {
                                        targetValue -= alreadySavedInvoiceValue;
                                    }
                                }
                            }
                            if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && _requestRepository.Configurations.RecalculatePromotionInDelivery)
                            {
                                targetValue += transactionCommonData.NetTotal - totalPromotedDiscount;
                                targetDiscount = (targetValue * (satesfiedPercentageValue / 100)) / (transactionCommonData.NetTotal) * 100;
                            }
                            else
                            {
                                targetValue += transactionCommonData.NetTotal;
                                targetDiscount = (targetValue * (satesfiedPercentageValue / 100)) / (transactionCommonData.NetTotal + totalPromotedDiscount) * 100;
                            }
                            foreach (ItemPackModel packModel in transactionCommonData.SoldItems)
                            {
                                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                                    itemsPromotedDiscount = Math.Min(targetDiscount , 100 - (packModel.WholeSalesPromotedDiscount + packModel.AllItemDiscount + packModel.ItemPromotedDiscount));
                                else
                                    itemsPromotedDiscount = Math.Min(targetDiscount , 100 - packModel.WholeSalesPromotedDiscount);

                                packModel.WholeSalesPromotedDiscount += itemsPromotedDiscount;
                                //if (promotion.FreeGoodsType.Equals(FreeGoodsTypes.CashIncentiveDiscount))
                                //    _soldItems[item.ItemID].Packs[pack.PackID].CashIncentivePromotedDiscount += itemsPromotedDiscount;
                                achievedValue += (packModel.NetTotal - packModel.CalculatedTax) * itemsPromotedDiscount / 100;
                                packModel.WholeSalesPromotedDiscount = 0;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return achievedValue;
        }
        private decimal CalculateRetailAchievement(Promotion promotion, decimal satesfiedPercentageValue,TransactionCommonData transactionCommonData)
        {
            decimal achievedValue = 0;
            Dictionary<int, Dictionary<int, PromotionGroupPackDetail>> groupPacks = new Dictionary<int, Dictionary<int, PromotionGroupPackDetail>>();
            try
            {
                decimal totalPromotedDiscount = 0, itemsPromotedDiscount = 0;
                if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                    totalPromotedDiscount = _promotionManager.CalculateCurrentPromotedDiscount(transactionCommonData);
                decimal targetValue = 0, targetDiscount = 0, alreadySavedInvoiceValue = 0;
                if (promotion.CustomerTargets != null)
                {
                    string TransID = string.Empty;
                    foreach (AchievementTargetCustomer customerTarget in promotion.CustomerTargets)
                    {
                        if (customerTarget.PromotedOnPromotionID == promotion.PromotionId)
                        {
                            if (customerTarget.IsFirstTimePromoted)
                            {
                                targetValue = _promotionManager.GetAchievementValue(customerTarget, promotion.PromotionType, promotion.StartDate, promotion.EndDate);
                                if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && targetValue > 0)
                                {
                                    alreadySavedInvoiceValue = 0;
                                    TransID = _promotionManager.GetInvoiceID(transactionCommonData.OrderId, int.Parse(customerTarget.CustomerID.ToString()), customerTarget.OutletID, -1);
                                    if (_promotionManager.CheckIfAchievementDetailsAlreadySaved(int.Parse(transactionCommonData.CustomerId.ToString()), transactionCommonData.OutletId, customerTarget.AchievementID, customerTarget.TargetID, TransID, -1, -1, -1, ref alreadySavedInvoiceValue))
                                    {
                                        {
                                            targetValue -= alreadySavedInvoiceValue;
                                        }
                                    }
                                    if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && _requestRepository.Configurations.RecalculatePromotionInDelivery)
                                    {
                                        targetValue += transactionCommonData.NetTotal - totalPromotedDiscount;
                                        targetDiscount = (targetValue * (satesfiedPercentageValue / 100)) / (transactionCommonData.NetTotal) * 100;
                                    }
                                    else
                                    {
                                        targetValue += transactionCommonData.NetTotal;
                                        targetDiscount = (targetValue * (satesfiedPercentageValue / 100)) / (transactionCommonData.NetTotal + totalPromotedDiscount) * 100;
                                    }
                                }
                                else
                                {
                                    if (transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.PartialDelivery && _requestRepository.Configurations.RecalculatePromotionInDelivery)
                                    {
                                        targetDiscount = satesfiedPercentageValue * ((transactionCommonData.NetTotal - totalPromotedDiscount) / transactionCommonData.NetTotal);
                                    }
                                    else
                                    {
                                        targetDiscount = satesfiedPercentageValue * (transactionCommonData.NetTotal / (transactionCommonData.NetTotal + totalPromotedDiscount));
                                    }
                                }
                                foreach (ItemPackModel packModel in transactionCommonData.SoldItems)
                                {


                                    if (_requestRepository.Configurations.PromotionCalculationSequence == PromotionCalculationSequence.SequentialFlow.GetHashCode())
                                        itemsPromotedDiscount = Math.Min(targetDiscount, 100 - (packModel.ExciseContractPromotedDiscount + packModel.AllItemDiscount + packModel.ItemPromotedDiscount));
                                    else
                                        itemsPromotedDiscount = Math.Min(targetDiscount, 100 - packModel.ExciseContractPromotedDiscount);
                                    packModel.ExciseContractPromotedDiscount += itemsPromotedDiscount;
                                    //if (promotion.FreeGoodsType.Equals(FreeGoodsTypes.CashIncentiveDiscount))
                                    //    packModel.CashIncentivePromotedDiscount += itemsPromotedDiscount;
                                    achievedValue += (packModel.NetTotal - packModel.CalculatedTax) * itemsPromotedDiscount / 100;
                                    packModel.ExciseContractPromotedDiscount = 0;
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return achievedValue;
        }
        public GlobalErrors CheckHeaderData(ref TransactionCommonData transationCommonData, ref string msgError)
        {
            return CheckHeaderData(ref transationCommonData, null, ref msgError);
        }

        public GlobalErrors CheckHeaderData(ref TransactionCommonData transationCommonData, DBHelper<int> dBHelper, ref string msgError)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {

                #region [Fill Outlet Data]
                int accountId = -1;
                bool checkBilltoBill = false;
                transationCommonData.Outlet = _customerManager.FillOutletData(transationCommonData.CustomerId, transationCommonData.OutletId, transationCommonData.DivisionId, dBHelper);

                if (transationCommonData.Outlet != null)
                    result = GlobalErrors.Success;

                if (result == GlobalErrors.Success && !AllowSalesModeSelectionForCustomer(transationCommonData.Outlet.CustomerTypeId, transationCommonData.ItemFormProcessMode))
                    transationCommonData.SalesMode = transationCommonData.Outlet.CustomerTypeId;

                transationCommonData.Outlet.SelectedSalesMode = transationCommonData.SalesMode; // used in [SaveInvoice]
                #endregion [Fill Outlet Data]

                if (result == GlobalErrors.Success && transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Sales && _requestRepository.Configurations.ControlTransactionOnDivisionLevel && _requestRepository.Configurations.CheckCreditLimitOnEmployeeDivisionAccount && transationCommonData.DivisionId != -1)
                {
                    result = _accountManager.GetEmployeeDivisionAccount(transationCommonData.DivisionId, transationCommonData.EmployeeId, ref accountId, dBHelper);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    if (accountId == -1)
                    {
                        msgError = Resources.MessagesConstants.MessageErrorNoEmployeeAccount;
                        return GlobalErrors.Error;
                    }
                }

                if (result == GlobalErrors.Success && (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Sales || transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Orders || transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Return || transationCommonData.ItemFormProcessMode == ItemFormProcessMode.ReturnSerials) && _requestRepository.Configurations.ControlTransactionOnDivisionLevel && (!_requestRepository.Configurations.UseCustomerLevelAccount))
                {
                    result = _accountManager.GetCustomerDivisionAccount(transationCommonData.DivisionId, transationCommonData.CustomerId, transationCommonData.OutletId, ref accountId, dBHelper);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    if (accountId == -1)
                    {
                        msgError = Resources.MessagesConstants.Desc_No_account_defined_for_customer_on_division;
                        return GlobalErrors.Error;
                    }
                }

                transationCommonData.Outlet.CustomerValidations.NoAccount = transationCommonData.Outlet.Account == null;

                // No Account
                if (transationCommonData.Outlet.CustomerValidations.NoAccount)
                    return GlobalErrors.Success;

                // Is Customer On Hold
                transationCommonData.Outlet.CustomerValidations.IsOnHold = IsCustomerOnHold(transationCommonData);
                if (!transationCommonData.IsTest && transationCommonData.ItemFormProcessMode != ItemFormProcessMode.CreditNote && transationCommonData.OrderTypeId != OrderTypes.Return.GetHashCode())
                {
                    // Is Violate Payment Terms
                    transationCommonData.Outlet.CustomerValidations.IsViolatePaymentTerms = IsCustomerViolatePaymentTerms(transationCommonData);

                    // Is Exceeds Customer Limit
                    transationCommonData.Outlet.CustomerValidations.IsExceedsCustomerLimit = IsExceedsCustomerLimit(transationCommonData);

                    //IsExceedsCustomerBillToBillLimit
                    checkBilltoBill = _customerManager.IsExceedsCustomerBillToBillLimit(transationCommonData.CustomerId, transationCommonData.OutletId, transationCommonData.DivisionId);
                    if (checkBilltoBill)
                    {
                        msgError = Resources.MessagesConstants.MessageErrorCustomerHasUnpaidtransactions;
                        return GlobalErrors.Error;
                    }
                }
                if(!transationCommonData.IsTest && (_requestRepository.Configurations.TransactionIDModeInBOTransactions == TransactionIDModeInBOInvoices.RouteCodeConcatenatedToFreeTextField.GetHashCode() || _requestRepository.Configurations.TransactionIDModeInBOTransactions == TransactionIDModeInBOInvoices.FreeTextField.GetHashCode()))
                {
                    if (IsTransactionIDExist(transationCommonData.DraftTransactionId))
                    {
                        msgError = Resources.MessagesConstants.Desc_Transaction_ID_Exist;
                        return GlobalErrors.Error;
                    }
                }
                if(transationCommonData.IsExchangeInvoice && (_requestRepository.Configurations.TransactionIDModeInBOTransactions == TransactionIDModeInBOInvoices.RouteCodeConcatenatedToFreeTextField.GetHashCode() || _requestRepository.Configurations.TransactionIDModeInBOTransactions == TransactionIDModeInBOInvoices.FreeTextField.GetHashCode()))
                {
                    if (IsTransactionIDExist(transationCommonData.ReturnId))
                    {
                        msgError = Resources.MessagesConstants.Desc_Return_ID_Exist;
                        return GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private bool AllowSalesModeSelectionForCustomer(int customerTypeId, ItemFormProcessMode processMode)
        {
            if (processMode == ItemFormProcessMode.Sales)
            {
                return _transactionManager.AllowSalesModeSelectionForCustomerInSales(customerTypeId);
            }
            else if(processMode == ItemFormProcessMode.Orders)
            {
                return _orderManager.AllowSalesModeSelectionForCustomerInOrder(customerTypeId);
            }
            return false;
        }
        public bool IsTransactionIDExist(string TransactionID)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                object field = 0;
                dBHelper = new DBHelper<int>();
                string query = string.Format(@"select Count(*) from [Transaction] where TransactionID = '{0}'", TransactionID);

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public GlobalErrors CheckCostPrice(TransactionCommonData transationCommonData, ref string msgError)
        {
            msgError = string.Empty;
            try
            {
                decimal amount = 0;
                decimal costAmount = 0;
                foreach (ItemPackModel item in transationCommonData.SoldItems)
                {
                    amount = item.Price * item.RequiredQty - item.CalculatedDiscount;
                    costAmount = item.CostPrice * item.RequiredQty;
                    if (amount < costAmount)
                    {
                        msgError = string.Format(ResourcesManager.TranslateKey(Resources.MessagesConstants.Desc_Msg_Cost_Price_Larger_Than_Original, _requestRepository.LanguageId), item.ItemCodeName + " (" + item.Uom + ")");
                        return GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return GlobalErrors.Success;
        }
        public bool IsCustomerOnHold(TransactionCommonData transationCommonData)
        {
            try
            {
                if (transationCommonData.Outlet.CustomerOnHold || transationCommonData.Outlet.OnHold)
                {
                    return true;
                }
                else if (transationCommonData.DivisionId != -1 && transationCommonData.Outlet.OnHoldDivisions.Count > 0)
                {
                    if (transationCommonData.Outlet.OnHoldDivisions.Contains(transationCommonData.DivisionId))
                        return true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return transationCommonData.Outlet.OnHold;
        }

        public bool IsCustomerViolatePaymentTerms(TransactionCommonData transactionCommonData)
        {
            bool violatedTerms = false;
            try
            {
                if ((_requestRepository.Configurations.CheckPaymentTermViolation && transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.Sales) ||
                    (_requestRepository.Configurations.CheckPaymentTermsOnOrders && transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.Orders) ||
                    (_requestRepository.Configurations.CheckPaymentTermViolationOnDelivery && transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.Delivery))
                {
                    bool isViolatingPaymentterms = IsCustomerViolatingPaymentTerms(transactionCommonData);
                    if (!isViolatingPaymentterms && transactionCommonData.ItemFormProcessMode == ItemFormProcessMode.Orders && _requestRepository.Configurations.CheckPaymentTermsOnOrdersOnAllDivision)
                    {
                        isViolatingPaymentterms = IsCustomerViolatingPaymentTermsOnAllDivision(transactionCommonData);
                    }
                    return isViolatingPaymentterms;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return violatedTerms;
        }

        public bool IsCustomerViolatingPaymentTermsOnAllDivision(TransactionCommonData transactionCommonData)
        {
            bool isViolatingPayment = false;
            try
            {
                if (!_requestRepository.Configurations.DefinePaymentTermForCashCustomer && ((int)CustomerTypes.CashCustomer == transactionCommonData.Outlet.CustomerTypeId))
                {
                    isViolatingPayment = false;
                }
                else if (transactionCommonData.Outlet.DivisionsPaymentTerm != null && transactionCommonData.Outlet.DivisionsPaymentTerm.Count > 0)
                {
                    foreach (KeyValuePair<int, PaymentTermModel> paymentTermDiv in transactionCommonData.Outlet.DivisionsPaymentTerm)
                    {
                        int divisionId = int.Parse(paymentTermDiv.Key.ToString());
                        if (_customerManager.CustomerViolatedTheTermsOnDivisions(transactionCommonData.Outlet, divisionId))
                        {
                            isViolatingPayment = true;
                            break;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isViolatingPayment;
        }

        public bool IsExceedsCustomerLimit(TransactionCommonData transationCommonData)
        {
            bool isExeed = false;
            try
            {
                if ((!_requestRepository.Configurations.AllowSellCustomerExceedsLimit && transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Sales) ||
                    (_requestRepository.Configurations.CheckCreditLimitOnOrders && transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Orders) ||
                    (!_requestRepository.Configurations.AllowDeliveryToCustomerExceedsLimit && transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Delivery))
                {
                    if (transationCommonData.SalesMode == (int)CustomerTypes.CreditCustomer ||
                        transationCommonData.SalesMode == (int)CustomerTypes.BillToBillCustomer)
                    {
                        transationCommonData.AmountToCheckInCreditLimit = transationCommonData.NetTotal;

                        if (transationCommonData.ItemFormProcessMode == ItemFormProcessMode.Orders)
                        {
                            // DraftTransactionId: OrderStatus Id
                            transationCommonData.AmountToCheckInCreditLimit += _orderManager.GetPendingOrdersTotal(transationCommonData.Outlet.CustomerId, transationCommonData.Outlet.OutletId, transationCommonData.DivisionId, transationCommonData.DraftTransactionId);
                            transationCommonData.Outlet.Account.PendingOrdersTotal = transationCommonData.AmountToCheckInCreditLimit;
                        }

                        return CheckCreditLimit(transationCommonData);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isExeed;
        }

        private static bool CheckCreditLimit(TransactionCommonData transactionCommonData)
        {
            decimal creditReleaseValue = 0;
            try
            {
                if (transactionCommonData.Outlet.CreditLimitCreditRelease != null && transactionCommonData.Outlet.CreditLimitCreditRelease.Value > 0)
                    creditReleaseValue = transactionCommonData.Outlet.CreditLimitCreditRelease.Value;

                decimal availableCredit = (transactionCommonData.Outlet.Account.CreditLimit + creditReleaseValue) - transactionCommonData.Outlet.Account.Balance;
                if (transactionCommonData.AmountToCheckInCreditLimit > availableCredit)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return true;
        }

        private bool IsCustomerViolatingPaymentTerms(TransactionCommonData transactionCommonData)
        {
            bool result = false;
            try
            {
                if (transactionCommonData.Outlet.PaymentTermCreditRelease != null)
                    return result;

                if (!_requestRepository.Configurations.DefinePaymentTermForCashCustomer && ((int)CustomerTypes.CashCustomer == transactionCommonData.Outlet.CustomerTypeId))
                {
                    result = false;
                }
                else
                {
                    if (transactionCommonData.Outlet.DivisionsPaymentTerm != null && transactionCommonData.Outlet.DivisionsPaymentTerm.Count > 0)
                        result = _customerManager.CustomerViolatedTheTermsOnDivisions(transactionCommonData.Outlet, transactionCommonData.DivisionId);
                    else result = _customerManager.CustomerViolatedTheTerms(transactionCommonData.Outlet, transactionCommonData.DivisionId);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public bool IsValidAccountAndDocumentSequence(DocumentSequenceFilter documentSequenceFilter, ref string documentId, ref int accountId)
        {
            try
            {
                documentId = _documentSequenceManager.GetMaxDocumentSequence(documentSequenceFilter.EmployeeId, documentSequenceFilter.DocumentType, documentSequenceFilter.DivisionId, documentSequenceFilter.SDCId);
                if (!string.IsNullOrEmpty(documentId))
                {
                    if (documentSequenceFilter.DocumentType == DocumentTypes.Collection) // also check for applied payment id
                    {
                        string appliedPaymentId = _documentSequenceManager.GetMaxDocumentSequence(documentSequenceFilter.EmployeeId, DocumentTypes.AppliedPayment, documentSequenceFilter.DivisionId, documentSequenceFilter.SDCId);
                        if (string.IsNullOrEmpty(appliedPaymentId))
                        {
                            documentId = string.Empty;
                            return false;
                        }
                    }
                }
                else
                {
                    return false;
                }

                DBHelper<int> dbHelper = new DBHelper<int>();
                //AccountModel empAccount = _accountManager.GetEmployeeAccount(documentSequenceFilter.EmployeeId, dbHelper);
                //if (empAccount == null || empAccount.AccountId == -1)
                //{
                //    return false;
                //}
                //else
                //{
                //    accountId = empAccount.AccountId;
                //}
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return true;
        }

        public GlobalErrors GetMaxID(string tableName,string columnName, ref int maxId)
        {
            try
            {
                return _validationManager.GetMaxID(tableName, columnName, ref maxId, null);
            }
            catch(Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public void RecalculateItemsWithProductDiscount(TransactionCommonData transationCommonData)
        {
            try
            {
                _promotionManager.RecalculateItemsWithProductDiscount(transationCommonData);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        #region[Contracted FOC]
        public GlobalErrors CheckForContractedFOC(TransactionCommonData transactionCommonData, ref List<AppliedContractedFOCModel> contractedFOCs)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _validationManager.CheckForContractedFOC(transactionCommonData, ref contractedFOCs);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors ApplyContractedFOCs(ref TransactionCommonData transactionCommonData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _validationManager.ApplyContractedFOCs(ref transactionCommonData);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region[Header Discount]
        public GlobalErrors CheckForHeaderDiscount(ref TransactionCommonData transactionCommon, ref List<HeaderDiscountModel> headerDiscountList) 
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _validationManager.CheckForHeaderDiscount(ref transactionCommon, ref headerDiscountList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion
        
    }
}