﻿using System;
using System.Text;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Core;
using Sonic.Web.Model;
using System.Reflection;

namespace Sonic.Web.Service
{
  public  class SupportNoteService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly SupportNoteManager _supportNoteManager;


        public SupportNoteService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _supportNoteManager = new SupportNoteManager(_requestRepository);


        }

        public GlobalErrors InsertSupportNote(SupportNote supportNote)
        {
            try
            {
                return _supportNoteManager.InsertSupportNote(supportNote);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
    }
}
