﻿using DinkToPdf;
using DinkToPdf.Contracts;
using Microsoft.AspNetCore.Hosting;
using Sonic.Web.Core;
using Sonic.Web.Core.Survey;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.Services;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Service.Survey
{
    public class SurveyService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly SurveyManager _surveyManager;
        private readonly MasterDataManager _masterDataManager;
        private readonly EmployeeManager _employeeManager;
        private readonly ItemManager _itemManager;
        private readonly DocumentSequenceManager _documentSequenceManager;
        private readonly EmailService _emailService;
        private readonly EmailManager _emailManager;
        private readonly TemplateGenerator _templateGenerator;
        private readonly IHostingEnvironment _hostingEnvironment;
        private IConverter _converter;
        public SurveyService(IRequestRepository requestRepository, IHostingEnvironment hostingEnvironment, IConverter converter)
        {
            _requestRepository = requestRepository;
            _surveyManager = new SurveyManager(requestRepository);
            _masterDataManager = new MasterDataManager(requestRepository);
            _employeeManager = new EmployeeManager(_requestRepository);
            _itemManager = new ItemManager(requestRepository);
            _documentSequenceManager = new DocumentSequenceManager(_requestRepository);
            _templateGenerator = new TemplateGenerator(requestRepository, hostingEnvironment, converter);
            _emailManager = new EmailManager(_requestRepository);
            _hostingEnvironment = hostingEnvironment;
            _emailService = new EmailService(_requestRepository);
            _converter = converter;
        }
        #region[LOV]
        public GlobalErrors GetLOVByID(int LOVID, ref LOVDynamicModel LOVModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _surveyManager.GetLOVByID(LOVID, ref LOVModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteLOV(int LOVID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();

            try
            {
                dBHelper.BeginTransaction();
                result = _surveyManager.DeleteLOV(LOVID, dBHelper);


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    dBHelper.CommitTransaction();
                else
                    dBHelper.RollBackTransaction();
            }
            return result;
        }
        public GlobalErrors EditLOV(LOVDynamicModel LOVModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                dBHelper.BeginTransaction();
                result = _surveyManager.EditLOV(LOVModel, dBHelper);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success|| result == GlobalErrors.SuccessWithZeroRowAffected)
                    dBHelper.CommitTransaction();
                else
                    dBHelper.RollBackTransaction();
            }
            return result;

        }
        public GlobalErrors SaveLOV(ref LOVDynamicModel LOVModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                dBHelper.BeginTransaction();
                result = _surveyManager.SaveLOV(ref LOVModel, dBHelper);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                    dBHelper.CommitTransaction();
                else
                    dBHelper.RollBackTransaction();
            }
            return result;

        }
        public GlobalErrors GetLOVs(ref List<SurveyTemplateModel> LOVs)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SurveyTemplateModel> dBHelper = new DBHelper<SurveyTemplateModel>();
                result = _surveyManager.GetQuestionsValues(ref LOVs, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion
        #region [SurveyPeriod]
        public GlobalErrors GetSurveyPeriods(ref List<SurveyPeriod> surveyPeriods, int surveyId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SurveyPeriod> dBHelper = new DBHelper<SurveyPeriod>();
                result = _surveyManager.GetSurveyPeriods(ref surveyPeriods, dBHelper, surveyId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion
        public GlobalErrors getAllCustomerSurveys(FilterModel filterModel, ref List<SurveyModel> surveys)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<TextLanguage> descriptions = null;
            List<OrganizationModel> organizationsList = new List<OrganizationModel>();

            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                result = _surveyManager.getAllCustomerSurveys(filterModel, ref surveys);

                if (result == GlobalErrors.Success)
                {
                    foreach (SurveyModel survey in surveys)
                    {
                        descriptions = new List<TextLanguage>();
                        result = _surveyManager.GetSurveyLanguages(survey.SurveyId, ref descriptions);
                        if (result != GlobalErrors.Success) break;
                        survey.SurveyNameDescriptionLanguages = descriptions;

                        descriptions = new List<TextLanguage>();
                        result = _surveyManager.GetSurveyLetterHeadLanguages(survey.SurveyId, ref descriptions);
                        if (result != GlobalErrors.Success) break;
                        survey.LetterHeadDescriptionLanguages = descriptions;

                        #region[Organizations]
                        if (result == GlobalErrors.Success)
                        {
                            organizationsList = new List<OrganizationModel>();
                            //if (survey.OrganizationID == -1)
                            //{
                            //    result = _surveyManager.GetAppliedSurveyOrganizations(survey.SurveyId, ref organizationsList);
                            //}
                            //else
                            //{
                            //    result = _surveyManager.GetSurveyOrganization(survey.OrganizationID, ref organizationsList);
                            //}
                            result = _surveyManager.GetAppliedSurveyOrganizations(survey.SurveyId, ref organizationsList);
                            if (result == GlobalErrors.Success && organizationsList != null && organizationsList.Count > 0)
                            {
                                survey.OrganizationsList = organizationsList;
                            }
                        }
                        #endregion

                        survey.IsUsed = _surveyManager.CheckIfSurveyUsed(survey.SurveyId,survey.DCFID,survey.SurveyTypeId,survey.LinkedToProm, dBHelper);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors FillUI(int surveyTypeId, ref object data)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SurveyTemplateModel> dBHelper = new DBHelper<SurveyTemplateModel>();
                //List<SecurityGroupModel> securityGroups = new List<SecurityGroupModel>();
                List<SurveyTemplateModel> fieldGroups = new List<SurveyTemplateModel>();
                //List<FieldSubTypeModel> questionTypeList = new List<FieldSubTypeModel>();
                List<FieldSubTypeModel> questionSubTypeList = new List<FieldSubTypeModel>();
                List<SurveyTemplateModel> questionValuesList = new List<SurveyTemplateModel>();
                List<OrganizationModel> organizationList = new List<OrganizationModel>();
                result = _surveyManager.GetAllFieldGroup(ref fieldGroups, dBHelper);
                //if (result == GlobalErrors.Success)
                //    result = SurveyManager.GetQuestionsType(ref questionTypeList);
                if (result == GlobalErrors.Success)
                    result = _surveyManager.GetQuestionsSubType(surveyTypeId, ref questionSubTypeList);
                if (result == GlobalErrors.Success)
                    result = _surveyManager.GetQuestionsValues(ref questionValuesList, dBHelper);
                if (result == GlobalErrors.Success)
                    result = _masterDataManager.GetOrganizationList(-1, ref organizationList);
                //if (result == GlobalErrors.Success)
                //    result = _employeeManager.getAllSecurityGroups(string.Empty, ref securityGroups);
                data = new
                {
                    fieldGroups = fieldGroups,
                    //questionTypeList = questionTypeList,
                    questionSubTypeList = questionSubTypeList,
                    questionValuesList = questionValuesList,
                    xList = questionValuesList,
                    yList = questionValuesList,
                    organizationList = organizationList,
                    //securityGroups = securityGroups
                };
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteSurvey(int surveyId, int dcfId, int surveyTypeId, bool linkedToPromotion)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                if (_surveyManager.CheckIfSurveyUsed(surveyId,dcfId,surveyTypeId, linkedToPromotion, dBHelper))
                {
                    return GlobalErrors.NotInitialized;
                }
                result = _surveyManager.DeleteSurvey(surveyId, dBHelper);
                if (result == GlobalErrors.Success)
                    dBHelper.CommitTransaction();
                else
                    dBHelper.RollBackTransaction();

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors getFieldGroups(ref List<SurveyTemplateModel> fieldGroups)
        {
            try
            {
                DBHelper<SurveyTemplateModel> dBHelper = new DBHelper<SurveyTemplateModel>();
                return _surveyManager.GetAllFieldGroup(ref fieldGroups, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }
        public GlobalErrors GetQuestionsDepend(int surveyId, int fieldId, ref List<SurveyTemplateModel> questionDependList)
        {
            try
            {
                DBHelper<SurveyTemplateModel> dBHelper = new DBHelper<SurveyTemplateModel>();
                return _surveyManager.GetQuestionsDepend(surveyId, fieldId, ref questionDependList, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }
        public GlobalErrors GetLOVOptions(int LOVID, ref List<LOVModel> LOVOptionsList)
        {
            try
            {
                return _surveyManager.GetLOVOptions(LOVID, ref LOVOptionsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }
        public GlobalErrors AllowDeleteQuestion(int fieldId, int surveyTypeId, ref bool isFieldHasAnswers)
        {
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                return _surveyManager.AllowDeleteQuestion(fieldId, surveyTypeId, ref isFieldHasAnswers, dBHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }

        public GlobalErrors UpdateCustomerSurvey(SurveyModel survey)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                err = _surveyManager.UpdateSurvey(survey, dBHelper);
                if (err == GlobalErrors.Success)
                {
                    err = _surveyManager.DeleteSurveyOrganizaions(survey.SurveyId, dBHelper);
                }
                if (err == GlobalErrors.Success)
                {
                    err = _surveyManager.SaveSurveyOrganizations(survey.SurveyId, survey.OrganizationsList, dBHelper);
                }
                if (err == GlobalErrors.Success)
                {
                    err = _surveyManager.DeleteSurveyLanguage(survey.SurveyId, dBHelper);
                }
                if (err == GlobalErrors.Success || err == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    err = _surveyManager.InsertSurveyLanguage(survey, dBHelper);
                }
                if (err == GlobalErrors.Success)
                {
                    err = _surveyManager.InsertSurveyLetterHeadLanguages(survey, dBHelper);
                }
                if (err == GlobalErrors.Success)
                {
                    err = _surveyManager.UpdateDCFLanguage(survey, dBHelper);
                }

                if (err == GlobalErrors.Success)
                {
                    foreach (int fieldId in survey.DeletedQuestion)
                    {
                        if (fieldId > 0)
                        {
                            err = _surveyManager.DeleteQuestions(fieldId, dBHelper);
                            if (err != GlobalErrors.Success) break;
                        }
                    }
                }
                if (err == GlobalErrors.Success)
                {
                    Dictionary<int, int> NewFieldIDs = new Dictionary<int, int>();
                    foreach (QuestionModel question in survey.Questions)
                    {
                        question.SurveyId = survey.SurveyId;
                        err = _surveyManager.InsertUpdateQuestion(survey.DCFID, question, dBHelper, NewFieldIDs);
                        if (err != GlobalErrors.Success) break;
                    }
                }
                if (survey.SurveyTypeId == SurveyTypes.CustomerSurvey.GetHashCode() || survey.SurveyTypeId == SurveyTypes.CustomerAppSurvey.GetHashCode())
                {
                    if (err == GlobalErrors.Success)
                    {
                        err = _surveyManager.DeleteAppliedCustomers(survey.SurveyId, dBHelper);
                    }
                    if (err == GlobalErrors.Success)
                    {
                        err = InsertAppliedToSurvey(survey, dBHelper);
                    }
                }
                else if (survey.SurveyTypeId == SurveyTypes.EmployeeSurvey.GetHashCode())
                {
                    if (err == GlobalErrors.Success)
                    {
                        err = _surveyManager.DeleteAppliedEmployees(survey.SurveyId, dBHelper);
                    }
                    if (err == GlobalErrors.Success)
                    {
                        err = InsertAppliedEmployeeToSurvey(survey, dBHelper);
                    }
                }
                else if (survey.SurveyTypeId == SurveyTypes.POSSurvey.GetHashCode() || survey.SurveyTypeId == SurveyTypes.POSStockCounting.GetHashCode())
                {
                    if (err == GlobalErrors.Success)
                    {
                        err = _surveyManager.DeleteApplySurveytoDisplayUnit(survey.SurveyId, dBHelper);
                    }
                }
                else if (survey.SurveyTypeId == SurveyTypes.QualityControl.GetHashCode())
                {
                    err = _surveyManager.DeleteQualityControlAppliedData(survey.SurveyId, dBHelper);

                    if (err == GlobalErrors.Success && survey.AppliedInspectors != null && survey.AppliedInspectors.Count > 0)
                    {
                        for (int i = 0; i < survey.AppliedInspectors.Count; i++)
                        {
                            err = _surveyManager.ApplySurveyToInspectors(survey.SurveyId, survey.AppliedInspectors[i].EmployeeId, dBHelper);
                            if (err != GlobalErrors.Success) break;
                        }
                    }
                    if (err == GlobalErrors.Success)
                    {
                        if (survey.AppliedItems != null && survey.AppliedItems.Count > 0)
                        {
                            for (int i = 0; i < survey.AppliedItems.Count; i++)
                            {
                                err = _surveyManager.ApplySurveyToItems(survey.SurveyId, survey.AppliedItems[i].ItemId, dBHelper);
                                if (err != GlobalErrors.Success) break;
                            }
                        }
                        else if (survey.AllItems)
                        {
                            err = _surveyManager.ApplySurveyToItems(survey.SurveyId, -1, dBHelper);
                        }
                    }
                }
                if (err == GlobalErrors.Success)
                    err = _surveyManager.DeleteSurveyPeriodTypes(survey.SurveyId, dBHelper);
                if ((err == GlobalErrors.Success || err == GlobalErrors.SuccessWithZeroRowAffected) && (survey.ListOfPeriods != null && survey.ListOfPeriods.Count >= 0 && survey.SurveyPeriodTypeId != -1) )
                    err = SaveSurveyPeriods(survey, survey.DCFID, survey.SurveyId, dBHelper);
                if (err == GlobalErrors.Success)
                    dBHelper.CommitTransaction();
                else
                    dBHelper.RollBackTransaction();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return err;
        }

        public GlobalErrors saveGroup(string group)
        {
            try
            {
                return _surveyManager.saveGroup(group);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        private GlobalErrors InsertAppliedToSurvey(SurveyModel survey, DBHelper<int> dBHelper)
        {
            GlobalErrors err = GlobalErrors.Success;
            try
            {
                if (survey.AppliedChannels != null && survey.AppliedChannels.Count > 0)
                {
                    foreach (var channel in survey.AppliedChannels)
                    {
                        err = _surveyManager.ApplySurveytoChannel(dBHelper, survey.SurveyId, channel);
                        if (err != GlobalErrors.Success) break;

                    }
                }

                if (err == GlobalErrors.Success)
                {
                    if (survey.AppliedGroups != null && survey.AppliedGroups.Count > 0)
                    {
                        foreach (var group in survey.AppliedGroups)
                        {
                            err = _surveyManager.ApplySurveytoGroup(group, survey.SurveyId, dBHelper);
                            if (err != GlobalErrors.Success) break;
                        }
                    }
                }

                if (err == GlobalErrors.Success)
                {

                    if (survey.AppliedCustomers != null && survey.AppliedCustomers.Count > 0)
                    {
                        foreach (var customer in survey.AppliedCustomers)
                        {
                            err = _surveyManager.ApplySurveytoCustomer(survey.SurveyId, customer.CustomerId, customer.OutletId, dBHelper);

                        }
                    }
                }
                if (err == GlobalErrors.Success && survey.SurveyTypeId != SurveyTypes.EmployeeSurvey.GetHashCode())
                {
                    if (survey.SecurityGroups != null && survey.SecurityGroups.Count > 0)
                    {
                        for (int i = 0; i < survey.SecurityGroups.Count; i++)
                        {
                            if (survey.SecurityGroups[i].SecurityGroupId != -1)
                            {
                                err = _surveyManager.ApplySurveytoSecurityGroup(survey.SurveyId, survey.SecurityGroups[i].SecurityGroupId, dBHelper);
                                if (err != GlobalErrors.Success) break;
                            }
                        }
                    }
                }
                if (survey.SurveyTypeId == SurveyTypes.EmployeeSurvey.GetHashCode())
                {
                    err = InsertAppliedEmployeeToSurvey(survey, dBHelper);
                }
                else if (err == GlobalErrors.Success && survey.SurveyTypeId == SurveyTypes.QualityControl.GetHashCode())
                {
                    if (survey.AppliedInspectors != null && survey.AppliedInspectors.Count > 0)
                    {
                        for (int i = 0; i < survey.AppliedInspectors.Count; i++)
                        {
                            err = _surveyManager.ApplySurveyToInspectors(survey.SurveyId, survey.AppliedInspectors[i].EmployeeId, dBHelper);
                            if (err != GlobalErrors.Success) break;
                        }
                    }

                    if (err == GlobalErrors.Success)
                    {
                        if (survey.AppliedItems != null && survey.AppliedItems.Count > 0)
                        {
                            for (int i = 0; i < survey.AppliedItems.Count; i++)
                            {
                                err = _surveyManager.ApplySurveyToItems(survey.SurveyId, survey.AppliedItems[i].ItemId, dBHelper);
                                if (err != GlobalErrors.Success) break;
                            }
                        }
                        else if(survey.AllItems)
                        {
                            err = _surveyManager.ApplySurveyToItems(survey.SurveyId, -1, dBHelper);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return err;
        }


        private GlobalErrors InsertAppliedEmployeeToSurvey(SurveyModel survey, DBHelper<int> dBHelper)
        {
            GlobalErrors err = GlobalErrors.Success;
            try
            {
                if (survey.AppliedEmployees != null && survey.AppliedEmployees.Count > 0)
                {
                    for (int i = 0; i < survey.AppliedEmployees.Count; i++)
                    {
                        err = _surveyManager.ApplySurveytoEmployee(survey.SurveyId, survey.AppliedEmployees[i].EmployeeId, dBHelper);
                        if (err != GlobalErrors.Success) break;
                    }
                }
                if (err == GlobalErrors.Success)
                {
                    if (survey.SecurityGroups != null && survey.SecurityGroups.Count > 0)
                    {
                        for (int i = 0; i < survey.SecurityGroups.Count; i++)
                        {
                            err = _surveyManager.ApplySurveytoSecurityGroup(survey.SurveyId, survey.SecurityGroups[i].SecurityGroupId, dBHelper);
                            if (err != GlobalErrors.Success) break;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return err;
        }
        public GlobalErrors SaveSurveyPeriods(SurveyModel survey, int maxDCFId, int maxSurveyId, DBHelper<int> dBHelper)
        {
            GlobalErrors err = GlobalErrors.Success;
            try
            {
                DateModel fromDate = survey.ValidFromModel;
                //survey.ListOfPeriods = new List<SurveyPeriod>();
                switch ((SurveyPeriodTypes)survey.SurveyPeriodTypeId)
                {

                    case SurveyPeriodTypes.Custom:
                        {

                            break;
                        }
                    case SurveyPeriodTypes.Daily:
                        {
                            if (fromDate.Year == survey.ValidToModel.Year && fromDate.Month == survey.ValidToModel.Month && fromDate.Day == survey.ValidToModel.Day)
                                survey.ListOfPeriods.Add(new SurveyPeriod(fromDate, survey.ValidToModel));
                            else
                                do
                                {
                                    if (survey.ListOfPeriods == null)
                                    {
                                        survey.ListOfPeriods = new List<SurveyPeriod>();
                                    }
                                    survey.ListOfPeriods.Add(new SurveyPeriod(fromDate, new DateModel(fromDate.Date.AddDays(1))));
                                    fromDate = new DateModel(fromDate.Date.AddDays(1));
                                }
                                while (fromDate.Date.CompareTo(survey.ValidToModel.Date) < 0);
                            break;
                        }
                    case SurveyPeriodTypes.Weekly:
                        {
                            int daysUntilStartOfWeek = (_requestRepository.Configurations.RouteVisitStartDay  - (int)fromDate.Date.DayOfWeek + 6) % 7;//use RouteVisitStartDay instead of #1
                            if (fromDate.Year == survey.ValidToModel.Year && fromDate.Month == survey.ValidToModel.Month && (survey.ValidToModel.Day - fromDate.Day <= 7))
                            {
                                survey.ListOfPeriods.Add(new SurveyPeriod(fromDate, survey.ValidToModel));
                            }
                            else
                            {
                                do
                                {
                                    if (survey.ValidToModel.Date.CompareTo(new DateModel(fromDate.Date.AddDays(7)).Date) < 0)
                                    {
                                        survey.ListOfPeriods.Add(new SurveyPeriod(fromDate, survey.ValidToModel));
                                        break;
                                    }
                                    else
                                    {
                                        survey.ListOfPeriods.Add(new SurveyPeriod(fromDate, new DateModel(fromDate.Date.AddDays(daysUntilStartOfWeek == 0?7: daysUntilStartOfWeek))));
                                        fromDate = new DateModel(fromDate.Date.AddDays(daysUntilStartOfWeek == 0 ? 7 : daysUntilStartOfWeek));
                                        daysUntilStartOfWeek = 7;
                                    }

                                }
                                while (fromDate.Date.CompareTo(survey.ValidToModel.Date) < 0);
                            }
                            if (fromDate.Date.DayOfWeek == (DayOfWeek)1)
                                return GlobalErrors.Success;
                            break;
                        }
                    case SurveyPeriodTypes.Monthly:
                        {
                            if (fromDate.Year == survey.ValidToModel.Year && fromDate.Month == survey.ValidToModel.Month)
                            {
                                survey.ListOfPeriods.Add(new SurveyPeriod(fromDate, survey.ValidToModel));
                            }
                            else
                                do
                                {
                                    survey.ListOfPeriods.Add(new SurveyPeriod(fromDate, new DateModel(fromDate.Date.AddMonths(1))));
                                    fromDate = new DateModel(fromDate.Date.AddMonths(1));
                                }
                                while (fromDate.Date.CompareTo(survey.ValidToModel.Date) < 0);
                            break;
                        }
                    case SurveyPeriodTypes.Yearly:
                        {
                            if (fromDate.Year == survey.ValidToModel.Year)
                            {
                                survey.ListOfPeriods.Add(new SurveyPeriod(fromDate, survey.ValidToModel));
                            }
                            else
                                do
                                {
                                    survey.ListOfPeriods.Add(new SurveyPeriod(fromDate, new DateModel(fromDate.Date.AddYears(1))));
                                    fromDate = new DateModel(fromDate.Date.AddYears(1));
                                }
                                while (fromDate.Date.CompareTo(survey.ValidToModel.Date) < 0);

                            break;
                        }
                }
                if (survey.ListOfPeriods != null && survey.ListOfPeriods.Count > 0)
                {
                    String query = "";
                    foreach (SurveyPeriod period in survey.ListOfPeriods)
                    {
                        if ((SurveyPeriodTypes)survey.SurveyPeriodTypeId == SurveyPeriodTypes.Custom)
                            period.ToDateModel = new DateModel(period.ToDateModel.Date.AddDays(1));
                        err = _surveyManager.SaveSurveyPeriod(maxDCFId, maxSurveyId, period, ref query);
                        if (err == GlobalErrors.Error) break;
                    }
                    if(err == GlobalErrors.Success && !String.IsNullOrEmpty(query))
                    {
                        err = dBHelper.ExecuteNonQuery(query);
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return err;
        }
        public GlobalErrors SaveCustomerSurvey(SurveyModel survey)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                int maxSurveyId = -1;
                int maxDCFId = -1;
                err = SurveyManager.getMaxSurveyID(ref maxSurveyId, dBHelper);
                if (err == GlobalErrors.Success)
                {
                    if (maxSurveyId > 0)
                        survey.SurveyId = maxSurveyId;
                    else
                        survey.SurveyId = 1;
                }

                if (err == GlobalErrors.Success)
                    err = SurveyManager.getMaxDCFID(ref maxDCFId, dBHelper);

                if (err == GlobalErrors.Success)
                {
                    if (maxDCFId > 0)
                        survey.DCFID = maxDCFId;
                    else
                        survey.DCFID = 1;
                }

                if (err == GlobalErrors.Success)
                    err = _surveyManager.InsertSurvey(survey, dBHelper);
                if (err == GlobalErrors.Success)
                    err = _surveyManager.SaveSurveyOrganizations(survey.SurveyId, survey.OrganizationsList, dBHelper);
                if (err == GlobalErrors.Success)
                {
                    err = _surveyManager.InsertSurveyLanguage(survey, dBHelper);
                }
                if (err == GlobalErrors.Success)
                {
                    err = _surveyManager.InsertSurveyLetterHeadLanguages(survey, dBHelper);
                }
                if (err == GlobalErrors.Success)
                {
                    err = _surveyManager.InsertDCF(survey.DCFID, dBHelper);
                }
                if (err == GlobalErrors.Success)
                {
                    err = _surveyManager.InsertDCFLanguage(survey, dBHelper);
                }
                if (err == GlobalErrors.Success)
                {
                    Dictionary<int, int> NewFieldIDs = new Dictionary<int, int>();
                    foreach (QuestionModel question in survey.Questions)
                    {
                        question.SurveyId = survey.SurveyId;
                        err = _surveyManager.InsertUpdateQuestion(survey.DCFID, question, dBHelper, NewFieldIDs);
                        if (err != GlobalErrors.Success) break;
                    }
                }
                if (err == GlobalErrors.Success)
                {
                    err = InsertAppliedToSurvey(survey, dBHelper);
                }
                if (err == GlobalErrors.Success && survey.ListOfPeriods != null && survey.ListOfPeriods.Count >= 0)
                {
                    err = SaveSurveyPeriods(survey, maxDCFId, maxSurveyId, dBHelper);
                }
                if (err == GlobalErrors.Success)
                    dBHelper.CommitTransaction();
                else
                    dBHelper.RollBackTransaction();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return err;
        }

        public GlobalErrors getAppliedList(int surveyId, ref List<CreditReleaseAssignmentModel> applyTo, ref List<SecurityGroupModel> securityGroups)
        {
            try
            {
                return _surveyManager.getAppliedList(surveyId, ref applyTo, ref securityGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors getEmployeesAppliedList(int surveyId, ref List<EmployeeModel> appliedEmployee, ref List<SecurityGroupModel> securityGroups)
        {
            try
            {
                return _surveyManager.getEmployeesAppliedList(surveyId, ref appliedEmployee,ref securityGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }



        public GlobalErrors getSurveyQuestions(int dcfId, ref List<QuestionModel> questions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<TextLanguage> descriptions = null;
            List<TextLanguage> bodyDescriptions = null;
            SurveyActionsTypesModel surveyAction = new SurveyActionsTypesModel();
            List<LOVModel> lovOptions = new List<LOVModel>();
            int actionID = -1;
            try
            {
                result = _surveyManager.getSurveyQuestions(dcfId, ref questions);
                if (result == GlobalErrors.Success)
                {
                    foreach (QuestionModel question in questions)
                    {
                        if (!string.IsNullOrEmpty(question.ActionTypeIdString))
                        {
                            string[] actions = question.ActionTypeIdString.Split(',');
                            foreach (string action in actions)
                            {
                                surveyAction = new SurveyActionsTypesModel();
                                actionID = int.Parse(action.ToString());
                                surveyAction.actionTypeId = actionID;
                                if(actionID == SurveyActionsTypes.SendEmail.GetHashCode())
                                {
                                    surveyAction.actionTypeName = ResourcesManager.TranslateKey(MessagesConstants.Desc_Send_Email, _requestRepository.LanguageId);
                                }
                                else if (actionID == SurveyActionsTypes.SendSystemNotification.GetHashCode())
                                {
                                    surveyAction.actionTypeName = ResourcesManager.TranslateKey(MessagesConstants.Desc_Send_System_Notification, _requestRepository.LanguageId);
                                }
                                else if (actionID == SurveyActionsTypes.MoveItemToGoodOrDamagedWarehouse.GetHashCode())
                                {
                                    surveyAction.actionTypeName = ResourcesManager.TranslateKey(MessagesConstants.Desc_Move_Item_To_Good_Or_Damaged_Warehouse, _requestRepository.LanguageId);
                                }
                                question.ActionTypeId.Add(surveyAction);
                            }
                        }
                        descriptions = new List<TextLanguage>();
                        result = _surveyManager.GeQuestionNameLanguages(question.FieldId, "Name", ref descriptions);
                        if(result == GlobalErrors.Success)
                        {
                            question.QuestionNameDescriptionLanguages = descriptions;
                        }

                        bodyDescriptions = new List<TextLanguage>();
                        result = _surveyManager.GeQuestionNameLanguages(question.FieldId, "Description", ref bodyDescriptions);
                        if (result == GlobalErrors.Success)
                        {
                            question.QuestionBodyDescriptionLanguages = bodyDescriptions;
                        }

                        if (result == GlobalErrors.Success)
                        {
                            if (question.LOVID > -1)
                            {
                                lovOptions = new List<LOVModel>();
                                result = _surveyManager.GetLOVOptions(question.LOVID, ref lovOptions);
                                if(result == GlobalErrors.Success)
                                {
                                    question.QuestionOptions = lovOptions;
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSurveyPeriodTypes(int surveyTypeId, ref List<SurveyPeriodTypeModel> surveyPeriodTypeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _surveyManager.GetSurveyPeriodTypes(surveyTypeId, ref surveyPeriodTypeList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetInspectorSurveys(FilterModel filterModel, ref List<SurveyModel> surveys)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                result = _surveyManager.GetInspectorSurveys(filterModel, ref surveys);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        
        public GlobalErrors GetSurveyData(int surveyId, int dcfid, int warehouseId,int readnigId, int organizationId, bool isClone, ref SurveyModel surveyModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _surveyManager.GetSurveyData(surveyId, dcfid, warehouseId, readnigId,organizationId, isClone, ref surveyModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveQualityControlReading(SurveyReadingModel surveyReadingModel, IHostingEnvironment _hostingEnvironment)
        {
            string itemIDs = string.Empty;
            string errorMessage = "";
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                result = _surveyManager.SaveQualityControlReading(surveyReadingModel, dBHelper);
                if (result == GlobalErrors.Success)
                {
                    itemIDs = string.Join(",", surveyReadingModel.AppliedItems.Select(x => x.ItemId).ToArray());
                    if (surveyReadingModel.Actions != null && surveyReadingModel.Actions.Count > 0)
                    {
                        int readingID = _surveyManager.GetMaxID("ReadingID", "QualityControlReading", dBHelper);
                        if (readingID > -1)
                        {
                            surveyReadingModel.ReadingId = readingID;
                            result = SaveQualityControlWarehouseTransaction(surveyReadingModel, itemIDs, dBHelper);
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = SendActionsEmail(surveyReadingModel, itemIDs, ref errorMessage);
                    }
                }
                if (result == GlobalErrors.Success)
                    dBHelper.CommitTransaction();
                else
                    dBHelper.RollBackTransaction();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveQualityControlWarehouseTransaction(SurveyReadingModel surveyReadingModel, string itemIDsString, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List <ItemPackModel> items = new List<ItemPackModel>();
            try
            {
                if (surveyReadingModel.Actions != null && surveyReadingModel.Actions.Count > 0)
                {
                    #region[Cash related data]
                    int helperId = -1, driverId = -1, supervisorId = -1, salesRepId = -1, salesManagerId = -1;
                    result = _employeeManager.GetEmployeeRelatedStaff(_requestRepository.CurrentOperator.EmployeeId, dbHelper, ref helperId, ref driverId, ref supervisorId, ref salesRepId, ref salesManagerId);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    #endregion

                    #region[Save WH transactions]
                    items = surveyReadingModel.AppliedItems;
                    if (items != null && items.Count > 0)
                    {
                        result = SaveQualityControlWHTransactions(surveyReadingModel, items, supervisorId, helperId, salesManagerId, driverId, salesRepId,  itemIDsString, dbHelper);
                    }
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    #endregion

                    #region [Reserve Stock & Serials]
                    result = _surveyManager.ReserveQCTransactionStockAndSerials(surveyReadingModel, itemIDsString, dbHelper);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    #endregion
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveQualityControlWHTransactions(SurveyReadingModel surveyReadingModel,List<ItemPackModel> items, int supervisorId, int helperId, int salesManagerId, int driverId, int salesRepId, string itemIDsString, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                #region[Cash Document Sequence per divisions]
                List<int> divisionIdsList = items.Select(x => x.DivisionId).Distinct().ToList();
                DBHelper<TransactionDivisionModel> dbHlperForIds = new DBHelper<TransactionDivisionModel>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                List<TransactionDivisionModel> maxIdsPerDivisionList = new List<TransactionDivisionModel>();
                TransactionDivisionModel transDiv = new TransactionDivisionModel();
                #endregion

                #region[Prepare Header string by loop on transactions]
                StringBuilder allValues = new StringBuilder();
                string transValue = string.Empty;
                string maxId = string.Empty;
                int docDivId = -1;
                int transDivId = -1;
                int organizationId = -1;
                
                foreach (int divisionID in divisionIdsList)
                {
                    transDiv = new TransactionDivisionModel();
                    transValue = string.Empty;
                    maxId = string.Empty;
                    docDivId = -1;
                    transDivId = -1;
                    organizationId = -1;
                    if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                    {
                        transDivId = divisionID;
                    }
                    if (_requestRepository.Configurations.ApplyDivisionsOnDocumentSequence)
                    {
                        docDivId = divisionID;
                    }
                    maxId = _documentSequenceManager.GetMaxDocumentSequence(_requestRepository.CurrentOperator.EmployeeId, DocumentTypes.WarhouseTransaction, docDivId);
                    transDiv.DivisionId = divisionID;
                    transDiv.TransactionId = maxId;
                    //if (surveyReadingModel.WarehouseTransactionOperationId == WarehouseTransactionOperation.TransferOut.GetHashCode())
                    //{
                    //    //1. Transfer out
                    //    organizationId = _warehouseManager.GetWarehouseOrganization(surveyReadingModel.WarehouseId != -1 ? surveyReadingModel.WarehouseId : surveyReadingModel.DamagedWarehouseId);
                    //    transValue = _surveyManager.PrepareWarehouseTransactionHeaderString(surveyReadingModel.ReadingId, maxId,surveyReadingModel.WarehouseId != -1 ? surveyReadingModel.WarehouseId : surveyReadingModel.DamagedWarehouseId, transDivId, organizationId, WarehouseTransactionType.OutputVoucher, WarehouseTransactionOperation.TransferOut, supervisorId, helperId, salesManagerId, driverId, salesRepId);
                    //}
                    //else if (surveyReadingModel.WarehouseTransactionOperationId == WarehouseTransactionOperation.Offload.GetHashCode())
                    //{
                    //    //2. Offload
                    //    organizationId = _warehouseManager.GetWarehouseOrganization(surveyReadingModel.VehicleId);
                    //    transValue = _surveyManager.PrepareWarehouseTransactionHeaderString(surveyReadingModel.ReadingId, maxId, surveyReadingModel.VehicleId, transDivId, organizationId, WarehouseTransactionType.TransferOut, WarehouseTransactionOperation.Offload, supervisorId, helperId, salesManagerId, driverId, salesRepId);
                    //}
                    if (!string.IsNullOrEmpty(transValue))
                    {
                        allValues.Append(transValue.Trim() + ",");
                    }
                    if (!maxIdsPerDivisionList.Contains(transDiv))
                        maxIdsPerDivisionList.Add(transDiv);
                }
                #endregion

                #region[Save All WH Headers]
                result = _surveyManager.SaveWarehouseTransactionHeader(allValues.ToString().TrimEnd(','), dbHelper);
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                #endregion

                #region[Update Document sequense according to last saved value per division]
                foreach (TransactionDivisionModel trans in maxIdsPerDivisionList)
                {
                    if (_requestRepository.Configurations.ApplyDivisionsOnDocumentSequence)
                    {
                        docDivId = trans.DivisionId;
                    }
                    result = _documentSequenceManager.UpdateMaxTransactionID(dbHelper, DocumentTypes.WarhouseTransaction, trans.TransactionId, _requestRepository.CurrentOperator.EmployeeId, docDivId);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                }
                #endregion

                #region[Save WH trans Details for all inserted transactions]
                result = _surveyManager.SaveWarehouseTransactionsDetails(surveyReadingModel.ReadingId, itemIDsString, dbHelper);
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SendActionsEmail(SurveyReadingModel surveyReadingModel,string itemIDs, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<string> recieversEmails = new List<string>();
            EmailModel emailModel = new EmailModel();
            List<EmailTemplateModel> emailTempList = new List<EmailTemplateModel>();
            string emailTypeIDs = string.Empty;
            string query = string.Empty;
            string vehicleWarehouse = string.Empty;
            string vehicleWarehouseCodeName = string.Empty;
            List<string> itemCodeNameList = new List<string>();
            string itemCodeName = string.Empty;
            string actionResons = string.Empty;
            string acceptableValueNote = string.Empty;
            int vehicleWarehouseID = -1;
            DataTable dtResultData = new DataTable();
            SurveyHeaderForPDF surveyHeader = new SurveyHeaderForPDF();
            string fileName = string.Empty;
            string direction = string.Empty;
            errorMessage = string.Empty;
            try
            {
                emailTypeIDs = "12,13";
                result = _emailManager.GetEmailTemplatesDetails(emailTypeIDs, ref emailTempList);
                if (result == GlobalErrors.Success && emailTempList != null && emailTempList.Count > 0)
                {
                    if (emailTempList.Any(e => (e.EmailTempId > 0)
                    && (
                    (e.EmailTypeId == 13 && !string.IsNullOrEmpty(e.EmailDestination))
                    ||
                    (e.EmailTypeId == 12 && _surveyManager.GetRecieversEmails(surveyReadingModel, ref recieversEmails) == GlobalErrors.Success
                    && recieversEmails != null && recieversEmails.Count > 0))))
                    {
                        if (_requestRepository.LanguageId == 2)
                        {
                            direction = " dir = 'rtl'";
                        }
                        dtResultData = new DataTable();
                        DataColumn[] dtDataColumns;
                        dtDataColumns = new DataColumn[3];
                        dtDataColumns[0] = new DataColumn("Field", typeof(string));
                        dtDataColumns[1] = new DataColumn("Answer", typeof(string));
                        dtDataColumns[2] = new DataColumn("Acceptable Value", typeof(string));
                        dtResultData.Columns.Add(dtDataColumns[0]);
                        dtResultData.Columns.Add(dtDataColumns[1]);
                        dtResultData.Columns.Add(dtDataColumns[2]);
                        if (surveyReadingModel.WarehouseTransactionOperationId == WarehouseTransactionOperation.Offload.GetHashCode())
                        {
                            vehicleWarehouse = ResourcesManager.TranslateKey(MessagesConstants.Desc_Vehicle, _requestRepository.LanguageId);
                        }
                        else
                        {
                            vehicleWarehouse = ResourcesManager.TranslateKey(MessagesConstants.Desc_Warehouse, _requestRepository.LanguageId);
                        }
                        if (surveyReadingModel.WarehouseId != -1)
                            vehicleWarehouseID = surveyReadingModel.WarehouseId;
                        else if (surveyReadingModel.VehicleId != -1)
                            vehicleWarehouseID = surveyReadingModel.VehicleId;
                        //else if (surveyReadingModel.DamagedWarehouseId != -1)
                        //    vehicleWarehouseID = surveyReadingModel.DamagedWarehouseId;
                        //result = _warehouseManager.GetWarehouseCodeName(vehicleWarehouseID, ref vehicleWarehouseCodeName);
                        if (result == GlobalErrors.Success)
                            result = _itemManager.GetItemsNameAndCode(itemIDs, ref itemCodeNameList);
                        if (result == GlobalErrors.Success)
                        {
                            itemCodeName = string.Format(@"<ol {0}>", direction);
                            foreach (string item in itemCodeNameList)
                            {
                                itemCodeName += string.Format(@"<li {0}> {1} <br></li>", direction, item);
                            }
                            itemCodeName += "</ol>";
                            DataRow Row = null;
                            foreach (SurveyReadingResultModel resultModel in surveyReadingModel.ResultList)
                            {
                                acceptableValueNote = string.Empty;
                                if (!string.IsNullOrEmpty(resultModel.AcceptableValueNote))
                                {
                                    Row = dtResultData.NewRow();
                                    acceptableValueNote = resultModel.AcceptableValueNote.Replace(",", "<br>");
                                    Row["Field"] = resultModel.Field;
                                    Row["Answer"] = resultModel.Answer;
                                    Row["Acceptable Value"] = acceptableValueNote;
                                    dtResultData.Rows.Add(Row);
                                }
                            }
                            actionResons = string.Format(@" <table {3} border=" + 1 + " cellpadding=" + 0 + " cellspacing=" + 0 + " width = " + 500 + ">" +
                                "<tr bgcolor='#ebedf0'>" +
                                "<td><b>{0}</b></td>" +
                                "<td><b>{1}</b></td>" +
                                "<td><b>{2}</b></td></tr>",
                             ResourcesManager.TranslateKey(MessagesConstants.Desc_Question, _requestRepository.LanguageId),
                             ResourcesManager.TranslateKey(MessagesConstants.Desc_Answer, _requestRepository.LanguageId),
                             ResourcesManager.TranslateKey(MessagesConstants.Desc_Value_Acceptable, _requestRepository.LanguageId),
                             direction
                                );
                            for (int loopCount = 0; loopCount < dtResultData.Rows.Count; loopCount++)
                            {
                                actionResons += "<tr><td>" + dtResultData.Rows[loopCount]["Field"] + "</td><td> " + dtResultData.Rows[loopCount]["Answer"] + "</td><td> " + dtResultData.Rows[loopCount]["Acceptable Value"] + "</td> </tr>";
                            }
                            actionResons += "</table>";
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        foreach (EmailTemplateModel emailTemplate in emailTempList)
                        {
                            if (emailTemplate.EmailTypeId == 12 && recieversEmails != null && recieversEmails.Count > 0 && surveyReadingModel.Actions != null && surveyReadingModel.Actions.Count > 0)
                            {
                                if (dtResultData != null && dtResultData.Rows.Count > 0)
                                {
                                    emailTemplate.Body = emailTemplate.Body.Replace("{0}", vehicleWarehouse).Replace("@@", "<br>");
                                    emailTemplate.Body = emailTemplate.Body.Replace("{1}", vehicleWarehouseCodeName).Replace("@@", "<br>");
                                    emailTemplate.Body = emailTemplate.Body.Replace("{2}", itemCodeName).Replace("@@", "<br>");
                                    emailTemplate.Body = emailTemplate.Body.Replace("{3}", actionResons).Replace("@@", "<br>");
                                    foreach (string email in recieversEmails)
                                    {
                                        emailModel = new EmailModel();
                                        emailModel.ToEmail = email;
                                        emailModel.EmailTempId = emailTemplate.EmailTempId;
                                        emailModel.Body = emailTemplate.Body;
                                        emailModel.IsBodyHtml = true;
                                        _emailService.SendEmailAsync(null, emailModel);
                                    }
                                }
                            }
                            if (emailTemplate.EmailTypeId == 13 && !string.IsNullOrEmpty(emailTemplate.EmailDestination) && surveyReadingModel.ResultList != null && surveyReadingModel.ResultList.Count > 0)
                            {
                                surveyHeader = new SurveyHeaderForPDF();
                                surveyHeader.SurveyName = surveyReadingModel.SurveyName;
                                surveyHeader.vehicleWarehouse = vehicleWarehouse;
                                surveyHeader.WarehouseCodeName = vehicleWarehouseCodeName;
                                surveyHeader.EmployeeCodeName = _requestRepository.CurrentOperator.EmployeeCode + '-' + _requestRepository.CurrentOperator.EmployeeName;
                                surveyHeader.ItemCodeName = itemCodeName;
                                emailModel = new EmailModel();
                                emailModel.ToEmail = emailTemplate.EmailDestination;
                                emailModel.EmailTempId = emailTemplate.EmailTempId;
                                emailModel.Body = emailTemplate.Body;
                                emailModel.IsBodyHtml = true;
                                HtmlToPdfDocument pdf = _templateGenerator.HtmlToPDF(surveyReadingModel, surveyHeader, _converter);
                                MemoryStream pdfStream = _templateGenerator.CreateQualityControlsPDF(pdf);
                                fileName = ResourcesManager.TranslateKey(MessagesConstants.Desc_Quality_Control_Report, _requestRepository.LanguageId) + ".pdf";
                                _emailService.SendEmailAsync(null, emailModel, pdfStream, fileName);
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ExecuteCloneSurveyProcedure(int surveyId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _surveyManager.ExecuteCloneSurveyProcedure(surveyId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #region [ECHO]
        public GlobalErrors GetCustomerSurveys(ref List<SurveyModel> surveyList)
        {
            try
            {
                return _surveyManager.GetCustomerSurveyList(ref surveyList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerSurveyAfterSaveOrder(ref SurveyModel survey, ref List<QuestionModel> questionModels, ref List<LOVModel> optionModels)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                List<SurveyModel> surveyList = new List<SurveyModel>();
                survey = new SurveyModel();
                result = _surveyManager.GetCustomerSurveyList(ref surveyList, true);
                if (result == GlobalErrors.Success)
                {
                    if (surveyList.Count > 0)
                    {
                        survey = surveyList[0];
                        questionModels = new List<QuestionModel>();
                        optionModels = new List<LOVModel>();
                        result = GetCustomerSurveyQuestions(survey.SurveyId, ref questionModels, ref optionModels);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }
                else
                {
                    return result;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerSurveyQuestions(int surevyId, ref List<QuestionModel> questions, ref List<LOVModel> questionOption)
        {
            try
            {
                return _surveyManager.GetCustomerSurveyQuestions(surevyId, ref questions, ref questionOption);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveSurveyAnswers(List<AnswerModel> surveyAnswers, string rootPath)
        {
            try
            {
                return _surveyManager.SaveQuestionAnswers(surveyAnswers, rootPath);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        #endregion
        public GlobalErrors GetLinkedToPromotionSurveys(int promotionId, ref List<SurveyModel> surveys)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _surveyManager.GetLinkedToPromotionSurveys(promotionId, ref surveys);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSurveys(int surveyTypeId, ref List<SurveyModel> surveys)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                result = _surveyManager.GetSurveys(surveyTypeId, ref surveys);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #region [Survey Images screens]
        public GlobalErrors GetSurveyCustomerImagesSharedTable(SurveyReportFilterModel filter, bool isExportMode, ref SharedTableResult<SurveyReportModel> surveyImagesList, ref List<dynamic> reportData)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _surveyManager.GetSurveyCustomerImagesSharedTable(filter, isExportMode, ref surveyImagesList, ref reportData);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                surveyImagesList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetSurveyEmployeeImagesSharedTable(SurveyReportFilterModel filter, bool isExportMode, ref SharedTableResult<SurveyReportModel> surveyImagesList, ref List<dynamic> reportData)
        {
            try
            {
                if (filter.CustomListFilter.Page < 0)
                    filter.CustomListFilter.Page = 0;
                if (filter.CustomListFilter.PageSize <= 0)
                    filter.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    filter.CustomListFilter.SearchFilter = filter.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                return _surveyManager.GetSurveyEmployeeImagesSharedTable(filter, isExportMode, ref surveyImagesList, ref reportData);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                surveyImagesList = null;
                return GlobalErrors.Error;
            }
        }
        #endregion
    }
}
