﻿using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Reflection;

namespace Sonic.Web.Service
{
    public class InvoicesLocationsService
    {
        private readonly IRequestRepository _requestRepository;
        private readonly TransactionManager _transactionManager;

        public InvoicesLocationsService(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _transactionManager = new TransactionManager(_requestRepository);
        }
        public GlobalErrors GetInvoicesLocations(GeneralFilter filter, ref List<TransactionModel> invoicesLocations)
        {
            try
            {
                return _transactionManager.GetInvoicesLocations(filter, ref invoicesLocations);
            }
            catch (Exception ex)
            {
                invoicesLocations = null;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
    }
}