﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using Sonic.Web.ZATCAXML.ZATCA.HelperContracts;
using System.Net.Http;
using Sonic.Web.ZATCAXML.ZATCA.APIHelper;
using System.Net.Http.Headers;
using System.Net;
using System.IO;
using Newtonsoft.Json;
using System.Xml;

namespace Sonic.Web.ZATCAXML.ZATCA.BLL
{
	[Guid("D9CE5E9C-9E42-4948-8833-42D4CDC2DA17")]
	[ClassInterface(ClassInterfaceType.AutoDual)]
	public class ApiRequestLogic
	{
		private bool _useZATCAProductionEnvironment = false;
		//public ApiRequestLogic() { }
		public ApiRequestLogic(bool useZATCAProductionEnvironment) 
		{
			_useZATCAProductionEnvironment = useZATCAProductionEnvironment;
		}

		public ComplianceCsrResponse GetComplianceCSIDAPI(string OTP, string CSR, string Directorypath)
		{
			ComplianceCsrResponse response = new ComplianceCsrResponse();
			try
			{
				using (var client = new HttpClient())
				{
					client.BaseAddress = new Uri(GlobalVariables.BaseUrl);
					client.DefaultRequestHeaders.Accept.Clear();
					client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));
					client.DefaultRequestHeaders.Add("OTP", OTP);
					client.DefaultRequestHeaders.Add("Accept-Version", "V2");
					//ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12 | SecurityProtocolType.Tls11 | SecurityProtocolType.Tls;

					ServicePointManager.SecurityProtocol = (SecurityProtocolType)768 | (SecurityProtocolType)3072 | SecurityProtocolType.Tls;
					//POST Method
					if (string.IsNullOrEmpty(CSR))
						CSR = File.ReadAllText(Directorypath + "\\cert\\csr.csr");
					var data = new StringContent(JsonConvert.SerializeObject(new { csr = Utility.ToBase64Encode(CSR) }), Encoding.UTF8, "application/json");

					HttpResponseMessage responsePost = client.PostAsync(GlobalVariables.ComplianceCsidEndpoint(_useZATCAProductionEnvironment), data).Result;
					var reponsestr = responsePost.Content.ReadAsStringAsync().Result;
					if (responsePost.IsSuccessStatusCode)
					{
						response = JsonConvert.DeserializeObject<ComplianceCsrResponse>(reponsestr);
					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.BadRequest)
					{
						//CertificatesErrorsResponse error = new CertificatesErrorsResponse();
						//error = JsonConvert.DeserializeObject<CertificatesErrorsResponse>(reponsestr);
						//foreach (var err in error.Errors)
						//{
						//	response.ErrorMessage = err.Code + " : " + err.Message + "\n";
						//}
						ErrorModel error = new ErrorModel();
						error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
						response.ErrorMessage = error.Code + " : " + error.Message;
					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.NotAcceptable)
					{
						//ErrorModel error = new ErrorModel();
						//error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
						response.ErrorMessage = "This Version is not supported or not provided in the header.";

					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.InternalServerError)
					{
						ErrorModel error = new ErrorModel();
						error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
						response.ErrorMessage = error.Code + " : " + error.Message;
					}
					else
					{
						response.ErrorMessage = "Error in ComplianceCsr API";
					}

				}
			}
			catch (Exception ex)
			{
				response.ErrorMessage = ex.Message;

			}
			return response;
		}
		public ComplianceCsrResponse GetComplianceCSIDAPI(string OTP, string CSR)
		{
			ComplianceCsrResponse response = new ComplianceCsrResponse();
			try
			{
				using (var client = new HttpClient())
				{
					client.BaseAddress = new Uri(GlobalVariables.BaseUrl);
					client.DefaultRequestHeaders.Accept.Clear();
					client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));
					client.DefaultRequestHeaders.Add("OTP", OTP);
					client.DefaultRequestHeaders.Add("Accept-Version", "V2");
					//ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12 | SecurityProtocolType.Tls11 | SecurityProtocolType.Tls;

					ServicePointManager.SecurityProtocol = (SecurityProtocolType)768 | (SecurityProtocolType)3072 | SecurityProtocolType.Tls;
					//POST Method
					if (string.IsNullOrEmpty(CSR))
					{
						response.ErrorMessage = "Please Enter csr";
						return response;
					}
					var data = new StringContent(JsonConvert.SerializeObject(new { csr = Utility.ToBase64Encode(CSR) }), Encoding.UTF8, "application/json");

					HttpResponseMessage responsePost = client.PostAsync(GlobalVariables.ComplianceCsidEndpoint(_useZATCAProductionEnvironment), data).Result;
					var reponsestr = responsePost.Content.ReadAsStringAsync().Result;
					if (responsePost.IsSuccessStatusCode)
					{
						response = JsonConvert.DeserializeObject<ComplianceCsrResponse>(reponsestr);

					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.BadRequest)
					{
						//CertificatesErrorsResponse error = new CertificatesErrorsResponse();
						//error = JsonConvert.DeserializeObject<CertificatesErrorsResponse>(reponsestr);
						//foreach (var err in error.Errors)
						//{
						//	response.ErrorMessage = err.Code + " : " + err.Message + "\n";
						//}
						ErrorModel error = new ErrorModel();
						error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
						response.ErrorMessage = error.Code + " : " + error.Message;
					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.NotAcceptable)
					{
						//ErrorModel error = new ErrorModel();
						//error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
						response.ErrorMessage = "This Version is not supported or not provided in the header.";

					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.InternalServerError)
					{
						ErrorModel error = new ErrorModel();
						error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
						response.ErrorMessage = error.Code + " : " + error.Message;
					}
					else
					{
						response.ErrorMessage = "Error in ComplianceCsr API";
					}

				}
			}
			catch (Exception ex)
			{
				response.ErrorMessage = ex.Message;

			}
			return response;
		}
		public ComplianceCsrResponse GetProductionCSIDAPI(string Compliance_request_id, string username, string password)
		{
			ComplianceCsrResponse response = new ComplianceCsrResponse();
			using (var client = new HttpClient())
			{
				client.BaseAddress = new Uri(GlobalVariables.BaseUrl);
				client.DefaultRequestHeaders.Accept.Clear();
				client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));
				client.DefaultRequestHeaders.Add("Accept-Version", "V2");
				var credentials = Convert.ToBase64String(Encoding.ASCII.GetBytes(username + ":" + password));
				client.DefaultRequestHeaders.TryAddWithoutValidation("Authorization", $"Basic {credentials}");
				ServicePointManager.SecurityProtocol = (SecurityProtocolType)768 | (SecurityProtocolType)3072 | SecurityProtocolType.Tls;

				//POST Method
				var data = new StringContent(JsonConvert.SerializeObject(new { compliance_request_id = Compliance_request_id }), Encoding.UTF8, "application/json");

				HttpResponseMessage responsePost = client.PostAsync(GlobalVariables.ProdCsidEndpoint(_useZATCAProductionEnvironment), data).Result;
				var reponsestr = responsePost.Content.ReadAsStringAsync().Result;

				if (responsePost.IsSuccessStatusCode)
				{
					response = JsonConvert.DeserializeObject<ComplianceCsrResponse>(reponsestr);
					return response;
				}
				else if (responsePost.StatusCode == System.Net.HttpStatusCode.BadRequest)
				{
					//CertificatesErrorsResponse error = new CertificatesErrorsResponse();
					//error = JsonConvert.DeserializeObject<CertificatesErrorsResponse>(reponsestr);
					//foreach(var err in error.Errors)
					//{
					//	response.ErrorMessage = err.Code + " : " + err.Message + "\n";
					//}
					ErrorModel error = new ErrorModel();
					error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
					response.ErrorMessage = error.Code + " : " + error.Message;
				}
				else if (responsePost.StatusCode == System.Net.HttpStatusCode.Unauthorized)
				{

					response.ErrorMessage = "Unauthorized Production CSID API";
				}
				else if (responsePost.StatusCode == System.Net.HttpStatusCode.NotAcceptable)
				{
					//ErrorModel error = new ErrorModel();
					//error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
					response.ErrorMessage = "This Version is not supported or not provided in the header.";

				}
				else if (responsePost.StatusCode == System.Net.HttpStatusCode.InternalServerError)
				{
					ErrorModel error = new ErrorModel();
					error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
					response.ErrorMessage = error.Code + " : " + error.Message;
				}
				else
				{
					response.ErrorMessage = "Error in ProductionCSID API";
				}
				return null;

			}
		}
		public InvoiceReportingResponse CallReportingAPI(string userName, string password, InvoiceReportingRequest inv)
		{
			using (var client = new HttpClient())
			{
				client.BaseAddress = new Uri(GlobalVariables.BaseUrl);
				client.DefaultRequestHeaders.Accept.Clear();
				client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));

				client.DefaultRequestHeaders.Add("accept-language", "en");
				client.DefaultRequestHeaders.Add("Clearance-Status", "0");
				client.DefaultRequestHeaders.Add("Accept-Version", "V2");
				var credentials = Convert.ToBase64String(Encoding.ASCII.GetBytes(userName + ":" + password));
				//for live
				client.DefaultRequestHeaders.TryAddWithoutValidation("Authorization", $"Basic {credentials}");
				//for test 
				//client.DefaultRequestHeaders.Add("Authorization", "Basic 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");
				ServicePointManager.SecurityProtocol = (SecurityProtocolType)768 | (SecurityProtocolType)3072 | SecurityProtocolType.Tls;

				//POST Method
				var data = new StringContent(JsonConvert.SerializeObject(inv), Encoding.UTF8, "application/json");

				HttpResponseMessage responsePost = client.PostAsync(GlobalVariables.InvoiceReportingEndPoint(_useZATCAProductionEnvironment), data).Result;

				string reponsestr = responsePost.Content.ReadAsStringAsync().Result;
				InvoiceReportingResponse result = new InvoiceReportingResponse();
				if (responsePost.IsSuccessStatusCode)
				{
					result = JsonConvert.DeserializeObject<InvoiceReportingResponse>(reponsestr);
					result.IsSuccess = true;
				}
				if (responsePost.StatusCode == System.Net.HttpStatusCode.Accepted)
				{
					result = JsonConvert.DeserializeObject<InvoiceReportingResponse>(reponsestr);
					foreach (var warning in result.validationResults.WarningMessages)
					{
						result.WarningMessage = warning.Code + " : " + warning.Message + "\n";
					}
					result.IsSuccess = true;
				}
				if (responsePost.StatusCode == System.Net.HttpStatusCode.BadRequest)
				{
					result = JsonConvert.DeserializeObject<InvoiceReportingResponse>(reponsestr);
				}
				if (responsePost.StatusCode == System.Net.HttpStatusCode.Unauthorized)
				{
					result = new InvoiceReportingResponse();
					result.ErrorMessage = "NotAcceptable";
					result.ReportingStatus = "Unauthorized";
				}
				if (responsePost.StatusCode == System.Net.HttpStatusCode.NotAcceptable)
				{
					result = new InvoiceReportingResponse();
					result.ErrorMessage = "NotAcceptable";
					result.ReportingStatus = "NotAcceptable";
				}
				if (responsePost.StatusCode == System.Net.HttpStatusCode.InternalServerError)
				{
					result = new InvoiceReportingResponse();
					ErrorModel error = new ErrorModel();
					error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
					result.ErrorMessage = error.Code + " : " + error.Message;
					result.ReportingStatus = "InternalServerError";
				}
				return result;

			}

		}
		public InvoiceClearanceResponse CallClearanceAPI(string userName, string password, InvoiceReportingRequest inv)
		{
			using (var client = new HttpClient())
			{
				client.BaseAddress = new Uri(GlobalVariables.BaseUrl);
				client.DefaultRequestHeaders.Accept.Clear();
				client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));

				client.DefaultRequestHeaders.Add("accept-language", "en");
				client.DefaultRequestHeaders.Add("Clearance-Status", "1");
				client.DefaultRequestHeaders.Add("Accept-Version", "V2");
				var credentials = Convert.ToBase64String(Encoding.ASCII.GetBytes(userName + ":" + password));
				//for live
				client.DefaultRequestHeaders.TryAddWithoutValidation("Authorization", $"Basic {credentials}");
				//for test 
				//client.DefaultRequestHeaders.Add("Authorization", "Basic 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");
				ServicePointManager.SecurityProtocol = (SecurityProtocolType)768 | (SecurityProtocolType)3072 | SecurityProtocolType.Tls;

				//POST Method
				var data = new StringContent(JsonConvert.SerializeObject(inv), Encoding.UTF8, "application/json");

				HttpResponseMessage responsePost = client.PostAsync(GlobalVariables.InvoiceClearanceEndPoint(_useZATCAProductionEnvironment), data).Result;

				string reponsestr = responsePost.Content.ReadAsStringAsync().Result;
				InvoiceClearanceResponse result = new InvoiceClearanceResponse();
				if (responsePost.IsSuccessStatusCode)
				{
					result = JsonConvert.DeserializeObject<InvoiceClearanceResponse>(reponsestr);
					var doc = new XmlDocument();
					if (!string.IsNullOrEmpty(result.ClearedInvoice))
					{
						doc.PreserveWhitespace = true;
						result.SingedXML = Utility.Base64Dencode(result.ClearedInvoice);
						doc.LoadXml(result.SingedXML);
						result.QRCode = Utility.GetNodeInnerText(doc, SettingsParams.QR_CODE_XPATH);
					}
					result.IsSuccess = true;
				}
				if (responsePost.StatusCode == System.Net.HttpStatusCode.Accepted)
				{
					result = JsonConvert.DeserializeObject<InvoiceClearanceResponse>(reponsestr);
					foreach (var warning in result.validationResults.WarningMessages)
					{
						result.WarningMessage = warning.Code + " : " + warning.Message + "\n";
					}
					var doc = new XmlDocument();
					if (!string.IsNullOrEmpty(result.ClearedInvoice))
					{
						doc.PreserveWhitespace = true;
						result.SingedXML = Utility.Base64Dencode(result.ClearedInvoice);
						doc.LoadXml(result.SingedXML);
						result.QRCode = Utility.GetNodeInnerText(doc, SettingsParams.QR_CODE_XPATH);
					}
					result.IsSuccess = true;
				}
				if (responsePost.StatusCode == System.Net.HttpStatusCode.BadRequest)
				{
					result = JsonConvert.DeserializeObject<InvoiceClearanceResponse>(reponsestr);
				}
				if (responsePost.StatusCode == System.Net.HttpStatusCode.Unauthorized)
				{
					result = new InvoiceClearanceResponse();
					result.ErrorMessage = "Unauthorized in Clearance API";
					result.ClearanceStatus = "Unauthorized";
				}
				if (responsePost.StatusCode == System.Net.HttpStatusCode.NotAcceptable)
				{
					result = new InvoiceClearanceResponse();
					result.ErrorMessage = "This Version is not supported or not provided in the header.";
					result.ClearanceStatus = "NotAcceptable";
				}
				if (responsePost.StatusCode == System.Net.HttpStatusCode.InternalServerError)
				{
					result = new InvoiceClearanceResponse();
					ErrorModel error = new ErrorModel();
					error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
					result.ErrorMessage = error.Code + " : " + error.Message;
					result.ClearanceStatus = "InternalServerError";
				}
				return result;

			}

		}

		public InvoiceReportingResponse CallComplianceInvoiceAPI(string userName, string password, InvoiceReportingRequest inv)
		{
			InvoiceReportingResponse response = new InvoiceReportingResponse();
			try
			{
				using (var client = new HttpClient())
				{
					client.BaseAddress = new Uri(GlobalVariables.BaseUrl);
					client.DefaultRequestHeaders.Accept.Clear();
					client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));

					client.DefaultRequestHeaders.Add("accept-language", "en");
					client.DefaultRequestHeaders.Add("Accept-Version", "V2");
					var credentials = Convert.ToBase64String(Encoding.ASCII.GetBytes(userName + ":" + password));
					//for live
					client.DefaultRequestHeaders.TryAddWithoutValidation("Authorization", $"Basic {credentials}");
					//for test 
					//client.DefaultRequestHeaders.Add("Authorization", "Basic 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");
					ServicePointManager.SecurityProtocol = (SecurityProtocolType)768 | (SecurityProtocolType)3072 | SecurityProtocolType.Tls;

					//POST Method
					var data = new StringContent(JsonConvert.SerializeObject(inv), Encoding.UTF8, "application/json");

					HttpResponseMessage responsePost = client.PostAsync(GlobalVariables.ComplianceInvoiceEndPoint(_useZATCAProductionEnvironment), data).Result;

					string reponsestr = responsePost.Content.ReadAsStringAsync().Result;
					response.IsSuccess = false;
					if (responsePost.IsSuccessStatusCode)
					{
						response = JsonConvert.DeserializeObject<InvoiceReportingResponse>(reponsestr);
						response.IsSuccess = true;
					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.Accepted)
					{
						response = JsonConvert.DeserializeObject<InvoiceReportingResponse>(reponsestr);
					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.BadRequest)
					{
						response = JsonConvert.DeserializeObject<InvoiceReportingResponse>(reponsestr);
						if (response.validationResults.ErrorMessages != null && response.validationResults.ErrorMessages.Count > 0)
						{
							foreach (var error in response.validationResults.ErrorMessages)
							{
								response.ErrorMessage = error.Message + "\n";
							}
						}

					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.Unauthorized)
					{
						response.ReportingStatus = "Unauthorized";
						response.ErrorMessage = "Unauthorized in Compliance Invoice API";
					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.NotAcceptable)
					{
						response.ReportingStatus = "NotAcceptable";
						response.ErrorMessage = "This Version is not supported or not provided in the header.";
					}
					else if (responsePost.StatusCode == System.Net.HttpStatusCode.InternalServerError)
					{
						ErrorModel error = new ErrorModel();
						error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
						response.ErrorMessage = error.Code + " : " + error.Message;
						response.ReportingStatus = "InternalServerError";
					}
					else
					{
						response.ErrorMessage = "Error in Compliance Invoice API";
					}
				}
			}
			catch (Exception ex)
			{

				response.ErrorMessage = ex.Message;
			}

			return response;
		}
		public string GetEncodedCertificate(string certpath)
		{
			string certtext = File.ReadAllText(certpath);

			string certbase64 = Utility.ToBase64Encode(certtext);

			return certbase64;
		}

		public string ToBase64Encode(string toEncode)
		{
			byte[] toEncodeAsBytes = Encoding.UTF8.GetBytes(toEncode);
			return Convert.ToBase64String(toEncodeAsBytes);
		}
	}
}
