﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.ZATCAXML.ZATCA.BLL
{
    public static class ErrorMessageHelper
    {
        public static Dictionary<string, ZatcaErrorMessage> ErrorMessage()
        {
            Dictionary<string, ZatcaErrorMessage> errors = new Dictionary<string, ZatcaErrorMessage>();
            errors.Add("BR-02", new ZatcaErrorMessage { ID = 1, Code = "BR-02", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن تحتوي الفاتورة على رقم الفاتورة (BT-1).", MessageEN = @"An Invoice shall have an Invoice number (BT-1)." });
            errors.Add("BR-03", new ZatcaErrorMessage { ID = 2, Code = "BR-03", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون للفاتورة تاريخ إصدار الفاتورة (BT-2).", MessageEN = @"An Invoice shall have an Invoice issue date (BT-2)." });
            errors.Add("BR-04", new ZatcaErrorMessage { ID = 3, Code = "BR-04", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن تحتوي الفاتورة على رمز نوع الفاتورة (BT-3).", MessageEN = @"An Invoice shall have an Invoice type code (BT-3)." });
            errors.Add("BR-05", new ZatcaErrorMessage { ID = 4, Code = "BR-05", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن تحتوي الفاتورة على رمز عملة الفاتورة (BT-5).", MessageEN = @"An Invoice shall have an Invoice currency code (BT-5)." });
            errors.Add("BR-06", new ZatcaErrorMessage { ID = 5, Code = "BR-06", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن تحتوي الفاتورة على اسم البائع (BT-27).", MessageEN = @"An Invoice shall contain the Seller name (BT-27)." });
            errors.Add("BR-08", new ZatcaErrorMessage { ID = 6, Code = "BR-08", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن تحتوي الفاتورة على العنوان البريدي للبائع (BG-5).", MessageEN = @"An Invoice shall contain the Seller postal address (BG-5)." });
            errors.Add("BR-09", new ZatcaErrorMessage { ID = 7, Code = "BR-09", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يحتوي العنوان البريدي للبائع (BG-5) على رمز بلد البائع (BT-40).", MessageEN = @"The Seller postal address (BG-5) shall contain a Seller country code (BT-40)." });
            errors.Add("BR-10", new ZatcaErrorMessage { ID = 8, Code = "BR-10", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن تحتوي الفاتورة على العنوان البريدي للمشتري (BG-8). لا ينطبق على الفواتير الضريبية المبسطة والإشعارات الدائنة وسندات الخصم المرتبطة بها (KSA-2 ، الموضع 1 و 2 = 02).", MessageEN = @"An Invoice shall contain the Buyer postal address (BG-8). Not applicable for simplified tax invoices and associated credit notes and debit notes (KSA-2, position 1 and 2 = 02)." });
            errors.Add("BR-13", new ZatcaErrorMessage { ID = 9, Code = "BR-13", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن تحتوي الفاتورة على إجمالي مبلغ الفاتورة بدون ضريبة القيمة المضافة (BT-109).", MessageEN = @"An Invoice shall have the Invoice total amount without VAT (BT-109)." });
            errors.Add("BR-14", new ZatcaErrorMessage { ID = 10, Code = "BR-14", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن تحتوي الفاتورة على إجمالي مبلغ الفاتورة مع ضريبة القيمة المضافة (BT-112).", MessageEN = @"An Invoice shall have the Invoice total amount with VAT (BT-112)." });
            errors.Add("BR-15", new ZatcaErrorMessage { ID = 11, Code = "BR-15", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون للفاتورة المبلغ المستحق للدفع (BT-115).", MessageEN = @"An Invoice shall have the Amount due for payment (BT-115)." });
            errors.Add("BR-16", new ZatcaErrorMessage { ID = 12, Code = "BR-16", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن تحتوي الفاتورة على سطر فاتورة واحد على الأقل (BG-25)", MessageEN = @"An Invoice shall have at least one Invoice line (BG-25)" });
            errors.Add("BR-21", new ZatcaErrorMessage { ID = 13, Code = "BR-21", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون لكل بند فاتورة (BG-25) معرف سطر فاتورة (BT-126).", MessageEN = @"Each Invoice line (BG-25) shall have an Invoice line identifier (BT-126)." });
            errors.Add("BR-22", new ZatcaErrorMessage { ID = 14, Code = "BR-22", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون لكل بند فاتورة (BG-25) كمية مفوتر بها (BT-129).", MessageEN = @"Each Invoice line (BG-25) shall have an Invoiced quantity (BT-129)." });
            errors.Add("BR-24", new ZatcaErrorMessage { ID = 15, Code = "BR-24", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون لكل بند فاتورة (BG-25) صافي مبلغ سطر الفاتورة (BT-131).", MessageEN = @"Each Invoice line (BG-25) shall have an Invoice line net amount (BT-131)." });
            errors.Add("BR-25", new ZatcaErrorMessage { ID = 16, Code = "BR-25", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يحتوي كل سطر فاتورة (BG-25) على اسم العنصر (BT-153).", MessageEN = @"Each Invoice line (BG-25) shall contain the Item name (BT-153)." });
            errors.Add("BR-26", new ZatcaErrorMessage { ID = 17, Code = "BR-26", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يحتوي كل بند فاتورة (BG-25) على صافي سعر البند (BT-146).", MessageEN = @"Each Invoice line (BG-25) shall contain the Item net price (BT-146)." });
            errors.Add("BR-31", new ZatcaErrorMessage { ID = 18, Code = "BR-31", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون لكل بدل مستوى مستند (BG-20) مبلغ بدل مستوى المستند (BT-92).", MessageEN = @"Each Document level allowance (BG-20) shall have a Document level allowance amount (BT-92)." });
            errors.Add("BR-32", new ZatcaErrorMessage { ID = 19, Code = "BR-32", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون لكل بدل على مستوى المستند (BG-20) رمز فئة ضريبة القيمة المضافة (BT-95) بدل مستوى المستند.", MessageEN = @"Each Document level allowance (BG-20) shall have a Document level allowance VAT category code (BT-95)." });
            errors.Add("BR-41", new ZatcaErrorMessage { ID = 20, Code = "BR-41", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون لكل بدل بند فاتورة (BG-27) مبلغ مخصص لبند الفاتورة (BT- 136).", MessageEN = @"Each Invoice line allowance (BG-27) shall have an Invoice line allowance amount (BT- 136)." });
            errors.Add("BR-45", new ZatcaErrorMessage { ID = 21, Code = "BR-45", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون لكل تصنيف لضريبة القيمة المضافة (BG-23) مبلغ خاضع للضريبة لفئة ضريبة القيمة المضافة (BT-116).", MessageEN = @"Each VAT breakdown (BG-23) shall have a VAT category taxable amount (BT-116)." });
            errors.Add("BR-46", new ZatcaErrorMessage { ID = 22, Code = "BR-46", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون لكل تصنيف لضريبة القيمة المضافة (BG-23) مبلغ ضريبة فئة ضريبة القيمة المضافة (BT-117).", MessageEN = @"Each VAT breakdown (BG-23) shall have a VAT category tax amount (BT-117)." });
            errors.Add("BR-47", new ZatcaErrorMessage { ID = 23, Code = "BR-47", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب تحديد كل تصنيف لضريبة القيمة المضافة (BG-23) من خلال رمز فئة ضريبة القيمة المضافة (BT- 118).", MessageEN = @"Each VAT breakdown (BG-23) shall be defined through a VAT category code (BT- 118)." });
            errors.Add("BR-48", new ZatcaErrorMessage { ID = 24, Code = "BR-48", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يكون لكل تصنيف لضريبة القيمة المضافة (BG-23) معدل فئة ضريبة القيمة المضافة (BT-119) ، إلا إذا كانت الفاتورة لا تخضع لضريبة القيمة المضافة.", MessageEN = @"Each VAT breakdown (BG-23) shall have a VAT category rate (BT-119), except if the Invoice is not subject to VAT." });
            errors.Add("BR-49", new ZatcaErrorMessage { ID = 25, Code = "BR-49", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن تحدد تعليمات الدفع (BG-16) رمز نوع وسيلة الدفع (BT-81).", MessageEN = @"A Payment instruction (BG-16) shall specify the Payment means type code (BT-81)." });
            errors.Add("BR-53", new ZatcaErrorMessage { ID = 26, Code = "BR-53", BusinessRules = @"integrity constraints (BR)", MessageAR = @"إذا كان رمز عملة محاسبة ضريبة القيمة المضافة (BT-6) موجودًا ، فسيتم توفير إجمالي مبلغ ضريبة القيمة المضافة للفاتورة بعملة المحاسبة (BT-111).", MessageEN = @"If the VAT accounting currency code (BT-6) is present, then the Invoice total VAT amount in accounting currency (BT-111) shall be provided." });
            errors.Add("BR-55", new ZatcaErrorMessage { ID = 27, Code = "BR-55", BusinessRules = @"integrity constraints (BR)", MessageAR = @"يجب أن يحتوي كل مرجع فاتورة سابق (BG-3) على مرجع فاتورة سابق (BT-25).", MessageEN = @"Each Preceding Invoice reference (BG-3) shall contain a Preceding Invoice reference (BT-25)." });
            errors.Add("BR-CO-04", new ZatcaErrorMessage { ID = 28, Code = "BR-CO-04", BusinessRules = @"conditions (BR-CO)", MessageAR = @"يجب تصنيف كل سطر فاتورة (BG-25) برمز فئة ضريبة القيمة المضافة للبند المفوتر (BT-151).", MessageEN = @"Each Invoice line (BG-25) shall be categorized with an Invoiced item VAT category code (BT-151)." });
            errors.Add("BR-CO-10", new ZatcaErrorMessage { ID = 29, Code = "BR-CO-10", BusinessRules = @"conditions (BR-CO)", MessageAR = @"مجموع صافي مبلغ بند الفاتورة (BT-106) = صافي مبلغ بند الفاتورة (BT-131).", MessageEN = @"Sum of Invoice line net amount (BT-106)= ? Invoice line net amount (BT-131)." });
            errors.Add("BR-CO-11", new ZatcaErrorMessage { ID = 30, Code = "BR-CO-11", BusinessRules = @"conditions (BR-CO)", MessageAR = @"مجموع البدلات على مستوى المستند (BT-107) = ? مبلغ بدل مستوى المستند (BT-92).", MessageEN = @"Sum of allowances on document level (BT-107) = ? Document level allowance amount (BT-92)." });
            errors.Add("BR-CO-13", new ZatcaErrorMessage { ID = 31, Code = "BR-CO-13", BusinessRules = @"conditions (BR-CO)", MessageAR = @"إجمالي مبلغ الفاتورة بدون ضريبة القيمة المضافة (BT- 109) = صافي مبلغ سطر الفاتورة (BT-131) - مجموع المخصصات على مستوى المستند (BT-107)", MessageEN = @"Invoice total amount without VAT (BT- 109) = ? Invoice line net amount (BT-131)- Sum of allowances on document level (BT-107)" });
            errors.Add("BR-CO-14", new ZatcaErrorMessage { ID = 32, Code = "BR-CO-14", BusinessRules = @"conditions (BR-CO)", MessageAR = @"إجمالي مبلغ ضريبة القيمة المضافة للفاتورة (BT-110) = ? مبلغ ضريبة فئة ضريبة القيمة المضافة (BT-117).", MessageEN = @"Invoice total VAT amount (BT-110) = ?VAT category tax amount (BT-117)." });
            errors.Add("BR-CO-15", new ZatcaErrorMessage { ID = 33, Code = "BR-CO-15", BusinessRules = @"conditions (BR-CO)", MessageAR = @"إجمالي مبلغ الفاتورة مع ضريبة القيمة المضافة (BT-112) = إجمالي مبلغ الفاتورة بدون ضريبة القيمة المضافة (BT-109) + إجمالي مبلغ الفاتورة لضريبة القيمة المضافة (BT-110).", MessageEN = @"Invoice total amount with VAT (BT-112) = Invoice total amount without VAT (BT-109) + Invoice total VAT amount (BT-110)." });
            errors.Add("BR-CO-16", new ZatcaErrorMessage { ID = 34, Code = "BR-CO-16", BusinessRules = @"conditions (BR-CO)", MessageAR = @"المبلغ المستحق للدفع (BT-115) = إجمالي مبلغ الفاتورة مع ضريبة القيمة المضافة (BT-112) - المبلغ المدفوع (BT-113)", MessageEN = @"Amount due for payment (BT-115) = Invoice total amount with VAT (BT-112) -Paid amount (BT-113)" });
            errors.Add("BR-CO-17", new ZatcaErrorMessage { ID = 35, Code = "BR-CO-17", BusinessRules = @"conditions (BR-CO)", MessageAR = @"مبلغ ضريبة فئة ضريبة القيمة المضافة (BT-117) = المبلغ الخاضع للضريبة لفئة ضريبة القيمة المضافة (BT-116) × (معدل فئة ضريبة القيمة المضافة (BT-119) / 100) ، مقربًا إلى رقمين عشريين.", MessageEN = @"VAT category tax amount (BT-117) = VAT category taxable amount (BT-116) x (VAT category rate (BT-119) / 100), rounded to two decimals." });
            errors.Add("BR-CO-18", new ZatcaErrorMessage { ID = 36, Code = "BR-CO-18", BusinessRules = @"conditions (BR-CO)", MessageAR = @"يجب أن تحتوي الفاتورة على مجموعة تصنيف واحدة على الأقل لضريبة القيمة المضافة (BG-23).", MessageEN = @"An Invoice shall at least have one VAT breakdown group (BG-23)." });
            errors.Add("BR-S-06", new ZatcaErrorMessage { ID = 37, Code = "BR-S-06", BusinessRules = @"VAT standard and reduced rate (BR-S)", MessageAR = @"في بدل مستوى المستند (BG-20) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-95) بدل مستوى المستند 'قياسيًا مُقدرًا' ، يجب أن يكون معدل ضريبة القيمة المضافة (BT-96) بدل مستوى المستند أكبر من الصفر.", MessageEN = @"In a Document level allowance (BG-20) where the Document level allowance VAT category code (BT-95) is 'Standard rated' the Document level allowance VAT rate (BT-96) shall be greater than zero." });
            errors.Add("BR-S-09", new ZatcaErrorMessage { ID = 38, Code = "BR-S-09", BusinessRules = @"VAT standard and reduced rate (BR-S)", MessageAR = @"يجب أن يساوي مبلغ ضريبة فئة ضريبة القيمة المضافة (BT-117) في تصنيف ضريبة القيمة المضافة (BG-23) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-118) 'قياسيًا' مبلغًا خاضعًا للضريبة لفئة ضريبة القيمة المضافة (BT-116) مضروبًا في فئة ضريبة القيمة المضافة معدل (BT-119) / 100) ، مقربًا إلى رقمين عشريين.", MessageEN = @"The VAT category tax amount (BT-117) in a VAT breakdown (BG-23) where VAT category code (BT-118) is 'Standard rated' shall equal the VAT category taxable amount (BT-116) multiplied by the VAT category rate (BT-119) /100), rounded to two decimals." });
            errors.Add("BR-S-10", new ZatcaErrorMessage { ID = 39, Code = "BR-S-10", BusinessRules = @"VAT standard and reduced rate (BR-S)", MessageAR = @"يجب ألا يكون لتفصيل ضريبة القيمة المضافة (BG-23) مع رمز فئة ضريبة القيمة المضافة (BT-118) 'المعدل القياسي' رمز سبب الإعفاء من ضريبة القيمة المضافة (BT-121) أو نص سبب الإعفاء من ضريبة القيمة المضافة (BT-120).", MessageEN = @"A VAT breakdown (BG-23) with VAT Category code (BT-118) 'Standard rate' shall not have a VAT exemption reason code (BT-121) or VAT exemption reason text (BT-120)." });
            errors.Add("BR-Z-01", new ZatcaErrorMessage { ID = 40, Code = "BR-Z-01", BusinessRules = @"VAT zero rate (BR-Z)", MessageAR = @"الفاتورة التي تحتوي على بند فاتورة (BG-25) ، بدل مستوى المستند (BG-20) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-151 أو BT-95) 'معدل صفر' يجب أن يحتوي في تصنيف ضريبة القيمة المضافة (BG- 23) رمز فئة ضريبة القيمة المضافة واحد بالضبط (BT-118) يساوي 'خاضع للضريبة بنسبة الصفر'.", MessageEN = @"An Invoice that contains an Invoice line (BG-25), a Document level allowance (BG-20) where the VAT category code (BT-151 or BT-95) is 'Zero rated' shall contain in the VAT breakdown (BG- 23) exactly one VAT category code (BT-118) equal with 'Zero rated'." });
            errors.Add("BR-Z-05", new ZatcaErrorMessage { ID = 41, Code = "BR-Z-05", BusinessRules = @"VAT zero rate (BR-Z)", MessageAR = @"في سطر الفاتورة (BG-25) حيث يكون رمز فئة ضريبة القيمة المضافة للبند المفوتر (BT-151) 'بدون تصنيف' ، يجب أن يكون معدل ضريبة القيمة المضافة للبند المفوتر (BT-152) 0 (صفر).", MessageEN = @"In an Invoice line (BG-25) where the Invoiced item VAT category code (BT-151) is 'Zero rated' the Invoiced item VAT rate (BT-152) shall be 0 (zero)." });
            errors.Add("BR-Z-06", new ZatcaErrorMessage { ID = 42, Code = "BR-Z-06", BusinessRules = @"VAT zero rate (BR-Z)", MessageAR = @"في بدل مستوى المستند (BG-20) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-95) بدل مستوى المستند 'معدل صفر' ، يجب أن يكون معدل ضريبة القيمة المضافة (BT-96) على مستوى المستند 0 (صفر).", MessageEN = @"In a Document level allowance (BG-20) where the Document level allowance VAT category code (BT-95) is 'Zero rated' the Document level allowance VAT rate (BT-96) shall be 0 (zero)." });
            errors.Add("BR-Z-09", new ZatcaErrorMessage { ID = 43, Code = "BR-Z-09", BusinessRules = @"VAT zero rate (BR-Z)", MessageAR = @"يجب أن يساوي مبلغ ضريبة فئة ضريبة القيمة المضافة (BT-117) في تصنيف ضريبة القيمة المضافة (BG-23) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-118) 'خاضعًا للصفر' 0 (صفر).", MessageEN = @"The VAT category tax amount (BT-117) in a VAT breakdown (BG-23) where VAT category code (BT-118) is 'Zero rated' shall equal 0 (zero)." });
            errors.Add("BR-E-01", new ZatcaErrorMessage { ID = 44, Code = "BR-E-01", BusinessRules = @" Exempted from VAT (BR-E)", MessageAR = @"الفاتورة التي تحتوي على بند فاتورة (BG-25) ، بدل مستوى المستند (BG-20) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-151 أو BT-95) 'معفي من ضريبة القيمة المضافة' يجب أن يحتوي بالضبط على تقسيم واحد لضريبة القيمة المضافة (BG) -23) برمز فئة ضريبة القيمة المضافة (BT-118) يساوي 'معفى من ضريبة القيمة المضافة'.", MessageEN = @"An Invoice that contains an Invoice line (BG-25), a Document level allowance (BG-20) where the VAT category code (BT-151 or BT-95) is 'Exempt from VAT' shall contain exactly one VAT breakdown (BG-23) with the VAT category code (BT-118) equal to 'Exempt from VAT'." });
            errors.Add("BR-E-05", new ZatcaErrorMessage { ID = 45, Code = "BR-E-05", BusinessRules = @" Exempted from VAT (BR-E)", MessageAR = @"في سطر الفاتورة (BG-25) حيث يكون رمز فئة ضريبة القيمة المضافة للبند المفوتر (BT-151) 'معفي من ضريبة القيمة المضافة' ، يجب أن يكون معدل ضريبة القيمة المضافة للبند المفوتر (BT-152) 0 (صفر).", MessageEN = @"In an Invoice line (BG-25) where the Invoiced item VAT category code (BT-151) is 'Exempt from VAT', the Invoiced item VAT rate (BT-152) shall be 0 (zero)." });
            errors.Add("BR-E-06", new ZatcaErrorMessage { ID = 46, Code = "BR-E-06", BusinessRules = @" Exempted from VAT (BR-E)", MessageAR = @"في بدل مستوى المستند (BG-20) حيث رمز فئة ضريبة القيمة المضافة بدل مستوى المستند (BT-95) ' معفاة من ضريبة القيمة المضافة ، يجب أن يكون معدل ضريبة القيمة المضافة (BT-96) بدل مستوى المستند 0 (صفر).'", MessageEN = @"'In a Document level allowance (BG-20) where the Document level allowance VAT category code" });
            errors.Add("BR-E-09", new ZatcaErrorMessage { ID = 47, Code = "BR-E-09", BusinessRules = @" Exempted from VAT (BR-E)", MessageAR = @"مبلغ ضريبة فئة ضريبة القيمة المضافة (BT-117) في تصنيف ضريبة القيمة المضافة (BG-23) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-118) يساوي 'معفي من ضريبة القيمة المضافة' يجب أن يساوي 0 (صفر).", MessageEN = @"The VAT category tax amount (BT-117) In a VAT breakdown (BG-23) where the VAT category code (BT-118) equals 'Exempt from VAT' shall equal 0 (zero)." });
            errors.Add("BR-E-10", new ZatcaErrorMessage { ID = 48, Code = "BR-E-10", BusinessRules = @" Exempted from VAT (BR-E)", MessageAR = @"يجب أن يكون لتفصيل ضريبة القيمة المضافة (BG-23) مع رمز فئة ضريبة القيمة المضافة (BT-118) 'معفى من ضريبة القيمة المضافة' رمز سبب الإعفاء من ضريبة القيمة المضافة (BT-121) أو نص سبب الإعفاء من ضريبة القيمة المضافة (BT-120).", MessageEN = @"A VAT breakdown (BG-23) with VAT Category code (BT-118) 'Exempt from VAT' shall have a VAT exemption reason code (BT-121) or a VAT exemption reason text (BT-120)." });
            errors.Add("BR-O-01", new ZatcaErrorMessage { ID = 49, Code = "BR-O-01", BusinessRules = @"Not subject to VAT (BR-O)", MessageAR = @"يجب أن تحتوي الفاتورة التي تحتوي على بند فاتورة (BG-25) ، وبدل مستوى المستند (BG-20) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-151 أو BT-95) 'لا يخضع لضريبة القيمة المضافة' ، على مجموعة تصنيف واحدة بالضبط لضريبة القيمة المضافة (BG-23) برمز فئة ضريبة القيمة المضافة (BT-118) يساوي 'غير خاضع لضريبة القيمة المضافة'.", MessageEN = @"An Invoice that contains an Invoice line (BG-25), a Document level allowance (BG-20) where the VAT category code (BT-151 or BT-95) is 'Not subject to VAT' shall contain exactly one VAT breakdown group (BG-23) with the VAT category code (BT-118) equal to 'Not subject to VAT'." });
            errors.Add("BR-O-05", new ZatcaErrorMessage { ID = 50, Code = "BR-O-05", BusinessRules = @"Not subject to VAT (BR-O)", MessageAR = @"يجب ألا يحتوي سطر الفاتورة (BG-25) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-151) 'لا يخضع لضريبة القيمة المضافة' على معدل ضريبة القيمة المضافة للبند المفوتر (BT-152).", MessageEN = @"An Invoice line (BG-25) where the VAT category code (BT-151) is 'Not subject to VAT' shall not contain an Invoiced item VAT rate (BT-152)." });
            errors.Add("BR-O-06", new ZatcaErrorMessage { ID = 51, Code = "BR-O-06", BusinessRules = @"Not subject to VAT (BR-O)", MessageAR = @"لا يحتوي بدل مستوى المستند (BG-20) حيث رمز فئة ضريبة القيمة المضافة (BT-95) 'لا يخضع لضريبة القيمة المضافة' على بدل مستوى المستند معدل ضريبة القيمة المضافة (BT-96).", MessageEN = @"A Document level allowance (BG-20) where VAT category code (BT-95) is 'Not subject to VAT' shall not contain a Document level allowance VAT rate (BT-96)." });
            errors.Add("BR-O-09", new ZatcaErrorMessage { ID = 53, Code = "BR-O-09", BusinessRules = @"Not subject to VAT (BR-O)", MessageAR = @"يجب أن يكون مبلغ ضريبة فئة ضريبة القيمة المضافة (BT-117) في تصنيف ضريبة القيمة المضافة (BG-23) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-118) 'غير خاضع لضريبة القيمة المضافة' 0 (صفر).", MessageEN = @"The VAT category tax amount (BT-117) in a VAT breakdown (BG-23) where the VAT category code (BT-118) is 'Not subject to VAT' shall be 0 (zero)." });
            errors.Add("BR-CL-01", new ZatcaErrorMessage { ID = 56, Code = "BR-CL-01", BusinessRules = @"Code lists (BR-CL)", MessageAR = @"يجب ترميز رمز نوع المستند بواسطة قوائم الرموز المتعلقة بالفاتورة وإشعار الدائن الخاصة بـ UNTDID 1001.", MessageEN = @"The document type code MUST be coded by the invoice and credit note related code lists of UNTDID 1001." });
            errors.Add("BR-CL-03", new ZatcaErrorMessage { ID = 57, Code = "BR-CL-03", BusinessRules = @"Code lists (BR-CL)", MessageAR = @"يجب تشفير معرف العملة باستخدام قائمة رموز ISO 4217 alpha-3", MessageEN = @"currencyID MUST be coded using ISO code list 4217 alpha-3" });
            errors.Add("BR-CL-04", new ZatcaErrorMessage { ID = 58, Code = "BR-CL-04", BusinessRules = @"Code lists (BR-CL)", MessageAR = @"يجب ترميز رمز عملة الفاتورة باستخدام قائمة رموز ISO 4217 alpha-3", MessageEN = @"Invoice currency code MUST be coded using ISO code list 4217 alpha-3" });
            errors.Add("BR-O-08", new ZatcaErrorMessage { ID = 52, Code = "BR-O-08", BusinessRules = @"Not subject to VAT (BR-O)", MessageAR = @"في تصنيف ضريبة القيمة المضافة (BG-23) حيث يكون رمز فئة ضريبة القيمة المضافة (BT-118) 'لا يخضع لضريبة القيمة المضافة' ، يجب أن يساوي مبلغ فئة ضريبة القيمة المضافة الخاضع للضريبة (BT-116) مجموع صافي مبالغ سطر الفاتورة (BT- 131) مطروحًا منه مجموع مبالغ مخصصات مستوى المستند (BT-92) حيث تكون رموز فئة ضريبة القيمة المضافة (BT-151 ، BT-95) 'غير خاضعة لضريبة القيمة المضافة'.", MessageEN = @"In a VAT breakdown (BG-23) where the VAT category code (BT-118) is ' Not subject to VAT' the VAT category taxable amount (BT-116) shall equal the sum of Invoice line net amounts (BT- 131) minus the sum of Document level allowance amounts (BT-92) where the VAT category codes (BT-151, BT-95) are 'Not subject to VAT'." });
            errors.Add("BR-O-10", new ZatcaErrorMessage { ID = 54, Code = "BR-O-10", BusinessRules = @"Not subject to VAT (BR-O)", MessageAR = @"يجب أن يكون لتفصيل ضريبة القيمة المضافة (BG-23) مع رمز فئة ضريبة القيمة المضافة (BT-118) 'غير خاضع لضريبة القيمة المضافة' رمز سبب الإعفاء من ضريبة القيمة المضافة (BT-121) ، مما يعني 'غير خاضع لضريبة القيمة المضافة' أو نص سبب الإعفاء من ضريبة القيمة المضافة ( BT-120) 'غير خاضع لضريبة القيمة المضافة' (أو ما يعادله من نص قياسي بلغة أخرى).", MessageEN = @"A VAT breakdown (BG-23) with VAT Category code (BT-118) ' Not subject to VAT' shall have a VAT exemption reason code (BT-121), meaning ' Not subject to VAT' or a VAT exemption reason text (BT-120) ' Not subject to VAT' (or the equivalent standard text in another language)." });
            errors.Add("BR-O-13", new ZatcaErrorMessage { ID = 55, Code = "BR-O-13", BusinessRules = @"Not subject to VAT (BR-O)", MessageAR = @"الفاتورة التي تحتوي على مجموعة تصنيف ضريبة القيمة المضافة (BG-23) مع رمز فئة ضريبة القيمة المضافة (BT-118) 'لا تخضع لضريبة القيمة المضافة' لا يجب أن تحتوي على مخصصات مستوى المستند (BG-20) حيث رمز فئة ضريبة القيمة المضافة بدل مستوى المستند (BT- 95) 'لا تخضع لضريبة القيمة المضافة'.", MessageEN = @"An Invoice that contains a VAT breakdown group (BG-23) with a VAT category code (BT-118) 'Not subject to VAT' shall not contain Document level allowances (BG-20) where Document level allowance VAT category code (BT-95) is not 'Not subject to VAT'." });
            errors.Add("BR-CL-05", new ZatcaErrorMessage { ID = 59, Code = "BR-CL-05", BusinessRules = @"Code lists (BR-CL)", MessageAR = @"يجب ترميز رمز العملة الضريبية باستخدام قائمة رموز ISO 4217 alpha-3", MessageEN = @"Tax currency code MUST be coded using ISO code list 4217 alpha-3" });
            errors.Add("BR-CL-14", new ZatcaErrorMessage { ID = 60, Code = "BR-CL-14", BusinessRules = @"Code lists (BR-CL)", MessageAR = @"يجب ترميز رموز البلدان في الفاتورة باستخدام قائمة رموز ISO 3166-1", MessageEN = @"Country codes in an invoice MUST be coded using ISO code list 3166-1" });
            errors.Add("BR-CL-16", new ZatcaErrorMessage { ID = 61, Code = "BR-CL-16", BusinessRules = @"Code lists (BR-CL)", MessageAR = @"الدفع يعني في الفاتورة يجب أن يتم ترميزها باستخدام قائمة كود UNCL4461", MessageEN = @"Payment means in an invoice MUST be coded using UNCL4461 code list" });
            errors.Add("BR-CL-18", new ZatcaErrorMessage { ID = 62, Code = "BR-CL-18", BusinessRules = @"Code lists (BR-CL)", MessageAR = @"يجب ترميز فئات ضريبة الفاتورة باستخدام قائمة رموز UNCL5305", MessageEN = @"Invoice tax categories MUST be coded using UNCL5305 code list" });
            errors.Add("BR-DEC-01", new ZatcaErrorMessage { ID = 63, Code = "BR-DEC-01", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"العدد الأقصى المسموح به من الكسور العشرية لمبلغ بدل مستوى المستند (BT-92) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Document level allowance amount (BT-92) is 2." });
            errors.Add("BR-DEC-02", new ZatcaErrorMessage { ID = 64, Code = "BR-DEC-02", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"العدد الأقصى المسموح به من الكسور العشرية للمبلغ الأساسي المسموح به على مستوى المستند (BT-93) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Document level allowance base amount (BT-93) is 2." });
            errors.Add("BR-DEC-09", new ZatcaErrorMessage { ID = 65, Code = "BR-DEC-09", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"الحد الأقصى المسموح به لعدد الكسور العشرية لصافي مبلغ سطر مجموع الفاتورة (BT-106) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Sum of Invoice line net amount (BT-106) is 2." });
            errors.Add("BR-DEC-10", new ZatcaErrorMessage { ID = 66, Code = "BR-DEC-10", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"العدد الأقصى المسموح به من الكسور العشرية لمجموع البدلات على مستوى المستند (BT- 107) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Sum of allowances on document level (BT- 107) is 2." });
            errors.Add("BR-DEC-12", new ZatcaErrorMessage { ID = 67, Code = "BR-DEC-12", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"الحد الأقصى المسموح به لعدد الكسور العشرية للمبلغ الإجمالي للفاتورة بدون ضريبة القيمة المضافة (BT-109) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Invoice total amount without VAT (BT-109) is 2." });
            errors.Add("BR-DEC-13", new ZatcaErrorMessage { ID = 68, Code = "BR-DEC-13", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"الحد الأقصى المسموح به لعدد الكسور العشرية لإجمالي مبلغ ضريبة القيمة المضافة (BT-110) للفاتورة هو 2.", MessageEN = @"The allowed maximum number of decimals for the Invoice total VAT amount (BT-110) is 2." });
            errors.Add("BR-DEC-14", new ZatcaErrorMessage { ID = 69, Code = "BR-DEC-14", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"الحد الأقصى المسموح به لعدد الكسور العشرية للمبلغ الإجمالي للفاتورة مع ضريبة القيمة المضافة (BT-112) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Invoice total amount with VAT (BT-112) is 2." });
            errors.Add("BR-DEC-15", new ZatcaErrorMessage { ID = 70, Code = "BR-DEC-15", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"الحد الأقصى المسموح به لعدد الكسور العشرية لإجمالي مبلغ ضريبة القيمة المضافة في الفاتورة بعملة المحاسبة (BT-111) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Invoice total VAT amount in accounting currency (BT-111) is 2." });
            errors.Add("BR-DEC-16", new ZatcaErrorMessage { ID = 71, Code = "BR-DEC-16", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"العدد الأقصى المسموح به من الكسور العشرية للمبلغ المدفوع (BT-113) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Paid amount (BT-113) is 2." });
            errors.Add("BR-DEC-18", new ZatcaErrorMessage { ID = 72, Code = "BR-DEC-18", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"العدد الأقصى المسموح به من الكسور العشرية للمبلغ المستحق للدفع (BT-115) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Amount due for payment (BT-115) is 2." });
            errors.Add("BR-DEC-19", new ZatcaErrorMessage { ID = 73, Code = "BR-DEC-19", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"الحد الأقصى المسموح به لعدد الكسور العشرية لمبلغ ضريبة القيمة المضافة الخاضع للضريبة (BT-116) هو 2.", MessageEN = @"The allowed maximum number of decimals for the VAT category taxable amount (BT-116) is 2." });
            errors.Add("BR-DEC-20", new ZatcaErrorMessage { ID = 74, Code = "BR-DEC-20", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"الحد الأقصى لعدد الكسور العشرية المسموح به لمبلغ ضريبة فئة ضريبة القيمة المضافة (BT-117) هو 2.", MessageEN = @"The allowed maximum number of decimals for the VAT category tax amount (BT-117) is 2." });
            errors.Add("BR-DEC-23", new ZatcaErrorMessage { ID = 75, Code = "BR-DEC-23", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"الحد الأقصى المسموح به لعدد الكسور العشرية لصافي مبلغ بند الفاتورة (BT-131) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Invoice line net amount (BT-131) is 2." });
            errors.Add("BR-DEC-24", new ZatcaErrorMessage { ID = 76, Code = "BR-DEC-24", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"الحد الأقصى المسموح به لعدد الكسور العشرية لمبلغ مخصص بند الفاتورة (BT-136) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Invoice line allowance amount (BT-136) is 2." });
            errors.Add("BR-DEC-25", new ZatcaErrorMessage { ID = 77, Code = "BR-DEC-25", BusinessRules = @"Decimals (BR-DEC)", MessageAR = @"الحد الأقصى المسموح به من الكسور العشرية للمبلغ الأساسي بدل بند الفاتورة (BT- 137) هو 2.", MessageEN = @"The allowed maximum number of decimals for the Invoice line allowance base amount (BT- 137) is 2." });
            errors.Add("BR-KSA-03", new ZatcaErrorMessage { ID = 78, Code = "BR-KSA-03", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن تحتوي الفاتورة على معرف فريد ('UUID') (KSA-1) يقدمه الجهاز الذي أصدر المستند (معرف رسالة فريد لعملية التبادل). يجب أن تحتوي هذه القيمة على أحرف وأرقام وشرطات فقط. (ملاحظة: في نظام التشغيل Windows ، تتم الإشارة إلى UUIDs بالمصطلح GUID.)", MessageEN = @"The invoice must contain a unique identifier (“UUID”) (KSA-1) given by the machine that issued the document (unique message identifier for interchange process). This value must contain only letters, digits, and dashes. (Note: In Windows OS UUIDs are referred to by the term GUID.)" });
            errors.Add("BR-KSA-04", new ZatcaErrorMessage { ID = 79, Code = "BR-KSA-04", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون تاريخ إصدار المستند (BT-2) أقل من التاريخ الحالي أو مساويًا له.", MessageEN = @"The document issue date (BT-2) must be less or equal to the current date." });
            errors.Add("BR-KSA-05", new ZatcaErrorMessage { ID = 80, Code = "BR-KSA-05", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون رمز نوع الفاتورة (BT-3) مساويًا لقيمة واحدة من المجموعة الفرعية لقائمة رموز UN / CEFACT 1001 ، D.16B المتفق عليها للفواتير الإلكترونية في المملكة العربية السعودية.", MessageEN = @"The invoice type code (BT-3) must be equal to one of value from the subset of UN/CEFACT code list 1001, D.16B agreed for KSA electronic invoices." });
            errors.Add("BR-KSA-07", new ZatcaErrorMessage { ID = 82, Code = "BR-KSA-07", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"غير مسموح بالفوترة الذاتية (KSA-2 ، الموضع 7 لا يمكن أن يكون '1') لفواتير التصدير (KSA-2 ، الموضع 5 = 1).", MessageEN = @"Self-billing is not allowed (KSA-2, position 7 cannot be '1') for export invoices (KSA-2, position 5 = 1)." });
            errors.Add("BR-KSA-06", new ZatcaErrorMessage { ID = 81, Code = "BR-KSA-06", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون رمز معاملة الفاتورة (KSA-2) موجودًا وأن يحترم الهيكل التالي : 
NNPNESB حيث NN (الموضعان 1 و 2) = نوع الفاتورة الفرعي:
- 01 للفاتورة الضريبية
- 02 لفاتورة ضريبية مبسطة
P (الموضع 3) = معاملة فاتورة لطرف ثالث ، 0 للخطأ ، 1 لصحيح N (الموضع 4) = معاملة الفاتورة الاسمية ، 0 للخطأ ، 1 لصحيح E (الموضع 5) = تصدير معاملة الفاتورة ، 0 للخطأ ، 1 لصحيح S (الموضع 6) = ملخص معاملة الفاتورة ، 0 للخطأ ، 1 لصحيح B (الموضع 7) = الفاتورة الذاتية", MessageEN = @"'The invoice transaction code (KSA-2) must exist and respect the following structure:NNPNESB where NN (positions 1 and 2) = invoice subtype:" });
            errors.Add("BR-KSA-08", new ZatcaErrorMessage { ID = 83, Code = "BR-KSA-08", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون تعريف البائع (BT-29) موجودًا مرة واحدة فقط مع أحد معرفات المخطط (BT-29-1) (CRN ، MOM ، MLS ، SAG ، OTH) ويجب أن يحتوي فقط على أحرف أبجدية رقمية.
- رقم السجل التجاري مع 'CRN' كمعرف المخطط
- رخصة مومرا مع 'MOM' كمعرف مخطط
- رخصة MLSD مع 'MLS' كمعرف مخطط
- رخصة Sagia مع 'SAG' كمخطط ID
- التطوير التنظيمي الآخر مع 'OTH' 'كمعرف مخطط
في حالة وجود عدة معرفات ، يجب إدخال أحد المعرفات أعلاه باتباع التسلسل المحدد أعلاه", MessageEN = @"'The seller identification (BT-29) must exist only once with one of the scheme ID (BT-29-1) (CRN, MOM, MLS, SAG, OTH) and must contain only alphanumeric characters." });
            errors.Add("BR-KSA-09", new ZatcaErrorMessage { ID = 84, Code = "BR-KSA-09", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يحتوي عنوان البائع على اسم الشارع (BT-35) ورقم المبنى (KSA-17) والرمز البريدي (BT-38) والمدينة (BT-37) والمقاطعة (KSA-3) ورمز البلد (BT-40).", MessageEN = @"Seller address must contain street name (BT-35), building number (KSA-17), postal code (BT-38), city (BT-37), District (KSA-3), country code (BT-40)." });
            errors.Add("BR-KSA-10", new ZatcaErrorMessage { ID = 85, Code = "BR-KSA-10", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يحتوي عنوان المشتري على شارع (BT-50) ، ومدينة (BT-52) ، ورمز بريدي (BT-53) ، ورمز البلد (BT- 55). لا تنطبق هذه القاعدة على الفواتير الضريبية المبسطة والإشعارات الدائنة وسندات الخصم المرتبطة بها (KSA-2 ، الموضع 1 و 2 = 02).", MessageEN = @"Buyer address must contain a street (BT-50), city (BT-52), postal code (BT-53), country code (BT- 55). This rule does not apply on the simplified tax invoices and associated credit notes and debit notes (KSA-2, position 1 and 2 = 02)." });
            errors.Add("BR-KSA-14", new ZatcaErrorMessage { ID = 86, Code = "BR-KSA-14", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون تعريف المشتري (BT-46) موجودًا مرة واحدة فقط مع أحد معرفات المخطط (BT-46-1) (NAT ، IQA ، PAS ، CRN ، MOM ، MLS ، SAG ،GCC، OTH) ويجب أن تحتوي على أحرف أبجدية رقمية فقط.
- رقم التعريف الضريبي '' TIN '' كمعرف مخطط
- رقم السجل التجاري مع 'CRN' كمعرف المخطط
- رخصة مومرا مع 'MOM' كمعرف مخطط
- رخصة MLSD مع 'MLS' كمعرف مخطط
- 700 رقم مع '700' كمخطط معرف
- رخصة Sagia مع 'SAG' كمخطط ID
- الرقم القومي مع 'NAT' كمعرف مخطط
- رقم تعريف مجلس التعاون الخليجي مع 'GCC' كمخطط ID
- رقم الإقامة مع 'IQA' كمخطط ID
- معرف جواز السفر مع 'PAS' 'مخطط ID
- معرّف آخر بـ 'OTH' كمعرّف مخطط
في حالة وجود عدة معرفات ، يجب إدخال أحد المعرفات أعلاه باتباع التسلسل المحدد أعلاه ", MessageEN = @"'The buyer identification (BT-46) must exist only once with one of the scheme ID (BT-46-1) (NAT, IQA, PAS, CRN, MOM, MLS, SAG,GCC, OTH) and must contain only alphanumeric characters." });
            errors.Add("BR-KSA-15", new ZatcaErrorMessage { ID = 87, Code = "BR-KSA-15", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن تحتوي الفاتورة الضريبية ((رمز نوع الفاتورة (BT-30) = 388) & (رمز معاملة الفاتورة (KSA-2) على '01' كأول رقمين)) تاريخ التوريد (KSA-5).", MessageEN = @"The tax invoice ((invoice type code (BT-30) = 388) & (invoice transaction code (KSA-2) has “01” as first 2 digits)) must contain the supply date (KSA-5)." });
            errors.Add("BR-KSA-16", new ZatcaErrorMessage { ID = 88, Code = "BR-KSA-16", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يعني الدفع أن الرمز (BT-81) في فاتورة موجود ، ثم يجب أن يحتوي على إحدى القيم من مجموعة فرعية من قائمة رموز UNTDID 4461.", MessageEN = @"Payment means code (BT-81) in an invoice exist, then it must contain one of the values from subset of UNTDID 4461 code list." });
            errors.Add("BR-KSA-17", new ZatcaErrorMessage { ID = 89, Code = "BR-KSA-17", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يحتوي إشعار الخصم والائتمان (رمز نوع الفاتورة (BT-3) يساوي 383 أو 381) على السبب (KSA-10) لإصدار نوع الفاتورة هذا.", MessageEN = @"Debit and credit note (invoice type code (BT-3) is equal to 383 or 381) must contain the reason (KSA-10) for this invoice type issuing." });
            errors.Add("BR-KSA-18", new ZatcaErrorMessage { ID = 90, Code = "BR-KSA-18", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يحتوي رمز فئة ضريبة القيمة المضافة على إحدى القيم (S ، Z ، E ، O).", MessageEN = @"VAT category code must contain one of the values (S, Z, E, O)." });
            errors.Add("BR-KSA-25", new ZatcaErrorMessage { ID = 91, Code = "BR-KSA-25", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كانت فاتورة ضريبية مبسطة أو إشعار دائن مرتبط أو إشعار خصم (KSA-2 ، الموضع 1 و 2 = 02) ورمز سبب الإعفاء الضريبي (BT-121) يساوي VATEX-SA-EDU أو VATEX- SA-HEA ، ثم اسم المشتري (BT-44) إلزامي.", MessageEN = @"If it is a simplified tax invoice or an associated credit note or a debit note (KSA-2, position 1 and 2 =  02) and the tax exemption reason code (BT-121) is equal with VATEX-SA-EDU or VATEX-SA-HEA, then buyer name (BT-44) is mandatory." });
            errors.Add("BR-KSA-26", new ZatcaErrorMessage { ID = 92, Code = "BR-KSA-26", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كانت الفاتورة تحتوي على تجزئة الفاتورة السابقة (KSA-13) ، فيجب أن تكون هذه التجزئة بتشفير base64 باستخدام SHA256.
يجب حساب التجزئة باستخدام الطريقة التالية كما هو موضح في ds: كتلة التحويلات في مواصفات فاتورة XML:
1. قم بإزالة كتلة <Invoice> <ext: UBLExtensi ons />
2. قم بإزالة كتلة <invoice> <cac: DocumentReference /> إضافية حيث <cbc: ID /> = QR
3. قم بإزالة كتلة <invoice> <cac: Signature />
4. الكنسي Alize الفاتورة باستخدام معيار C14N11
5. قم بتجزئة السلسلة الناتجة باستخدام SHA256 إلى كائن ثنائي
6. يقوم Base64 بتشفير الكائن الثنائي لإنشاء قيمة ملخص للفاتورة الأولى ، وتجزئة الفاتورة السابقة هي المكافئ لـ base64 المشفر SHA256 للحرف '' 0 '(صفر)).", MessageEN = @"'If the invoice contains the previous invoice hash (KSA-13), this hash must be base64 encoded SHA256." });
            errors.Add("BR-KSA-27", new ZatcaErrorMessage { ID = 93, Code = "BR-KSA-27", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يحتوي المستند على رمز QR QR (KSA-14) ، ويجب أن يكون هذا الرمز base64Binary. يرجى الرجوع إلى معايير تنفيذ ميزات الأمان لمزيد من التفاصيل.", MessageEN = @"The document must contain aa QR code (KSA-14), and this code must be base64Binary. Please refer to the Security Features Implementation Standards for more details." });
            errors.Add("BR-KSA-28", new ZatcaErrorMessage { ID = 94, Code = "BR-KSA-28", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كان طابع التشفير (KSA- 15) موجودًا في الفاتورة ، فيجب أن يحتوي ختم التشفير هذا (KSA-15) على القيمة 'urn: oasis: names: specification: ubl: signature: 1' لمعرف معلومات التوقيع.", MessageEN = @"If the cryptographic stamp (KSA- 15) exists in the invoice, this cryptographic stamp (KSA-15) must contain the exact “urn:oasis:names:specification:ubl:signature:1” value for signature information ID." });
            errors.Add("BR-KSA-29", new ZatcaErrorMessage { ID = 95, Code = "BR-KSA-29", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كان طابع التشفير (KSA- 15) موجودًا في الفاتورة ، فيجب أن يحتوي ختم التشفير هذا (KSA-15) على
  قيمة لمعرف التوقيع المشار إليه ومعرف التوقيع. ", MessageEN = @"'If the cryptographic stamp (KSA- 15) exists in the invoice, this cryptographic stamp (KSA-15) must contain the exact" });
            errors.Add("BR-KSA-30", new ZatcaErrorMessage { ID = 96, Code = "BR-KSA-30", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يحتوي ختم تشفير المستند (KSA-15) على القيمة الدقيقة لطريقة التوقيع.", MessageEN = @"The document cryptographic stamp (KSA-15) must contain the exact  value for signature method." });
            errors.Add("BR-KSA-DEC- 03", new ZatcaErrorMessage { ID = 128, Code = "BR-KSA-DEC- 03", BusinessRules = @"decimals rules (BR-KSA-DEC)", MessageAR = @"يجب أن يحتوي مبلغ ضريبة القيمة المضافة على مستوى البند (KSA-11) على رقمين عشريين كحد أقصى.", MessageEN = @"VAT amount at line level (KSA-11) must have a maximum two decimals." });
            errors.Add("BR-KSA-DEC- 04", new ZatcaErrorMessage { ID = 129, Code = "BR-KSA-DEC- 04", BusinessRules = @"decimals rules (BR-KSA-DEC)", MessageAR = @"يجب أن يحتوي المبلغ مع ضريبة القيمة المضافة على مستوى السطر (KSA-12) على رقمين عشريين كحد أقصى.", MessageEN = @"Amount with VAT at line level (KSA-12) must have a maximum two decimals." });
            errors.Add("BR-KSA-CL- 01", new ZatcaErrorMessage { ID = 130, Code = "BR-KSA-CL- 01", BusinessRules = @"code list (BR-KSA-CL)", MessageAR = @"يجب أن يكون رمز العملة (BT-5) وفقًا لمعيار ISO 4217: 2005", MessageEN = @"Currency code (BT-5) must be according to ISO 4217:2005" });
            errors.Add("BR-KSA-CL- 02", new ZatcaErrorMessage { ID = 131, Code = "BR-KSA-CL- 02", BusinessRules = @"code list (BR-KSA-CL)", MessageAR = @"يجب أن تحتوي جميع سمات معرّف العملة (BT-5) على نفس قيمة رمز عملة الفاتورة (BT-5) ، باستثناء مبلغ الفاتورة الإجمالي لضريبة القيمة المضافة بعملة المحاسبة (BT- 111).", MessageEN = @"All currencyID attributes (BT-5) must have the same value as the invoice currency code (BT-5), except for the invoice total VAT amount in accounting currency (BT- 111)." });
            errors.Add("BR-KSA-31", new ZatcaErrorMessage { ID = 97, Code = "BR-KSA-31", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"بالنسبة إلى الفواتير الضريبية المبسطة والإشعارات الدائنة وسندات الخصم المرتبطة بها (KSA-2 ، الموضع 1 و 2 = 02) ، يتم قبول ما يلي فقط:
? طرف ثالث (KSA-2 ، الموضع 3 = 1) ،
? التوريد الاسمي (المملكة العربية السعودية -2 ، الموضع 4 = 1) وملخص المعاملات (المملكة العربية السعودية -2 ، الموضع 6 = 1) ", MessageEN = @"'For simplified tax invoices and associated credit notes and debit notes  (KSA-2, position 1 and 2 = 02),  only the following are accepted:" });
            errors.Add("BR-KSA-33", new ZatcaErrorMessage { ID = 98, Code = "BR-KSA-33", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن تحتوي كل فاتورة على قيمة عداد فاتورة (KSA-16).", MessageEN = @"Each invoice must have an invoice counter value (KSA-16)." });
            errors.Add("BR-KSA-34", new ZatcaErrorMessage { ID = 99, Code = "BR-KSA-34", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"تحتوي قيمة عداد الفاتورة (KSA-16) على أرقام فقط.", MessageEN = @"The invoice counter value (KSA-16) contains only digits." });
            errors.Add("BR-KSA-35", new ZatcaErrorMessage { ID = 100, Code = "BR-KSA-35", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كانت الفاتورة تحتوي على تاريخ انتهاء التوريد (KSA-24) ، فيجب أن تحتوي الفاتورة على تاريخ التوريد (KSA-5).", MessageEN = @"If the invoice contains a supply end date (KSA-24), then the invoice must contain a supply date (KSA-5)." });
            errors.Add("BR-KSA-36", new ZatcaErrorMessage { ID = 101, Code = "BR-KSA-36", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كانت الفاتورة تحتوي على تاريخ انتهاء التوريد (KSA-24) ، فيجب أن يكون هذا التاريخ أكبر من تاريخ التوريد (KSA-5) أو مساويًا له.", MessageEN = @"If the invoice contains a supply end date (KSA-24), then this date must be greater than or equal to the supply date (KSA-5)." });
            errors.Add("BR-KSA-37", new ZatcaErrorMessage { ID = 102, Code = "BR-KSA-37", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يتكون رقم مبنى عنوان البائع من 4 أرقام.", MessageEN = @"The seller address building number must contain 4 digits." });
            errors.Add("BR-KSA-39", new ZatcaErrorMessage { ID = 103, Code = "BR-KSA-39", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن تحتوي الفاتورة على رقم تسجيل ضريبة القيمة المضافة للبائع أو رقم ضريبة القيمة المضافة لمجموعة البائعين (BT-31).", MessageEN = @"The invoice must contain the seller VAT registration number or seller group VAT number (BT-31)." });
            errors.Add("BR-KSA-40", new ZatcaErrorMessage { ID = 104, Code = "BR-KSA-40", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كانت موجودة في الفاتورة ، فيجب أن يحتوي رقم تسجيل ضريبة القيمة المضافة للبائع أو رقم تسجيل ضريبة القيمة المضافة لمجموعة البائع (BT-31) على 15 رقمًا. الرقمان الأول والأخير هما '3'.", MessageEN = @"If it exists in the invoice, the seller VAT registration number or the seller group VAT registration number  (BT-31) must contain 15 digits. The first and the last digits are “3”." });
            errors.Add("BR-KSA-42", new ZatcaErrorMessage { ID = 105, Code = "BR-KSA-42", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون اسم المشتري (BT-44) موجودًا في الفاتورة الضريبية والإشعارات الدائنة وسندات الخصم المرتبطة بها (KSA-2 ، الموضع 1 و 2 = 01).", MessageEN = @"The buyer name (BT-44) must be present in the tax invoice and associated credit notes and debit notes (KSA-2, position 1 and 2 = 01)." });
            errors.Add("BR-KSA-49", new ZatcaErrorMessage { ID = 108, Code = "BR-KSA-49", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كان كود سبب الإعفاء الضريبي (BT-121) يساوي VATEX-SA- EDU أو VATEX-SA-HEA ، فإن معرف المشتري الآخر (BT-46) إلزامي ويجب أن يكون الرقم القومي (BT-46-1 = نات)", MessageEN = @"If the tax exemption reason code (BT-121) is equal to VATEX-SA- EDU or VATEX-SA-HEA, then the other buyer ID (BT-46) is mandatory and must be national ID (BT-46-1 = NAT)" });
            errors.Add("BR-KSA-50", new ZatcaErrorMessage { ID = 109, Code = "BR-KSA-50", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون مبلغ سطر ضريبة القيمة المضافة (KSA-11) هو صافي مبلغ سطر الفاتورة (BT-131) × (معدل ضريبة القيمة المضافة (BT- 152) / 100).", MessageEN = @"The line VAT amount (KSA-11) must be Invoice line net amount (BT-131) x (Line VAT rate (BT- 152)/100)." });
            errors.Add("BR-KSA-51", new ZatcaErrorMessage { ID = 110, Code = "BR-KSA-51", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون مبلغ السطر مع ضريبة القيمة المضافة (KSA- 12) هو صافي مبلغ سطر الفاتورة (BT-131) + مبلغ سطر ضريبة القيمة المضافة (KSA-11).", MessageEN = @"The line amount with VAT (KSA- 12) must be Invoice line net amount (BT-131) + Line VAT amount (KSA-11)." });
            errors.Add("BR-KSA-52", new ZatcaErrorMessage { ID = 111, Code = "BR-KSA-52", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يعتبر مبلغ سطر ضريبة القيمة المضافة (KSA-11) إلزاميًا للفاتورة الضريبية والإشعارات الدائنة وسندات الخصم المرتبطة بها (KSA-2 ، الموضع 1 و 2 = 01).", MessageEN = @"The line VAT amount (KSA-11) is mandatory for tax invoice and associated credit notes and debit notes (KSA-2, position 1 and 2 =01)." });
            errors.Add("BR-KSA-44", new ZatcaErrorMessage { ID = 106, Code = "BR-KSA-44", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كانت موجودة في الفاتورة ، وإذا لم تكن فاتورة تصدير (KSA-2 ، الموضع 5 خاطئ) ، يجب أن يحتوي رقم تسجيل ضريبة القيمة المضافة للمشتري أو رقم تسجيل ضريبة القيمة المضافة لمجموعة المشتري (BT-48) على 15 رقمًا أول رقم و الرقم الأخير هو 3.", MessageEN = @"If it exists in the invoice, and If it is not an export invoice (KSA-2, position 5 is false), the buyer VAT registration number or buyer group VAT registration number (BT-48) must contain 15 digits The first digit and the last digit is 3." });
            errors.Add("BR-KSA-46", new ZatcaErrorMessage { ID = 107, Code = "BR-KSA-46", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كانت فاتورة تصدير (المملكة العربية السعودية -2 ، الموضع 5 صحيح) ، يجب ألا يكون رقم تسجيل ضريبة القيمة المضافة للمشتري أو رقم تسجيل ضريبة القيمة المضافة لمجموعة المشترين (BT-48) موجودًا في الفاتورة.", MessageEN = @"If it is an export invoice (KSA-2, position 5 is true), the buyer VAT registration number or buyer group VAT registration number (BT-48) must not exist in the invoice." });
            errors.Add("BR-KSA-53", new ZatcaErrorMessage { ID = 112, Code = "BR-KSA-53", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يعتبر مبلغ السطر مع ضريبة القيمة المضافة (KSA- 12) إلزاميًا للفاتورة الضريبية والإشعارات الدائنة وسندات الخصم المرتبطة بها (KSA-2 ، الموضع 1 و 2 = 01).", MessageEN = @"The line amount with VAT (KSA- 12) is mandatory for tax invoice and associated credit notes and debit notes (KSA-2, position 1 and 2 = 01)." });
            errors.Add("BR-KSA-56", new ZatcaErrorMessage { ID = 113, Code = "BR-KSA-56", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"بالنسبة للإشعارات الدائنة ((BT-3) لها قيمة 381) وسندات الخصم ((BT-3) لها قيمة 383) ، فإن معرّف مرجع الفوترة (BT-25) إلزامي.", MessageEN = @"For credit notes ((BT-3) has the value of 381) and debit notes ((BT-3) has the value of 383), the billing reference ID (BT-25) is mandatory." });
            errors.Add("BR-KSA-60", new ZatcaErrorMessage { ID = 114, Code = "BR-KSA-60", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون ختم التشفير (KSA-15) موجودًا في فواتير ضريبية مبسطة وما يرتبط بها من ملاحظات دائنة وأوراق خصم (KSA-2 ، الموضع 1 و 2 = 02)", MessageEN = @"Cryptographic stamp (KSA-15) must exist in simplified tax invoices and associated credit notes and debit notes (KSA-2, position 1 and 2 = 02)" });
            errors.Add("BR-KSA-61", new ZatcaErrorMessage { ID = 115, Code = "BR-KSA-61", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن تكون تجزئة الفاتورة السابقة (KSA-13) موجودة في الفاتورة.", MessageEN = @"Previous invoice hash (KSA-13) must exist in an invoice." });
            errors.Add("BR-KSA-63", new ZatcaErrorMessage { ID = 116, Code = "BR-KSA-63", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كان رمز بلد المشتري (BT-55) هو 'SA' ، فإن هذه الحقول إلزامية: اسم الشارع (BT-35) ، ورقم المبنى (KSA-17) ، والرمز البريدي (BT- 38) ، والمدينة (BT-37) ) ، المنطقة (KSA-3) ، رمز البلد (BT-40).", MessageEN = @"If the buyer country code (BT-55) is “SA”, then these fields are mandatory: street name (BT-35), building number (KSA-17), postal code (BT- 38),  city (BT-37), District (KSA-3), country code (BT-40)." });
            errors.Add("BR-KSA-64", new ZatcaErrorMessage { ID = 117, Code = "BR-KSA-64", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"عنوان البائع يجب أن يتكون الرقم الإضافي (KSA-23) من 4 أرقام.", MessageEN = @"Seller Address Additional number (KSA-23) must be 4 digits." });
            errors.Add("BR-KSA-65", new ZatcaErrorMessage { ID = 118, Code = "BR-KSA-65", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"عنوان المشتري يجب أن يتكون الرقم الإضافي (KSA-19) من 4 أرقام إذا كان موجودًا.", MessageEN = @"Buyer Address Additional number (KSA-19) must be 4 digits if it exists." });
            errors.Add("BR-KSA-66", new ZatcaErrorMessage { ID = 119, Code = "BR-KSA-66", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يتكون الرمز البريدي للبائع (BT-38) من 5 أرقام.", MessageEN = @"Seller postal code (BT-38) must be 5 digits." });
            errors.Add("BR-KSA-67", new ZatcaErrorMessage { ID = 120, Code = "BR-KSA-67", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كان رمز بلد المشتري (BT-55) هو 'SA' ، فيجب أن يتكون الرمز البريدي للمشتري (BT-53) من 5 أرقام.", MessageEN = @"If the buyer country code (BT-55) is “SA”, then the Buyer postal code (BT-53) must be 5 digits." });
            errors.Add("BR-KSA-68", new ZatcaErrorMessage { ID = 121, Code = "BR-KSA-68", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون رمز العملة الضريبية (BT-6) موجودًا في الفاتورة.", MessageEN = @"Tax currency code (BT-6) must exist in an invoice." });
            errors.Add("BR-KSA-71", new ZatcaErrorMessage { ID = 124, Code = "BR-KSA-71", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كانت الفاتورة من نوع فاتورة مبسطة وهي فاتورة موجزة (KSA-2 ، الموضع 1 و 2 = 02 ، الموضع 6 = 1) ، فيجب أن يكون اسم المشتري موجودًا", MessageEN = @"If the Invoice is a simplified invoice type and is a summary invoice (KSA-2, position 1 and 2 = 02, position 6 = 1), then the buyer name must be present" });
            errors.Add("BR-KSA-DEC- 02", new ZatcaErrorMessage { ID = 127, Code = "BR-KSA-DEC- 02", BusinessRules = @"decimals rules (BR-KSA-DEC)", MessageAR = @"يجب أن تتراوح معدلات ضريبة القيمة المضافة (BT-96119 ، BT-152) من 0.00 إلى 100.00 ، بحد أقصى رقمين عشريين. يتم قبول الأرقام فقط ، ولا يُسمح برمز النسبة المئوية (?).", MessageEN = @"The VAT rates (BT-96119, BT-152) must be from 0.00 to 100.00, with maximum two decimals. Only numerals are accepted, the percentage symbol (%) is not allowed." });
            errors.Add("BR-KSA-69", new ZatcaErrorMessage { ID = 122, Code = "BR-KSA-69", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن يكون لتفصيل ضريبة القيمة المضافة (BG-23) مع رمز فئة ضريبة القيمة المضافة (BT-118) 'مصنفة صفريًا' رمز سبب استثناء ضريبة القيمة المضافة (BT-121) ونص سبب استثناء ضريبة القيمة المضافة (BT-120).", MessageEN = @"A VAT breakdown (BG-23) with VAT Category code (BT-118) 'Zero rated' shall have a VAT exception reason code (BT-121) and VAT exception reason text (BT-120)." });
            errors.Add("BR-KSA-70", new ZatcaErrorMessage { ID = 123, Code = "BR-KSA-70", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"يجب أن تحتوي الفاتورة على أوقات إصدار الفاتورة (KSA-25) ستكون هذه القيمة بالتنسيق: hh: mm: ss للوقت المعبر عنه في AST أو hh: mm: ssZ للوقت المعبر عنه بالتوقيت العالمي المنسق. (على سبيل المثال ، 19:20:30)", MessageEN = @"The invoice must contain an Invoice issue times (KSA-25) This value will be in the format: hh:mm:ss for time expressed in AST or hh:mm:ssZ for time expressed in UTC. (eg 19:20:30)" });
            errors.Add("BR-KSA-72", new ZatcaErrorMessage { ID = 125, Code = "BR-KSA-72", BusinessRules = @"business rules (BR-KSA)", MessageAR = @"إذا كانت الفاتورة من نوع فاتورة مبسطة وكانت عبارة عن فاتورة موجزة (المملكة العربية السعودية -2 ، الموضع 1 و 2 = 02 ، الموضع 6 = 1) ، فيجب أن يكون تاريخ التوريد (المملكة العربية السعودية -5) وتاريخ انتهاء التوريد (المملكة العربية السعودية -24) كن حاضرا", MessageEN = @"If the Invoice is a simplified invoice type and is a summary invoice (KSA-2, position 1 and 2 = 02, position 6 = 1), then a supply date (KSA-5) and supply end date (KSA-24) must be present" });
            errors.Add("BR-KSA-DEC- 01", new ZatcaErrorMessage { ID = 126, Code = "BR-KSA-DEC- 01", BusinessRules = @"decimals rules (BR-KSA-DEC)", MessageAR = @"يجب أن تتراوح قيم النسبة المئوية المسموح بها (BT-94 ، BT-138) من 0.00 إلى 100.00 ، بحد أقصى منزلتين عشريتين. يتم قبول الأرقام فقط ، ولا يُسمح برمز النسبة المئوية (?).", MessageEN = @"The allowance percentage values (BT-94, BT-138) must be from 0.00 to 100.00, with maximum two decimal places. Only numerals are accepted, the percentage symbol (%) is not allowed." });
            errors.Add("BR-KSA-CL- 03", new ZatcaErrorMessage { ID = 132, Code = "BR-KSA-CL- 03", BusinessRules = @"code list (BR-KSA-CL)", MessageAR = @"يجب أن يكون رمز Mime وفقًا لمجموعة فرعية من قائمة رموز IANA.", MessageEN = @"Mime code must be according to subset of IANA code list." });
            errors.Add("BR-KSA-CL- 04", new ZatcaErrorMessage { ID = 133, Code = "BR-KSA-CL- 04", BusinessRules = @"code list (BR-KSA-CL)", MessageAR = @"يجب أن يكون كود سبب الإعفاء من ضريبة القيمة المضافة (BT-121) موجودًا في الفاتورة ، ويجب أن يكون للرموز Z و E ضريبة الإعفاء (أو الاستثناءات) كود السبب والنص الخاص بالمملكة العربية السعودية", MessageEN = @"VAT exemption reason code (BT-121) must exist in the invoice, the codes Z, E must have Tax exemption (or exceptions) reason code and text - specific to Saudi Arabia" });
            errors.Add("BR-KSA-CL- 05", new ZatcaErrorMessage { ID = 134, Code = "BR-KSA-CL- 05", BusinessRules = @"code list (BR-KSA-CL)", MessageAR = @"إذا كان كود سبب الإعفاء من ضريبة القيمة المضافة (BT-121) هو الرموز 'Z' أو 'E' ، فيجب أن يكون نص سبب الإعفاء من ضريبة القيمة المضافة (BT-120) موجودًا مع إحدى القيم من رمز سبب الإعفاء الضريبي (أو استثناء) والنص - خاصة بالمملكة العربية السعودية", MessageEN = @"If VAT exemption reason code (BT-121) is the codes  “Z” or “E”, then VAT exemption reason text (BT-120) must exist with one of the values from Tax exemption (or exception) reason code and text - specific to Saudi Arabia" });
            errors.Add("BR-KSA- EN16931-01", new ZatcaErrorMessage { ID = 135, Code = "BR-KSA- EN16931-01", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"يجب أن تكون عملية الأعمال (BT-23) 'إعداد التقارير: 1.0'.", MessageEN = @"Business process (BT-23) must be “reporting:1.0”." });
            errors.Add("BR-KSA- EN16931-02", new ZatcaErrorMessage { ID = 136, Code = "BR-KSA- EN16931-02", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"يجب أن يكون رمز عملة محاسبة ضريبة القيمة المضافة (BT-6) 'SAR'", MessageEN = @"VAT accounting currency code (BT-6) must be “SAR”" });
            errors.Add("BR-KSA- EN16931-03", new ZatcaErrorMessage { ID = 137, Code = "BR-KSA- EN16931-03", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"يجب أن يكون مبلغ المخصص (BT- 92 ، BT-136) مساويًا للمبلغ الأساسي (BT-93 ، BT- 137) * النسبة المئوية (BT-94 ، BT-138) / 100 في حالة وجود المبلغ الأساسي والنسبة المئوية.", MessageEN = @"Allowance amount (BT- 92, BT-136) must equal base amount (BT-93, BT- 137) * percentage (BT-94, BT-138) / 100 if base amount and percentage exists." });
            errors.Add("BR-KSA- EN16931-04", new ZatcaErrorMessage { ID = 138, Code = "BR-KSA- EN16931-04", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"يجب توفير المبلغ الأساسي المخصص (BT-93 ، BT-137) عند البدل", MessageEN = @"Allowance base amount (BT-93, BT-137) must be provided when allowance" });
            errors.Add("BR-KSA- EN16931-05", new ZatcaErrorMessage { ID = 139, Code = "BR-KSA- EN16931-05", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"يجب توفير نسبة العلاوة (BT-94 ، BT-138) عند توفير المبلغ الأساسي المخصص (BT-93 ، BT-137).", MessageEN = @"Allowance percentage (BT-94, BT-138) must be provided when the allowance base amount (BT-93, BT-137) is provided." });
            errors.Add("BR-KSA- EN16931-06", new ZatcaErrorMessage { ID = 140, Code = "BR-KSA- EN16931-06", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"لا يُسمح بفرض رسوم على مستوى السعر (BG- 29). يسمح فقط بقيمة 'خطأ'.", MessageEN = @"Charge on price level (BG- 29) is NOT allowed. Only value 'false' allowed." });
            errors.Add("BR-KSA- EN16931-07", new ZatcaErrorMessage { ID = 141, Code = "BR-KSA- EN16931-07", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"يجب أن يكون صافي سعر العنصر (BT-146) مساويًا (السعر الإجمالي (BT-148) - مبلغ المخصص (BT-147)) عند تقديم السعر الإجمالي.", MessageEN = @"Item net price (BT-146) must equal (Gross price (BT-148) - Allowance amount (BT-147)) when gross price is provided." });
            errors.Add("BR-KSA- EN16931-08", new ZatcaErrorMessage { ID = 142, Code = "BR-KSA- EN16931-08", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"يجب تقديم إجمالي ضريبة واحد فقط (BG-22) مع الإجماليات الضريبية الفرعية.", MessageEN = @"Only one tax total (BG-22) with tax subtotals must be provided." });
            errors.Add("BR-KSA- EN16931-09", new ZatcaErrorMessage { ID = 143, Code = "BR-KSA- EN16931-09", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"يجب تقديم إجمالي ضريبة واحد فقط (BG-22) بدون المجاميع الفرعية للضرائب عند تقديم رمز عملة الضريبة.", MessageEN = @"Only one tax total (BG-22) without tax subtotals must be provided when tax currency code is provided." });
            errors.Add("BR-KSA- EN16931-11", new ZatcaErrorMessage { ID = 144, Code = "BR-KSA- EN16931-11", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"يجب أن يكون صافي مبلغ سطر الفاتورة (BT-131) مساويًا (الكمية المفوترة (BT-129) * (صافي سعر الصنف (BT-146) / الكمية الأساسية لسعر العنصر (BT-149)) -)) - مجموع مبلغ مخصص بند الفاتورة (BT- 136)", MessageEN = @"Invoice line net amount (BT-131) must equal (Invoiced quantity (BT-129) * (Item net price (BT-146) / item price base quantity (BT-149))-))- Sum of invoice line allowance amount (BT- 136)" });
            errors.Add("BR-KSA- EN16931-12", new ZatcaErrorMessage { ID = 145, Code = "BR-KSA- EN16931-12", BusinessRules = @"KSA – EN16931 (BR-KSA-EN16931)", MessageAR = @"يجب أن تكون الكمية الأساسية (BT-149) رقمًا موجبًا أعلى من الصفر.", MessageEN = @"Base quantity (BT-149) must be a positive number above zero." });
            errors.Add("BR-KSA-F-01", new ZatcaErrorMessage { ID = 146, Code = "BR-KSA-F-01", BusinessRules = @"KSA – formats (BR-KSA-F)", MessageAR = @"يجب تنسيق التاريخ YYYY-MM-DD.", MessageEN = @"A date MUST be formatted YYYY-MM-DD." });
            errors.Add("BR-KSA-F-02", new ZatcaErrorMessage { ID = 147, Code = "BR-KSA-F-02", BusinessRules = @"KSA – formats (BR-KSA-F)", MessageAR = @"يجب أن تساوي قيمة مؤشر المخصصات 'خطأ'", MessageEN = @"Allowance Indicator value MUST equal to 'false'" });
            errors.Add("BR-KSA-F-03", new ZatcaErrorMessage { ID = 148, Code = "BR-KSA-F-03", BusinessRules = @"KSA – formats (BR-KSA-F)", MessageAR = @"يجب ألا يحتوي المستند على عناصر فارغة.", MessageEN = @"Document MUST not contain empty elements." });
            errors.Add("BR-KSA-F-04", new ZatcaErrorMessage { ID = 149, Code = "BR-KSA-F-04", BusinessRules = @"KSA – formats (BR-KSA-F)", MessageAR = @"يجب أن تكون جميع كميات المستندات وكمياتها موجبة.", MessageEN = @"All the document amounts and quantities must be positive." });

            return errors;
        }

    }
}
